# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997 - 2009 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: system environment, resource control and configuration details

=end
module SiSU_images
  class Images
    def initialize(md,data)
      @md,@data=md,data
    end
    def images
      data=@data
      tuned_file=[]
      @rmgk=false
      if SiSU_Env::Info_settings.new.program?('rmagick'); @rmgk=SiSU_Env::Load.new('RMagick').prog
      else tell=SiSU_Screen::Ansi.new(@md.cmd,'use of RMagick is not enabled in sisurc.yml')
        tell.warn if @md.cmd =~/[vVM]/
      end
      data.each do |para|
        para.strip!
        if para =~/#{Mx[:lnk_o]}\s*\S+\.(?:png|jpg|gif)(?:\s*|\s+.+)?#{Mx[:lnk_c]}(?:(?:https?|file|ftp):\S+|image)/
          if para !~/#{Mx[:lnk_o]}\s*\S+\.(?:png|jpg|gif)\s+\d+x\d+\s+/
            m=/#{Mx[:lnk_o]}\s*(\S+\.(?:png|jpg|gif))/
            if @rmgk
              imgs=para.scan(m).flatten
              images=imgs.each do |image|
                dir=SiSU_Env::Info_env.new(@md.fns)
                path_image=[dir.path.image_source_local_tex,dir.path.image_source_remote_tex,dir.path.image_source_tex]
                image_path=nil
                path_image.each do |image_path|
                  break if FileTest.exist?("#{image_path}/#{image}")
                end
                if FileTest.exist?("#{image_path}/#{image}")
                  img=Magick::ImageList.new("#{image_path}/#{image}")
                  img_col,img_row=img.columns,img.rows
                  if img_col > img_row                                               #landscape
                    if img_col> 640 #480
                      img_col=640 #480
                      img_row=((1.00*img_col/img.columns)*img.rows).round
                    end
                  else                                                               #portrait
                    if img_col> 640 #480
                      img_col=640 #480
                      img_row=((1.00*img_col/img.columns)*img.rows).round
                    end
                    if img_row > 640
                      img_row=640
                      img_col=((1.00*img_row/img.rows)*img.columns).round
                    end
                  end
                  para.gsub!(/(#{image})/,"#{image} #{img_col}x#{img_row}")
                else para.gsub!(/#{Mx[:lnk_o]}\s*(\S+)\.(png|jpg|gif).+?#{Mx[:lnk_c]}((?:https?|file|ftp):\S+|image)/,'[ \1 (\2 missing) ]')
                end
              end
            else
              images=para.scan(m) do |image|
                tell=SiSU_Screen::Ansi.new(@md.cmd,'where image dimensions have not been provided RMagick is required',image)
                tell.warn #unless @opt.cmd =~/q/
              end
            end
          end
        end
        para.gsub!(/(#{Mx[:lnk_o]})\s*(\S+\.(?:png|jpg|gif))\s+/i,'\1\2 ') if para =~/#{Mx[:lnk_o]}\s*\S+\.(?:png|jpg|gif).+?#{Mx[:lnk_c]}(?:(?:https?|file|ftp):\S+|image)/
        tuned_file << para unless para.nil?
      end
      tuned_file
    end
  end
end
__END__
