# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: xml template
   ** Notes: tidy -xml index.xml >> index.tidy

=end
module SiSU_XML_format
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  class Paragraph_number
    def initialize(md,paranum)
      @md=md
      @paranum=/(\d+)/m.match(paranum)[1]
    end
    def display
      p_num_display=@paranum.gsub(/(\d+)/,
        '<font size="1" color="#777777">' +
        '&nbsp;&nbsp;\1</font>')
      p_num_display
    end
    def name
      p_num_name=@paranum.gsub(/(\d+)/,'<a name="\1"></a>')
      p_num_name
    end
    def goto
      p_num_goto=@paranum.gsub(/(\d+)/,'<a href="#\1">')
      p_num_goto
    end
  end
  class Head_information
    def initialize #dc rdf
      @full_title=@subtitle=@author=@subject=@description=@publisher=@contributor=@date=@type=@format=@identifier=@source=@language=@relation=@coverage=@rights=@copyright=@owner=@keywords=''
      @sfx,@pdf,@md=@@md.sfx,@@md.pdf,@@md
      # DublinCore 1 - title
      @rdfurl=%{  rdf:about="http://www.jus.uio.no/lm/toc"\n}
      if @md.full_title
        @full_title=%{<meta name="dc.title" content="#{seg_name}#{@md.full_title}" />\n}
        #if @md.subtitle
        #  #@rdf_title=%{    dc.title="#{seg_name}#{@md.title} - #{@md.subtitle}"\n}
        #  @full_title=%{<meta name="dc.title" content="#{seg_name}#{@md.title} - #{@md.subtitle}" />\n}
        #else
        #  #@rdf_title=%{    dc.title="#{seg_name}#{@md.title}"\n}
        #  @full_title=%{<meta name="dc.title" content="#{seg_name}#{@md.title}" />\n}
        #end
      end
      if @md.author                                                          # DublinCore 2 - author/creator (author)
        @rdf_author=%{    dc.author="#{@md.author}"\n}
        @author=%{<meta name="dc.author" content="#{@md.author}" />\n}
      end
      if @md.subject                                                          # DublinCore 3 - subject (us library of congress, eric or udc, or schema???)
        @rdf_subject=%{    dc.subject="#{@md.subject}"\n}
        @subject=%{<meta name="dc.subject" content="#{@md.subject}" />\n}
      end
      if @md.description                                                      # DublinCore 4 - description
        @rdf_description=%{    dc.description="#{@md.description}"\n}
        @description=%{<meta name="dc.description" content="#{@md.description}" />\n}
      end
      if @md.publisher                                                        # DublinCore 5 - publisher (current copy published by)
        @rdf_publisher=%{    dc.publisher="#{@md.publisher}"\n}
        @publisher=%{<meta name="dc.publisher" content="#{@md.publisher}" />\n}
      end
      if @md.contributor                                                      # DublinCore 6 - contributor
        @rdf_contributor=%{    dc.contributor="#{@md.contributor}"\n}
        @contributor=%{<meta name="dc.contributor" content="#{@md.contributor}" />\n}
      end
      if @md.date                                                             # DublinCore 7 - date year-mm-dd
        @rdf_date=%{    dc.date="#{@md.date}"\n}
        @date=%{<meta name="dc.date" content="#{@md.date}" #{@md.date_scheme} />\n}
      end
      if @md.date_created                                                     # DublinCore 7 - date.created year-mm-dd
        @rdf_date_created=%{    dc.date.created="#{@md.date_created}"\n}
        @date_created=%{<meta name="dc.date.created" content="#{@md.date_created}" #{@md.date_created_scheme} />\n}
      end
      if @md.date_issued                                                      # DublinCore 7 - date.issued year-mm-dd
        @rdf_date_issued=%{    dc.date.issued="#{@md.date_issued}"\n}
        @date_issued=%{<meta name="dc.date.issued" content="#{@md.date_issued}" #{@md.date_issued_scheme} />\n}
      end
      if @md.date_available                                                   # DublinCore 7 - date.available year-mm-dd
        @rdf_date_available=%{    dc.date.available="#{@md.date_available}"\n}
        @date_available=%{<meta name="dc.date.available" content="#{@md.date_available}" #{@md.date_available_scheme} />\n}
      end
      if @md.date_valid                                                       # DublinCore 7 - date.valid year-mm-dd
        @rdf_date_valid=%{    dc.date.valid="#{@md.date_valid}"\n}
        @date_valid=%{<meta name="dc.date.valid" content="#{@md.date_valid}" #{@md.date_valid_scheme} />\n}
      end
      if @md.date_modified                                                    # DublinCore 7 - date.modified year-mm-dd
        @rdf_date_modified=%{    dc.date.modified="#{@md.date_modified}"\n}
        @date_modified=%{<meta name="dc.date.modified" content="#{@md.date_modified}" #{@md.date_modified_scheme} />\n}
      end
      if @md.type                                                             # DublinCore 8 - type (genre eg. report, convention etc)
        @rdf_type=%{    dc.type="#{@md.type}"\n}
        @type=%{<meta name="dc.type" content="#{@md.type}" />\n}
      end
      if @md.format                                                           # DublinCore 9 - format (use your mime type)
        @rdf_format=%{    dc.format="#{@md.format}"\n}
        @format=%{<meta name="dc.format" content="#{@md.format}" />\n}
      end
      if @md.identifier                                                       # DublinCore 10 - identifier (your identifier, could use urn which is free)
        @rdf_identifier=%{    dc.identifier="#{@md.identifier}"\n}
        @identifier=%{<meta name="dc.identifier" content="#{@md.identifier}" />\n}
      end
      if @md.source                                                           # DublinCore 11 - source (document source)
        @rdf_source=%{    dc.source="#{@md.source}"\n}
        @source=%{<meta name="dc.source" content="#{@md.source}" />\n}
      end
      if @md.language[:name]                                                  # DublinCore 12 - language (English)
        @rdf_language=%{    dc.language="#{@md.language[:name]}"\n}
        @language=%{<meta name="dc.language" content="#{@md.language[:name]}" />\n}
      end
      if @md.language_original[:name]                                                  # DublinCore 12 - language (English)
        @rdf_language_original=%{    dc.language="#{@md.language_original[:name]}"\n}
        @language_original=%{<meta name="dc.language" content="#{@md.language_original[:name]}" />\n}
      end
      if @md.relation                                                         # DublinCore 13 - relation
        @rdf_relation=%{    dc.relation="#{@md.relation}"\n}
        @relation=%{<meta name="dc.relation" content="#{@md.relation}" />\n}
      end
      if @md.coverage                                                         # DublinCore 14 - coverage
        @rdf_coverage=%{    dc.coverage="#{@md.coverage}"\n}
        @coverage=%{<meta name="dc.coverage" content="#{@md.coverage}" />\n}
      end
      if @md.rights                                                           # DublinCore 15 - rights
        @rdf_rights=%{    dc.rights="#{@md.rights}"\n}
        @rights=%{<meta name="dc.rights" content="#{@md.rights}" />\n}
      end
      @copyright=%{<meta name="copyright" content="#{@md.rights}" />\n} if @md.rights # possibly redundant see dc.rights
      @owner=%{<meta name="owner" content="#{@md.owner}" />\n} if @md.owner
      @keywords=%{<meta name="keywords" content="#{@md.keywords}" />\n} if @md.keywords
      @vz=SiSU_Env::Get_init.instance.skin #margin,paragraph,table,banner,url,png,txt,color,font,nav_txt,nav_png,credits,js,php
      @index=case @md.file_type
      when /php/; 'index' # @index="index.php"
      else        'index'
      end
    end
    def toc_head_escript #embedded script in this case PHP
      # %{<p>PHP or other embedded script for object persistence may go HERE</p>}
    end
    #def seg_head_escript #embedded script in this case PHP
    #  # %{<p>PHP or other embedded script for object persistence may go HERE</p>}
    #end
    def table_close
      '</font> </td></tr></table>'
    end
    def buttons_home
      %{\n#{@banner.home_and_index_buttons}\n}
    end
    def copyat
      %{copy @ <a href="#{@url.home}" #{@js.home}>#{@txt.home}</a>}
    end
    def toc_head
      #<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
      #         xmlns:dc="http://purl.org/dc/elements/1.1/">
      #  <rdf:Description rdf:about="http://www.jus.uio.no/lm/doc"
      #      dc:author="Author"
      #      dc:title="Title"
      #      dc:description="Description if any"
      #      dc:date="Publication Date"
      #  />
      #</rdf:RDF>
      #Dublin Core
      <<WOK
<html>
<head>
<title>#{@md.html_title}</title>
<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
         xmlns:dc="http://purl.org/dc/elements/1.1/">
 <rdf:Description
#@rdfurl
#@rdf_title
#@rdf_subtitle
#@rdf_author
#@rdf_subject
#@rdf_description
#@rdf_publisher
#@rdf_contributor
#@rdf_date
#@rdf_date_created
#@rdf_date_issued
#@rdf_date_available
#@rdf_date_valid
#@rdf_date_modified
#@rdf_type
#@rdf_format
#@rdf_identifier
#@rdf_source
#@rdf_language
#@rdf_relation
#@rdf_coverage
#@rdf_rights
  />
</rdf:RDF>
#@full_title
#@author
#@subject
#@description
#@publisher
#@contributor
#@date
#@date_created
#@date_issued
#@date_available
#@date_valid
#@date_modified
#@type
#@format
#@identifier
#@source
#@language
#@relation
#@coverage
#@rights
#@copyright
#@owner
#{@png.ico}
#{@txt.generator}
#{@js.head}
\n</head>
#{@color.body}
#{@font.css_table_file}
<a name="top"></a>
<a name="up"></a>
<a name="start"></a>
#{@js.top}
WOK
    end
  end
  class Format_text_object
    @@dp=nil
    attr_accessor :md,:txt,:format,:paranum,:p_num,:para_id,:headname,:font
    def initialize(md,t_o)
      @md,@t_o=md,t_o
      if t_o.class == Hash
        @txt =t_o[:txt]            || nil
        @format =t_o[:format]      || nil
        @lnk_url =t_o[:lnk_url]    || nil
        @lnk_txt =t_o[:lnk_txt]    || nil
        @ocn =t_o[:ocn]            || nil
        #@h_name =t_o[:h_name]      || nil
      #elsif t_o.class == Array
      #  @txt =txt[0]
      #elsif t_o.class == String
      #  @txt =txt
      else
        p t_o.class
        p caller
      end
      if @t_o[:ocn]=~/\d+/
        @paranum=/(\d+)/m.match(@t_o[:ocn])[1]
        @headname=''
        #if txt[2]=~/\d+/
        m=/#{Mx[:lv_o]}\d:(\S+?)#{Mx[:lv_c]}/m.match(@format)
        headname=m[1] if m
        @headname=%{<a name="h#{headname}"></a>} unless headname.nil?
        @p_num=SiSU_XML_format::Paragraph_number.new(@md,@paranum)
      end
      rgx=/^[1-6-]~{1,2}/ #watch
      @lnk_url=@lnk_url.gsub(rgx,'') if @lnk_url =~rgx
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
      rgx=/~\{\d+\s+(.+?)#{Mx[:id_o]}#@dp#{Mx[:id_c]}\}~/
      @lnk_url=@lnk_url.gsub(rgx,'\1') if @lnk_url =~rgx
      @vz=SiSU_Env::Get_init.instance.skin
    end
    def scr_endnote_body
      "<endnote>#{@txt}</endnote> "
    end
  end
  class Format_scroll < Format_text_object
    def initialize(md,t_o)
      super(md,t_o)
    end
    def heading_body
      %{<p class="norm">#{@p_num.name}#{@headname}#{@txt} </p>} +
      %{<p class="paranum">#{@p_num.display} </p>\n}
    end
    def heading_body1
      %{<h1 class="norm">#{@p_num.name}#{@headname}#{@txt} </h1>} +
      %{<p class="paranum">#{@p_num.display} </p>\n}
    end
    def heading_body2
      %{<h2 class="norm">#{@p_num.name}#{@headname}#{@txt} </h2>} +
      %{<p class="paranum">#{@p_num.display} </p>\n}
    end
    def heading_body3
      %{<h3 class="norm">#{@p_num.name}#{@headname}#{@txt} </h3>} +
      %{<p class="paranum">#{@p_num.display} </p>\n}
    end
    def heading_body4
      %{<h4 class="norm">#{@p_num.name}#{@headname}#{@txt}</h4>} +
      %{<p class="paranum">#{@p_num.display} </p>\n}
    end
    def heading_body5
      %{<h5 class="norm">#{@p_num.name}#{@headname}#{@txt} </h5>} +
      %{<p class="paranum">#{@p_num.display} </p>\n}
    end
    def heading_body6
      %{<h6 class="norm">#{@p_num.name}#{@headname}#{@txt} </h6>} +
      %{<p class="paranum">#{@p_num.display} </p>\n}
    end
  end
  class XML
  end
end
__END__
