# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: html generation, processing

=end
module SiSU_HTML
  require 'pstore'
  require "#{SiSU_lib}/particulars"
  include SiSU_Particulars
  require "#{SiSU_lib}/defaults"
  include SiSU_Viz
  require "#{SiSU_lib}/html_table"
  require "#{SiSU_lib}/html_format"
  include SiSU_HTML_Format
  require "#{SiSU_lib}/html_segments"
  require "#{SiSU_lib}/html_scroll"
  include SiSU_HTML_seg
  require "#{SiSU_lib}/html_promo"
  include SiSU_HTML_promo
  require "#{SiSU_lib}/html_tune"
  include SiSU_Tune
  require "#{SiSU_lib}/shared_xml"
  require "#{SiSU_lib}/shared_structure"
  class Source
    def initialize(opt)
      @opt=opt
      @particulars=SiSU_Particulars::Combined_singleton.instance.get_all(opt)
    end
    def read
      songsheet
    end
    def songsheet
      begin
        @md=@particulars.md
        @fnb=@md.fnb
        @env=@particulars.env
        loc=@env.url.output_tell
        tool=if @opt.cmd =~/z/;   "#{@env.program.web_browser} #{loc}/#@fnb/#{@md.fn[:index]}"
        elsif @opt.cmd =~/[MVv]/; "#{@env.program.web_browser} #{loc}/#@fnb/#{@md.fn[:index]}"
        else                 ''
        end
        SiSU_Screen::Ansi.new(@opt.cmd,'HTML',tool).green_hi_blue unless @opt.cmd =~/q/
        SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@env.path.output_tell}/#@fnb/#{@md.fn[:index]}").flow if @opt.cmd =~/[MV]/
        SiSU_Env::Info_skin.new(@md).select
        data=nil
        my_make=SiSU_Env::Create_file.new(@opt.cmd,@opt.fns,@md) #Beware #FIX opt and md, both not necessary
        SiSU_Env::SiSU_file.new(@md).mkdir
        @tuned_file_array=SiSU_HTML::Source::Html_environment.new(@particulars).tuned_file_instructions
        data=@tuned_file_array
        scr_endnotes=SiSU_HTML::Source::Endnotes.new(data,@md).scroll
        toc=SiSU_HTML::Source::Toc.new(data,@md).songsheet
        links_guide=SiSU_HTML::Source::Links_guide.new(data,@md).toc
        data=@tuned_file_array
        scr_toc=SiSU_HTML::Source::Scroll_head_and_segtoc.new(@md,toc,links_guide).in_common #watch
        SiSU_HTML::Source::Seg.new(data,@md).songsheet
        data=@tuned_file_array
        scr=SiSU_HTML::Source::Scroll.new(data,@md).songsheet
        scroll=SiSU_HTML::Source::Scroll_output.new(scr_toc,scr[:body],scr_endnotes,scr[:metadata],scr[:owner_details],scr[:tails],@md).publish
        SiSU_HTML::Source::Output.new(scroll,@md).scroll
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
        unless @opt.cmd =~/[MV]/ #check maintenance flag
          texfiles=Dir["#{@env.path.tune}/#{@opt.fns}*"]
          texfiles.each do |f|
            if FileTest.file?(f)
              File.unlink(f)
            end
          end
        end
        SiSU_Env::Create_file.new(@opt.cmd,@opt.fns).param_instantiate
        @@flag,@@scr,@@seg,@@seg_endnotes,@@seg_subtoc,@@seg_ad={},{},{},{},{},{}
        @@seg_total,@@tracker,@@loop_count,@@tablehead,@@number_of_cols=0,0,0,0,0
        @@seg_name,@@seg_name_html,@@seg_subtoc_array,@@seg_endnotes_array,@@segtocband,@@tablefoot=Array.new(7){[]}
        @@filename_seg,@@seg_url,@@fn,@@to_lev4,@@get_hash_to,@@get_hash_fn='','','','','','',''
        @@is4=@@is3=@@is2=@@is1=@@header1=@@header2=@@header3=@@header4=0
      end
    end
    private
    class Html_environment
      def initialize(particulars)
        @particulars=particulars
        @md,@env=particulars.md,particulars.env
        @vz=SiSU_Env::Get_init.instance.skin
        @env,@css,@symlnk=particulars.env,SiSU_Style::CSS.new,SiSU_Env::Create_system_link.new #home
      end
      def suffix_linkname #not used at present
        sfx=if @md.cmd =~/h/; '.html'
        else                  ''
        end
      end
      def link_images
        @symlnk.images
      end
      def directories
        my_make=SiSU_Env::Create_file.new(@md.cmd,@md.fns)
        @path={ :root=>my_make.html_root }
        title=File.basename(@md.fns,'.rb')
        SiSU_Env::SiSU_file.new(@md).mkdir
      end
      def tuned_file_instructions
        @tell=SiSU_Screen::Ansi.new(@md.cmd)
        if @md
          #@md.sfx=''
          @md.sfx='' if @md.cmd =~/z/
          if @md.cmd =~/h/ \
          or @md.fns =~/\~[a-z]{2,3}\.s?/ #multilingual document protection is a bit arbitrary, (needed by existing server configuration), add configuration overide...
            if @md.cmd =~/H/ \
            and @md.fns =~/\~[a-z]{2,3}\.s?/
              SiSU_Screen::Ansi.new(@md.cmd,
                'multilingual document, creating internal url links with filetype suffix',
                "\n\t\t(overriding -H request, using -h mode instead)"
              ).warn unless @md.cmd =~/q/
            end
            @md.sfx='.html'
          end
        end
        @md.cmd=@md.cmd.gsub(/H/,'h')
        @md.file_type='html' if @md.cmd =~/[hon]/
        directories
        newfilename=%{#{@env.path.output}/#{@md.fnb}/#{@md.fn[:index]}} if @md.file_type =~/html/
        dal_array=@particulars.dal_array # dal file drawn here
        @tuned_file_array=SiSU_Tune::Tune.new(dal_array,@md).songsheet
        @tuned_file_array
      end
    end
    class Split_text_object <SiSU_Structure::Split_text_object
    end
    class Links_guide
      @links_guide_toc=[]
      def initialize(data,md)
        @data,@md=data,md
      end
      def toc
        @links_guide_toc=[]
        format_head_toc=SiSU_HTML_Format::Head_toc.new(@md)
        guide_type='horzontal' #values: horizontal or vertical
        @links_guide_toc << format_head_toc.links_guide_open(guide_type)
        if defined? @md.lnk \
        and @md.lnk
          @md.lnk.each do |l|
            if defined? l[:say]
              target=if l[:url] !~/^\.(\.)?\//; 'external'
              else                              '_top'
              end
              s_lnk_url,s_lnk_lnk=l[:url],l[:say]
              txt_obj={:lnk_url =>s_lnk_url,:lnk_txt =>s_lnk_lnk,:target =>target}
              lev_para_ocn=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
              @links_guide_toc << lev_para_ocn.links_guide if s_lnk_lnk
            end
          end
        end
        format_head_toc=SiSU_HTML_Format::Head_toc.new(@md)
        @links_guide_toc << format_head_toc.links_guide_close #(guide_type)
        @links_guide_toc
      end
    end
    class Endnotes
      include SiSU_HTML_Format
      def initialize(data,md)
        @data,@md=data,md
      end
      def scroll
        @scr_endnotes=[]
        format_head_scroll=SiSU_HTML_Format::Head_scroll.new(@md)
        @scr_endnotes << format_head_scroll.title_endnote
        @data.each do |para|
          pg=para.dup
          unless pg =~/^#{Mx[:gr_o]}code#{Mx[:gr_c]}/
            if pg =~/(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})[\d*+]+ <a name="_[\d*+]+"/ \
            and not pg =~/^#{Mx[:gr_o]}code#{Mx[:gr_c]}/
              endnote_array=[] #(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]})
              if pg=~/#{Mx[:en_a_o]}[\d*+].+?#{Mx[:en_a_c]}/m
                endnote_array << pg.scan(/#{Mx[:en_a_o]}[\d*+]+(.+?)#{Mx[:en_a_c]}/m)
              end
              if pg=~/#{Mx[:en_b_o]}[\d*]+\s.+?#{Mx[:en_b_c]}/m
                endnote_array << pg.scan(/#{Mx[:en_b_o]}[\d*]+(.+?)#{Mx[:en_b_c]}/m)
              end
              if pg=~/#{Mx[:en_b_o]}[\d+]+\s.+?#{Mx[:en_b_c]}/m
                endnote_array << pg.scan(/#{Mx[:en_b_o]}[\d+]+(.+?)#{Mx[:en_b_c]}/m)
              end
              endnote_array.flatten.each do |note|
                txt_obj={:txt =>note}
                format_scroll=SiSU_HTML_Format::Format_scroll.new(@md,txt_obj)
                @scr_endnotes << format_scroll.endnote_body
              end
            end
          end
        end
        @scr_endnotes
      end
    end
    class Toc <Links_guide
      @@toc={ :seg=>[],:seg_mini=>[],:scr=>[] }
      @@seg_url=''
      @@dp,@@firstseg=nil,nil
      def initialize(data='',md=nil)
        @data,@md=data,md
        @vz=SiSU_Env::Get_init.instance.skin
        @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
        @pat_heading=/^(?:#{Mx[:lv_o]}[1-6]:\S*?#{Mx[:lv_c]}\s*)?(.*)#{Mx[:id_o]}~(\d+);(?:[hm]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
        @pat_strip_heading_name=/<a name="h?\d.*?">(.+?)<\/a>/
        @tell=SiSU_Screen::Ansi.new(@md.cmd) if @md
      end
      def songsheet #extracts toc for scroll & seg
        SiSU_Screen::Ansi.new(@md.cmd,'Toc').txt_grey unless @md.cmd =~/q/
        toc=nil
        @@firstseg=nil
        @@toc={ :seg=>[],:seg_mini=>[],:scr=>[] }
        @data.each do |para|
          if para =~/^(?:#{Mx[:lv_o]}[1-6]:|4~!)/
            para_toc=para.dup
            para_toc.gsub!(/&nbsp;<a name="-[\d*+]+" href="#_[\d*+]+">&nbsp;<sup>[\d*+]+<\/sup>&nbsp;<\/a>\s*(?:#{Mx[:en_a_o]}|#{Mx[:en_b_o]}).+?(?:#{Mx[:en_a_c]}|#{Mx[:en_b_c]})/m,'') #remove endnotes from toc
            toc=case para_toc
            when /^\s*#{Mx[:lv_o]}1:\S*/; Toc.new(para_toc,@md).level_1
            when /^\s*#{Mx[:lv_o]}2:\S*/; Toc.new(para_toc,@md).level_2
            when /^\s*#{Mx[:lv_o]}3:\S*/; Toc.new(para_toc,@md).level_3
            when /^\s*#{Mx[:lv_o]}4:\S+/; Toc.new(para_toc,@md).level_4
            when /^\s*#{Mx[:lv_o]}5:\S*/; Toc.new(para_toc,@md).level_5
            when /^\s*#{Mx[:lv_o]}6:\S*/; Toc.new(para_toc,@md).level_6
            when /^\s*4~!/;               Toc.new(para_toc).level_crosslink
            else
            end
            if @@firstseg.nil? \
            and para=~/^#{Mx[:lv_o]}4:\S+?#{Mx[:lv_c]}/
              @@firstseg=/^#{Mx[:lv_o]}4:(\S+?)#{Mx[:lv_c]}/.match(para)[1]
            end
            if toc
              begin
                @@toc[:seg] << toc[:seg] if toc[:seg]
                @@toc[:seg_mini] << toc[:seg_mini] if toc[:seg_mini]
                @@toc[:scr] << toc[:scr] if toc[:scr]
              rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
              end
            end
          end
        end
        @md.firstseg=@@firstseg
        @@toc
      end
      def minitoc
        minitoc=@@toc[:seg_mini].join("\n")
        '<div class="toc">' + minitoc + '</div>'
      end
    protected
      def rss #sort all wrong, disabled but kept
        @@toc[:seg] <<<<WOK
<center>
<table><tr><td>
<p><font color="#222222" #{@font.face} size="2">
(relatively static) RSS feeds for DOCUMENTS:<br />
<a href="../rssfeed/documents.xml"><img border="0" height="14" width="36" src="../_sisu/image/rss.png" alt="RSS feed"></a>&nbsp;http://www.jus.uio.no/lm/rssfeed/documents.xml<br />
<a href="../rssfeed/tradelaw.xml"><img border="0" height="14" width="36" src="../_sisu/image/rss.png" alt="RSS feed"></a>&nbsp;http://www.jus.uio.no/lm/rssfeed/tradelaw.xml<br />
<a href="../rssfeed/environmental.xml"><img border="0" height="14" width="36" src="../_sisu/image/rss.png" alt="RSS feed"></a>&nbsp;http://www.jus.uio.no/lm/rssfeed/environmental.xml<br />
<center><a href="mailto:info@address.com" target="_top">info@address.com</a></center>
</font></p>
</td></tr></table>
WOK
      end
      def level_doc_owner_details
        if @md.stmp =~/\w\w/
          format_head_scroll=SiSU_HTML_Format::Head_scroll.new(@md)
          @@toc[:scr] << format_head_scroll.toc_owner_details
        end
      end
#not used -->
      def level_endnotes
        if @md.flag_endnotes
          format_head_scroll=SiSU_HTML_Format::Head_scroll.new(@md)
          @@toc[:scr] << format_head_scroll.toc_endnote
        end
      end
      def level_concordance
        format_head_toc=SiSU_HTML_Format::Head_toc.new(@md)
        @@toc[:seg_mini] << format_head_toc.mini_seg_concordance
      end
      def level_metadata
        format_head_toc=SiSU_HTML_Format::Head_toc.new(@md)
        @@toc[:scr] << format_head_toc.metadata
        @@toc[:seg] << format_head_toc.seg_metadata
        @@toc[:seg_mini] << format_head_toc.mini_seg_metadata
      end
      def level_word_index
        format_head_toc=SiSU_HTML_Format::Head_toc.new(@d0c)
        @@toc[:scr] << format_head_toc.concordance
        @@toc[:seg] << format_head_toc.concordance
        @@toc[:seg_mini] << format_head_toc.mini_concordance
      end
# <-- not used
      def level_1
        para=@data
        unless para =~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
          para.gsub!(@pat_strip_heading_name,'\1')
        end
        para[@pat_heading]
        linkname,link=$1.strip,$2 if $&
          if link \
          and link !~/#/ #% keep eye on link
            p_num=SiSU_HTML_Format::Paragraph_number.new(@md,link)
          end
          title=unless para =~/Document Information/; linkname
        else
          link='metadata'
          %{<b><a href="#{@md.fnl[:pre]}#{link}#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}">#{linkname}</a></b>}
        end
        toc={}
        txt_obj={:txt =>title}
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc[:seg]=if para =~/^#{Mx[:lv_o]}\d:meta^#{Mx[:lv_c]}\s*Document Information/
          format_toc.lev0
        else format_toc.lev1
        end
        toc[:seg_mini]=if para =~/^#{Mx[:lv_o]}\d:meta#{Mx[:lv_c]}\s*Document Information/
          x=if @md.concord_make
            format_toc.mini_concord_tail
          else format_toc.mini_tail
          end
        else format_toc.mini_lev1
        end
        title=if para =~/(#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]})$/
          m=/#{$1}/
          para.gsub!(m,'')
          if para=~/^#{Mx[:lv_o]}\d:meta#{Mx[:lv_c]}\s*Document Information/
            %{<a href="#docinfo">#{linkname}</a>}
          else linkname
          end
        else
          @@toc[:scr] <<  '<br />'
          link=if para =~/#{Mx[:id_o]}~[1-9];([0-6]):\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/; $1
          else ''
          end
          %{<b><a href="##{link}">#{linkname}</a></b>}
        end
        txt_obj={:txt =>title}
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc[:scr]=if para =~/^#{Mx[:lv_o]}\d:meta^#{Mx[:lv_c]}\s*Document Information/
          format_toc.lev0
        else format_toc.lev1
        end
        toc
      end
      def level_2
        para=@data
        unless para =~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
          para.gsub!(@pat_strip_heading_name,'\1')
        end
        para[@pat_heading]
        linkname,ocn=$1.strip,$2 if $&
        if ocn \
        and ocn !~/#/
          p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        end
        txt_obj={:txt =>linkname}
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc={}
        toc[:seg]=format_toc.lev2
        toc[:seg_mini]=format_toc.mini_lev2
        if para =~/(#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]})$/
          m=/#{$1}/
          para.gsub!(m,'')
          title=linkname
        else title=%{#{p_num.goto}#{linkname}</a>}
        end
        txt_obj={:txt =>title}
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc[:scr]=format_toc.lev2
        toc
      end
      def level_3
        para=@data
        para.gsub!(@pat_strip_heading_name,'\1')
        para.gsub(/(.*?)<a name="(\d+)"><\/a>(.*)/,'\1') #2002w42 altered gsub! - problematic? - suspect
        para[@pat_heading]
        linkname,ocn=$1.strip,$2 if $&
        if ocn \
        and ocn !~/#/
          p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        end
        txt_obj={:txt =>linkname}
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc={}
        toc[:seg]=format_toc.lev3
        toc[:seg_mini]=format_toc.mini_lev3
        if para =~/(#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]})$/
          m=/#{$1}/
          para.gsub!(m,'')
          title=linkname
        else title=%{#{p_num.goto}#{linkname}</a>}
        end
        txt_obj={:txt =>title}
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc[:scr]=format_toc.lev3
        toc
      end
      def level_4
        para=@data
        unless para =~/~metadata/
          unless para =~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
            para.gsub!(@pat_strip_heading_name,'\1')
            para[@pat_heading]
            linkname,ocn=$1.strip,$2 if $&
            p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn) if ocn
          end
          para.gsub!(/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/,'')
          if para =~/^#{Mx[:lv_o]}4:/
            seg_link=para.gsub(/^\s*#{Mx[:lv_o]}4:(\S+?)#{Mx[:lv_c]}\s*(.+?)$/,
              %{  <a href="#{@md.fnl[:pre]}\\1#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}" target="_top">
    \\2
  </a> })
            if seg_link =~/(#{Mx[:id_o]}\~\d+;(?:\w|[0-6]:\d+);\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]})$/m
              m=/#{$1}/m
              seg_link.gsub!(m,'')
            end
            @@seg_url=para[/^#{Mx[:lv_o]}4:(\S+?)#{Mx[:lv_c]}.+?$/,1]
          elsif para =~/\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+/
            seg_link=para.gsub(/^\s*(#{@md.lv4}\s+)\s*(\d+.\d+.\d+.\d+|\d+.\d+.\d+|\d+.\d+|\d+)(.*)/,
              %{<a href="#{@md.fnl[:pre]}\\2#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}" } +
              %{target="_top">\\1 \\2 \\3</a> })
          end
          p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn) if ocn
          txt_obj={:txt =>seg_link}
          format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
          toc={}
          toc[:seg]=format_toc.lev4
          toc[:seg_mini]=format_toc.mini_lev4
          if para =~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
            m=/#{$1}/
            para.gsub!(m,'')
            title=linkname
          else title=%{#{p_num.goto}#{linkname}</a>} if p_num
          end
          txt_obj={:txt =>title}
          format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
          toc[:scr]=format_toc.lev4
          toc
        end
      end
      def level_5
        para=@data
        if para !~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
          para.gsub!(@pat_strip_heading_name,'\1')
        end
        para[@pat_heading]
        linkname,ocn=$1.strip,$2 if $&
        if ocn \
        and ocn !~/#/
          p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        end
        toc={}
        if para =~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
          m=/#{$1}/
          para.gsub!(m,'')
          title=linkname
        else
          lnk_n_txt=%{  <a href="#{@md.fnl[:pre]}#{@@seg_url}#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}##{ocn}">
    #{linkname}
  </a>}
          txt_obj={:txt =>lnk_n_txt}
          format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
          toc[:seg]=format_toc.lev5
          toc[:seg_mini]=format_toc.mini_lev5
          title=%{#{p_num.goto}#{linkname}</a>}
        end
        txt_obj={:txt =>title}
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc[:scr]=format_toc.lev5
        toc
      end
      def level_6
        para=@data
        if para !~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
          para.gsub!(@pat_strip_heading_name,'\1')
        end
        para[@pat_heading]
        linkname,ocn=$1.strip,$2 if $&
        if ocn \
        and ocn !~/#/
          p_num=SiSU_HTML_Format::Paragraph_number.new(@md,ocn)
        end
        toc={}
        if para =~/#{Mx[:id_o]}~0;(?:\w|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}$/
          m=/#{$1}/
          para.gsub!(m,'')
          title=linkname
        else
          lnk_n_txt=%{  <a href="#{@md.fnl[:pre]}#{@@seg_url}#{@md.fnl[:mid]}#{@md.sfx}#{@md.fnl[:post]}##{ocn}">
    #{linkname}
  </a>}
          txt_obj={:txt =>lnk_n_txt}
          format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
          toc[:seg]=format_toc.lev6
          toc[:seg_mini]=format_toc.mini_lev6
          title=%{#{p_num.goto}#{linkname}</a>}
        end
        txt_obj={:txt =>title}
        format_toc=SiSU_HTML_Format::Format_toc.new(@md,txt_obj)
        toc[:scr]=format_toc.lev6
        toc
      end
      def level_crosslink
        para=@data
        if para !~/^4~!/
          para.gsub!(/^4~!\s+(\S+)\s+(.+)/,
            %{<table><tr><td width =\"80\"></td>
  <td><a href="http://\\1" target="_top">
    #{@png.crosslink_ext}
      &nbsp;&nbsp;\\2
    <\/a>
  </td></tr></table>
})
        else
          para.gsub!(/^4~!\s+(\S+)\s+(.+)/,
            %{<table><tr><td width ="80">
  </td><td>
    <a href="\\1" target="_top">
      #{@png.crosslink}
        &nbsp;&nbsp;\\2
    <\/a>
  </td></tr></table>
})
        end
      end
    end
    class Scroll_head_and_segtoc < Toc
      def initialize(md='',toc='',links_guide_toc='')
        @md,@toc,@links_guide_toc=md,toc,links_guide_toc
        @vz=SiSU_Env::Get_init.instance.skin
      end
      def in_common
        toc_shared=[]
        @segtoc=[]
        SiSU_Screen::Ansi.new(@md.cmd,'Scroll & Segtoc').txt_grey unless @md.cmd =~/q/
        format_head_toc=SiSU_HTML_Format::Head_toc.new(@md)
        dochead=format_head_toc.head
        dochead.gsub!(/toc\.(html)/,'doc.\1') #kludge
        ads=SiSU_HTML_promo::Ad.new(@md)
        toc_shared << dochead << ads.div.major
        @segtoc << format_head_toc.head << ads.div.major
        toc_shared << format_head_toc.toc_head_escript if SiSU_HTML_Format::Head_toc.method_defined? :toc_head_escript
        @segtoc << format_head_toc.toc_head_escript if SiSU_HTML_Format::Head_toc.method_defined? :toc_head_escript
        toc_shared << format_head_toc.scroll_head_navigation_band
        if @md.rights
          rights=format_head_toc.rights
          rights=SiSU_Tune::Clean_html.new(rights).clean
        end
        if @md.prefix_b
          prefix_b=format_head_toc.prefix_b
          prefix_b=SiSU_Tune::Clean_html.new(prefix_b).clean
        end
        @seg_toc_band=format_head_toc.seg_head_navigation_band('pdf') #bug, vary depending on type of doc !! examine
        @seg_toc_band_bottom=format_head_toc.seg_head_navigation_band_bottom('pdf') #bug, vary depending on type of doc !! examine
        @segtoc << @seg_toc_band
        toc_shared << format_head_toc.scroll_head_title_banner_open
        @segtoc << format_head_toc.seg_head_title_banner_open
        tmp_head=nil
        doc_title_endnote=@md.title.gsub(/(\*+)/,'<sup><a href="#endnotes">\1</a></sup>')
        tmp_head=doc_title_endnote + "\n"
        txt_obj={:txt =>tmp_head}
        format_txt_obj=SiSU_HTML_Format::Format_text_object.new(@md,txt_obj)
        toc_shared << format_txt_obj.center_bold
        @segtoc << format_txt_obj.center_bold
        if not @md.subtitle.nil? \
        and not @md.subtitle.empty?
          tmp_head=@md.subtitle + "\n"
          txt_obj={:txt=>tmp_head}
          format_txt_obj=SiSU_HTML_Format::Format_text_object.new(@md,txt_obj)
          toc_shared << format_txt_obj.center_bold
          @segtoc << format_txt_obj.center_bold
        end
        if @md.author
          creator_endnote=@md.author.gsub(/(\*+)/,%{&nbsp;<sup><a href="#notes">\\1</a></sup>})
          tmp_head=creator_endnote + "\n"
          txt_obj={:txt =>tmp_head}
          format_txt_obj=SiSU_HTML_Format::Format_text_object.new(@md,txt_obj)
          toc_shared << format_txt_obj.center_bold
          @segtoc << format_txt_obj.center_bold
        end
        toc_shared << format_head_toc.copyat
        @segtoc << format_head_toc.copyat
        toc_shared << "#{@vz.table_close*1}\n"
        @segtoc << "#{@vz.table_close*1}\n"
        tmp_head=nil
        if @md.prefix_a
          tmp_head ||= %{<p />#{@md.prefix_a}\n}
          toc_shared << tmp_head.dup
          @segtoc << tmp_head.dup
        end
        tmp_head=nil
        toc_shared << @links_guide_toc
        toc_shared << rights if @md.rights
        toc_shared << prefix_b if @md.prefix_b
        #Table of Contents added/appended here
        toc_shared << @toc[:scr]
        @segtoc << @links_guide_toc
        @segtoc << @toc[:seg]
        @segtoc << rights if @md.rights
        @segtoc << prefix_b if @md.prefix_b
        #Segtoc tail added here
        @segtoc << "</p>\n" #bugfix sort later DEBUGNOW
        @segtoc << @seg_toc_band_bottom
        ads=SiSU_HTML_promo::Ad.new(@md)
        @segtoc << format_head_toc.seg_navigation_tail << ads.div.close << ads.display << format_head_toc.html_close
        @segtoc.flatten!.compact!
        Output.new(@segtoc,@md).segtoc
        @segtoc=[]
        @toc[:scr],@toc[:seg]=[],[]
        toc_shared
      end
    end
    class Table < SiSU_HTML_table::Table
    end
    class Scroll < SiSU_HTML_scroll::Scroll
    end
    class Scroll_output
      def initialize(scr_toc,scr_body,scr_endnotes,scr_metadata,scr_owner_details,scr_tails,md)
        @scr_toc,@scr_body,@scr_endnotes,@scr_metadata,@scr_owner_details,@scr_tails,@md=scr_toc,scr_body,scr_endnotes,scr_metadata,scr_owner_details,scr_tails,md
      end
      def publish
        scroll=[]
        hr='<center><hr width=90% /></center>'
        scroll << @scr_toc << hr << @scr_body << @scr_endnotes << hr << @scr_metadata << @scr_owner_details << @scr_tails
        scroll.flatten!.compact!
      end
    end
    class Seg < SiSU_HTML_seg::Seg
    end
    class Output
      @@dp=nil
      def initialize(data='',md='')
        @data,@md=data,md
        @my_make=SiSU_Env::Create_file.new(@md.cmd,@md.fns,@md)
        @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
      end
      def scroll
        begin
          @filename_html_scroll=@my_make.file_html_scroll(@md)
          @data.each do |para|
            para.strip!
            para.gsub!(/<:.+?>/,'')
            para.gsub!(/#{Rx[:mx_fa_clean]}/,'')
            unless para =~/\A\s*\Z/
              @filename_html_scroll.puts para,"\n"
            end
          end
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
        end
      end
      def segtoc
        begin
          @filename_html_segtoc=@my_make.file_html_segtoc(@md)
          @filename_html_index=@my_make.file_html_index(@md)
          @data.each do |para|
            para.strip!
            para.gsub!(/<!.+?!>|#{Mx[:gr_o]}.*?#{Mx[:gr_c]}|#{Mx[:id_o]}~\d+;(?:[ohm]|[0-6]:)\d+;\w\d+#{Mx[:id_c]}#{Mx[:id_o]}#@dp:#@dp#{Mx[:id_c]}/,'')
            unless para =~/\A\s*\Z/
              @filename_html_segtoc.puts para,"\n"
              @filename_html_index.puts para,"\n"
            end
          end
        rescue; SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
        end
      end
    end
  end
end
__END__
