# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: common file for xml table generation

=end
module SiSU_Tables
  require "#{SiSU_lib}/defaults"
  include SiSU_Viz
  class Table #_xml
    @@tablehead=0
    @@tablefoot=[] #watch #bug??? #check was @@tablefoot
    def initialize(one,ocn='')
      @one,@parablock,@ocn,@vz=one,one,ocn,SiSU_Env::Get_init.instance.skin
    end
    def table_split                                                            #% used but, no longer operational, revisit
      @new_content=[]
      @one.split(/\n/).each do |parablock|
        table=Table_xml.new("#{parablock}\n")
        @new_content << table.table
      end
      @new_content.join
    end
  end
  class Table_xml <Table
    @@tablehead=0
    @@tablefoot=[]
    @@dp=nil
    def initialize(one,ocn='')
      @one,@parablock,@ocn,@vz=one,one,ocn,SiSU_Env::Get_init.instance.skin
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
    end
    def table
      m=@parablock[/<!f(.+?)!>/,1]
      @@tablefoot << m if m
      @parablock.gsub!(/<!f.+?!>/,'')
      @@tablehead=1 if @parablock =~/<!Th¡/u
      if @parablock =~/<!Th?¡/u
        @parablock.gsub!(/<!Th?¡.+?!~(\d+);\w\d+;\w\d+>/u,
          %{\n<ocn>#@ocn</ocn><table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">})
      end
      if @parablock =~/<!TZ!>/
        tablefoot=[]
        #bug table footers need rethink, removed for now
        @@tablefoot.each {|x| tablefoot << ''}
        @@tablefoot=[]
        @parablock.gsub!(/<!TZ!>\s+<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><#@dp:#@dp>/,"</table>\n") # +
        @parablock.gsub!(/<!TZ!>\s*/,"</table>\n")
      end
      if @@tablehead == 1
        if @parablock =~/¡¡/u
          @parablock.gsub!(/<!¡¡(\d+?)¡/u,
            %{<tr>
  <td width="\\1%" valign="top">
    #{@vz.paragraph_table_xml}<b>})
          @parablock.gsub!(/¡¡(\d+?)¡/u,
            %{</b></td><td width="\\1%" valign="top">
  #{@vz.paragraph_table_xml}<b>})
          @parablock.gsub!(/!>/,"</b>\n</td>\n</tr>")
          @@tablehead=0
        end
        @parablock
      else
        @parablock.gsub!(/<!¡¡(\d+?)¡/u,
          %{<tr>
  <td width="\\1%" valign="top">
    #{@vz.paragraph_table_xml}})
        @parablock.gsub!(/¡¡(\d+?)¡/u,
          %{
  </td>
  <td width="\\1%" valign="top">
    #{@vz.paragraph_table_xml}})
        @parablock.gsub!(/!>/,"\n</td>\n</tr>\n")
      end
      @parablock
    end
  end
  class Table_xml_exp <Table
    @@tablehead=0
    @@tablefoot=[]
    def initialize(one)
      @one,@parablock,@vz=one,one,SiSU_Env::Get_init.instance.skin
    end
    def table_head(inf)
      %{<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">
  <tr>
    <td valign="top" align="justify">
      <a name="#{inf}"></a>
    </td>
    <td>
<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">}
    end
    def table_end(tablefoot='')
      %{</table>#{@vz.margin_numless}#{@vz.margin_numless}&nbsp;#{@vz.table_close}
#{tablefoot}}
    end
    def table_row(inf,h=false)
      bold=if h; '<b>'
      else       ''
      end
      %{
<tr>
  <td width="#{inf}%" valign="top">#{bold}}
    end
    def table_cell(inf,h=false)
      if h; %{</b></td><td width="#{inf}%" valign="top"><b>}
      else  %{</td><td width="#{inf}%" valign="top">}
      end
    end
    def table_row_close(h=false)
      bold_close=if h; '</b>'
      else             ''
      end
      "#{bold_close}</td></tr>"
    end
    def table
      m=@parablock[/<!f(.+?)!>/,1]
      @@tablefoot << m if m
      @parablock.gsub!(/<!f.+?!>/,'')
      @@tablehead=1 if @parablock =~/<!Th¡/u
      if @parablock =~/<!Th?¡.+?!~(\d+);\w\d+;\w\d+>/u; @parablock=table_head($1)
      end
      if @parablock =~/<!TZ!>/
        tablefoot=[]
        @@tablefoot.each {|x| tablefoot << ''}
        @@tablefoot=[]
        if @parablock =~/<!TZ!>/; @parablock=table_end
        end
      end
      if @@tablehead == 1
        if @parablock =~/¡¡/u
          if @parablock =~/<!¡¡(\d+?)¡/u
            @parablock.gsub!(/<!¡¡(\d+?)¡/u,table_row($1,true))
          end
          if @parablock =~/¡¡(\d+?)¡/u
            @parablock.gsub!(/¡¡(\d+?)¡/u,table_cell($1,true))
          end
          if @parablock =~/!>/
            @parablock.gsub!(/!>/,table_row_close(true))
          end
          @@tablehead=0
        end
        @parablock
      else
        if @parablock =~/<!¡¡(\d+?)¡/u
          @parablock.gsub!(/<!¡¡(\d+?)¡/u,table_row($1))
        end
        if @parablock =~/¡¡(\d+?)¡/u
          @parablock.gsub!(/¡¡(\d+?)¡/u,table_cell($1))
        end
        if @parablock =~/!>/
          @parablock.gsub!(/!>/,table_row_close)
        end
        @parablock
      end
      @parablock
    end
  end
end

