# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: manpage formatting template

=end
module Format
  require "#{SiSU_lib}/param"
  include SiSU_Param
  include SiSU_Viz
  class Paragraph_number
    def initialize(paranum)
      @paranum=/(\d+)/m.match(paranum)[1]
    end
    def display
      @paranum.gsub(/(\d+)/,'<font size="1" color="#777777">&nbsp;&nbsp;\1</font>')
    end
    def name
      @paranum.gsub(/(\d+)/,'<a name="\1"></a>')
    end
    def goto
      @paranum.gsub(/(\d+)/,'<a href="#\1">')
    end
  end
  class Format_text_object
    @@dp=nil
    def initialize(one,two,three)
      one.gsub!(/\.(html|pdf|php)/,'') if one =~/\.\.\/\S+/
      @one,@two,@three=one,two,three
      rgx=/^[1-6-]~/
      @one.gsub!(rgx,'') if @one =~rgx
      @dp=@@dp ||=SiSU_Env::Info_env.new.digest.pattern
      rgx=/~\{[\d*+]+\s+(.+?)<#@dp>\}~/
      @one.gsub!(rgx,'\1') if @one =~rgx
      @link,@linkname=one,two
      @vz=SiSU_Env::Get_init.instance.skin
    end
    def scr_endnote_body
      "<endnote>#@one</endnote> "
    end
    def heading_body1
    end
    def heading_body2
    end
    def heading_body3
    end
    def heading_body4
    end
    def heading_body5
    end
    def heading_body6
    end
  end
  class XML
  end
end
__END__

