# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: document abstraction tables

=end
module SiSU_document_structure_tables
  class Instantiate < SiSU_Param::Parameters::Instructions
    @@flag={}
    def initialize
      @@flag['table_to']=false
      @@counter=@@column=@@columns=0
      @@line_mode=''
    end
  end
  class Tables
    @@flag={}
    def initialize(md,data)
      @md,@data=md,data
      Instantiate.new
    end
    def table_visual(para)
      count=0
      @row=[]
      table=[]
      @rows=para.split(/;;/)
      @rows.compact! #(c\d+?;.+?)
      @rows.each do |row|
        count +=1
        @row[count]=row.split(/\|/)
      end
      @row.compact!
      widths=if @row[0].join =~/^\{(?:t|table)(?:~h)?\s+\d+;/
        col_width=@row[0].join.scan(/\d+/)
        rem=(100 - col_width[0].to_i)
        col_w=rem/(@row[1].length - 1)
        "#{col_width[0].to_s};" + ("#{col_w};" * (@row[1].length-1))
      else
        col_w=100/@row[1].length
        "#{col_w};" * @row[1].length
      end
      @row.delete_if {|r| r[0] =~/\{(?:table|t)(?:~h)?(?:\s+c\d+;)?[\d; ]*\}/}
      w=widths.split(/;/)
      tuned_file=[]
      tuned_file << if para =~/\{(?:t|table)~h(?:\sc\d+;)?[\d; ]*\}/
        "<!Th#{TS1} c#{@row[2].length}; #{widths}!>"
      elsif para =~/\{(?:t|table)(?:\sc\d+;)?[\d; ]*\}/
        "<!T#{TS1} c#{@row[2].length}; #{widths}!>"
      end
      @row.each do |l|
        l << '' if l.length == (@row[1].length - 1)
        table=[]
        if l.length == @row[1].length
          table << '<!'                                                                  #'<tr>'
          n= -1
          l.each do |c|
            n +=1                                                                      #'<td>' + c + '</td>'
            table << if c =~/\A(?:\n)?\s*\Z/
              "#{TS1}#{TS1}#{w[n]}#{TS1}" + ' '
            else
              "#{TS1}#{TS1}#{w[n]}#{TS1}" + c.strip
            end
          end
          table << '!>'                                                                  #'</tr>'
          tuned_file << table.join
        end
      end
      tuned_file << '<!TZ!>'                                                            #'</table>'
      tuned_file=tuned_file.compact.join("\n")
    end
    def tables
      data=@data
      count=0
      @row,@tuned_file,@tuned_table=[],[],[]
      data.each do |para|
        para.gsub!(/\n\s+\n/,"\n")
        para.gsub!(/\s+\n/,"\n")
        para.gsub!(/<:hi>/,'<span style="background-color: rgb(255,240,196)">') # bright yellow rgb(255,255,0) pale yellow rgb(255,255,200)
        para.gsub!(/<:\/hi>/,%{</span>})
        table=[]
        if para =~/^\{(?:t|table)(?:~h)?(?:\sc\d+;)?[\d; ]*\}/
          @tuned_file << table_visual(para)
          @tuned_file=@tuned_file.flatten
        elsif @@flag['table_to'] \
        or para[/^table\{(?:~h)?/]
          if para[/table\{(?:~h)?\s+c(\d+;.+)/]
            instructions=$1
            @@column=instructions.split(/;\s*/)
            @@columns=@@column[0]
            para.gsub!(/^table\{~h\s+(c\d+?;.+?)$/,"<!Th#{TS1} \\1!>")
            para.gsub!(/^table\{\s+(c\d+?;.+?)$/,"<!T#{TS1} \\1!>")
            @@flag['table_to']=true
          end
          if @@flag['table_to'] \
          and para =~/\}table/
            para.gsub!(/^\}table\s*$/,"<!TZ!>\n")
            para.gsub!(/\n/,' ') #newlines taken out
            para.strip!
            @tuned_table << para
            @tuned_table.delete('')
            @tuned_file << @tuned_table.compact.join("\n") #@tuned_table.compact.join =~/\S+/  #would be preferable
            para=''
            @tuned_table=[]
            @@flag['table_to']=false
          end
          if @@flag['table_to'] \
          and para =~/\S/
            @@counter=1
            sub_array=para.dup
            @@line_mode=sub_array.scan(/.+/u)
            Tables.new(@md,@@line_mode).tr_td
            para=@@line_mode.join
            para.gsub!(/(.*\S+.*)\Z/m,'<!\1!>') unless para =~/<!Th?#{TS1}/u
          end
          para.gsub!(/\n/,' ')
          para.strip!
          @tuned_table << para
        else
          para.gsub!(/\n/,' ') unless para =~/<:(?:code|verse|alt|group)>/
          para.strip!
          @tuned_file << para
        end
        @tuned_file
      end
      @tuned_file
    end
    def tr_td
      data=@data
      data.each do |line|
        if @@counter <= @@columns.to_i \
        and line !~/(\}T\s*$|<:table[-_](close|end)>|<!TZ!>)/
          #if line.encoding.inspect =~/Encoding:ASCII-8BIT/
          #  line=line.force_encoding('utf-8')
          #end
          line.gsub!(/(.+)/,"#{TS1}#{TS1}#{@@column[@@counter]}#{TS1}\\1") unless line =~/<!Th?#{TS1}/u
          @@counter+=1
        end
      end
      data
    end
  end
end
__END__
#p line.encoding
@data.each {|x| p x.encoding }
p para if para.encoding.inspect =~/Encoding:ASCII-8BIT/
