# coding: utf-8
=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007, 2008 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licensing/licenses/gpl.html>
   <http://www.gnu.org/licenses/gpl.html>

   <http://www.jus.uio.no/sisu/gpl.fsf/toc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/doc.html>
   <http://www.jus.uio.no/sisu/gpl.fsf/plain.txt>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: composite documents, assemble/build documents from other
   documents or parts of marked up text

=end
module SiSU_Assemble
  require "#{SiSU_lib}/sysenv"
  class Remote_image
    def initialize
      @env=SiSU_Env::Info_env.new
    end
    def image(dir)
      images=[]
      images[0]=dir
      images
    end
    def download_images(download_from,images_array)
      path="#{@env.path.processing}/external_document/image"
      mkdir_p(path) unless FileTest.directory?(path)
      images_array.each do |i|
        image="#{path}/#{i}"
        imagefile=File.new(image,'w+')
        open("#{download_from}/#{i}") do |g|
          imagefile << g.read
        end
        imagefile.close
      end
      output_path="#{@env.path.webserv}/#{@env.path.stub_pwd}/_sisu/image_external"
      mkdir_p(output_path) unless FileTest.directory?(output_path)
      SiSU_Env::System_call.new("#{path}/*",output_path,'q').rsync
    end
    def download_doc_skin(doc_skin) #first element in array is source url
      path="#{@env.path.processing}/external_document/skin/doc"
      mkdir_p(path) unless FileTest.directory?(path)
      download_from=doc_skin.shift
      doc_skin.each do |i|
        skin="#{path}/#{i}.rb"
        unless FileTest.exists?(skin)
          skinfile=File.new(skin,'w+')
          open("#{download_from}/#{i}.rb") do |g|
            skinfile << g.read
          end
          skinfile.close
        end
      end
    end
  end
  class Composite
    @@imager={}
    def initialize(opt)
      @opt=opt
      @env=SiSU_Env::Info_env.new
    end
    def read
      begin
        @fns_array=IO.readlines(@opt.fns,'')
        assembled=insertions?
        write(assembled)
      rescue; SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    def write(assembled)
      assembled_file=File.new("#{@env.path.composite_file}/#{@opt.fnb}.ssm.sst",'w+')
      assembled.each{|a| assembled_file << a }
      assembled_file.close
    end
    def download_images(download_from,images_array)
      path="#{@env.path.processing}/external_document/image"
      mkdir_p(path) unless FileTest.directory?(path)
      images_array.each do |i|
        image="#{path}/#{i}"
        unless FileTest.exists?(image)
          imagefile=File.new(image,'w+')
          open("#{download_from}/#{i}") do |g|
            imagefile << g.read
          end
          imagefile.close
        end
      end
    end
    def download_doc_skin(doc_skin) #first element in array is source url
      path="#{@env.path.processing}/external_document/skin/doc"
      mkdir_p(path) unless FileTest.directory?(path)
      download_from=doc_skin.shift
      doc_skin.each do |i|
        skin="#{path}/#{i}.rb"
        unless FileTest.exists?(skin)
          skinfile=File.new(skin,'w+')
          open("#{download_from}/#{i}.rb") do |g|
            skinfile << g.read
          end
          skinfile.close
        end
      end
    end
    def insertion(fni,insert_array)
      file={ :prepared=>[],:images=>[] }
      rgx_image=/(?:^|[^_\\])\{\s*(\S+?\.(?:png|jpg|gif))/
      #rgx_image=/([a-zA-Z0-9._-]+?\.(?:png|jpg|gif))/
      file[:prepared] << "\n% |#{fni}|@|^|>>ok\n"
      @code_flag=false
      insert_array.each do |i|
        @code_flag=if i =~/^code\{/; true
        elsif i =~/^\}code/; false
        else @code_flag
        end
        if not @code_flag \
        and i !~/^%+\s/
          i.gsub!(/^([123]|:?[ABC])~\? /,'% [conditional heading:] \1~ ')            #off conditional heading (consider syntax)
          if i =~/^0~|^@\S+?:/
            i.gsub!(/\n/m,"\n%  ")
            i.gsub!(/\n%\s+$/m,'')
            i.gsub!(/^0~|^@\S+?:/m,"\n% [imported header:] ")                          #off imported headers
          end
        end
        file[:prepared] << i
        if i !~/^%+\s/ \
        and i =~rgx_image
          file[:images] << i.scan(rgx_image).uniq
        end
      end
      file[:prepared] << "\n% end import" << "\n\n"
      if file[:images].length > 0
        file[:images].flatten!
        file[:images].uniq!
        file[:images].delete_if {|x| x =~/http:\/\// }
      end
      file
    end
    def insertions?
      data=@fns_array
      tuned_file,imagedir=[],[]
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'Composite Document',@opt.fns)
      tell.grey_title_hi unless @opt.cmd =~/q/
      para=data.each do |para|
        if para =~/^<<\s+(\S+?\.ss[it])$/ \
        or para =~/^<<\{(\S+?\.ss[it])\}$/ \
        or para =~/^(?:<<\s*)\|(\S+?)\|@\|.+?\|(?:req(?:quire)?\b|\s*\})?/ \
        or para =~/^r\{(.+?)\}/ #depreciated
          loadfile=$1.strip
          tell=SiSU_Screen::Ansi.new(@opt.cmd,'loading:',loadfile)
          tell.txt_grey if @opt.cmd =~/[MVv]/
          tuned_file << if loadfile =~ /(?:https?|file):\/\/\S+?\.ss[ti]$/ # and NetTest
            imagedir = /((?:https?|file):\/\/\S+?)\/[^\/]+?\.ss[ti]$/.match(loadfile).captures.join + '/_sisu/image' #watch
            require 'uri'
            image_uri=URI.parse(imagedir)
            require 'open-uri'
            require 'pp'
            insert=open(loadfile)
            insert_array=insert.dup
            insert.close
            file=insertion(loadfile,insert_array)
            @@imager[image_uri] ||=[]
            @@imager[image_uri] << file[:images]
            file[:prepared]
          elsif loadfile =~ /\.ss[ti]$/ \
          and FileTest.file?(loadfile)
            insert_array=IO.readlines(loadfile,'')
            file=insertion(loadfile,insert_array)
            file[:prepared]
          else
            cX=SiSU_Screen::Ansi.new(@opt.cmd).cX
            puts "\t  #{cX.fuschia}ERROR#{cX.off} #{cX.brown}#{@opt.fns}#{cX.off} #{cX.fuschia}requires invalid or non-existent file:#{cX.off} #{cX.brown}#{loadfile}#{cX.off}"
            para
          end
        else tuned_file << para
        end
        tuned_file.flatten!
        tuned_file.compact!
      end
      if @@imager.length >0
        @@imager.each do |d,i|
          i.flatten!
          i.uniq!
          download_images(d,i)
        end
      end
      tuned_file
    end
  end
end
__END__

