=begin

 * Name: SiSU

 * Description: a framework for document structuring, publishing and search

 * Author: Ralph Amissah

 * Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah All Rights Reserved.

 * License: GPL 3 or later:

   SiSU, a framework for document structuring, publishing and search

   Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
   2007 Ralph Amissah

   This program is free software: you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation, either version 3 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program. If not, see <http://www.gnu.org/licenses/>.

   If you have Internet connection, the latest version of the GPL should be
   available at these locations:
   <http://www.fsf.org/licenses/gpl.html>
   <http://www.gnu.org/copyleft/gpl.html>
   <http://www.jus.uio.no/sisu/gpl.fsf>

 * SiSU uses:
   * Standard SiSU markup syntax,
   * Standard SiSU meta-markup syntax, and the
   * Standard SiSU object citation numbering and system

 * Hompages:
   <http://www.jus.uio.no/sisu>
   <http://www.sisudoc.org>

 * Download:
   <http://www.jus.uio.no/sisu/SiSU/download.html>

 * Ralph Amissah
   <ralph@amissah.com>
   <ralph.amissah@gmail.com>

 ** Description: document abstraction

=end
module SiSU_document_structure_code
  class Instantiate < SiSU_Param::Parameters::Instructions
    @@flag={} #Beware!!
    def initialize
      @@flag['table_to']=false
      @@counter=@@column=@@columns=0
      @@line_mode=''
    end
  end
  class Code
    @@flag={} #Beware!!
    def initialize(md,data)
      @md,@data=md,data
      Instantiate.new
    end
    def code
      data=@data
      tuned_file=[]
      @tuned_group=[]
      @@counter=0
      @verse_count=0
      data.each do |para|
        para.gsub!(/(<:(?:code|verse|alt|group)>)\s/,'\1') #double check
        para.gsub!(/(?:\n\s*\n)+/m,"\n") unless @@flag['code']
        if para =~/^code\{/
          @@flag['code']=true
          @@counter=1
          para.gsub!(/^code\{.*/,'<:code>')
        elsif para =~/^(?:poem)\{/ \
        and not @@flag['code']
          @@flag['poem']=true
          para.gsub!(/^(poem)\{.*/,'<:verse>')
        elsif para =~/^(?:alt|group)\{/ \
        and not @@flag['code'] #group not tested, stub 2005
          @@flag['group']=true
          para.gsub!(/^(alt|group)\{.*/,'<:\1>')
        end
        if @@flag['code']
          if @@flag['code'] \
          and para =~/^\}code/
            para.gsub!(/^\}code.*/,'<:code-end>')
            @@flag['code']=false
          end
          if @@flag['code'] \
          or para =~/<:code-end>/ #and para =~/\S/
            sub_array=if para !~/<:code(?:-end)?>/; para.dup + '<:br>'
            else para.dup
            end
            @line_mode=sub_array.scan(/.+/)
            #@line_mode=[]
            #sub_array.scan(/.+/) {|w| @line_mode << w + '<:br>' if w =~/[\Ss]+/}
            SiSU_document_structure_code::Code.new(@md,@line_mode).code_lines('code')
            para=@line_mode.join
          end
        elsif ( @@flag['poem'] \
        or @@flag['group'] ) \
        and not @@flag['code']
          if @@flag['poem'] \
          and para =~/^\}(?:poem)/
            para.gsub!(/^\}(poem).*/,"\n<:verse-end>")
            @@flag['poem']=false
          elsif ( @@flag['group'] \
          and para =~/^\}(?:alt|group)/ ) \
          and not @@flag['code']
            para.gsub!(/^\}(alt|group).*/,'<:\1-end>')
            @@flag['group']=false
          end
          if @@flag['poem'] \
          or @@flag['group'] \
          and para =~/\S/ \
          and para !~/<:(verse|code|alt|group)(-end)?>/ \
          and not @@flag['code']
            sub_array=para.dup
            @line_mode=sub_array.scan(/.+/)
            type=if @@flag['poem']; 'poem'
            else 'group'
            end
            SiSU_document_structure_code::Code.new(@md,@line_mode).code_lines(type)
            div=if @@flag['poem'] \
            and @verse_count > 0
              "\n" + '<:verse-end>' + "\n\n" + '<:verse>'
            else ''
            end
            @verse_count+=1 if @@flag['poem']
            para = div + @line_mode.join
          else para
          end
        end
        if @@flag['code'] \
        or @@flag['poem'] \
        or  @@flag['group']
          @tuned_group << para if para =~/\S+/
        elsif para =~/<:(?:code|alt|group|verse)-end>/
          @verse_count=0
          @tuned_group << para
          tuned_file <<= if para =~/<:group-end>/
            @tuned_group.join("\n")
          else @tuned_group=@tuned_group.join
            @tuned_group.gsub!(/<:br><:br>(<:code-end>)/,'\1')
            @tuned_group
          end
          @tuned_group=[]
        else tuned_file << para
        end
      end
      tuned_file
    end
    def code_lines(type='')
      data=@data
      data.each do |line|
        if line =~/\S/ \
        and line !~/^code\{|^\}code|<:code.+/
          line.gsub!(/\s\s/,'&nbsp;&nbsp;')
          line.gsub!(/^/,'<:codeline>') if type=='code' # try sort for texpdf special case
          if line =~/(?:https?|file|ftp):\/\/\S+$/
            line.gsub!(/$/,' <:br>')
          else line.gsub!(/$/,'<:br>') #unless type=='code'
          end
          if @@flag['code']; @@counter+=1
          else
          end
        elsif line =~/^\s*$/
          line.gsub!(/$/,' <:br>')
        end
      end
    end
  end
end
__END__
