=begin
 * Name: SiSU information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: spellchecking

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:

  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system

  © Ralph Amissah 1997, current 2007.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module Utility
  class Spell
    def initialize(input,filesrc,flg)
      @flg=flg
      @filename, @filetype = /(.+?)(\.\w\w\w0$)/.match(filesrc)[1,2] #.gsub(/\.\w\w\w0$/, "")
      @input=input
      @allwords=[]
      puts @filename
      @speller='aspell' # 'ispell'
      @dictionary='british'
      @lang='en_GB'
    end
    def check
      @input.each do |data|
        data.gsub!(/(http|www|ftp|gopher|png|jpg|gif|html|htm|&nbsp;)\S+/i,' ')
        data.gsub!(/<\/?(table|tr|td|b|p|href).*?>/i,' ')
        data.gsub!(/(<==.+|<:\S+>|<!.+?!>|^0~.+|\{\{\{|~)/,' ')
        data.gsub!(/(["|<>)(\n'`'.;&_-]|\=)/,' ')
        data.gsub!(/\b(altExternal|
          target|externalimg|
          srcimagebext|
          img|src|toc|pdf|
          cd|org|
          helvetica|roman
          )\b/i,' ')
        data.gsub!(/EOF/,'')
        @words=data.scan(/\S+/)
        @words.each { |y| @allwords << y }
      end
      @allwords.uniq!
      if @flg =~ /S/
        File.open('/home/ralph/spell_error','a+') do |file| #fix
          file.puts %{\n\n<<#@filename>>}
        end
        @allwords.each { |y| puts y.inspect; system(%{cat #{y} | /usr/bin/#@speller -l -d #@dictionary >> ~/spell_error })}
      else
        @allwords.each { |y| sp=%x{echo #{y}|#@speller -l }; puts sp unless sp.empty?}
      end
    end
  end
end
__END__

