=begin
 * Name: modify.rb
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: A conversion script for canned substitutions,
     a fairly generic simple tool that can be used to store other canned conversions,
     used here for altering SiSU markup

 * Copyright (C) 2004, 2006 Ralph Amissah

 * Packaged with: SiSU information Structuring Universe - Structured information, Serialized Units
 * SiSU Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  © Ralph Amissah 1997, current 2007.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Markup
  class Markup_identify
    @@fns,@@version_determined,@@version_declared,@@declared_doc_type='','','','[text?]'
    attr_accessor :version_determined,:version_declared,:declared_doc_type
    def initialize(content,opt)
      @cont,@opt=content,opt
    end
    def identify
      @version_determined,@version_declared,@declared_doc_type=@@version_determined,@@version_declared,@@declared_doc_type
      if @opt.fns != @@fns
        if @cont[0] =~ /^(?:%\s+)?SiSU\s+(text|master|insert)\s+([0-9](?:\.[0-9]+){1,2})/ or @cont[0] =~ /^(?:%\s+)?sisu-([0-9](?:\.[0-9]+){1,2})/
          @declared_doc_type,@version_declared=$1,$2
        elsif @cont[0] =~ /^(?:%\s+)?SiSU\s+([0-9](?:\.[0-9]+){1,2})/ or @cont[0] =~ /^(?:%\s+)?sisu-([0-9](?:\.[0-9]+){1,2})/
          @version_declared=$1
        end
        @flag_38=false
        @cont.each_with_index do |y,i|
          if @flag_38 or y =~/^:?A~/
            @version_determined=0.38
            @flag_38=true
            break if i >= 200
            if y =~ /(?:~{\*+|~\[\*|~\[\+)\s/
              @version_determined=0.42 #0.38 can safely be treated as 0.42
              break
            end
          end
          if y =~/^0~/ and not @flag_38
            @version_determined=0.16
            break
          end
        end
        @@fns=@opt.fns
        @@version_determined,@@version_declared,@@declared_doc_type=@version_determined,@version_declared,@declared_doc_type
      end
      self
    end
    def markup_version?
      identify.version_determined.to_f
    end
  end
end
__END__
