=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download.html

 * Description: modules shared by db and flatfile output generators, mostly xml/xhtml/html formatting

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_Format_Shared
  require SiSU_lib + '/defaults'
  include SiSU_Viz
  class CSS_Format
    def initialize(content=nil,id=nil,ocnd='',ocns='',lv='',hname=nil)
      content.gsub!(/<:i[12]>/,'')
      @content=content
      @id=@ocn=id
      @ocnd,@ocns=ocnd,ocns
      @lv=@notenumber=lv.to_s
      @hname=hname.to_s
      @tab="\t"
      # lots introduced to do html tables in db
      @@tablehead,@@tablefoot=[],[]
      @margin=SiSU_Viz::Margin.new
      @pargraph=SiSU_Viz::Paragraph.new
      @table=SiSU_Viz::Table.new
      @font=SiSU_Viz::Font.new
    end
    def paragraph
      %{#{@tab*1}<p class="h#@lv" id="#@ocn" type="substantive" header="#@hname">\n#{@tab*2}#@content\n#{@tab*1}</p>\n}  << "\n"
    end
    def endnote
      <<GSUB
#{@tab*1}<p class="endnote" name="note_#@notenumber" from="#@ocn">
#{@tab*2}<a name="_#@notenumber" href="#-#@notenumber">#@notenumber.</a> <note>#@content</note>
#{@tab*1}</p>
GSUB
    end
    def lev_toc_hname
      %{#{@tab*1}<p class="toc#@lv" header="#@hname"><a href="##@ocn">\n#{@tab*2}#@content\n#{@tab*1}</a></p>\n}  << "\n"
    end
    def lev_toc
      %{#{@tab*1}<p class="toc#@lv"><a href="##@ocn">\n#{@tab*2}#@content\n#{@tab*1}</a></p>\n}  << "\n"
    end
    def lev4_plus
      %{#{@tab*1}<p class="h#@lv" id="#@ocn" type="substantive" header="#@hname">\n#{@tab*2}#@content\n#{@tab*1}</p>\n}  << "\n"
    end
    def lev4_minus
      %{#{@tab*1}<p class="h#@lv" id="#@ocn" type="substantive">\n#{@tab*2}#@content\n#{@tab*1}</p>\n}  << "\n"
    end
    def norm_comment
      %{#{@tab*1}<p class="norm" id="none" type="comment">\n#{@tab*2}#@content\n#{@tab*1}</p>\n} 
    end
    def norm
      %{#{@tab*1}<p class="norm" id="#@ocn" type="substantive">\n#{@tab*2}#@content\n#{@tab*1}</p>\n} 
    end
    def indent1
      %{#{@tab*1}<p class="indent1" id="#@ocn" type="substantive">\n#{@tab*2}#@content\n#{@tab*1}</p>\n} 
    end
    def indent2
      %{#{@tab*1}<p class="indent2" id="#@ocn" type="substantive">\n#{@tab*2}#@content\n#{@tab*1}</p>\n} 
    end
    def para_table
      %{<p class="norm" align="left"><font #{@font.small} #{@font.color} #{@font.face}>}
    end
    def ocn
      %{#{@tab*1}<p class="ocn">#@ocn</p>} << "\n"
    end
   def html_table # get rid of use html_table
      @new_content=[]
      @content.split(/\n/).each do |parablock|
        m=parablock[/<!f(.+?)!>/,1]
        @@tablefoot<<m if m 
        parablock.gsub!(/<!f.+?!>/,'')
        @@tablehead=1 if parablock =~/<!Th¡/
        parablock.gsub!(/<!Th?¡.+?!~(\d+)>/,
           #%{<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center"><tr><td valign="top" align="justify"><p class="norm" id="\\1">  </p> </td><td>\n} +
           %{<table summary="normal text css" width="100%" border="0" bgcolor="white" cellpadding="2" align="center">})
        if parablock =~/<!TZ!>/
          tablefoot=[]
          @@tablefoot.each {|x| tablefoot << %{<p align="center"><font size=2><i>#{x}</i></font></p>\n}}
          @@tablefoot=[]
          parablock.gsub!(/<!TZ!>/,
            %{#{@table.close}\n}) # +
            #%{#{tablefoot}})
        end
        if @@tablehead == 1
          if parablock =~/¡¡/
            parablock.gsub!(/<!¡¡(\d+?)¡/,
              %{\n<tr>} +
              %{\n<td width="\\1%" valign="top">} +
              %{#{para_table}<b>})
            parablock.gsub!(/¡¡(\d+?)¡/,
              %{</b></td><td width="\\1%" valign="top">} +
              %{#{para_table}<b>})
            parablock.gsub!(/!>/, '</b></td></tr>')
            @@tablehead=0 #if parablock =~/!>/
          end
          parablock
        else
          parablock.gsub!(/<!¡¡(\d+?)¡/,
            %{\n<tr>} +
            %{\n<td width="\\1%" valign="top">} +
            %{#{para_table}})
          parablock.gsub!(/¡¡(\d+?)¡/,
            %{</td><td width="\\1%" valign="top">} +
            %{#{para_table}})
          parablock.gsub!(/!>/, '</td></tr>')
          parablock
        end
        @new_content << parablock
      end
      @new_content.join
    end
  end
  class CSS_Format_generic #does CSS_Format in one definition, needs to be told about class, despite brevity of generic, easier to see structure with CSS_Format
    def initialize(css_class='',content='',id=nil,ocnd=nil,ocns=nil,lv='',hname=nil)
      @tab="\t"
      @class=css_class
      @content=content
      @lv=@notenumber=lv.to_s
      #@ocn=ocn.to_s
      @hname=hname.to_s
      @id=@ocn=id
    end
    def paragraph
      css_class=%{class="#@class" }
      if @ocn
        id=%{id="#@ocn" }
        type=%{type="substantive" }
      else
        id=%{id="none" }
        type=%{type="comment" }
      end
      header=%{header="#@hname" } if @hname
      %{#{@tab*1}<p #{css_class}#{id}#{type}#{header}>\n#{@tab*2}#@content\n#{@tab*1}</p>\n}  << "\n"
    end
    def para
      paragraph
    end
  end
end
__END__

