=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: xml output (sax style) processing

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com

 * Notes: tidy -xml sax.xml >> index.tidy
=end
module SiSU_XML_SAX
  require SiSU_lib + '/defaults'
  require SiSU_lib + '/param'
  include SiSU_Param
  include SiSU_Viz
  require SiSU_lib + '/sysenv'
  include SiSU_Env
  require SiSU_lib + '/metaverse'
  require SiSU_lib + '/common_xml'
  require SiSU_lib + '/xml_format'
  include SiSU_XML_format
  include SiSU_XML_character
  require SiSU_lib + '/rexml'
  include SiSU_Rexml
  @@alt_id_count,@@tablehead,@@number_of_cols=0,0,0
  @@tablefoot=''
  class Source
    def initialize(opt)
      @opt=opt
    end
    def read
      begin
        @md=SiSU_Param::Parameters.new(@opt).get
        @env=SiSU_Env::Info_dir.new(@opt.fns)
        path=SiSU_Env::Info_dir.new(@opt.fns).tell_output_path
        loc=SiSU_Env::Info_dir.new(@opt.fns).tell_output_location
        tool=if @opt.cmd =~/[MV]/: "#{@env.web_browser} #{loc}/#{@md.fnb}/#{@md.fn[:sax]}\n\t#{@env.xml_viewer} #{path}/#{@md.fnb}/#{@md.fn[:sax]}"
        elsif @opt.cmd =~/v/: "#{@env.web_browser} #{loc}/#{@md.fnb}/#{@md.fn[:sax]}"
        else ''
        end
        tell=SiSU_Screen::Ansi.new(@opt.cmd,'invert','XML SAX',tool)
        tell.colorize unless @opt.cmd =~/q/
        tell=SiSU_Screen::Ansi.new(@opt.cmd,@opt.fns,"#{@env.tell_output_path}/#{@md.fnb}/#{@md.fn[:sax]}")
        tell.flow if @opt.cmd =~/[MV]/
        @metaverse_array=SiSU_Metaverse::Source.new(@opt).get # metaverse file drawn here
        SiSU_XML_SAX::Source::Songsheet.new(@metaverse_array,@md,@env).songsheet
      rescue: SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
        #file closed in songsheet
      end
    end
    private
    class Songsheet
      def initialize(data,md,dir)
        @data,@md,@env=data,md,dir
      end
      def songsheet
        begin
          SiSU_XML_SAX::Source::Scroll.new(@data,@md).songsheet
          SiSU_XML_SAX::Source::Tidy.new(@md,@env).xml if @md.cmd =~/[VM]/i # test wellformedness, comment out when not in use
          SiSU_Rexml::Rexml.new(@md,@md.fn[:sax]).xml if @md.cmd =~/M/ # test rexml parsing, comment out when not in use #debug
        rescue: SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
        ensure
        end
      end
    end
    class Scroll
      require SiSU_lib + '/common_text'
      require SiSU_lib + '/css'
      include SiSU_text_utils
      @@dp,@@env=nil,nil
      @@xml=Hash.new
      @@xml[:body],@@xml[:open],@@xml[:close],@@xml[:head]=Array.new,Array.new,Array.new,Array.new
      def initialize(data='',md=nil)
        @data,@md=data,md
        @margin=SiSU_Viz::Margin.new
        @@dp ||=SiSU_Env::Info_dir.new.digest_pattern
        @regx=/^(?:(?:<:p[bn]>\s*)?\d~(?:(\S+))?\s+)?(.+?)\s*<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>$/
        @tab="\t"
        @env=SiSU_Env::Info_dir.new(@md.fns) if @md
        @char_enc=SiSU_XML_character::Encode.new
        @sys=SiSU_Env::System_call.new
      end
      def songsheet
        Scroll.new(@data,@md).pre
        Scroll.new(@data,@md).markup
        Scroll.new(@data,@md).post
        Scroll.new(@data,@md).publish
      end
    protected
      def embedded_endntoes(para='')
        para.gsub!(/~\{(\d+)\s+(.+?)\s*<#{@@dp}>\}~/, 
          "<endnote><number>\\1</number><note>\\2</note></endnote> ")
        para.gsub!(/~\{([*+]+)\s+(.+?)\s*<#{@@dp}>\}~/, 
          "<endnote><asterisk>\\1</asterisk><note>\\2</note></endnote> ")
      end
      def extract_endnotes(para='')
        notes=para.scan(/~\{([\d*+]+\s+.+?)\s*<#{@@dp}>\}~/)
        notes.each do |e| 
          s=e.to_s
          util=SiSU_text_utils::Paragraph.new(s,70)
          wrap=util.line_wrap
          wrap.gsub!(/^(\d+)\s+(.+?)\s*\Z/m, <<WOK
#{@tab*1}<endnote notenumber="\\1">
#{@tab*2}<number>\\1</number>
#{@tab*2}<note>
#{@tab*3}\\2
#{@tab*2}</note>
#{@tab*1}</endnote>
WOK
) 
          wrap.gsub!(/^([*+]+)\s+(.+?)\s*\Z/m, <<WOK
#{@tab*1}<endnote asterisk="\\1.length">
#{@tab*2}<asterisk>\\1</asterisk>
#{@tab*2}<note>
#{@tab*3}\\2
#{@tab*2}</note>
#{@tab*1}</endnote>
WOK
) 
          @endnotes << wrap
        end
      end
      def xml_head_dc(meta='',verse='')
        verse.gsub!(/<br(?: \/)?>/,'')
        verse.gsub!(/ & /,' and ')
        @@xml[:head] <<<<WOK
#{@tab}<dc class="#{meta}">
#{@tab*2}#{verse}
#{@tab}</dc>
WOK
      end
      def xml_head(meta='',verse='')
        @@xml[:head] <<<<WOK
#{@tab}<#{meta}>
#{@tab*2}#{verse}
#{@tab}</#{meta}>
WOK
      end
      def xml_sc(md='')
        sc=if @md.sc_info
          <<WOK
    <source_control>
      <sc class="sourcefile">
        #{@md.sc_filename}
      </sc>
      <sc class="number">
        #{@md.sc_number}
      </sc>
      <sc class="date">
        #{@md.sc_date}
      </sc>
    </source_control>
WOK
        else ''
        end
        @@xml[:sc]=sc   #<<<<WOK
#WOK
      end
      def xml_structure_ee(para='',lv='',ocn='',hname='') #embedded endnotes
        lv=lv.to_i
        n=lv - 1
        n3=lv + 2
        lv=nil if lv == 0
        embedded_endnotes(para)
        if para[@regx]
          paragraph="#{para[@regx,2]}"
          util=SiSU_text_utils::Paragraph.new(paragraph,70)
          wrapped=util.line_wrap
        end
        @@xml[:body] << "#{@tab*0}<object>" << "\n" if para[@regx] 
        @@xml[:body] << "#{@tab*1}<ocn>#{para[@regx,3]}</ocn>" << "\n" if para[@regx,3]
        @@xml[:body] << if lv: %{#{@tab*1}<text class="h#{lv}">#{wrapped}</text>\n} << "\n" 
        else                   %{#{@tab*1}<text class="norm">#{wrapped}</text>\n} # main text, contents, body KEEP
        end
        #@@xml[:body] << "#{@tab*1}<text>#{wrapped}</text>\n" # main text, contents, body KEEP
        ##@@xml[:body] << "#{@tab*1}<text>#{para[@regx,2]}</text>\n" if para[@regx,2] # old unwrapped main text, contents, body KEEP
        @@xml[:body] << "#{@tab*0}</object>" << "\n" if para[@regx]
      end
      def xml_structure(para='',lv='',ocn='',hname='') #extracted endnotes
        lv=lv.to_i
        n=lv - 1
        n3=lv + 2
        lv=nil if lv == 0
        extract_endnotes(para)
        #puts @endnotes
        para.gsub!(/~\{([\d*+]+)\s+(?:.+?)\s*<#{@@dp}>\}~/,"<en>\\1</en>")
        if para[@regx]
          paragraph="#{para[@regx,2]}"
          util=SiSU_text_utils::Paragraph.new(paragraph,70)
          wrapped=util.line_wrap
        end
        @@xml[:body] << if para[@regx,3]: %{#{@tab*0}<object id="#{para[@regx,3]}">} << "\n" 
        else                              "#{@tab*0}<object>" << "\n" if para[@regx] 
        end
        #@@xml[:body] << "#{@tab*1}<heading>#{lv}</heading>" << "\n" if lv
        @@xml[:body] << "#{@tab*1}<ocn>#{para[@regx,3]}</ocn>" << "\n" if para[@regx,3]
        @@xml[:body] << if lv: %{#{@tab*1}<text class="h#{lv}">\n#{@tab*2}#{wrapped}\n#{@tab*1}</text>\n} << "\n" 
        else                   %{#{@tab*1}<text class="norm">\n#{@tab*2}#{wrapped}\n#{@tab*1}</text>\n} # main text, contents, body KEEP
        end
        #@@xml[:body] << "#{@tab*1}<text>\n#{@tab*2}#{wrapped}\n#{@tab*1}</text>\n" # main text, contents, body KEEP
        @@xml[:body] << "#{@endnotes}" if @endnotes # main text, endnotes KEEP
        ##@@xml[:body] << "#{@tab*1}<text>#{para[@regx,2]}</text>\n" if para[@regx,2] # old unwrapped main text, contents, body KEEP
        @@xml[:body] << "#{@tab*0}</object>" << "\n" if para[@regx]
        @endnotes=Array.new
      end
      def group_structure(para='',ocn='')
        para.gsub!(/<:group(?:-end)?>/,'')
        para.strip!
        @@xml[:body] << %{#{@tab*0}<object id="#{ocn}">} << "\n"
        @@xml[:body] << %{#{@tab*1}<ocn>#{ocn}</ocn>} << "\n"
        @@xml[:body] << %{#{@tab*1}<text class="group">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*2}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*1}</text>\n}
        @@xml[:body] << "#{@tab*0}</object>" << "\n"
      end
      def poem_structure(para='',ocn='')
        para.gsub!(/<:poem(?:-end)?>/,'')
        para.strip!
        @@xml[:body] << %{#{@tab*0}<object id="#{ocn}">} << "\n"
        @@xml[:body] << %{#{@tab*1}<ocn>#{ocn}</ocn>} << "\n"
        @@xml[:body] << %{#{@tab*1}<text class="poem">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*2}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*1}</text>\n}
        @@xml[:body] << "#{@tab*0}</object>" << "\n"
      end
      def code_structure(para='',ocn='')
        para.gsub!(/<:code(?:-end)?>/,'')
        para.strip!
        @@xml[:body] << %{#{@tab*0}<object id="#{ocn}">} << "\n"
        @@xml[:body] << %{#{@tab*1}<ocn>#{ocn}</ocn>} << "\n"
        @@xml[:body] << %{#{@tab*1}<text class="code">#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*2}#{para}#{@tab*1}\n}
        @@xml[:body] << %{#{@tab*1}</text>\n}
        @@xml[:body] << "#{@tab*0}</object>" << "\n"
      end
      def table_structure(table='',ocn='') #tables
        @@xml[:body] << %{#{@tab*0}<object id="#{ocn}">} << "\n" #if para[@regx] 
        @@xml[:body] << %{#{@tab*1}#{table}\n#{@tab*1}\n} # unless lv  # main text, contents, body KEEP
        @@xml[:body] << "#{@tab*0}</object>" << "\n" #if para[@regx]
        @endnotes=Array.new
      end
      def tidywords(wordlist)
        wordlist.each do |x|
          x.gsub!(/&/,'&amp;') unless x =~/&\S+;/
        end
      end
      def markup
        data=@data
        dir=SiSU_Env::Info_dir.new(@md.fns)
        xml_sc(@md)
        @endnotes,@level,@cont,@copen,@xml_contents_close=Array.new,Array.new,Array.new,Array.new,Array.new
        @rcdc=false
        (0..6).each { |x| @cont[x]=@level[x]=false } 
        (4..6).each { |x| @xml_contents_close[x]='' } 
        data.each do |para|
          #para.gsub!(/<br(\s*\/)?>/,'')
          para.gsub!(/<:pb>\s*/,'')
          para.gsub!(/<[-~]#>/,'')
          para.gsub!(/<0;\w\d+;[um]\d+><#{@@dp}:#{@@dp}>/,'')
          para.gsub!(/\{(\S+?\.(?:png|jpg)) .+?\}(?:(?:https?|ftp):\/\/\S+|image)/, 
            "<image.path>#{dir.url_images_local}\/\\1</image.path>")
          para.gsub!(/&nbsp;/,' ') #clean
          wordlist=para.scan(/\S+|\n/) #\n needed for tables, check though added 2005w17
          para=tidywords(wordlist).join(' ').strip
          @char_enc.utf8(para) if @sys.locale =~/utf-?8/i #% utf8
          if para =~/^0~(\S+)\s+(.+?)$/ # for headers
            dc=SiSU_scan::Header_scan.new(@md,para).dublin
            if dc: xml_head_dc(dc[0],dc[1])
	    end
          end
          @rcdc=true if @rcdc==false and (para =~/~metadata/ or para =~/1~\s+Document Information/)
          if para !~/(^0~|<ENDNOTES>|<EOF>)/ 
            if para =~/.+?<~\d+;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>.*/
              paranum=para[@regx,3]  #/.+?<~(\d+?)>.*/.match(para)[1]
              @p_num=SiSU_XML_format::Paragraph_number.new(@md,paranum)
            end
            @sto=SiSU_text_parts::Split_text_object.new(@md,para).lev_segname_para_ocn
            ### problem in scroll, it appears tables are getting paragraph numbers
            unless @rcdc
              m=/<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
              if para =~m
                format_scroll=SiSU_XML_format::Format_scroll.new(@md,@sto.text) if @sto.format =~/i[12]|null/
                case @sto.format
                when /^(1)~(?:(\S+))?/
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body1
                when /^(2)~(?:(\S+))?/
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body2
                when /^(3)~(?:(\S+))?/
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body3
                when /^(4)~(\S+)/ # work on see Split_text_object
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body4
                when /^(5)~(?:(\S+))?/
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body5
                when /^(6)~(?:(\S+))?/
                  xml_structure(para,$1,@sto.ocn,$2)
                  para=@sto.lev_para_ocn.heading_body6
                #when /^(i1)$/i
                #  #format_scroll.gsubBody
                #  #para=@sto[:lev_para_ocn].scrIndent1
                #when /^(i2)$/i
                #  format_scroll.gsubBody
                #  para=@sto[:lev_para_ocn].scrIndent2
                #when /^(center)$/i
                #  para.gsub!(/(.+)/,
                #    %{<center>(\\1)</center>})
                #  para=@sto[:lev_para_ocn].scrPara
                #when /^(b|bold)$/i
                #  para.gsub!(/(.+)/,
                #    %{<b>(\\1)</b>})
                #  para=@sto[:lev_para_ocn].scrPara
                #when /null/ # see whether u can improve
                #    if (para !~/#{@margin.txt_0}|#{@margin.txt_1}|#{@margin.txt_2}/)
                #      #format_scroll.gsubBody
                #      #para=@sto[:lev_para_ocn].scrPara
                #    end
                else
                  matched=/<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>$/mi.match(para)
                  stamp,ocn=matched[0],matched[1]
                  #ocn=/<~(\d+);(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>$/mi.match(para)[1]
                  if para =~ /<:poem>/
                    para.gsub!(/#{stamp}/,'')
                    poem_structure(para,ocn)
                  elsif para =~ /<:group>/
                    para.gsub!(/#{stamp}/,'')
                    group_structure(para,ocn)
                  elsif para =~ /<:code>/
                    para.gsub!(/</,'&lt;')
                    para.gsub!(/>/,'&gt;')
                    para.gsub!(/#{stamp}/,'')
                    code_structure(para,ocn)
                  elsif para =~/<!Th?.+/i # tables come as single block #work area 2005w13
                    table=SiSU_Tables::Table_xml.new(para,ocn)
                    para=table.table_split
                    table_structure(para)
                  else xml_structure(para,nil,nil,nil)
                  end
                  #@@xml[:body] << "#{@tab*6}<object>" << "\n" if para[@regx]
                  #@@xml[:body] << "#{@tab*7}<ocn>#{para[@regx,3]}</ocn>" << "\n" if para[@regx,3]
                  #@@xml[:body] << "#{@tab*7}<text>#{para[@regx,2]}</text>\n" if para[@regx,2] # main text, contents, body KEEP
                  #@@xml[:body] << "#{@tab*6}</object>" << "\n" if para[@regx]
                end
              elsif para =~/(Note|Endnotes?)/ and para !~/<~\d+;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
                #format_scroll=MonoSiSU.new('<br /><a name="notes">Note</a>')
                #para=format_scroll.boldPara
              elsif para =~/(MetaData)/ and para =~/<~(\d+);[m]\d+;\w\d+><#{@@dp}:#{@@dp}>/ #debug 2003w46 add rc info
                format_scroll=Format_scroll.new(@md,'<br /><a name="metadata">MetaData</a>')
                para=format_scroll.bold_para
              elsif para =~/(Owner Details)/ and para !~/<~\d+;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/
                format_scroll=Format_scroll.new(@md,'<br /><a name="owner.details">Owner Details</a>')
                @@xml[:owner_details]=format_scroll.bold_para
                para=''
              elsif para =~/(.*)<!#!>(.*)/i
                one,two=$1,$2
                format_text=Format_text_object.new(one,two)
                para=format_text.seg_no_paranum
              end
              para='' if (para =~/<a name="n\d+">/ and para =~/^(-\{{2}~\d+|<!e[:_]\d+!>)/) # -endnote
              if para =~/.*<:#>.*$/
                para=case para
                when /<:i1>/
                  format_text=Format_text_object.new(para,'')
                  format_text.scr_inden_ocn_e_no_paranum
                when /<:i2>/
                  format_text=Format_text_object.new(para,'')
                  format_text.scr_inden_ocn_e_no_paranum
                end
              end
              if para !~/#{@margin.txt_0}|#{@margin.txt_1}|#{@margin.txt_2}/
                # i don't get the condition for no paranum
              end
              if para =~/<:center>/i
                one,two=/(.*)<:center>(.*)/i.match(para)[1,2]
                format_text=Format_text_object.new(one,two)
                para=format_text.center
              end
            else #
            end
            para.gsub!(/<:\S+?>/,'')
            para.gsub!(/<!.+!>/i,'') ## Clean Prepared Text #bugwatch reinstate
          end
        end
        6.downto(4) do |x|
          y=x - 1; v=x - 3
          @@xml[:body] << "#{@tab*5}</content>\n#{@tab*y}</contents#{v}>\n" if @level[x] == true
        end
        3.downto(1) do |x|
          y=x - 1
          @@xml[:body] << "#{@tab*y}</heading#{x}>\n" if @level[x] == true
        end
        #6.downto(1) { |x| y=x - 1; @@xml[:body] << "#{@tab*y}</level #{x}>\n" if @level[x] == true } 
      end
      def pre
        rdf=SiSU_XML_tags::RDF.new(@md)
        dir=SiSU_Env::Info_dir.new
        #<?xml version="1.0"?>
        #<?xml version="1.0" encoding="UTF-8" standalone="no"?>
        #<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>
        #<?xml version="1.0" encoding="ISO-8859-1" standalone="yes"?>
        #<?xml version="1.0" encoding="UTF-8" standalone="no"?>
        #<?xml version="1.0" encoding="UTF-16" standalone="no"?>
        @@xml[:head]=Array.new #added
        @@xml[:body]=Array.new #added
        css=SiSU_Env::CSS_select.new(@md).xml_sax
        encoding=if @sys.locale =~/utf-?8/i: '<?xml version="1.0" encoding="UTF-8" standalone="no"?>'
        else                                 '<?xml version="1.0" encoding="ISO-8859-1" standalone="no"?>'
        end
        @@xml[:open] =<<WOK
#{encoding}
<?xml-stylesheet type="text/css" href="../#{dir.style}/#{css}"?>
#{rdf.comment_xml}
<document>
WOK
        @@xml[:head] << "<head>\n"
        @@xml[:body] << "<body>\n"
      end
      def post
        @@xml[:head] << @@xml[:sc]
        @@xml[:head] << "</head>\n"
        @@xml[:body] << "</body>\n"
        @@xml[:close] = "</document>\n"
      end
      def publish
        content=Array.new
        data=@data
        content << @@xml[:open]
        content << @@xml[:head]
        content << @@xml[:body]
        content << @@xml[:metadata]
        content << @@xml[:owner_details] if @md.stmp =~/\w\w/
        content << @@xml[:tail]
        content << @@xml[:close]
        Output.new(content.to_s,@md).xml
        @@xml=Hash.new # check whether should be nil
      end
    end
    class Output
      include SiSU_Param
      include SiSU_Env
      def initialize(data,md)
        @data,@md=data,md
      end
      def xml
        @sisu=Array.new
        @data.each do |para|
          para.gsub!(/<:\S+?>/,'')
          para.gsub!(/<!.+?!>/,'')
          para="#{para}\n" unless para.empty?
          @sisu << para
        end
        new_file_data=@sisu.to_s
        @sisu=new_file_data.scan(/.+/)
        filename_plaintext=SiSU_Env::SiSU_file.new(@md).mkdir
        filename_xml=SiSU_Env::SiSU_file.new(@md,@md.fn[:sax]).mkfile
        @sisu.each {|para| filename_xml.puts para}
        filename_xml.close
      end
    end
    class Tidy
      def initialize(md,dir)
        @md,@env=md,dir
        @prog=SiSU_Env::Info_program.new 
      end
      def xml
        if @prog.tidy !=false #note values can be other than true
          if @md.cmd =~/[VM]/
            tell=SiSU_Screen::Ansi.new(@md.cmd,'invert','Using XML Tidy','check document structure')
            tell.colorize unless @md.cmd =~/q/
            tell.grey_open unless @md.cmd =~/q/
            tidyfile='/dev/null' #don't want one or screen output, check for alternative flags
            tidy =SiSU_Env::System_call.new("#{@env.data_o}/#{@md.fnb}/#{@md.fn[:sax]}",tidyfile)
            tidy.well_formed?
            tell.p_off unless @md.cmd =~/q/
          end
        end
      end
      def xmlexp #possibly use to decide whether to call rexml
      end
    end
  end
end
__END__

