=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: LaTeX formatting template, unicode utf-8 version, used for pdf

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_TeX_Pdf
  @@table_pg_break_counter=1
  require SiSU_lib + '/param'
  include SiSU_Param
  include SiSU_Viz
  #require "#{SiSU_lib}/character_encoding"
  #include SiSU_character_encode
  class Use_TeX
    attr_accessor :url,:txt,:date
    def initialize(md,orientation='')
      @url,@txt,@date=SiSU_Viz::Url.new,SiSU_Viz::Txt.new,SiSU_Env::Info_date.new
      @md,@orientation=md,orientation
      @copymark='{\\begin{footnotesize}\\raisebox{1ex}{\\copyright}\\end{footnotesize}}'
    end
    def skip
      "\n\\vspace*{\\smallskipamount} \n"
    end
    def paraskip_normal
      '\setlength{\parskip}{1ex plus0.5ex minus0.2ex}'
    end
    def paraskip_small
      '\setlength{\parskip}{0.5ex plus0.2ex minus0.1ex}'
    end
    def skip_small
      #"\\smallskip{}"
    end
    def skip_small_vspace
      "\n\\vspace*{\\smallskipamount} \n"
    end
    def skip_small_footnote
      #"\n\\smallskip{}\n"
    end
    def skip_medium
      "\n\\medskip{}\n\n"
    end
    def skip_dummy
      "\n"
    end
    def header
      "\\lhead[ ]{ }\n" +
      "\\chead[ \\fancyplain{} \\bfseries \\footnotesize  \\leftmark ]{ \\fancyplain{} \\bfseries \\footnotesize \\rightmark }\n" +
      "\\rhead[ ]{ }\n"
    end
    def footer
      base_prog_txt=if @md.base_program
        case @md.base_program
        when /kdissert/i: " \\\\ \\href{http://freehackers.org/~tnagy/kdissert/}{Kdissert}"
        else ''
        end
      else ''
      end
      "\\lfoot[\\textrm{\\thepage}]{\\tiny \\href{#{@url.sisu}}{#{@txt.signature}}#{base_prog_txt}}\n" +
      "\\cfoot[\\href{#{@url.home}}{#{@url.txt}}]{\\href{#{@url.home}}{#{@url.txt}}}\n" +
      "\\rfoot[\\tiny \\href{#{@url.sisu}}{#{@txt.signature}}]{\\textrm{\\thepage}}\n"
    end
    def site
      "\\href{#{@url.home}}{#{@url.txt}}"
    end
    def sitename                                   #owners site, eg freeculture, free.for.all, gutenberg etc.
      "\\href{#{@url.home}}{#{@txt.home}}"
    end
    def owner_chapter
      "Contact Details for Original Promulgating Authority"
    end
    #BOOK standard dimensions - 229x156
    def newpage
      case @orientation
      when /landscape/ # using longtable latex package
<<WOK
\\clearpage
WOK
      when /portrait/
<<WOK
\\newpage
WOK
      end
    end
    def sisu_rights
      v=SiSU_Env::Info_version.new.get_version
      base_prog_txt=if @md.base_program
        case @md.base_program
        when /kdissert/i: "\n\\\\ This document prepared using \\href{http://freehackers.org/~tnagy/kdissert/}{Kdissert \\ http://freehackers.org/~tnagy/kdissert/ } \\\\ Kdissert is Document Mapping software by Thomas Nagy" 
        else ''
        end
      else ''
      end
<<WOK
\\\\ ~
{\\begin{footnotesize}#{base_prog_txt}
\\\\ Generated by \\href{http://www.jus.uio.no/sisu}{SiSU \\ www.jus.uio.no/sisu } \\begin{tiny}[ #{v[:project]} #{v[:version]} of #{v[:date_stamp]} ]\\end{tiny} 
\\\\ using SiSU: object citation numbering, markup, meta-markup, and system \\\\ #@copymark Ralph Amissah 1997, current #{@date.year}, All Rights Reserved.
\\\\ SiSU is released under \\href{http://www.fsf.org/licenses/gpl.html}{GPL 2 } or later, \\href{http://www.fsf.org/licenses/gpl.html}{http://www.fsf.org/licenses/gpl.html}.
{\\end{footnotesize}
\\\\ 
WOK
    end
    def doc_sc_info_footnote_full
      #base_prog_txt=if @md.base_program
      #  case @md.base_program
      #  when /kdissert/i: "\n\\\\ This document prepared using \\href{http://freehackers.org/~tnagy/kdissert/}{Kdissert \\ http://freehackers.org/~tnagy/kdissert/ }" 
      #  else ''
      #  end
      #else ''
      #end
<<WOK
\\footnote{%\nGenerated by \\href{http://www.jus.uio.no/sisu}{SiSU \\ www.jus.uio.no/sisu }\\ \\newline \\scriptsize{Document version information: \\emph{sourcefile} \\uline{#{@md.fnstex}}; \\emph{version} \\uline{#{@md.sc_number}}; \\emph{date} \\uline{#{@md.sc_date}}; \\emph{time} \\uline{#{@md.sc_time}}}}
WOK
    end
    def doc_sc_info_footnote_brief
      " \\footnote{%\nGenerated by \\href{http://www.jus.uio.no/sisu}{SiSU \\ www.jus.uio.no/sisu }\\\n}"
    end
    def doc_sc_info
      v=SiSU_Env::Info_version.new.get_version
<<WOK
\\\\
{\\begin{footnotesize} 
Document version information: \\\\
\\emph{sourcefile} \\uline{#{@md.fnstex}}; \\emph{version} \\uline{#{@md.sc_number}}; \\emph{date} \\uline{#{@md.sc_date}}; \\emph{time} \\uline{#{@md.sc_time}} \\\\
Generated by \\href{http://www.jus.uio.no/sisu}{SiSU www.jus.uio.no/sisu }\\- version information: \\\\ 
\\uline{ #{v[:project]} #{v[:version]} of #{v[:date_stamp]}}

\\end{footnotesize}}&
WOK
    end
    def doc_no_sc_info
      v=SiSU_Env::Info_version.new.get_version
<<WOK
\\\\
{\\begin{small} 
Document information: \\\\
\\emph{sourcefile} \\uline{#{@md.fnstex}} \\\\
Generated by \\href{http://www.jus.uio.no/sisu}{SiSU www.jus.uio.no/sisu }\\- version information: \\\\ 
\\uline{ #{v[:project]} #{v[:version]} of #{v[:date_stamp]}}

\\end{tiny}}&
WOK
    end
    def endnotes #not used should be inserted before MetaData section which preceeds doc_tail, but is "part of document"
<<WOK
\\subsection*{Endnotes}
\\addcontentsline{toc}{section}{Endnotes}
\\
\\listofendnotes
WOK
    end
    def doc_tail
      dir=SiSU_Env::Info_dir.new(@md.fns)
      base_html="#{dir.output_links_path[:url_root]}/#{@md.fnb}"
      v=SiSU_Env::Info_version.new.get_version
      sisu_ico=if FileTest.file?("#{dir.image_source_tex}/sisu.png")
        "\\includegraphics*[width=60pt]{#{dir.image_source_tex}/sisu.png}"
      else
        tell=SiSU_Screen::Ansi.new(@md.cmd,'WARNING - image directory or image(s) missing:', %{"#{dir.image_source_tex}"} )
        tell.warn unless @md.cmd =~/q/
        " SiSU "
      end
      url=@md.fnb.gsub(/(?:\\)*([$&~%_#}{^])/,"\\\\\\1")
<<WOK
\\subsection*{Information on this document copy and an unofficial List of Some web related information and sources}
\\addcontentsline{toc}{section}{Information on this document copy and an unofficial List of Some web related information and sources}
\\\\
\"Support Open Standards and Open Sources for the Information Technology Infrastructure\" RA\\subsubsection*{Information on this document copy #{site}}
\\addcontentsline{toc}{subsection}{Information on this document copy}
{\\begin{footnotesizel} 
\\\\ Generated by \\href{http://www.jus.uio.no/sisu/}{SiSU} found at \\href{http://www.jus.uio.no/sisu/}{www.jus.uio.no/sisu} \\begin{tiny}[ #{v[:project]} #{v[:version]} #{v[:date_stamp]} ]\\end{tiny} (using SiSU: object citation numbering, markup, meta-markup, and system) #@copymark Ralph Amissah 1997, current #{@date.year}, All Rights Reserved.
\\\\ SiSU is released under \\href{http://www.fsf.org/licenses/gpl.html}{GPL 2 } or later (\\href{http://www.fsf.org/licenses/gpl.html}{www.fsf.org/licenses/gpl.html}). {\\end{footnotesize} 
{\\begin{small} 
\\\\ W3 since October 3 1993 \\href{http://www.jus.uio.no/sisu/}{#{sisu_ico}}SiSU 1997, current #{@date.year}. \\\\ #{sitename} presentations at \\begin{bfseries}#{site}\\end{bfseries} \\\\ \\\\ #{@md.title} \\textbf{pdf} versions can be found at:  \\\\
{\\end{small} 
\\begin{scriptsize}\\href{#{@url.root_http}/#{url}/#{@md.fn[:pdf_p]}}{#{@url.root_http}/#{url}/#{@md.fn[:pdf_p]}}\\end{scriptsize}  \\\\
\\begin{scriptsize}\\href{#{@url.root_http}/#{url}/#{@md.fn[:pdf_l]}}{#{@url.root_http}/#{url}/#{@md.fn[:pdf_l]}}\\end{scriptsize}  \\\\
\\\\\n#{@md.title} \\textbf{html} versions may be found at: \\\\
\\begin{scriptsize}\\href{#{@url.root_http}/#{url}/#{@md.fn[:toc]}}{#{@url.root_http}/#{url}/#{@md.fn[:toc]}}\\end{scriptsize} or \\\\
\\begin{scriptsize}\\href{#{@url.root_http}/#{url}/#{@md.fn[:doc]}}{#{@url.root_http}/#{url}/#{@md.fn[:doc]}}\\end{scriptsize}
\\\\
\\\\
\\href{#{@url.root_http}/#{url}/#{@md.fn[:manifest]}}{SiSU Manifest} of document output and metadata may be found at: \\\\
\\begin{scriptsize}\\href{#{@url.root_http}/#{url}/#{@md.fn[:manifest]}}{#{@url.root_http}/#{url}/#{@md.fnl[:pre]}sisu\\_manifest#{@md.fnl[:mid]}.html#{@md.fnl[:post]}}\\end{scriptsize}
\\\\
\\\\
 #{sitename} found at: \\begin{bfseries}#{site}\\end{bfseries}\\subsubsection*{Links that may be of interest at #{@txt.home} and elsewhere:}
\\addcontentsline{toc}{subsection}{Links that may be of interest}
WOK
    end
    def mail_tail #not retested, the old mail_tail is commented out and appended to this program
      dir=SiSU_Env::Info_dir.new(@md.fns)
<<WOK
\\subsection*{Mail sender details}
\\addcontentsline{toc}{subsection}{Mail sender details}
\\\\
Mail from: ralph@amissah.com\\\\
44 20 8789 3452\\\\
44 77 9669 4448
\\\\
 \"Support Open Standards and Open Sources for the Information Technology Infrastructure\" RA
\\subsubsection*{Information on this document copy #{site}\\copyright}
Presentations' look and feel generated by \\href{http://www.jus.uio.no/sisu/}{SiSU Scribe} \\href{http://www.jus.uio.no/sisu/}{http://www.jus.uio.no/sisu/} programmed in Ruby on Debian/Gnu/Linux by \\copyright Ralph Amissah, W3 since October 3 1993 \\href{http://www.jus.uio.no/sisu/}{\\includegraphics*[width=35pt]{#{dir.image_source_tex}/sisu.png}}for #{sitename}. SiSU Scribe (sisu information structuring unit) produces Electronic Documents, i.e. it generates structured output for use in a number of file formats, including the pdf file produced here.
WOK
    end
  end
  class Format_text_object
    require 'iconv'
    attr_accessor :string,:string1,:string,:orientation,:url,:dir,:tex
    @@sys=SiSU_Env::System_call.new
    @@tex_backslash="\\\\"
    @@tex_3='\\\\\\{\\\\\\{' #?? debug crazy
    @@tex_1='\\\\\\~' #?? debug crazy
    @@tex_2='\\\\\\{\\\\\\{' #?? debug crazy
    @@tex_pattern_margin_number="\\\\begin\\\{tiny\\\}~\\\\end\\\{tiny\\\}\\\{\\\\marginpar.+?\s+"
    @@tableheader=0
    @@sys=SiSU_Env::System_call.new
    @@flag_code=false
    @@dp=nil
    def initialize(md,string,string1=nil)
      @md,@string,@string1=md,string,string1
      if defined? @md.image and @md.image =~/center/
        @center_begin,@center_end="\\begin{center}","\\end{center}"
      else @center_begin,@center_end='',''
      end
      @start_table=''
      @@dp ||=SiSU_Env::Info_dir.new.digest_pattern
      @s=SiSU_Viz::TeX.new
    end
    def longtable_landscape
      @end_table="\\end{longtable}"
      @row_break='\\\\\\'
      if @string[/<!Th?¡\s+c(\d+);(.+?)!\\~(\d+;\w\d+;\w\d+)>/i]
        no_of_cols,cols_width,ocn=$1,$2,$3
        @@tableheader=1 if @string =~/<!Th/i
        @w=cols_width.split(/;\s*/)
        @@number_of_cols=no_of_cols
        @colW=Array.new
        @colW << '{'
        @w.each  do |x|
          x.strip!
          x=(x.to_i/100.0 * 12)
          col_w=x.to_s # x.gsub(/.+/,'l\|') #unless x.nil?
          @colW << "lp{#{col_w}cm}" if col_w
        end
        @colW << '}'
        @colW=@colW.join
        @start_table="<~#{ocn}>\n\\setlength{\\LTleft}{0pt}\n\\setlength{\\LTright}{\\fill}\n" +
          "\\begin{longtable}#@colW\n"
        @string.gsub!(/<!Th?¡\s+c\d+?;.+!\\~\d+;\w\d+;\w\d+>/,@start_table)
      end
      if @string =~/<!TZ!>/
        @string.gsub!(/<!TZ!>/," #@end_table")
      end
      @string.gsub!(/<!¡/,'')
      if @@tableheader == 1
        if @string =~/¡\d+?¡(.+?)(?:¡|!)/
          tablefoot=@string[/\<!f(.+?)!\>/,1]
          @string.gsub!(/\<!f(.+?)!\>/,'')
          @string.gsub!(/¡\d+?¡(.+?)(?:¡|!)/,"{\\begin{tiny} {\\bfseries \\1}\\end{tiny}}&")
          @string.gsub!(/&>\s*$/," #@row_break \\hline\\endhead #@row_break")
          @string="#@string \\multicolumn{#{@@number_of_cols}}{l}{\\tiny #{tablefoot}} \\\\ \\hline\n\\endfoot\n\\hline\n" if tablefoot
          @@tableheader,@@number_of_cols=0,0
        end
      else
        if @string =~/¡\d+?¡(.+?)(?:¡|!)/
          @string.gsub!(/¡\d+?¡(.+?)(?:¡|!)/,"\\begin{tiny}\\1\\end{tiny}&")
          @string.gsub!(/&>\s*$/," #@row_break")
        end
      end
      @string="<~#{ocn}>" + @string
    end
    def longtable_portrait
      @end_table="\\end{longtable}"
      @row_break='\\\\\\'
      if @string[/<!Th?¡\s+c(\d+);(.+?)!\\~(\d+;\w\d+;\w\d+)>/i]
        no_of_cols,cols_width,ocn=$1,$2,$3
        @@tableheader=1 if @string =~/<!Th/i
        @w=cols_width.split(/;\s*/)
        @@number_of_cols=no_of_cols
        @colW=Array.new
        @colW << '{'
        @w.each  do |x|
          x.strip!
          x=(x.to_i/100.0 * 16)
          col_w=x.to_s # x.gsub(/.+/,'l\|') #unless x.nil?
          @colW << "lp{#{col_w}cm}" if col_w
        end
        @colW << '}'
        @colW=@colW.join
        @start_table="<~#{ocn}>\n\\setlength{\\LTleft}{0pt}\n\\setlength{\\LTright}{\\fill}\n" +
          "\\begin{longtable}#@colW\n"
        @string.gsub!(/<!Th?¡\s+c\d+?;.+!\\~\d+;\w\d+;\w\d+>/,"#@start_table")
      end
      if @string =~/<!TZ!>/
        @string.gsub!(/<!TZ!>/," #@end_table")
      end
      @string.gsub!(/<!¡/,'')
      if @@tableheader == 1
        if @string =~/¡\d+?¡(.+?)(?:¡|!)/
          tablefoot=@string[/\<!f(.+?)!\>/,1]
          @string.gsub!(/\<!f(.+?)!\>/,'')
          @string.gsub!(/¡\d+?¡(.+?)(?:¡|!)/,"{\\begin{tiny} {\\bfseries \\1}\\end{tiny}}&")
          @string.gsub!(/&>\s*$/," #@row_break \\hline\\endhead #@row_break")
          @string="#@string \\multicolumn{#{@@number_of_cols}}{l}{\\tiny #{tablefoot}} \\\\ \\hline\n\\endfoot\n\\hline\n" if tablefoot
          @@tableheader,@@number_of_cols=0,0
        end
      else
        if @string =~/¡\d+?¡(.+?)(?:¡|!)/
          @string.gsub!(/¡\d+?¡(.+?)(?:¡|!)/,"\\begin{tiny}\\1\\end{tiny}&")
          @string.gsub!(/&>\s*$/," #@row_break")
        end
      end
      @string="<~#{ocn}>" + @string
    end
    def scopedtable
      # some features related to headers have been incorporated in longtable
      # that are not included yet here, so until synced is broken on some
      # input files, work needs to be done if is to work as before
      @end_table="\\end{tabular}"
      @row_break='\\\\\\\\'
      @break_page="#@row_break\n#@row_break \n"
      if @string[/<!Th?¡\s+c(\d+);(.+?)!>/i]
        no_of_cols, cols_width=$1,$2
        @w=cols_width.split(/;\s*/)
        @colW=Array.new
        @w.each  do |x|
          col_w=((x.to_i*12)/100.00).to_s #unless x.nil?
          @colW << "p{#{col_w}cm}" if col_w
        end
        @start_table="\\begin{tabular}{#@colW}\n"
        @string.gsub!(/<!Th?¡\s+c\d+?;.+!>/,"#@start_table}")
      end
      if @string =~/<!TZ!>/
        @string.gsub!(/<!TZ!>/,"#@end_table")
        @@table_pg_break_counter=1
      end
      if @string =~/<!¡/
        if @@table_pg_break_counter == 28 # taken from 34 ideal for portrait to 28 which suits landscape
          @string = "\n\n#@end_table \n#@break_page#@start_table\n"
          @@table_pg_break_counter=1
        else
          @string.gsub!(/<!¡/,'')
          @@table_pg_break_counter+=1
          tablefoot=@string[/\<!f(.+?)!\>/,1]
          @string.gsub!(/\<!f(.+?)!\>/,'')
        end
      end
      if @string =~/¡\d+?¡(.+?)(?:¡|!)/
      @string.gsub!(/¡\d+?¡(.+?)(?:¡|!)/,"\\begin{tiny}\\1\\end{tiny}&")
      @string.gsub!(/&>\s*$/,"#@row_break")
      end
      @string
    end
    def special_characters_1(para)
      # ~ ^ $ & % _ { }                                                          #LaTeX special characters - KEEP list
      #p @@utf_8.list
      #@string=Iconv.conv('ISO-8859-1', 'UTF-8', @string)
      word=@string.scan(/\S+|\n/) #unless line =~/^(?:0~\S|%+\s)/
      para_array=Array.new
      if word
        word.each do |w| # _ - / # | : ! ^ ~
          unless para =~/^(?:0~|%+ |<!Th?¡ )/m
            w.gsub!(/~/i,'<=tilde>') unless w=~/^[1-6]~|~\{|\}~|^\^~\s|~\^|\*~\S+|~#|\{t~|<~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+>/
            w.gsub!(/&#(?:126|152);/i,'<=tilde>') #126 usual
            w.gsub!(/\\?\||&#124;/i,'<=pipe>') #unless w=~/<~\d+;(?:[ohmu]|[0-6]:)\d+;\w\d+>/ # | SiSU not really special sisu character but done, also LaTeX
          end
          para_array << w
        end
        para=para_array.join(' ')
        @string=para.strip
      end
      @string.gsub!(/<~\d+;(?:\w|[0-6]:)\d+;[umdv]\d+><#{@@dp}:#{@@dp}>/i,'')
      @string.gsub!(/.+?<-#>/i,'')
      @string.gsub!(/<EOF>/i,'')
      @string.gsub!(/<ENDNOTES?>/i,'')
      #problem sequence ->
      @string.gsub!(/&(?:nbsp);/i,'<=hardspace>')                                 # < SiSU special character also LaTeX
      @string.gsub!(/&(?:lt|#060);/i,'<=lt>')                                     # < SiSU special character also LaTeX
      @string.gsub!(/&(?:gt|#062);/i,'<=gt>')                                     # > SiSU special character also LaTeX
      @string.gsub!(/&#123;/i,'<=curlyopen>')                                     # { SiSU special character also LaTeX
      @string.gsub!(/&#125;/i,'<=curlyclose>')                                    # } SiSU special character also LaTeX
      @string.gsub!(/&#(?:126|152);/i,'<=tilde>')                                 # ~ SiSU special character also LaTeX
      @string.gsub!(/&#035;/i,'\#')                                               # # SiSU special character also LaTeX
      @string.gsub!(/&#033;/i,'!')                                                # ! SiSU not really special sisu character but done, also LaTeX
      @string.gsub!(/&#042;/i,'*')                                                # * should you wish to escape astrisk e.g. describing \*{bold}*
      @string.gsub!(/&#045;/i,'-')                                                # - SiSU special character also LaTeX
      @string.gsub!(/&#043;/i,'+')                                                # + SiSU special character also LaTeX
      @string.gsub!(/&#044;/i,',')                                                # + SiSU special character also LaTeX
      @string.gsub!(/&#038;/i,'<=amp>') #unless @string=~/<:code>/                   # / SiSU special character also LaTeX
      @string.gsub!(/&#047;/i,'<=slash>')                                         # / SiSU special character also LaTeX
      @string.gsub!(/&#092;/i,'<=backslash>')                                     # \ SiSU special character also LaTeX
      @string.gsub!(/&#095;/i,'<=underscore>')                                    # _ SiSU special character also LaTeX
      @string.gsub!(/&#124;/i,'|')                                                # | SiSU not really special sisu character but done, also LaTeX
      @string.gsub!(/&#058;/i,':')                                                # : SiSU not really special sisu character but done, also LaTeX
      @string.gsub!(/&#094;/i,'<=caret>')                                         # ^ SiSU not really special sisu character but done, also LaTeX
      @string.gsub!(/\#/,'<=hash>')
      ##watch placement, problem sequence ^
      @string.gsub!(/<sup><font face=symbol>&atild;<\/font><\/sup>/i,' ')
      @string.gsub!(/<:pb>/i,'\newpage')
      @string.gsub!(/<:pn>/i,'\clearpage')
      @string.gsub!(/\\copy(right|mark)?/,'<=copymark>') # ok problem with superscript
    end
    def special_characters_2(para)
      @string.gsub!(/&#156;/,'\oe ')
      @string.gsub!(/\$/,'\$')
      @string.gsub!(/\#/,'\#')
      @string.gsub!(/\%/,'\%')
      @string.gsub!(/\~/,'\~') #revist, should not be necessary to mark remaining tildes
      if @string !~/^\s*<:image|\}:image\s/
        @string.gsub!(/_/,'\_')
      end
      @string.gsub!(/\{/,'\{')
      @string.gsub!(/\}/,'\}')
      @string.gsub!(/&nbsp;/i,'~') # ~ character for hardspace
      # sequence important must appear after removal of { and }
      @string.gsub!(/&\S+?;/i,'') #hmmm
      # sequence imortant place before removal of &
      if @string=~/<:code>/:        @@flag_code=true
      elsif @string=~/<:code-end>/: @@flag_code=false
      end
      if @@flag_code: @string.gsub!(/&/,'{\\\&}')
      else @string.gsub!(/(\s+&\s+)/,' and ')
      end
      @string.gsub!(/§/i,'\S') #latex: space between next character not preserved? #@string.gsub!(/§ /i, '\S ')
      @string.gsub!(/£/i,'\pounds')
      @string.gsub!(/&\S+?;/i,' ')
      @string.gsub!(/<a href=".+?">/i,' ')
      @string.gsub!(/<\/a>/i,' ')
      if @string !~/^\s*<:image|\}image/                                           #watch carefully could introduce breaks ! removed \}http changed 0.1.1-4 200501
        if @string =~/(?:https?|ftp):\/\/\S+?<\/\S>/i                                        #problems where have font attribute eg </u> (change substitution sequence?)
          @string.gsub!(/[^\}]((?:https?|ftp):\/\/\S+?)(<\/\S>)/i," \\begin{scriptsize}\\href{\\1}{ \\1 } \\end{scriptsize}\\2")
        else # regular urls !! http:// href
          if para=~/(?:https?|ftp):\/\/\S+?[,.]? /
            @string.gsub!(/(?:^|[^\}])((?:https?|ftp):\/\/\S+?)([,.])? /i," \\begin{scriptsize}\\href{\\1}{ \\1}\\end{scriptsize}\\2 ")
          else @string.gsub!(/(?:^|[^\}])((?:https?|ftp):\/\/\S+)/i," \\begin{scriptsize}\\href{ \\1 }{\\1} \\end{scriptsize}") #should not be necessary, not checked
          end
        end
      else #@string =~/\\~\\\{.+?\\\}\\~/ # \\~\\{1
        #@string.gsub!(/(?:\n)?(http:\/\/\S+)/i, " \\begin{scriptsize}\\href{\\1}{\\1} \\end{scriptsize}") #bug...
      end
      @string.gsub!(/<:ee>/i,'')
      @string.gsub!(/<!>/i,' ')
      #proposed change, insert, but may be redundant
      @string.gsub!(/ \/><:i[12]>(.+?)(?:\}~|<br)/i," \\begin{ParagraphIndent}{0.01\\columnwidth}\\1\\end{ParagraphIndent} ") # footnote indents, problems if match exists in ordinary paragraphs? check! Work Area 200501 a bit tricky as must be able to match multiple times, and to clean remainder
      @string.gsub!(/<(br|p)>|<\/\s*(br|p)>|<(br|p)\s*\/>/i," #{@@tex_backslash*2} ") # Work Area
      @string.gsub!(/<b>(.+?)<\/b>/i,"\\begin{bfseries}\\1 \\end{bfseries}")
      @string.gsub!(/<em>(.+?)<\/em>/i,"\\begin{bfseries}\\1 \\end{bfseries}")
      @string.gsub!(/<(bold|strong)>(.+?)<\/(bold|strong)>/i,"\\begin{bfseries}\\1 \\end{bfseries}")
      @string.gsub!(/<h\d+>(.+?)<\/h\d+>/i,"\\begin{bfseries}\\1 \\end{bfseries}")
      @string.gsub!(/<i>(.+?)<\/i>/i,"\\emph{\\1}")
      @string.gsub!(/<italic>(.+?)<\/italic>/i,"\\emph{\\1}")
      @string.gsub!(/<u>(.+?)<\/u>/i,"\\uline{\\1}") # ulem
      @string.gsub!(/<ins>(.+?)<\/ins>/i,"\\uline{\\1}") # ulem
      @string.gsub!(/<del>(.+?)<\/del>/i,"\\sout{\\1}") # ulem
      @string.gsub!(/<sub>(.+?)<\/sub>/i,"\$_{\\textrm{\\1}}\$")
      @string.gsub!(/<sup>(.+?)<\/sup>/i,"\$^{\\textrm{\\1}}\$")
      unless @@flag_code
        @string.gsub!(/"(.+?)"/i,"``\\1''")  # quotations open & close " need condition exclude for code
        @string.gsub!(/\s+"/i," ``")         # open "
        @string.gsub!(/^([1-6-]#{@@tex_1}(?:\S+)?|<.+?>)?\s*"/i,'\1``')       # open "
        @string.gsub!(/"(\s|\.|,|:|;)/i,"''\\1")       # close "
        @string.gsub!(/"([1-6-]#{@@tex_1}(?:\S+)?|<.+?>)?\s*$/i,"''\\1")       # close "
        @string.gsub!(/"(\.|,)/i,"''")       # close "
        @string.gsub!(/\s+'/i," `")          # open '
        @string.gsub!(/^([1-6-]#{@@tex_1}(?:\S+)?|<.+?>)?\s*'/i,"\\1`")         # open '
      end
      @string.gsub!(/^(<:i[12]>)?\s*\\_\*\s*/,'\\1 \begin{math} \bullet \end{math}~~') #bullets - added 2004w17 watch \\_
      @string.gsub!(/(<font.*?>|<\/font>)/i,'')
      @string.gsub!(/\s*<sup>(\S+?)<\/sup>/i,"^\\1")
      @string.gsub!(/(<sup>|<\/sup>)/i,'')
      @string
    end
    def special_characters_3(para)
      @string.gsub!(/<br(\s*[^\/][^>])/i,'\1') # clean up, incredibly messy :-( footnote indents, problems if match exists in ordinary paragraphs? check! Work Area 200501 a bit tricky as must be able to match multiple times, and to clean remainder
      @string.gsub!(/([^<][^b][^r]\s+)\/>/i,'\1') # clean up, incredibly messy :-( footnote indents, problems if match exists in ordinary paragraphs? check! Work Area 200501 a bit tricky as must be able to match multiple times, and to clean remainder
      #problem sequence (another kludge) ->
      @string.gsub!(/<=lt>/,'{\UseTextSymbol{OML}{<}}')
      @string.gsub!(/<=gt>/,'{\UseTextSymbol{OML}{>}}')
      #@string.gsub!(/<=lt>/,'\<')
      #@string.gsub!(/<=gt>/,'\>')
      @string.gsub!(/<=curlyopen>/,'\{') #not currently operational
      @string.gsub!(/<=curlyclose>/,'\}')
      @string.gsub!(/<=underscore>/,'\_')
      @string.gsub!(/<=tilde>/,'\~~')
      @string.gsub!(/<=pipe>/,'{\textbar}')
      @string.gsub!(/<=caret>/,'{\^{~}}')
      #@string.gsub!(/<=caret>/,'\^{}')
      @string.gsub!(/<=exclaim>/,'\Verbatim{!}')
      @string.gsub!(/<=hash>/,'{\#}')
      #@string.gsub!(/<=hash>/,'{\UseTextSymbol{OT1}{#}}')
      #@string.gsub!(/<=slash>/,'{\slash}')
      @string.gsub!(/<=hardspace>/,'{~}') #changed ... 2005
      @string.gsub!(/<=amp>/,'{\\\&}') #changed ... 2005
      #@string.gsub!(/<=amp>/,'{\UseTextSymbol{OT1}{&}}')
      @string.gsub!(/<=slash>/,'{/}')
      @string.gsub!(/<=backslash>/,'{\textbackslash}')
      #@string.gsub!(/<=asterisk>/,'*')
      #@string.gsub!(/<=exclaim>/,'!')
      #@string.gsub!(/<=asterisk>/,'{\ast}')
      #@string.gsub!(/<=copymark>/,"^{\\copyright} ") # watch has been problematic
      #copymark='{\\begin{small}\\raisebox{1ex}{\\copyright}\\end{small}} '
      @string.gsub!(/<=copymark>\s*(.+)?\s+(<\\~\d+;\w(?:[0-6]:)?\d+;\w\d+><#{@@dp}:#{@@dp}>)/,"^\\copyright \\textnormal{\\1} \\2") # watch likely to be problematic
      @string
    end
    def special_characters_unsafe_1(para) #depreciated, make obsolete
      # some substitutions are sequence sensitive, rearrange with care.
      @string.gsub!(/\\backslash (copyright|clearpage|newpage)/,"\\\\\\1")  #kludge bad solution, find out where tail is sent through specChar !
    end
    def special_characters_unsafe_2(para)
    end
    def special_characters_unsafe_3(para)
    end
    def special_characters                                                       #special characters - some substitutions are sequence sensitive, rearrange with care.
      special_characters_1(@string)
      special_characters_unsafe_1(@string)
      special_characters_2(@string)
      special_characters_3(@string)
    end
    def special_characters_safe                                                  #special characters - some substitutions are sequence sensitive, rearrange with care.
      special_characters_1(@string)
      special_characters_2(@string)
      #special_characters_3(@string)
    end
    def heading_major(para,lev)
      title=@md.title
      para.strip! if para
      para.gsub!(/(?:\\begin\{bfseries\}|\\begin\{itshape\})(.+?)(?:\\end\{bfseries\}|\\end\{itshape\})/m,'\1')
      cont_ln=para.dup
      cont_ln.gsub!(/#{@@tex_pattern_margin_number}/,'')
      cont_ln.gsub!(/#{lev}#{@@tex_1}\s+/,'')
      if para =~/\\footnote/i #and para =~/^[1-6]#{@@tex_1}/ # removing footnotes from headings!
        cont_ln.gsub!(/\s*\\footnote\[\d+\]\{%\n .+? \}\s*/,' ') 
        cont_ln.gsub!(/\s*\\Footnote[A]\{[*+]+\}\{%\n .+? \}\s*/,' ') 
      end
      para.gsub!(/(#{@md.lev}.*)\n?$/im,"\\part*{\\1}
\\addcontentsline{toc}{section}{#{cont_ln}}
\\markboth{#{title}}\n") if (para !~/#{lev}#{@@tex_1}/)
      para.gsub!(/^#{lev}#{@@tex_1}\s*(.*)\n?$/im,
        "\\part*{\\1}
\\addcontentsline{toc}{section}{#{cont_ln}}
\\markboth{#{title}}\n") 
    end
    def level1
      heading_major(@string,1)
    end
    def level2
      heading_major(@string,2)
    end
    def level3
      heading_major(@string,3)
    end
    def level4
      @string.strip! if @string
      @string.gsub!(/(?:\\begin\{bfseries\}|\\begin\{itshape\})(.+?)(?:\\end\{bfseries\}|\\end\{itshape\})/m,'\1')
      cont_ln=@string.dup
      cont_ln.gsub!(/#{@@tex_pattern_margin_number}/,'')
      cont_ln.gsub!(/#{@@tex_backslash*2}/,"#{@@tex_backslash*4}") # added w42
      cont_ln.gsub!(/4#{@@tex_1}\S+\s+/,'')
      cont_ln.gsub!(/\\footnote\[\d+\]\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      cont_ln.gsub!(/\\Footnote[A]\{[*+]+\}\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      title=@md.title
      @string.gsub!(/#{@md.lv4}\s+(#{@md.lv4})/im,'\1')
      if @string =~/4#{@@tex_1}endnotes|<:4-endnotes>/  
        # watch exclusion removes endnotes marker from pdf 2003w03
        @string.gsub!(/.+/im,'')
      end
      if @string =~/\\footnote/i #and para =~/^[1-6]#{@@tex_1}/ # removing footnotes from headings!
        cont_ln.gsub!(/\s*\\footnote\[\d+\]\{%\n .+? \}\s*/,' ') 
        cont_ln.gsub!(/\s*\\Footnote[A]\{[*+]+\}\{%\n .+? \}\s*/,' ') 
      end
      if @string !~/4#{@@tex_1}/
        @string.gsub!(/(#{@md.lv4}.*)\n?$/im,"\\subsubsection*{\\1}
\\addcontentsline{toc}{subsection}{#{cont_ln}}
\\markright{#{title}}") 
      else
        @string.gsub!(/^\s*4#{@@tex_1}\S+\s*(.*)?\n?$/im,"\\subsubsection*{\\1}
\\addcontentsline{toc}{subsection}{#{cont_ln}}
\\markright{#{title}}") 
      end
      @string.gsub!(/#{@md.lv4}\s*(.marginpar)/im,'\1')
    end
    def level5
      # there is a problem here with creation of headers does not do what you would want it to header starts with a * and is not in bold work on \\@string*, same for next section 2002w46
      @string.strip! if @string
      @string.gsub!(/(?:\\begin\{bfseries\}|\\begin\{itshape\})(.+?)(?:\\end\{bfseries\}|\\end\{itshape\})/m,'\1')
      cont_ln=@string.dup
      cont_ln.gsub!(/#{@@tex_pattern_margin_number}/,'')
      cont_ln.gsub!(/5#{@@tex_1}(?:\S+)?\s+/,'')
      cont_ln.gsub!(/\\footnote\[\d+\]\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      cont_ln.gsub!(/\\Footnote[A]\{[*+]+\}\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      cont_ln.gsub!(/\\\&/,' and ') #revisit: tmp bugfix 200507, substitutes & with 'and' in toc, needed e.g. for AT&T, see ffa
      @string.gsub!(/#{@md.lv5}\s+(#{@md.lv5})/im,'\1')
      if @string =~/\\footnote/i #and para =~/^[1-6]#{@@tex_1}/ # removing footnotes from headings!
        cont_ln.gsub!(/\s*\\footnote\[\d+\]\{%\n .+? \}\s*/,' ') 
        cont_ln.gsub!(/\s*\\Footnote[A]\{[*+]+\}\{%\n .+? \}\s*/,' ') 
      end
      if @string !~/5#{@@tex_1}/
        @string.gsub!(/(#{@md.lv5}.*?)\n?$/im,"\\subsubsection*{\\1}
\\addcontentsline{toc}{subsubsection}{#{cont_ln} \\\\
}")
      else
        @string.gsub!(/^\s*5#{@@tex_1}(?:\S+)?\s*(.*)?\n?$/im,"\\subsubsection*{\\1}
\\addcontentsline{toc}{subsubsection}{#{cont_ln} \\\\
}")
      end
      @string.gsub!(/#{@md.lv5}\s*(.marginpar)/im,'\1')
    end
    def level6
      # there is a problem here with creation of headers does not do what you would want it to header starts with a * and is not in bold work on \\sub@string*, same for previous section 2002w46
      @string.strip! if @string
      @string.gsub!(/(?:\\begin\{bfseries\}|\\begin\{itshape\})(.+?)(?:\\end\{bfseries\}|\\end\{itshape\})/m,'\1')
      cont_ln=@string.dup
      cont_ln.gsub!(/#{@@tex_pattern_margin_number}/,'')
      cont_ln.gsub!(/6#{@@tex_1}(?:\S+)?\s+/,'')
      cont_ln.gsub!(/\\footnote\[\d+\]\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      cont_ln.gsub!(/\\Footnote[A]\{[*+]+\}\{%.+?\\end\{scriptsize\}\s*\}/m,'') #arbitrary bugfix, revisit should not be necessary, eg. wta.1994 2004w22
      @string.gsub!(/#{@md.lv6}\s+(#{@md.lv6})/im,'\1')
      if @string =~/\\footnote/i #and para =~/^[1-6]#{@@tex_1}/ # removing footnotes from headings!
        cont_ln.gsub!(/\s*\\footnote\[\d+\]\{%\n .+? \}\s*/,' ') 
        cont_ln.gsub!(/\s*\\Footnote[A]\{[*+]+\}\{%\n .+? \}\s*/,' ') 
      end
      @string.gsub!(/(#{@md.lv6}.*)\n?$/im,
        "\\subsubsection*{\\1}") if (@string !~/6#{@@tex_1}/)
      @string.gsub!(/^\s*6#{@@tex_1}(?:\S+)?\s*(.*)?\n?$/im,
        "\\subsubsection*{\\1}")
      @string.gsub!(/#{@md.lv6}\s*(.marginpar)/im,'\1')
      #end BUGWATCH
    end
    def indent1
      @string.gsub!(/<:i1>(.*)/im,
        "\\begin{ParagraphIndent}{0.01\\columnwidth} \\1
\\end{ParagraphIndent}
")
    end
    def indent2
      @string.gsub!(/<:i2>(.*)/im,
        "\\begin{ParagraphIndent}{0.02\\columnwidth} \\1
\\end{ParagraphIndent}
") 
    end
    def symbol_graphic
      dir=SiSU_Env::Info_dir.new(@md.fns)
      image='c_' + /<:=\s*(\S+?)\s*>/im.match(@string).captures.join + '.png' #watch
      if FileTest.file?("#{dir.image_source_tex}/#{image}")
        @string.gsub!(/<:=\s*(\S+?)\s*>/i,
          "\\includegraphics*[width=11pt]{#{dir.image_source_tex}/c_\\1.png}")
      else
        tell=SiSU_Screen::Ansi.new(@md.cmd,"ERROR - image:", %{"#{image}" missing}, "search path: #{dir.image_source_tex}")
        tell.error2 unless @md.cmd =~/q/
        @string.gsub!(/\{\S+\.(png|jpg).+?\}(?:https?|ftp):\/\/\S+/, '') # fragile match operator\\ fragile ! 
      end
    end
    def image
      dir=SiSU_Env::Info_dir.new(@md.fns)
      image,m=/<:image\s+(\S+)\s+.+?width=``(\d+)''.+?>/im.match(@string).captures
      width=m[1] || '100'
      width=width.to_i*0.4
      image_source=if @md.fns =~/\._?sst$/ and FileTest.file?("#{dir.image_source_local_tex}/#{image}")
        dir.image_source_local_tex
      elsif @md.fns =~/\.-ss[tm]$/ and FileTest.file?("#{dir.image_source_remote_tex}/#{image}")
        dir.image_source_remote_tex
      elsif FileTest.file?("#{dir.image_source_tex}/#{image}")
        dir.image_source_tex
      else
        tell=SiSU_Screen::Ansi.new(@md.cmd,"ERROR - image:", %{"#{image}" missing}, "search locations: #{dir.image_source_local_tex}, #{dir.image_source_remote_tex} and #{dir.image_source_tex}")
        tell.error2 unless @md.cmd =~/q/
        nil
      end
      if image_source
        @string.gsub!(/<:image\s+((?:https?|ftp)\S+)\s+(\S+)\s+.+\s+?>/i,
          @center_begin + "\\href{\\1}{\\includegraphics*[width=#{width}pt]{#{image_source}/\\2}}" + @center_end )
        @string.gsub!(/<:image\s+(\S+)\s+.+\s+?>/i,
          @center_begin + "\\includegraphics*[width=#{width}pt]{#{image_source}/\\1}" + @center_end )          
      else
        @string.gsub!(/<:image\s+(\S+)\s+.+\s+?>/i,'\1}')
      end
    end
    def png #fc missing image check
      dir=SiSU_Env::Info_dir.new(@md.fns)
      # messy clean up
      z=@string[/\\\{(\S.+?)\}(?:image|png)/,1].strip if @string =~ /\\\{\S.+?\}(?:image|png)/ # match operator for z \\ fragile !
      if z #debug 2004w14
        image=z[/(\S+?\.(?:png|jpg)\b)/im]
        image.gsub!(/\\/,'')
        width=if z =~ /\d+x\d*/
          w=(z[/(\d+)x\d*/,1]).to_i
          w*0.8
        else '100' #revisit, is bug for small images/icons
        end
        width='380' if width.to_i > 380
        c=z[/``(.+?)''/im]
      end
      hsp="\n{\\color{mywhite} .}&~\n" # ~ character for hardspace
      caption="{\\\\\\\ \n\\begin{scriptsize}#{hsp*3}#{c}\\end{scriptsize}&}" if c
      #caption="{\\\\\\\ \n\\begin{scriptsize}#{hsp*3}#{c[1]}\\end{scriptsize}&}" if c
      image_source=if @md.fns =~/\._?sst$/ and FileTest.file?("#{dir.image_source_local_tex}/#{image}")
        dir.image_source_local_tex
      elsif @md.fns =~/\.-ss[tm]$/ and FileTest.file?("#{dir.image_source_remote_tex}/#{image}")
        dir.image_source_remote_tex
      elsif FileTest.file?("#{dir.image_source_tex}/#{image}")
        dir.image_source_tex
      else
        unless image.nil? or image.length < 2
          tell=SiSU_Screen::Ansi.new(@md.cmd,"ERROR - image:", %{"#{image}" missing}, "search locations: #{dir.image_source_local_tex}, #{dir.image_source_remote_tex} and #{dir.image_source_tex}")
          tell.error2 unless @md.cmd =~/q/
        end
        nil
      end
      if image_source
        @string.gsub!(/\\\{\S+\.(png|jpg).+?\}(image|png)/, # fragile match operator\\ fragile ! 
          "#@center_begin\n\\includegraphics*[width=#{width}pt]{#{image_source}/#{image}}#{caption}#@center_end")
      else
        @string.gsub!(/\\\{\S+\.(png|jpg).+?\}(image|png)/,'') # fragile match operator\\ fragile ! 
      end
    end
    def http_word_mode(orientation='')
      # clean up ! - work area, testing
      dir=SiSU_Env::Info_dir.new(@md.fns)
      @words=Array.new
      @string.each do |word|
        @words << if word=~/\{.+?\}(?:https?|ftp):\S+/
          if word =~/\\\{(.+?)\\\}((?:https?|ftp)\S+?)([.,](?:\s|$))/
            r=%r/\\\{(.+?)\\?\}((?:https?|ftp):\S+?)(?:[.,](?:\s|$)|(?:\s|$))/
            d=/\\\{.+?\\?\}(?:https?|ftp):\S+([.,](?:\s|$))/.match(word).captures.to_s
          else
            r=%r/\\\{(.+?)\\?\}((?:https?|ftp):\S+)/
            d=''
          end
          z,url=r.match(word).captures if word =~r 
          url=url.strip
          if word =~/\{\s*\S+\.?(?:png|jpg)/ and word=~/\s+\d+x\d+\s+/
            image,x,y=z.scan(/\S+/)
            image.gsub!(/\\/,'')
            width=200
            width=z[/(\d+)x\d*/,1] ||='200' #watch
            dm=SiSU_Viz::TeX.new(@md.papersize).dimensions
            width=if orientation =~/portrait/ #value is not currently passed
              width=if width.to_i > dm.portrait.img_px: dm.portrait.img_px
              else                                      width
              end
            else
              width=if width.to_i > dm.landscape.img_px: dm.landscape.img_px
              else                                       width
              end
            end
            c=z[/``(.+?)''/im,1]
            hsp="\n{\\color{mywhite} .}&~\n" # ~ character for hardspace
            caption="{\\\\\ \n\\begin{scriptsize}#{hsp*3}#{c}\\end{scriptsize}&}" if c
          elsif word =~/\{\s*(\S+\.?\.(?:png|jpg))/
            tell=SiSU_Screen::Ansi.new(@md.cmd,%{document built without image: "#{$1}" as image dimensions not provided (& librmagick-ruby is not installed)?\n})
            tell.print_grey #unless @opt.cmd =~/q/
          end
          ins=if image #most images fc etc. #% clean up !
            out=if @md.fns =~/\._?sst$/ and FileTest.file?("#{dir.image_source_local_tex}/#{image}")
              @center_begin +          
              "\\\n\\href{#{url}}" + #not satisfactory: \\ added to ^line to mimic reference file output
              "{\\includegraphics*[width=#{width}pt]" +
              "{#{dir.image_source_local_tex}/#{image}}}" +
              "#{caption}" +
              @center_end if word =~ /(\{[a-zA-Z0-9_\\]+\.(?:png|jpg).+?\}(?:https?|ftp):\/\/\S+)/
            elsif @md.fns =~/\.-ss[tm]$/ and FileTest.file?("#{dir.image_source_remote_tex}/#{image}")
              @center_begin +          
              "\\\n\\href{#{url}}" + #not satisfactory: \\ added to ^line to mimic reference file output
              "{\\includegraphics*[width=#{width}pt]" +
              "{#{dir.image_source_remote_tex}/#{image}}}"  +
              "#{caption}" +
              @center_end if word =~ /(\{[a-zA-Z0-9_\\]+\.(?:png|jpg).+?\}(?:https?|ftp):\/\/\S+)/
            elsif FileTest.file?("#{dir.image_source_tex}/#{image}")
              @center_begin +          
              "\\\n\\href{#{url}}\n" + #not satisfactory: \\ added to ^line to mimic reference file output, mirror above ... not tested
              "{\\includegraphics*[width=#{width}pt]" +
              "{#{dir.image_source_tex}/#{image}}}" +
              "#{caption}" +
              @center_end if word =~/(\{[a-zA-Z0-9_\\]+\.(?:png|jpg).+?\}(?:https?|ftp):\/\/\S+)/
            else
              tell=SiSU_Screen::Ansi.new(@md.cmd,"ERROR - image:", %{"#{image}" missing}, "search locations: #{dir.image_source_local_tex}, #{dir.image_source_remote_tex} and #{dir.image_source_tex}")
              tell.error2 unless @md.cmd =~/q/
              '' if word =~ /\{\S+\.(png|jpg).+?\}(?:https?|ftp):\/\/\S+/ 
            end
          else
            link=z.strip #[/(.+?)\\/im,1]
            word="\\href{#{url}}{#{link}}#{d}" if word =~/\\\{.+?\\\}(?:https?|ftp):\/\/\S+/
          end
        else word
        end
      end
      @words.join
    end
    def http(orientation) 
      wm=@string.dup.scan(/\\\{.+?\\\}(?:(?:https?|ftp):\S+|image)|\w+\s*|./m) #first match of interest others passed through
      @string=SiSU_TeX_Pdf::Format_text_object.new(@md,wm).http_word_mode(orientation)
    end
    def language
      @lang=if @md.dc_language[:code]
        case @md.dc_language[:code]
        when 'en': 'english'
        when 'us': 'USenglish'
        when 'fr': 'french'
        when 'de': 'ngerman'
        when 'it': 'italian'
        when 'es': 'spanish'
        when 'pt': 'portuges'
        when 'br': 'brazilian'
        when 'se': 'swedish'
        when 'dk': 'danish'
        when 'fi': 'finnish'
        when 'no': 'norske,nynorsk'
        when 'is': 'icelandic'
        when 'nl': 'dutch'
        when 'ee': 'estonian'
        when 'hu': 'magyar'
        when 'pl': 'polish'
        when 'ro': 'romanian'
        when 'ru': 'russian'
        when 'gr': 'greek'
        when 'ua': 'ukrainian'
        when 'tr': 'turkish'
        when 'si': 'slovene'
        when 'sk': 'slovak'
        when 'hr': 'croatian'
        when 'cz': 'czech'
        when 'bg': 'bulgarian'
        else       'english'
        end
      else         'english'
      end
    end
    def title
      @string=Format_text_object.new(@md,@string).special_characters_safe
      if @string1
        @string1=Format_text_object.new(@md,@string1).special_characters_safe
        @string1.gsub!(/\$/,"\\$")
        "\n\\title{#@string#{@@tex_backslash*2} \\textbf{\\normalsize #@string1}\\normalsize}"
      else "\n\\title{#@string}"
      end
    end
    def title_landscape
      title
    end
    def title_portrait
      title
    end
    def tex_head_lang #babel
      language
      #@md.dc_language[:name]
      lang=if @lang =~/^(?:en)$/: @lang
      else "#@lang,english"
      end
      #"\\usepackage[#{lang}]{babel}"
    end
    def tex_head_encode
      case @md.file_encoding
      when /utf-?8/i
      <<WOK 
\\usepackage{babel}
\\usepackage{ucs}
\\usepackage[utf8x]{inputenc}
WOK
      when /iso-?8859/i                                                         #% iso8859
      <<WOK 
\\usepackage[latin1]{inputenc}
WOK
      else
      <<WOK 
\\usepackage[latin1]{inputenc}
WOK
      end
    end
    def tex_head_info
      generator="Generated by: #{@md.sisu_version[:project]} #{@md.sisu_version[:version]} of #{@md.sisu_version[:date_stamp]} (#{@md.sisu_version[:date]})"  if @md.sisu_version[:version]
      lastdone="Last Generated on: #{Time.now}"
      rubyv="Ruby version: #{@md.ruby_version}"
      <<WOK
%% Sisu Sabaki (Linux & Ruby - \"better ways\") LaTeX output
%% #{generator}
%% #{rubyv}
%% LaTeX output
%% #{lastdone}
%% SiSU http://www.jus.uio.no/sisu
WOK
    end
    def tex_head_paper_a4_portrait
      <<WOK
#{tex_head_info}
\\documentclass[12pt,a4paper,#{tex_head_lang},titlepage]{scrartcl}                         %with titlepage
%\\documentclass[12pt,a4paper,english,english]{article}                                  %without titlepage
\\setlength{\\textheight}{#{@s.a4.portrait.h}mm}    \\setlength{\\textwidth}{#{@s.a4.portrait.w}mm}
\\setlength{\\oddsidemargin}{0mm}   \\setlength{\\evensidemargin}{0mm}
\\setlength{\\topmargin}{-12pt}     \\setlength{\\headheight}{12pt}
\\setlength{\\headsep}{35pt}
\\setlength{\\marginparsep}{4mm}
\\setlength{\\marginparwidth}{8mm}
WOK
    end
    def tex_head_paper_us_letter_portrait        #refine text dimensions & placement
      <<WOK
#{tex_head_info}
\\documentclass[12pt,letterpaper,#{tex_head_lang},titlepage]{scrartcl}                     %with titlepage
\\setlength{\\textheight}{#{@s.letter.portrait.h}mm}    \\setlength{\\textwidth}{#{@s.letter.portrait.w}mm}
\\setlength{\\oddsidemargin}{0mm}   \\setlength{\\evensidemargin}{0mm}
\\setlength{\\topmargin}{-12pt}     \\setlength{\\headheight}{12pt}
\\setlength{\\headsep}{35pt}
\\setlength{\\marginparsep}{4mm}
\\setlength{\\marginparwidth}{8mm}
WOK
    end
    def tex_head_paper_us_legal_portrait         #refine text dimensions & placement
      <<WOK
#{tex_head_info}
\\documentclass[12pt,legalpaper,#{tex_head_lang},titlepage]{scrartcl}                      %with titlepage
\\setlength{\\textheight}{#{@s.legal.portrait.h}mm}    \\setlength{\\textwidth}{#{@s.legal.portrait.w}mm}
\\setlength{\\oddsidemargin}{0mm}   \\setlength{\\evensidemargin}{0mm}
\\setlength{\\topmargin}{-12pt}     \\setlength{\\headheight}{12pt}
\\setlength{\\headsep}{35pt}
\\setlength{\\marginparsep}{4mm}
\\setlength{\\marginparwidth}{8mm}
WOK
    end
    def tex_head_paper_book_b5_portrait          #refine text dimensions & placement
      <<WOK
#{tex_head_info}
\\documentclass[11pt,b5paper,#{tex_head_lang},titlepage]{scrartcl}                         %with titlepage
\\setlength{\\textheight}{#{@s.b5.portrait.h}mm}    \\setlength{\\textwidth}{#{@s.b5.portrait.w}mm}
\\setlength{\\oddsidemargin}{0mm}   \\setlength{\\evensidemargin}{0mm}
\\setlength{\\topmargin}{-12pt}     \\setlength{\\headheight}{12pt}
\\setlength{\\headsep}{35pt}
\\setlength{\\marginparsep}{4mm}
\\setlength{\\marginparwidth}{8mm}
WOK
    end
    def tex_head_paper_book_a5_portrait          #refine text dimensions & placement
      <<WOK
#{tex_head_info}
\\documentclass[11pt,a5paper,#{tex_head_lang},titlepage]{scrartcl}                         %with titlepage
\\setlength{\\textheight}{#{@s.a5.portrait.h}mm}    \\setlength{\\textwidth}{#{@s.a5.portrait.w}mm}
\\setlength{\\oddsidemargin}{0mm}   \\setlength{\\evensidemargin}{0mm}
\\setlength{\\topmargin}{-12pt}     \\setlength{\\headheight}{12pt}
\\setlength{\\headsep}{35pt}
\\setlength{\\marginparsep}{4mm}
\\setlength{\\marginparwidth}{8mm}
WOK
    end
    def tex_head_paper_a4_landscape
      <<WOK
#{tex_head_info}
%\\documentclass[12pt,a4paper,english,english, landscape, twocolumn]{article}                  %without titlepage
\\documentclass[12pt,a4paper,#{tex_head_lang}, landscape, titlepage, twocolumn]{scrartcl}        %with titlepage
\\setlength{\\textheight}{#{@s.a4.landscape.h}mm}  \\setlength{\\textwidth}{#{@s.a4.landscape.w}mm}
\\setlength{\\oddsidemargin}{-8mm}  \\setlength{\\evensidemargin}{-8mm}
\\setlength{\\topmargin}{-18mm}  \\setlength{\\headheight}{12pt}
\\setlength{\\headsep}{20pt}
\\setlength{\\columnsep}{40pt}
\\setlength{\\marginparsep}{4mm}
\\setlength{\\marginparwidth}{8mm}
WOK
    end
    def tex_head_paper_us_letter_landscape       #refine text dimensions & placement
      <<WOK
#{tex_head_info}
\\documentclass[11pt,letterpaper,#{tex_head_lang}, landscape, titlepage, twocolumn]{scrartcl}    %with titlepage
\\setlength{\\textheight}{#{@s.letter.landscape.h}mm}  \\setlength{\\textwidth}{#{@s.letter.landscape.w}mm}
\\setlength{\\oddsidemargin}{-8mm}  \\setlength{\\evensidemargin}{-8mm}
\\setlength{\\topmargin}{-18mm}  \\setlength{\\headheight}{12pt}
\\setlength{\\headsep}{20pt}
\\setlength{\\columnsep}{40pt}
\\setlength{\\marginparsep}{4mm}
\\setlength{\\marginparwidth}{8mm}
WOK
    end
    def tex_head_paper_us_legal_landscape        #refine text dimensions & placement
      <<WOK
#{tex_head_info}
\\documentclass[11pt,legalpaper,#{tex_head_lang}, landscape, titlepage, twocolumn]{scrartcl}     %with titlepage
\\setlength{\\textheight}{#{@s.legal.landscape.h}mm}  \\setlength{\\textwidth}{#{@s.legal.landscape.w}mm}
\\setlength{\\oddsidemargin}{-8mm}  \\setlength{\\evensidemargin}{-8mm}
\\setlength{\\topmargin}{-18mm}  \\setlength{\\headheight}{12pt}
\\setlength{\\headsep}{20pt}
\\setlength{\\columnsep}{48pt}
\\setlength{\\marginparsep}{4mm}
\\setlength{\\marginparwidth}{8mm}
WOK
    end
    def tex_head_paper_book_b5_landscape         #refine text dimensions & placement
      <<WOK
#{tex_head_info}
\\documentclass[11pt,b5paper,#{tex_head_lang}, landscape, titlepage, twocolumn]{scrartcl}        %with titlepage
\\setlength{\\textheight}{#{@s.b5.landscape.h}mm}  \\setlength{\\textwidth}{#{@s.b5.landscape.w}mm}
\\setlength{\\oddsidemargin}{-8mm}  \\setlength{\\evensidemargin}{-8mm}
\\setlength{\\topmargin}{-18mm}  \\setlength{\\headheight}{12pt}
\\setlength{\\headsep}{20pt}
\\setlength{\\columnsep}{38pt}
\\setlength{\\marginparsep}{4mm}
\\setlength{\\marginparwidth}{8mm}
WOK
    end
    def tex_head_paper_book_a5_landscape         #refine text dimensions & placement
      <<WOK
%% Sisu Scribe (Linux & Ruby - \"better ways\") LaTeX two column landscape output
\\documentclass[10pt,a5paper,#{tex_head_lang}, landscape, titlepage, twocolumn]{scrartcl}        %with titlepage
\\setlength{\\textheight}{#{@s.a5.landscape.h}mm}  \\setlength{\\textwidth}{#{@s.a5.landscape.w}mm}
\\setlength{\\oddsidemargin}{-8mm}  \\setlength{\\evensidemargin}{-8mm}
\\setlength{\\topmargin}{-18mm}  \\setlength{\\headheight}{12pt}
\\setlength{\\headsep}{20pt}
\\setlength{\\columnsep}{35pt}
\\setlength{\\marginparsep}{4mm}
\\setlength{\\marginparwidth}{8mm}
WOK
    end
    def tex_head_paper
      case @string
      when /portrait/
        case @md.papersize
        when /a4/i:      tex_head_paper_a4_portrait           #European default, SiSU default 
        when /letter/i:  tex_head_paper_us_letter_portrait    #U.S. default
        when /legal/i:   tex_head_paper_us_legal_portrait     #U.S. alternative
        when /a5/i:      tex_head_paper_book_a5_portrait
        when /book|b5/i: tex_head_paper_book_b5_portrait      #book default - larger
        else             tex_head_paper_a4_portrait           #default currently A4
        end
      when /landscape/
        case @md.papersize
        when /a4/i:      tex_head_paper_a4_landscape          #European default, SiSU default 
        when /letter/i:  tex_head_paper_us_letter_landscape   #U.S. default
        when /legal/i:   tex_head_paper_us_legal_landscape    #U.S. alternative
        when /a5/i:      tex_head_paper_book_a5_landscape 
        when /book|b5/i: tex_head_paper_book_b5_landscape     #book default - larger
        else             tex_head_paper_a4_landscape          #default currently A4
        end
      end
    end
    def tex_head_pdftex
      color=case @string
      when /portrait/
      <<WOK
  colorlinks=true,
  urlcolor=myblack, 
  filecolor=myblack,
  linkcolor=myblack,
WOK
      when /landscape/
      <<WOK
  colorlinks=true,
  urlcolor=myblue,    % \\href{...}{...}   external url
  filecolor=mygreen,  % \\href{...}     local file
  linkcolor=myred,    % \\href{...} and \\pageref{...}
WOK
      end
      <<WOK
\\usepackage{alltt}
\\usepackage{thumbpdf}
\\usepackage[pdftex,
  #{color.strip}
  pdftitle={#@string1},
%  pdftitle={Untitled},
  pdfauthor={LM-sisu-scribe},
  pdfsubject={law},
  pdfkeywords={law},
  pageanchor=true,
  plainpages=true,
  pdfpagelabels=true,
  pagebackref,
  bookmarks=true,
  bookmarksopen=true,
  pdfmenubar=true,
  pdfpagemode=UseOutline,
  pdffitwindow=true,
  pdfwindowui=true,
  plainpages=false,
%  pdfusetitle=true,
%  pdfpagelayout=SinglePage,
%  pdfpagelayout=TwoColumnRight,
%  pdfpagelayout=TwoColumnLeft,
%  pdfstartpage=3,
  pdfstartview=FitH
]
{hyperref}
\\usepackage[usenames]{color}
\\definecolor{myblack}{rgb}{0,0,0}
\\definecolor{myred}{rgb}{0.75,0,0}
\\definecolor{mygreen}{rgb}{0,0.5,0}
\\definecolor{myblue}{rgb}{0,0,0.5}
\\definecolor{mywhite}{rgb}{1,1,1}
WOK
    end
    def tex_head_misc
      <<WOK
\\usepackage{textcomp}
\\usepackage[parfill]{parskip}
\\usepackage[normalem]{ulem}
\\usepackage{soul}
\\usepackage{longtable}
\\usepackage{graphicx}
\\makeatletter
\\parindent0pt
\\usepackage{times}
\\usepackage{amssymb}
% amssymb used for backslash
WOK
    end
    def a4_orientation
      endnotes=("\\usepackage{endnotes}" if @string =~/endnotes?/)||'' #not implemented see also def endnotes
      language
      <<WOK
#{tex_head_paper}
#{tex_head_encode}
#{tex_head_pdftex}
#{tex_head_misc}
\\setcounter{secnumdepth}{2}
\\setcounter{tocdepth}{4}
\\makeatletter
#{endnotes}
\\usepackage[multiple,marginal]{footmisc}
\\usepackage[para]{manyfoot}
\\DeclareNewFootnote{A}
%\\DeclareNewFootnote[para]{A}
\\newenvironment{ParagraphIndent}[1]%
{
\\begin{list}{}{%
\\setlength\\topsep{0pt}%
\\addtolength{\\leftmargin}{#1}
\\setlength\\parsep{0pt plus 1pt}%
}
\\item[]
}
{\\end{list}}
\\usepackage{fancyhdr}\n\\lhead{}
\\renewcommand{\\part}{\\\@startsection
{part}%
{1}%
{-2mm}%
{-\\baselineskip}%
{0.5\\baselineskip}%
{\\bfseries\\large\\scshape}}%
\\renewcommand{\\section}{\\\@startsection
{section}%
{2}%
{-2mm}%
{-\\baselineskip}%
{0.5\\baselineskip}%
{\\bfseries\\Large\\upshape}}%
\\renewcommand{\\subsection}{\\\@startsection
{subsection}%
{3}%
{-2mm}%
{-\\baselineskip}%
{0.5\\baselineskip}%
{\\bfseries\\large\\upshape}}%
\\renewcommand{\\subsubsection}{\\\@startsection
{subsubsection}%
{4}%
{-2mm}%
{-\\baselineskip}%
{0.5\\baselineskip}%
{\\bfseries\\normalsize\\upshape}}%
\\renewcommand{\\paragraph}{\\\@startsection
{paragraph}%
{5}%
{-2mm}%
{-\\baselineskip}%
{0.5\\baselineskip}%
{\\normalfont\\normalsize\\itshape}}%
\\renewcommand{\\subparagraph}{\\\@startsection
{subparagraph}%
{6}%
{-2mm}%
{-\\baselineskip}%
{0.5\\baselineskip}%
{\\normalfont\\normalsize\\itshape}}%\n
\\selectlanguage{#{language}}
WOK
    end
    def a4generic
    end
    def para_num
      paranumber_display=if $flag =~/0/: ''                                        #!ocn no object citation numbering
      else "\\begin{tiny}~\\end{tiny}{\\marginpar{\\begin{tiny}#@string1\\end{tiny}}}" #ocn object citation numbering
      end
      if @string !~/^([1-6a-z-]#{@@tex_1}(?:\S+)?|<:.+?>|#{@md.lv1}|#{@md.lv2}|#{@md.lv3}|#{@md.lv4}|#{@md.lv5}|#{@md.lv6})/
        @string.gsub!(/^\s*(.+)/m,"#{paranumber_display}\\1\n") #watch - in 1-6 is suspect
      else
        if (@string =~/^(?:[1-6a-z-]#{@@tex_1}(?:\S+)?|<:.+?>)/) #watch - in 1-6 is suspect
          @string.gsub!(/^([1-6a-z-]#{@@tex_1}(?:\S+)?|<:.+?>)\s*(.+)/m,"\\1 #{paranumber_display} \\2\n") #watch - in 1-6 is suspect
        else
          @string.gsub!(/(#{@md.lv1}.+)$/,"#{@md.lv1} #{paranumber_display}\\1\n")
          @string.gsub!(/(#{@md.lv2}.+)$/,"#{@md.lv2} #{paranumber_display}\\1\n")
          @string.gsub!(/(#{@md.lv3}.+)$/,"#{@md.lv3} #{paranumber_display}\\1\n")
          @string.gsub!(/(#{@md.lv4}.+)$/,"#{@md.lv4} #{paranumber_display}\\1\n")
          @string.gsub!(/(#{@md.lv5}.+)$/,"#{@md.lv5} #{paranumber_display}\\1\n")
          @string.gsub!(/(#{@md.lv6}.+)$/,"#{@md.lv6} #{paranumber_display}\\1\n")
        end
      end
      @string
    end
    def lev1
    end
    def lev2
    end
    def lev3
    end
    def lev4
    end
    def lev5
    end
    def lev6
    end
  end
end
__END__
