=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: rexml testing of xml

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com

 * Notes: tidy -xml sax.xml >> index.tidy
=end
module SiSU_Rexml
  # load XML file for REXML parsing
  require 'rexml/document' if FileTest.directory?("#{Config::CONFIG['rubylibdir']}/rexml") #Config::CONFIG['sitedir']
  require SiSU_lib + '/param'
  include SiSU_Param
  include SiSU_Viz
  require SiSU_lib + '/sysenv'
  include SiSU_Env
  class Rexml
    require 'rexml/document' if FileTest.directory?("#{Config::CONFIG['rubylibdir']}/rexml") #Config::CONFIG['sitedir']
    def initialize(md,fno)
      @md,@fno=md,fno
      @env=SiSU_Env::Info_dir.new(@md.fns)
      @prog=SiSU_Env::Info_program.new #(md.fns) #if md
      @fnap="#{@env.data_o}/#{@md.fnb}/#@fno" #index.xml causes problems with index.html in server config
      @e_head='/document/head'
      @e_title='/document/head/title'
      @e_object='/document/body/object'
      @e_ocn='/document/body/object/ocn'
      @e_text='/document/body/object/text'
      @e_endnote='/document/body/object/endnote'
      #@ocn='/document/body/object/ocn'
    end
    def xml
      begin
        if FileTest.file?(@fnap)
          if @prog.rexml !=false and FileTest.directory?('/usr/lib/ruby/1.8/rexml/') #note values can be other than true
            xmlfile=IO.readlines(@fnap,'').join
            @xmldoc=REXML::Document.new xmlfile
            tell=SiSU_Screen::Ansi.new(@md.cmd,'invert','REXML',"XML document #@fnap loaded")  #% tell
            tell.colorize unless @md.cmd =~/q/
            #% substantive text
            if @md.cmd =~ /v/i
              @xmldoc.elements.each(@e_head) do |e|
                tell=SiSU_Screen::Ansi.new(@md.cmd,'brown',e)
                tell.colorize unless @md.cmd =~/q/
              end
            end
          end
        else
          tell=SiSU_Screen::Ansi.new(@md.cmd,'fuschia',"File Not Found #{xmlfile}",'requested XML processing skipped')
          tell.colorize unless @md.cmd =~/q/
          exit
        end
      rescue: SiSU_Errors::Info_error.new($!,$@,@md.cmd,@md.fns).error
      ensure
      end
    end
  end
end
__END__

 misc
e.each do |element|
  element.each do |child|
    if child.is_a?(REXML::Text)
      puts "Text: #{child.to_s.inspect}"
    else
      puts "SubElement: #{child.name}"
    end
  end
end

