=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: opendocument formatting, default opendocument template

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module OD_format
  require SiSU_lib + '/param'
  include SiSU_Param
  include SiSU_Viz
  class Paragraph_number
    def initialize(paranum)
      @paranum=/(\d+)/im.match(paranum)[1]
    end
    def display
      @paranum.gsub(/(\d+)/,%{<font size="1" color="#777777">&nbsp;&nbsp;\\1</font>})
    end
    def name
      @paranum.gsub(/(\d+)/,%{<a name="\\1"></a>})
    end
    def goto
      @paranum.gsub(/(\d+)/,%{<a href="#\\1">})
    end
  end
  class Format_text_object
    @@dp=nil
    def initialize(one,two,three)
      one.gsub!(/\.(html|pdf|php)/,'') if one =~/\.\.\/\S+/
      @one,@two,@three=one,two,three
      rgx=/[1-6-]~/
      @one.gsub!(rgx,'') if @one =~rgx
      @@dp ||=SiSU_Env::Info_dir.new.digest_pattern
      rgx=/~\{\d+\s+(.+?)<#{@@dp}>\}~/
      @one.gsub!(rgx,'\1') if @one =~rgx
      @link,@linkname=one,two
      @margin=SiSU_Viz::Margin.new
      @paragraph=SiSU_Viz::Paragraph.new
      @table=SiSU_Viz::Table.new
      @banner=SiSU_Viz::Banner.new
      @url=SiSU_Viz::Url.new
      @icon=SiSU_Viz::Icon.new
      @font=SiSU_Viz::Font.new
    end
    def scr_endnote_body
      %{<endnote>#@one</endnote> }
    end
    def heading_body1
      #%{<text:h text:style-name="Heading_20_1" text:outline-level="1">#@two</text:h>}
    end
    def heading_body2
      #%{<text:h text:style-name="Heading_20_2" text:outline-level="2">#@two</text:h>}
    end
    def heading_body3
      #%{<text:h text:style-name="Heading_20_3" text:outline-level="3">#@two</text:h>}
    end
    def heading_body4
      #%{<text:h text:style-name="Heading_20_4" text:outline-level="4">#@two</text:h>}
    end
    def heading_body5
      #%{<text:h text:style-name="Heading_20_5" text:outline-level="5">#@two</text:h>}
    end
    def heading_body6
      #%{<text:h text:style-name="Heading_20_6" text:outline-level="6">#@two</text:h>}
    end
  end
  class Table
    @@tablehead=0
    @@table_counter=0 #reinitialise on new file
    @@tablefoot=Array.new #watch
    @@fns=''
    @@dp=nil
    def initialize(md,one)
      @md,@one,@parablock,@margin,@paragraph,@table=md,one,one,SiSU_Viz::Margin.new,SiSU_Viz::Paragraph.new,SiSU_Viz::Table.new
      if @md.fns != @@fns
        @@table_counter=0
        @@fns=@md.fns
        @@dp ||=SiSU_Env::Info_dir.new.digest_pattern
      end
    end
    def table_head(count,col,h=false)
      type=if h: 1
      else       2
      end
      alpha=case col.to_i
      when  1: 'A'
      when  2: 'B'
      when  3: 'C'
      when  4: 'D'
      when  5: 'E'
      when  6: 'F'
      when  7: 'G'
      when  8: 'H'
      when  9: 'I'
      when 10: 'J'
      when 11: 'K'
      when 12: 'L'
      when 13: 'M'
      when 14: 'N'
      else     'D'
      end
      %{<table:table table:name="Table#{count}" table:style-name="Table#{type}">
<table:table-column table:style-name="Table#{type}.#{alpha}" table:number-columns-repeated="#{col}"/>
}
    end
    def table_end(tablefoot='')
      %{</table:table>}
    end
    def table_row(inf,h=false)
      if h: %{<table:table-row>
<table:table-cell office:value-type="string">
<text:p text:style-name="Table_20_Heading">
}
      else  %{<table:table-row>
<table:table-cell office:value-type="string">\n<text:p text:style-name="P7">
}
      end
    end
    def table_cell(inf,h=false)
      if h: %{</text:p>
</table:table-cell>
<table:table-cell office:value-type="string">
<text:p text:style-name="Table_20_Heading">
}
      else  %{</text:p>
</table:table-cell>
<table:table-cell office:value-type="string">
<text:p text:style-name="P7">
}
      end
    end
    def table_row_close(h=false)
      %{</text:p>
</table:table-cell>
</table:table-row>
}
    end
    def table
      @parablock='' if @parablock =~/^<!$/
      @parablock.gsub!(/<~\d+;(?:\w|[0-6]:)\d+;\w\d+><#{@@dp}:#{@@dp}>/,'')
      m=@parablock[/<!f(.+?)!>/,1]
      @@tablefoot << m if m 
      @parablock.gsub!(/<!f.+?!>/,'')
      @@tablehead=1 if @parablock =~/<!Th¡/i
      @@table_counter+=1  if @parablock =~/<!Th?¡/i
      if @parablock =~/<!Th¡\s+c(\d+).+?!~\d+;\w\d+;\w\d+>/: @parablock=table_head(@@table_counter,$1,true)
      elsif @parablock =~/<!T¡\s+c(\d+).+?!~\d+;\w\d+;\w\d+>/: @parablock=table_head(@@table_counter,$1)
      end
      if @parablock =~/<!TZ!>/
        tablefoot=Array.new
        @@tablefoot.each {|x| tablefoot << ''}
        @@tablefoot=Array.new
        if @parablock =~/<!TZ!>/: @parablock=table_end
        end
      end
      if @@tablehead == 1
        if @parablock =~/¡¡/
          if @parablock =~/<!¡¡(\d+?)¡/
            @parablock.gsub!(/<!¡¡(\d+?)¡/,table_row($1,true))
          end
          if @parablock =~/¡¡(\d+?)¡/ 
            @parablock.gsub!(/¡¡(\d+?)¡/,table_cell($1,true))
          end
          if @parablock =~/!>/
            @parablock.gsub!(/!>/,table_row_close(true))
          end
          @@tablehead=0
        end
        @parablock
      else
        if @parablock =~/<!¡¡(\d+?)¡/
          @parablock.gsub!(/<!¡¡(\d+?)¡/,table_row($1))
        end
        if @parablock =~/¡¡(\d+?)¡/
          @parablock.gsub!(/¡¡(\d+?)¡/,table_cell($1))
        end
        if @parablock =~/!>/
          @parablock.gsub!(/!>/,table_row_close)
        end
        @parablock
      end
      @parablock
    end
    def table_split
      @new_content=Array.new
      @one.split(/\s*<!/).each do |parablock|
      #@one.split(/\n/).each do |parablock|
        table=Table.new(@md,"<!#{parablock}")
        @new_content << table.table
      end
      @new_content.join
    end
  end
  class XML
  end
end
__END__
