=begin
 * Name: modify.rb
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download
 * Description: A conversion script for canned substitutions,
     a fairly generic simple tool that can be used to store other canned conversions,
     used here for altering SiSU markup

 * Copyright (C) 2004, 2006 Ralph Amissah

 * Packaged with: SiSU - Simple information Structuring Universe -
     Structured information, Serialized Units
 * SiSU Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com

 * Notes: configure rc in ~/.sisu/sisurc.yaml
=end
module SiSU_Markup
  class Markup_inform
    attr_accessor :version
    def initialize(version,message)
      @version,@message=version,message
    end
    def version
      @version
    end
    def message
      @message
    end
    def history
      Markup_history.new(@version).query
    end
  end
  class Markup_identify
    def initialize(opt)
      @opt=opt
      @description="This is a script attempts to identify the version of markup used in SiSU (and provides information on changes in markup)"
    end
    def help
    print <<WOK

#@description

WOK
      exit
    end
    def identify #(f)
      f=@opt.fns
      if f =~/(?:\.sst|\.ssm|\.ssi|\.s[123])$/ and File.exist?(f)
        file=File.open(f,'r')
        cont=file.readlines
        file.close
        links,oldlinks='',''
        markup=nil
        cont.each do |y|
          if y =~/^(?:0\{?~links?|@links?:)\s/ and f =~/(?:\.sst|\.ssm|\.ssi|\.s[123])/
            links=unless y =~/\{.+?\}\S+/: oldlinks=' (pre 0.20.4 header links)'
            else ' (post 0.20.4 header links)'
            end
          end
          if y =~/^:?A~/ and f =~/(?:\.sst|\.ssm|\.ssi)/
            version='0.38'
            markup=Markup_inform.new(version,'0.38' + oldlinks)
            break
          end
          if y =~/^1~/ and f =~/(?:\.sst|\.ssm|\.ssi)/
            version='0.37'
            markup=Markup_inform.new(version,'0.37 is substantially 0.16 - 0.36 markup with new file-extension' + oldlinks)
            break
          end
          if y =~/^1~/ and f =~/\.([rs])([123])/
            t,n=$1,$2
            version='0.16'
            instruct=if t =~/r/
              " (change file extension from .#{t}#{n} to .ssm)"
            else " (change file extension from .#{t}#{n} to .sst)"
            end
            markup=Markup_inform.new(version,'0.16 - 0.36' + instruct + links)
            break
          end
          if y =~/^0\{~/
            version='0.1'
            markup=Markup_inform.new(version,'0.1 - 0.15')
            break
          end
          if y =~/^0\{{3}/
            markup=Markup_inform.new('circa. 1997','old, check date')
            break
          end
          #if y =~/^1{~/
          #  markup_version='0.16'
          #  break
          #end
          markup='Not a recognised file type '
        end
        markup
      else Markup_history.new(@opt).help_query
      end
    end
    def determine_markup_version
      if @opt.fns.nil? or @opt.fns.empty?: Markup_history.new(@opt).help_identify
      end
      if File.exist?(@opt.fns)
        if @opt.fns =~/\.(?:sst|ssm|ssi|s[123i]|r[123])/
          markup=identify #(@opt.fns)
          if markup.version
            unless @opt.cmd =~/q/
              puts "Markup Type Appears to be: < #{markup.version} > < #{@opt.fns} >"
              puts markup.message
              puts %{"sisu --query=#{markup.version}" for a brief description of markup type}
              #puts markup.history
            end
          end
        else puts 'file-type not recognised: ' + @opt.fns
        end
      else puts 'file not found: ' + @opt.fns
      end
      if markup.version: markup.version
      else               'markup type/version not determined'
      end
    end
    def markup_version?
      if @opt.fns.empty?
        @opt.files.each do |fns|
          @opt.fns=fns
          determine_markup_version
        end
      else determine_markup_version
      end
    end
  end
  class Markup_history
    def initialize(opt)
      @opt=opt
    end
    def sisu_0_38
      <<WOK

  SiSU 0.38 introduced alternative experimental header and heading/structure markers,
  
  @headername: and headers :A~ :B~ :C~ 1~ 2~ 3~

  as the equivalent of

  0~headername and headers 1~ 2~ 3~ 4~ 5~ 6~

  The internal document markup of SiSU 0.16 remains valid and standard
  Though note that SiSU 0.37 introduced a new file naming convention

  SiSU has in effect two sets of levels to be considered, using 0.38 notation
  A-C headings/levels, pre-ordinary paragraphs /pre-substantive text, and
  1-3 headings/levels, levels which are followed by ordinary text.
    This may be conceptualised as levels A,B,C, 1,2,3, and using such letter
    number notation, in effect:
      A must exist, optional B and C may follow in sequence (not strict)
      1 must exist, optional 2 and 3 may follow in sequence
    i.e. there are two independent heading level sequences A,B,C and 1,2,3
      (using the 0.16 standard notation 1,2,3 and 4,5,6)
    on the positive side:
      * the 0.38 A,B,C,1,2,3 alternative makes explicit an aspect of structuring
        documents in SiSU that is not otherwise obvious to the newcomer (though
        it appears more complicated, is more in your face and likely to be
        understood fairly quickly)
      * the substantive text follows levels 1,2,3 and it is 'nice' to do
        most work in those levels
WOK
    end
    def sisu_0_37
      <<WOK

  SiSU 0.37 introduced new file naming convention,
  using the file extensions .sst .ssm and .ssi
  to replace .s1 .s2 .s3 .r1 .r2 .r3  and .si

  this is captured by the following file 'rename' instruction:

  rename 's/\.s[123]$/\.sst/' *.s{1,2,3}
  rename 's/\.r[123]$/\.ssm/' *.r{1,2,3}
  rename 's/\.si$/\.ssi/' *.si

  The internal document markup remains unchanged, from SiSU 0.16
WOK
    end
    def sisu_0_16
      <<WOK

  SiSU 0.16 (0.15 development branch) introduced the use of

  the header 0~ and headings/structure 1~ 2~ 3~ 4~ 5~ 6~

  in place of the 0.1 header, heading/structure notation
WOK
    end
    def sisu_0_1
      <<WOK

  SiSU 0.1 headers and headings structure represented by
  header 0{~ and headings/structure  1{ 2{ 3{ 4{~ 5{ 6{
WOK
    end
    def help_query
      <<WOK

  sisu --query=[sisu version [0.38] or 'history] 
  provides a short history of changes to SiSU markup

WOK
    end
    def help_identify
      <<WOK

  sisu --identify [filename] 
  attempts to identify the SiSU markup used in a file

WOK
    end
    def query
      tell=if @opt.mod_s =~/--query/
        tell=case @opt.mod_s
        when /history/
          "#{sisu_0_38}\n#{sisu_0_37}\n#{sisu_0_16}\n#{sisu_0_1}"
        when /0.38/
          "#{sisu_0_38}#{sisu_0_16}"
        when /0.37/
          "#{sisu_0_37}\n#{sisu_0_16}"
        when /0.1[6-9]|0.2[0-9]|0.3[0-6]/
          "#{sisu_0_16}\n#{sisu_0_1}"
        when /0.[1-9]|0.1[1-4]/
          sisu_0_1
        else puts "NOT RECOGNISED: #{@opt.mod_s}"
          help_query
        end
        tell
      else help_query
      end
    end
  end
end
#%% to use as independent program ------------------------->
=begin
f=$*
cf=f[0].to_s
f.shift
match_and_replace=Array.new
unless f.length > 0: f=Dir.glob("[a-z]*.ss?")  #restricted to sisu type files, it need not be
end
puts "SiSU files:"
puts f
f.each do |x|
  SiSU_Markup::Markup_identify.new(x).markup_version?
end
=end
__END__
