=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: base formatting template for html generation

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module SiSU_HTML_Format
  require SiSU_lib + '/param'
  include SiSU_Param
  include SiSU_Viz
  #include SiSU_HTML_Format
  require SiSU_lib + '/common_xml'
  include SiSU_XML_tags
  require SiSU_lib + '/common_text'
  include SiSU_text_utils
  class Paragraph_number
    def initialize(md,paranum)
      @md=md
      @paranum=paranum[/(\d+)/im,1]
      @paranum ||=''
      @paranum='' if @paranum =~/^0$/
    end
    def ocn_display
      ocn_class=if @md.cmd =~/[phH]\S*0/: 'ocn_off'
      else                               'ocn'
      end
      @paranum.gsub(/^(\d+|)$/,
        %{  <p class="#{ocn_class}">
    &nbsp;&nbsp;\\1
  </p>})
    end
    def name
      %{<a name="#@paranum" />}
      #%{<a name="#@paranum"></a>}
    end
    def id #w3c? "tidy" complains about numbers as identifiers ! annoying
      %{id="o#@paranum"}
      #%{id="#@paranum"}
    end
    def goto
      %{<a href="##@paranum">}
    end
  end
  class Paragraph_id_ocn #used by table version #work area 2003w48
    attr_accessor :paranum,:font,:p_num
    def initialize(md,paranum)
      @paranum,@font,@p_num=paranum,SiSU_Viz::Font.new,SiSU_HTML_Format::Paragraph_number.new(md,paranum)
    end
    def txt
      %{  <p #{@p_num.id} align="justify">#{@p_num.name}
  <font #{@font.size_txt} #{@font.color} #{@font.face}>}
    end
    def txt_00
      %{  <p #{@p_num.id} align="justify">#{@p_num.name}
  <font #{@font.size_txt_00} #{@font.color} #{@font.face}>}
    end
    def font_citation
      %{<font #{@font.size_txt} #{@font.face}>}
    end
    def endnote
      %{  <p #{@p_num.id} align="justify">#{@p_num.name}
  <font #{@font.size_endnote} #{@font.color} #{@font.face}>}
    end
    def table
      %{  <p #{@p_num.id} align="left">#{@p_num.name}
  <font #{@font.small} #{@font.color} #{@font.face}>}
    end
    def tiny
      %{  <p #{@p_num.id} align="justify">#{@p_num.name}
  <font #{@font.tiny} #{@font.color} #{@font.face}>}
    end
    def small
      %{  <p #{@p_num.id} align="justify">#{@p_num.name}
  <font #{@font.small} #{@font.color} #{@font.face}>} # keep but not used?
    end
    def font_tiny
      %{<font #{@font.tiny} #{@font.face}>}
    end
    def font_small
      %{<font #{@font.small} #{@font.face}>}
    end
    def header_
      %{  <p #{@p_num.id} align="center">#{@p_num.name}
  <font #@font color="#@color" #{@font.face}>}
    end
  end
  class Head_information
    #attr_accessor
    include SiSU_XML_tags
    include SiSU_Viz
    include SiSU_HTML_Format
    include SiSU_Env
    @@margin=SiSU_Viz::Margin.new
    @@paragraph=SiSU_Viz::Paragraph.new
    @@table=SiSU_Viz::Table.new
    @@banner=SiSU_Viz::Banner.new
    @@url=SiSU_Viz::Url.new
    @@icon=SiSU_Viz::Icon.new
    @@png=SiSU_Viz::Png.new
    @@txt=SiSU_Viz::Txt.new
    @@color=SiSU_Viz::Color.new
    @@font=SiSU_Viz::Font.new
    @@nav_txt=SiSU_Viz::Nav_txt.new
    @@nav_png=SiSU_Viz::Nav_png.new
    @@credits=SiSU_Viz::Credits.new
    @@js=SiSU_Viz::Javascript.new
    @@php=SiSU_Viz::Php.new
    #@@date=SiSU_Env::Info_date.new
    attr_reader :md,:sfx,:pdf,:rdf,:margin,:paragraph,:table,:banner,:url,:png,:txt,:color,:font,:nav_txt,:nav_png,:credits,:credit,:js,:php,:seg_name_html,:metalink,:tocband_scroll,:tocband_segtoc,:link,:linkname #,:date
    def initialize(md='')
      @md=md
      @sfx,@pdf=@md.sfx,@md.pdf
      @rdf=SiSU_XML_tags::RDF.new(md)
      # DublinCore 1 - title
      @margin,@paragraph,@table,@banner,@url,@icon,@png,@txt,@color,@font,@nav_txt,@nav_png,@credits,@js,@php=@@margin,@@paragraph,@@table,@@banner,@@url,@@icon,@@png,@@txt,@@color,@@font,@@nav_txt,@@nav_png,@@credits,@@js,@@php
      @css=SiSU_Env::CSS_stylesheet.new(md)
      @seg_name_html=(SiSU_HTML::Source::Seg.new.seg_name_html || [])
      @seg_name_html_tracker=(SiSU_HTML::Source::Seg.new.seg_name_html_tracker || [])
      case @md.file_type
      when /php/: @index='index' # @index="index.php"
      else        @index='index'
      end
      @metalink='#metadata'
      @tocband_scroll,@tocband_segtoc=nil,nil
    end
    def doc_type
      %{<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">\n}
#      %{<!DOCTYPE HTML PUBLIC "-//W3C//Dtd HTML 4.0 Transitional//EN">
#<html>\n}
    end
    def toc_head_escript #embedded script in this case PHP
      # %{<p>PHP or other embedded script for object persistence may go HERE</p>}
    end
    def seg_head_escript #embedded script in this case PHP 
      # %{<p>PHP or other embedded script for object persistence may go HERE</p>}
    end
    def table_close
      %{  </font>
#{@table.close}}
    end
    def buttons_home
      %{<!- home and index buttons -!>
  #{@banner.home_and_index_buttons}
<!- home and index buttons -!>}
    end
    def copyat
      %{#{@paragraph.heading_1_center}copy @
  <a href="#{@url.home}" #{@js.home}>
    #{@txt.home}
  </a></h1>}
    end
  end
  class Head_toc < Head_information
    def initialize(md)
      super(md)
      @md=md
      @tocband_scroll,@tocband_segtoc=make_scroll,make_seg
    end
    def scroll_head_navigation_band
      pdf=if @md.programs[:pdf]
        <<WOK
<td align="center" width="60%">
  #{make_seg_scroll_pdf}
</td>
WOK
      else ''
      end
      %{<table summary="toc scroll navigation band">
<tr>
<td width="20%">
  &nbsp;
</td></tr>
</table>
<table summary="table of contents" id="toc" bgcolor=#{@color.band1}>
<tr><td width="20%">
  #{@banner.band}
</td>#{pdf}
<td width="20%">
  &nbsp;
#{@table.close}
<p />}
    end
    def seg_head_navigation_band(type='')
      if type=~/pdf/
        @tocband_segtoc=make_scroll_seg_pdf
      end
      firstseg=%{<a href="#{@md.fnl[:pre]}#{@md.firstseg}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" alt="-&gt;">
      #{@nav_png.nxt}
    </a>} if @md.firstseg =~/\S+/
      %{<table summary="toc segment navigation band">
<tr>
<td width="20%">&nbsp;</td>
</tr></table>
<table summary="table of contents" id="toc" bgcolor=#{@color.band1}>
<tr><td width="20%">
 #{@banner.band}
</td>
<td width="60%" align="center">
  #@tocband_segtoc
</td>
<td width="20%" align="center">
  &nbsp;#{firstseg}
#{@table.close}
<p />}
    end
    def concordance_link(text)
      if @md.concord_make
  %{<font size=2>
    <a href="#{@md.fn[:concordance]}" target="_top" #{@js.concordance}>
      #{text}
    </a>
  </font>}
      else ''
      end
    end
    def make_scroll_pdf
      pdf=if @md.programs[:pdf]
        %{
<td align="center" bgcolor=#{@color.band2} border="0">
  <a href="#{@md.fn[:pdf_p]}" target="_top" #{@js.portrait}>
    #{@nav_txt.pdf_portrait}
  </a>
</td>
<td align="center" bgcolor=#{@color.band2}>
  <a href="#{@md.fn[:pdf_l]}" target="_top" #{@js.landscape}>
    #{@nav_txt.pdf_landscape}
  </a>
</td>
<td align="center" bgcolor=#{@color.band2}>
  #{@nav_txt.pdfs}
</td>}
      else ''
      end
      concord=concordance_link(@nav_txt.concordance)
      %{<table summary="toc scroll with pdf" border="0" cellpadding="3" cellspacing="0">
<tr>
<td align="center" bgcolor=#{@color.band2} border="0">
  <a href="#{@md.fn[:manifest]}" target="_top">
  #{@nav_txt.manifest_link}</a>
</td>
<td align="center" bgcolor=#{@color.band2} border="0">
  #{@nav_txt.doc_link}
</td>#{pdf}
<td align="center" bgcolor=#{@color.band2}>
   #{concord}
#{@table.close}}
    end
    def make_seg_pdf
      pdf=if @md.programs[:pdf]
        %{
<td align="center" bgcolor=#{@color.band2} border="0">
  <a href="#{@md.fn[:pdf_p]}" target="_top" #{@js.portrait}>
    #{@nav_txt.pdf_portrait}
  </a>
<td align="center" bgcolor=#{@color.band2} border="0">
  <a href="#{@md.fn[:pdf_l]}" target="_top" #{@js.landscape}>
    #{@nav_txt.pdf_landscape}
  </a>
</td>
<td align="center" bgcolor=#{@color.band2}>
  #{@nav_txt.pdfs}
</td>}
      else ''
      end
      concord=concordance_link(@nav_txt.concordance)
      %{<table summary="toc segment with pdf" border="0" cellpadding="3" cellspacing="0">
<tr>
<td align="center" bgcolor=#{@color.band2}>
  #{@nav_txt.toc_link} 
</td></td>#{pdf}
<td align="center" bgcolor=#{@color.band2}>
   #{concord}
#{@table.close}}
    end
    def make_seg_scroll_pdf
      pdf=if @md.programs[:pdf]
        %{
<td align="center" bgcolor=#{@color.band2} border="0">
  <a href="#{@md.fn[:pdf_p]}" target="_top" #{@js.portrait}>
    #{@nav_txt.pdf_portrait}
  </a>
<td align="center" bgcolor=#{@color.band2} border="0">
  <a href="#{@md.fn[:pdf_l]}" target="_top" #{@js.landscape}>
    #{@nav_txt.pdf_landscape}
  </a>
</td>
<td align="center" bgcolor=#{@color.band2}>
  #{@nav_txt.pdfs}
</td>}
      else ''
      end
      concord=concordance_link(@nav_txt.concordance)
      %{<table summary="toc segment and scroll with pdf" border="0" cellpadding="3" cellspacing="0">
<tr>
<td align="center" bgcolor=#{@color.band2} border="0">
  <a href="#{@md.fn[:manifest]}" target="_top">
  #{@nav_txt.manifest_link}</a>
</td>
<td align="center" bgcolor=#{@color.band2} border="0">
  #{@nav_txt.doc_link} 
</td>
<td align="center" bgcolor=#{@color.band2}>
  <a href="#{@md.fn[:toc]}" target="_top" #{@js.toc}>
    #{@nav_txt.toc_link}
  </a>
</td>#{pdf}
<td align="center" bgcolor=#{@color.band2}>
   #{concord}
#{@table.close}}
    end
    def make_scroll_seg_pdf
      manifest=scroll=seg=''
      manifest=%{<td align="center" bgcolor=#{@color.band2}>
  <a href="#{@md.fn[:manifest]}" target="_top">
  #{@nav_txt.manifest_link}</a>
</td>
}
      pdf=if @md.programs[:pdf]
        %{
<td align="center" bgcolor=#{@color.band2} border="0">
  <a href="#{@md.fn[:pdf_p]}" target="_top" #{@js.portrait}>
    #{@nav_txt.pdf_portrait}
  </a>
</td>
<td align="center" bgcolor=#{@color.band2} border="0">
  <a href="#{@md.fn[:pdf_l]}" target="_top" #{@js.landscape}>
    #{@nav_txt.pdf_landscape}
  </a>
</td>
<td align="center" bgcolor=#{@color.band2}>
  #{@nav_txt.pdfs}
</td>}
      else ''
      end
      if @md.fns =~ /\.(?:ss[ft]|[_-]sst)$/
        scroll=%{<td align="center" bgcolor=#{@color.band2}>
  <a href="#{@md.fn[:doc]}" target="_top" #{@js.doc}>
    #{@nav_txt.doc_link}
  </a>
</td>
}
      end
      if @md.fns =~ /\.(?:ss[ft]|[_-]sst)$/
        seg=%{<td align="center" bgcolor=#{@color.band2}>
  #{@nav_txt.toc_link}
</td>
}
      end
      concord=concordance_link(@nav_txt.concordance)
      %{<table summary="toc scroll and segment with pdf" border="0" cellpadding="3" cellspacing="0">
<tr>
  #{manifest}
  #{seg}
  #{scroll}#{pdf}
<td align="center" bgcolor=#{@color.band2}>
  #{concord}
#{@table.close}}
    end
    def head
      %{#{doc_type}
<head>
  <title>
    #{@md.html_title}
  </title>
  <meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
  #{@rdf.rdftoc}
  #{@rdf.metatag_html}
  #{@font.css_table_file}
</head>
#{@color.body}
  <a name="top" id="top"></a>
  <a name="up" id="up"></a>
  <a name="start" id="start"></a>
  #{@js.top}} 
    end
    def document_versions_toc_hold
      manifest=%{
  <li class="ref">
    <a href="./portrait" alt="pdf, portrait" target="_top">
      #{@nav_txt.manifest}
    </a>
  </li>}
      pdf=if @md.programs[:pdf]
         %{
  <li class="ref">
    <a href="./portrait" alt="pdf, portrait" target="_top">
      #{@nav_txt.pdf_portrait}
    </a>
  </li>
  <li class="ref">
    <a href="./landscape" alt="pdf, landscape" target="_top">
      #{@nav_txt.pdf_landscape}
    </a>
  </li>}
      else ''
      end
      scroll=if @md.fns
        %{
  <li class="ref">
    <a href="./doc" alt="html full length document" target="_top">
      html&nbsp;scroll
    </a>
  </li>}
      else ''
      end
      %{<div id="document_versions">
  <ul id="vertical">
  <li class="ref">
     Versions:
  </li>
  <li class="ref">
    <a href="./toc" alt="html toc, segmented text" target="_top">
      html&nbsp;seg
    </a>
  </li>#{scroll}#{pdf}
  <li class="ref">
    <a href="./concordance" alt="concordance, rudimentary index" target="_top">
      concordance
    </a>
  </li>
  </ul>
</div>}
    end
    def document_versions_toc
      #document_version_hold
    end
    def links_guide_vertical_open
      url=if defined? @url.hp: @url.hp
      else @url.home
      end
      %{<div id="vertical_links">
  <ul id="vertical">
  <li class="refbold">
    <a href="#{url}" #{@js.home}>
      #{@txt.hp}
    </a>
  </li>
  <li class="ref">
     Quick Ref.:
  </li>
  <li class="ref">
    <a href="#{@md.fn[:manifest]}" alt="Document Manifest" target="_top">
      Manifest
    </a>
  </li>
<!- quick ref -!>}
    end
    def links_guide_horizontal_open
      url=if defined? @url.hp: @url.hp
      else @url.home
      end
      %{<div id="horizontal_links">
  <ul id="horizontal">
  <li class="refbold">
    <a href="#{url}" #{@js.home}>
      #{@txt.hp}
    </a>
  </li>
  <li class="ref">
     Quick Ref.:
  </li>
  <li class="ref">
    <a href="#{@md.fn[:manifest]}" alt="Document Manifest" target="_top">
      Manifest
    </a>
  </li>
<!- quick ref -!>}
    end
    def links_guide_open(type='horizontal')
      if type=='vertical': links_guide_vertical_open
      else                 links_guide_horizontal_open
      end
    end
    def links_guide_close #(type='horizontal')
      insert=''
      insert=@banner.home_guide if @md.sfx_src =~/lm?/
      #insert=@banner.home_guide if @md.sfx_src =~/s?/
      insert=if @md.sfx_src =~/s?/
        link='http://www.jus.uio.no/sisu'                      #get from defaults
        url='www.jus.uio.no/sisu'
        name='SiSU electronic documents'                            #get from defaults
        #name='SiSU electronic documents/books'                      #get from defaults
        insert= %{  <li class="refbold">
    <a href="#{link}" alt="#{name}" target="_top">
      #{name}
    </a>
  </li>
  <li class="ref">
    <a href="#{link}" alt="#{name}" target="_top">
      #{url}
    </a>
  </li>
  </ul>
</div>}
      end
      %{ #{insert}
<!- quick ref -!>}
    end
    def links_guide_open_old
      url=if defined? @url.hp: @url.hp
      else @url.home
      end
      %{  <br />
  #{@banner.open_blue}
  #{@banner.blueband}
  <br />
  <p class="bigref">
    <a href="#{url}#@sfx" #{@js.home}>
      #{@png.hp_nav}
      #{@txt.hp}
    </a>
  </p>
  <p class="quickref">
     Quick Ref.:
  </p>
<!- quick ref -!>}
    end
    def links_guide_close_old
      insert=''
      insert=@banner.home_guide if @md.sfx_src =~/lm?/
      %{ #{insert}
<!- quick ref -!>
#{@banner.blueband}
#{@banner.close_blue}
<br />}
    end
    def prefix_a
    end
    def rights
      rights=@md.dc_rights.gsub(/^\s*Copyright\s+/,'<sup>&copy;</sup>&nbsp;')
      %{<table summery="copyright">
<tr>
<td width=10%>&nbsp;</td>
<td width=80%>
  #{rights}
</td>
<td width=10%>&nbsp;
#{@table.close}
<p />}
    end
    def prefix_b
      %{<table summery="prefix">
<tr>
<td width=10%>&nbsp;</td>
<td width=80%>
  #{@md.prefix_b}
</td>
<td width=10%>&nbsp;
#{@table.close}
<p />}
    end
    def scroll_head_title_banner_open
      %{<center>
#{@md.icon}
</center>
#{@banner.instrument_cover_band_scr}}
    end
    def seg_head_title_banner_open
      %{<center>
  #{@md.icon}
</center>
#{@banner.instrument_cover_band_seg}}
    end
    def make_scroll
      concord=concordance_link(@nav_txt.concordance)
      %{<table summary="toc scroll" border="0" cellpadding="3" cellspacing="0">
<tr><td align="center" bgcolor="white" border="0">
  #{@nav_txt.doc_link}
</td>
<td align="center" bgcolor="white">
   #{concord}
#{@table.close}}
    end
    def make_seg
      concord=concordance_link(@nav_txt.concordance)
      %{<table summary="toc segment" border="0" cellpadding="3" cellspacing="0">
<tr><td align="center" bgcolor="white">
  #{@nav_txt.toc_link}
</td>
<td align="center" bgcolor="white">
  <font size=2>
   #{concord}
#{@table.close}}
    end
    def concordance #check structure
      concord=concordance_link(@nav_txt.concordance)
      %{#{@margin.txt_3}
  #{@paragraph.font_small}
   #{concord}
    </font> 
#{@table.close}}
    end
    def metadata
      %{#{@margin.txt_3}
#{@paragraph.font_small}
  <a href="#@metalink" #{@js.metalink}>
    <i>MetaData</i>
    <font size="1" color="#777777">
      &nbsp;&nbsp;&nbsp;
    </font>
  </a>
  </font>
#{@table.close}}
    end
    def seg_metadata
      @metalink=%{./#{@md.fn[:metadata]}}
      metadata
    end
    def seg_tail
      %{<p>&nbsp;<p>
<table summary="toc segment tail" bgcolor=#{@color.band1}>
<tr><td width="20%">
  #{@banner.band}
</td>
<td width="60%">
  <center>
    #{@tocband_segtoc}
  </center>
</td>
<td width="20%">
  &nbsp;
</td></tr>
</table>
<p>&nbsp;</p>
#{@credits.credits}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits"></a>
</body>
</html>}
    end
    def scroll_tail
      nav=scroll_head_navigation_band
      %{#{nav}
#{@credits.credits}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits"></a>
</body>
</html>}
    end
    def seg_navigation_tail #this is a bug area, look up and "tidy"
      #nav=scroll_head_navigation_band
      %{<p>&nbsp;</p>
#{@credits.credits}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits"></a>
</body>
</html>}
    end
  end
  class Head_scroll < Head_toc
    def initialize(md)
      super(md)
    end
    def toc_owner_details
      %{#{@margin.txt_3}
#{@paragraph.font_small}
  <a href="#owner.details">
    Owner Details
    <font size="1" color="#777777">
      &nbsp;&nbsp;&nbsp;
    </font>
  </a>
  </font>
#{@table.close}}
    end
    def table
      %{<table summary="scroll table" width=#{@table.width_1} border="0" bgcolor="white" cellpadding="0">
<tr><th width=#{@@indent['level_1']} align="right">
</th>
<td valign="top">
#{@paragraph.txt}}
    end
    def table1
      %{<table summary="scroll table1" width=#{@table.width_1} border="0" cellpadding=#{@table.cellpad_box} #{@color.color_table1} align="justify">
<tr><td valign="top">
#{@paragraph.txt}}
    end
    def table2
      %{<table summary="scroll table2" width=#{@table.width_1} border="0" cellpadding=#{@table.cellpad_box} #{@color.color_table2} align="justify">
<tr><td valign="top">
#{@paragraph.txt}}
    end
    def toc_endnote
      %{#{@margin.txt_3}
#{@paragraph.font_small}
  <a href="#endnotes">
    Endnotes
  </a>
#{@table.close}}
    end
    def title_endnote
      %{#{@margin.txt_0}
  #{@paragraph.txt}
  <br />
  <a name="endnotes" id="endnotes"></a>
  <b>Endnotes</b>
#{@margin.num}
  &nbsp;
#{@table.close}}
    end
    def tail
      %{<br />
#{@margin.txt_0}
<table summary="scroll tail" bgcolor="#777777">
<tr><td width="20%">
#{@banner.band}
</td>
<td width="60%">
<center>#@tocband_scroll</center>
</td>
<td width="20%">
  &nbsp;
</td></tr>
</table>
<br />
#{@paragraph.txt}
  <center>
    #{@credits.credits}
  </center>
#{@margin.num}
#{@table.close}
<a name="bottom id="finish"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits" id="credits"></a>
<font color="white" size="0">
  #{@md.title*10}
</font>
</body>
</html>} 
    end
  end
  class Head_seg < Head_information
    def initialize(md)
      super(md)
    end
    def head
      %{#{doc_type}
<head>
  <title>
    #{@seg_name_html[@seg_name_html_tracker]} - 
    #{@md.html_title}
  </title>
<meta http-equiv="Content-Type" content="text/html;charset=utf-8" />
#{@rdf.rdfseg}
#{@rdf.metatag_html}
#{@font.css_table_file}
</head>
#{@color.body}
<a name="top" id="top"></a>
<a name="up" id="up"></a>
<a name="start" id="start"></a>
#{@js.top}} 
    end
    def title_banner(title,subtitle,creator)
    end
    def dot_control_pre_next
      %{<table summary="segment hidden control pre and next" width="100%" border="0" cellpadding="0" bgcolor=#{@color.grey_pale} align="center">
<tr><td align="left">
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker-1]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@js.prev}>
    #{@nav_png.dot_pre}
  </a>
</td>
<td align="center">
  <a href="#{@md.fnl[:pre]}#@index#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@js.toc}>
    #{@nav_png.dot_toc}
  </a>
</td>
<td align="right">
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker+1]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@js.next}>
    #{@nav_png.dot_nxt}
  </a>
#{@table.close}}
    end
    def dot_control_pre
      %{<table summary="segment hidden control pre" width="100%" border="0" cellpadding="0" bgcolor=#{@color.grey_pale} align="center">
<tr><td align="left">
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker-2]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@js.prev}>
    #{@nav_png.dot_pre}
  </a>
</td>
<td align="center">
  <a href="#{@md.fnl[:pre]}#@index#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@js.toc}>
    #{@nav_png.dot_toc}
  </a>
</td>
<td align="right">
  <a href="#{@md.fn[:toc]}" target="_top" #{@js.next}>
    #{@nav_png.dot_nxt}
  </a>
#{@table.close}}
    end
    def toc_nav(f_pre=false,f_nxt=false,use=1)
      pre=nxt=''
      toc=%{<td align="center" bgcolor=#{@color.band1}>
  <a href="#{@md.fnl[:pre]}#@index#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@js.toc}>
    #{@nav_png.toc}
  </a>
</td>}
      pre=%{<td align="center" bgcolor=#{@color.band1}>
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker-use]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@js.prev}>
    #{@nav_png.pre}
  </a>
</td>} if f_pre==true
      nxt=%{<td align="center" bgcolor=#{@color.band1}>
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker+1]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@js.next}>
    #{@nav_png.nxt}
  </a>
</td>} if f_nxt==true
      %{<table summary="segment navigation pre/next" border="0" cellpadding="3" cellspacing="0">
<tr>
#{pre}
#{toc}
#{nxt}
<td>
#{@table.close}} 
    end
    def toc_next2
      pre,nxt=false,true
      toc_nav(false,true).dup
    end
    def toc_pre_next2
      toc_nav(true,true).dup
    end
    def toc_pre2
      toc_nav(true,false,2).dup
    end
    def concordance_link(text)
      if @md.concord_make
  %{<font size=2>
    <a href="#{@md.fn[:concordance]}" target="_top" #{@js.concordance}>
      #{text}
    </a>
  </font>}
      else ''
      end
    end
    def doc_types #used in seg_nav_band ###
      scroll=seg=''
      pdf=if @md.programs[:pdf]
        %{<td align="center" bgcolor=#{@color.band2}>
  <a href="#{@md.fn[:pdf_p]}" target="_top" #{@js.portrait}>
    #{@nav_txt.pdf_portrait}
  </a>
</td>
<td align="center" bgcolor=#{@color.band2}>
  <a href="#{@md.fn[:pdf_l]}" target="_top" #{@js.landscape}>
    #{@nav_txt.pdf_landscape}
  </a>
</td>
<td align="center" bgcolor=#{@color.band2}>
  #{@nav_txt.pdfs}
</td>}
      else ''
      end
      dir=SiSU_Env::Info_dir.new(@md.fns)
      sum='manifest'
      concord=concordance_link(@nav_txt.concordance)
      if @md.fns =~ /\.[_-]?sst$/
        scroll=%{<td align="center" bgcolor=#{@color.band2}>
  <a href="#{@md.fn[:doc]}" target="_top" #{@js.doc}>
    #{@png.doc}
  </a>
</td>}
      end
      if @md.fns =~ /\.[_-]?sst$/
        %{<td align="center" bgcolor=#{@color.band2}>
  <a href="#{@md.fn[:toc]}" target="_top" #{@js.toc}>
    #{@png.toc}
  </a>
</td>}
      end
      %{
<table summary="segment navigation available documents types: toc,doc,pdf,concordance" border="0" cellpadding="3" cellspacing="0">
<tr>
  #{seg}
  #{scroll}
  #{pdf}
<td align="center" bgcolor=#{@color.band2}>
  #{concord}
#{@table.close}}
    end
    def toc_pre_next3 #used with seg_doc_types in seg_nav_band #with pdf & other doc types #knxjs
      %{<table summary="segment navigation pre/next" border="0" cellpadding="3" cellspacing="0">
<tr><td align="center" bgcolor=#{@color.band1}>
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker-1]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@js.prev}>
    #{@nav_png.previous}
  </a>
</td>
<td align="center" bgcolor=#{@color.band1}>
  <a href="#{@md.fnl[:pre]}#@index#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@js.toc}>
    #{@nav_png.toc}
  </a>
</td>
<td align="center" bgcolor=#{@color.band1}>
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker+1]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@js.next}>
    #{@nav_png.next}
  </a>
#{@table.close}} 
    end
    def toc_next3 #used with seg_doc_types in seg_nav_band #with pdf & other doc types #knxjs
      %{<table summary="segment navigation next" border="0" cellpadding="3" cellspacing="0">
<tr>
<td align="center" bgcolor=#{@color.band1}>
  <a href="#{@md.fnl[:pre]}#@index#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@js.toc}>
    #{@nav_png.toc}
  </a>
</td>
<td align="center" bgcolor=#{@color.band1}>
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker+1]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@js.next}>
    #{@nav_png.next}
  </a>
#{@table.close}} 
    end
    def toc_pre3 #used with seg_doc_types in seg_nav_band #with pdf and other doc types #knxjs
    # note endnotes is now two back, with insertion between end of text and metadata, but what happens where no endnote?
      %{<table summary="segment navigation pre" border="0" cellpadding="3" cellspacing="0">
<tr><td align="center" bgcolor=#{@color.band1}>
  <a href="#{@md.fnl[:pre]}#{@seg_name_html[@seg_name_html_tracker-2]}#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@js.prev}>
    #{@nav_png.previous}
  </a></td>
<td align="center" bgcolor=#{@color.band1}>
  <a href="#{@md.fnl[:pre]}#@index#{@md.fnl[:mid]}#@sfx#{@md.fnl[:post]}" target="_top" #{@js.toc}>
    #{@nav_png.toc}
  </a>
#{@table.close}} 
    end
    def toc_endnote
    end
    def title_endnote(title,subtitle,creator,table_top_control)
      %{#{@banner.instrument_cover_band_seg}
  <h1 class="banner">
    #{title}
  </h1>
  <h1 class="subbanner">
   #{subtitle}
  </h1>
  <h1 class="subbanner">
    #{creator}
  </h1>
  <h4 class="banner">
    Endnotes
  </h4>
#{@table.close}
#{table_top_control}
#{@paragraph.heading_1}
<b><i>Endnotes</i></b></font></p>}
    end
    def navigation_table
      %{<table summary="navigation segment table" width=#{@table.width_1} border="0" bgcolor="white" cellpadding="0">
<tr><th width="#{@@indent['leve_1']}" align="right">
</td>
<td valign="top">
  <font size=2>}
    end
    def navigation_table1
      %{<table summary="navigation segment table1" width=#{@table.width_1} border="0" cellpadding=#{@table.cellpad_box} bgcolor=#{@color.table1} align="left">
<tr><td valign="top">
  <font size="2">}
    end
    def navigation_table2
      %{<table summary="navigation segment table2" width=#{@table.width_2} border="0" cellpadding=#{@table.cellpad_box} bgcolor=#{@color.table2} align="left">
<tr><td valign="top">
  <font size="2">}
    end
    def header_advert_local_1
      dir=SiSU_Env::Info_dir.new(@fns)
      %{  <center>
<table summary="image" border="0" cellpadding="3" cellspacing="0" align="center">
<tr><td align="center" bgcolor="white">
  <a href="http://#{@md.ad_url}#@sfx" target="_top">
    <img border="0" src="#{dir.url_images_local}/#{@md.ad_png}" alt="#{@md.ad_alt}">
  </a>
  <p />
#{@table.close}
</center>}
    end
    def header_advert_local_2
      dir=SiSU_Env::Info_dir.new(@fns)
      %{  <center>
<table summary="image" border="0" cellpadding="3" cellspacing="0" align="center">
<tr><td align="center" bgcolor="white">
  <a href="#{@md.ad_url}#@sfx" target="_top">
    <img border="0" src="#{dir.url_images_local}/#{@md.ad_png}" alt="#{@md.ad_alt}">
  </a>
  <p />
#{@table.close}
</center>}
    end
    def header_advert_external
      dir=SiSU_Env::Info_dir.new(@fns)
      %{  <center>
<table summary="image" border="0" cellpadding="3" cellspacing="0" align="center">
<tr><td align="center" bgcolor="white">
  <a href="#{@md.ad_url}#@sfx" target="external">
    <img border="0" src="#{dir.url_images_local}/#{@md.ad_png}" alt="#{@md.ad_alt}">
  </a>
  <p />
#{@table.close}
</center>}
    end
    def credit
      %{<br/>
#{@credits.credits}
<a name="bottom" id="bottom"></a>
<a name="down" id="down"></a>
<a name="end" id="end"></a>
<a name="finish" id="finish"></a>
<a name="stop" id="stop"></a>
<a name="credits" id="credits"></a>
</body>
</html>}
    end
    def navigation_band(segtocband,seg_table_top_control)
      %{<table summary="segment navigation band" bgcolor=#{@color.band1} width="100%">
<tr><td width="10%" align="left">
#{@banner.band}
</td>
<td align="left">
<table summary="segment hidden control pre and next" width="100%" border="0" cellpadding="0" bgcolor=#{@color.band1} align="center">
<tr>
<td align="left" bgcolor="white">
 &nbsp;<a href="#{@md.fn[:manifest]}" target="_top">
#{@nav_txt.manifest_link}</a>
</td>
#{@table.close}
<td width="50%" align="center">
  #{segtocband}
</td>
<td width="20" align="right">
  #{doc_types}
</td>
<td width="5%" align="right">
  &nbsp;
</td></tr>
</table>
#{seg_table_top_control}}
    end
    def endnote_mark
%{<p class="center" id="endnotes">
<a href="#top">^</a></p>}
    end
  end
  class Format_text_object
    @@margin=SiSU_Viz::Margin.new
    @@paragraph=SiSU_Viz::Paragraph.new
    @@table=SiSU_Viz::Table.new
    @@banner=SiSU_Viz::Banner.new
    @@url=SiSU_Viz::Url.new
    @@icon=SiSU_Viz::Icon.new
    @@font=SiSU_Viz::Font.new
    @@table=SiSU_Viz::Table.new
    @@color=SiSU_Viz::Color.new
    @@dp=nil
    attr_accessor :md,:one,:two,:three,:parablock,:table,:link,:linkname,:format,:paranum,:p_num,:para_id,:headname,:margin,:paragraph,:table,:banner,:url,:icon,:font,:one_stripped
    def initialize(md='',*txt)
      txt[0].gsub!(/\.(html|pdf|php)/,'') if txt[0] =~/\.\.\/\S+/
      @md,@one,@two,@three=md,txt[0],txt[1],txt[2]
      rgx=/[1-6-]~/
      @one_stripped=@one.gsub(rgx,'') if @one =~rgx
      @@dp ||=SiSU_Env::Info_dir.new.digest_pattern
      rgx=/~\{[\d*+]+\s+(.+?)<#{@@dp}>\}~/ #problem introduced
      @one_stripped=@one.gsub(rgx,'\1') if @one =~rgx #problem introduced
      @link,@linkname=txt[0],txt[1]
      @format,parablock=txt[0],txt[1]
      @parablock=if parablock=~/\S+/
      #@parablock=@one=if parablock=~/\S+/
        wrap=SiSU_text_utils::Paragraph.new(parablock,70,4)
        wrap.line_wrap
      else parablock
      end
      #p @parablock.class if parablock
      #p @parablock if parablock
      if txt[2]=~/\d+/
        @paranum=txt[2][/(\d+)/im,1] # unless paranum =~/#/
        @p_num=SiSU_HTML_Format::Paragraph_number.new(@md,@paranum)
        @para_id=Paragraph_id_ocn.new(@md,@paranum) #used by table version
      end
      @headname=''
      if @format =~ /\d~(\S+)/im
        headname=$1 #format[/\d~(\S+)/im,1]
        @headname=if headname =~/^[a-zA-Z]/: %{<a name="#{headname}" id="#{headname}"></a>} #consider: h_#{headname}
        else %{<a name="h#{headname}" id="h#{headname}"></a>}
        end
      end
      @margin=@@margin       #SiSU_Viz::Margin.new
      @paragraph=@@paragraph #SiSU_Viz::Paragraph.new
      @table=@@table         #SiSU_Viz::Table.new
      @banner=@@banner       #SiSU_Viz::Banner.new
      @url=@@url             #SiSU_Viz::Url.new
      @icon=@@icon           ##SiSU_Viz::Icon.new
      @font=@@font           #SiSU_Viz::Font.new
      @table=@@table         #SiSU_Viz::Table.new
      @color=@@color         #SiSU_Viz::Color.new
      #file_base=@one.gsub(/\.(html|pdf|php)/,'') if @one =~/\.\.\/\S+/
      #@link,@linkname=file_base,@two
    end
    def para_form                                                                # regular paragraphs shaped here
      ul=ulc=''
      ul,ulc="<ul>\n  ","\n  </ul>" if @tag =~/li/
      %{#{@margin.css}
  #{ul}<#@tag class="#@class" #{@p_num.id}>#{@p_num.name}
    #@parablock
  </#@tag>#{ulc}
#{@margin.num_css}
  #{@p_num.ocn_display}
#{@table.close}
}
    end
    def para
      @tag,@class='p','norm'
      para_form
    end
    def code
      @tag,@class='p','code'
      para_form
    end
    def center
      @tag,@class='p','center'
      para_form
      #"<center>#@one#@two</center>" #watch removed and problems may arise 2005w11
    end
    def bold
      @tag,@class='p','bold'
      para_form
    end
    def bullet
      @tag,@class='li','bullet'
      para_form
    end
    def bullet_indent1
      @tag,@class='li','i1'
      para_form
    end
    def bullet_indent2
      @tag,@class='li','i2'
      para_form
    end
    def indent1
      @tag,@class='p','i1'
      para_form
    end
    def indent2
      @tag,@class='p','i2'
      para_form
    end
    def dl
      "<dl><b>#@one</b> #@two</dl>"
    end
    def table_end                                                                #<!TZ!>
      %{</table>
  #{@margin.num_css.strip}
    #{@p_num.ocn_display}
  #{@table.close}}
    end
    def no_paranum
      %{#{@margin.css}
#{@paragraph.txt}
  #@one #@two
#{@margin.num}
#{@table.close}}
    end
    def gsub_body
      case @one
      when /^(?:<:i[12]>\s*)?\((i+|iv|v|vi+|ix|x|xi+)\)/
        @one.gsub!(/^\((i+|iv|v|vi+|ix|x|xi+)\)/,%{<b>(\\1)</b>})
        @one.gsub!(/^(<:i[12]>)\s*\((i+|iv|v|vi+|ix|x|xi+)\)/,%{\\1<b>(\\2)</b>})
      when /^(?:<:i[12]>\s*)?\(?(\d|[a-z])+\)/
        @one.gsub!(/^\((\d+|[a-z])+\)/,%{<b>(\\1)</b>})
        @one.gsub!(/^(<:i[12]>)\s*\((\d+|[a-z])+\)/,%{\\1<b>(\\2)</b>})
      when /^\s*\d{1,3}\.\s/
        @one.gsub!(/^\s*(\d+\.)/,%{<b>\\1</b>})
      when /^\s*[A-Z]\.\s/
        @one.gsub!(/^\s*([A-Z]\.)/,%{<b>\\1</b>})
      end
    end
    def bold_para
      %{#{@margin.txt_0}
  <p class="bold">
    #@one
  </p>
#{@margin.num_css}
  &nbsp;&nbsp;&nbsp;
#{@table.close}}
    end
    def toc_head_copy_at
      %{<p class="center">#@one</p>\n}
    end
    def center
      %{<p class="center">#@one</p>\n}
    end
    def bold
      %{<p class="bold">#@one</p>\n}
    end
    def center_bold
      %{<p class="centerbold">#@one</p>\n}
    end
  end
  class XML
  end
end
__END__

