=begin
 * Name: SiSU - Simple information Structuring Universe - Structured information, Serialized Units
 * Author: Ralph Amissah
   * http://www.jus.uio.no/sisu
   * http://www.jus.uio.no/sisu/SiSU/download

 * Description: modules shared by the different db types, dbi, postgresql, sqlite

 * Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006 Ralph Amissah

 * License: GPL 2 or later

  Summary of GPL 2

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the Free
  Software Foundation; either version 2 of the License, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA

  If you have Internet connection, the latest version of the GPL should be
  available at these locations:
    http://www.fsf.org/licenses/gpl.html
    http://www.gnu.org/copyleft/gpl.html
    http://www.jus.uio.no/sisu/gpl2.fsf

  SiSU was first released to the public on January 4th 2005

  SiSU uses:
  
  *  Standard SiSU markup syntax,
  *  Standard SiSU meta-markup syntax, and the
  *  Standard SiSU object citation numbering and system
  
  © Ralph Amissah 1997, current 2006.
  All Rights Reserved.

 * Ralph Amissah: ralph@amissah.com
                  ralph.amissah@gmail.com
=end
module  SiSU_DB 
  # column sizes for database
  class Column_size
    def lt_title
      320
    end
    def lt_subtitle
      320
    end
    def lt_creator
      200
    end
    def lt_illustrator
      200
    end
    def lt_translator
      200
    end
    def lt_prepared_by
      200
    end
    def lt_digitized_by
      200
    end
    def lt_subject
      400
    end
    def lt_date
      10
    end
    def lt_date_created
      10
    end
    def lt_date_issued
      10
    end
    def lt_date_available
      10
    end
    def lt_date_modified
      10
    end
    def lt_date_valid
      10
    end
    def lt_type
      100
    end
    def lt_description
      800
    end
    def lt_publisher
      120
    end
    def lt_contributor
      120
    end
    def lt_format
      100
    end
    def lt_identifier
      100
    end
    def lt_source
      100
    end
    def lt_language
      30
    end
    def lt_language_char
      3
    end
    def lt_language_original
      30
    end
    def lt_language_original_char
      3
    end
    def lt_relation
      100
    end
    def lt_coverage
      100
    end
    def lt_rights
      800
    end
    def lt_copyright
      200
    end
    def lt_owner
      100
    end
    def lt_keywords
      200
    end
    def lt_comment
      600
    end
    def lt_loc
      30
    end
    def lt_dewey
      30
    end
    def lt_isbn
      16
    end
    def lt_pg
      10
    end
    def lt_abstract
      600
    end
    def lt_skin
      100
    end
    def lt_markup
      100
    end
    def lt_links
      100
    end
    def lt_information
      100
    end
    def lt_contact
      100
    end
    def lt_suffix
      600
    end
    def lt_filename
      256
    end
    def lt_types
      1
    end
    def lt_subj
      64
    end
    def document_clean
      12000
      #2712                                                                      #% (problems with indexing when over 4200 - only a couple of documents affected, at least 12,000 is desireable) #new error message on indexing:  index row size 2900 exceeds btree maximum, 2713
    end
    def document_body
      16000
    end
    def document_seg
      120
    end
    def document_seg_full
      120
    end
    def endnote_clean
      12000
      #2712                                                                       #% (problems with indexing when over 4200 - only a couple of documents affected, at least 12,000 is desireable) #new error message on indexing:  index row size 2900 exceeds btree maximum, 2713
    end
    def endnote_body
      16000
    end
  end
  class Test
    def initialize(info,opt)
      @ck,@opt=info,opt
      #puts @ck.methods
      unless @opt.cmd =~/q/
        puts @ck.tp[:fns]
        puts @ck.tp[:title]
        puts @ck.tp[:creator] if @ck.tp[:creator] 
      end
    end
    def verify
      unless @opt.cmd =~/q/
      puts @ck.tp[:fns].length.to_s            + ' checklength ' + @ck.tp[:fns]            if @ck.tp[:fns]            and @ck.tp[:fns].length            >@ck.lt_filename
      puts @ck.tp[:title].length.to_s          + ' checklength ' + @ck.tp[:title]          if @ck.tp[:title]          and @ck.tp[:title].length          >@ck.lt_title
      puts @ck.tp[:subtitle].length.to_s       + ' checklength ' + @ck.tp[:subtitle]       if @ck.tp[:subtitle]       and @ck.tp[:subtitle].length       >@ck.lt_subtitle
      puts @ck.tp[:creator].length.to_s        + ' checklength ' + @ck.tp[:creator]        if @ck.tp[:creator]        and @ck.tp[:creator].length        >@ck.lt_creator
      puts @ck.tp[:illustrator].length.to_s    + ' checklength ' + @ck.tp[:illustrator]    if @ck.tp[:illustrator]    and @ck.tp[:illustrator].length    >@ck.lt_illustrator
      puts @ck.tp[:translator].length.to_s     + ' checklength ' + @ck.tp[:translator]     if @ck.tp[:translator]     and @ck.tp[:translator].length     >@ck.lt_translator
      puts @ck.tp[:prepared_by].length.to_s    + ' checklength ' + @ck.tp[:prepared_by]    if @ck.tp[:prepared_by]    and @ck.tp[:prepared_by].length    >@ck.lt_prepared_by
      puts @ck.tp[:digitized_by].length.to_s   + ' checklength ' + @ck.tp[:digitized_by]   if @ck.tp[:digitized_by]   and @ck.tp[:digitized_by].length   >@ck.lt_digitized_by
      puts @ck.tp[:subject].length.to_s        + ' checklength ' + @ck.tp[:subject]        if @ck.tp[:subject]        and @ck.tp[:subject].length        >@ck.lt_subject
      puts @ck.tp[:description].length.to_s    + ' checklength ' + @ck.tp[:description]    if @ck.tp[:description]    and @ck.tp[:description].length    >@ck.lt_description
      puts @ck.tp[:publisher].length.to_s      + ' checklength ' + @ck.tp[:publisher]      if @ck.tp[:publisher]      and @ck.tp[:publisher].length      >@ck.lt_publisher
      puts @ck.tp[:contributor].length.to_s    + ' checklength ' + @ck.tp[:contributor]    if @ck.tp[:contributor]    and @ck.tp[:contributor].length    >@ck.lt_contributor
      puts @ck.tp[:date].length.to_s           + ' checklength ' + @ck.tp[:date]           if @ck.tp[:date]           and @ck.tp[:date].length           >@ck.lt_date
      puts @ck.tp[:date_created].length.to_s   + ' checklength ' + @ck.tp[:date_created]   if @ck.tp[:date_created]   and @ck.tp[:date_created].length   >@ck.lt_date_created
      puts @ck.tp[:date_issued].length.to_s    + ' checklength ' + @ck.tp[:date_issued]    if @ck.tp[:date_issued]    and @ck.tp[:date_issued].length    >@ck.lt_date_issued
      puts @ck.tp[:date_valid].length.to_s     + ' checklength ' + @ck.tp[:date_valid]     if @ck.tp[:date_valid]     and @ck.tp[:date_valid].length     >@ck.lt_date_valid
      puts @ck.tp[:date_available].length.to_s + ' checklength ' + @ck.tp[:date_available] if @ck.tp[:date_available] and @ck.tp[:date_available].length >@ck.lt_date_available
      puts @ck.tp[:date_modified].length.to_s  + ' checklength ' + @ck.tp[:date_modified]  if @ck.tp[:date_modified]  and @ck.tp[:date_modified].length  >@ck.lt_date_modified
      puts @ck.tp[:type].length.to_s           + ' checklength ' + @ck.tp[:type]           if @ck.tp[:type]           and @ck.tp[:type].length           >@ck.lt_type
      puts @ck.tp[:format].length.to_s         + ' checklength ' + @ck.tp[:format]         if @ck.tp[:format]         and @ck.tp[:format].length         >@ck.lt_format
      puts @ck.tp[:identifier].length.to_s     + ' checklength ' + @ck.tp[:identifier]     if @ck.tp[:identifier]     and @ck.tp[:identifier].length     >@ck.lt_identifier
      puts @ck.tp[:source].length.to_s         + ' checklength ' + @ck.tp[:source]         if @ck.tp[:source]         and @ck.tp[:source].length         >@ck.lt_source
      puts @ck.tp[:language].length.to_s       + ' checklength ' + @ck.tp[:language]       if @ck.tp[:language]       and @ck.tp[:language].length       >@ck.lt_language
      puts @ck.tp[:language_original].length.to_s + ' checklength ' + @ck.tp[:language_original] if @ck.tp[:language_original] and @ck.tp[:language_original].length >@ck.lt_language_original
      #puts @ck.tp[:language_char].length.to_s     + ' checklength ' + @ck.tp[:language_char]       if @ck.tp[:language_char]       and @ck.tp[:language_char].length       >@ck.lt_language_char
      #puts @ck.tp[:language_original_char].length.to_s + ' checklength ' + @ck.tp[:language_original_char]       if @ck.tp[:language_original_char]       and @ck.tp[:language_original_char].length       >@ck.lt_language_original_char
      puts @ck.tp[:relation].length.to_s       + ' checklength ' + @ck.tp[:relation]       if @ck.tp[:relation]       and @ck.tp[:relation].length       >@ck.lt_relation
      puts @ck.tp[:coverage].length.to_s       + ' checklength ' + @ck.tp[:coverage]       if @ck.tp[:coverage]       and @ck.tp[:coverage].length       >@ck.lt_coverage
      puts @ck.tp[:rights].length.to_s         + ' checklength ' + @ck.tp[:rights]         if @ck.tp[:rights]         and @ck.tp[:rights].length         >@ck.lt_rights
      puts @ck.tp[:copyright].length.to_s      + ' checklength ' + @ck.tp[:copyright]      if @ck.tp[:copyright]      and @ck.tp[:copyright].length      >@ck.lt_copyright
      puts @ck.tp[:owner].length.to_s          + ' checklength ' + @ck.tp[:owner]          if @ck.tp[:owner]          and @ck.tp[:owner].length          >@ck.lt_owner
      puts @ck.tp[:keywords].length.to_s       + ' checklength ' + @ck.tp[:keywords]       if @ck.tp[:keywords]       and @ck.tp[:keywords].length       >@ck.lt_keywords
      puts @ck.tp[:abstract].length.to_s       + ' checklength ' + @ck.tp[:abstract]       if @ck.tp[:abstract]       and @ck.tp[:abstract].length       >@ck.lt_abstract
      puts @ck.tp[:comment].length.to_s        + ' checklength ' + @ck.tp[:comment]        if @ck.tp[:comment]        and @ck.tp[:comment].length        >@ck.lt_comment
      puts @ck.tp[:loc].length.to_s            + ' checklength ' + @ck.tp[:loc]            if @ck.tp[:loc]            and @ck.tp[:loc].length            >@ck.lt_loc
      puts @ck.tp[:dewey].length.to_s          + ' checklength ' + @ck.tp[:dewey]          if @ck.tp[:dewey]          and @ck.tp[:dewey].length          >@ck.lt_dewey
      puts @ck.tp[:isbn].length.to_s           + ' checklength ' + @ck.tp[:isbn]           if @ck.tp[:isbn]           and @ck.tp[:isbn].length           >@ck.lt_isbn
      puts @ck.tp[:pg].length.to_s             + ' checklength ' + @ck.tp[:pg]             if @ck.tp[:pg]             and @ck.tp[:pg].length             >@ck.lt_pg
      puts @ck.tp[:date]                                                                   if @ck.tp[:date] !~/\d\d-\d\d-\d\d/
      end
    end
  end
  class Create<SiSU_DB::Column_size
    require SiSU_lib + '/sysenv'
    @@dl=nil
    def initialize(opt,conn='',sql_type='pg')
      @opt,@conn,@sql_type=opt,conn,sql_type
      @cX=SiSU_Screen::Ansi.new(@opt.cmd).cX
      @comment=comment
      @@dl ||=SiSU_Env::Info_dir.new.digest_length
    end
    def available
      DBI.available_drivers.each do |driver|
        puts "Driver: #{driver}"
        DBI.data_sources(driver).each do |dsn|
          puts "\tDatasource: #{dsn}"
        end
      end
    end
    def create_db
      @env=SiSU_Env::Info_dir.new(@opt.fns)
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'invert','Create PG db:',%{"SiSU_#{@env.output_stub}"})
      tell.colorize unless @opt.cmd =~/q/
      SiSU_Env::System_call.new.create_pg_db(@env.output_stub) #watch use of output_stub instead of stub
    end
    def comment
      @comment=Hash.new('')
      case @sql_type
      when /pg/
        @comment['metadata'] =%{
/*      CREATE SEQUENCE tid_seq START 1; */
        COMMENT ON Table metadata
          IS 'contains SiSU documents metadata with metadata';
        COMMENT ON COLUMN metadata.tid
          IS 'unique';
        COMMENT ON COLUMN metadata.filename
          IS 'document filename';
        COMMENT ON COLUMN metadata.title
          IS 'metadata title (dublin core element 1)';
        COMMENT ON COLUMN metadata.subtitle
          IS 'document subtitle';
        COMMENT ON COLUMN metadata.creator
          IS 'metadata creator (dublin core element 2)';
        COMMENT ON COLUMN metadata.illustrator
          IS 'metadata illustrator';
        COMMENT ON COLUMN metadata.translator
          IS 'metadata translator';
        COMMENT ON COLUMN metadata.subject
          IS 'metadata subject (dublin core element 3)';
        COMMENT ON COLUMN metadata.date
          IS 'metadata date (dublin core element 7)';
        COMMENT ON COLUMN metadata.date_created
          IS 'metadata date created (dublin core)';
        COMMENT ON COLUMN metadata.date_issued
          IS 'metadata date of issue (dublin core)';
        COMMENT ON COLUMN metadata.date_available
          IS 'metadata date available (dublin core)';
        COMMENT ON COLUMN metadata.date_valid
          IS 'metadata date valid (dublin core)';
        COMMENT ON COLUMN metadata.date_modified
          IS 'metadata date modified (dublin core)';
        COMMENT ON COLUMN metadata.type
          IS 'metadata type (dublin core element 8)';
        COMMENT ON COLUMN metadata.description
          IS 'metadata description (dublin core element 4)';
        COMMENT ON COLUMN metadata.publisher
          IS 'metadata publisher (dublin core element 5)';
        COMMENT ON COLUMN metadata.contributor
          IS 'metadata contributor (dublin core element 6)';
        COMMENT ON COLUMN metadata.prepared_by
          IS 'metadata markup prepared by';
        COMMENT ON COLUMN metadata.digitized_by
          IS 'metadata digitized by';
        COMMENT ON COLUMN metadata.format
          IS 'metadata format (dublin core element 9)';
        COMMENT ON COLUMN metadata.identifier
          IS 'metadata identifier (dublin core element 10)';
        COMMENT ON COLUMN metadata.source
          IS 'metadata source (dublin core element 11)';
        COMMENT ON COLUMN metadata.language
          IS 'metadata language (dublin core element 12)';
        COMMENT ON COLUMN metadata.language_original
          IS 'metadata original language';
        COMMENT ON COLUMN metadata.relation
          IS 'metadata  (dublin core element 13)';
        COMMENT ON COLUMN metadata.coverage
          IS 'metadata coverage (dublin core element 14)';
        COMMENT ON COLUMN metadata.rights
          IS 'metadata rights / copyright / license (dublin core element 15)';
        COMMENT ON COLUMN metadata.owner
          IS 'metadata owner';
        COMMENT ON COLUMN metadata.keywords
          IS 'metadata keywords';
        COMMENT ON COLUMN metadata.comment
          IS 'metadata comment';
        COMMENT ON COLUMN metadata.abstract
          IS 'metadata abstract';
        COMMENT ON COLUMN metadata.loc
          IS 'metadata library of congress';
        COMMENT ON COLUMN metadata.dewey
          IS 'metadata dewey';
        COMMENT ON COLUMN metadata.isbn
          IS 'metadata isbn';
        COMMENT ON COLUMN metadata.pg
          IS 'metadata project gutenberg number';
        COMMENT ON COLUMN metadata.prefix_a
          IS 'metadata prefix';
        COMMENT ON COLUMN metadata.prefix_b
          IS 'metadata prefix';
        COMMENT ON COLUMN metadata.skin
          IS 'metadata sisu skin';
        COMMENT ON COLUMN metadata.markup
          IS 'metadata markup source';
        COMMENT ON COLUMN metadata.links
          IS 'metadata links';
        COMMENT ON COLUMN metadata.information
          IS 'metadata information';
        COMMENT ON COLUMN metadata.contact
          IS 'metadata contact';
        COMMENT ON COLUMN metadata.suffix
          IS 'metadata sisu suffix (output related)';
        COMMENT ON COLUMN metadata.filename
          IS 'metadata source filename';
        COMMENT ON COLUMN metadata.types
          IS 'document types scroll 1, seg 2, both 3';
        COMMENT ON COLUMN metadata.subj
          IS 'subject areas - no way to populate at present as not mapped';
/*
        CREATE FUNCTION fileremoval() RETURNS opaque AS '
          BEGIN
            DELETE FROM metadata WHERE tid=#@removetid;
            DELETE FROM documents WHERE documents.metadata_tid=#@removetid;
            DELETE FROM endnotes WHERE endnotes.metadata_tid=#@removetid;
            DELETE FROM urls WHERE urls.metadata_tid=#@removetid;
          END;
        ' LANGUAGE 'plpgsql';
        CREATE TRIGGER removefile AFTER INSERT
        PROCEDURE fileremoval(); 
*/
        }
        @comment['documents'] =%{
        COMMENT ON Table documents
          IS 'contains searchable text of SiSU documents';
        COMMENT ON COLUMN documents.lid
          IS 'unique';
        COMMENT ON COLUMN documents.metadata_tid
          IS 'tie to title in metadata';
        COMMENT ON COLUMN documents.lev
          IS 'doc level 1-6 \d\~';
        COMMENT ON COLUMN documents.seg
          IS 'segment name from level 4';
        COMMENT ON COLUMN documents.ocn
          IS 'object citation number';
        COMMENT ON COLUMN documents.en_a
          IS 'first endnote number in text object (eg. NULL or 34) (used with en_z to create range)';
        COMMENT ON COLUMN documents.en_z
          IS 'last endnote number within text object (eg. NULL, 34 or say 47) (used with en_a to create range)';
        COMMENT ON COLUMN documents.types
          IS 'document types seg scroll';
        COMMENT ON COLUMN documents.clean
          IS 'text object - substantive text: clean, stripped of markup';
        COMMENT ON COLUMN documents.body
          IS 'text object - substantive text: light html markup';
        COMMENT ON COLUMN documents.lev1
          IS 'document structure, level 1';
        COMMENT ON COLUMN documents.lev2
          IS 'document structure, level 2';
        COMMENT ON COLUMN documents.lev3
          IS 'document structure, level 3';
        COMMENT ON COLUMN documents.lev4
          IS 'document structure, level 4';
        COMMENT ON COLUMN documents.lev5
          IS 'document structure, level 5';
        COMMENT ON COLUMN documents.lev6
          IS 'document structure, level 6';
/*      CREATE TABLE documents_trade (db NUMERIC(1)) INHERITS (documents); */
/*      CREATE TABLE documents_env (db NUMERIC(1)) INHERITS (documents); */
        }
        @comment['endnotes'] =%{
        COMMENT ON Table endnotes
          IS 'contains searchable text of SiSU documents endnotes';
        COMMENT ON COLUMN endnotes.nid
          IS 'unique';
        COMMENT ON COLUMN endnotes.document_lid
          IS 'ties to text block from which referenced';
        COMMENT ON COLUMN endnotes.nr
          IS 'endnote number <!e_(\d+)!>';
        COMMENT ON COLUMN endnotes.clean
          IS 'endnote substantive content, stripped of markup';
        COMMENT ON COLUMN endnotes.body
          IS 'endnote substantive content';
        COMMENT ON COLUMN endnotes.ocn
          IS 'object citation no# <\~(\d+)> from which endnote is referenced';
        COMMENT ON COLUMN documents.metadata_tid
          IS 'tie to title in metadata - unique for each document';
        }
        @comment['urls'] =%{
        COMMENT ON Table urls
          IS 'contains base url links to different SiSU output';
        COMMENT ON COLUMN documents.metadata_tid
          IS 'tie to title in metadata - unique for each document, the mapping of rows is one to one';
        COMMENT ON COLUMN urls.plaintext
          IS 'plaintext utf-8';
        COMMENT ON COLUMN urls.html_toc
          IS 'table of contents for segmented html document';
        COMMENT ON COLUMN urls.html_doc
          IS 'html document (scroll)';
        COMMENT ON COLUMN urls.xhtml
          IS 'xhtml document (scroll)';
        COMMENT ON COLUMN urls.xml_sax
          IS 'xml sax oriented document (scroll)';
        COMMENT ON COLUMN urls.xml_dom
          IS 'xml dom oriented document (scroll)';
        COMMENT ON COLUMN urls.odf
          IS 'opendocument format text';
        COMMENT ON COLUMN urls.pdf_p
          IS 'pdf portrait';
        COMMENT ON COLUMN urls.pdf_l
          IS 'pdf landscape';
        COMMENT ON COLUMN urls.concordance
          IS 'rudimentary document index linked to html';
        COMMENT ON COLUMN urls.latex_p
          IS 'latex portrait';
        COMMENT ON COLUMN urls.latex_l
          IS 'latex_landscape';
        COMMENT ON COLUMN urls.markup
          IS 'markup';
        COMMENT ON COLUMN urls.sisupod
          IS 'SiSU document format .tgz (all SiSU information on document)';
        }
      end
      @comment
    end
    def output_dir?
      dir=SiSU_Env::Info_dir.new('')
      if @opt.cmd =~/d/: dir.webserv_path_dir_stub_ensure
      end
    end
    def create_table_metadata
      print %{
        currently using sisu dbi module
        to be populated from documents files
        create tables metadata
        data import through ruby transfer
      } unless @opt.cmd =~/q/
      @conn.execute(%{
        CREATE TABLE metadata (
          tid               INT4 PRIMARY KEY,
          title             VARCHAR(#{lt_title}) NULL,
          subtitle          VARCHAR(#{lt_subtitle}) NULL,
          creator           VARCHAR(#{lt_creator}) NULL,
          illustrator       VARCHAR(#{lt_illustrator}) NULL,
          translator        VARCHAR(#{lt_translator}) NULL,
          subject           VARCHAR(#{lt_subject}) NULL,
          date              VARCHAR(#{lt_date}) NULL,
          date_created      VARCHAR(#{lt_date_created}) NULL,
          date_issued       VARCHAR(#{lt_date_issued}) NULL,
          date_available    VARCHAR(#{lt_date_available}) NULL,
          date_valid        VARCHAR(#{lt_date_valid}) NULL,
          date_modified     VARCHAR(#{lt_date_modified}) NULL,
/*        date              DATE, */
/*        date_created      DATE, */
/*        date_issued       DATE, */
/*        date_available    DATE, */
/*        date_valid        DATE, */
/*        date_modified     DATE, */
          type              VARCHAR(#{lt_type}) NULL,
          description       VARCHAR(#{lt_description}) NULL,
          publisher         VARCHAR(#{lt_publisher}) NULL,
          contributor       VARCHAR(#{lt_contributor}) NULL,
          prepared_by       VARCHAR(#{lt_prepared_by}) NULL,
          digitized_by      VARCHAR(#{lt_digitized_by}) NULL,
          format            VARCHAR(#{lt_format}) NULL,
          identifier        VARCHAR(#{lt_identifier}) NULL,
          source            VARCHAR(#{lt_source}) NULL,
          language          VARCHAR(#{lt_language}) NULL,
          language_original VARCHAR(#{lt_language_original}) NULL,
          relation          VARCHAR(#{lt_relation}) NULL,
          coverage          VARCHAR(#{lt_coverage}) NULL,
          rights            VARCHAR(#{lt_rights}) NULL,
          copyright         VARCHAR(#{lt_copyright}) NULL,
          owner             VARCHAR(#{lt_owner}) NULL,
          keywords          VARCHAR(#{lt_keywords}) NULL,
          comment           VARCHAR(#{lt_comment}) NULL,
          loc               VARCHAR(#{lt_loc}) NULL,
          dewey             VARCHAR(#{lt_dewey}) NULL,
          isbn              VARCHAR(#{lt_isbn}) NULL,
          pg                VARCHAR(#{lt_pg}) NULL,
          abstract          VARCHAR(#{lt_abstract}) NULL,
          prefix_a          TEXT NULL,
          prefix_b          TEXT NULL,
          skin              VARCHAR(#{lt_skin}) NULL,
          markup            VARCHAR(#{lt_markup}) NULL,
/*        toc               VARCHAR(100) NULL, */
          links             VARCHAR(#{lt_links}) NULL,
          information       VARCHAR(#{lt_information}) NULL,
          contact           VARCHAR(#{lt_contact}) NULL,
          suffix            VARCHAR(#{lt_suffix}) NULL,
          filename          VARCHAR(#{lt_filename}) NULL UNIQUE,
          types             CHAR(#{lt_types}) NULL,
          subj              VARCHAR(#{lt_subj}) NULL
        );
        #{@comment['metadata']}
      })
    end
    def create_table                                                             # create documents base
      print %{
        to be populated from documents files
        create tables documents document_trade document_env
        data import through ruby transfer
      } unless @opt.cmd =~/q/
      @conn.execute(%{
        CREATE TABLE documents (
          lid             INT4 PRIMARY KEY,
          metadata_tid      INT4 REFERENCES metadata,
          ocn             SMALLINT,
          ocnd            VARCHAR(6),
          ocns            VARCHAR(6),
          clean           TEXT NULL,
          body            TEXT NULL,
/*        clean           VARCHAR(#{document_clean}) NULL, */
/*        body            VARCHAR(#{document_body}) NULL, */
          seg             VARCHAR(#{document_seg}) NULL,
/*        lev             CHAR(1) NULL, */
          lev             SMALLINT NULL,
          lev1            SMALLINT,
          lev2            SMALLINT,
          lev3            SMALLINT,
          lev4            SMALLINT,
          lev5            SMALLINT,
          lev6            SMALLINT,
          en_a            SMALLINT NULL,
          en_z            SMALLINT NULL,
          digest_clean    CHAR(#{@@dl}),
          digest_all      CHAR(#{@@dl}),
          types           CHAR(1) NULL
        );
        #{@comment['documents']}
      })
    end
    def create_table_endnotes
      print %{
        to be populated from documents files
        create tables endnotes
        data import through ruby transfer
      } unless @opt.cmd =~/q/
      @conn.execute(%{
        CREATE TABLE endnotes (
          nid             INT4 PRIMARY KEY,
          document_lid    INT4 REFERENCES documents,
          nr              SMALLINT,
          clean           TEXT NULL,
          body            TEXT NULL,
/*        clean           VARCHAR(#{endnote_clean}) NULL, */
/*        body            VARCHAR(#{endnote_body}) NULL, */
          ocn             SMALLINT,
          ocnd            VARCHAR(6),
          ocns            VARCHAR(6),
          digest_clean    CHAR(#{@@dl}),
          metadata_tid    INT4 REFERENCES metadata
        );
        #{@comment['endnotes']}
      })
    end
    def create_table_urls                                                       # create documents file links mapping
      print %{
        currently using sisu dbi module
        to be populated from documents files
        create tables urls
        data import through ruby transfer
      } unless @opt.cmd =~/q/
      @conn.execute(%{
        CREATE TABLE urls (
/*        tid             INT4 PRIMARY KEY, */
          metadata_tid    INT4 REFERENCES metadata,
          plaintext       varchar(512),
          html_toc        varchar(512),
          html_doc        varchar(512),
          xhtml           varchar(512),
          xml_sax         varchar(512),
          xml_dom         varchar(512),
          odf             varchar(512),
          pdf_p           varchar(512),
          pdf_l           varchar(512),
          concordance     varchar(512),
/*        meta            varchar(512), */
          latex_p         varchar(512),
          latex_l         varchar(512),
          digest          varchar(512),
          manifest        varchar(512),
          markup          varchar(512),
          sisupod         varchar(512)
        );
        #{@comment['urls']}
      })
    end
    def create_indexes
    end
  end
  class Case
    def initialize(opt,conn='',sql_type='pg') 
      @opt,@conn,@sql_type=opt,conn,sql_type
      #@sdb=Create.new(@conn)
      @sdb=SiSU_DB::Create.new(@opt,@conn,@sql_type)
      @index=SiSU_DB::Index.new(@opt,@conn,@sql_type)
      @sdb_no=SiSU_DB::Drop.new(@opt,@conn,@sql_type)
      @sdb_import=SiSU_DB::Import.new(@opt,@conn,@sql_type) if @opt.mod_s =~/update|import/
      @remove=SiSU_DB::Remove.new(@opt,@conn) if @opt.mod_s =~/update|remove/
      @db=SiSU_Env::Info_db.new
    end
    def cases
      @opt.mod.each do |mod|
        case mod
        when /^--createdb$/
          @sdb.output_dir?
          begin
          @sdb.create_db
          rescue: @sdb.output_dir?
          end
        when /^--(?:init(?:ialize)?|create(?:all)?)$/
          @sdb.output_dir?
          #@sdb.create_db
          begin
          @sdb.create_table_metadata
          @sdb.create_table
          @sdb.create_table_endnotes
          @sdb.create_table_urls
          @index.create_indexes
          rescue: @sdb.output_dir?
          end
        when /^--createtable(s)?$/
          @sdb.output_dir?
          begin
          @sdb.create_table_metadata
          @sdb.create_table
          @sdb.create_table_endnotes
          @sdb.create_table_urls
          @index.create_indexes
          rescue: @sdb.output_dir?
          end
        when /^--recreate$/
          @sdb.output_dir?
          begin
          @sdb_no.drop_tables
          @sdb.create_table_metadata
          @sdb.create_table
          @sdb.create_table_endnotes
          @sdb.create_table_urls
          @index.create_indexes
          rescue: @sdb.output_dir?
          end
        when /^--cr(eate)?lex$/
          @sdb.output_dir?
          begin
          @sdb.create_table
          rescue: @sdb.output_dir?
          end
        when /^--cr(eate)?metadata$/
          @sdb.output_dir?
          begin
          @sdb.create_table_metadata
          rescue: @sdb.output_dir?
          end
        when /^--import$/
          @sdb_import.marshal_load
          tell=case @sql_type
          when /sqlite/: SiSU_Screen::Ansi.new(@opt.cmd,"sqlite #{@db.db_sqlite} database?")
          when /pg/:     SiSU_Screen::Ansi.new(@opt.cmd,"pgaccess or psql #{@db.db_psql} database?")
          else '???'
          end
          tell.puts_grey if @opt.cmd =~/v/
        when /^--remove$/
          @remove.remove
          #puts "#{@cX.grey}remove #@opt.fns#{@cX.off}"
        when /^--update$/
          @remove.remove
          @sdb_import.marshal_load
          tell=SiSU_Screen::Ansi.new(@opt.cmd,"pgaccess or psql #{@db.db_psql} database?")
          tell.puts_grey if @opt.cmd =~/v/
        when /^--index$/
          @index.create_indexes
        when /^droptable(s)?$/
          @sdb_no.drop_tables
        when /^--dropindex(es)?$/
          @sdb_no.drop_indexes
        when /^--(?:dropall|drop)$/
          @sdb_no.drop_tables
          #@sdb_no.drop_indexes
        else
          help=SiSU_Help::Help.new
          help.summary
          help.commands
        end
      end
      begin
      @conn.commit if @sql_type =~/sqlite/
      rescue: @sdb.output_dir?
      end
    end
  end
  class Index                                                                    # create documents Indexes
    def initialize(opt,conn='',sql_type='')
      @opt,@conn,@sql_type=opt,conn,sql_type
    end
    def create_indexes                                                           # check added from pg not tested
      print "
        create documents indexes
        create indexes for: [after populating dbase]
      " unless @opt.cmd =~/q/
      @conn.execute(%{
        CREATE INDEX object_nr ON documents(ocn);
/*      CREATE INDEX body ON documents(body); */
        CREATE INDEX clean ON documents(clean);
        CREATE INDEX digest_clean ON documents(digest_clean);
        CREATE INDEX digest_all ON documents(digest_all);
        CREATE INDEX lev1 ON documents(lev1);
        CREATE INDEX lev2 ON documents(lev2);
        CREATE INDEX lev3 ON documents(lev3);
        CREATE INDEX lev4 ON documents(lev4);
        CREATE INDEX lev5 ON documents(lev5);
        CREATE INDEX lev6 ON documents(lev6);
        CREATE INDEX endnote_nr ON endnotes(nr);
        CREATE INDEX endnote ON endnotes(clean);
        CREATE INDEX digest_en ON endnotes(digest_clean);
        CREATE INDEX title ON metadata(title);
        CREATE INDEX filename ON metadata(filename)
      }) unless @opt.cmd =~/q/
    end
  end
  class Drop
    def initialize(opt,conn='',sql_type='')
      @opt,@conn,@sql_type=opt,conn,sql_type
    end
    def drop_tables                                                              #% drop all tables
      begin
        case @sql_type
        when /sqlite/
          cascade=''
          commit=@conn.commit
        else
          cascade='CASCADE'
          commit=''
        end
        @conn.do(%{
          DROP TABLE metadata #{cascade};
          DROP TABLE documents #{cascade};
          DROP TABLE endnotes #{cascade};
          DROP TABLE urls #{cascade};
/*        DROP TABLE documents_trade; */
/*        DROP TABLE documents_env; */
/*        DROP SEQUENCE tid_seq;  */
        })
        commit
      rescue
      end
    end
    def drop_indexes                                                             #% drop all indexes
      #@conn.do(%{
      #  DROP INDEX object_nr ON documents(ocn);
      #  DROP INDEX body ON documents(body);
      #  DROP INDEX clean ON documents(clean);
      #  DROP INDEX lev1 ON documents(lev1);
      #  DROP INDEX lev2 ON documents(lev2);
      #  DROP INDEX lev3 ON documents(lev3);
      #  DROP INDEX lev4 ON documents(lev4);
      #  DROP INDEX lev5 ON documents(lev5);
      #  DROP INDEX lev6 ON documents(lev6);
      #  DROP INDEX endnote_nr ON endnotes(nr);
      #  DROP INDEX endnote ON endnotes(body);
      #  DROP INDEX title ON metadata(title);
      #  DROP INDEX filename ON metadata(filename)
      #  /*
      #  DROP INDEX object_nr ON documents(ocn) CASCADE;
      #  DROP INDEX body ON documents(body) CASCADE;
      #  DROP INDEX clean ON documents(clean) CASCADE;
      #  DROP INDEX lev1 ON documents(lev1) CASCADE;
      #  DROP INDEX lev2 ON documents(lev2) CASCADE;
      #  DROP INDEX lev3 ON documents(lev3) CASCADE;
      #  DROP INDEX lev4 ON documents(lev4) CASCADE;
      #  DROP INDEX lev5 ON documents(lev5) CASCADE;
      #  DROP INDEX lev6 ON documents(lev6) CASCADE;
      #  DROP INDEX endnote_nr ON endnotes(nr) CASCADE;
      #  DROP INDEX endnote ON endnotes(body) CASCADE;
      #  DROP INDEX title ON metadata(title) CASCADE;
      #  DROP INDEX filename ON metadata(filename) CASCADE
      #  */
      #})
    end
    def db_help                                                                  #% help
      puts    %{
        not yet implemented
        init createall
        createtable
        recreate\t(destroy and create)
        createlex\t()
        createmetadata\t()
        import\t(import data)
        index\t(create index)
        droptables\t(where tables made and content imported)
        dropall\t(where tables made, content imported and tables indexed)
      }
    end
  end
  class Remove
    def initialize(opt,conn='' )
      @opt,@conn=opt,conn
      @md=SiSU_Param::Parameters.new(@opt).get
      @fnb=@md.fnb
      @db=SiSU_Env::Info_db.new
    end
    def remove
      del=@conn.select_one(%{ SELECT tid FROM metadata WHERE filename LIKE '#{@opt.fns}'; })
      #del=@conn.select_one(%{ SELECT metadata.tid WHERE metadata.filename LIKE '#{@opt.fns}'; })
      if del
        del_id=del.join 
        #@conn.execute("BEGIN")
        @conn.execute(%{
          DELETE FROM endnotes WHERE metadata_tid LIKE '#{del_id}';
          DELETE FROM documents WHERE metadata_tid LIKE '#{del_id}';
          DELETE FROM urls WHERE metadata_tid LIKE '#{del_id}';
          DELETE FROM metadata WHERE tid LIKE '#{del_id}';
          /*
          DELETE FROM documents WHERE documents.metadata_tid LIKE '#{del_id}';
          DELETE FROM endnotes WHERE endnotes.metadata_tid LIKE '#{del_id}';
          DELETE FROM urls WHERE urls.metadata_tid LIKE '#{del_id}';
          DELETE FROM metadata WHERE metadata.tid LIKE '#{del_id}';
          */
        })
        #@conn.execute("COMMIT")
      else
        tell=SiSU_Screen::Ansi.new(@opt.cmd,"no such file in database #{@db.db_psql}::#{@opt.fns}")
        tell.puts_grey #if @opt.cmd.include? ?v
      end
    end
  end
  class Load_tuple                                                               #% main database populate
    require SiSU_lib + '/param'
    include SiSU_Param
    def initialize(conn,col,opt)
      @conn,@col,@opt=conn,col,opt
      @col[:lev]=@col[:lev].to_i
      @col[:lev]=0 unless @col[:lev]=~/[1-6]/ or @col[:lev]==1 or @col[:lev]==2 or @col[:lev]==3 or @col[:lev]==4 or @col[:lev]==5 or @col[:lev]==6 #changed from \d+ ??
      @col[:ocn]=0 unless @col[:ocn]=~/\d+/
      #@col[:ocn]=@col[:ocn].to_i
      @cX=SiSU_Screen::Ansi.new(@opt.cmd).cX
    end
    def tuple                                                                    #% import line
      begin
        if @col[:en_a]
          #puts "#{@col[:lid]}, #{@col[:tid]}, #{@col[:lev]}, '#{@col[:plaintext]}', '#{@col[:body]}', '#{@col[:ocn]}', '#{@col[:ocnd]}', '#{@col[:ocns]}', '#{@col[:seg]}', '#{@col[:lv1]}', '#{@col[:lv2]}', '#{@col[:lv3]}', '#{@col[:lv4]}', '#{@col[:lv5]}', '#{@col[:lv6]}', '#{@col[:en_a]}', '#{@col[:en_z]}'"
          @conn.execute(%{
          INSERT INTO documents (lid, metadata_tid, lev, clean, body, ocn, ocnd, ocns, seg, lev1, lev2, lev3, lev4, lev5, lev6, en_a, en_z, digest_clean, digest_all) VALUES (#{@col[:lid]}, #{@col[:tid]}, #{@col[:lev]}, '#{@col[:plaintext]}', '#{@col[:body]}', '#{@col[:ocn]}', '#{@col[:ocnd]}', '#{@col[:ocns]}', '#{@col[:seg]}', '#{@col[:lv1]}', '#{@col[:lv2]}', '#{@col[:lv3]}', '#{@col[:lv4]}', '#{@col[:lv5]}', '#{@col[:lv6]}', '#{@col[:en_a]}', '#{@col[:en_z]}', '#{@col[:digest_clean]}', '#{@col[:digest_all]}');
        })
        else
          #puts "#{@col[:lid]}, #{@col[:tid]}, #{@col[:lev]}, '#{@col[:plaintext]}', '#{@col[:body]}', '#{@col[:ocn]}', '#{@col[:ocnd]}', '#{@col[:ocns]}', '#{@col[:seg]}', '#{@col[:lv1]}', '#{@col[:lv2]}', '#{@col[:lv3]}', '#{@col[:lv4]}', '#{@col[:lv5]}', '#{@col[:lv6]}'"
          @conn.execute(%{
          INSERT INTO documents (lid, metadata_tid, lev, clean, body, ocn, ocnd, ocns, seg, lev1, lev2, lev3, lev4, lev5, lev6, digest_clean, digest_all) VALUES (#{@col[:lid]}, #{@col[:tid]}, #{@col[:lev]}, '#{@col[:plaintext]}', '#{@col[:body]}', '#{@col[:ocn]}', '#{@col[:ocnd]}', '#{@col[:ocns]}', '#{@col[:seg]}', '#{@col[:lv1]}', '#{@col[:lv2]}', '#{@col[:lv3]}', '#{@col[:lv4]}', '#{@col[:lv5]}', '#{@col[:lv6]}', '#{@col[:digest_clean]}', '#{@col[:digest_all]}');
        })
        end
        if @opt.cmd =~/v/ 
          if @col[:lev].to_s =~/[1235678]/ 
            puts %{#{@col[:lev]}>\t#{@col[:lv1]}\t#{@col[:lv2]}\t#{@col[:lv3]}\t#{@col[:lv4]}\t#{@col[:lv5]}\t#{@col[:lv6]}\t#{@col[:ocn]}\t#{@col[:ocnd]}\t#{@col[:ocns]}}
          elsif @col[:lev].to_s =~/[4]/
            puts %{#{@cX.green}#{@col[:lev]}>#{@cX.off}\t#{@col[:lv1]}\t#{@col[:lv2]}\t#{@col[:lv3]}\t#{@col[:lv4]}\t#{@col[:lv5]}\t#{@col[:lv6]}\t#{@col[:ocn]}\t#{@col[:ocnd]}\t#{@col[:ocns]}\t#{@col[:seg]}} 
          end
        end
      rescue: SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
        #@conn.execute("COMMIT")
      end
    end
  end
  class Import<SiSU_DB::Column_size                                              #% main
    include SiSU_Param
    include SiSU_Screen
    @@dl=nil
    attr_accessor :tp
    def initialize(opt,conn='',sql_type='pg')
      @opt,@conn,@sql_type=opt,conn,sql_type
      @cX=SiSU_Screen::Ansi.new(@opt.cmd).cX
      @env=SiSU_Env::Info_dir.new(@opt.fns)
      @metaverse="#{@env.metaverse}"
      if @opt.fns.empty? or @opt.cmd.empty?: @fnb=''
      else
        @md=SiSU_Param::Parameters.new(@opt).get
        @fnb=@md.fnb
      end
      @suffix=@opt.fns[/(?:.+?)\.[_-]?sst/,1]
      @fnm="#@metaverse/#{@opt.fns}.meta.rbm"
      @@seg=''
      @@seg_full=''                                                              #create? consider placing field just before clean text as opposed to seg which contains seg(.html) name info seg_full would contain seg info for levels 5 & 6 where available eg seg_full may be 7.3 (level 5) and 7.3.1 (level 6) where seg  is 7
      @col=Hash.new('')
      @col[:ocn]=''
      @counter=Hash.new
      sql='SELECT MAX(lid) FROM documents'
      @col[:lid]=@conn.execute( sql ) { |x| x.fetch_all.to_s.to_i }
      @col[:lid] ||=0
      sql='SELECT MAX(nid) FROM endnotes'
      @id_n=@conn.execute( sql ) { |x| x.fetch_all.to_s.to_i } 
      @id_n ||=0
      @col[:lv1]=@col[:lv2]=@col[:lv3]=@col[:lv4]=@col[:lv5]=@col[:lv6]=0
      @db=SiSU_Env::Info_db.new
      @@dl ||=SiSU_Env::Info_dir.new.digest_length
    end
    def marshal_load
      require SiSU_lib + '/metaverse'
      @metaverse_array=SiSU_Metaverse::Source.new(@opt).get                  # metaverse file drawn here
      #@metaverse_array.each { |x| p x; sleep 1 }
      tell=SiSU_Screen::Ansi.new(@opt.cmd,"#{@db.db_psql}::#{@opt.fns}")
      tell.puts_blue unless @opt.cmd =~/q/
      tell=SiSU_Screen::Ansi.new(@opt.cmd,'Marshal Load',@fnm)
      tell.print_grey if @opt.cmd =~/v/
      case @sql_type 
      when /sqlite/                                                              #fix logic for sqlite !
        import_db_metadata(@metaverse_array)
        import_documents(@metaverse_array)
        import_db_urls(@metaverse_array,@fnm)                                     #import OID on/off
        @conn.commit                                                             #sqlite watch
      else
        file_exist=@conn.select_one(%{ SELECT metadata.tid FROM metadata WHERE metadata.filename ~ '#{@opt.fns}'; })
        unless file_exist
          @conn.execute('BEGIN')
          import_db_metadata(@metaverse_array)
          import_documents(@metaverse_array)
          import_db_urls(@metaverse_array,@fnm)                                   #import OID on/off
          @conn.execute('COMMIT')
        else
          @db=SiSU_Env::Info_db.new
          puts "\n#{@cX.grey}file #{@cX.off} #{@cX.blue}#{@opt.fns}#{@cX.off} #{@cX.grey}already exists in database#{@cX.off} #{@cX.blue}#{@db.db_psql}#{@cX.off} #{@cX.brown}update instead?#{@cX.off}"
        end
      end
    end
    def special_character_escape(string)
      string.gsub!(/'/,"''")
      string.gsub!(/<:br>/, "<br />\n")
      string.gsub!(/<:(?:code|alt|group|poem)(?:-end)?>/, '')
    end
    def unicode_special_character_escape(string)
      #string.gsub!(/(["';:,])/, %{\\\\\\1})
    end
    #def html_table(string)
    #end
    def strip_markup(string) #define rules, make same as in metaverse clean
      string.gsub!(/<sup>(\d+)<\/sup>/i,"[\\1]")
      string.gsub!(/<:i[12]>/,'')
      string.gsub!(/(?:&nbsp\\;)+/i,' ')
      string.gsub!(/<!T[h]?¡.+?!>/, "[TABLE]\n")                                #tables
      string.gsub!(/<!¡¡\d+(.+?)!>/,'\1')                                       #tables
      string.gsub!(/¡¡\d+¡/,' ')                                                #tables
      string.gsub!(/¡/,' ')                                                     #tables tidy later
      string.gsub!(/<.+?>/,'')
      string.gsub!(/\{.+?\.(?:png|jpg).+?\}(?:https?|ftp)\\\:\S+ /,' [image] ')           # else image names found in search
      string.gsub!(/\s\s+/,' ')
      string.strip!
    end
                                                                                 #% import into database tables
    def import_db_metadata(dbi_unit)                                               #% import documents - populate database
      print %{ #{@cX.grey}import documents dbi_unit #{@cX.off} } unless @opt.cmd =~/q/
      @tp=Hash.new
      @md=SiSU_Param::Parameters.new(@opt).get
      if @md.title: @tp[:title]=@md.title
        special_character_escape(@tp[:title])
        @tp[:title_f],@tp[:title_i]='title, ',"'#{@tp[:title]}', "
        sql="SELECT MAX(tid) FROM metadata"
        id_t=@conn.execute( sql ) { |x| x.fetch_all.to_s.to_i }
        @@id_t=id_t if id_t
        @@id_t ||=0
        @@id_t+=1 #bug related, needs to be performed once at start of file, but consider moving, as, placed here it means program will fail if document header lacks 0~title
        puts %{\n#{@cX.grey}Processing file number#{@cX.off}: #{@cX.green}#{@@id_t}#{@@cX.off}} unless @opt.cmd =~/q/
      end
      if @md.dc_title: @tp[:long_title]=@md.dc_title
        #sql="SELECT MAX(tid) FROM metadata"
        #id_t=@conn.execute( sql ) { |x| x.fetch_all.to_s.to_i }
        #@@id_t=id_t if id_t
        #@@id_t ||=0
        #@@id_t+=1 #bug related, needs to be performed once at start of file, but consider moving, as, placed here it means program will fail if document header lacks 0~title
        #puts %{\n#{@cX.grey}Processing file number#{@cX.off}: #{@cX.green}#{@@id_t}#{@@cX.off}}
      end
      if @md.subtitle: @tp[:subtitle]=@md.subtitle
        special_character_escape(@tp[:subtitle])
        @tp[:subtitle_f],@tp[:subtitle_i]='subtitle, ',"'#{@tp[:subtitle]}', "
      end
      if @md.dc_creator: @tp[:creator]=@md.dc_creator
        special_character_escape(@tp[:creator])
        @tp[:creator_f],@tp[:creator_i]='creator, ',"'#{@tp[:creator]}', "
      end
      if @md.dc_contributor: @tp[:contributor]=@md.dc_contributor
        special_character_escape(@tp[:contributor])
        @tp[:contributor_f],@tp[:contributor_i]='contributor, ',"'#{@tp[:contributor]}', "
      end
      if @md.translator: @tp[:translator]=@md.translator
        special_character_escape(@tp[:translator])
        @tp[:translator_f],@tp[:translator_i]='translator, ',"'#{@tp[:translator]}', "
      end
      if @md.illustrator: @tp[:illustrator]=@md.illustrator
        special_character_escape(@tp[:illustrator])
        @tp[:illustrator_f],@tp[:illustrator_i]='illustrator, ',"'#{@tp[:illustrator]}', "
      end
      if @md.dc_publisher: @tp[:publisher]=@md.dc_publisher
        special_character_escape(@tp[:publisher])
        @tp[:publisher_f],@tp[:publisher_i]='publisher, ',"'#{@tp[:publisher]}', "
      end
      if @md.prepared_by: @tp[:prepared_by]=@md.prepared_by
        special_character_escape(@tp[:prepared_by])
        @tp[:prepared_by_f],@tp[:prepared_by_i]='prepared_by, ',"'#{@tp[:prepared_by]}', "
      end
      if @md.digitized_by: @tp[:digitized_by]=@md.digitized_by
        special_character_escape(@tp[:digitized_by])
        @tp[:digitized_by_f],@tp[:digitized_by_i]='digitized_by, ',"'#{@tp[:digitized_by]}', "
      end
      if @md.dc_subject: @tp[:subject]=@md.dc_subject
        special_character_escape(@tp[:subject])
        @tp[:subject_f],@tp[:subject_i]='subject, ',"'#{@tp[:subject]}', "
      end
      if @md.dc_description: @tp[:description]=@md.dc_description
        special_character_escape(@tp[:description])
        @tp[:description_f],@tp[:description_i]='description, ',"'#{@tp[:description]}', "
      end
      if @md.abstract: @tp[:abstract]=@md.abstract
        special_character_escape(@tp[:abstract])
        @tp[:abstract_f],@tp[:abstract_i]='abstract, ',"'#{@tp[:abstract]}', "
      end
      if @md.dc_type: @tp[:type]=@md.dc_type
        special_character_escape(@tp[:type])
        @tp[:type_f],@tp[:type_i]='type, ',"'#{@tp[:type]}', "
      end
      #if @md.owner: @tp[:owner]=@md.owner
      #  special_character_escape(@tp[:owner])
      #  @tp[:owner_f],@tp[:owner_i]='owner, ',"'#{@tp[:owner}', "
      #end
      #if @md.copyright: @tp[:copyright]=@md.copyright
      #  special_character_escape(@tp[:copyright])
      #  @tp[:copyright_f],@tp[:copyright_i]='copyright, ',"'#{@tp[:copyright]}', "
      #end
      if @md.dc_rights: @tp[:rights]=@md.dc_rights
        special_character_escape(@tp[:rights])
        @tp[:rights_f],@tp[:rights_i]='rights, ',"'#{@tp[:rights]}', "
      end
      if @md.dc_date: @tp[:date]=@md.dc_date
        special_character_escape(@tp[:date])
        @tp[:date_f],@tp[:date_i]='date, ',"'#{@tp[:date]}', "
      end
      if @md.dc_date_created: @tp[:date_created]=@md.dc_date_created
        special_character_escape(@tp[:date_created])
        @tp[:date_created_f],@tp[:date_created_i]='date_created, ',"'#{@tp[:date_created]}', "
      end
      if @md.dc_date_issued: @tp[:date_issued]=@md.dc_date_issued
        special_character_escape(@tp[:date_issued])
        @tp[:date_issued_f],@tp[:date_issued_i]='date_issued, ',"'#{@tp[:date_issued]}', "
      end
      if @md.dc_date_available: @tp[:date_available]=@md.dc_date_available
        special_character_escape(@tp[:date_available])
        @tp[:date_available_f],@tp[:date_available_i]='date_available, ',"'#{@tp[:date_available]}', "
      end
      if @md.dc_date_modified: @tp[:date_modified]=@md.dc_date_modified
        special_character_escape(@tp[:date_modified])
        @tp[:date_modified_f],@tp[:date_modified_i]='date_modified, ',"'#{@tp[:date_modified]}', "
      end
      if @md.dc_date_valid: @tp[:date_valid]=@md.dc_date_valid
        special_character_escape(@tp[:date_valid])
        @tp[:date_valid_f],@tp[:date_valid_i]='date_valid, ',"'#{@tp[:date_valid]}', "
      end
      if @md.dc_language[:name]: @tp[:language]=@md.dc_language[:name]
        special_character_escape(@tp[:language])
        @tp[:language_f],@tp[:language_i]='language, ',"'#{@tp[:language]}', "
      end
      if @md.language_original[:name]: @tp[:language_original]=@md.language_original[:name]
        special_character_escape(@tp[:language_original])
        @tp[:language_original_f],@tp[:language_original_i]='language_original, ',"'#{@tp[:language_original]}', "
      end
      if @md.dc_format: @tp[:format]=@md.dc_format
        special_character_escape(@tp[:format])
        @tp[:format_f],@tp[:format_i]='format, ',"'#{@tp[:format]}', "
      end
      if @md.dc_identifier: @tp[:identifier]=@md.dc_identifier
        special_character_escape(@tp[:identifier])
        @tp[:identifier_f],@tp[:identifier_i]='identifier, ',"'#{@tp[:identifier]}', "
      end
      if @md.dc_source: @tp[:source]=@md.dc_source
        special_character_escape(@tp[:source])
        @tp[:source_f],@tp[:source_i]='source, ',"'#{@tp[:source]}', "
      end
      if @md.dc_relation: @tp[:relation]=@md.dc_relation
        special_character_escape(@tp[:relation])
        @tp[:relation_f],@tp[:relation_i]='relation, ',"'#{@tp[:relation]}', "
      end
      if @md.dc_coverage: @tp[:coverage]=@md.dc_coverage
        special_character_escape(@tp[:coverage])
        @tp[:coverage_f],@tp[:coverage_i]='coverage, ',"'#{@tp[:coverage]}', "
      end
      if @md.keywords: @tp[:keywords]=@md.keywords
        special_character_escape(@tp[:keywords])
        @tp[:keywords_f],@tp[:keywords_i]='keywords, ',"'#{@tp[:keywords]}', "
      end
      if @md.comments: @tp[:comments]=@md.comments
        special_character_escape(@tp[:comments])
        @tp[:comments_f],@tp[:comments_i]='comments, ',"'#{@tp[:comments]}', "
      end
      if @md.cls_loc: @tp[:cls_loc]=@md.cls_loc
        special_character_escape(@tp[:cls_loc])
        @tp[:cls_loc_f],@tp[:cls_loc_i]='cls_loc, ',"'#{@tp[:cls_loc]}', "
      end
      if @md.cls_dewey: @tp[:cls_dewey]=@md.cls_dewey
        special_character_escape(@tp[:cls_dewey])
        @tp[:cls_dewey_f],@tp[:cls_dewey_i]='cls_dewey, ',"'#{@tp[:cls_dewey]}', "
      end
      if @md.cls_pg: @tp[:cls_pg]=@md.cls_pg
        special_character_escape(@tp[:cls_pg])
        @tp[:cls_pg_f],@tp[:cls_pg_i]='cls_pg, ',"'#{@tp[:cls_pg]}', "
      end
      if @md.cls_isbn: @tp[:cls_isbn]=@md.cls_isbn
        special_character_escape(@tp[:cls_isbn])
        @tp[:cls_isbn_f],@tp[:cls_isbn_i]='cls_isbn, ',"'#{@tp[:cls_isbn]}', "
      end
      if @md.prefix_a: @tp[:prefix_a]=@md.prefix_a
        special_character_escape(@tp[:prefix_a])
        @tp[:prefix_a_f],@tp[:prefix_a_i]='prefix_a, ',"'#{@tp[:prefix_a]}', "
      end
      if @md.prefix_b: @tp[:prefix_b]=@md.prefix_b
        special_character_escape(@tp[:prefix_b])
        @tp[:prefix_b_f],@tp[:prefix_b_i]='prefix_b, ',"'#{@tp[:prefix_b]}', "
      end
      #if @md.suffix: @tp[:suffix]=@md.suffix
      #  special_character_escape(@tp[:suffix])
      #  @tp[:suffix_f],@tp[:suffix_i]='suffix, ',"'#{@tp[:suffix]}', "
      #end
      if @md.fns: @tp[:fns]=@md.fns
        special_character_escape(@tp[:fns])
        @tp[:fns_f],@tp[:fns_i]="filename, ","'#{@tp[:fns]}', "
      end
      #if @md.en[:mismatch] > 0
      #  id,info='WARNING document error in endnote markup, number mismatch',"endnotes: #{@md.en[:note]} != endnote reference marks: #{@md.en[:mark]} (difference = #{@md.en[:mismatch]})"
      #end
      if @md.wc_words: @tp[:wc_words]=@md.wc_words
        @tp[:wc_words_f],@tp[:wc_words_i]='wc_words, ',"'#{@tp[:wc_words]}', "
      end
      if @md.dgst: @tp[:dgst]=@md.dgst
        @tp[:dgst_f],@tp[:dgst_i]='dgst, ',"'#{@tp[:dgst]}', "
      end
      if @md.sc_number: @tp[:sc_number]=@md.sc_number
        @tp[:sc_number_f],@tp[:sc_number_i]='sc_number, ',"'#{@tp[:sc_number]}', "
      end
      if @md.sc_date: @tp[:sc_date]=@md.sc_date
        @tp[:sc_date_f],@tp[:sc_date_i]='sc_date', ',"'#{@tp[:sc_date]}', "
      end
      if @md.generated: @tp[:generated]=@md.generated
        @tp[:generated_f],@tp[:generated_i]='generated, ',"'#{@tp[:generated]}', "
      end
      #if @md.sisu_version:                    special_character_escape(@md.sisu_version)
      #  #id,info='Generated by',"#{@md.sisu_version[:project]} #{@md.sisu_version[:version]} #{@md.sisu_version[:date_stamp]} (#{@md.sisu_version[:date]})"
      #end
      #if @md.ruby_version:                      special_character_escape(@md.ruby_version)
      SiSU_DB::Test.new(self,@opt).verify                                             #% import title names, filenames (tuple)
      @conn.execute(%{
        INSERT INTO metadata (#{@tp[:fns_f]} #{@tp[:suffix_f]} #{@tp[:title_f]} #{@tp[:subtitle_f]} #{@tp[:creator_f]} #{@tp[:illustrator_f]} #{@tp[:translator_f]} #{@tp[:subject_f]} #{@tp[:description_f]} #{@tp[:publisher_f]} #{@tp[:contributor_f]} #{@tp[:prepared_by_f]} #{@tp[:digitized_by_f]} #{@tp[:date_f]} #{@tp[:date_created_f]} #{@tp[:date_issued_f]} #{@tp[:date_valid_f]} #{@tp[:date_available_f]} #{@tp[:date_modified_f]} #{@tp[:type_f]} #{@tp[:format_f]} #{@tp[:identifier_f]} #{@tp[:source_f]} #{@tp[:language_f]} #{@tp[:language_original_f]} #{@tp[:relation_f]} #{@tp[:coverage_f]} #{@tp[:rights_f]} #{@tp[:copyright_f]} #{@tp[:owner_f]} #{@tp[:keywords_f]} #{@tp[:abstract_f]} #{@tp[:comment_f]} #{@tp[:loc_f]} #{@tp[:dewey_f]} #{@tp[:isbn_f]} #{@tp[:pg_f]} #{@tp[:prefix_a_f]} #{@tp[:prefix_b_f]} tid) VALUES (#{@tp[:fns_i]} #{@tp[:suffix_i]} #{@tp[:title_i]} #{@tp[:subtitle_i]} #{@tp[:creator_i]} #{@tp[:illustrator_i]} #{@tp[:translator_i]} #{@tp[:subject_i]} #{@tp[:description_i]} #{@tp[:publisher_i]} #{@tp[:contributor_i]} #{@tp[:prepared_by_i]} #{@tp[:digitized_by_i]} #{@tp[:date_i]} #{@tp[:date_created_i]} #{@tp[:date_issued_i]} #{@tp[:date_valid_i]} #{@tp[:date_available_i]} #{@tp[:date_modified_i]} #{@tp[:type_i]} #{@tp[:format_i]} #{@tp[:identifier_i]} #{@tp[:source_i]} #{@tp[:language_i]} #{@tp[:language_original_i]} #{@tp[:relation_i]} #{@tp[:coverage_i]} #{@tp[:rights_i]} #{@tp[:copyright_i]} #{@tp[:owner_i]} #{@tp[:keywords_i]} #{@tp[:abstract_i]} #{@tp[:comment_i]} #{@tp[:loc_i]} #{@tp[:dewey_i]} #{@tp[:isbn_i]} #{@tp[:pg_i]} #{@tp[:prefix_a_i]} #{@tp[:prefix_b_i]} #{@@id_t});
      })
    end
    def import_documents(dbi_unit)                                                     #% import documents - populate main database table
                                                                                 #% import into substantive database tables (tuple)
      begin
        @col[:tid]=@@id_t
        @en=Array.new
        @col[:en_a]=nil
        @col[:en_z]=nil
        dbi_unit.each do |data|
          data.gsub!(/<[biu]>(.+?)<\/[biu]>/,'\1')                             # remove bold, italics, underscore
          @col[:seg]=@@seg
          if data =~/<~\d+;(?:\w|[0-6]:)\d+;\w\d+><[0-9a-f]{#{@@dl}}:[0-9a-f]{#{@@dl}}>/m                                                    # regular text
            notedata=data.dup
            if data[/^([123])~\s+(.+?)<~(\d+);((?:\w|[0-6]:)\d+);(\w\d+)><([0-9a-f]{#{@@dl}}):([0-9a-f]{#{@@dl}})>/]
              @col[:lev],txt,@col[:ocn],@col[:ocnd],@col[:ocns],@col[:digest_clean],@col[:digest_all]=$1,$2,$3,$4,$5,$6,$7
              @col[:lid]+=1
              if txt =~/~\{.+?\}~/
                word_mode=txt.scan(/\S+/)
                endnote_range(word_mode)
                @en << txt.scan(/~\{(\d+).+?\}~/)
                txt.gsub!(/~\{(\d+).+?\}~/,"<sup>\\1</sup>")
              end
              @col[:body]=SiSU_Format_Shared::CSS_Format.new(txt,@col[:ocn],@col[:lev]).lev4_minus
              special_character_escape(@col[:body])
              @col[:plaintext]=@col[:body].dup
              strip_markup(@col[:plaintext])
              if @en[0]: @en_a,@en_z = @en[0].first,@en[0].last
              end
              t=Load_tuple.new(@conn,@col,@opt)
              t.tuple
              case @col[:lev]
              when /1/: @col[:lv1]+=1
              when /2/: @col[:lv2]+=1
              when /3/: @col[:lv3]+=1
              end
              @col[:lev]=@col[:plaintext]=@col[:body]=''
            elsif data[/4~(.+?)\s+(.+?)<~(\d+);((?:\w|[0-6]:)\d+);(\w\d+)><([0-9a-f]{#{@@dl}}):([0-9a-f]{#{@@dl}})>/]                                 #data =~ /^\s*4\{~\S+.+?<~\d+>/ # header lev4 seg level
              @@seg,txt,@col[:ocn],@col[:ocnd],@col[:ocns],@col[:digest_clean],@col[:digest_all]=$1,$2,$3,$4,$5,$6,$7
              @col[:seg]=@@seg
              @col[:lv4]+=1
              @col[:lid]+=1
              @col[:lev]=4
              if txt =~ /~\{.+?\}~/
                word_mode=txt.scan(/\S+/)
                endnote_range(word_mode)
                @en << txt.scan(/~\{(\d+).+?\}~/)
                txt.gsub!(/~\{(\d+).+?\}~/,"<sup>\\1</sup>")
              end
              @col[:body]=SiSU_Format_Shared::CSS_Format.new(txt,@col[:ocn],@col[:lev],@col[:seg]).lev4_plus
              special_character_escape(@col[:body])
              @col[:plaintext]=@col[:body].dup
              strip_markup(@col[:plaintext])
              if @en[0]: @en_a,@en_z = @en[0].first,@en[0].last
              end
              t=Load_tuple.new(@conn,@col,@opt)
              t.tuple
              @col[:lev]=@col[:plaintext]=@col[:body]=''
            elsif data[/^5~(?:~\S+)?(.+?)<~(\d+);((?:\w|[0-6]:)\d+);(\w\d+)><([0-9a-f]{#{@@dl}}):([0-9a-f]{#{@@dl}})>/]                             # header lev5 seg level
              txt,@col[:ocn],@col[:ocnd],@col[:ocns],@col[:digest_clean],@col[:digest_all]=$1,$2,$3,$4,$5,$6
              re=/5~(.+?)\s+/
              @@seg_full=re.match(data)[1] if data=~re #create?
              @@seg ||='' #nil # watch
              @col[:seg]=@@seg
              @col[:lv5]+=1
              @col[:lid]+=1
              @col[:lev]=5
              if txt =~ /~\{.+?\}~/
                word_mode=txt.scan(/\S+/)
                endnote_range(word_mode)
                @en << txt.scan(/~\{(\d+).+?\}~/)
                txt.gsub!(/~\{(\d+).+?\}~/,"<sup>\\1</sup>")
              end
              @col[:body]=SiSU_Format_Shared::CSS_Format.new(txt,@col[:ocn],@col[:ocnd],@col[:ocns],@col[:lev],@col[:seg]).lev4_plus
              special_character_escape(@col[:body])
              @col[:plaintext]=@col[:body].dup
              strip_markup(@col[:plaintext])
              if @en[0]: @en_a,@en_z = @en[0].first,@en[0].last
              end
              t=Load_tuple.new(@conn,@col,@opt)
              t.tuple
              @col[:lev]=@col[:plaintext]=@col[:body]=''
            elsif data[/^6~(?:~\S+)?(.+?)<~(\d+);((?:\w|[0-6]:)\d+);(\w\d+)><([0-9a-f]{#{@@dl}}):([0-9a-f]{#{@@dl}})>/] # header lev6 seg level
              txt,@col[:ocn],@col[:ocnd],@col[:ocns],@col[:digest_clean],@col[:digest_all]=$1,$2,$3,$4,$5,$6
              re=/6~(.+?)\s+/
              @@seg_full=re.match(data)[1] if data=~re #create?
              @@seg ||='' #nil # watch
              @col[:seg]=@@seg
              @col[:lv6]+=1
              @col[:lid]+=1
              @col[:lev]=6
              if txt =~ /~\{.+?\}~/
                word_mode=txt.scan(/\S+/)
                endnote_range(word_mode)
                @en << txt.scan(/~\{(\d+).+?\}~/)
                txt.gsub!(/~\{(\d+).+?\}~/,"<sup>\\1</sup>")
                #txt.gsub!(/~\{(\d+).+?\}~/,"^[\\1]")
              end
              @col[:body]=SiSU_Format_Shared::CSS_Format.new(txt,@col[:ocn],@col[:ocnd],@col[:ocns],@col[:lev],@col[:seg]).lev4_plus
              special_character_escape(@col[:body])
              @col[:plaintext]=@col[:body].dup
              strip_markup(@col[:plaintext])
              if @en[0]: @en_a,@en_z = @en[0].first,@en[0].last
              end
              t=Load_tuple.new(@conn,@col,@opt)
              t.tuple
              @col[:lev]=@col[:plaintext]=@col[:body]=''
            else                                                                 #{ regular text
              @col[:lid]+=1
              txt=''
              txt,@col[:ocn],@col[:ocnd],@col[:ocns],@col[:digest_clean],@col[:digest_all]=(/(.+?)<~(\d+);((?:\w|[0-6]:)\d+);(\w\d+)><([0-9a-f]{#{@@dl}}):([0-9a-f]{#{@@dl}})>/m).match(data).captures
              if txt =~ /~\{.+?\}~/
                word_mode=txt.scan(/\S+/)
                endnote_range(word_mode)
                @en << txt.scan(/~\{(\d+).+?\}~/)
                txt.gsub!(/~\{(\d+).+?\}~/,"<sup>\\1</sup>")
                #txt.gsub!(/~\{(\d+).+?\}~/,"^[\\1]") # remove endnote, keep endnote reference number, display as, e.g. [^1]
              end
              if @sql_type=~/pg/ and txt.size > (document_clean - 1)             #% examine pg build & remove limitation
                puts "\n\nTOO LARGE (TXT - see error log)\n\n"
                system(%{echo "\n#{@opt.fns}\nTEXT BODY\n#{@col[:body].size} object #{@col[:ocn]} -> #{@col[:body].slice(0..500)}" >> /home/ralph/pg_documents_error_log})
                txt=%{\n\nLARGE TEXT BLOCK OMITTED\n\n}
              end
              if @en[0]: @en_a,@en_z = @en[0].first,@en[0].last
              end
              @col[:body]=if txt=~/<!T[h]?¡.+?!~\d+;\w\d+;\w\d+>/ #watch
                SiSU_Format_Shared::CSS_Format.new(txt,@col[:ocn],@col[:ocnd],@col[:ocns]).html_table
              elsif txt=~/<:i1>/
                SiSU_Format_Shared::CSS_Format.new(txt,@col[:ocn],@col[:ocnd],@col[:ocns]).indent1
              elsif txt=~/<:i2>/
                SiSU_Format_Shared::CSS_Format.new(txt,@col[:ocn],@col[:ocnd],@col[:ocns]).indent2
              else
                SiSU_Format_Shared::CSS_Format.new(txt,@col[:ocn],@col[:ocnd],@col[:ocns]).norm
              end
              special_character_escape(@col[:body])
              @col[:plaintext]=@col[:body].dup
              strip_markup(@col[:plaintext])
              t=Load_tuple.new(@conn,@col,@opt)
              t.tuple
              @en=Array.new
              @col[:en_a]=@col[:en_z]=nil
              @col[:lev]=@col[:plaintext]=@col[:body]=''
            end
            if notedata =~ /~\{.+?\}~/                                           #% import into database endnotes tables
              endnote_array=notedata.scan(/~\{.+?\}~/)
              endnote_array.each do |inf|
                if inf[/~\{(\d+)(.+?)<([0-9a-f]{#{@@dl}})>\}~/]                                       # metaverse new endnotes 2003w31/1
                  en,txt,digest_clean=$1,$2,$3 
                  @id_n+=1
                  body=SiSU_Format_Shared::CSS_Format.new(txt,@col[:ocn],@col[:ocnd],@col[:ocns],en).endnote
                  special_character_escape(body)
                  special_character_escape(txt)
                  strip_markup(txt)
                  if txt.size > (endnote_clean - 1)
                    puts "\n\nTOO LARGE (ENDNOTE - see error log)\n\n"
                    system(%{echo "\n#{@opt.fns}\nENDNOTE\n#{txt.size} object #{@col[:ocn]},#{@col[:ocnd]},#{@col[:ocns]} -> #{txt.slice(0..500)}" >> /home/ralph/pg_documents_error_log})
                    txt=%{\n\nLARGE TEXT BLOCK OMITTED\n\n}
                  end
                  if txt
                    #puts "'#{@id_n}', '#{@col[:lid]}', '#{en}', '#{txt}', '#{body}', '#{@col[:ocn]}', '#{@col[:ocnd]}', '#{@col[:ocns]}', '#{@@id_t}'" #% endnotes
                    @conn.execute(%{
                      INSERT INTO endnotes (nid, document_lid, nr, clean, body, ocn, ocnd, ocns, metadata_tid, digest_clean) VALUES ('#{@id_n}', '#{@col[:lid]}', '#{en}', '#{txt}', '#{body}', '#{@col[:ocn]}', '#{@col[:ocnd]}', '#{@col[:ocns]}', '#{@@id_t}', '#{digest_clean}');
                    }) 
                  end
                end
              end
              word_mode=notedata.scan(/\S+/)
            end
          end
        end
      rescue: SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
    def endnote_range(word_array)
      @col[:en_a]=@col[:en_z]=nil
      word_array.each do |w|
        if w[/~\{(\d+)\s+.+?\}~/]                                                # not tested since change 2003w31
          @col[:en_a]=$1 unless @col[:en_a]
          @col[:en_z]=@col[:en_a].dup unless @col[:en_a]
          @col[:en_z]=$1 if @col[:en_a]
        end
      end
    end
    def import_db_urls(dbi_unit,meta)                                           #% import documents OID - populate database
      begin
        @fnm=meta
        @env=SiSU_Env::Info_dir.new(@opt.fns)
        base=@env.output_links_path[:url_root]
        out=@env.data_o
        markup,meta,latex,plaintext,html_toc,html_doc,xml_sax,xml_dom,pdf_p,pdf_l,concordance,sisupod='','','','','','','','','','','',''
        markup_li,meta_li,latex_li,plaintext_li,html_li,xml_sax_li,xml_dom_li,pdf_p_li,pdf_l_li,concordance_li,sisupod_li='','','','','','','','','','',''
        #if FileTest.file?("#{pwd}/#{@opt.fns}")==true
        #  markup='markup,'
        #  markup_li="'#{pwd}/#{@opt.fns}',"
        #end
        #if FileTest.file?(@fnm)==true
        #  meta='meta,'
        #  meta_li="'#@fnm',"
        #end
        #if FileTest.file?("latex")==true                                         #sort out
        #  #latex='latex,'
        #  #latex_li="lo_import('#{latexpath}/#{@opt.fns}.tex'),"
        #  latex,latex_li='',''
        #end
        if @fnb.empty? or @fnb.nil?: p 'file output path error' #remove
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@md.fn[:plain]}")==true)
          plaintext,plaintext_li='plaintext,', "'#{base}/#@fnb/#{@md.fn[:plain]}',"
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@md.fn[:toc]}")==true)
          html_toc,html_toc_li='html_toc,', "'#{base}/#@fnb/#{@md.fn[:toc]}',"
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@md.fn[:doc]}")==true)
          html_doc,html_doc_li='html_doc,', "'#{base}/#@fnb/#{@md.fn[:doc]}',"
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@md.fn[:xhtml]}")==true)
          xhtml,xhtml_li='xhtml,', "'#{base}/#@fnb/#{@md.fn[:xhtml]}',"
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@md.fn[:sax]}")==true)
          xml_sax,xml_sax_li='xml_sax,', "'#{base}/#@fnb/#{@md.fn[:sax]}',"
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@md.fn[:dom]}")==true)
          xml_dom,xml_dom_li='xml_dom,', "'#{base}/#@fnb/#{@md.fn[:dom]}',"
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@md.fn[:odf]}")==true)
          odf,odf_li='odf,', "'#{base}/#@fnb/#{@md.fn[:odf]}',"
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@md.fn[:pdf_p]}")==true)
          pdf_p,pdf_p_li='pdf_p,', "'#{base}/#@fnb/#{@md.fn[:pdf_p]}',"
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@md.fn[:pdf_l]}")==true)
          pdf_l,pdf_l_li='pdf_l,', "'#{base}/#@fnb/#{@md.fn[:pdf_l]}',"
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@md.fn[:concordance]}")==true)
          concordance,concordance_li='concordance,', "'#{base}/#@fnb/#{@md.fn[:concordance]}',"
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@opt.fns}.tex")==true)
          latex_p,latex_p_li='latex_p,', "'#{base}/#@fnb/#{@opt.fns}.tex',"
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@opt.fns}.landscape.tex")==true)
          latex_l,latex_l_li='latex_l,', "'#{base}/#@fnb/#@opt.fns}.landscape.tex',"
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@md.fn[:digest]}")==true)
          digest,digest_li='digest,', "'#{base}/#@fnb/#{@md.fn[:digest]}',"
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@md.fn[:manifest]}")==true) #revisit, was to be text, this is html
          manifest,manifest_li='manifest,', "'#{base}/#@fnb/#{@md.fn[:manifest]}',"
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@opt.fns}.meta")==true)
          markup,markup_li='markup,', "'#{base}/#@fnb/#{@opt.fns}.meta',"
        end
        if @opt.cmd !~/e/ or (@opt.cmd=~/e/ and FileTest.file?("#{out}/#@fnb/#{@opt.fns}.tgz")==true)
          sisupod,sisupod_li='sisupod,', "'#{base}/#@fnb/#{@opt.fns}.tgz',"
        end
      @conn.execute(%{
        INSERT INTO urls (#{plaintext} #{html_toc} #{html_doc} #{xhtml} #{xml_sax} #{xml_dom} #{odf} #{pdf_p} #{pdf_l} #{concordance} #{latex_p} #{latex_l} #{manifest} #{digest} #{markup} #{sisupod} metadata_tid) VALUES (#{plaintext_li} #{html_toc_li} #{html_doc_li} #{xhtml_li} #{xml_sax_li} #{xml_dom_li} #{odf_li} #{pdf_p_li} #{pdf_l_li} #{concordance_li} #{latex_p_li} #{latex_l_li} #{manifest_li} #{digest_li} #{markup_li} #{sisupod_li} #{@@id_t});
      })
      rescue: SiSU_Errors::Info_error.new($!,$@,@opt.cmd,@opt.fns).error
      ensure
      end
    end
  end
end
__END__

