/*
    Silky - A GTK+ client for SILC.
    Copyright (C) 2003,2004 Toni Willberg

    - Arrays defining layout of xml config files

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    http://silky.sourceforge.net/

*/

#include "includes.h"

/* arrays for xml elements and attributes definitions follow... */

/* attribute number,	name used in xml,	default value */
SilkyXMLAttribute xml_attributes[] = {
 { ATTR_VERSION,	"version",		SILKY_VERSION },
 { ATTR_CONFIG_VERSION, "config-version",	SILKY_CONFIG_VERSION },
};

gint xml_attr_bits[] = {
  ATTR_VERSION,
  ATTR_CONFIG_VERSION,
};


/* { name,		type,		parent,		additional attributes,
									default value

Keep this in same order as enums

 */

/* using number of main config elements here, because it's largest */
SilkyXMLElement xml_elements[NUM_CONFIG][NUM_CM] = {

/**************** MAIN */
{
 { NULL,		0,			0,	NULL },
 { "silky",		0,			ATTR_VERSION | ATTR_CONFIG_VERSION,	NULL },

 { "userinfo",		CM_ROOT,		0, NULL },
 { "nickname",  	CM_USERINFO,		0, "" },	/* empty, system should provide this */
 { "realname",  	CM_USERINFO,		0, "Silky User" },
 { "quitmessage",	CM_USERINFO,		0, N_("Another happy Silky user") },

 { "gui",		CM_ROOT,		0, NULL },
 { "colors",		CM_GUI,			0, NULL },
 { "mynickname",	CM_GUI_COLORS,		0, "default" },
 { "mytext",		CM_GUI_COLORS,		0, "default" },
 { "myaction",		CM_GUI_COLORS,		0, "default" },
 { "nicknames",		CM_GUI_COLORS,		0, "default" },
 { "text",		CM_GUI_COLORS,		0, "default" },
 { "actions",		CM_GUI_COLORS,		0, "default" },
 { "timestamp",		CM_GUI_COLORS,		0, "default" },
 { "servermessages",	CM_GUI_COLORS,		0, "default" },
 { "inputbox",		CM_GUI_COLORS,		0, "default" },
 { "background",	CM_GUI_COLORS,		0, "default" },
 { "highlight-words",	CM_GUI_COLORS,		0, "default" },
 { "highlight-mynick",	CM_GUI_COLORS,		0, "default" },

 { "highlights",	CM_GUI,			0, NULL },
 { "own-nick",		CM_GUI_HIGHLIGHTS,	0, "ON" },
 { "words",		CM_GUI_HIGHLIGHTS,	0, "" },

 { "font",		CM_GUI,			0, "" },
 { "debug-usec",	CM_GUI,			0, "OFF" },
 { "cmdhistory-depth",	CM_GUI,			0, "50" },
 { "tips",		CM_GUI,			0, "ON" },

 { "security",		CM_ROOT,		0, NULL },
 { "message-signing",	CM_SECURITY,		0, NULL },
 { "channel-messages",	CM_SECURITY_MESSAGE_SIGNING,	0,	"ON" },
 { "private-messages",	CM_SECURITY_MESSAGE_SIGNING,	0,	"ON" },
 { "channel-actions",	CM_SECURITY_MESSAGE_SIGNING,	0,	"ON" },
 { "private-actions",	CM_SECURITY_MESSAGE_SIGNING,	0,	"ON" },
},

/****** SERVERS */
{
 { NULL,		0,			0, NULL },
 { "silky",		0,			ATTR_VERSION | ATTR_CONFIG_VERSION, NULL },

 { "server",		CS_ROOT,		0, NULL },
 { "hostname",		CS_SERVER,		0, "" },
 { "port",		CS_SERVER,		0, "706" },
 { "autoconnect",	CS_SERVER,		0, "OFF" },
},
/****** BUDDIES */
{
 { NULL,		0,			0, NULL },
 { "silky",		0,			ATTR_VERSION | ATTR_CONFIG_VERSION, NULL },

 { "buddy",		CB_ROOT,		0, NULL },
 { "nickname",		CB_BUDDY,		0, "" },
 { "realname",		CB_BUDDY,		0, "" },
 { "fingerprint",	CB_BUDDY,		0, "" },

 { "attributes",	CB_BUDDY,		0, NULL },
 { "languages",		CB_BUDDY_ATTR,		0, "" },
 { "preferred-contact", CB_BUDDY_ATTR,		0, "" },
 { "timezone",		CB_BUDDY_ATTR,		0, "" },
 { "geolocation",	CB_BUDDY_ATTR,		0, "" }
}
};
