/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult, 2003 OGINO Tomonori
    email                : rgroult@jalix.org ogino@nn.iij4u.or.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "main.h"
#include "kstartuplogo.h"

#include <kimageio.h>
#include <kprocess.h>
#include <kmainwindow.h>

#include <dcopclient.h>

#include <qpixmapcache.h>

class KConfig;

extern void qimageio_readXCF(QImageIO *io);
extern void kimgio_magick_register();

static MainWindow *frame=NULL;

class ShowImgApplication : public KUniqueApplication
{
public:
  ShowImgApplication() : KUniqueApplication() { };

  virtual int newInstance();
};


int
ShowImgApplication::newInstance()
{
	// process args:
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
	if(frame)
	{
		frame->raise();
		if (args->count() == 1)
		{
			frame->openDir(QFile::decodeName(args->arg (0)));
		}
	}
	args->clear();
	return 0;
}


int
main (int argc, char **argv)
{
	KAboutData*  aboutData = new KAboutData("showimg", I18N_NOOP ("showimg"),
	        	      "0.9.1", description, KAboutData::License_GPL,
	        	      "(c) 2001-2004, Richard Groult", I18N_NOOP("(Please e-mail any bug reports...\nor encouragements to me :)"),
	        	      "http://www.jalix.org/projects/showimg/",
	        	      "rgroult@jalix.org" );

	aboutData->addAuthor ("Richard Groult", I18N_NOOP("Developer"), "rgroult@jalix.org", "http://ric.jalix.org");
	aboutData->addAuthor ("Dominik Seichter", I18N_NOOP("to allow me to use his great software krename for showimg, and patch writing"), "domseichter@web.de", "http://www.freshmeat.net/projects/krename" );
	aboutData->addAuthor ("Tomonori Ogino", I18N_NOOP("patch for archives"), "ogino@nn.iij4u.or.jp");

	aboutData->addCredit ("Valerie", I18N_NOOP("for the original logo"));
	aboutData->addCredit ("Benoist", I18N_NOOP("BETA testor, translation, and help for the zoom feature"), "b.gaston@laposte.net");
	aboutData->addCredit ("Romain Vallet", I18N_NOOP("Documentation and spelling corrector"), "rom@jalix.org");
	aboutData->addCredit ("Guillaume Duhamel",I18N_NOOP("Beginning of Japanese translation and beginning of the http/ftp protocol support") , "Guillaume.Duhamel@univ-rouen.fr");

	aboutData->addCredit ("Alain Bidaud and the Jalix team", I18N_NOOP("for the web site"));

	aboutData->addCredit ("Andre Pascual ", I18N_NOOP("for the current logo and additional icons"), "andre@linuxgraphic.org");
	aboutData->addCredit ("Jean-Philippe Martin",I18N_NOOP("for icons and advice about features and design") , "jeanphilippemartin@club-internet.fr");

	aboutData->addCredit ("Hape Schaal ", I18N_NOOP("German translator and a great help for debugging"), "hp.news@gmx.de");
	aboutData->addCredit ("Andrea Tavazzani",I18N_NOOP("Italian translation") , "andreatavazzani@libero.it");
	aboutData->addCredit ("E. Jorge Tizado ",I18N_NOOP("Spanish translation") , "dbajtm@unileon.es");
	aboutData->addCredit ("Fabrice Mous",I18N_NOOP("Dutch translation") , "fabrice@kde.nl");
	aboutData->addCredit ("Karolina Lindqvist",I18N_NOOP("Swedish translation") , "pgd-karolinali@algonet.se");
	aboutData->addCredit ("Tomonori Ogino",I18N_NOOP("Japanese translation and archive patch") , "ogino@nn.iij4u.or.jp");
	aboutData->addCredit ("Jozef Riha",I18N_NOOP("Slovak translation") , "zefo@seznam.cz");

	aboutData->addCredit ("Matthias Wandel", I18N_NOOP("to allow me to use jhead for JPEG-EXIF format support"), "MWandel@rim.net");
	aboutData->addCredit ("Andrew Richards", I18N_NOOP("to allow me to use his printImageDialog class"), "ajr@users.sourceforge.net");

	aboutData->addCredit ("Lots of people", I18N_NOOP("for bugs reports, advice\nand encouragement :)"));

	//

	KCmdLineArgs::init (argc, argv, aboutData);
	KCmdLineArgs::addCmdLineOptions (options);
	ShowImgApplication::addCmdLineOptions();

	bool alreadyRunning=!ShowImgApplication::start();
	if (alreadyRunning)
	{
		fprintf(stderr, "ShowImg is already running!\n");
		return 0;
	}

	ShowImgApplication kApp;
	KConfig *config = new KConfig("showimgrc");
	config->setGroup("confirm");
	KStartupLogo* logo=NULL;
	if(config->readBoolEntry("showSP", true))
	{
		logo = new KStartupLogo();
		logo->show();
	}

	QPixmap::setDefaultOptimization( QPixmap::MemoryOptim );
	KImageIO::registerFormats();
	QImageIO::defineIOHandler("XCF", "gimp xcf", 0, qimageio_readXCF, NULL);
	kimgio_magick_register();
	QPixmap::setDefaultOptimization(QPixmap::MemoryOptim);
	QPixmapCache::setCacheLimit(2*1024);


	KCmdLineArgs *args = KCmdLineArgs::parsedArgs ();
	if (argc == 1)
	{
		frame = new MainWindow ("MainFrame");
	}
	else
	{
		frame = new MainWindow (QFile::decodeName (args->arg (0)), "MainFrame");
	}

	frame->setIcon(kApp.icon());
	kApp.setMainWidget (frame);
	QObject::connect(kapp,SIGNAL(lastWindowClosed()),frame,SLOT(quit()));

	if(logo)
	{
		logo->hide();
		delete logo;
	}
	int ret = kApp.exec ();
	{
		/* clean-up temporaly extracting dir. */
		KShellProcess *proc = new KShellProcess();

		QString  dest;
		dest.setNum (getpid ());
		dest.prepend ("/tmp/.qlist");

		*proc << "rm -r -f " << KShellProcess::quote(dest);
		proc->start(KShellProcess::Block);
	}
	return ret;
}
