
/***************************************************************************
                          imageviewer.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SHOWIMG_H
#define SHOWIMG_H

#include <qwidget.h>

#include <ktrader.h>

class ImageListView;
class MainWindow;

class KAction;
class KActionCollection;
class KPixmapIO;
class KPopupMenu;

class QLabel;
class QMenuBar;
class QPopupMenu;
class QWidget;

#define EFFECT_NORMALIZE 1
#define EFFECT_EQUALIZE 2
#define EFFECT_INTENSITY 3
#define EFFECT_INVERT 9
#define EFFECT_GRAYSCALE 10

#define EFFECT_EMBOSS 4
#define EFFECT_SWIRL 5
#define EFFECT_SPREAD 6
#define EFFECT_IMPLODE 7
#define EFFECT_CHARCOAL 8


class ImageViewer:public QWidget
{
	Q_OBJECT

public:
	/**
	      create the imageViewer
	      @param parent the parent widget
	      @param ImageListView the list of the images
	      @param MainWindow the mainwindow
	      @param name
	      @param wFlags
	*/
	ImageViewer (QWidget * parent = NULL,
		      ImageListView * il = NULL,
		      MainWindow *mw = NULL,
		      QString name = NULL, int wFlags = 0);

	/**
	      init the menu given the actionCollection
	*/
	void initMenu(KActionCollection *actionCollection);

	/**
	      set the grayscale level
	      @param togray between 0 and 100
	*/
	void setToGrayscale(int togray);
	int toGrayscale();

	/**
	      load and display an image given the full filaname
	      @param fileName the full filaname of the picture to display
	*/
	bool loadImage (QString fileName="", int index=-1);

	void reload();

	/**
	      preload in memory an image given the full filaname
	      @param fileName the full filaname of the picture to load
	*/
	bool preloadImage (QString fileName);

	/**
	      upadate the status of the mainwindow
	*/
	void updateStatus ();

	/**
	      @return true if an image is loaded
	*/
	bool hasImage();

	/**
	      flip or miror the diplayed image
	*/
	void mirror (bool horizontal, bool vertical, bool r=true);

	/**
	      rotate to the left
	*/  
	void rotateLeft(bool r=true);
	/**
	      rotate to the right
	*/  
	void rotateRight(bool r=true);

	/**
	      display the image with its original size (i.e zoom=1)
	*/
	void originalSize();

	/**
	      fit or unfit the image ti the screen
	      @param fit if true, fit the image
	      @keep if true, store this param for te next images
	*/
	void setFit(bool fit, bool keep=false);

	/**
	      set smooth for the next image, required for memory and time
	*/
	void setSmooth(bool s);

	/**
	      zoom into the image given the rate
	*/
	void zoomIn(float rate);

	/**
	      zoom out the image given the rate
	*/
	void zoomOut(float rate);

	/**
	      if true, store the zoom rate
	*/
	void setZoomLock(bool lock);

	/**
	      scroll the image of dx and dy pixels
	*/
	void scroll ( int dx, int dy ) ;

	void applyFilter(int filter, bool activate);
	void applyFilter();
	void applyFilterPreloaded();

	/**
	      @return a pixmap of the displayed image
	*/
	QPixmap getPixmap();

	/**
	      @return the fullname of the displayed image
	*/
	QString getFilename();

	/**
	      @param shrink if true, shrink the image if it's larger than the screen
	*/
	void setShrink(bool shrink);

	/**
	      @param enlarge if true, enlarge the image if it's smaller than the screen
	*/
	void setEnlarge( bool enlarge);
	const bool& getEnlarge();

	/**
	      set the background color
	*/
	void setBackgroundColor(QColor col);

	QLabel *status;
	int total;
	int nbImg;

	MainWindow *mw;


public slots:
	void wallpaperC();
	void wallpaperM();
	void wallpaperCM();
	void wallpaperCMa();
	void wallpaperA();
	void wallpaperL();

	void wallpaper (int mode=1);

	void fitHeight(bool setFitHeight=true, bool redraw=true);
	void fitWidth(bool setFitWidth=true, bool redraw=true);

	void scrolldxR();
	void scrolldyB();
	void scrolldxL();
	void scrolldyT();

	QString slotSave(QString path);
	
protected:
	void paintEvent (QPaintEvent *);
	void resizeEvent (QResizeEvent *);

	void wheelEvent (QWheelEvent * e);

	void mousePressEvent (QMouseEvent * e);
	void mouseReleaseEvent (QMouseEvent * e);
	void mouseMoveEvent (QMouseEvent * e);
	
	void mouseDoubleClickEvent (QMouseEvent * e);
	
protected slots:
	void movieUpdated(const QRect& area);
	void movieResized(const QSize& size);
	void movieStatus(int status);
	void startMovie();

private:
	bool autoRotate(bool r=false);

	int virtualScreenWitdth();
	int virtualScreenHeight();

	int virtualPictureWitdth();
	int virtualPictureHeight();

	void setVirtualPosX(double posX);
	void setVirtualPosY(double posY);
	int getVirtualPosX();
	int getVirtualPosY();
	QPoint getVirtualPos();
	void setVirtualPos(QPoint pos);

	void setPosX(double posX);
	void setPosY(double posY);
	void setPos(QPoint pos);
	int getPosX();
	int getPosY();
	QPoint getPos();

	bool posXForTopXIsOK(double posX);
	bool posYForTopYIsOK(double posY);

	void placeImage(bool redraw=false);
	void centerImage(int posX, int posY, bool redraw=false);
	void centerImage(bool redraw=false);
	void centerXImage(bool redraw=false);
	void centerYImage(bool redraw=false);

	void doScale (bool repaint=true);
	void scaleFit();
	void fitSize(bool redraw=true);
	void scalePreload ();
	void reduceSize();
	void enlargeSize();
	bool smooth () const;
	bool reconvertImage ();

	QString filename;
	bool ss; //true if smooth image
	QImage *image;// the loaded image
	QImage *imageScaled;  // the preloaded scaled image
	QString imageName;
	QString imageType;
	int imageIndex;
	KPixmapIO *pIO;

	QString preimageName;
	QImage *preloadedImage;       // the preloaded image
	QImage *preloadedScaledImage; // the preloaded image

	KActionCollection *actionCollection;
	QPopupMenu *file;
	KPopupMenu *m_popup, *m_popup_openWith ;

	int grayscale;
	ImageListView *il;

	QPoint *sp, *ep, *lp; //start, end, and last Points
	QBrush bgBrush;

	float scale;

	double realPosX, realPosY;
	double dragStartPosX, dragStartPosY;
	double topPosX, topPosY;
	double difTopPosX, difTopPosY;

	ButtonState button;
	QMovie* movie;
	void initMovie();

	bool fit, isFitWidth, isFitHeight;
	bool hasimage;


protected:
	bool shrink;
	bool enlarge;
	bool lock;

	bool e_normalize, e_equalize,  e_intensity, e_emboss, e_swirl, e_spread, e_implode, e_charcoal, e_invert, e_grayscale;
};


#endif // SHOWIMG_H
