
/***************************************************************************
                          imageloader.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "imageloader.h"
#include "imagelistview.h"
#include "imagefileinfo.h"
#include "exif.h"

#include <kurl.h>
#include <kapp.h>
#include <klocale.h>
#include <kprocess.h>
#include <kpixmapio.h>
#include <kapplication.h>
#include <kstandarddirs.h>

#include <qstring.h>
#include <qimage.h>
#include <qlabel.h>
#include <qdir.h>
#include <qpainter.h>

//#include <iostream.h>
#include <sys/stat.h>
#include <unistd.h>
#include <math.h>


class ImageListView;

void *
__thread_start (void *arg)
{
	pthread_cleanup_push (__thread_cleanup, arg);
	((ImageLoader *) arg)->thread_start ();
	pthread_cleanup_pop (0);
	pthread_detach (pthread_self ());
	return 0;
}

void
__thread_cleanup (void *arg)
{
	((ImageLoader *) arg)->thread_cleanup ();
}


ImageLoader::ImageLoader (QWidget * parent, const char *name):
QObject (parent, name)
{
	EventList.setAutoDelete (true);
	installEventFilter (this);
	Loading = Running = false;

	size=QSize(80,60);
	setThumbnailSize(size);
	showFrame=false;
	
	ptop=QImage(locate("appdata", "pics/border.png"));
}

ImageLoader::~ImageLoader ()
{
	stopLoading (true);
}

void
ImageLoader::setShowFrame(bool show)
{
	showFrame=show;
}
void
ImageLoader::setUseEXIF(bool useexif)
{
	useEXIF=useexif;
}


QPixmap
ImageLoader::addBorder(QPixmap *pix, bool hasAlpha)
{
	if(!showFrame) return *pix;

	QPixmap res(pix->size());
	QPainter p(&res);
		if(hasAlpha) p.drawTiledPixmap (0, 0, pix->width(), pix->height(), QPixmap(locate("appdata", "pics/bgxpm.png")));
		p.drawImage(0, 0, ptop.scale(pix->width()+1, pix->height()+1));
		p.drawImage((int)floor((float)pix->width()/ptop.width()*14), (int)floor((float)pix->height()/ptop.height()*13),
				pix->convertToImage().smoothScale( (int)ceil(pix->width()*0.79738562092)+1, (int)ceil(pix->height()*0.76691729323)+1));
	p.end();
	return res;
}

QPixmap
ImageLoader::addForeground(QPixmap *pix, bool hasAlpha)
{
	QPixmap res(pix->size());
	QPainter p(&res);
		if(hasAlpha) p.drawTiledPixmap (0, 0, pix->width(), pix->height(), QPixmap(locate("appdata", "pics/bgxpm.png")));
		p.drawPixmap(0,0,*pix);
	p.end();
	return res;
}

void
ImageLoader::setThumbnailSize(QSize newSize)
{
	if(size==newSize)
		return;
	else
		size=newSize;
}


QSize
ImageLoader::getThumbnailSize()
{
	return size;
}


void
ImageLoader::loadMiniImage (QFileInfo * fi, QWidget * w, bool threaded)
{
//	kdDebug() << __FILE__ << __LINE__ << "ImageLoader::loadMiniImage (QFileInfo * fi, QWidget * w, bool threaded) = \n\t"  << QDir::homeDirPath () + "/.showimg/cache/" + fi->absFilePath ()<< endl;
	bool cont=true;
	QFileInfo thumb(QDir::homeDirPath () + "/.showimg/cache/" + fi->absFilePath ());

	if(!thumb.exists())
	{
		if(useEXIF && thumb.extension().lower()=="jpg"  )
		{
			ProcessFile(fi->absFilePath().ascii(), false, thumb.absFilePath().ascii());
		}
	}
//	kdDebug() << __FILE__ << __LINE__ << "ImageLoader::loadMiniImage (QFileInfo * fi, QWidget * w, bool threaded) = \n\t"  << QDir::homeDirPath () + "/.showimg/cache/" + fi->absFilePath ()<< endl;	if (thumb.exists ())
	{
		if(fi->lastModified() < thumb.lastModified())
		{
			QImage im (QDir::homeDirPath () + "/.showimg/cache/" + fi->absFilePath ());
			im.setAlphaBuffer(true);
			double
			 wexpand = (double) im.width () / (double)getThumbnailSize().width(),
			 hexpand = (double) im.height () / (double)getThumbnailSize().height();
			//if (wexpand >= 1.0 || hexpand >= 1.0) // don't expand small images  !
			{
				int neww, newh;
				if (wexpand > hexpand)
				{
					neww = (int) (im.width () / wexpand );
					newh = (int) (im.height () / wexpand );
				}
				else
				{
					neww = (int) (im.width () / hexpand );
					newh = (int) (im.height () / hexpand );
				 }
				im=im.scale(neww,newh);
			}
			cont=false;
			QPixmap pix = KPixmapIO().convertToPixmap(im);
			(void)kapp->processEvents();
			((ImageListView *) w)->slotSetPixmap(addBorder(&pix, true));
		}
	}
	if(cont)
	{
//		kdDebug() << __FILE__ << __LINE__ << "ImageLoader::loadMiniImage (QFileInfo * fi, QWidget * w, bool threaded) = \n\t"  << QDir::homeDirPath () + "/.showimg/cache/" + fi->absFilePath ()<< endl;
		ImageLoadEvent *e = new ImageLoadEvent (fi, w, threaded);
		EventList.append (e);
		if (EventList.count () > 0 && !Running)
		{
			Running = true;
			startTimer (1);
			nextImage ();
		}
	}
}

void
ImageLoader::startLoading ()
{
	Running = true;
	ImageLoadEvent *e = ((int) (EventList.count ()) > 0 ? EventList.take (0) : 0);
	if (!e)
	{
		Running = Loading = false;
		killTimers ();
	
		return;      
	}
	if (!initLoading (e))
	{
		cantLoad (e);
		return;
	}
	Loading = true;
	loadImageInternal (e);
}


void
ImageLoader::stopLoading (bool clean)
{
	if (Loading)
	{
		pthread_cancel (ThreadID);
		pthread_join (ThreadID, NULL);
		Loading = Running = false;
		killTimers ();
		ImageLoadedList.clear ();
	}
	if (clean)
	{
		EventList.clear ();
	}
}

void
ImageLoader::cantLoad (ImageLoadEvent * e)
{
	(void)kapp->postEvent (e->widget (), e);
	// Try to load next image
	Loading = false;
	nextImage ();
}

bool
ImageLoader::eventFilter (QObject *, QEvent * e)
{
	switch (e->type ())
	{
		case Event_NextImage:
			startLoading ();
			return true;
		case Event_ImageLoad:
		{
		 	 Loading = false;
		 	 ImageLoadEvent *ev = new ImageLoadEvent (*((ImageLoadEvent *) e));
		 	 finishLoading (ev);
		 	 (void)kapp->postEvent (ev->widget (), ev);
		 	 nextImage ();
		 	 return true;
		}
		default : return false;
	}
	return false;
}


void
ImageLoader::nextImage ()
{
	if (!Loading)
	{
		NextImageEvent *e = new NextImageEvent;
		(void)kapp->postEvent (this, e);
	}
}


void
ImageLoader::thread_start ()
{
	InternalImage.load (InternalPath);
	ImageLoadedList.append (InternalEvent);
}


void
ImageLoader::thread_cleanup ()
{
}


void
ImageLoader::timerEvent (QTimerEvent * )
{
	while (ImageLoadedList.count () > 0)
	{
		ImageLoadEvent *e = ImageLoadedList.take (0);
		(void)kapp->postEvent (this, e);
	}
}


bool
ImageLoader::initLoading (ImageLoadEvent * e)
{ 
	QFileInfo *fi = e->fileInfo ();
	image_path = QString (fi->absFilePath ());
	image_url.setPath(image_path);

	if (!mini_image_file_exists || mini_image_outdated)
		return true;
	return false;
}


void
ImageLoader::finishLoading (ImageLoadEvent * e)
{
	QFileInfo *fi = e->fileInfo ();
	QImage image = InternalImage, ditheredImage;
//	kdDebug() << __FILE__ << __LINE__ << " ImageLoader::finishLoading (ImageLoadEvent * e) = \n\t"  << QDir::homeDirPath () + "/.showimg/cache/" + fi->absFilePath ()<< endl;

	if (image.isNull ())
	{
//			kdDebug() << __FILE__ << __LINE__ << " ImageLoader::finishLoading (ImageLoadEvent * e) = \n\t Impossible de crer l'aperu"  << endl;
			image = BarIcon("file_broken",48).convertToImage();
	}	
	
	double
	  wexpand = (double) image.width () / (double)getThumbnailSize().width() ,
	  hexpand = (double) image.height () / (double)getThumbnailSize().height();

	//if (wexpand >= 1.0 || hexpand >= 1.0) // don't expand small images  !
	{
		int neww, newh;
		if (wexpand > hexpand)
		{
		 	 neww = (int) (image.width () / wexpand);
		 	 newh = (int) (image.height () / wexpand);
		}
		else
		{
			neww = (int) (image.width () / hexpand);
			newh = (int) (image.height () / hexpand);
		}
		image = image.smoothScale (neww, newh);
	}

		QString  dest = QString (QDir::homeDirPath () + "/.showimg/");
		QDir	  dirDest = QDir (dest);
		if (!dirDest.exists ())
		{
			QDir ().mkdir (dest);
		}
		dest = dest + "cache/";
		dirDest = QDir (dest);
		if (!dirDest.exists ())
		{
			QDir ().mkdir (dest);
		}
		QString  res = QString (fi->absFilePath ());
		QCString  ssrep;
		int  pos = res.find ("/");
		while (pos != -1)
		{
			dest = dest + res.left (pos) + "/";
			dirDest = QDir (dest);
			if (!dirDest.exists ())
			{
				QDir ().mkdir (dest);
			}
			res = res.right(res.length () - pos - 1);
			pos = res.find ("/");
		}
	image.save(QString (dest) + fi->fileName (), "PNG");
	mini_image = KPixmapIO().convertToPixmap(image);

	if(!mini_image.isNull ())
	{
		((ImageListView *) e->widget ())->slotSetPixmap (addBorder(&mini_image, image.hasAlphaBuffer()));
	}
	else
		((ImageListView *) e->widget ())->slotSetPixmap (BarIcon("file_broken",48));
	InternalImage.reset ();
	image.reset();
}


void
ImageLoader::loadImageInternal (ImageLoadEvent * e)
{
	InternalPath = image_url.path ();
	InternalEvent = e;
	InternalImage.reset ();
	// Problem here with xpm and xbm image, interfere with X system and can cause crash.
	// As it is probably a small image, it's probably not a problem to load it synchronously.

	if (!e->threaded ())
		thread_start ();
	else
		if (pthread_create (&ThreadID, 0, __thread_start, this) == 0);
	else
		qWarning ("%s %d  ImageLoader::loadImageInternal (ImageLoadEvent * e) : unable to start loading thread",__FILE__,__LINE__);

}
