
/***************************************************************************
                          imagefileinfo.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef _IMAGEFILEINFO_H_
#define _IMAGEFILEINFO_H_

#include <qstring.h>

#define IMAGE	0
#define ALBUM	1

class QString;

class ImageFileInfo
{
public:
	ImageFileInfo(QString filename, int type, bool r=true);
	~ImageFileInfo();
	
	bool hasInfo();
	
	void write(QString title, QString event,
			QString location, QString people,
			QString date, QString description,
			QString fileDest=QString());

	void write(QString title,
		QString shortDescription, QString longDescription,
		QString fileDest=QString());
	
	void update(QString destDir);
	
	QString getTitle() const;
	void setTitle(QString title);
	QString getEvent() const;
	void setEvent(QString event);
	QString getLocation() const;
	void setLocation(QString location);
	QString getPeople() const;
	void setPeople(QString people);
	QString getDate() const;
	void setDate(QString date);
	QString getDescription() const;
	void setDescription(QString description);
	QString getShortDescription() const;
	void setShortDescription(QString shortdesc);
	QString getLongDescription() const;
	void setLongDescription(QString longdesc);
	
protected:
	bool verif(QString info);
	void read(bool r=true);
	int type;
	
	QString filename,imageid;
	QString info;
	
	QString 
		title, event, 
		location, people, 
		date, description,
		shortdesc, longdesc;

private:
	bool found;
	
};
#endif
