#
# Copyright (C) 2006 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

import gettext
_ = gettext.translation('setroubleshoot-plugins', '/usr/share/locale', fallback=True).lgettext

from setroubleshoot.util import *
from setroubleshoot.Plugin import Plugin
import re

class plugin(Plugin):
    summary =_('''
    SELinux is preventing the spamd daemon from reading users' home directories.
    ''')

    problem_description = _('''
    SELinux has denied the spamd daemon access to users' home
    directories. Someone is attempting to access your home directories
    via your spamd daemon. If you only setup spamd to share non-home
    directories, this probably signals a intrusion attempt.
    ''')

    fix_description = _('''
    If you want spamd to share home directories you need to turn on
    the $BOOLEAN boolean: "setsebool -P $BOOLEAN=1"
    ''')

    fix_cmd = 'setsebool -P $BOOLEAN=1'
    
    def __init__(self):
        Plugin.__init__(self, __name__)

    def analyze(self, avc):
        if avc.matches_source_types(['spamd_t']) and \
           avc.matches_target_types(['home_root_t', '.*_home_t', '.*_home_dir_t']):
            # MATCH
            avc.set_template_substitutions(BOOLEAN="spamd_enable_home_dirs")
            return self.report(avc, _("SAMBA"),
                               self.summary, self.problem_description,
                               self.fix_description, self.fix_cmd)
        else:
            return None

