#
# Copyright (C) 2006 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

import gettext
_ = gettext.translation('setroubleshoot-plugins', '/usr/share/locale', fallback=True).lgettext

from setroubleshoot.util import *
from setroubleshoot.Plugin import Plugin

class plugin(Plugin):
    summary =_('''
    SELinux is preventing $SOURCE ($SOURCE_TYPE) "$ACCESS" to $TARGET_PATH ($TARGET_TYPE).
    ''')

    problem_description = _('''
    SELinux is preventing $SOURCE ($SOURCE_TYPE) "$ACCESS" to $TARGET_PATH ($TARGET_TYPE).
    The SELinux type $TARGET_TYPE, is a generic type for all files in the directory and very few processes (SELinux Domains) are allowed to write to this SELinux type.  This type of denial usual indicates a mislabeled file.  By default a file created in a directory has the gets the context of the parent directory, but SELinux policy has rules about the creation of directories, that say if a process running in one SELinux Domain (D1) creates a file in a directory with a particular SELinux File Context (F1) the file gets a different File Context (F2).  The policy usually allows the SELinux Domain (D1) the ability to write, unlink, and append on (F2).  But if for some reason a file ($TARGET_PATH) was created with the wrong context, this domain will be denied.  The usual solution to this problem is to reset the file context on the target file, restorecon -v '$TARGET_PATH'.  If the file context does not change from $TARGET_TYPE, then this is probably a bug in policy.  Please file a <a href="http://bugzilla.redhat.com/bugzilla/enter_bug.cgi">bug report</a> against the selinux-policy package.
If it does change, you can try your application again to see if it works.  The file context could have been mislabeled by editing the file or moving the file from a different directory, if the file keeps getting mislabeled, check the init scripts to see if they are doing something to mislabel the file.  
 
    ''')

    fix_description = _('''
    You can attempt to fix file context by executing restorecon -v '$TARGET_PATH'
    ''')

    fix_cmd = "restorecon '$TARGET_PATH'"
    
    def __init__(self):
        Plugin.__init__(self, __name__)
        self.set_priority(91)

    def analyze(self, avc):

        restorecon_files = ['dir', 'file', 'lnk_file', 'sock_file']

        if avc.matches_target_types(['var_log_t', 'var_lib_t', 'etc_t', 'root_t', 'var_lock_t', 'var_run_t', 'var_spool_t'])  and \
           avc.all_accesses_are_in(['write', 'append', 'unlink'])                                                             and \
           avc.has_tclass_in(restorecon_files):
            # MATCH
            return self.report(avc, _("File Label"),
                               self.summary, self.problem_description,
                               self.fix_description, self.fix_cmd)
        else:
            return None

