/*
 * Copyright (C) 2009-2016 Alistair Neil <info@dazzleships.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package lib;

import java.awt.Image;
import javax.swing.ImageIcon;

/**
 *
 * @author Alistair Neil, <info@dazzleships.net>
 */
public class AboutDialog extends javax.swing.JDialog {

    private String strHome = null;
    private String strContact = null;

    /**
     * Creates new About Dialog
     *
     * @param parent
     * @param modal
     */
    public AboutDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }

    /**
     * Set appliction description
     *
     * @param text
     */
    public void setAppDescription(String text) {
        jTextAreaVersion.setText(text);
    }

    /**
     * Set application logo
     *
     * @param ii
     */
    public void setAppLogo(ImageIcon ii) {
        Image im = ii.getImage().getScaledInstance(jLabelAppLogo.getWidth(), jLabelAppLogo.getHeight(), Image.SCALE_SMOOTH);
        ii.setImage(im);
        jLabelAppLogo.setIcon(ii);
    }

    /**
     * Set home url
     *
     * @param home
     */
    public void setHomeURL(String home) {
        strHome = home;
    }

    /**
     * Set contact url
     *
     * @param contact
     */
    public void setContactURL(String contact) {
        strContact = contact;
    }

    /**
     * Set text on Contact button
     *
     * @param text
     */
    public void setButtonContactText(String text) {
        jButtonContact.setText(text);
    }

    /**
     * Set text on Visit button
     *
     * @param text
     */
    public void setButtonVisitText(String text) {
        jButtonVisit.setText(text);
    }

    /**
     * Set text on Close button
     *
     * @param text
     */
    public void setButtonCloseText(String text) {
        jButtonClose.setText(text);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        jButtonVisit = new javax.swing.JButton();
        jButtonContact = new javax.swing.JButton();
        jButtonClose = new javax.swing.JButton();
        jLabelAppLogo = new javax.swing.JLabel();
        jTextAreaVersion = new javax.swing.JTextArea();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Title");
        setResizable(false);

        jButtonVisit.setText("Visit Us");
        jButtonVisit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonVisitActionPerformed(evt);
            }
        });

        jButtonContact.setText("Contact Us");
        jButtonContact.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonContactActionPerformed(evt);
            }
        });

        jButtonClose.setText("Close");
        jButtonClose.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCloseActionPerformed(evt);
            }
        });

        jLabelAppLogo.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jLabelAppLogo.setPreferredSize(new java.awt.Dimension(128, 128));

        jTextAreaVersion.setEditable(false);
        jTextAreaVersion.setColumns(15);
        jTextAreaVersion.setForeground(jPanel1.getForeground());
        jTextAreaVersion.setLineWrap(true);
        jTextAreaVersion.setRows(5);
        jTextAreaVersion.setWrapStyleWord(true);
        jTextAreaVersion.setBorder(null);
        jTextAreaVersion.setFocusable(false);
        jTextAreaVersion.setOpaque(false);

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(jButtonVisit)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jButtonContact)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addComponent(jButtonClose))
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(jLabelAppLogo, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTextAreaVersion, javax.swing.GroupLayout.PREFERRED_SIZE, 183, javax.swing.GroupLayout.PREFERRED_SIZE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jLabelAppLogo, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jTextAreaVersion))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jButtonVisit)
                    .addComponent(jButtonContact)
                    .addComponent(jButtonClose)))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonVisitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonVisitActionPerformed
        if (strHome != null) {
            Utilities.openFileExternally(strHome);
        }
    }//GEN-LAST:event_jButtonVisitActionPerformed

    private void jButtonContactActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonContactActionPerformed
        if (strContact != null) {
            Utilities.openFileExternally(strContact);
        }
    }//GEN-LAST:event_jButtonContactActionPerformed

    private void jButtonCloseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCloseActionPerformed
        dispose();
    }//GEN-LAST:event_jButtonCloseActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonClose;
    private javax.swing.JButton jButtonContact;
    private javax.swing.JButton jButtonVisit;
    private javax.swing.JLabel jLabelAppLogo;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JTextArea jTextAreaVersion;
    // End of variables declaration//GEN-END:variables
}
