#!/usr/bin/perl -wT

# SecureCGI (perl prototype, outdated)
#
# (c) 2001 Krzysztof Bielawski
# (c) 2001 Piotr Roszatycki
#
# This software is under GPL

use BSD::Resource;
use English;
use MIME::Base64;

# Only www-data user can run this script
$server_uid = 33;

# Limits and priority
$limit_nproc = 50;
$limit_open_max = 100;
$limit_memory = 64*1024*1024;
$limit_cpu = 30;
$priority = 20;

# Check caller's uid
if ($UID != $server_uid) {
	print "Content-type: text/html\n\n";
	print "Invalid user\n";
	exit 1;
}

# PATH_TRANSLATED have to be set
if (!defined $ENV{PATH_TRANSLATED}) {
	print "Content-type: text/html\n\n";
	print "Undefined PATH_TRANSLATED\n";
	exit 1;
}

# Untaint $PATH_TRANSLATED
$PATH_TRANSLATED = $ENV{PATH_TRANSLATED};
$PATH_TRANSLATED =~ m/^(.*)$/;
$PATH_TRANSLATED = $1;

# Check if exists
if (! -f $PATH_TRANSLATED) {
	print "Content-type: text/html\n\n";
	print "Script not found\n";
	exit 1;
}

# Stat script
if (-l $PATH_TRANSLATED) {
    @lstats = stat($PATH_TRANSLATED);
} else {
    @stats = stat($PATH_TRANSLATED);
}

# Check script's owner
if ($stats[4] == 0) {
	print "Content-type: text/html\n\n";
	print "Illegal script owner\n";
	exit 1;
}
if ($stats[5] == 0) {
	print "Content-type: text/html\n\n";
	print "Illegal script group\n";
	exit 1;
}

# Change personality
$GID=$stats[5];
$EGID=$GID;
$UID=$stats[4];
$EUID=$UID;

# Set CGI environment
@pw = getpwuid $stats[4];
$ENV{SCRIPT_FILENAME} = $ENV{PATH_TRANSLATED};
$ENV{SCRIPT_NAME} = $ENV{PATH_INFO} if defined $ENV{PATH_INFO};
$ENV{UID} = $stats[4];
$ENV{GID} = $stats[5];
$ENV{USER} = $pw[0];
$ENV{HOME} = $pw[7];

# Clean up environment
delete @ENV{qw(IFS CDPATH ENV BASH_ENV 
    REDIRECT_SCRIPT_URI REDIRECT_URL REDIRECT_HTTP_AUTHORIZATION
    REDIRECT_UNIQUE_ID REDIRECT_STATUS__)};

# Change directory
$pwd = $PATH_TRANSLATED;
$pwd =~ s%/[^/]*$%%;
$ENV{PWD} = $pwd;
chdir $pwd;

# HTTP authorization
if ($ENV{HTTP_AUTHORIZATION}) {
	$tmp=$ENV{HTTP_AUTHORIZATION};
	$tmp=~s/Basic (.*)/$1/;
	@auth_decoded=split /:/, decode_base64($tmp);
	$ENV{REMOTE_USER}=$auth_decoded[0];
	$ENV{REMOTE_PASSWORD}=$auth_decoded[1];
	if ($ENV{PATH_TRANSLATED}=~/php3?$/) {
		$ENV{PHP_AUTH_USER}=$auth_decoded[0];
		$ENV{PHP_AUTH_PW}=$auth_decoded[1];
	}
}

# Set limits for non-server scripts
if ($stats[4] != $server_uid) {
	setrlimit(RLIMIT_NPROC,$limit_nproc,$limit_nproc) 
	        or die "Can't set RLIMIT_NPROC";
	setrlimit(RLIMIT_OPEN_MAX,$limit_open_max,$limit_open_max) 
        	or die "Can't set RLIMIT_OPEN_MAX";
	setrlimit(RLIMIT_VMEM,$limit_memory,$limit_memory) 
        	or die "Can't set RLIMIT_VMEM";
	setrlimit(RLIMIT_CPU,$limit_cpu,$limit_cpu)
		or die "Can't set RLIMIT_CPU";
	setpriority(PRIO_PROCESS,$PID,$priority)
		or die "Can't set priority";
}

# Execute script
if ($ENV{PATH_TRANSLATED}=~/php3$/) {
	exec "/usr/bin/php3", $ENV{PATH_TRANSLATED};
}
elsif ($ENV{PATH_TRANSLATED}=~/php$/) {
	exec "/usr/bin/php4", $ENV{PATH_TRANSLATED};
}
elsif ($ENV{PATH_TRANSLATED}=~/pl$/) {
	exec "/usr/bin/perl", $ENV{PATH_TRANSLATED};
}
else {
	exec "/bin/sh", "-c", $ENV{PATH_TRANSLATED};
}
