/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

 // Disable symbol overrides so that we can use system headers.
#define FORBIDDEN_SYMBOL_ALLOW_ALL

// HACK to allow building with the SDL backend on MinGW
// see bug #1800764 "TOOLS: MinGW tools building broken"
#ifdef main
#undef main
#endif // main

#include "file.h"
#include "tag_maps.h"

#define BARBOT_COUNT_EN 250
static const TagMapping BARBOT_MAP_EN[250] = {
	{ 0x46cd0, 0x3d21e }, { 0x46ce2, 0x3d23b }, { 0x46ced, 0x3d246 },
	{ 0x46cf8, 0x3d251 }, { 0x46d03, 0x3d25c }, { 0x46d0e, 0x3d267 },
	{ 0x46d19, 0x3d272 }, { 0x46d24, 0x3d27d }, { 0x46d2f, 0x3d288 },
	{ 0x46cd1, 0x3d21f }, { 0x46cd9, 0x3d22a }, { 0x46cda, 0x3d233 },
	{ 0x46cdb, 0x3d234 }, { 0x46cdc, 0x3d235 }, { 0x46cdd, 0x3d236 },
	{ 0x46cde, 0x3d237 }, { 0x46cdf, 0x3d238 }, { 0x46ce0, 0x3d239 },
	{ 0x46ce1, 0x3d23a }, { 0x46ce3, 0x3d23c }, { 0x46ce4, 0x3d23d },
	{ 0x46ce5, 0x3d23e }, { 0x46ce6, 0x3d23f }, { 0x46ce7, 0x3d240 },
	{ 0x46ce8, 0x3d241 }, { 0x46ce9, 0x3d242 }, { 0x46cea, 0x3d243 },
	{ 0x46ceb, 0x3d244 }, { 0x46cec, 0x3d245 }, { 0x46cee, 0x3d26b },
	{ 0x46cef, 0x3d247 }, { 0x46cf0, 0x3d248 }, { 0x46cf1, 0x3d249 },
	{ 0x46cf2, 0x3d24a }, { 0x46cf3, 0x3d24b }, { 0x46cf4, 0x3d24c },
	{ 0x46cf5, 0x3d24d }, { 0x46cf6, 0x3d24e }, { 0x46cf7, 0x3d24f },
	{ 0x46cf9, 0x3d250 }, { 0x46cfa, 0x3d252 }, { 0x46cfb, 0x3d253 },
	{ 0x46cfc, 0x3d254 }, { 0x46cfd, 0x3d255 }, { 0x46cfe, 0x3d256 },
	{ 0x46cff, 0x3d257 }, { 0x46d00, 0x3d258 }, { 0x46d01, 0x3d259 },
	{ 0x46d02, 0x3d25a }, { 0x46d04, 0x3d25b }, { 0x46d05, 0x3d25d },
	{ 0x46d06, 0x3d25e }, { 0x46d07, 0x3d25f }, { 0x46d08, 0x3d260 },
	{ 0x46d09, 0x3d26f }, { 0x46d0a, 0x3d270 }, { 0x46d0b, 0x3d271 },
	{ 0x46d0c, 0x3d273 }, { 0x46d0d, 0x3d274 }, { 0x46d0f, 0x3d275 },
	{ 0x46d10, 0x3d276 }, { 0x46d11, 0x3d277 }, { 0x46d12, 0x3d278 },
	{ 0x46d13, 0x3d279 }, { 0x46d14, 0x3d27a }, { 0x46d15, 0x3d27b },
	{ 0x46d16, 0x3d27c }, { 0x46d17, 0x3d27e }, { 0x46d18, 0x3d27f },
	{ 0x46d1a, 0x3d280 }, { 0x46d1b, 0x3d281 }, { 0x46d1c, 0x3d282 },
	{ 0x46d1d, 0x3d283 }, { 0x46d1e, 0x3d284 }, { 0x46d1f, 0x3d285 },
	{ 0x46d20, 0x3d286 }, { 0x46d21, 0x3d287 }, { 0x46d22, 0x3d289 },
	{ 0x46d23, 0x3d28a }, { 0x46d25, 0x3d28b }, { 0x46d26, 0x3d28c },
	{ 0x46d27, 0x3d28d }, { 0x46d28, 0x3d28e }, { 0x46d29, 0x3d28f },
	{ 0x46d2a, 0x3d290 }, { 0x46d2b, 0x3d291 }, { 0x46d2c, 0x3d292 },
	{ 0x46d2d, 0x3d220 }, { 0x46d2e, 0x3d221 }, { 0x46d30, 0x3d222 },
	{ 0x46d31, 0x3d223 }, { 0x46d32, 0x3d224 }, { 0x46d33, 0x3d225 },
	{ 0x46d34, 0x3d226 }, { 0x46d35, 0x3d227 }, { 0x46d36, 0x3d228 },
	{ 0x46d37, 0x3d229 }, { 0x46d38, 0x3d22b }, { 0x46d39, 0x3d22c },
	{ 0x46cd2, 0x3d22d }, { 0x46cd3, 0x3d22e }, { 0x46cd5, 0x3d22f },
	{ 0x46cd6, 0x3d230 }, { 0x46cd7, 0x3d231 }, { 0x46cd8, 0x3d232 },
	{ 0x46d3a, 0x3d768 }, { 0x46d3b, 0x3d372 }, { 0x46d47, 0x3d43c },
	{ 0x46d48, 0x3d7ce }, { 0x46d49, 0x3d7cf }, { 0x46d4a, 0x3d6f1 },
	{ 0x46d4b, 0x3d77c }, { 0x46d4c, 0x3d49d }, { 0x46d4d, 0x3d77c },
	{ 0x46d4e, 0x3d0b5 }, { 0x46d4f, 0x3d177 }, { 0x46d50, 0x3d2d7 },
	{ 0x46d51, 0x3d77c }, { 0x46d52, 0x3d77c }, { 0x46d53, 0x3d30b },
	{ 0x46d55, 0x3d706 }, { 0x46d56, 0x3d704 }, { 0x46d57, 0x3d77c },
	{ 0x46d54, 0x3d0a0 }, { 0x46d58, 0x3d722 }, { 0x46d5a, 0x3d44a },
	{ 0x46d5b, 0x3d452 }, { 0x46d5c, 0x3d469 }, { 0x46d5d, 0x3d475 },
	{ 0x46d5e, 0x3d476 }, { 0x46d5f, 0x3d477 }, { 0x46d60, 0x3d478 },
	{ 0x46d61, 0x3d479 }, { 0x46d62, 0x3d47a }, { 0x46d63, 0x3d44b },
	{ 0x46d64, 0x3d44c }, { 0x46d65, 0x3d44d }, { 0x46d66, 0x3d44e },
	{ 0x46d67, 0x3d44f }, { 0x46d68, 0x3d450 }, { 0x46d69, 0x3d451 },
	{ 0x46d6a, 0x3d453 }, { 0x46d6b, 0x3d460 }, { 0x46d6c, 0x3d462 },
	{ 0x46d6d, 0x3d463 }, { 0x46d6e, 0x3d464 }, { 0x46d6f, 0x3d465 },
	{ 0x46d70, 0x3d466 }, { 0x46d71, 0x3d467 }, { 0x46d72, 0x3d468 },
	{ 0x46d73, 0x3d454 }, { 0x46d74, 0x3d455 }, { 0x46d75, 0x3d456 },
	{ 0x46d76, 0x3d457 }, { 0x46d77, 0x3d458 }, { 0x46d78, 0x3d459 },
	{ 0x46d79, 0x3d45a }, { 0x46d7a, 0x3d45b }, { 0x46d7b, 0x3d45c },
	{ 0x46d7c, 0x3d45f }, { 0x46d7d, 0x3d461 }, { 0x46d7e, 0x3d46a },
	{ 0x46d7f, 0x3d46d }, { 0x46d80, 0x3d46e }, { 0x46d81, 0x3d46f },
	{ 0x46d82, 0x3d470 }, { 0x46d83, 0x3d471 }, { 0x46d84, 0x3d472 },
	{ 0x46d85, 0x3d473 }, { 0x46d86, 0x3d474 }, { 0x46d87, 0x3d46b },
	{ 0x46d88, 0x3d75d }, { 0x46d89, 0x3d75e }, { 0x46d8a, 0x3d75f },
	{ 0x46d8b, 0x3d760 }, { 0x46d8c, 0x3d761 }, { 0x46d8d, 0x3d762 },
	{ 0x46d8e, 0x3d763 }, { 0x46d8f, 0x3d766 }, { 0x46d90, 0x3d767 },
	{ 0x46d91, 0x3d77c }, { 0x46d92, 0x3d768 }, { 0x46d93, 0x3d765 },
	{ 0x46d94, 0x3d769 }, { 0x46d95, 0x3d770 }, { 0x46d96, 0x3d775 },
	{ 0x46d97, 0x3d776 }, { 0x46d98, 0x3d777 }, { 0x46d99, 0x3d778 },
	{ 0x46d9a, 0x3d779 }, { 0x46d9b, 0x3d77a }, { 0x46d9c, 0x3d77b },
	{ 0x46d9d, 0x3d764 }, { 0x46d9e, 0x3d739 }, { 0x46d9f, 0x3d73a },
	{ 0x46da0, 0x3d73b }, { 0x46da1, 0x3d73c }, { 0x46da2, 0x3d73d },
	{ 0x46da3, 0x3d73e }, { 0x46da4, 0x3d742 }, { 0x46da5, 0x3d744 },
	{ 0x46da6, 0x3d743 }, { 0x46da7, 0x3d745 }, { 0x46da8, 0x3d741 },
	{ 0x46da9, 0x3d746 }, { 0x46daa, 0x3d747 }, { 0x46dab, 0x3d748 },
	{ 0x46dac, 0x3d749 }, { 0x46dad, 0x3d74a }, { 0x46dae, 0x3d74b },
	{ 0x46daf, 0x3d73f }, { 0x46db0, 0x3d771 }, { 0x46db1, 0x3d74c },
	{ 0x46db2, 0x3d74d }, { 0x46db3, 0x3d74e }, { 0x46db4, 0x3d74f },
	{ 0x46db5, 0x3d750 }, { 0x46db6, 0x3d751 }, { 0x46db7, 0x3d753 },
	{ 0x46db8, 0x3d755 }, { 0x46db9, 0x3d754 }, { 0x46dba, 0x3d756 },
	{ 0x46dbb, 0x3d752 }, { 0x46dbc, 0x3d757 }, { 0x46dbd, 0x3d758 },
	{ 0x46dbe, 0x3d759 }, { 0x46dbf, 0x3d75a }, { 0x46dc0, 0x3d75b },
	{ 0x46dc1, 0x3d75c }, { 0x46dc2, 0x3d4a7 }, { 0x46dc3, 0x3d2bf },
	{ 0x46dc4, 0x3d6fa }, { 0x46dc5, 0x3d6f9 }, { 0x46dc6, 0x3d6fb },
	{ 0x46dc7, 0x3d6f5 }, { 0x46dc8, 0x3d6fc }, { 0x46dc9, 0x3d6ff },
	{ 0x46dca, 0x3d2ab }, { 0x46dcb, 0x3d715 }, { 0x46dcc, 0x3d710 },
	{ 0x46dcd, 0x3d70c }, { 0x46dce, 0x3d712 }, { 0x46dcf, 0x3d70f },
	{ 0x46dd0, 0x3d717 }, { 0x46dd1, 0x3d716 }, { 0x46dd2, 0x3d285 },
	{ 0x46dd3, 0x3d269 }, { 0x46dd4, 0x3d2f8 }, { 0x46dd5, 0x0c421 },
	{ 0x46dd6, 0x0c3fc }
};

#define BELLBOT_COUNT_EN 108
static const TagMapping BELLBOT_MAP_EN[108] = {
	{ 0x46cd0, 0x31331 }, { 0x46ce2, 0x31332 }, { 0x46ced, 0x31333 },
	{ 0x46cf8, 0x31334 }, { 0x46d03, 0x31335 }, { 0x46d0e, 0x31336 },
	{ 0x46d19, 0x31337 }, { 0x46d24, 0x31338 }, { 0x46d2f, 0x31339 },
	{ 0x46cd1, 0x3133a }, { 0x46cd9, 0x3133b }, { 0x46cda, 0x3133c },
	{ 0x46cdb, 0x3133d }, { 0x46cdc, 0x3133e }, { 0x46cdd, 0x3133f },
	{ 0x46cde, 0x31340 }, { 0x46cdf, 0x31341 }, { 0x46ce0, 0x31342 },
	{ 0x46ce1, 0x31343 }, { 0x46ce3, 0x31344 }, { 0x46ce4, 0x31345 },
	{ 0x46ce5, 0x31346 }, { 0x46ce6, 0x31347 }, { 0x46ce7, 0x31348 },
	{ 0x46ce8, 0x31349 }, { 0x46ce9, 0x3134a }, { 0x46cea, 0x3134b },
	{ 0x46ceb, 0x3134c }, { 0x46cec, 0x3134d }, { 0x46cee, 0x3134e },
	{ 0x46cef, 0x3134f }, { 0x46cf0, 0x31350 }, { 0x46cf1, 0x31351 },
	{ 0x46cf2, 0x31352 }, { 0x46cf3, 0x31353 }, { 0x46cf4, 0x31354 },
	{ 0x46cf5, 0x31355 }, { 0x46cf6, 0x31356 }, { 0x46cf7, 0x31357 },
	{ 0x46cf9, 0x31358 }, { 0x46cfa, 0x31359 }, { 0x46cfb, 0x3135a },
	{ 0x46cfc, 0x3135b }, { 0x46cfd, 0x3135c }, { 0x46cfe, 0x3135d },
	{ 0x46cff, 0x3135e }, { 0x46d00, 0x3135f }, { 0x46d01, 0x31360 },
	{ 0x46d02, 0x31361 }, { 0x46d04, 0x31362 }, { 0x46d05, 0x31363 },
	{ 0x46d06, 0x31364 }, { 0x46d07, 0x31365 }, { 0x46d08, 0x31366 },
	{ 0x46d09, 0x31367 }, { 0x46d0a, 0x31368 }, { 0x46d0b, 0x31369 },
	{ 0x46d0c, 0x3136a }, { 0x46d0d, 0x3136b }, { 0x46d0f, 0x3136c },
	{ 0x46d10, 0x3136d }, { 0x46d11, 0x3136e }, { 0x46d12, 0x3136f },
	{ 0x46d13, 0x31370 }, { 0x46d14, 0x31371 }, { 0x46d15, 0x31372 },
	{ 0x46d16, 0x31373 }, { 0x46d17, 0x31374 }, { 0x46d18, 0x31375 },
	{ 0x46d1a, 0x31376 }, { 0x46d1b, 0x31377 }, { 0x46d1c, 0x31378 },
	{ 0x46d1d, 0x31379 }, { 0x46d1e, 0x3137a }, { 0x46d1f, 0x3137b },
	{ 0x46d20, 0x3137c }, { 0x46d21, 0x3137d }, { 0x46d22, 0x3137e },
	{ 0x46d23, 0x3137f }, { 0x46d25, 0x31380 }, { 0x46d26, 0x31381 },
	{ 0x46d27, 0x31382 }, { 0x46d28, 0x31383 }, { 0x46d29, 0x31384 },
	{ 0x46d2a, 0x31385 }, { 0x46d2b, 0x31386 }, { 0x46d2c, 0x31387 },
	{ 0x46d2d, 0x31388 }, { 0x46d2e, 0x31389 }, { 0x46d30, 0x3138a },
	{ 0x46d31, 0x3138b }, { 0x46d32, 0x3138c }, { 0x46d33, 0x3138d },
	{ 0x46d34, 0x3138e }, { 0x46d35, 0x3138f }, { 0x46d36, 0x31390 },
	{ 0x46d37, 0x31391 }, { 0x46d38, 0x31392 }, { 0x46d39, 0x31393 },
	{ 0x46cd2, 0x31394 }, { 0x46cd3, 0x31395 }, { 0x46cd4, 0x31396 },
	{ 0x46cd5, 0x31397 }, { 0x46cd6, 0x31398 }, { 0x46cd7, 0x31399 },
	{ 0x46cd8, 0x3139a }, { 0x46d3b, 0x313d7 }, { 0x46d58, 0x313d6 }
};

#define DESKBOT_COUNT_EN 108
static const TagMapping DESKBOT_MAP_EN[108] = {
	{ 0x46cd0, 0x3ac00 }, { 0x46ce2, 0x3ac10 }, { 0x46ced, 0x3ac1b },
	{ 0x46cf8, 0x3ac26 }, { 0x46d03, 0x3ac31 }, { 0x46d0e, 0x3ac3b },
	{ 0x46d19, 0x3ac46 }, { 0x46d24, 0x3ac51 }, { 0x46d2f, 0x3ac5c },
	{ 0x46cd1, 0x3ac01 }, { 0x46cd9, 0x3ac07 }, { 0x46cda, 0x3ac08 },
	{ 0x46cdb, 0x3ac09 }, { 0x46cdc, 0x3ac0a }, { 0x46cdd, 0x3ac0b },
	{ 0x46cde, 0x3ac0c }, { 0x46cdf, 0x3ac0d }, { 0x46ce0, 0x3ac0e },
	{ 0x46ce1, 0x3ac0f }, { 0x46ce3, 0x3ac11 }, { 0x46ce4, 0x3ac12 },
	{ 0x46ce5, 0x3ac13 }, { 0x46ce6, 0x3ac15 }, { 0x46ce7, 0x3ac16 },
	{ 0x46ce8, 0x3ac17 }, { 0x46ce9, 0x3ac18 }, { 0x46cea, 0x3ac19 },
	{ 0x46ceb, 0x3ac1a }, { 0x46cec, 0x3ac1c }, { 0x46cee, 0x3abf2 },
	{ 0x46cef, 0x3ac1d }, { 0x46cf0, 0x3ac1e }, { 0x46cf1, 0x3ac1f },
	{ 0x46cf2, 0x3ac20 }, { 0x46cf3, 0x3ac21 }, { 0x46cf4, 0x3ac22 },
	{ 0x46cf5, 0x3ac23 }, { 0x46cf6, 0x3ac24 }, { 0x46cf7, 0x3ac25 },
	{ 0x46cf9, 0x3ac27 }, { 0x46cfa, 0x3ac28 }, { 0x46cfb, 0x3ac29 },
	{ 0x46cfc, 0x3ac2a }, { 0x46cfd, 0x3ac2b }, { 0x46cfe, 0x3ac2c },
	{ 0x46cff, 0x3ac2d }, { 0x46d00, 0x3ac2e }, { 0x46d01, 0x3ac2f },
	{ 0x46d02, 0x3ac30 }, { 0x46d04, 0x3ac32 }, { 0x46d05, 0x3ac33 },
	{ 0x46d06, 0x3ac34 }, { 0x46d07, 0x3ac35 }, { 0x46d08, 0x3ac36 },
	{ 0x46d09, 0x3acd2 }, { 0x46d0a, 0x3ac37 }, { 0x46d0b, 0x3ac38 },
	{ 0x46d0c, 0x3ac39 }, { 0x46d0d, 0x3ac3a }, { 0x46d0f, 0x3ac3c },
	{ 0x46d10, 0x3ac3d }, { 0x46d11, 0x3ac3e }, { 0x46d12, 0x3ac3f },
	{ 0x46d13, 0x3ac40 }, { 0x46d14, 0x3ac41 }, { 0x46d15, 0x3ac42 },
	{ 0x46d16, 0x3ac43 }, { 0x46d17, 0x3ac44 }, { 0x46d18, 0x3ac45 },
	{ 0x46d1a, 0x3ac47 }, { 0x46d1b, 0x3ac48 }, { 0x46d1c, 0x3ac49 },
	{ 0x46d1d, 0x3ac4a }, { 0x46d1e, 0x3ac4b }, { 0x46d1f, 0x3ac4c },
	{ 0x46d20, 0x3ac4d }, { 0x46d21, 0x3ac4e }, { 0x46d22, 0x3ac4f },
	{ 0x46d23, 0x3ac50 }, { 0x46d25, 0x3ac52 }, { 0x46d26, 0x3ac53 },
	{ 0x46d27, 0x3ac54 }, { 0x46d28, 0x3ac55 }, { 0x46d29, 0x3ac56 },
	{ 0x46d2a, 0x3ac57 }, { 0x46d2b, 0x3ac58 }, { 0x46d2c, 0x3ac59 },
	{ 0x46d2d, 0x3ac5a }, { 0x46d2e, 0x3ac5b }, { 0x46d30, 0x3ac5d },
	{ 0x46d31, 0x3ac5e }, { 0x46d32, 0x3ac5f }, { 0x46d33, 0x3ac60 },
	{ 0x46d34, 0x3ac61 }, { 0x46d35, 0x3ac62 }, { 0x46d36, 0x3ac63 },
	{ 0x46d37, 0x3ac64 }, { 0x46d38, 0x3ac65 }, { 0x46d39, 0x3ac66 },
	{ 0x46cd2, 0x3ac02 }, { 0x46cd3, 0x3ac03 }, { 0x46cd4, 0x3ac04 },
	{ 0x46cd5, 0x3ac05 }, { 0x46cd6, 0x3ac06 }, { 0x46d3b, 0x3ae27 },
	{ 0x46d58, 0x3ae0e }, { 0x46dd2, 0x3aebc }, { 0x46dd6, 0x3aebd }
};

#define DOORBOT_COUNT_EN 240
static const TagMapping DOORBOT_MAP_EN[240] = {
	{ 0x46cd1, 0x35ee6 }, { 0x46cd2, 0x35ee7 }, { 0x46cd3, 0x35ee8 },
	{ 0x46cd4, 0x35ee9 }, { 0x46cd5, 0x35eea }, { 0x46cd6, 0x35eeb },
	{ 0x46cd7, 0x35eec }, { 0x46cd8, 0x35eed }, { 0x46cd9, 0x35eee },
	{ 0x46cda, 0x35eef }, { 0x46cdb, 0x35ef0 }, { 0x46cdc, 0x35ef1 },
	{ 0x46cdd, 0x35ef2 }, { 0x46cde, 0x35ef3 }, { 0x46cdf, 0x35ef4 },
	{ 0x46ce0, 0x35ef5 }, { 0x46ce1, 0x35ef6 }, { 0x46ce2, 0x35ef7 },
	{ 0x46ce3, 0x35ef8 }, { 0x46ce4, 0x35ef9 }, { 0x46ce5, 0x35efa },
	{ 0x46ce6, 0x35efb }, { 0x46ce7, 0x35efc }, { 0x46ce8, 0x35efd },
	{ 0x46ce9, 0x35efe }, { 0x46cea, 0x35eff }, { 0x46ceb, 0x35f00 },
	{ 0x46cec, 0x35f01 }, { 0x46ced, 0x35f02 }, { 0x46cee, 0x35f03 },
	{ 0x46cef, 0x35f04 }, { 0x46cf0, 0x35f05 }, { 0x46cf1, 0x35f06 },
	{ 0x46cf2, 0x35f07 }, { 0x46cf3, 0x35f08 }, { 0x46cf4, 0x35f09 },
	{ 0x46cf5, 0x35f0a }, { 0x46cf6, 0x35f0b }, { 0x46cf7, 0x35f0c },
	{ 0x46cf8, 0x35f0d }, { 0x46cf9, 0x35f0e }, { 0x46cfa, 0x35f0f },
	{ 0x46cfb, 0x35f10 }, { 0x46cfc, 0x35f11 }, { 0x46cfd, 0x35f12 },
	{ 0x46cfe, 0x35f13 }, { 0x46cff, 0x35f14 }, { 0x46d00, 0x35f15 },
	{ 0x46d01, 0x35f16 }, { 0x46d02, 0x35f17 }, { 0x46d03, 0x35f18 },
	{ 0x46d04, 0x35f19 }, { 0x46d05, 0x35f1a }, { 0x46d06, 0x35f1b },
	{ 0x46d07, 0x35f1c }, { 0x46d08, 0x35f1d }, { 0x46d09, 0x35f1e },
	{ 0x46d0a, 0x35f1f }, { 0x46d0b, 0x35f20 }, { 0x46d0c, 0x35f21 },
	{ 0x46d0d, 0x35f22 }, { 0x46d0e, 0x35f23 }, { 0x46d0f, 0x35f24 },
	{ 0x46d10, 0x35f25 }, { 0x46d11, 0x35f26 }, { 0x46d12, 0x35f27 },
	{ 0x46d13, 0x35f28 }, { 0x46d14, 0x35f29 }, { 0x46d15, 0x35f2a },
	{ 0x46d16, 0x35f2b }, { 0x46d17, 0x35f2c }, { 0x46d18, 0x35f2d },
	{ 0x46d19, 0x35f2e }, { 0x46d1a, 0x35f2f }, { 0x46d1b, 0x35f30 },
	{ 0x46d1c, 0x35f31 }, { 0x46d1d, 0x35f32 }, { 0x46d1e, 0x35f33 },
	{ 0x46d1f, 0x35f34 }, { 0x46d20, 0x35f35 }, { 0x46d21, 0x35f36 },
	{ 0x46d22, 0x35f37 }, { 0x46d23, 0x35f38 }, { 0x46d24, 0x35f39 },
	{ 0x46d25, 0x35f3a }, { 0x46d26, 0x35f3b }, { 0x46d27, 0x35f3c },
	{ 0x46d28, 0x35f3d }, { 0x46d29, 0x35f3e }, { 0x46d2a, 0x35f3f },
	{ 0x46d2b, 0x35f40 }, { 0x46d2c, 0x35f41 }, { 0x46d2d, 0x35f42 },
	{ 0x46d2e, 0x35f43 }, { 0x46d2f, 0x35f44 }, { 0x46d30, 0x35f45 },
	{ 0x46d31, 0x35f46 }, { 0x46d32, 0x35f47 }, { 0x46d33, 0x35f48 },
	{ 0x46d34, 0x35f49 }, { 0x46d35, 0x35f4a }, { 0x46d36, 0x35f4b },
	{ 0x46d37, 0x35f4c }, { 0x46d38, 0x35f4d }, { 0x46d39, 0x35f4e },
	{ 0x46d3a, 0x35bf5 }, { 0x46d3b, 0x360c0 }, { 0x46d3d, 0x36027 },
	{ 0x46d3e, 0x36028 }, { 0x46d3f, 0x36029 }, { 0x46d40, 0x3602a },
	{ 0x46d41, 0x3602e }, { 0x46d42, 0x3602f }, { 0x46d43, 0x36030 },
	{ 0x46d44, 0x36031 }, { 0x46d45, 0x3602c }, { 0x46d46, 0x3602d },
	{ 0x46d47, 0x36227 }, { 0x46d48, 0x36084 }, { 0x46d49, 0x36085 },
	{ 0x46d4a, 0x36467 }, { 0x46d4b, 0x36457 }, { 0x46d4c, 0x36457 },
	{ 0x46d4d, 0x36457 }, { 0x46d4e, 0x3646d }, { 0x46d4f, 0x36457 },
	{ 0x46d50, 0x36470 }, { 0x46d51, 0x36457 }, { 0x46d52, 0x36457 },
	{ 0x46d53, 0x36457 }, { 0x46d55, 0x360a3 }, { 0x46d56, 0x3634c },
	{ 0x46d57, 0x36457 }, { 0x46d54, 0x36457 }, { 0x46d58, 0x360bf },
	{ 0x46d5a, 0x36407 }, { 0x46d5b, 0x3640c }, { 0x46d5c, 0x3641a },
	{ 0x46d5d, 0x36420 }, { 0x46d5e, 0x36421 }, { 0x46d5f, 0x36422 },
	{ 0x46d60, 0x36423 }, { 0x46d61, 0x36424 }, { 0x46d66, 0x36408 },
	{ 0x46d67, 0x36409 }, { 0x46d68, 0x3640a }, { 0x46d69, 0x3640b },
	{ 0x46d6a, 0x3640d }, { 0x46d6e, 0x36415 }, { 0x46d6f, 0x36416 },
	{ 0x46d70, 0x36417 }, { 0x46d71, 0x36418 }, { 0x46d72, 0x36419 },
	{ 0x46d73, 0x3640e }, { 0x46d74, 0x3640f }, { 0x46d75, 0x36410 },
	{ 0x46d76, 0x36411 }, { 0x46d77, 0x36412 }, { 0x46d7e, 0x3641b },
	{ 0x46d7f, 0x3641c }, { 0x46d80, 0x3641d }, { 0x46d81, 0x3641e },
	{ 0x46d82, 0x3641f }, { 0x46d88, 0x362d4 }, { 0x46d89, 0x362db },
	{ 0x46d8a, 0x362e2 }, { 0x46d8b, 0x362e3 }, { 0x46d8c, 0x362e7 },
	{ 0x46d8d, 0x362eb }, { 0x46d8e, 0x362f2 }, { 0x46d8f, 0x362f5 },
	{ 0x46d90, 0x36305 }, { 0x46d91, 0x36457 }, { 0x46d92, 0x36309 },
	{ 0x46d93, 0x362f4 }, { 0x46d94, 0x3630a }, { 0x46d96, 0x36318 },
	{ 0x46d97, 0x36319 }, { 0x46d98, 0x36326 }, { 0x46d99, 0x36327 },
	{ 0x46d9a, 0x3632e }, { 0x46d9b, 0x3632f }, { 0x46d9c, 0x36330 },
	{ 0x46d9d, 0x362f3 }, { 0x46d9e, 0x362b0 }, { 0x46d9f, 0x362b1 },
	{ 0x46da0, 0x362b2 }, { 0x46da1, 0x362b3 }, { 0x46da2, 0x362b4 },
	{ 0x46da3, 0x362b5 }, { 0x46da4, 0x362b9 }, { 0x46da5, 0x362bb },
	{ 0x46da6, 0x362ba }, { 0x46da7, 0x362bc }, { 0x46da8, 0x362b8 },
	{ 0x46da9, 0x362bd }, { 0x46daa, 0x362be }, { 0x46dab, 0x362bf },
	{ 0x46dac, 0x362c0 }, { 0x46dad, 0x362c1 }, { 0x46dae, 0x362c2 },
	{ 0x46daf, 0x362b6 }, { 0x46db0, 0x36314 }, { 0x46db1, 0x362c3 },
	{ 0x46db2, 0x362c4 }, { 0x46db3, 0x362c5 }, { 0x46db4, 0x362c6 },
	{ 0x46db5, 0x362c7 }, { 0x46db6, 0x362c8 }, { 0x46db7, 0x362ca },
	{ 0x46db8, 0x362cc }, { 0x46db9, 0x362cb }, { 0x46dba, 0x362cd },
	{ 0x46dbb, 0x362c9 }, { 0x46dbc, 0x362ce }, { 0x46dbd, 0x362cf },
	{ 0x46dbe, 0x362d0 }, { 0x46dbf, 0x362d1 }, { 0x46dc0, 0x362d2 },
	{ 0x46dc1, 0x362d3 }, { 0x46dc2, 0x3637c }, { 0x46dc3, 0x3627c },
	{ 0x46dc4, 0x36497 }, { 0x46dc5, 0x36493 }, { 0x46dc6, 0x3647f },
	{ 0x46dc7, 0x3647c }, { 0x46dc8, 0x36482 }, { 0x46dc9, 0x3648a },
	{ 0x46dca, 0x3649b }, { 0x46dcb, 0x364b6 }, { 0x46dcc, 0x364aa },
	{ 0x46dcd, 0x364a1 }, { 0x46dce, 0x364b0 }, { 0x46dcf, 0x364a7 },
	{ 0x46dd1, 0x364b9 }, { 0x46dd2, 0x36370 }, { 0x46dd3, 0x363ab },
	{ 0x46dd4, 0x36404 }, { 0x46dd5, 0x362ab }, { 0x46dd6, 0x3636d }
};

#define LIFTBOT_COUNT_EN 118
static const TagMapping LIFTBOT_MAP_EN[118] = {
	{ 0x46cd1, 0x335b5 }, { 0x46cd2, 0x33603 }, { 0x46cd3, 0x33604 },
	{ 0x46cd4, 0x33605 }, { 0x46cd5, 0x33606 }, { 0x46cd6, 0x33607 },
	{ 0x46cd7, 0x33608 }, { 0x46cd8, 0x33607 }, { 0x46cd9, 0x335b6 },
	{ 0x46cda, 0x335b7 }, { 0x46cdb, 0x335b8 }, { 0x46cdc, 0x335b9 },
	{ 0x46cdd, 0x335ba }, { 0x46cde, 0x335bb }, { 0x46cdf, 0x335bc },
	{ 0x46ce0, 0x335bd }, { 0x46ce1, 0x335bf }, { 0x46ce2, 0x335ac },
	{ 0x46ce3, 0x335c0 }, { 0x46ce4, 0x335c1 }, { 0x46ce5, 0x335c2 },
	{ 0x46ce6, 0x335c4 }, { 0x46ce7, 0x335c5 }, { 0x46ce8, 0x335c6 },
	{ 0x46ce9, 0x335c7 }, { 0x46cea, 0x335c8 }, { 0x46ceb, 0x335ca },
	{ 0x46cec, 0x335cb }, { 0x46ced, 0x335ad }, { 0x46cee, 0x335cc },
	{ 0x46cef, 0x335ce }, { 0x46cf0, 0x335d0 }, { 0x46cf1, 0x335d1 },
	{ 0x46cf2, 0x335d2 }, { 0x46cf3, 0x335d4 }, { 0x46cf4, 0x335d5 },
	{ 0x46cf5, 0x335d6 }, { 0x46cf6, 0x335d7 }, { 0x46cf7, 0x335d8 },
	{ 0x46cf8, 0x335ae }, { 0x46cf9, 0x335d9 }, { 0x46cfa, 0x335db },
	{ 0x46cfb, 0x335de }, { 0x46cfc, 0x335df }, { 0x46cfd, 0x335e0 },
	{ 0x46cfe, 0x335e1 }, { 0x46cff, 0x335e2 }, { 0x46d00, 0x335e3 },
	{ 0x46d01, 0x335e4 }, { 0x46d02, 0x335e5 }, { 0x46d03, 0x335af },
	{ 0x46d04, 0x335e6 }, { 0x46d05, 0x335e7 }, { 0x46d06, 0x335ea },
	{ 0x46d07, 0x335eb }, { 0x46d08, 0x335ec }, { 0x46d09, 0x3364a },
	{ 0x46d0a, 0x3364b }, { 0x46d0b, 0x3364c }, { 0x46d0c, 0x3364d },
	{ 0x46d0d, 0x3364e }, { 0x46d0e, 0x335b0 }, { 0x46d0f, 0x33650 },
	{ 0x46d10, 0x33651 }, { 0x46d11, 0x33652 }, { 0x46d12, 0x33653 },
	{ 0x46d13, 0x33654 }, { 0x46d14, 0x33656 }, { 0x46d15, 0x33657 },
	{ 0x46d16, 0x33658 }, { 0x46d17, 0x33659 }, { 0x46d18, 0x3365b },
	{ 0x46d19, 0x335b1 }, { 0x46d1a, 0x3365c }, { 0x46d1b, 0x3365d },
	{ 0x46d1c, 0x3365e }, { 0x46d1d, 0x3365f }, { 0x46d1e, 0x33660 },
	{ 0x46d1f, 0x33661 }, { 0x46d20, 0x33662 }, { 0x46d21, 0x33663 },
	{ 0x46d22, 0x335a9 }, { 0x46d23, 0x335aa }, { 0x46d24, 0x335b2 },
	{ 0x46d25, 0x335ed }, { 0x46d26, 0x335ee }, { 0x46d27, 0x335ef },
	{ 0x46d28, 0x335f0 }, { 0x46d29, 0x335f1 }, { 0x46d2a, 0x335f2 },
	{ 0x46d2b, 0x335f4 }, { 0x46d2c, 0x335f5 }, { 0x46d2d, 0x335f6 },
	{ 0x46d2e, 0x335f7 }, { 0x46d2f, 0x335b4 }, { 0x46d30, 0x335f8 },
	{ 0x46d31, 0x335f9 }, { 0x46d32, 0x335fa }, { 0x46d33, 0x335fb },
	{ 0x46d34, 0x335fc }, { 0x46d35, 0x335fd }, { 0x46d36, 0x335ff },
	{ 0x46d37, 0x33600 }, { 0x46d38, 0x33601 }, { 0x46d39, 0x33602 },
	{ 0x46d3a, 0x3380f }, { 0x46d3b, 0x33695 }, { 0x46d47, 0x07536 },
	{ 0x46d4a, 0x3360c }, { 0x46d4e, 0x337fc }, { 0x46d50, 0x337fd },
	{ 0x46d56, 0x33800 }, { 0x46d58, 0x33694 }, { 0x46dc2, 0x337f3 },
	{ 0x46dc6, 0x337fb }, { 0x46dc7, 0x337f9 }, { 0x46dca, 0x33802 },
	{ 0x46dd3, 0x33775 }
};

#define MAITRED_COUNT_EN 108
static const TagMapping MAITRED_MAP_EN[] = {
	{ 0x46cd0, 0x3f94c }, { 0x46ce2, 0x3f9a6 }, { 0x46ced, 0x3f9a7 },
	{ 0x46cf8, 0x3f9a8 }, { 0x46d03, 0x3f9a9 }, { 0x46d0e, 0x3f9aa },
	{ 0x46d19, 0x3f9ab }, { 0x46d24, 0x3f9ac }, { 0x46d2f, 0x3f9ad },
	{ 0x46cd1, 0x3f9ae }, { 0x46cd9, 0x3f9af }, { 0x46cda, 0x3f9b0 },
	{ 0x46cdb, 0x3f9b1 }, { 0x46cdc, 0x3f9b2 }, { 0x46cdd, 0x3f9b3 },
	{ 0x46cde, 0x3f9b4 }, { 0x46cdf, 0x3f9b5 }, { 0x46ce0, 0x3f9b6 },
	{ 0x46ce1, 0x3f9b7 }, { 0x46ce3, 0x3f9b8 }, { 0x46ce4, 0x3f9b9 },
	{ 0x46ce5, 0x3f9ba }, { 0x46ce6, 0x3f9bb }, { 0x46ce7, 0x3f9bc },
	{ 0x46ce8, 0x3f9bd }, { 0x46ce9, 0x3f9be }, { 0x46cea, 0x3f9bf },
	{ 0x46ceb, 0x3f9c0 }, { 0x46cec, 0x3f9c1 }, { 0x46cee, 0x3f9c2 },
	{ 0x46cef, 0x3f9c3 }, { 0x46cf0, 0x3f9c4 }, { 0x46cf1, 0x3f9c5 },
	{ 0x46cf2, 0x3f9c6 }, { 0x46cf3, 0x3f9c7 }, { 0x46cf4, 0x3f9c8 },
	{ 0x46cf5, 0x3f9c9 }, { 0x46cf6, 0x3f9ca }, { 0x46cf7, 0x3f9cb },
	{ 0x46cf9, 0x3f9cc }, { 0x46cfa, 0x3f9cd }, { 0x46cfb, 0x3f9ce },
	{ 0x46cfc, 0x3f9cf }, { 0x46cfd, 0x3f9d0 }, { 0x46cfe, 0x3f9d1 },
	{ 0x46cff, 0x3f9d2 }, { 0x46d00, 0x3f9d3 }, { 0x46d01, 0x3f9d4 },
	{ 0x46d02, 0x3f9d5 }, { 0x46d04, 0x3f9d6 }, { 0x46d05, 0x3f9d7 },
	{ 0x46d06, 0x3f9d9 }, { 0x46d07, 0x3f9da }, { 0x46d08, 0x3f9db },
	{ 0x46d09, 0x3f98a }, { 0x46d0a, 0x3f98b }, { 0x46d0b, 0x3f98c },
	{ 0x46d0c, 0x3f98d }, { 0x46d0d, 0x3f98e }, { 0x46d0f, 0x3f98f },
	{ 0x46d10, 0x3f991 }, { 0x46d11, 0x3f992 }, { 0x46d12, 0x3f993 },
	{ 0x46d13, 0x3f994 }, { 0x46d14, 0x3f996 }, { 0x46d15, 0x3f997 },
	{ 0x46d16, 0x3f998 }, { 0x46d17, 0x3f999 }, { 0x46d18, 0x3f99a },
	{ 0x46d1a, 0x3f99b }, { 0x46d1b, 0x3f99c }, { 0x46d1c, 0x3f99d },
	{ 0x46d1d, 0x3f99e }, { 0x46d1e, 0x3f99f }, { 0x46d1f, 0x3f9a1 },
	{ 0x46d20, 0x3f9a2 }, { 0x46d21, 0x3f9a3 }, { 0x46d22, 0x3f9a4 },
	{ 0x46d23, 0x3f9a5 }, { 0x46d25, 0x3f9dd }, { 0x46d26, 0x3f9de },
	{ 0x46d27, 0x3f9df }, { 0x46d28, 0x3f9e0 }, { 0x46d29, 0x3f9e1 },
	{ 0x46d2a, 0x3f9e2 }, { 0x46d2b, 0x3f9e3 }, { 0x46d2c, 0x3f9e4 },
	{ 0x46d2d, 0x3f9e5 }, { 0x46d2e, 0x3f9e6 }, { 0x46d30, 0x3f9e7 },
	{ 0x46d31, 0x3f9e8 }, { 0x46d32, 0x3f9e9 }, { 0x46d33, 0x3f9ea },
	{ 0x46d34, 0x3f9eb }, { 0x46d35, 0x3f9ec }, { 0x46d36, 0x3f9ed },
	{ 0x46d37, 0x3f9ee }, { 0x46d38, 0x3f9ef }, { 0x46d39, 0x3f9f0 },
	{ 0x46cd2, 0x3f9f1 }, { 0x46cd3, 0x3f9f2 }, { 0x46cd4, 0x3f9f3 },
	{ 0x46cd5, 0x3f9f9 }, { 0x46cd6, 0x3f9fa }, { 0x46cd7, 0x3f9fb },
	{ 0x46cd8, 0x3f9fc }, { 0x46d3b, 0x3f853 }, { 0x46d58, 0x3f83c }
};

#define BARBOT_COUNT_DE 229
static const TagMapping BARBOT_MAP_DE[229] = {
	{ 0x46cd0, 0x3d21e }, { 0x46ce2, 0x3d23b }, { 0x46ced, 0x3d246 },
	{ 0x46cf8, 0x3d251 }, { 0x46d03, 0x3d25c }, { 0x46d0e, 0x3d267 },
	{ 0x46d19, 0x3d272 }, { 0x46d24, 0x3d27d }, { 0x46d2f, 0x3d288 },
	{ 0x46cd1, 0x3d21f }, { 0x46cd9, 0x3d22a }, { 0x46cda, 0x3d233 },
	{ 0x46cdb, 0x3d234 }, { 0x46cdc, 0x3d235 }, { 0x46cdd, 0x3d236 },
	{ 0x46cde, 0x3d237 }, { 0x46cdf, 0x3d238 }, { 0x46ce0, 0x3d239 },
	{ 0x46ce1, 0x3d23a }, { 0x46ce3, 0x3d23c }, { 0x46ce4, 0x3d23d },
	{ 0x46ce5, 0x3d23e }, { 0x46ce6, 0x3d23f }, { 0x46ce7, 0x3d240 },
	{ 0x46ce8, 0x3d241 }, { 0x46ce9, 0x3d242 }, { 0x46cea, 0x3d243 },
	{ 0x46ceb, 0x3d244 }, { 0x46cec, 0x3d245 }, { 0x46cee, 0x3d26b },
	{ 0x46cef, 0x3d247 }, { 0x46cf0, 0x3d248 }, { 0x46cf1, 0x3d249 },
	{ 0x46cf2, 0x3d24a }, { 0x46cf3, 0x3d24b }, { 0x46cf4, 0x3d24c },
	{ 0x46cf5, 0x3d24d }, { 0x46cf6, 0x3d24e }, { 0x46cf7, 0x3d24f },
	{ 0x46cf9, 0x3d250 }, { 0x46cfa, 0x3d252 }, { 0x46cfb, 0x3d253 },
	{ 0x46cfc, 0x3d254 }, { 0x46cfd, 0x3d255 }, { 0x46cfe, 0x3d256 },
	{ 0x46cff, 0x3d257 }, { 0x46d00, 0x3d258 }, { 0x46d01, 0x3d259 },
	{ 0x46d02, 0x3d25a }, { 0x46d04, 0x3d25b }, { 0x46d05, 0x3d25d },
	{ 0x46d06, 0x3d25e }, { 0x46d07, 0x3d25f }, { 0x46d08, 0x3d260 },
	{ 0x46d09, 0x3d26f }, { 0x46d0a, 0x3d270 }, { 0x46d0b, 0x3d271 },
	{ 0x46d0c, 0x3d273 }, { 0x46d0d, 0x3d274 }, { 0x46d0f, 0x3d275 },
	{ 0x46d10, 0x3d276 }, { 0x46d11, 0x3d277 }, { 0x46d12, 0x3d278 },
	{ 0x46d13, 0x3d279 }, { 0x46d1d, 0x3d283 }, { 0x46d1e, 0x3d284 },
	{ 0x46d1f, 0x3d285 }, { 0x46d20, 0x3d286 }, { 0x46d21, 0x3d287 },
	{ 0x46d22, 0x3d289 }, { 0x46d23, 0x3d28a }, { 0x46d25, 0x3d28b },
	{ 0x46d26, 0x3d28c }, { 0x46d27, 0x3d28d }, { 0x46d28, 0x3d28e },
	{ 0x46d29, 0x3d28f }, { 0x46d2a, 0x3d290 }, { 0x46d2b, 0x3d291 },
	{ 0x46d2c, 0x3d292 }, { 0x46cd2, 0x3d22d }, { 0x46cd3, 0x3d22e },
	{ 0x46cd5, 0x3d22f }, { 0x46cd6, 0x3d230 }, { 0x46cd7, 0x3d231 },
	{ 0x46cd8, 0x3d232 }, { 0x46d3a, 0x3d768 }, { 0x46d3b, 0x3d372 },
	{ 0x46d48, 0x3d7ce }, { 0x46d49, 0x3d7cf }, { 0x46d4a, 0x3d6f1 },
	{ 0x46d4b, 0x3d77c }, { 0x46d4c, 0x3d49d }, { 0x46d4d, 0x3d77c },
	{ 0x46d4e, 0x3d0b5 }, { 0x46d4f, 0x3d177 }, { 0x46d50, 0x3d2d7 },
	{ 0x46d51, 0x3d77c }, { 0x46d52, 0x3d77c }, { 0x46d53, 0x3d30b },
	{ 0x46d55, 0x3d706 }, { 0x46d56, 0x3d704 }, { 0x46d57, 0x3d77c },
	{ 0x46d54, 0x3d0a0 }, { 0x46d58, 0x3d722 }, { 0x46d5a, 0x3d44a },
	{ 0x46d5b, 0x3d452 }, { 0x46d5c, 0x3d469 }, { 0x46d5d, 0x3d475 },
	{ 0x46d5e, 0x3d476 }, { 0x46d5f, 0x3d477 }, { 0x46d60, 0x3d478 },
	{ 0x46d61, 0x3d479 }, { 0x46d62, 0x3d47a }, { 0x46d63, 0x3d44b },
	{ 0x46d64, 0x3d44c }, { 0x46d65, 0x3d44d }, { 0x46d66, 0x3d44e },
	{ 0x46d67, 0x3d44f }, { 0x46d68, 0x3d450 }, { 0x46d69, 0x3d451 },
	{ 0x46d6a, 0x3d453 }, { 0x46d6b, 0x3d460 }, { 0x46d6c, 0x3d462 },
	{ 0x46d6d, 0x3d463 }, { 0x46d6e, 0x3d464 }, { 0x46d6f, 0x3d465 },
	{ 0x46d70, 0x3d466 }, { 0x46d71, 0x3d467 }, { 0x46d72, 0x3d468 },
	{ 0x46d73, 0x3d454 }, { 0x46d74, 0x3d455 }, { 0x46d75, 0x3d456 },
	{ 0x46d76, 0x3d457 }, { 0x46d77, 0x3d458 }, { 0x46d78, 0x3d459 },
	{ 0x46d79, 0x3d45a }, { 0x46d7a, 0x3d45b }, { 0x46d7b, 0x3d45c },
	{ 0x46d7c, 0x3d45f }, { 0x46d7d, 0x3d461 }, { 0x46d7e, 0x3d46a },
	{ 0x46d7f, 0x3d46d }, { 0x46d80, 0x3d46e }, { 0x46d81, 0x3d46f },
	{ 0x46d82, 0x3d470 }, { 0x46d83, 0x3d471 }, { 0x46d84, 0x3d472 },
	{ 0x46d85, 0x3d473 }, { 0x46d86, 0x3d474 }, { 0x46d87, 0x3d46b },
	{ 0x46d88, 0x3d75d }, { 0x46d89, 0x3d75e }, { 0x46d8a, 0x3d75f },
	{ 0x46d8b, 0x3d760 }, { 0x46d8c, 0x3d761 }, { 0x46d8d, 0x3d762 },
	{ 0x46d8e, 0x3d763 }, { 0x46d8f, 0x3d766 }, { 0x46d90, 0x3d767 },
	{ 0x46d91, 0x3d77c }, { 0x46d92, 0x3d768 }, { 0x46d93, 0x3d765 },
	{ 0x46d94, 0x3d769 }, { 0x46d95, 0x3d770 }, { 0x46d96, 0x3d775 },
	{ 0x46d97, 0x3d776 }, { 0x46d98, 0x3d777 }, { 0x46d99, 0x3d778 },
	{ 0x46d9a, 0x3d779 }, { 0x46d9b, 0x3d77a }, { 0x46d9c, 0x3d77b },
	{ 0x46d9d, 0x3d764 }, { 0x46d9e, 0x3d739 }, { 0x46d9f, 0x3d73a },
	{ 0x46da0, 0x3d73b }, { 0x46da1, 0x3d73c }, { 0x46da2, 0x3d73d },
	{ 0x46da3, 0x3d73e }, { 0x46da4, 0x3d742 }, { 0x46da5, 0x3d744 },
	{ 0x46da6, 0x3d743 }, { 0x46da7, 0x3d745 }, { 0x46da8, 0x3d741 },
	{ 0x46da9, 0x3d746 }, { 0x46daa, 0x3d747 }, { 0x46dab, 0x3d748 },
	{ 0x46dac, 0x3d749 }, { 0x46dad, 0x3d74a }, { 0x46dae, 0x3d74b },
	{ 0x46daf, 0x3d73f }, { 0x46db0, 0x3d771 }, { 0x46db1, 0x3d74c },
	{ 0x46db2, 0x3d74d }, { 0x46db3, 0x3d74e }, { 0x46db4, 0x3d74f },
	{ 0x46db5, 0x3d750 }, { 0x46db6, 0x3d751 }, { 0x46db7, 0x3d753 },
	{ 0x46db8, 0x3d755 }, { 0x46db9, 0x3d754 }, { 0x46dba, 0x3d756 },
	{ 0x46dbb, 0x3d752 }, { 0x46dbc, 0x3d757 }, { 0x46dbd, 0x3d758 },
	{ 0x46dbe, 0x3d759 }, { 0x46dbf, 0x3d75a }, { 0x46dc0, 0x3d75b },
	{ 0x46dc1, 0x3d75c }, { 0x46dc2, 0x3d4a7 }, { 0x46dc3, 0x3d2bf },
	{ 0x46dc4, 0x3d6fa }, { 0x46dc5, 0x3d6f9 }, { 0x46dc6, 0x3d6fb },
	{ 0x46dc7, 0x3d6f5 }, { 0x46dc8, 0x3d6fc }, { 0x46dc9, 0x3d6ff },
	{ 0x46dca, 0x3d2ab }, { 0x46dcb, 0x3d715 }, { 0x46dcc, 0x3d710 },
	{ 0x46dcd, 0x3d70c }, { 0x46dce, 0x3d712 }, { 0x46dcf, 0x3d70f },
	{ 0x46dd0, 0x3d717 }, { 0x46dd1, 0x3d716 }, { 0x46dd2, 0x3d285 },
	{ 0x46dd3, 0x3d269 }, { 0x46dd4, 0x3d2f8 }, { 0x46dd5, 0x0c429 },
	{ 0x46dd6, 0x0c400 }
};

#define BELLBOT_COUNT_DE 108
static const TagMapping BELLBOT_MAP_DE[108] = {
	{ 0x46cd0, 0x31331 }, { 0x46ce2, 0x31332 }, { 0x46ced, 0x31333 },
	{ 0x46cf8, 0x31334 }, { 0x46d03, 0x31335 }, { 0x46d0e, 0x31336 },
	{ 0x46d19, 0x31337 }, { 0x46d24, 0x31338 }, { 0x46d2f, 0x31339 },
	{ 0x46cd1, 0x3133a }, { 0x46cd9, 0x3133b }, { 0x46cda, 0x3133c },
	{ 0x46cdb, 0x3133d }, { 0x46cdc, 0x3133e }, { 0x46cdd, 0x3133f },
	{ 0x46cde, 0x31340 }, { 0x46cdf, 0x31341 }, { 0x46ce0, 0x31342 },
	{ 0x46ce1, 0x31343 }, { 0x46ce3, 0x31344 }, { 0x46ce4, 0x31345 },
	{ 0x46ce5, 0x31346 }, { 0x46ce6, 0x31347 }, { 0x46ce7, 0x31348 },
	{ 0x46ce8, 0x31349 }, { 0x46ce9, 0x3134a }, { 0x46cea, 0x3134b },
	{ 0x46ceb, 0x3134c }, { 0x46cec, 0x3134d }, { 0x46cee, 0x3134e },
	{ 0x46cef, 0x3134f }, { 0x46cf0, 0x31350 }, { 0x46cf1, 0x31351 },
	{ 0x46cf2, 0x31352 }, { 0x46cf3, 0x31353 }, { 0x46cf4, 0x31354 },
	{ 0x46cf5, 0x31355 }, { 0x46cf6, 0x31356 }, { 0x46cf7, 0x31357 },
	{ 0x46cf9, 0x31358 }, { 0x46cfa, 0x31359 }, { 0x46cfb, 0x3135a },
	{ 0x46cfc, 0x3135b }, { 0x46cfd, 0x3135c }, { 0x46cfe, 0x3135d },
	{ 0x46cff, 0x3135e }, { 0x46d00, 0x3135f }, { 0x46d01, 0x31360 },
	{ 0x46d02, 0x31361 }, { 0x46d04, 0x31362 }, { 0x46d05, 0x31363 },
	{ 0x46d06, 0x31364 }, { 0x46d07, 0x31365 }, { 0x46d08, 0x31366 },
	{ 0x46d09, 0x31367 }, { 0x46d0a, 0x31368 }, { 0x46d0b, 0x31369 },
	{ 0x46d0c, 0x3136a }, { 0x46d0d, 0x3136b }, { 0x46d0f, 0x3136c },
	{ 0x46d10, 0x3136d }, { 0x46d11, 0x3136e }, { 0x46d12, 0x3136f },
	{ 0x46d13, 0x31370 }, { 0x46d14, 0x31371 }, { 0x46d15, 0x31372 },
	{ 0x46d16, 0x31373 }, { 0x46d17, 0x31374 }, { 0x46d18, 0x31375 },
	{ 0x46d1a, 0x31376 }, { 0x46d1b, 0x31377 }, { 0x46d1c, 0x31378 },
	{ 0x46d1d, 0x31379 }, { 0x46d1e, 0x3137a }, { 0x46d1f, 0x3137b },
	{ 0x46d20, 0x3137c }, { 0x46d21, 0x3137d }, { 0x46d22, 0x3137e },
	{ 0x46d23, 0x3137f }, { 0x46d25, 0x31380 }, { 0x46d26, 0x31381 },
	{ 0x46d27, 0x31382 }, { 0x46d28, 0x31383 }, { 0x46d29, 0x31384 },
	{ 0x46d2a, 0x31385 }, { 0x46d2b, 0x31386 }, { 0x46d2c, 0x31387 },
	{ 0x46d2d, 0x31388 }, { 0x46d2e, 0x31389 }, { 0x46d30, 0x3138a },
	{ 0x46d31, 0x3138b }, { 0x46d32, 0x3138c }, { 0x46d33, 0x3138d },
	{ 0x46d34, 0x3138e }, { 0x46d35, 0x3138f }, { 0x46d36, 0x31390 },
	{ 0x46d37, 0x31391 }, { 0x46d38, 0x31392 }, { 0x46d39, 0x31393 },
	{ 0x46cd2, 0x31394 }, { 0x46cd3, 0x31395 }, { 0x46cd4, 0x31396 },
	{ 0x46cd5, 0x31397 }, { 0x46cd6, 0x31398 }, { 0x46cd7, 0x31399 },
	{ 0x46cd8, 0x3139a }, { 0x46d3b, 0x313d7 }, { 0x46d58, 0x313d6 }
};

#define DESKBOT_COUNT_DE 101
static const TagMapping DESKBOT_MAP_DE[101] = {
	{ 0x46cd0, 0x3ac00 }, { 0x46ce2, 0x3ac10 }, { 0x46ced, 0x3ac1b },
	{ 0x46cf8, 0x3ac26 }, { 0x46d03, 0x3ac31 }, { 0x46d0e, 0x3ac3b },
	{ 0x46d19, 0x3ac46 }, { 0x46d24, 0x3ac51 }, { 0x46d2f, 0x3ac5c },
	{ 0x46cd1, 0x3ac01 }, { 0x46cd9, 0x3ac07 }, { 0x46cda, 0x3ac08 },
	{ 0x46cdb, 0x3ac09 }, { 0x46cdc, 0x3ac0a }, { 0x46cdf, 0x3ac0d },
	{ 0x46ce0, 0x3ac0e }, { 0x46ce1, 0x3ac0f }, { 0x46ce3, 0x3ac11 },
	{ 0x46ce4, 0x3ac12 }, { 0x46ce5, 0x3ac13 }, { 0x46ce6, 0x3ac15 },
	{ 0x46ce7, 0x3ac16 }, { 0x46ce8, 0x3ac17 }, { 0x46ce9, 0x3ac18 },
	{ 0x46cea, 0x3ac19 }, { 0x46ceb, 0x3ac1a }, { 0x46cec, 0x3ac1c },
	{ 0x46cee, 0x3abf2 }, { 0x46cef, 0x3ac1d }, { 0x46cf0, 0x3ac1e },
	{ 0x46cf3, 0x3ac21 }, { 0x46cf4, 0x3ac22 }, { 0x46cf5, 0x3ac23 },
	{ 0x46cf6, 0x3ac24 }, { 0x46cf7, 0x3ac25 }, { 0x46cf9, 0x3ac27 },
	{ 0x46cfa, 0x3ac28 }, { 0x46cfb, 0x3ac29 }, { 0x46cfc, 0x3ac2a },
	{ 0x46cfd, 0x3ac2b }, { 0x46cfe, 0x3ac2c }, { 0x46cff, 0x3ac2d },
	{ 0x46d00, 0x3ac2e }, { 0x46d01, 0x3ac2f }, { 0x46d04, 0x3ac32 },
	{ 0x46d05, 0x3ac33 }, { 0x46d08, 0x3ac36 }, { 0x46d09, 0x3acd2 },
	{ 0x46d0a, 0x3ac37 }, { 0x46d0b, 0x3ac38 }, { 0x46d0c, 0x3ac39 },
	{ 0x46d0d, 0x3ac3a }, { 0x46d0f, 0x3ac3c }, { 0x46d10, 0x3ac3d },
	{ 0x46d11, 0x3ac3e }, { 0x46d12, 0x3ac3f }, { 0x46d13, 0x3ac40 },
	{ 0x46d14, 0x3ac41 }, { 0x46d15, 0x3ac42 }, { 0x46d16, 0x3ac43 },
	{ 0x46d17, 0x3ac44 }, { 0x46d18, 0x3ac45 }, { 0x46d1a, 0x3ac47 },
	{ 0x46d1b, 0x3ac48 }, { 0x46d1c, 0x3ac49 }, { 0x46d1d, 0x3ac4a },
	{ 0x46d1e, 0x3ac4b }, { 0x46d1f, 0x3ac4c }, { 0x46d20, 0x3ac4d },
	{ 0x46d21, 0x3ac4e }, { 0x46d22, 0x3ac4f }, { 0x46d23, 0x3ac50 },
	{ 0x46d25, 0x3ac52 }, { 0x46d26, 0x3ac53 }, { 0x46d27, 0x3ac54 },
	{ 0x46d28, 0x3ac55 }, { 0x46d29, 0x3ac56 }, { 0x46d2a, 0x3ac57 },
	{ 0x46d2b, 0x3ac58 }, { 0x46d2c, 0x3ac59 }, { 0x46d2d, 0x3ac5a },
	{ 0x46d2e, 0x3ac5b }, { 0x46d30, 0x3ac5d }, { 0x46d31, 0x3ac5e },
	{ 0x46d32, 0x3ac5f }, { 0x46d33, 0x3ac60 }, { 0x46d34, 0x3ac61 },
	{ 0x46d35, 0x3ac62 }, { 0x46d36, 0x3ac63 }, { 0x46d37, 0x3ac64 },
	{ 0x46d38, 0x3ac65 }, { 0x46d39, 0x3ac66 }, { 0x46cd2, 0x3ac02 },
	{ 0x46cd3, 0x3ac03 }, { 0x46cd4, 0x3ac04 }, { 0x46cd5, 0x3ac05 },
	{ 0x46cd6, 0x3ac06 }, { 0x46d3b, 0x3ae27 }, { 0x46d58, 0x3ae0e },
	{ 0x46dd2, 0x3aebc }, { 0x46dd6, 0x3aebd }
};

#define DOORBOT_COUNT_DE 234
static const TagMapping DOORBOT_MAP_DE[234] = {
	{ 0x46cd0, 0x35ee5 }, { 0x46cd1, 0x35ee6 }, { 0x46cd2, 0x35ee7 },
	{ 0x46cd3, 0x35ee8 }, { 0x46cd4, 0x35ee9 }, { 0x46cd5, 0x35eea },
	{ 0x46cd6, 0x35eeb }, { 0x46cd7, 0x35eec }, { 0x46cd8, 0x35eed },
	{ 0x46cd9, 0x35eee }, { 0x46cda, 0x35eef }, { 0x46cdb, 0x35ef0 },
	{ 0x46cdc, 0x35ef1 }, { 0x46cdd, 0x35ef2 }, { 0x46cde, 0x35ef3 },
	{ 0x46cdf, 0x35ef4 }, { 0x46ce0, 0x35ef5 }, { 0x46ce1, 0x35ef6 },
	{ 0x46ce2, 0x35ef7 }, { 0x46ce3, 0x35ef8 }, { 0x46ce4, 0x35ef9 },
	{ 0x46ce5, 0x35efa }, { 0x46ce6, 0x35efb }, { 0x46ce7, 0x35efc },
	{ 0x46ce8, 0x35efd }, { 0x46ce9, 0x35efe }, { 0x46cea, 0x35eff },
	{ 0x46ceb, 0x35f00 }, { 0x46cec, 0x35f01 }, { 0x46ced, 0x35f02 },
	{ 0x46cee, 0x35f03 }, { 0x46cef, 0x35f04 }, { 0x46cf0, 0x35f05 },
	{ 0x46cf1, 0x35f06 }, { 0x46cf2, 0x35f07 }, { 0x46cf3, 0x35f08 },
	{ 0x46cf4, 0x35f09 }, { 0x46cf5, 0x35f0a }, { 0x46cf6, 0x35f0b },
	{ 0x46cf7, 0x35f0c }, { 0x46cf8, 0x35f0d }, { 0x46cf9, 0x35f0e },
	{ 0x46cfa, 0x35f0f }, { 0x46cfb, 0x35f10 }, { 0x46cfc, 0x35f11 },
	{ 0x46cfd, 0x35f12 }, { 0x46cfe, 0x35f13 }, { 0x46cff, 0x35f14 },
	{ 0x46d00, 0x35f15 }, { 0x46d01, 0x35f16 }, { 0x46d02, 0x35f17 },
	{ 0x46d03, 0x35f18 }, { 0x46d04, 0x35f19 }, { 0x46d05, 0x35f1a },
	{ 0x46d06, 0x35f1b }, { 0x46d07, 0x35f1c }, { 0x46d08, 0x35f1d },
	{ 0x46d09, 0x35f1e }, { 0x46d0a, 0x35f1f }, { 0x46d0b, 0x35f20 },
	{ 0x46d0c, 0x35f21 }, { 0x46d0d, 0x35f22 }, { 0x46d0e, 0x35f23 },
	{ 0x46d0f, 0x35f24 }, { 0x46d10, 0x35f25 }, { 0x46d11, 0x35f26 },
	{ 0x46d12, 0x35f27 }, { 0x46d13, 0x35f28 }, { 0x46d14, 0x35f29 },
	{ 0x46d15, 0x35f2a }, { 0x46d16, 0x35f2b }, { 0x46d17, 0x35f2c },
	{ 0x46d18, 0x35f2d }, { 0x46d19, 0x35f2e }, { 0x46d1a, 0x35f2f },
	{ 0x46d1d, 0x35f32 }, { 0x46d20, 0x35f35 }, { 0x46d21, 0x35f36 },
	{ 0x46d22, 0x35f37 }, { 0x46d23, 0x35f38 }, { 0x46d24, 0x35f39 },
	{ 0x46d25, 0x35f3a }, { 0x46d26, 0x35f3b }, { 0x46d27, 0x35f3c },
	{ 0x46d28, 0x35f3d }, { 0x46d29, 0x35f3e }, { 0x46d2a, 0x35f3f },
	{ 0x46d2b, 0x35f40 }, { 0x46d2c, 0x35f41 }, { 0x46d2d, 0x35f42 },
	{ 0x46d2e, 0x35f43 }, { 0x46d2f, 0x35f44 }, { 0x46d30, 0x35f45 },
	{ 0x46d31, 0x35f46 }, { 0x46d32, 0x35f47 }, { 0x46d33, 0x35f48 },
	{ 0x46d34, 0x35f49 }, { 0x46d35, 0x35f4a }, { 0x46d36, 0x35f4b },
	{ 0x46d37, 0x35f4c }, { 0x46d38, 0x35f4d }, { 0x46d39, 0x35f4e },
	{ 0x46d3a, 0x35bf5 }, { 0x46d3b, 0x360c0 }, { 0x46d3d, 0x36027 },
	{ 0x46d3e, 0x36028 }, { 0x46d3f, 0x36029 }, { 0x46d40, 0x3602a },
	{ 0x46d41, 0x3602e }, { 0x46d42, 0x3602f }, { 0x46d43, 0x36030 },
	{ 0x46d44, 0x36031 }, { 0x46d45, 0x3602c }, { 0x46d46, 0x3602d },
	{ 0x46d47, 0x36227 }, { 0x46d4a, 0x36467 }, { 0x46d4b, 0x36457 },
	{ 0x46d4c, 0x36457 }, { 0x46d4d, 0x36457 }, { 0x46d4e, 0x3646d },
	{ 0x46d4f, 0x36457 }, { 0x46d50, 0x36470 }, { 0x46d51, 0x36457 },
	{ 0x46d52, 0x36457 }, { 0x46d53, 0x36457 }, { 0x46d55, 0x360a3 },
	{ 0x46d56, 0x3634c }, { 0x46d57, 0x36457 }, { 0x46d54, 0x36457 },
	{ 0x46d58, 0x360bf }, { 0x46d5a, 0x36407 }, { 0x46d5b, 0x3640c },
	{ 0x46d5c, 0x3641a }, { 0x46d5d, 0x36420 }, { 0x46d5f, 0x36422 },
	{ 0x46d60, 0x36423 }, { 0x46d61, 0x36424 }, { 0x46d66, 0x36408 },
	{ 0x46d67, 0x36409 }, { 0x46d68, 0x3640a }, { 0x46d69, 0x3640b },
	{ 0x46d6a, 0x3640d }, { 0x46d6e, 0x36415 }, { 0x46d6f, 0x36416 },
	{ 0x46d70, 0x36417 }, { 0x46d71, 0x36418 }, { 0x46d72, 0x36419 },
	{ 0x46d73, 0x3640e }, { 0x46d74, 0x3640f }, { 0x46d75, 0x36410 },
	{ 0x46d76, 0x36411 }, { 0x46d77, 0x36412 }, { 0x46d7e, 0x3641b },
	{ 0x46d7f, 0x3641c }, { 0x46d80, 0x3641d }, { 0x46d81, 0x3641e },
	{ 0x46d82, 0x3641f }, { 0x46d88, 0x362d4 }, { 0x46d89, 0x362db },
	{ 0x46d8a, 0x362e2 }, { 0x46d8b, 0x362e3 }, { 0x46d8c, 0x362e7 },
	{ 0x46d8d, 0x362eb }, { 0x46d8e, 0x362f2 }, { 0x46d8f, 0x362f5 },
	{ 0x46d90, 0x36305 }, { 0x46d91, 0x36457 }, { 0x46d92, 0x36309 },
	{ 0x46d93, 0x362f4 }, { 0x46d94, 0x3630a }, { 0x46d96, 0x36318 },
	{ 0x46d97, 0x36319 }, { 0x46d98, 0x36326 }, { 0x46d99, 0x36327 },
	{ 0x46d9a, 0x3632e }, { 0x46d9b, 0x3632f }, { 0x46d9c, 0x36330 },
	{ 0x46d9d, 0x362f3 }, { 0x46d9e, 0x362b0 }, { 0x46d9f, 0x362b1 },
	{ 0x46da0, 0x362b2 }, { 0x46da1, 0x362b3 }, { 0x46da2, 0x362b4 },
	{ 0x46da3, 0x362b5 }, { 0x46da4, 0x362b9 }, { 0x46da5, 0x362bb },
	{ 0x46da6, 0x362ba }, { 0x46da7, 0x362bc }, { 0x46da8, 0x362b8 },
	{ 0x46da9, 0x362bd }, { 0x46daa, 0x362be }, { 0x46dab, 0x362bf },
	{ 0x46dac, 0x362c0 }, { 0x46dad, 0x362c1 }, { 0x46dae, 0x362c2 },
	{ 0x46daf, 0x362b6 }, { 0x46db0, 0x36314 }, { 0x46db1, 0x362c3 },
	{ 0x46db2, 0x362c4 }, { 0x46db3, 0x362c5 }, { 0x46db4, 0x362c6 },
	{ 0x46db5, 0x362c7 }, { 0x46db6, 0x362c8 }, { 0x46db7, 0x362ca },
	{ 0x46db8, 0x362cc }, { 0x46db9, 0x362cb }, { 0x46dba, 0x362cd },
	{ 0x46dbb, 0x362c9 }, { 0x46dbc, 0x362ce }, { 0x46dbd, 0x362cf },
	{ 0x46dbe, 0x362d0 }, { 0x46dbf, 0x362d1 }, { 0x46dc0, 0x362d2 },
	{ 0x46dc1, 0x362d3 }, { 0x46dc2, 0x3637c }, { 0x46dc3, 0x3627c },
	{ 0x46dc4, 0x36497 }, { 0x46dc5, 0x36493 }, { 0x46dc6, 0x3647f },
	{ 0x46dc7, 0x3647c }, { 0x46dc8, 0x36482 }, { 0x46dc9, 0x3648a },
	{ 0x46dca, 0x3649b }, { 0x46dcb, 0x364b6 }, { 0x46dcc, 0x364aa },
	{ 0x46dcd, 0x364a1 }, { 0x46dce, 0x364b0 }, { 0x46dcf, 0x364a7 },
	{ 0x46dd1, 0x364b9 }, { 0x46dd2, 0x36370 }, { 0x46dd3, 0x363ab },
	{ 0x46dd4, 0x36404 }, { 0x46dd5, 0x362ab }, { 0x46dd6, 0x3636d }
};

#define LIFTBOT_COUNT_DE 119
static const TagMapping LIFTBOT_MAP_DE[119] = {
	{ 0x46cd0, 0x335ab }, { 0x46cd1, 0x335b5 }, { 0x46cd2, 0x33603 },
	{ 0x46cd3, 0x33604 }, { 0x46cd4, 0x33605 }, { 0x46cd5, 0x33606 },
	{ 0x46cd6, 0x33607 }, { 0x46cd7, 0x33608 }, { 0x46cd8, 0x33607 },
	{ 0x46cd9, 0x335b6 }, { 0x46cda, 0x335b7 }, { 0x46cdb, 0x335b8 },
	{ 0x46cdc, 0x335b9 }, { 0x46cdd, 0x335ba }, { 0x46cde, 0x335bb },
	{ 0x46cdf, 0x335bc }, { 0x46ce0, 0x335bd }, { 0x46ce1, 0x335bf },
	{ 0x46ce2, 0x335ac }, { 0x46ce3, 0x335c0 }, { 0x46ce4, 0x335c1 },
	{ 0x46ce5, 0x335c2 }, { 0x46ce6, 0x335c4 }, { 0x46ce7, 0x335c5 },
	{ 0x46ce8, 0x335c6 }, { 0x46ce9, 0x335c7 }, { 0x46cea, 0x335c8 },
	{ 0x46ceb, 0x335ca }, { 0x46cec, 0x335cb }, { 0x46ced, 0x335ad },
	{ 0x46cee, 0x335cc }, { 0x46cef, 0x335ce }, { 0x46cf0, 0x335d0 },
	{ 0x46cf1, 0x335d1 }, { 0x46cf2, 0x335d2 }, { 0x46cf3, 0x335d4 },
	{ 0x46cf4, 0x335d5 }, { 0x46cf5, 0x335d6 }, { 0x46cf6, 0x335d7 },
	{ 0x46cf7, 0x335d8 }, { 0x46cf8, 0x335ae }, { 0x46cf9, 0x335d9 },
	{ 0x46cfa, 0x335db }, { 0x46cfb, 0x335de }, { 0x46cfc, 0x335df },
	{ 0x46cfd, 0x335e0 }, { 0x46cfe, 0x335e1 }, { 0x46cff, 0x335e2 },
	{ 0x46d00, 0x335e3 }, { 0x46d01, 0x335e4 }, { 0x46d02, 0x335e5 },
	{ 0x46d03, 0x335af }, { 0x46d04, 0x335e6 }, { 0x46d05, 0x335e7 },
	{ 0x46d06, 0x335ea }, { 0x46d07, 0x335eb }, { 0x46d08, 0x335ec },
	{ 0x46d09, 0x3364a }, { 0x46d0a, 0x3364b }, { 0x46d0b, 0x3364c },
	{ 0x46d0c, 0x3364d }, { 0x46d0d, 0x3364e }, { 0x46d0e, 0x335b0 },
	{ 0x46d0f, 0x33650 }, { 0x46d10, 0x33651 }, { 0x46d11, 0x33652 },
	{ 0x46d12, 0x33653 }, { 0x46d13, 0x33654 }, { 0x46d14, 0x33656 },
	{ 0x46d15, 0x33657 }, { 0x46d16, 0x33658 }, { 0x46d17, 0x33659 },
	{ 0x46d18, 0x3365b }, { 0x46d19, 0x335b1 }, { 0x46d1a, 0x3365c },
	{ 0x46d1b, 0x3365d }, { 0x46d1c, 0x3365e }, { 0x46d1d, 0x3365f },
	{ 0x46d1e, 0x33660 }, { 0x46d1f, 0x33661 }, { 0x46d20, 0x33662 },
	{ 0x46d21, 0x33663 }, { 0x46d22, 0x335a9 }, { 0x46d23, 0x335aa },
	{ 0x46d24, 0x335b2 }, { 0x46d25, 0x335ed }, { 0x46d26, 0x335ee },
	{ 0x46d27, 0x335ef }, { 0x46d28, 0x335f0 }, { 0x46d29, 0x335f1 },
	{ 0x46d2a, 0x335f2 }, { 0x46d2b, 0x335f4 }, { 0x46d2c, 0x335f5 },
	{ 0x46d2d, 0x335f6 }, { 0x46d2e, 0x335f7 }, { 0x46d2f, 0x335b4 },
	{ 0x46d30, 0x335f8 }, { 0x46d31, 0x335f9 }, { 0x46d32, 0x335fa },
	{ 0x46d33, 0x335fb }, { 0x46d34, 0x335fc }, { 0x46d35, 0x335fd },
	{ 0x46d36, 0x335ff }, { 0x46d37, 0x33600 }, { 0x46d38, 0x33601 },
	{ 0x46d39, 0x33602 }, { 0x46d3a, 0x3380f }, { 0x46d3b, 0x33695 },
	{ 0x46d47, 0x07536 }, { 0x46d4a, 0x3360c }, { 0x46d4e, 0x337fc },
	{ 0x46d50, 0x337fd }, { 0x46d56, 0x33800 }, { 0x46d58, 0x33694 },
	{ 0x46dc2, 0x337f3 }, { 0x46dc6, 0x337fb }, { 0x46dc7, 0x337f9 },
	{ 0x46dca, 0x33802 }, { 0x46dd3, 0x33775 } 
};

#define MAITRED_COUNT_DE 105
static const TagMapping MAITRED_MAP_DE[105] = {
	{ 0x46cd0, 0x3f94c }, { 0x46ce2, 0x3f9a6 }, { 0x46ced, 0x3f9a7 },
	{ 0x46cf8, 0x3f9a8 }, { 0x46d03, 0x3f9a9 }, { 0x46d0e, 0x3f9aa },
	{ 0x46d19, 0x3f9ab }, { 0x46d24, 0x3f9ac }, { 0x46d2f, 0x3f9ad },
	{ 0x46cd1, 0x3f9ae }, { 0x46cd9, 0x3f9af }, { 0x46cda, 0x3f9b0 },
	{ 0x46cdb, 0x3f9b1 }, { 0x46cdc, 0x3f9b2 }, { 0x46cdd, 0x3f9b3 },
	{ 0x46cde, 0x3f9b4 }, { 0x46cdf, 0x3f9b5 }, { 0x46ce0, 0x3f9b6 },
	{ 0x46ce1, 0x3f9b7 }, { 0x46ce3, 0x3f9b8 }, { 0x46ce4, 0x3f9b9 },
	{ 0x46ce5, 0x3f9ba }, { 0x46ce6, 0x3f9bb }, { 0x46ce7, 0x3f9bc },
	{ 0x46ce8, 0x3f9bd }, { 0x46ce9, 0x3f9be }, { 0x46cea, 0x3f9bf },
	{ 0x46ceb, 0x3f9c0 }, { 0x46cec, 0x3f9c1 }, { 0x46cee, 0x3f9c2 },
	{ 0x46cef, 0x3f9c3 }, { 0x46cf0, 0x3f9c4 }, { 0x46cf1, 0x3f9c5 },
	{ 0x46cf5, 0x3f9c9 }, { 0x46cf6, 0x3f9ca }, { 0x46cf7, 0x3f9cb },
	{ 0x46cf9, 0x3f9cc }, { 0x46cfa, 0x3f9cd }, { 0x46cfb, 0x3f9ce },
	{ 0x46cfc, 0x3f9cf }, { 0x46cfd, 0x3f9d0 }, { 0x46cfe, 0x3f9d1 },
	{ 0x46cff, 0x3f9d2 }, { 0x46d00, 0x3f9d3 }, { 0x46d01, 0x3f9d4 },
	{ 0x46d02, 0x3f9d5 }, { 0x46d04, 0x3f9d6 }, { 0x46d05, 0x3f9d7 },
	{ 0x46d06, 0x3f9d9 }, { 0x46d07, 0x3f9da }, { 0x46d08, 0x3f9db },
	{ 0x46d09, 0x3f98a }, { 0x46d0a, 0x3f98b }, { 0x46d0b, 0x3f98c },
	{ 0x46d0c, 0x3f98d }, { 0x46d0d, 0x3f98e }, { 0x46d0f, 0x3f98f },
	{ 0x46d10, 0x3f991 }, { 0x46d11, 0x3f992 }, { 0x46d12, 0x3f993 },
	{ 0x46d13, 0x3f994 }, { 0x46d14, 0x3f996 }, { 0x46d15, 0x3f997 },
	{ 0x46d16, 0x3f998 }, { 0x46d17, 0x3f999 }, { 0x46d18, 0x3f99a },
	{ 0x46d1a, 0x3f99b }, { 0x46d1b, 0x3f99c }, { 0x46d1c, 0x3f99d },
	{ 0x46d1d, 0x3f99e }, { 0x46d1e, 0x3f99f }, { 0x46d1f, 0x3f9a1 },
	{ 0x46d20, 0x3f9a2 }, { 0x46d21, 0x3f9a3 }, { 0x46d22, 0x3f9a4 },
	{ 0x46d23, 0x3f9a5 }, { 0x46d25, 0x3f9dd }, { 0x46d26, 0x3f9de },
	{ 0x46d27, 0x3f9df }, { 0x46d28, 0x3f9e0 }, { 0x46d29, 0x3f9e1 },
	{ 0x46d2a, 0x3f9e2 }, { 0x46d2b, 0x3f9e3 }, { 0x46d2c, 0x3f9e4 },
	{ 0x46d2d, 0x3f9e5 }, { 0x46d2e, 0x3f9e6 }, { 0x46d30, 0x3f9e7 },
	{ 0x46d31, 0x3f9e8 }, { 0x46d32, 0x3f9e9 }, { 0x46d33, 0x3f9ea },
	{ 0x46d34, 0x3f9eb }, { 0x46d35, 0x3f9ec }, { 0x46d36, 0x3f9ed },
	{ 0x46d37, 0x3f9ee }, { 0x46d38, 0x3f9ef }, { 0x46d39, 0x3f9f0 },
	{ 0x46cd2, 0x3f9f1 }, { 0x46cd3, 0x3f9f2 }, { 0x46cd4, 0x3f9f3 },
	{ 0x46cd5, 0x3f9f9 }, { 0x46cd6, 0x3f9fa }, { 0x46cd7, 0x3f9fb },
	{ 0x46cd8, 0x3f9fc }, { 0x46d3b, 0x3f853 }, { 0x46d58, 0x3f83c }
};

void writeTagMappings(const char *name, const TagMapping *map, int count) {
	outputFile.seek(dataOffset);

	for (int idx = 0; idx < count; ++idx, ++map) {
		outputFile.writeLong(map->_src);
		outputFile.writeLong(map->_dest);
	}

	uint size = outputFile.size() - dataOffset;
	writeEntryHeader(name, dataOffset, size);
	dataOffset += size;
}

void writeAllTagMappings() {
	writeTagMappings("TagMap/Barbot", BARBOT_MAP_EN, BARBOT_COUNT_EN);
	writeTagMappings("TagMap/Bellbot", BELLBOT_MAP_EN, BELLBOT_COUNT_EN);
	writeTagMappings("TagMap/Deskbot", DESKBOT_MAP_EN, DESKBOT_COUNT_EN);
	writeTagMappings("TagMap/Doorbot", DOORBOT_MAP_EN, DOORBOT_COUNT_EN);
	writeTagMappings("TagMap/Liftbot", LIFTBOT_MAP_EN, LIFTBOT_COUNT_EN);
	writeTagMappings("TagMap/MaitreD", MAITRED_MAP_EN, MAITRED_COUNT_EN);

	writeTagMappings("TagMap/Barbot/DE", BARBOT_MAP_DE, BARBOT_COUNT_DE);
	writeTagMappings("TagMap/Bellbot/DE", BELLBOT_MAP_DE, BELLBOT_COUNT_DE);
	writeTagMappings("TagMap/Deskbot/DE", DESKBOT_MAP_DE, DESKBOT_COUNT_DE);
	writeTagMappings("TagMap/Doorbot/DE", DOORBOT_MAP_DE, DOORBOT_COUNT_DE);
	writeTagMappings("TagMap/Liftbot/DE", LIFTBOT_MAP_DE, LIFTBOT_COUNT_DE);
	writeTagMappings("TagMap/MaitreD/DE", MAITRED_MAP_DE, MAITRED_COUNT_DE);

}
