/***************************************************************************
 *   copyright           : (C) 2004 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "atcommand.h"
#include "helper.h"
#include "common.h"

#include "string.h"

int keypad_dial_number (char* number) {
  char* keylist;
  char* ausgabe;
  char* temp;

  if (str_len(number) == 0) return 0;

  // enable keypad control from TE
  at_command_send(AT_GEN_TERM_CMODE,"2");
  //ignore response
  mem_realloc(at_read_line(),0);

  //disable keypad lock
  //should never fail but handle that case anyway
  if (lock_get_status("CS") != 0) return 0;
  
  keylist = mem_alloc(strlen(number)+3,1);
  sprintf(keylist,"C%sS",number);
  temp = keylist;
  do {
    temp = at_gen_keypad(temp,1,0);
    ausgabe = at_read_line();
    if (at_line_type(ausgabe,NULL,NULL) != AT_RET_OK) {
      return 0;
    }
    mem_realloc(ausgabe,0);
  } while (temp != NULL);
  mem_realloc(keylist,0);
  return 1;
}
