/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef HELPERS_H
#define HELPERS_H

#include "intincl.h"
#include <stdlib.h>

/* returns the console width in columns for fd */
long console_width(int fd);

/* print a status bar to console */
void console_print_status (int fd, const char* text, size_t textlen,
			   unsigned long current, unsigned long total);

/* returns the number of digits in num */
unsigned int numlen (long num);

/* returns the GSM type of address (TOA) value */
uint8_t numtype (const char* number);

/* returns 1 if every character in s is a digit else 0*/
int is_number(const char* s);

/* returns 1 if s is a telephone number else 0 */
int is_telephone_number (const char* s);

/* converts a hexadezimal string with a given length to an int */
unsigned int hexstr2int(char *hexstring, unsigned int length);


/* (re)allocate memory */
void* mem_alloc (size_t size, short zero_it);
void* mem_realloc (void* oldpointer, size_t size);

/* duplicate a c string */
char* str_dup (const char* input);
char* strn_dup (const char* input, size_t insize);

/* strlen() does not seem to check for strlen(NULL) and crashes */
size_t str_len(const char *s);

/** calculate the printed string width
 * This works for UTF-8 and charsets with fixed-size elements
 * @param s the string
 * @param len bytecount of s or less
 * @return amount of printed characters
 */
size_t str_width (const char* s);
size_t strn_width (const char* s, size_t len);

/** check if a string is valid
 * This works for UTF-8 and charsets with fixed-size elements
 * @param s string in ISO-8859-? or UTF-8
 * @param len bytecount of s or less
 */
int strn_valid (const char* s, size_t len);
int str_valid (const char* s);

/** split a string
 * @param str string to split up (it gets modified!)
 * @param split at what points in str to split
 * @param count maximum number of splits, 0 means unlimited
 * 
 * @return return the dynamically allocated array ([0] = str)
 */
char** str_split (char* str, char* split, unsigned long count);

/** remove duplicates from a string list (keeps order)
 * @param list a NULL terminated list of strings
 */
void str_list_uniq (char** list);

/** append a list to another list
 * @param list1 malloc'ed pointer to a list
 * @param size1 current size of list1
 * @param list2 list to append to list1
 * @param size2 size of list2
 * @return realloc'ed (from list1), NULL-terminated list pointer
 */
char** str_list_append (char** list1, size_t size1,
			char** list2, size_t size2);

/** sort the list (alphabetical order)
 * Be warned that if you use a list created be str_split,
 * the memory pointer may not be at element 0 anymore!
 * @param list a NULL terminated list of strings
 */
void str_list_sort (char** list);

#endif
