
/***************************************************************************
 *   copyright           : (C) 2003 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "options.h"
#include "helper.h"

#include <stdlib.h>

#include "config.h"
#ifdef HAVE_GETOPT_H
# include <getopt.h>
#else
# include <gnugetopt/getopt.h>
#endif

char** args_parse (int argc, char** argv, struct args_t* args) {
  int arg = -1;
  int option_index = 0;
  char** retval;
  int i;

  struct option myoptions[]={
    {"remove",0,0,'r'},
    {"send",0,0,'s'},
    {"get",0,0,'g'},
    
    {"bitmap",2,0,'B'}, //old, compat
    {"midi",2,0,'M'}, //old, compat
    {"vcal",2,0,'C'}, //old, compat
    {"vcard",2,0,'F'}, //old, compat
    {"binary",0,0,'N'},
    {"pbook",2,0,'P'},
    {"sms",2,0,'S'},
    
    {"info",0,0,'i'},
    {"mem-info",0,0,0},
    {"set-time",0,0,0},
    {"set-smsc",0,0,0},
    {"reset",0,0,0},

    {"mem",1,0,0},
    {"slot",1,0,0},
    {"smsmem",1,0,0}, //old, compat
    {"text",1,0,'t'},
    {"unicode",0,0,0},
    {"number",1,0,'n'},
    {"flash",0,0,0},
    {"srr",0,0,0},
    {"direct",0,0,0},
    {"sort",1,0,0}, //new since 0.7.3
    
    {"device",1,0,'d'},
    {"baud",1,0,'b'},
    {"device-timeout",1,0,0},
    {"ignore-serial-bits",0,0,0},
    {"keep-serial-bits",0,0,0},
    {"start-delay",1,0,0},
    
    {"out",1,0,'o'},
    {"pipe",1,0,'p'},
    
    {"pin",1,0,0},
    
    {"verbose",0,0,'v'},
    {"quiet",0,0,'q'},
    {"help",0,0,'h'},
    {"version",0,0,0},
    
    {0,0,0,0}
  };
  const char myoptions_short[]="rsgB::M::C::F::NP::S::it:n:d:b:o:p:vqh";
  char* posixly_correct;

  if ((posixly_correct=getenv("POSIXLY_CORRECT")) != NULL) {
    posixly_correct = str_dup(getenv("POSIXLY_CORRECT"));
  }
  setenv("POSIXLY_CORRECT","1",1);

  while ((arg = getopt_long(argc, argv,
			    myoptions_short,
			    myoptions,
			    &option_index)) != -1) {
    if (arg==0) {
      arg_fill(arg,myoptions[option_index].name,optarg,args);
    } else {
      arg_fill(arg,NULL,optarg,args);
    }
  }
  if (posixly_correct == NULL) {
    unsetenv("POSIXLY_CORRECT");
  } else {
    setenv("POSIXLY_CORRECT",posixly_correct,1);
  }
  if (optind >= argc) {
    retval = mem_alloc(sizeof(char*),0);    
    i=0;
  } else {
    retval = mem_alloc((argc-optind+1)*sizeof(char*),0);
    for (i=0;optind+i < argc;++i) {
      retval[i] = argv[optind+i];
    }
  }
  retval[i]=NULL;

  return retval;
}
