
/***************************************************************************
 *   copyright           : (C) 2002 by Hendrik Sattler                     *
 *   mail                : post@hendrik-sattler.de                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CHARSETS_H
#define CHARSETS_H

char* get_system_charset ();

enum repmode {
  /* replace all unknown character with a \XXXX replacement
   * it is used for all output that we might read again
   */
  REPMODE_ESCAPE_CHARS = 0,
  /* replace all unknown character with a '?'
   * it is used for all output that we may not read again
   */
  REPMODE_QUESTIONMARK,
  /* abort on error with an error message
   */
  REPMODE_ABORT
};

#include "intincl.h"
#define ucs4char_t uint32_t
#define ucs2char_t uint16_t
#define gsmchar_t  uint8_t

#include <stdlib.h>

//tell the length of own types
size_t ucs4len (const ucs4char_t* input);
size_t ucs2len (ucs2char_t* input);

//almost like strndup()/strdup() but return NULL if s == NULL
ucs4char_t* ucs4ndup(const ucs4char_t* s, size_t n);
ucs4char_t* ucs4dup(const ucs4char_t* s);
//just like strncmp()/strcmp()
int ucs4ncmp (const ucs4char_t* s1, const ucs4char_t* s2, size_t n);
int ucs4cmp (const ucs4char_t* s1, const ucs4char_t* s2);
//just like strstr()
ucs4char_t* ucs4str (const ucs4char_t* haystack, const ucs4char_t* needle);

//these two are mainly used by the other function from below
ucs4char_t* convert_to_internal (char* from_code, char* input,
				 size_t insize);
char* convert_from_internal (char* to_code, ucs4char_t* input,
			     enum repmode replacement_mode);

//convert from/to the system's charset
char* convert_to_system (ucs4char_t* input,
			 enum repmode replacement_mode);
ucs4char_t* convert_from_system (char* input);

//convert from/to 7bit GSM charset
gsmchar_t* convert_to_gsm (ucs4char_t* input);
ucs4char_t* convert_from_gsm (gsmchar_t* input);

//convert from/to UCS-2 unicode charset
ucs2char_t* convert_to_ucs2 (ucs4char_t* input);
ucs4char_t* convert_from_ucs2 (ucs2char_t* input);
char* convert_to_ucs2_hexstring (ucs4char_t* input);
ucs4char_t* convert_from_ucs2_hexstring (char* input);

#endif
