##############################################################################
#
# Copyright (c) 2005 Zope Corporation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
"""
ILockInfo implementation.

$Id: $
"""

from zope.app.locking.interfaces import ILockInfo, LockingError
import zope.interface, time


class LockInfo(object):
    
    zope.interface.implements(ILockInfo)

    def __init__(self, target, principal_id, timeout=None):
        self.target = target
        self.principal_id = principal_id
        self.created = time.time()
        self.timeout = timeout
        self.data = {}

    def get(self, key, default=None):
        return self.data.get(key, default)

    def keys(self):
        return self.data.keys()

    def values(self):
        return self.data.values()

    def items(self):
        return self.data.items()

    def __getitem__(self, key):
        return self.data[key]

    def __setitem__(self, key, value):
        self.data[key] = value

    def __delitem__(self, key):
        del self.data[key]

    def __contains__(self, key):
        return self.data.has_key(key)

    def __iter__(self):
        return iter(self.data)

    def __len__(self):
        return len(self.data)

