/*
 * Decompiled with CFR 0.152.
 */
package jsr166y;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jsr166y.ForkJoinPool;
import jsr166y.ForkJoinWorkerThread;
import sun.misc.Unsafe;

public abstract class ForkJoinTask<V>
implements Future<V>,
Serializable {
    volatile int status;
    static final int COMPLETION_MASK = -536870912;
    static final int NORMAL = -536870912;
    static final int CANCELLED = -1073741824;
    static final int EXCEPTIONAL = -1610612736;
    static final int SIGNAL_MASK = 65535;
    static final int INTERNAL_SIGNAL_MASK = Short.MAX_VALUE;
    static final int EXTERNAL_SIGNAL = 32768;
    static final Map<ForkJoinTask<?>, Throwable> exceptionMap = Collections.synchronizedMap(new WeakHashMap());
    private static final long serialVersionUID = -7721805057305804111L;
    private static final Unsafe UNSAFE = ForkJoinTask.getUnsafe();
    private static final long statusOffset = ForkJoinTask.objectFieldOffset("status", ForkJoinTask.class);

    static ForkJoinWorkerThread getWorker() {
        Thread t = Thread.currentThread();
        return t instanceof ForkJoinWorkerThread ? (ForkJoinWorkerThread)t : null;
    }

    final boolean casStatus(int cmp, int val) {
        return UNSAFE.compareAndSwapInt(this, statusOffset, cmp, val);
    }

    static void rethrowException(Throwable ex) {
        if (ex != null) {
            UNSAFE.throwException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setCompletion(int completion) {
        ForkJoinPool pool = ForkJoinTask.getPool();
        if (pool != null) {
            int s;
            while ((s = this.status) >= 0 && !this.casStatus(s, completion)) {
            }
            if ((s & 0xFFFF) != 0) {
                if ((s &= Short.MAX_VALUE) != 0) {
                    pool.updateRunningCount(s);
                }
                ForkJoinTask forkJoinTask = this;
                synchronized (forkJoinTask) {
                    this.notifyAll();
                }
            }
        } else {
            this.externallySetCompletion(completion);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void externallySetCompletion(int completion) {
        int s;
        while ((s = this.status) >= 0 && !this.casStatus(s, s & 0xFFFF | completion)) {
        }
        ForkJoinTask forkJoinTask = this;
        synchronized (forkJoinTask) {
            this.notifyAll();
        }
    }

    final void setNormalCompletion() {
        if (!UNSAFE.compareAndSwapInt(this, statusOffset, 0, -536870912)) {
            this.setCompletion(-536870912);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAwaitDone() {
        try {
            while (this.status >= 0) {
                ForkJoinTask forkJoinTask = this;
                synchronized (forkJoinTask) {
                    if (this.status >= 0) {
                        this.wait();
                    }
                }
            }
        }
        catch (InterruptedException ie) {
            this.onInterruptedWait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAwaitDone(long startTime, long nanos) {
        ForkJoinTask forkJoinTask = this;
        synchronized (forkJoinTask) {
            try {
                while (this.status >= 0) {
                    long nt = nanos - (System.nanoTime() - startTime);
                    if (nt > 0L) {
                        this.wait(nt / 1000000L, (int)(nt % 1000000L));
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException ie) {
                this.onInterruptedWait();
            }
        }
    }

    private int awaitDone(ForkJoinWorkerThread w, boolean maintainParallelism) {
        int s;
        ForkJoinPool pool = w == null ? null : w.pool;
        while ((s = this.status) >= 0) {
            if (!this.casStatus(s, pool == null ? s | 0x8000 : s + 1)) continue;
            if (pool == null || !pool.preJoin(this, maintainParallelism)) {
                this.doAwaitDone();
            }
            if (((s = this.status) & Short.MAX_VALUE) == 0) break;
            this.adjustPoolCountsOnUnblock(pool);
            break;
        }
        return s;
    }

    private int awaitDone(ForkJoinWorkerThread w, long nanos) {
        int s;
        ForkJoinPool pool = w == null ? null : w.pool;
        while ((s = this.status) >= 0) {
            if (!this.casStatus(s, pool == null ? s | 0x8000 : s + 1)) continue;
            long startTime = System.nanoTime();
            if (pool == null || !pool.preJoin(this, false)) {
                this.doAwaitDone(startTime, nanos);
            }
            if ((s = this.status) >= 0) {
                this.adjustPoolCountsOnCancelledWait(pool);
                s = this.status;
            }
            if (s >= 0 || (s & Short.MAX_VALUE) == 0) break;
            this.adjustPoolCountsOnUnblock(pool);
            break;
        }
        return s;
    }

    private void adjustPoolCountsOnUnblock(ForkJoinPool pool) {
        int s;
        while ((s = this.status) < 0 && !this.casStatus(s, s & 0xE0000000)) {
        }
        if (pool != null && (s &= Short.MAX_VALUE) != 0) {
            pool.updateRunningCount(s);
        }
    }

    private void adjustPoolCountsOnCancelledWait(ForkJoinPool pool) {
        if (pool != null) {
            int s;
            while ((s = this.status) >= 0 && (s & Short.MAX_VALUE) != 0) {
                if (!this.casStatus(s, s - 1)) continue;
                pool.updateRunningCount(1);
                break;
            }
        }
    }

    private void onInterruptedWait() {
        ForkJoinWorkerThread w = ForkJoinTask.getWorker();
        if (w == null) {
            Thread.currentThread().interrupt();
        } else if (w.isTerminating()) {
            this.cancelIgnoringExceptions();
        }
    }

    private void setDoneExceptionally(Throwable rex) {
        exceptionMap.put(this, rex);
        this.setCompletion(-1610612736);
    }

    private void reportException(int s) {
        if ((s &= 0xE0000000) < -536870912) {
            if (s == -1073741824) {
                throw new CancellationException();
            }
            ForkJoinTask.rethrowException(exceptionMap.get(this));
        }
    }

    private V reportFutureResult() throws InterruptedException, ExecutionException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int s = this.status & 0xE0000000;
        if (s < -536870912) {
            Throwable ex;
            if (s == -1073741824) {
                throw new CancellationException();
            }
            if (s == -1610612736 && (ex = exceptionMap.get(this)) != null) {
                throw new ExecutionException(ex);
            }
        }
        return this.getRawResult();
    }

    private V reportTimedFutureResult() throws InterruptedException, ExecutionException, TimeoutException {
        Throwable ex;
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        int s = this.status & 0xE0000000;
        if (s == -536870912) {
            return this.getRawResult();
        }
        if (s == -1073741824) {
            throw new CancellationException();
        }
        if (s == -1610612736 && (ex = exceptionMap.get(this)) != null) {
            throw new ExecutionException(ex);
        }
        throw new TimeoutException();
    }

    private boolean tryExec() {
        try {
            if (!this.exec()) {
                return false;
            }
        }
        catch (Throwable rex) {
            this.setDoneExceptionally(rex);
            ForkJoinTask.rethrowException(rex);
            return false;
        }
        this.setNormalCompletion();
        return true;
    }

    final void quietlyExec() {
        if (this.status >= 0) {
            try {
                if (!this.exec()) {
                    return;
                }
            }
            catch (Throwable rex) {
                this.setDoneExceptionally(rex);
                return;
            }
            this.setNormalCompletion();
        }
    }

    private boolean tryQuietlyInvoke() {
        try {
            if (!this.exec()) {
                return false;
            }
        }
        catch (Throwable rex) {
            this.setDoneExceptionally(rex);
            return false;
        }
        this.setNormalCompletion();
        return true;
    }

    final void cancelIgnoringExceptions() {
        try {
            this.cancel(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private int busyJoin(ForkJoinWorkerThread w) {
        ForkJoinTask<?> t;
        int s;
        while ((s = this.status) >= 0 && (t = w.scanWhileJoining(this)) != null) {
            t.quietlyExec();
        }
        return s >= 0 ? this.awaitDone(w, false) : s;
    }

    public final ForkJoinTask<V> fork() {
        ((ForkJoinWorkerThread)Thread.currentThread()).pushTask(this);
        return this;
    }

    public final V join() {
        ForkJoinWorkerThread w = ForkJoinTask.getWorker();
        if (w == null || this.status < 0 || !w.unpushTask(this) || !this.tryExec()) {
            this.reportException(this.awaitDone(w, true));
        }
        return this.getRawResult();
    }

    public final V invoke() {
        if (this.status >= 0 && this.tryExec()) {
            return this.getRawResult();
        }
        return this.join();
    }

    public static void invokeAll(ForkJoinTask<?> t1, ForkJoinTask<?> t2) {
        t2.fork();
        t1.invoke();
        t2.join();
    }

    public static void invokeAll(ForkJoinTask<?> ... tasks) {
        ForkJoinTask<?> t;
        int last;
        Throwable ex = null;
        int i = last = tasks.length - 1;
        while (i >= 0) {
            t = tasks[i];
            if (t == null) {
                if (ex == null) {
                    ex = new NullPointerException();
                }
            } else if (i != 0) {
                t.fork();
            } else {
                t.quietlyInvoke();
                if (ex == null) {
                    ex = t.getException();
                }
            }
            --i;
        }
        i = 1;
        while (i <= last) {
            t = tasks[i];
            if (t != null) {
                if (ex != null) {
                    t.cancel(false);
                } else {
                    t.quietlyJoin();
                    if (ex == null) {
                        ex = t.getException();
                    }
                }
            }
            ++i;
        }
        if (ex != null) {
            ForkJoinTask.rethrowException(ex);
        }
    }

    public static <T extends ForkJoinTask<?>> Collection<T> invokeAll(Collection<T> tasks) {
        ForkJoinTask t;
        int last;
        if (!(tasks instanceof RandomAccess) || !(tasks instanceof List)) {
            ForkJoinTask.invokeAll(tasks.toArray(new ForkJoinTask[tasks.size()]));
            return tasks;
        }
        List ts = (List)tasks;
        Throwable ex = null;
        int i = last = ts.size() - 1;
        while (i >= 0) {
            t = (ForkJoinTask)ts.get(i);
            if (t == null) {
                if (ex == null) {
                    ex = new NullPointerException();
                }
            } else if (i != 0) {
                t.fork();
            } else {
                t.quietlyInvoke();
                if (ex == null) {
                    ex = t.getException();
                }
            }
            --i;
        }
        i = 1;
        while (i <= last) {
            t = (ForkJoinTask)ts.get(i);
            if (t != null) {
                if (ex != null) {
                    t.cancel(false);
                } else {
                    t.quietlyJoin();
                    if (ex == null) {
                        ex = t.getException();
                    }
                }
            }
            ++i;
        }
        if (ex != null) {
            ForkJoinTask.rethrowException(ex);
        }
        return tasks;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.setCompletion(-1073741824);
        return (this.status & 0xE0000000) == -1073741824;
    }

    @Override
    public final boolean isDone() {
        return this.status < 0;
    }

    @Override
    public final boolean isCancelled() {
        return (this.status & 0xE0000000) == -1073741824;
    }

    public final boolean isCompletedAbnormally() {
        return (this.status & 0xE0000000) < -536870912;
    }

    public final boolean isCompletedNormally() {
        return (this.status & 0xE0000000) == -536870912;
    }

    public final Throwable getException() {
        int s = this.status & 0xE0000000;
        return s >= -536870912 ? null : (s == -1073741824 ? new CancellationException() : exceptionMap.get(this));
    }

    public void completeExceptionally(Throwable ex) {
        this.setDoneExceptionally(ex instanceof RuntimeException || ex instanceof Error ? ex : new RuntimeException(ex));
    }

    public void complete(V value) {
        try {
            this.setRawResult(value);
        }
        catch (Throwable rex) {
            this.setDoneExceptionally(rex);
            return;
        }
        this.setNormalCompletion();
    }

    @Override
    public final V get() throws InterruptedException, ExecutionException {
        ForkJoinWorkerThread w = ForkJoinTask.getWorker();
        if (w == null || this.status < 0 || !w.unpushTask(this) || !this.tryQuietlyInvoke()) {
            this.awaitDone(w, true);
        }
        return this.reportFutureResult();
    }

    @Override
    public final V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long nanos = unit.toNanos(timeout);
        ForkJoinWorkerThread w = ForkJoinTask.getWorker();
        if (w == null || this.status < 0 || !w.unpushTask(this) || !this.tryQuietlyInvoke()) {
            this.awaitDone(w, nanos);
        }
        return this.reportTimedFutureResult();
    }

    public final V helpJoin() {
        ForkJoinWorkerThread w = (ForkJoinWorkerThread)Thread.currentThread();
        if (this.status < 0 || !w.unpushTask(this) || !this.tryExec()) {
            this.reportException(this.busyJoin(w));
        }
        return this.getRawResult();
    }

    public final void quietlyHelpJoin() {
        ForkJoinWorkerThread w;
        if (!(this.status < 0 || (w = (ForkJoinWorkerThread)Thread.currentThread()).unpushTask(this) && this.tryQuietlyInvoke())) {
            this.busyJoin(w);
        }
    }

    public final void quietlyJoin() {
        ForkJoinWorkerThread w;
        if (!(this.status < 0 || (w = ForkJoinTask.getWorker()) != null && w.unpushTask(this) && this.tryQuietlyInvoke())) {
            this.awaitDone(w, true);
        }
    }

    public final void quietlyInvoke() {
        if (this.status >= 0 && !this.tryQuietlyInvoke()) {
            this.quietlyJoin();
        }
    }

    public static void helpQuiesce() {
        ((ForkJoinWorkerThread)Thread.currentThread()).helpQuiescePool();
    }

    public void reinitialize() {
        if ((this.status & 0xE0000000) == -1610612736) {
            exceptionMap.remove(this);
        }
        this.status = 0;
    }

    public static ForkJoinPool getPool() {
        Thread t = Thread.currentThread();
        return t instanceof ForkJoinWorkerThread ? ((ForkJoinWorkerThread)t).pool : null;
    }

    public static boolean inForkJoinPool() {
        return Thread.currentThread() instanceof ForkJoinWorkerThread;
    }

    public boolean tryUnfork() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).unpushTask(this);
    }

    public static int getQueuedTaskCount() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).getQueueSize();
    }

    public static int getSurplusQueuedTaskCount() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).getEstimatedSurplusTaskCount();
    }

    public abstract V getRawResult();

    protected abstract void setRawResult(V var1);

    protected abstract boolean exec();

    protected static ForkJoinTask<?> peekNextLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).peekTask();
    }

    protected static ForkJoinTask<?> pollNextLocalTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).pollLocalTask();
    }

    protected static ForkJoinTask<?> pollTask() {
        return ((ForkJoinWorkerThread)Thread.currentThread()).pollTask();
    }

    public static ForkJoinTask<?> adapt(Runnable runnable) {
        return new AdaptedRunnable<Object>(runnable, null);
    }

    public static <T> ForkJoinTask<T> adapt(Runnable runnable, T result) {
        return new AdaptedRunnable<T>(runnable, result);
    }

    public static <T> ForkJoinTask<T> adapt(Callable<? extends T> callable) {
        return new AdaptedCallable<T>(callable);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeObject(this.getException());
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.status &= Short.MIN_VALUE;
        this.status |= 0x8000;
        Object ex = s.readObject();
        if (ex != null) {
            this.setDoneExceptionally((Throwable)ex);
        }
    }

    private static long objectFieldOffset(String field, Class<?> klazz) {
        try {
            return UNSAFE.objectFieldOffset(klazz.getDeclaredField(field));
        }
        catch (NoSuchFieldException e) {
            NoSuchFieldError error = new NoSuchFieldError(field);
            error.initCause(e);
            throw error;
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException se) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Field f = Unsafe.class.getDeclaredField("theUnsafe");
                        f.setAccessible(true);
                        return (Unsafe)f.get(null);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                throw new RuntimeException("Could not initialize intrinsics", e.getCause());
            }
        }
    }

    static final class AdaptedCallable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Callable<? extends T> callable;
        T result;
        private static final long serialVersionUID = 2838392045355241008L;

        AdaptedCallable(Callable<? extends T> callable) {
            if (callable == null) {
                throw new NullPointerException();
            }
            this.callable = callable;
        }

        @Override
        public T getRawResult() {
            return this.result;
        }

        @Override
        public void setRawResult(T v) {
            this.result = v;
        }

        @Override
        public boolean exec() {
            try {
                this.result = this.callable.call();
                return true;
            }
            catch (Error err) {
                throw err;
            }
            catch (RuntimeException rex) {
                throw rex;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        @Override
        public void run() {
            this.invoke();
        }
    }

    static final class AdaptedRunnable<T>
    extends ForkJoinTask<T>
    implements RunnableFuture<T> {
        final Runnable runnable;
        final T resultOnCompletion;
        T result;
        private static final long serialVersionUID = 5232453952276885070L;

        AdaptedRunnable(Runnable runnable, T result) {
            if (runnable == null) {
                throw new NullPointerException();
            }
            this.runnable = runnable;
            this.resultOnCompletion = result;
        }

        @Override
        public T getRawResult() {
            return this.result;
        }

        @Override
        public void setRawResult(T v) {
            this.result = v;
        }

        @Override
        public boolean exec() {
            this.runnable.run();
            this.result = this.resultOnCompletion;
            return true;
        }

        @Override
        public void run() {
            this.invoke();
        }
    }
}

