/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.publickeystore;

import com.sun.midp.publickeystore.Storage;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class InputStorage
extends Storage {
    private DataInputStream in;

    InputStorage(InputStream input) throws IOException {
        this.in = new DataInputStream(input);
        this.in.readByte();
    }

    Object readValue(byte[] tag) throws IOException {
        try {
            this.in.readFully(tag, 0, 1);
        }
        catch (EOFException e) {
            return null;
        }
        byte type = this.in.readByte();
        if (type == 1) {
            int len = this.in.readUnsignedShort();
            if (len < 0) {
                throw new IOException("input storage corrupted");
            }
            byte[] value = new byte[len];
            this.in.readFully(value);
            return value;
        }
        if (type == 2) {
            return this.in.readUTF();
        }
        if (type == 3) {
            return new Long(this.in.readLong());
        }
        throw new IOException("input storage corrupted");
    }
}

