/* HP Scanjet 3900 series - RTS8822L Core

   Copyright (C) 2006 Jonathan Bravo Lopez <jkdsoft@gmail.com>

   This file is part of the SANE package.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   As a special exception, the authors of SANE give permission for
   additional uses of the libraries contained in this release of SANE.

   The exception is that, if you link a SANE library with other files
   to produce an executable, this does not by itself cause the
   resulting executable to be covered by the GNU General Public
   License.  Your use of that executable is in no way restricted on
   account of linking the SANE library code into it.

   This exception does not, however, invalidate any other reasons why
   the executable file might be covered by the GNU General Public
   License.

   If you submit changes to SANE to the maintainers to be included in
   a subsequent release, you agree by submitting the changes that
   those changes may be distributed with this exception intact.

   If you write modifications of your own for SANE, it is your choice
   whether to permit this exception to apply to your modifications.
   If you do not wish that, delete this exception notice.
*/


/*
 This code is still a bit ugly due to it's the result of applying
 reverse engineering techniques to windows driver. So at this
 moment what you see is exactly what windows driver does.
 And so many global vars exist that will be erased when driver
 is entirely debugged. There are some variables with unknown
 purpose. So they have no meaning name in form v+address. I
 hope to change their names when driver is debugged completely.
*/

#define GetTickCount() (time(0) * 1000)
#define min(A,B) (((A)<(B)) ? (A) : (B))
#define max(A,B) (((A)>(B)) ? (A) : (B))
#define PIXEL_TO_MM(_pixel_, _dpi_) ((_pixel_) * 25.4 / (_dpi_))
#define MM_TO_PIXEL(_mm_, _dpi_) ((_mm_) * (_dpi_) / 25.4)

#include <stdio.h>
#include <stdlib.h>
#include <string.h>		/* bzero()   */
#include <time.h>		/* clock()   */
#include <math.h>		/* truncf()  */
#include <ctype.h>		/* tolower() */
#include <unistd.h>		/* usleep()  */
#include <tiffio.h>		/* TIFF_Save */

#ifdef STANDALONE
#include "hp3900_debug.c"
#endif

#include "hp3900_types.c"
#include "hp3900_config.c"
#include "hp3900_usb.c"

/*-------------------- Exported function headers --------------------*/

/* Debug commands*/
static void show_MotorMove (struct stmotormove *params);
static void show_ScanLowLevelConfig (struct st_hwdconfig *params);
static void show_ScanParams (struct st_scanparams *params);
static void show_calibtable (struct st_calib_table *params);
static void TIFF_Save (char *sFile, SANE_Int width, SANE_Int height,
		       SANE_Int depth, SANE_Byte * buffer, SANE_Int size);

/*static SANE_Int  info_registers(SANE_Byte *buffer);*/
/*static SANE_Int  showbuffer(SANE_Int level, char *title, SANE_Byte *buffer, SANE_Int size);*/
/*static void show_diff(SANE_Byte *original);*/

/* Scanner level commands*/
static SANE_Int HP_OP_INIT_SCANNER (void);
static SANE_Int RT_OP_SET_PARAMETER (struct params *param);
static SANE_Int RT_OP_START_SCAN (SANE_Int arg1, SANE_Int arg2);
static void HP_OP_END_SCANNER (void);

/* Functions to manage data */
static SANE_Int Data_Get (SANE_Byte * address, SANE_Int size);
static void Data_Set (SANE_Int data, SANE_Byte * address, SANE_Int size);
static void Data_SetBigEndian (SANE_Int data, SANE_Byte * address,
			       SANE_Int size);
static void Data_BitSet (SANE_Int data, SANE_Byte * address, SANE_Int size);
static void Data_BitSet2 (SANE_Int data, SANE_Byte * address, SANE_Int size,
			  SANE_Int start);

/* Chipset related commands */
static SANE_Int Chipset_ID (void);
static SANE_Int Chipset_Name (char *name, SANE_Int size);

/* Initializing functions */
static SANE_Int Init_Registers (void);
static SANE_Int Init_USBData (void);
static SANE_Int Init_Vars (void);

/* Chipset management useful commands*/
static SANE_Int RTS_USBType (void);
static SANE_Byte RTS_CCDType (void);
static void RTS_DebugInit (void);
static SANE_Int RTS_Enable_CCD (SANE_Byte * Regs, SANE_Int channels);
static SANE_Int RTS_Execute (void);
static SANE_Int RTS_GetImage (SANE_Byte * Regs, struct st_scanparams *myvar,
			      struct st_calib_table *Calibtable,
			      SANE_Byte * buffer,
			      struct st_calibration *myCalib, SANE_Int arg6,
			      SANE_Int gainmode);
static SANE_Byte RTS_IsExecuting (SANE_Byte * Regs);
static SANE_Int RTS_isTmaAttached (void);
static SANE_Int RTS_ReadRegs (SANE_Byte * buffer);
static SANE_Int RTS_SetCoords (SANE_Byte * Regs, SANE_Int iLeft,
			       SANE_Int iTop, SANE_Int iRight,
			       SANE_Int iDown);
static SANE_Int RTS_Setup (SANE_Byte * Regs, struct st_scanparams *myvar,
			   struct st_hwdconfig *hwdcfg,
			   struct st_calib_table *Calibtable);
static SANE_Int RTS_SetupGamma (SANE_Byte * Regs,
				struct st_hwdconfig *lowcfg);
static SANE_Int RTS_WriteRegs (SANE_Byte * buffer);

static SANE_Int Start_Scan (void);
static void StopScan (void);

static void SetLock (SANE_Byte * Regs, SANE_Byte Enable);
static SANE_Int fn3330 (SANE_Byte * Regs, struct st_cal2 *calbuffers,
			SANE_Int sensorchannelcolor, SANE_Int * tablepos,
			SANE_Int data);
static SANE_Int fn3560 (USHORT * table, struct st_cal2 *calbuffers,
			SANE_Int * tablepos);
static SANE_Int fn3730 (struct st_cal2 *calbuffers, SANE_Byte * Regs,
			USHORT * table, SANE_Int sensorchannelcolor,
			SANE_Int data);

static SANE_Int Reading_CreateBuffers (void);
static SANE_Int Reading_DestroyBuffers (void);

static SANE_Int Notify_BufferSize_to_read (SANE_Int data, SANE_Int size);
static SANE_Int Wait_for_desired_size (SANE_Byte Channels_per_dot,
				       SANE_Byte Channel_size, SANE_Int size,
				       SANE_Int * last_amount,
				       SANE_Int seconds, SANE_Byte op);

static SANE_Int fn66d0 (void);
static SANE_Int fnfe70 (SANE_Int * transferred);
static SANE_Int fnb250 (SANE_Byte * buffer, SANE_Int buffer_size,
			SANE_Int * transferred);
static SANE_Int fnf7f0 (SANE_Byte * pPointer1, SANE_Int res1, SANE_Int width1,
			SANE_Byte * pPointer2, SANE_Int res2, SANE_Int width2,
			SANE_Int myresize_mode);
static SANE_Int Resize_Line (SANE_Byte * to_buffer, SANE_Int to_resolution,
			     SANE_Int to_width, SANE_Byte * from_buffer,
			     SANE_Int from_resolution, SANE_Int from_width,
			     SANE_Int myresize_mode);

static SANE_Int Read_Image (SANE_Int buffer_size, SANE_Byte * buffer,
			    SANE_Int * transferred);
static SANE_Int Read_ResizeBlock (SANE_Byte * buffer, SANE_Int buffer_size,
				  SANE_Int * transferred);
static SANE_Int Read_Block (SANE_Int buffer_size, SANE_Byte * buffer,
			    SANE_Int * transferred);
static SANE_Int Read_NonColor_Block (SANE_Byte * buffer, SANE_Int buffer_size,
				     SANE_Byte ColorMode,
				     SANE_Int * transferred);

/* AutoRef functions */
static SANE_Int AutoRef (SANE_Byte * Regs, SANE_Int resolution_x,
			 SANE_Int resolution_y, SANE_Int saveautoreffile);
static SANE_Byte AutoRef_GetCount (void);
static SANE_Int AutoRef_IncCount (void);
static SANE_Int AutoRef_SetCount (SANE_Byte data);

/* Ref functions */
static SANE_Int Refs_Calculate (SANE_Byte depth, SANE_Int width,
				SANE_Int height, SANE_Byte * scanned_pattern,
				SANE_Int * ler1, SANE_Int ler1order,
				SANE_Int * ser1, SANE_Int ser1order);
static SANE_Int Refs_Set (SANE_Byte * Regs, struct st_scanparams *myscan,
			  SANE_Int autoref);
static SANE_Int Refs_GetOrigin (SANE_Int * left_leading,
				SANE_Int * start_pos);
static SANE_Int Refs_SetOrigin (SANE_Int left_leading, SANE_Int start_pos);

/* Coordinates' constrains functions */
static SANE_Int Constrains_Init (void);
static SANE_Int Constrains_Check (SANE_Int Resolution, SANE_Int scantype,
				  struct st_coords *mycoords);
static struct st_coords *Constrains_Get (SANE_Byte scantype);
static SANE_Int Constrains_Set (SANE_Byte type, struct st_coords *coords);
static void Constrains_Free (void);

/* Pulse-Width Modulation functions */
static SANE_Int PWM_GetDutyCycle (SANE_Int * data);
static SANE_Int PWM_GetReady (SANE_Int resolution, SANE_Int * unknown,
			      double diff, SANE_Int totaltime,
			      SANE_Int SANE_Interval, SANE_Int value);
static SANE_Int PWM_SetDutyCycle (SANE_Int duty_cycle);

/* Fixed Pulse-Width Modulation functions */
static SANE_Int FixedPWM_Get (SANE_Byte type);
static SANE_Int FixedPWM_Set (SANE_Int fixedpwm);
static SANE_Int FixedPWM_Use (SANE_Byte enable);

/* Gain and offset functions */
static SANE_Int GainOffset_Clear (void);
static SANE_Int GainOffset_Get (void);
static SANE_Byte GainOffset_GetCount (void);
static SANE_Int GainOffset_IncCount (SANE_Int * arg1);
static SANE_Int GainOffset_SetCount (SANE_Byte data);

/* Gamma functions*/
static SANE_Int Gamma_AllocTable (SANE_Byte * table);
static void Gamma_FreeTables (void);
static SANE_Int Gamma_SendTables (SANE_Byte * Regs, SANE_Byte * gammatable,
				  SANE_Int size);

/* Lamp functions */
static SANE_Int Lamp_OverDrive (SANE_Int itime, SANE_Int lamp);
static SANE_Byte Lamp_GetGainMode (SANE_Int resolution, SANE_Byte scantype);
static SANE_Int Lamp_GetStatus (SANE_Byte * flb_lamp, SANE_Byte * tma_lamp);
static SANE_Int Lamp_IsAtHome (SANE_Byte * Regs);
static SANE_Int Lamp_ParkHome (SANE_Byte * Regs, struct stmotormove *mymotor);
static SANE_Int Lamp_Relocate (SANE_Int park, SANE_Int value, SANE_Int ypos);
static void Lamp_SetGainMode (SANE_Byte * Regs, SANE_Int resolution,
			      SANE_Byte gainmode);
static SANE_Int Lamp_SetStatus (SANE_Byte * Regs, SANE_Int turn_on,
				SANE_Int lamp);
static SANE_Int Lamp_SetStatus2 (SANE_Int turnon, SANE_Int lamp);
static SANE_Int Lamp_SetTimer (SANE_Int minutes);
static SANE_Int Lamp_SetupPwm (SANE_Int lamp);
static SANE_Int Lamp_WaitForPWM (SANE_Int resolution, SANE_Int scan_type);
static SANE_Int Lamp_Warmup (SANE_Byte * Regs, SANE_Int lamp);

/* Motor functions */
static SANE_Byte *Motor_AddStep (SANE_Byte * steps, SANE_Int * bwriten,
				 SANE_Int step);
static SANE_Int Motor_Change (SANE_Byte * buffer, SANE_Byte value);
static void Motor_FreeConfig (void);
static SANE_Int Motor_GetFromResolution (SANE_Int resolution);
static SANE_Int Motor_LoadConfig (SANE_Int inifile);
static SANE_Int Motor_LoadCurve (SANE_Int pos);
static SANE_Int Motor_ParkHome (SANE_Int arg1, SANE_Int arg2);
static SANE_Int Motor_SendSteps (SANE_Byte * steps, SANE_Int count,
				 SANE_Int v15f8);
static SANE_Int Motor_Setup (SANE_Byte * buffer2,
			     struct st_motorsetting *mysetting);

/* Functions to arrange scanned lines */
static SANE_Int Arrange_Colour (SANE_Byte * buffer, SANE_Int buffer_size,
				SANE_Int * transferred);
static SANE_Int Arrange_NonColour (SANE_Byte * buffer, SANE_Int buffer_size,
				   SANE_Int * transferred);

/* Composing RGB triplet functions */
static void Triplet_Gray (SANE_Byte * pPointer1, SANE_Byte * pPointer2,
			  SANE_Byte * buffer, SANE_Int channels_count);
static void Triplet_Lineart (SANE_Byte * pPointer1, SANE_Byte * pPointer2,
			     SANE_Byte * buffer, SANE_Int channels_count);
static void Triplet_Compose_Order (SANE_Byte * pRed, SANE_Byte * pGreen,
				   SANE_Byte * pBlue, SANE_Byte * buffer,
				   SANE_Int dots);
static void Triplet_Compose_HRes (SANE_Byte * pPointer1,
				  SANE_Byte * pPointer2,
				  SANE_Byte * pPointer3,
				  SANE_Byte * pPointer4,
				  SANE_Byte * pPointer5,
				  SANE_Byte * pPointer6, SANE_Byte * buffer,
				  SANE_Int Width);
static void Triplet_Compose_LRes (SANE_Byte * pRed, SANE_Byte * pGreen,
				  SANE_Byte * pBlue, SANE_Byte * buffer,
				  SANE_Int dots);
static void Triplet_Colour_Order (SANE_Byte * pRed, SANE_Byte * pGreen,
				  SANE_Byte * pBlue, SANE_Byte * buffer,
				  SANE_Int Width);
static void Triplet_Colour_HRes (SANE_Byte * pRed1, SANE_Byte * pGreen1,
				 SANE_Byte * pBlue1, SANE_Byte * pRed2,
				 SANE_Byte * pGreen2, SANE_Byte * pBlue2,
				 SANE_Byte * buffer, SANE_Int Width);
static void Triplet_Colour_LRes (SANE_Int Width, SANE_Byte * Buffer,
				 SANE_Byte * pChannel1, SANE_Byte * pChannel2,
				 SANE_Byte * pChannel3);

/* Timing functions */
static SANE_Int Timing_Load (SANE_Int timing);
static SANE_Int Timing_Set (SANE_Int mytiming, SANE_Byte * Regs);
static SANE_Int Timing_Set_cph (SANE_Byte * Regs, struct st_cph *cph);

/* Functions used to manage resizing buffers */
static SANE_Int Resizing_CreateBuffers (SANE_Int size1, SANE_Int size2,
					SANE_Int size3);
static SANE_Int Resizing_DestroyBuffers (void);

/* Scanner buttons support */
static SANE_Int Buttons_Enable (void);
static SANE_Int Buttons_Status (void);

/* Calibration functions */
static SANE_Int Calib_CreateBuffers (struct st_calibration *buffer,
				     SANE_Int my14b4);
static SANE_Int Calib_CreateFixedBuffers (void);
static void Calib_FreeBuffers (struct st_calibration *caltables);
static void Calib_LoadCut (struct st_scanparams *scancfg, SANE_Int scantype,
			   struct st_calibration_data *calibdata,
			   SANE_Int file);
/*static SANE_Int Calib_AdcOffsetRT(struct st_calibration_data *calibdata, SANE_Int value);*/
static SANE_Int Calib_BlackShading (struct st_calibration_data *calibdata,
				    struct st_calibration *myCalib,
				    SANE_Int gainmode);
static SANE_Int Calib_WhiteShading3 (struct st_calibration_data *calibdata,
				     struct st_calibration *myCalib,
				     SANE_Int gainmode);
static void Calibrate_Free (struct st_cal2 *calbuffers);
static SANE_Int Calibrate_Malloc (struct st_cal2 *calbuffers,
				  SANE_Byte * Regs,
				  struct st_calibration *myCalib,
				  SANE_Int somelength);
static SANE_Int Calib_ReadTable (SANE_Byte * table, SANE_Int size,
				 SANE_Int data);
static SANE_Int Calib_SetTable (SANE_Byte * Regs,
				struct st_calib_table *Calibtable);
static SANE_Int Calib_LoadParams (struct st_calibration_data *calibdata,
				  SANE_Int scantype, SANE_Int resolution,
				  SANE_Int bitmode);
static SANE_Int Calib_PAGain (struct st_calibration_data *calibdata,
			      SANE_Int gainmode);
static SANE_Int Calibration (SANE_Byte * TheBuffer,
			     struct st_scanparams *myscan,
			     struct st_calibration *myCalib, SANE_Int value);


static SANE_Int SSCG_Enable (SANE_Byte enable, SANE_Byte mode,
			     SANE_Byte clock);
static void Split_into_12bit_channels (SANE_Byte * destino,
				       SANE_Byte * fuente, SANE_Int size);
static SANE_Int Scan_Read_BufferA (SANE_Int buffer_size, SANE_Int arg2,
				   SANE_Byte * pBuffer,
				   SANE_Int * bytes_transfered);
static SANE_Int Ops_in_0021 (void);
static SANE_Int Get_Scanner_Buffer_Size (SANE_Byte channels_per_dot,
					 SANE_Int channel_size);
static SANE_Int Apply_Gamma_and_Shading (SANE_Byte * Regs,
					 struct st_scanparams *myvar,
					 struct st_hwdconfig *hwdcfg,
					 struct st_gammatables *mygamma,
					 struct st_calibration *myCalib);
static SANE_Int funcion2ec0 (SANE_Byte * TheBuffer,
			     struct st_scanparams *myvar, SANE_Int somevalue);
static SANE_Int Bulk_Operation (SANE_Byte op, SANE_Int buffer_size,
				SANE_Byte * buffer, SANE_Int * transfered);
static SANE_Int fn11b0 (double dSize, SANE_Byte * buffer, double *lf080);
static SANE_Int fn3fc0 (SANE_Byte * buffer, struct st_scanparams *myvar,
			struct st_hwdconfig *hwdcfg);
static SANE_Int Get_PAG_Value (SANE_Byte scantype, SANE_Byte color);
static SANE_Int GetOneLineInfo (SANE_Int resolution,
				struct st_icolours *maximus,
				struct st_icolours *minimus,
				struct st_dcolours *average);

static SANE_Int Set_LER_SER (SANE_Int resolution);
static SANE_Int Load_StripCoords (SANE_Int scantype, SANE_Int * ypos,
				  SANE_Int * xpos);

/*static SANE_Int Get_Gamma_Tables(SANE_Byte *Gamma_buffer);*/

/*static SANE_Int Free_Fixed_CalBuffer(void);*/
static SANE_Int OpenUsbDriver (void);
static SANE_Int SetMultiExposure (SANE_Byte * Regs);

static SANE_Int dump_shading (struct st_calibration *myCalib);

static void Set_E950_Mode (SANE_Byte mode);
static SANE_Int InitProfileName (SANE_Int ccdtype);
static SANE_Int LoadIniParam (void);
static void FreeIniParam (void);
static SANE_Int LoadScannerParams (SANE_Int inifile);
static void FreeScannerParams (void);
static SANE_Int LoadImagingParams (SANE_Int inifile);
static void FreeImagingParams (void);

static SANE_Int LoadScanningConfig (SANE_Int inifile);
static SANE_Int LoadScanModeParams (SANE_Int colormode, SANE_Byte scantype,
				    SANE_Int scanmode, SANE_Int mode);
static SANE_Int *Load_Scan_Mode (SANE_Byte * counter, SANE_Int scancount,
				 SANE_Int scanmode, SANE_Int inifile);

static SANE_Int LoadCheckStable (struct st_checkstable *buffer,
				 SANE_Int mycheck);
static SANE_Int SetPwmLampMode (SANE_Int mode);
static SANE_Int SetScanParams (SANE_Byte * Buffer,
			       struct st_scanparams *myscan,
			       struct st_hwdconfig *hwdcfg);
static SANE_Int SetupScanMode (SANE_Int colormode, SANE_Int resolution);
static char IsScannerLinked (void);
static void EF08_Control (SANE_Byte * buffer, SANE_Byte value);
static SANE_Int E8D9_Control (void);
static SANE_Int WaitForScanner (SANE_Int msecs);

static SANE_Int E800_FLIP_FLOP (void);
static SANE_Int WaitEndingAction (SANE_Int msecs);
static SANE_Int Read_FE3E (SANE_Byte * destino);

static double get_shrd (double value, SANE_Int desp);
static char get_byte (double value);
/*static SANE_Int RTS8822_GetRegisters(SANE_Byte *buffer);*/

/* Lamp */
/*static SANE_Int Lamp_On(void);
static SANE_Int Lamp_Off(void);
static SANE_Int Lamp_Switch(SANE_Int lamp);*/

/* ----------------- Implementation ------------------*/

static void
HP_OP_END_SCANNER (void)
{
  Gamma_FreeTables ();
  FreeIniParam ();
  Constrains_Free ();
}

static SANE_Int
HP_OP_INIT_SCANNER ()
{
  SANE_Int rst;

  DBG (2, "> HP_OP_INIT_SCANNER:\n");

  rst = ERROR;

  /* Try to connect */
  if (OpenUsbDriver () == OK)
    {
      DBG (2, " -> Chipset model ID: %i\n", Chipset_ID ());

      /* Load some calibrating config */
      warmupt1 = get_value (PLATFORM, WARMUPT1, 0, FITCALIBRATE);
      warmupt2 = get_value (PLATFORM, WARMUPT2, 0, FITCALIBRATE);
      ccdtype = get_value (PLATFORM, CCDTYPE, -1, FITCALIBRATE);

      if (ccdtype == -1)
	/* Lets read ccdtype from scanner */
	ccdtype = RTS_CCDType ();

      if (InitProfileName (ccdtype) == OK)
	{
	  if (LoadIniParam () == OK)
	    {
	      if (IsScannerLinked () == OK)
		{
		  Set_E950_Mode (0);
		  Gamma_AllocTable (NULL);
		  Constrains_Init ();
		  rst = OK;
		}
	      else
		FreeIniParam ();
	    }
	}
    }

  return rst;
}

static SANE_Int
RTS_WriteRegs (SANE_Byte * buffer)
{
  SANE_Int rst = ERROR;

  if (buffer != NULL)
    rst = Write_Buffer (0xe800, buffer, 0x71a * sizeof (SANE_Byte));

  return rst;
}

static SANE_Int
RTS_ReadRegs (SANE_Byte * buffer)
{
  SANE_Int rst = ERROR;

  if (buffer != NULL)
    rst = Read_Buffer (0xe800, buffer, 0x71a * sizeof (SANE_Byte));

  return rst;
}

static void
SetLock (SANE_Byte * Regs, SANE_Byte Enable)
{
  SANE_Byte lock;

  DBG (2, "+ SetLock(*Regs, Enable=%i):\n", Enable);

  if (Regs == NULL)
    {
      if (Read_Byte (0xee00, &lock) != OK)
	lock = 0;
    }
  else
    lock = Regs[0x600];

  if (Enable == 0)
    lock &= 0xfb;
  else
    lock |= 4;

  if (Regs != NULL)
    Regs[0x600] = lock;

  Write_Byte (0xee00, lock);

  DBG (2, "- SetLock\n");
}

static void
Set_E950_Mode (SANE_Byte mode)
{
  SANE_Int data;

  DBG (2, "+ Set_E950_Mode(mode=%i):\n", mode);

  if (Read_Word (0xe950, &data) == OK)
    {
      data = (mode == 0) ? data & 0xffbf : data | 0x40;
      Write_Word (0xe950, data);
    }

  DBG (2, "- Set_E950_Mode\n");
}

static SANE_Int
OpenUsbDriver ()
{
  SANE_Int rst;

  DBG (2, "+ OpenUsbDriver:\n");

  /* Gets USB type of this scanner */
  usbtype = RTS_USBType ();

  if (usbtype != ERROR)
    {
      v360c = 1;
      v53ba = 1;
      v0740 = 0;
      rst = OK;
    }
  else
    rst = ERROR;

  DBG (2, "- OpenUsbDriver: rst=%i\n", rst);

  return rst;
}

static SANE_Byte
RTS_CCDType ()
{
  /*
     Returns CCD Type
     01 = TOSHIBA CCD
     00 = SONY CCD
   */

  SANE_Int a, b, c;
  SANE_Byte rst;
  char *strccd[] = { "TOSHIBA", "SONY" };

  DBG (2, "+ RTS_CCDType:\n");

  a = b = c = 0;

  /* Save data first */
  Read_Word (0xe950, &a);
  Read_Word (0xe956, &b);

  /* Enables GPIO 0xe950 writing directly 0x13ff */
  Write_Word (0xe950, 0x13ff);
  /* Sets GPIO 0xe956 writing 0xfcf0 */
  Write_Word (0xe956, 0xfcf0);
  /* Makes a sleep of 200 ms */
  usleep (1000 * 200);
  /* Get GPIO 0xe968 */
  Read_Word (0xe968, &c);
  /* Restore data */
  Write_Word (0xe950, a);
  Write_Word (0xe956, b);

  rst = ((_B1 (c) & 1) == 0) ? TOSHIBA : SONY;

  a = (rst == TOSHIBA) ? 0 : 1;
  DBG (2, "- RTS_CCDType: %s\n", strccd[a]);

  return rst;
}

static SANE_Int
InitProfileName (SANE_Int ccdtype)
{
  DBG (2, "> InitProfileName(ccdtype=%i):\n", ccdtype);

  if (ccdtype == TOSHIBA)
    {
      /* Toshiba ccd */
      usbfile = (usbtype == USB20) ? T_RTINIFILE : T_USB1INIFILE;
      timingfile = T_TIMING1;
    }
  else
    {
      /* Sony ccd */
      usbfile = (usbtype == USB20) ? S_RTINIFILE : S_USB1INIFILE;
      timingfile = S_TIMING1;
    }

  pwmlampenabled = get_value (SCAN_PARAM, PWMLAMPENABLED, 2, usbfile);
  pwmlamplevel = get_value (SCAN_PARAM, PWMLAMPLEVEL, 1, usbfile);
  pwmlampfrequencyflb1200 =
    get_value (SCAN_PARAM, PWMLAMPFREQUENCYFLB1200, 9, usbfile);
  pwmlampdutycycleflb1200 =
    get_value (SCAN_PARAM, PWMLAMPDUTYCYCLEFLB1200, 0x0d, usbfile);
  pwmlampfrequencyflb600 =
    get_value (SCAN_PARAM, PWMLAMPFREQUENCYFLB600, 9, usbfile);
  pwmlampdutycycleflb600 =
    get_value (SCAN_PARAM, PWMLAMPDUTYCYCLEFLB600, 0x0d, usbfile);
  pwmlampfrequencyta1200 =
    get_value (SCAN_PARAM, PWMLAMPFREQUENCYTA1200, 9, usbfile);
  pwmlampdutycycleta1200 =
    get_value (SCAN_PARAM, PWMLAMPDUTYCYCLETA1200, 0x0d, usbfile);
  pwmlampfrequencyta600 =
    get_value (SCAN_PARAM, PWMLAMPFREQUENCYTA600, 9, usbfile);
  pwmlampdutycycleta600 =
    get_value (SCAN_PARAM, PWMLAMPDUTYCYCLETA600, 0x0d, usbfile);
  pwmlampfrequencyneg1200 =
    get_value (SCAN_PARAM, PWMLAMPFREQUENCYNEG1200, 9, usbfile);
  pwmlampdutycycleneg1200 =
    get_value (SCAN_PARAM, PWMLAMPDUTYCYCLENEG1200, 0x0d, usbfile);
  pwmlampfrequencyneg600 =
    get_value (SCAN_PARAM, PWMLAMPFREQUENCYNEG600, 9, usbfile);
  pwmlampdutycycleneg600 =
    get_value (SCAN_PARAM, PWMLAMPDUTYCYCLENEG600, 0x0d, usbfile);
  dpi100Lumping = get_value (SCAN_PARAM, DPILUMPING100, 0, usbfile);
  changemotorcurrent = get_value (SCAN_PARAM, CHANGEMOTORCURRENT, 0, usbfile);

  return OK;
}

static void
FreeIniParam ()
{
  FreeScannerParams ();
  FreeImagingParams ();
}

static SANE_Int
LoadIniParam ()
{
  DBG (2, "> LoadIniParam:\n");

  LoadScannerParams (usbfile);
  LoadImagingParams (usbfile);

  return OK;
}

static SANE_Int
LoadScanModeParams (SANE_Int colormode, SANE_Byte scantype, SANE_Int scanmode,
		    SANE_Int mode)
{
  SANE_Int rst, imode;

  DBG (2,
       "> LoadScanModeParams(colormode=%i, scantype=%i, scanmode=%i, mode=%i):\n",
       colormode, scantype, scanmode, mode);

  rst = OK;

  switch (colormode)
    {
    case CM_COLOR:
    case 3:
      switch (scantype)
	{
	case ST_NEG:
	  imode = SCANNEGCOLORMODE1;
	  break;
	case ST_TA:
	  imode = SCANTACOLORMODE1;
	  break;
	case ST_NORMAL:
	  imode = SCANCOLORMODE1;
	  break;
	default:
	  rst = ERROR;
	}
      break;
    case CM_GRAY:
      switch (scantype)
	{
	case ST_NEG:
	  imode = SCANNEGGRAYMODE1;
	  break;
	case ST_TA:
	  imode = SCANTAGRAYMODE1;
	  break;
	case ST_NORMAL:
	  imode = SCANGRAYMODE1;
	  break;
	default:
	  rst = ERROR;
	}
      break;
    case CM_LINEART:
      switch (scantype)
	{
	case ST_NEG:
	  if (get_value (PLATFORM, SCANNEGLINEARTCOUNT, 0, usbfile) == 0)
	    imode = SCANNEGGRAYMODE1;
	  else
	    imode = SCANNEGLINEARTMODE1;
	  break;
	case ST_TA:
	  if (get_value (PLATFORM, SCANTALINEARTCOUNT, 0, usbfile) == 0)
	    imode = SCANTAGRAYMODE1;
	  else
	    imode = SCANTALINEARTMODE1;
	  break;
	case ST_NORMAL:
	  if (get_value (PLATFORM, SCANLINEARTCOUNT, 0, usbfile) == 0)
	    imode = SCANGRAYMODE1;
	  else
	    imode = SCANLINEARTMODE1;
	  break;
	default:
	  rst = ERROR;
	}
      break;
    default:
      rst = ERROR;
    }

  if (rst == OK)
    {
      SANE_Int mymode = imode + scanmode;
      if (scanmodeparams == NULL)
	{
	  scanmodeparams =
	    (struct st_scanmode *) malloc (sizeof (struct st_scanmode) *
					   scandata[IST_NEG].
					   color[ICM_LINEART].totalcount);

	  if (scanmodeparams != NULL)
	    bzero (scanmodeparams,
		   sizeof (struct st_scanmode) *
		   scandata[IST_NEG].color[ICM_LINEART].totalcount);
	}
      else
	{
	  if (mode > scandata[IST_NEG].color[ICM_LINEART].totalcount)
	    scanmodeparams =
	      (struct st_scanmode *) realloc (scanmodeparams,
					      sizeof (struct st_scanmode) *
					      scandata[IST_NEG].
					      color[ICM_LINEART].totalcount);
	}

      if ((scanmodeparams != NULL) && (mode >= 0x00)
	  && (mode <= scandata[IST_NEG].color[ICM_LINEART].totalcount))
	{
	  struct st_scanmode *sm;
	  SANE_Byte multiexposure;
	  SANE_Int cont;

	  sm = &scanmodeparams[mode];
	  sm->samplerate = get_value (mymode, SAMPLERATE, 0, usbfile);
	  sm->systemclock = get_value (mymode, SYSTEMCLOCK, 0, usbfile);
	  sm->ctpc = get_value (mymode, CTPC, 0, usbfile);
	  sm->dummyline = get_value (mymode, DUMMYLINE, 0, usbfile);
	  sm->expt[0] = get_value (mymode, EXPT1, 0, usbfile);
	  sm->expt[1] = get_value (mymode, EXPT2, 0, usbfile);
	  sm->expt[2] = get_value (mymode, EXPT3, 0, usbfile);
	  sm->mexpt[0] = get_value (mymode, MEXPT1, 0, usbfile);
	  sm->mexpt[1] = get_value (mymode, MEXPT2, 0, usbfile);
	  sm->mexpt[2] = get_value (mymode, MEXPT3, 0, usbfile);
	  sm->motorplus = get_value (mymode, MOTORPLUS, 0, usbfile);
	  sm->timing = get_value (mymode, TIMING, 1, usbfile) - 1;
	  sm->motorcurve = get_value (mymode, MOTORCURVE, 1, usbfile);
	  sm->motorbackstep = get_value (mymode, MOTORBACKSTEP, 0, usbfile);
	  sm->multiexposurefor16bitmode =
	    get_value (mymode, MULTIEXPOSUREFOR16BITMODE, 1, usbfile);
	  sm->multiexposureforfullspeed =
	    get_value (mymode, MULTIEXPOSUREFORFULLSPEED, 1, usbfile);

	  multiexposure = get_value (mymode, MULTIEXPOSURE, 1, usbfile);

	  for (cont = 0; cont < 3; cont++)
	    {
	      if (sm->mexpt[cont] == 0)
		{
		  sm->mexpt[cont] = sm->ctpc;
		  if (multiexposure != 1)
		    sm->expt[cont] = sm->ctpc;
		}
	    }

	  sm->ctpc = ((sm->ctpc + 1) * multiexposure) - 1;

	  if (sm->motorcurve == 0)
	    {
	      sm->has_curves = FALSE;
	      sm->mmtir = get_value (mymode, MMTIR, 2, usbfile);
	      sm->mmtirh = get_value (mymode, MMTIRH, 2, usbfile);
	    }
	  else
	    {
	      sm->has_curves = TRUE;
	      sm->motorcurve--;
	    }

	  sm->mri = get_value (mymode, MRI, 1, usbfile);
	  sm->msi = get_value (mymode, MSI, 0x10, usbfile);

	  sm->skiplinecount = get_value (mymode, SKIPLINECOUNT, 0, usbfile);
	  sm->scanmotorsteptype =
	    _B0 (get_value (mymode, SCANMOTORSTEPTYPE, 0, usbfile));
	  if (sm->scanmotorsteptype > 3)
	    sm->scanmotorsteptype = 0;
	}
      else
	rst = OK;
    }

  return rst;
}

static void
FreeScannerParams ()
{
  SANE_Int C, D;

  for (C = 0; C < 3; C++)
    for (D = 0; D < 3; D++)
      if (scandata[C].color[D].mode != NULL)
	{
	  free (scandata[C].color[D].mode);
	  scandata[C].color[D].mode = NULL;
	}
}

static SANE_Int
LoadScannerParams (SANE_Int inifile)
{
  SANE_Int a, chorder, chcolor, chgray;
  long double b;

  DBG (2, "> LoadScannerParams(%i)\n", inifile);

  scantype = ST_NORMAL;
  arrangeline2 = get_value (SCAN_PARAM, ARRANGELINE, FIX_BY_HARD, inifile);
  motorcount = get_value (PLATFORM, MOTORCOUNT, 0, inifile);
  timingcount = get_value (PLATFORM, TIMINGCOUNT, 0, inifile);
  sensortype = get_value (PLATFORM, SENSORTYPE, TOSHIBA, inifile);
  realsensorresolution =
    get_value (PLATFORM, REALSENSORRESOLUTION, 0, inifile);
  sensorlinedistance = get_value (PLATFORM, SENSORLINEDISTANCE, 0, inifile);
  motortype = get_value (PLATFORM, MOTORTYPE, 0, inifile);
  motorpwmfrequency = get_value (PLATFORM, MOTORPWMFREQUENCY, 0x1e, inifile);
  motorresolution = get_value (PLATFORM, MOTORRESOLUTION, 0, inifile);
  binarythresholdh = get_value (PLATFORM, BINARYTHRESHOLDH, 0x80, inifile);
  binarythresholdl = get_value (PLATFORM, BINARYTHRESHOLDL, 0x7f, inifile);

  chorder = get_value (PLATFORM, RGBCHANNELORDER, 0x7b, inifile);
  chcolor = get_value (PLATFORM, SENSORCHANNELCOLOR, 0x7b, inifile);
  chgray = get_value (PLATFORM, SENSORCHANNELGRAY, 0x0c, inifile);

  for (a = 0; a < 3; a++)
    {
      rgbchannelorder[2 - a] = _B0 (chorder % 0x0a) - 1;
      b = chorder;
      b = (b * 0x66666667);
      b = b / pow (2, 32);
      b = b / 4;
      chorder = b;
      chorder += (chorder >> 0x1f);

      sensorchannelcolor[2 - a] = _B0 (chcolor % 10) - 1;
      b = chcolor;
      b = (b * 0x66666667);
      b = b / pow (2, 32);
      b = b / 0x04;
      chcolor = b;
      chcolor += (chcolor >> 0x1f);
    }

  if (chgray > 0x0a)
    {
      sensorchannelgray[0] = _B0 (chgray % 10) - 1;
      b = chgray;
      b = (b * 0x66666667);
      b = b / pow (2, 32);
      b = b / 4;
      chgray = b;
      sensorchannelgray[0x01] = chgray + (chgray >> 0x1f);
    }
  else
    sensorchannelgray[0] = chgray - 1;

  bzero (&scandata, sizeof (struct st_scantypes) * 3);

  /* NORMAL */
  scandata[IST_NORMAL].color[ICM_COLOR].mode =
    Load_Scan_Mode (&scandata[IST_NORMAL].color[ICM_COLOR].count,
		    SCANCOLORCOUNT, SCANCOLORMODE1, inifile);

  scandata[IST_NORMAL].color[ICM_GRAY].mode =
    Load_Scan_Mode (&scandata[IST_NORMAL].color[ICM_GRAY].count,
		    SCANGRAYCOUNT, SCANGRAYMODE1, inifile);

  scandata[IST_NORMAL].color[ICM_LINEART].mode =
    Load_Scan_Mode (&scandata[IST_NORMAL].color[ICM_LINEART].count,
		    SCANLINEARTCOUNT, SCANLINEARTMODE1, inifile);

  if (scandata[IST_NORMAL].color[ICM_LINEART].mode == NULL)
    {
      if (scandata[IST_NORMAL].color[ICM_GRAY].mode != NULL)
	{
	  scandata[IST_NORMAL].color[ICM_LINEART].count =
	    scandata[IST_NORMAL].color[ICM_GRAY].count;

	  if (scandata[IST_NORMAL].color[ICM_LINEART].count > 0)
	    {
	      scandata[IST_NORMAL].color[ICM_LINEART].mode =
		(SANE_Int *) malloc (sizeof (SANE_Int) *
				     scandata[IST_NORMAL].color[ICM_LINEART].
				     count);

	      if (scandata[IST_NORMAL].color[ICM_LINEART].mode != NULL)
		for (a = 0; a < scandata[IST_NORMAL].color[ICM_LINEART].count;
		     a++)
		  scandata[IST_NORMAL].color[ICM_LINEART].mode[a] =
		    scandata[IST_NORMAL].color[ICM_GRAY].mode[a];
	    }
	}
    }

  /* TA */
  scandata[IST_TA].color[ICM_COLOR].mode =
    Load_Scan_Mode (&scandata[IST_TA].color[ICM_COLOR].count,
		    SCANTACOLORCOUNT, SCANTACOLORMODE1, inifile);

  scandata[IST_TA].color[ICM_GRAY].mode =
    Load_Scan_Mode (&scandata[IST_TA].color[ICM_GRAY].count, SCANTAGRAYCOUNT,
		    SCANTAGRAYMODE1, inifile);

  scandata[IST_TA].color[ICM_LINEART].mode =
    Load_Scan_Mode (&scandata[IST_TA].color[ICM_LINEART].count,
		    SCANTALINEARTCOUNT, SCANTALINEARTMODE1, inifile);

  if (scandata[IST_TA].color[ICM_LINEART].mode == NULL)
    {
      if (scandata[IST_TA].color[ICM_GRAY].mode != NULL)
	{
	  scandata[IST_TA].color[ICM_LINEART].count =
	    scandata[IST_TA].color[ICM_GRAY].count;

	  if (scandata[IST_TA].color[ICM_LINEART].count > 0)
	    {
	      scandata[IST_TA].color[ICM_LINEART].mode =
		(SANE_Int *) malloc (sizeof (SANE_Int) *
				     scandata[IST_TA].color[ICM_LINEART].
				     count);
	      if (scandata[IST_TA].color[ICM_LINEART].mode != NULL)
		for (a = 0; a < scandata[IST_TA].color[ICM_LINEART].count;
		     a++)
		  scandata[IST_TA].color[ICM_LINEART].mode[a] =
		    scandata[IST_TA].color[ICM_GRAY].mode[a];
	    }
	}
    }

  /* NEG */
  scandata[IST_NEG].color[ICM_COLOR].mode =
    Load_Scan_Mode (&scandata[IST_NEG].color[ICM_COLOR].count,
		    SCANNEGCOLORCOUNT, SCANNEGCOLORMODE1, inifile);

  scandata[IST_NEG].color[ICM_GRAY].mode =
    Load_Scan_Mode (&scandata[IST_NEG].color[ICM_GRAY].count,
		    SCANNEGGRAYCOUNT, SCANNEGGRAYMODE1, inifile);

  scandata[IST_NEG].color[ICM_LINEART].mode =
    Load_Scan_Mode (&scandata[IST_NEG].color[ICM_LINEART].count,
		    SCANNEGLINEARTCOUNT, SCANNEGLINEARTMODE1, inifile);

  if (scandata[IST_NEG].color[ICM_LINEART].mode == NULL)
    {
      if (scandata[IST_NEG].color[ICM_GRAY].mode != NULL)
	{
	  scandata[IST_NEG].color[ICM_LINEART].count =
	    scandata[IST_NEG].color[ICM_GRAY].count;

	  if (scandata[IST_NEG].color[ICM_LINEART].count > 0)
	    {
	      scandata[IST_NEG].color[ICM_LINEART].mode =
		(SANE_Int *) malloc (sizeof (SANE_Int) *
				     scandata[IST_NEG].color[ICM_LINEART].
				     count);
	      if (scandata[IST_NEG].color[ICM_LINEART].mode != NULL)
		for (a = 0; a < scandata[IST_NEG].color[ICM_LINEART].count;
		     a++)
		  scandata[IST_NEG].color[ICM_LINEART].mode[a] =
		    scandata[IST_NEG].color[ICM_GRAY].mode[a];
	    }
	}
    }

  {
    SANE_Int st, cm, sum;
    SANE_Int c[3] = { ICM_COLOR, ICM_GRAY, ICM_LINEART };

    sum = 0;
    for (st = IST_NORMAL; st <= IST_NEG; st++)
      {
	for (cm = 0; cm < 3; cm++)
	  {
	    scandata[st].color[c[cm]].totalcount = sum;
	    sum += scandata[st].color[c[cm]].count;
	  }
      }
  }

  dmabuffersize = get_value (DMA_PARAM, DMABUFFERSIZE, 0x800000, inifile);
  dmasetlength = get_value (DMA_PARAM, DMASETLENGTH, 0x40000, inifile);
  dmatransfersize = get_value (DMA_PARAM, DMATRANSFERSIZE, 0x40000, inifile);
  shadingbase = get_value (TRUE_GRAY_PARAM, SHADINGBASE, 3, inifile);
  shadingfact[0] = get_value (TRUE_GRAY_PARAM, SHADINGFACT1, 1, inifile);
  shadingfact[1] = get_value (TRUE_GRAY_PARAM, SHADINGFACT2, 1, inifile);
  shadingfact[2] = get_value (TRUE_GRAY_PARAM, SHADINGFACT3, 1, inifile);

  return OK;
}

static SANE_Int *
Load_Scan_Mode (SANE_Byte * counter, SANE_Int scancount, SANE_Int scanmode,
		SANE_Int inifile)
{
  SANE_Int a, data, count, option;
  SANE_Int *scanbuffer;

  DBG (2,
       "> Load_Scan_Mode(counter=%i, scancount='%i', scanmode='%i', inifile='%i'):\n",
       *counter, scancount, scanmode, inifile);

  count = 0;
  scanbuffer = NULL;

  *counter = _B0 (get_value (PLATFORM, scancount, 0, inifile));
  option = scanmode;
  for (a = 0; a < *counter; a++)
    {
      data = get_value (PLATFORM, option, 0, inifile) & 0xffff;
      if (data > 0)
	{
	  count++;
	  if (scanbuffer == NULL)
	    scanbuffer = (SANE_Int *) malloc (sizeof (SANE_Int) * count);
	  else
	    scanbuffer =
	      (SANE_Int *) realloc (scanbuffer, sizeof (SANE_Int) * count);

	  if (scanbuffer == NULL)
	    {
	      count = 0;
	      break;
	    }
	  else
	    scanbuffer[count - 1] = data;
	}
      option++;
    }
  *counter = count;

  return scanbuffer;
}

static void
FreeImagingParams ()
{
  Motor_FreeConfig ();
}

static SANE_Int
LoadImagingParams (SANE_Int inifile)
{
  SANE_Int C, edg1, edg2, odg1, odg2, vga1, vga2, pag;

  DBG (2, "> LoadImagingParams(inifile='%i'):\n", inifile);

  scan.startpos = get_value (SCAN_PARAM, STARTPOS, 0, inifile);
  scan.leftleading = get_value (SCAN_PARAM, LEFTLEADING, 0, inifile);
  arrangeline = get_value (SCAN_PARAM, ARRANGELINE, FIX_BY_HARD, inifile);
  calibrate = get_value (SCAN_PARAM, CALIBRATE, 2, inifile);
  throughput = get_value (SCAN_PARAM, THROUGHPUT, 0, inifile);
  compression = get_value (SCAN_PARAM, COMPRESSION, 0, inifile);

  edg1 = EDCG11;
  edg2 = EDCG21;
  odg1 = ODCG11;
  odg2 = ODCG21;
  vga1 = VGAG11;
  vga2 = VGAG21;
  pag = PAG1;

  for (C = CL_RED; C <= CL_BLUE; C++)
    {
      default_calib_table.edcg1[C] = get_value (SCAN_PARAM, edg1, 0, inifile);
      default_calib_table.edcg2[C] = get_value (SCAN_PARAM, edg2, 0, inifile);
      default_calib_table.odcg1[C] = get_value (SCAN_PARAM, odg1, 0, inifile);
      default_calib_table.odcg2[C] = get_value (SCAN_PARAM, odg2, 0, inifile);
      default_calib_table.vgag1[C] = get_value (SCAN_PARAM, vga1, 4, inifile);
      default_calib_table.vgag2[C] = get_value (SCAN_PARAM, vga2, 4, inifile);
      default_calib_table.pag[C] = get_value (SCAN_PARAM, pag, 3, inifile);
      edg1++;
      edg2++;
      odg1++;
      odg2++;
      vga1++;
      vga2++;
      pag++;
    }

  linedarlampoff = get_value (CALI_PARAM, LINEDARLAMPOFF, 0, inifile);
  linedarklevel1 = get_value (CALI_PARAM, LINEDARKLEVEL1, 5, inifile);
  linedarklevel2 = get_value (CALI_PARAM, LINEDARKLEVEL2, 4, inifile);
  pixeldarklevel = get_value (CALI_PARAM, PIXELDARKLEVEL, 0x00ffff, inifile);

  pixeldarkscanlines =
    get_value (CALI_PARAM, PIXELDARKSCANLINES, 0x14, inifile);
  pixeldarkdiscardpercent =
    get_value (CALI_PARAM, PIXELDARKDISCARDPERCENT, 0x23, inifile);
  waittimeafterpixeldark =
    get_value (CALI_PARAM, WAITTIMEAFTERPIXELDARK, 0, inifile);
  discardwhitepercent1 =
    get_value (CALI_PARAM, DISCARDWHITEPERCENT, 0x64, inifile) + 1000;
  discardwhitepercent2 =
    get_value (CALI_PARAM, DISCARDWHITEPERCENT, 0x5a, inifile) + 1000;
  discardwhitepercent3 =
    get_value (CALI_PARAM, DISCARDWHITEPERCENT, 0x50, inifile) + 1000;
  discardblackpercent1 =
    1000 - get_value (CALI_PARAM, DISCARDBLACKPERCENT, 0x32, inifile);
  discardblackpercent2 =
    1000 - get_value (CALI_PARAM, DISCARDBLACKPERCENT, 0x28, inifile);
  discardblackpercent3 =
    1000 - get_value (CALI_PARAM, DISCARDBLACKPERCENT, 0x06, inifile);
  sensortype = get_value (PLATFORM, SENSORTYPE, 1, inifile);

  if (sensortype == TOSHIBA)
    sensorevenodddistance =
      get_value (PLATFORM, SENSOREVENODDDISTANCE, 0, inifile);

  realsensorresolution =
    get_value (PLATFORM, REALSENSORRESOLUTION, 2400, inifile);
  motorresolution = get_value (PLATFORM, MOTORRESOLUTION, 2400, inifile);
  lampofftimer = get_value (PLATFORM, LAMPOFFTIMER, 5, inifile);
  lampwarmupchecklevel =
    get_value (PLATFORM, LAMPWARMUPCHECKLEVEL, 0, inifile);
  binarythresholdh = get_value (PLATFORM, BINARYTHRESHOLDH, 0x80, inifile);
  binarythresholdl = get_value (PLATFORM, BINARYTHRESHOLDL, 0x7f, inifile);
  basetargetcode = get_value (PLATFORM, BASETARGETCODE, 0x00f0f0f0, inifile);

  basetarget1 = _B0 (basetargetcode / 128);
  basetarget2 = _B0 (basetargetcode / 10);

  basespeedpps = get_value (MOVEMOTORSETTING, BASESPEEDPPS, 0x2bc, inifile);
  basespeedmotormove =
    get_value (MOVEMOTORSETTING, BASESPEEDMOTORMOVE, 0, inifile);
  highspeedmotormove =
    get_value (MOVEMOTORSETTING, HIGHSPEEDMOTORMOVE, 0, inifile);
  parkhomemotormove =
    get_value (MOVEMOTORSETTING, PARKHOMEMOTORMOVE, 0, inifile);

  Motor_LoadConfig (inifile);
  LoadScanningConfig (inifile);

  return OK;
}

static SANE_Int
Arrange_Colour (SANE_Byte * buffer, SANE_Int buffer_size,
		SANE_Int * transferred)
{
  /*
     05F0FA78   04EC00D8  /CALL to Assumed StdFunc2 from hpgt3970.04EC00D3
     05F0FA7C   05D10048  |Arg1 = 05D10048
     05F0FA80   0000F906  \Arg2 = 0000F906
   */
  SANE_Int mydistance;
  SANE_Int Lines_Count;
  SANE_Int space;
  SANE_Int rst = OK;
  SANE_Int c;

  DBG (2, "> Arrange_Colour(*buffer, buffer_size=%i, *transferred)\n",
       buffer_size);

  if (scanning.imagebuffer == NULL)
    {
      if (sensortype == TOSHIBA)
	mydistance =
	  (sensorlinedistance * scan2.resolution_y) / realsensorresolution;
      else
	mydistance = 0;

      /*aafa */
      if (mydistance != 0)
	{
	  scanning.bfsize =
	    (use_hightresolution == TRUE) ? use_sensorevenodddist : 0;
	  scanning.bfsize = (scanning.bfsize + (mydistance * 2) + 1) * v158c;
	}
      else
	scanning.bfsize = v158c * 2;

      /*ab3c */
      space =
	(((scanning.bfsize / v158c) * bytesperline) >
	 scanning.bfsize) ? (scanning.bfsize / v158c) *
	bytesperline : scanning.bfsize;

      scanning.imagebuffer =
	(SANE_Byte *) malloc (space * sizeof (SANE_Byte));
      if (scanning.imagebuffer == NULL)
	return ERROR;

      scanning.imagepointer = scanning.imagebuffer;

      if (Read_Block (scanning.bfsize, scanning.imagebuffer, transferred) !=
	  OK)
	return ERROR;

      orderchannel = FALSE;
      channel_size = (scan2.depth == 8) ? 1 : 2;

      /* Calculate channel displacements */
      for (c = CL_RED; c <= CL_BLUE; c++)
	{
	  if (mydistance == 0)
	    {
	      /*ab9b */
	      if (use_hightresolution == FALSE)
		{
		  if ((((sensorlinedistance * scan2.resolution_y) * 2) /
		       realsensorresolution) == 1)
		    orderchannel = TRUE;

		  if (orderchannel == TRUE)
		    scanning.desp[c] =
		      ((rgbchannelorder[c] / 2) * v158c) + (channel_size * c);
		  else
		    scanning.desp[c] = channel_size * c;
		}
	    }
	  else
	    {
	      /*ac32 */
	      scanning.desp[c] =
		(rgbchannelorder[c] * (mydistance * v158c)) +
		(channel_size * c);

	      if (use_hightresolution == TRUE)
		{
		  scanning.desp1[c] = scanning.desp[c];
		  scanning.desp2[c] =
		    ((channel_size * 3) + scanning.desp[c]) +
		    (use_sensorevenodddist * v158c);
		}
	    }
	}

      /*ace2 */
      for (c = CL_RED; c <= CL_BLUE; c++)
	{
	  if (use_hightresolution == TRUE)
	    {
	      scanning.pColour2[c] = scanning.imagebuffer + scanning.desp2[c];
	      scanning.pColour1[c] = scanning.imagebuffer + scanning.desp1[c];
	    }
	  else
	    scanning.pColour[c] = scanning.imagebuffer + scanning.desp[c];
	}
    }

  /*ad91 */
  Lines_Count = buffer_size / v158c;
  while (Lines_Count > 0)
    {
      if (orderchannel == FALSE)
	{
	  if (use_hightresolution == TRUE)
	    Triplet_Colour_HRes (scanning.pColour1[CL_RED],
				 scanning.pColour1[CL_GREEN],
				 scanning.pColour1[CL_BLUE],
				 scanning.pColour2[CL_RED],
				 scanning.pColour2[CL_GREEN],
				 scanning.pColour2[CL_BLUE], buffer,
				 v158c / (channel_size * 3));
	  else
	    Triplet_Colour_LRes (v158c / (channel_size * 3), buffer,
				 scanning.pColour[CL_RED],
				 scanning.pColour[CL_GREEN],
				 scanning.pColour[CL_BLUE]);
	}
      else
	Triplet_Colour_Order (scanning.pColour[CL_RED],
			      scanning.pColour[CL_GREEN],
			      scanning.pColour[CL_BLUE], buffer,
			      v158c / (channel_size * 3));

      v15b8 -= bytesperline;
      if (v15b8 < 0)
	v15bc--;

      buffer += v158c;

      Lines_Count--;
      if (Lines_Count == 0)
	{
	  if ((v15b8 | v15bc) == 0)
	    return OK;
	}

      if (Read_Block (v158c, scanning.imagepointer, transferred) == ERROR)
	return ERROR;

      /* Update displacements */
      for (c = CL_RED; c <= CL_BLUE; c++)
	{
	  if (use_hightresolution == TRUE)
	    {
	      /*aeb7 */
	      scanning.desp2[c] =
		(scanning.desp2[c] + v158c) % scanning.bfsize;
	      scanning.desp1[c] =
		(scanning.desp1[c] + v158c) % scanning.bfsize;

	      scanning.pColour2[c] = scanning.imagebuffer + scanning.desp2[c];
	      scanning.pColour1[c] = scanning.imagebuffer + scanning.desp1[c];
	    }
	  else
	    {
	      /*af86 */
	      scanning.desp[c] = (scanning.desp[c] + v158c) % scanning.bfsize;
	      scanning.pColour[c] = scanning.imagebuffer + scanning.desp[c];
	    }
	}

      /*aff3 */
      scanning.imagepointer += v158c;
      if (scanning.imagepointer >= (scanning.imagebuffer + scanning.bfsize))
	scanning.imagepointer = scanning.imagebuffer;
    }

  return rst;
}

static SANE_Int
RT_OP_SET_PARAMETER (struct params *param)
{
  SANE_Int rst;
  char sdebug[20];
  SANE_Byte mybuffer[1];
  struct st_hwdconfig hwdcfg;

  DBG (2, "+ RT_OP_SET_PARAMETER:\n");
  DBG (2, "->  param->resolution_x=%i\n", param->resolution_x);
  DBG (2, "->  param->resolution_y=%i\n", param->resolution_y);
  DBG (2, "->  param->left        =%i\n", param->coords.left);
  DBG (2, "->  param->width       =%i\n", param->coords.width);
  DBG (2, "->  param->top         =%i\n", param->coords.top);
  DBG (2, "->  param->height      =%i\n", param->coords.height);

  if (param->colormode == CM_LINEART)
    strcpy (sdebug, "CM_LINEART\n");
  else if (param->colormode == CM_GRAY)
    strcpy (sdebug, "CM_GRAY\n");
  else
    strcpy (sdebug, "\n");
  DBG (2, "->    param->colormode   =%i = %s", param->colormode, sdebug);

  switch (param->scantype)
    {
    case ST_NORMAL:
      strcpy (sdebug, "ST_NORMAL\n");
      break;
    case ST_TA:
      strcpy (sdebug, "ST_TA\n");
      break;
    case ST_NEG:
      strcpy (sdebug, "ST_NEG\n");
      break;
    default:
      DBG (2, "\n");
    }
  DBG (2, "->    param->scantype    =%i = %s", param->scantype, sdebug);
  DBG (2, "->    param->depth       =%i\n", param->depth);
  DBG (2, "->    param->channel     =%i\n", param->channel);

  bzero (&hwdcfg, sizeof (struct st_hwdconfig));

  scan.resolution_x = param->resolution_x;
  scan.resolution_y = param->resolution_y;

  if (param->coords.width == 0)
    bzero (&scan.coord, sizeof (struct st_coords));
  else
    memcpy (&scan.coord, &param->coords, sizeof (struct st_coords));

  switch (param->colormode)
    {
    case CM_LINEART:
      scan.colormode = CM_LINEART;
      scan.depth = 8;
      break;
    case CM_GRAY:
      scan.colormode = CM_GRAY;
      scan.depth = param->depth;
      break;
    case CM_COLOR:
      scan.colormode = CM_COLOR;
      scan.depth = param->depth;
      break;
    }

  scan.channel = _B0 (param->channel);

  arrangeline = FIX_BY_HARD;
  if (scan.resolution_x == 2400)
    {
      if (scan.colormode != CM_COLOR)
	{
	  if (scan.colormode == CM_GRAY)
	    {
	      if (scan.channel == 3)
		arrangeline = FIX_BY_SOFT;
	    }
	}
      else
	arrangeline = FIX_BY_SOFT;
    }

  if ((param->scantype > 0) && (param->scantype < 4))
    {
      hwdcfg.scantype = param->scantype;
      scan.scantype = param->scantype;
    }
  else
    {
      hwdcfg.scantype = ST_NORMAL;
      scan.scantype = ST_NORMAL;
    }

  BGeneral[0x146] |= 0x40;
  if (sensortype == SONY)
    BGeneral[0x146] &= 0xbf;	/* if sony sensor */

  /* turn on appropiated lamp */
  if (scan.scantype == ST_NORMAL)
    Lamp_SetStatus2 (TRUE, FLB_LAMP - 1);
  else
    Lamp_SetStatus2 (TRUE, TMA_LAMP - 1);

  mybuffer[0] = 0;
  if (RTS_IsExecuting (mybuffer) == FALSE)
    RTS_WriteRegs (BGeneral);

  hwdcfg.calibrate = mybuffer[0];

  if ((scan.coord.width != 0) && (scan.coord.height != 0))
    {
      if ((scan.colormode != CM_LINEART) && (scan.depth == 16))
	compression = FALSE;

      hwdcfg.arrangeline = arrangeline;	/*1 */
      hwdcfg.highresolution = (scan.resolution_x > 1200) ? TRUE : FALSE;
      hwdcfg.sensorevenodddistance = sensorevenodddistance;

      SetScanParams (BGeneral, &scan, &hwdcfg);
      v11c8 = 0;
      v11ec = 0;
      v11f8 = 0;
      v11e8 = 0;
      v11f0 = 0;
      v11f4 = 0;
      scan.shadinglength =
	(((scan.sensorresolution * 17) / 2) + 3) & 0xfffffffc;
      v11fc = 0;
      v11e4 = 0;
      v1200 = 0;
      v11d0 = 0;
      v11cc = 0;
      v11d4 = 0;
      v11d8 = 0;
      rst = OK;
    }
  else
    rst = ERROR;

  DBG (2, "- RT_OP_SET_PARAMETER: %i\n", rst);

  return rst;
}

static SANE_Int
SetScanParams (SANE_Byte * Buffer, struct st_scanparams *myscan,
	       struct st_hwdconfig *hwdcfg)
{
  struct st_coords mycoords;
  SANE_Int mycolormode;
  SANE_Int myvalue;
  SANE_Int myresult;
  SANE_Int mymode;
  SANE_Int myresolution;
  SANE_Int channel_size;
  SANE_Int channel_count;

  DBG (2, "+ SetScanParams:\n");
  show_ScanParams (myscan);
  show_ScanLowLevelConfig (hwdcfg);

  bzero (&mycoords, sizeof (struct st_coords));
  /* Copy myscan to scan2 */
  memcpy (&scan2, myscan, sizeof (struct st_scanparams));

  mycolormode = myscan->colormode;
  myvalue = myscan->colormode;
  scantype = hwdcfg->scantype;

  if (myscan->colormode == CM_LINEART)
    scan2.depth = 8;

  if ((myscan->colormode != CM_COLOR) && (myscan->channel == 3))	/*channel = 0x00 */
    {
      if (myscan->colormode == CM_GRAY)
	{
	  mycolormode = (hwdcfg->arrangeline != FIX_BY_SOFT) ? 3 : CM_COLOR;
	}
      else
	mycolormode = 3;
      myvalue = mycolormode;
    }

  myresult = SetupScanMode (myvalue, myscan->resolution_x);	/*0x0b */
  if (myresult != ERROR)
    myresult = 0;

  imageresx = myscan->resolution_x;
  imageresy = myscan->resolution_y;
  scan2.resolution_x = myscan->resolution_x;
  scan2.resolution_y = myscan->resolution_y;

  /* if SetupScanMode is ok... */
  if (myresult != ERROR)
    {
      /* Supported resolution */
      Resize.type = 0;
      scan2.resolution_x = myscan->resolution_x;
      scan2.resolution_y = myscan->resolution_y;
      mycoords.left = myscan->coord.left;
      mycoords.top = myscan->coord.top;
      mycoords.width = myscan->coord.width;
      mycoords.height = myscan->coord.height;
    }
  else
    {
      /* Non supported resolution. We will resize image after scanning */
      SANE_Int myst, mycm, mymd, brk;

      Resize.type = 1;

      imageresx = myscan->resolution_x;
      imageresy = myscan->resolution_y;

      if ((hwdcfg->scantype >= ST_NORMAL) && (hwdcfg->scantype <= ST_NEG))
	myst = hwdcfg->scantype - 1;
      else
	myst = ST_NORMAL - 1;

      if ((mycolormode >= CM_GRAY) && (mycolormode <= 3))
	mycm = mycolormode - 1;
      else
	mycm = 3 - 1;

      mymd = scandata[myst].color[mycm].count - 1;
      brk = 0;
      while ((mymd >= 0) && (brk == 0))
	{
	  if (scan2.resolution_x < scandata[myst].color[mycm].mode[mymd])
	    {
	      /* Adjust scanning resolution */
	      scan2.resolution_x = scandata[myst].color[mycm].mode[mymd];
	      scan2.resolution_y = scandata[myst].color[mycm].mode[mymd];
	      brk++;
	    }
	  else
	    mymd--;
	}

      if (mymd < 0)
	{
	  /* Set scanning resolution to the lowest value */
	  Resize.type = 2;
	  if (scandata[myst].color[mycm].count > 0)
	    {
	      scan2.resolution_x =
		scandata[myst].color[mycm].mode[scandata[myst].color[mycm].
						count - 1];
	      scan2.resolution_y =
		scandata[myst].color[mycm].mode[scandata[myst].color[mycm].
						count - 1];
	    }
	  else
	    {
	      scan2.resolution_x = 100;
	      scan2.resolution_y = 100;
	    }
	}
    }

  mymode = SetupScanMode (myvalue, scan2.resolution_x);
  if (mymode == ERROR)
    return ERROR;

  scan_samplerate = scanmodeparams[mymode].samplerate;
  myscan->timing = scanmodeparams[mymode].timing;

  scan2.sensorresolution = scantiming[myscan->timing].sensorresolution;
  if ((scantype > 0) && (scantype < 5))
    scan2.shadinglength =
      (((scan2.sensorresolution * 17) / 2) + 3) & 0xfffffffc;

  myscan->sensorresolution = scan2.sensorresolution;
  myscan->shadinglength = scan2.shadinglength;

  if (myresult != 0)
    {
      imageheight = myscan->coord.height;
      Resize.towidth = myscan->coord.width;
      imageheight2 = myscan->coord.height;

      mycoords.left = (scan2.resolution_x * myscan->coord.left) / imageresx;
      mycoords.width = (scan2.resolution_x * myscan->coord.width) / imageresx;
      mycoords.top = (scan2.resolution_y * myscan->coord.top) / imageresy;
      mycoords.height =
	((scan2.resolution_y * myscan->coord.height) / imageresy) + 2;

      switch (scan2.colormode)
	{
	case CM_GRAY:
	  if ((scan_samplerate == FALSE) && (mycolormode != 3))
	    Resize.towidth *= 2;

	  channel_size = (scan2.depth == 8) ? 1 : 2;
	  Resize.mode = (scan2.depth == 8) ? RSZ_GRAYL : RSZ_GRAYH;
	  Resize.bytesperline = Resize.towidth * channel_size;
	  break;
	case CM_LINEART:
	  if (scan_samplerate == FALSE)
	    Resize.towidth *= 2;

	  Resize.mode = RSZ_LINEART;
	  Resize.bytesperline = (Resize.towidth + 7) / 8;
	  break;
	default:		/*CM_COLOR */
	  channel_count = 3;
	  channel_size = (scan2.depth == 8) ? 1 : 2;
	  Resize.mode = (scan2.depth == 8) ? RSZ_COLOURL : RSZ_COLOURH;
	  Resize.bytesperline =
	    myscan->coord.width * (channel_count * channel_size);
	  break;
	}
    }

  if ((mycolormode != CM_LINEART) && (scan2.depth <= 8))
    use_compresion = hwdcfg->compression;
  else
    use_compresion = FALSE;

  v15f4 = 0;

  if ((arrangeline2 == FIX_BY_HARD) || (mycolormode == CM_LINEART))
    arrangeline2 = mycolormode;
  else if ((mycolormode == CM_GRAY) && (hwdcfg->highresolution == FALSE))
    arrangeline2 = 0;

  if (hwdcfg->highresolution == FALSE)
    {
      /* resolution < 1200 dpi */
      use_hightresolution = FALSE;
      use_sensorevenodddist = 0x00;
    }
  else
    {
      /* resolution > 1200 dpi */
      use_hightresolution = TRUE;
      use_sensorevenodddist = hwdcfg->sensorevenodddistance;
    }

  v1594 = 0;
  if (mycolormode != CM_LINEART)
    {
      if ((scan2.resolution_x > 2400) && (myscan->samplerate == FALSE))
	myvalue = 8;
      else
	myvalue = 4;

      /* Ajustar ancho */
      if ((mycoords.width % myvalue) != 0)
	{
	  v1594 = myvalue - (mycoords.width % myvalue);
	  mycoords.width += v1594;
	}
    }
  else
    {
      /* Lineart */
      myvalue = 32 - (mycoords.width & 0x1f);
      if (myvalue < 32)
	{
	  mycoords.width += myvalue;
	  v1594 = (myvalue / 8);
	}
    }

  if (mycolormode == CM_LINEART)
    {
      bytesperline =
	(scan_samplerate == FALSE) ? mycoords.width / 4 : mycoords.width / 8;
      imagewidth3 = bytesperline;
      lineart_width = bytesperline * 8;
      v158c = bytesperline - v1594;
      Resize.fromwidth = v158c * 8;
    }
  else
    {
      /*4510 */
      switch (mycolormode)
	{
	case CM_COLOR:
	  channel_count = 3;
	  break;
	case 3:
	  channel_count = 1;
	  break;
	case CM_GRAY:
	  channel_count = (scan_samplerate == FALSE) ? 2 : 1;	/*1 */
	  break;
	}

      channel_size = (scan2.depth == 8) ? 1 : 2;
      v1594 *= (channel_count * channel_size);
      bytesperline = mycoords.width * (channel_count * channel_size);
      imagewidth3 = bytesperline / channel_count;
      lineart_width = imagewidth3 / channel_size;
      v158c = bytesperline - v1594;
      Resize.fromwidth = v158c / (channel_count * channel_size);
    }

  imagesize = mycoords.height * bytesperline;
  v15b4 = 0;
  v15b8 = imagesize;
  v15bc = 0;
  dimageheight = mycoords.height;
  v15ac = 0;

  myresolution = (myscan->sensorresolution / myscan->resolution_x) & 0x1f;
  Data_BitSet (myresolution, &Buffer[0xc0], 5);

  myscan->coord.left = mycoords.left;
  myscan->coord.top = mycoords.top;
  myscan->coord.width = mycoords.width;
  myscan->coord.height = mycoords.height;
  myscan->resolution_x = scan2.resolution_x;
  myscan->resolution_y = scan2.resolution_y;

  myvalue = (myresult == 0) ? v158c : Resize.bytesperline;
  myscan->bytesperline = bytesperline;

  myscan->v157c = myvalue;

  if (scan.colormode != CM_COLOR)
    {
      if (mycolormode == CM_COLOR)
	myscan->v157c = (myscan->v157c / 3);
    }

  if (scan.colormode == CM_LINEART)
    {
      if (mycolormode == 3)
	{
	  myscan->v157c = (myscan->v157c + 7) / 8;
	  myscan->bytesperline = (myscan->bytesperline + 7) / 8;
	}
    }

  DBG (2, "- SetScanParams:\n");

  return OK;
}

static SANE_Int
GainOffset_SetCount (SANE_Byte data)
{
  DBG (2, "> GainOffset_SetCount(data=%i):\n", data);

  if (data > 0x0f)
    data = 0x0f;

  return IWrite_Byte (0x0077, data, 0x200, 0x200);
}

static SANE_Int
GainOffset_IncCount (SANE_Int * arg1)
{
  SANE_Byte count;
  SANE_Int rst;

  DBG (2, "+ GainOffset_IncCount:\n");

  count = GainOffset_GetCount ();
  if ((count >= 0x0f) || (GainOffset_Get () != OK))
    {
      offset_blue = 0;
      offset_green = 0;
      offset_red = 0;
      gain_blue = 0;
      gain_green = 0;
      gain_red = 0;
      count = 0;
    }
  else
    {
      count++;
      if (arg1 != NULL)
	*arg1 = 1;
    }

  rst = GainOffset_SetCount (count);

  DBG (2, "- GainOffset_IncCount: %i\n", rst);

  return rst;
}

static SANE_Int
GainOffset_Get ()
{
  SANE_Int data, rst, myrst;
  SANE_Byte data2;

  DBG (2, "+ GainOffset_Get:\n");

  data2 = 0;
  rst = ERROR;
  myrst = IRead_Word (0x70, &data, 0x200);

  if (myrst == OK)
    {
      offset_red = data & 0xffff;
      myrst = IRead_Word (0x72, &data, 0x200);
      if (myrst == OK)
	{
	  offset_green = data & 0xffff;
	  myrst = IRead_Word (0x74, &data, 0x200);
	  if (myrst == OK)
	    {
	      offset_blue = data & 0xffff;
	      myrst = IRead_Byte (0x76, &data2, 0x200);
	    }
	}
    }
  data2 = _B0 (data2 + offset_green + offset_blue + offset_red);

  if ((myrst == OK) && (data2 == 0x5b))
    {
      gain_red = (offset_red >> 9) & 0x1f;
      gain_green = (offset_green >> 9) & 0x1f;
      gain_blue = (offset_blue >> 9) & 0x1f;
      offset_green &= 0x01ff;
      offset_blue &= 0x01ff;
      offset_red &= 0x01ff;
      rst = OK;
    }
  else
    {
      offset_blue = 0;
      offset_green = 0;
      offset_red = 0;
      gain_blue = 0;
      gain_green = 0;
      gain_red = 0;
    }

  DBG (2,
       "->   Preview gainR=%i, gainG=%i, gainB=%i, offsetR=%i, offsetG=%i, offsetB=%i\n",
       gain_red, gain_green, gain_blue, offset_red, offset_green,
       offset_blue);

  DBG (2, "- GainOffset_Get: %i\n", rst);

  return rst;
}

static SANE_Int
SetupScanMode (SANE_Int colormode, SANE_Int resolution)
{
  SANE_Int rst = -1;
  struct st_scandata *myscanmode;

  DBG (2, "+ SetupScanMode(colormode=%i, resolution=%i):\n", colormode,
       resolution);

  if (colormode == CM_GRAY)
    myscanmode = &scandata[scantype - 1].color[ICM_GRAY];
  else if (colormode == CM_LINEART)
    myscanmode = &scandata[scantype - 1].color[ICM_LINEART];
  else if ((colormode == CM_COLOR) || (colormode == 3))
    myscanmode = &scandata[scantype - 1].color[ICM_COLOR];
  else
    myscanmode = &scandata[IST_NEG].color[ICM_COLOR];

  if (myscanmode != NULL)
    {
      if (myscanmode->count > 0)
	{
	  SANE_Byte brk = 0;
	  SANE_Int scanmode = 0;

	  do
	    {
	      if (resolution == myscanmode->mode[scanmode])
		brk++;
	      else
		scanmode++;
	    }
	  while ((scanmode < myscanmode->count) && (brk == 0));

	  if (brk != 0)
	    {
	      rst = _B0 (myscanmode->totalcount + scanmode);	/* mode */
	      LoadScanModeParams (colormode, scantype, _B0 (scanmode), rst);
	      Timing_Load (scanmodeparams[rst].timing);
	    }
	}
    }

  DBG (2, "- SetupScanMode: %i\n", rst);

  return rst;
}

static SANE_Int
Timing_Load (SANE_Int timing)
{
  SANE_Int rst;

  DBG (2, "> Timing_Load(timing=%i)\n", timing);

  rst = ERROR;
  if ((timing < timingcount) && (timing > -1))
    {
      SANE_Int timing_file = timingfile + timing;

      if (scantiming == NULL)
	scantiming =
	  (struct st_timing *) malloc (sizeof (struct st_timing) *
				       timingcount);

      if (scantiming != NULL)
	{
	  SANE_Int a, opt;
	  struct st_timing *st = &scantiming[timing];

	  if (st != NULL)
	    {
	      st->sensorresolution =
		get_value (TIMING, SENSORRESOLUTION, 0, timing_file);
	      st->cnpp = get_value (TIMING, CNPP, 5, timing_file);
	      st->cdss1 = get_value (TIMING, CDSS1, 0, timing_file);
	      st->cdsc1 = get_value (TIMING, CDSC1, 0, timing_file);
	      st->cdss2 = get_value (TIMING, CDSS2, 0, timing_file);
	      st->cdsc2 = get_value (TIMING, CDSC2, 0, timing_file);

	      st->cvtrp[0] = get_value (TIMING, CVTRP1, 0xff, timing_file);
	      st->cvtrp[1] = get_value (TIMING, CVTRP2, 0xff, timing_file);
	      st->cvtrp[2] = get_value (TIMING, CVTRP3, 0xff, timing_file);

	      st->cvtrw = get_value (TIMING, CVTRW, 0xff, timing_file);
	      st->cvtrbpw = get_value (TIMING, CVTRBPW, 0xff, timing_file);
	      st->cvtrfpw = get_value (TIMING, CVTRFPW, 0xff, timing_file);
	      st->clamps = get_value (TIMING, CLAMPS, 0, timing_file);
	      st->clampe = get_value (TIMING, CLAMPE, 0, timing_file);
	      st->adcclkp[0] =
		get_lvalue (TIMING, ADCCLKP1, 0xf83e0f80, timing_file);
	      st->adcclkp[1] = get_lvalue (TIMING, ADCCLKP2, 0, timing_file);
	      st->adcclkp2e = get_value (TIMING, ADCCLKP2E, 0, timing_file);

	      /*Load cph structures */
	      for (a = 0; a < 6; a++)
		{
		  opt = CPH0P1 + (a * 5);

		  st->cph[a].p1 = get_lvalue (TIMING, opt, 0, timing_file);
		  st->cph[a].p2 =
		    get_lvalue (TIMING, opt + 1, 0, timing_file);
		  st->cph[a].ps = get_value (TIMING, opt + 2, 0, timing_file);
		  st->cph[a].ge = get_value (TIMING, opt + 3, 0, timing_file);
		  st->cph[a].go = get_value (TIMING, opt + 4, 0, timing_file);
		}

	      rst = OK;
	    }
	}
    }

  return rst;
}

static void
Motor_FreeConfig ()
{
  DBG (2, "> Motor_FreeConfig():\n");

  if (motormove != NULL)
    {
      free (motormove);
      motormove = NULL;
    }
}

static SANE_Int
Motor_LoadConfig (SANE_Int inifile)
{
  SANE_Int a, b, buffer;

  DBG (2, "> Motor_LoadConfig(inifile=%i):\n", inifile);

  b = 0;
  motormovecount = get_value (PLATFORM, MOTORMOVECOUNT, 0, inifile);
  buffer = MOTORMOVE1;
  for (a = 0; a < motormovecount; a++)
    {
      if (motormove == NULL)
	motormove =
	  (struct stmotormove *) malloc (sizeof (struct stmotormove));
      else
	motormove =
	  (struct stmotormove *) realloc (motormove,
					  sizeof (struct stmotormove) * (a +
									 1));

      if (motormove != NULL)
	{
	  b++;
	  bzero (&motormove[a], sizeof (struct stmotormove));
	  motormove[a].systemclock =
	    get_value (buffer, SYSTEMCLOCK, 0, inifile);
	  motormove[a].scanmotorsteptype =
	    get_value (buffer, SCANMOTORSTEPTYPE, 0, inifile);
	  motormove[a].motorcurve =
	    get_value (buffer, MOTORCURVE, 0, inifile);
	  motormove[a].ctpc = get_value (buffer, CTPC, 0, inifile);

	  if (motormove[a].motorcurve > 0)
	    {
	      motormove[a].has_curves = TRUE;
	      motormove[a].motorcurve--;
	    }
	  else
	    motormove[a].has_curves = FALSE;
	  buffer++;
	}
      else
	b = 0;
    }

  motormovecount = b;

  return OK;
}

static SANE_Int
LoadScanningConfig (SANE_Int inifile)
{
  SANE_Int a, section[3] = { FLB_FIND_EDGE, TA_FIND_EDGE, TA_NEG_FIND_EDGE };

  DBG (2, "> LoadScanningConfig(inifile=%i):\n", inifile);

  for (a = 0; a < 3; a++)
    {
      findedge[a].exposuretime =
	get_value (section[a], EXPOSURETIME, 0x1b58, inifile);
      findedge[a].scanystart =
	get_value (section[a], SCANYSTART, 0x0a, inifile);
      findedge[a].scanylines =
	get_value (section[a], SCANYLINES, 0x37, inifile);
      findedge[a].findlermethod =
	get_value (section[a], FINDLERMETHOD, 1, inifile);
      findedge[a].findlerstart =
	get_value (section[a], FINDLERSTART, 0x12c0, inifile);
      findedge[a].findlerend =
	get_value (section[a], FINDLEREND, 0x1518, inifile);
      findedge[a].checkoffsetser =
	get_value (section[a], CHECKOFFSETSER, 0xfffffff1, inifile);
      findedge[a].findserchecklines =
	get_value (section[a], FINDSERCHECKLINES, 0x0f, inifile);
      findedge[a].findserstart =
	get_value (section[a], FINDSERSTART, 0, inifile);
      findedge[a].findserend =
	get_value (section[a], FINDSEREND, 0x4b0, inifile);
      findedge[a].findsermethod =
	get_value (section[a], FINDSERMETHOD, 0, inifile);
      findedge[a].offsettoser =
	get_value (section[a], OFFSETTOSER, 0, inifile);
      findedge[a].offsettoler =
	get_value (section[a], OFFSETTOLER, 0x82, inifile);
    }

  return OK;
}

static char
IsScannerLinked ()
{
  SANE_Int var2;
  SANE_Byte BL;

  DBG (2, "+ IsScannerLinked:\n");

  Read_FE3E (&v1619);
  Init_USBData ();
  scan.scantype = ST_NORMAL;
  v07d0 = 1;
  WaitForScanner (0x30000);

  BL = 0;

  /* Comprobar si es la primera conexin con el escaner */
  if (Read_Word (0xe829, &var2) == OK)
    {
#ifdef STANDALONE
      firstconnection = TRUE;
#else
      firstconnection = (var2 == 0) ? TRUE : FALSE;
#endif

      if (firstconnection == TRUE)
	{
	  /* primera conexin */
	  SANE_Byte flb_lamp, tma_lamp;

	  flb_lamp = 0;
	  tma_lamp = 0;
	  Lamp_GetStatus (&flb_lamp, &tma_lamp);

	  if (flb_lamp == 0)
	    {
	      /* if tma_lamp is turned on, bl = 1 else bl = 0 */
	      if (tma_lamp != 0)
		BL = 1;
	    }

	  /*Clear GainOffset count */
	  GainOffset_Clear ();
	  GainOffset_SetCount (0);

	  /* Clear AutoRef count */
	  AutoRef_SetCount (0);

	  Buttons_Enable ();
	  Lamp_SetTimer (13);
	}
      else
	BL = _B0 (var2);
    }

  if (E800_FLIP_FLOP () != OK)
    return ERROR;

  v0748 = Motor_ParkHome (2, parkhomemotormove);
  v084e = 4;

  Lamp_SetTimer (13);

  /* Use fixed pwm? */
  usefixedpwm = get_value (PLATFORM, USEFIXEDPWM, 1, FITCALIBRATE);
  if (usefixedpwm != FALSE)
    {
      FixedPWM_Set (FixedPWM_Get (ST_NORMAL));
      /* Lets enable using fixed pwm */
      FixedPWM_Use (TRUE);
    }

  Lamp_SetupPwm ((BL == 0) ? FLB_LAMP : TMA_LAMP);

  LoadCheckStable (&check_preview, 0);
  LoadCheckStable (&check_flb, 1);
  LoadCheckStable (&check_tma, 2);

  DBG (2, "- IsScannerLinked:\n");

  return OK;
}

static SANE_Int
LoadCheckStable (struct st_checkstable *buffer, SANE_Int mycheck)
{
  double data;

  DBG (2, "> LoadCheckStable(*buffer, mycheck=%i):\n", mycheck);

  switch (_B0 (mycheck))
    {
    case 0:
      data = get_value (CHECKSTABLE, PREVIEW_DIFF, 0x1f4, FITCALIBRATE);
      buffer->diff = data * 0.01;
      buffer->interval =
	get_value (CHECKSTABLE, PREVIEW_INTERVAL, 0x1f4, FITCALIBRATE);
      buffer->tottime =
	get_value (CHECKSTABLE, PREVIEW_TOTTIME, 0x1388, FITCALIBRATE);
      break;
    case 1:
      data = get_value (CHECKSTABLE, FLB_DIFF, 0x1f4, FITCALIBRATE);
      buffer->diff = data * 0.01;
      buffer->interval =
	get_value (CHECKSTABLE, FLB_INTERVAL, 0x1f4, FITCALIBRATE);
      buffer->tottime =
	get_value (CHECKSTABLE, FLB_TOTTIME, 0x2710, FITCALIBRATE);
      break;
    case 2:
      data = get_value (CHECKSTABLE, TMA_DIFF, 0x3e8, FITCALIBRATE);
      buffer->diff = data * 0.01;
      buffer->interval =
	get_value (CHECKSTABLE, TMA_INTERVAL, 0x1f4, FITCALIBRATE);
      buffer->tottime =
	get_value (CHECKSTABLE, TMA_TOTTIME, 0x1388, FITCALIBRATE);
      break;
    }

  return OK;
}


static SANE_Int
FixedPWM_Use (SANE_Byte enable)
{
  SANE_Byte mypwm;
  SANE_Int rst;

  DBG (2, "+ FixedPWM_Use(enable=%i):\n", enable);

  rst = ERROR;

  if (IRead_Byte (0x007b, &mypwm, 0x200) == OK)
    {
      mypwm = (enable == FALSE) ? mypwm & 0x7f : mypwm | 0x80;

      if (IWrite_Byte (0x007b, mypwm, 0x200, 0x200) == OK)
	rst = OK;
    }

  DBG (2, "- FixedPWM_Use: %i\n", rst);

  return rst;
}

static SANE_Int
FixedPWM_Set (SANE_Int fixedpwm)
{
  SANE_Int rst;

  DBG (2, "+ FixedPWM_Set(fixedpwm=%i):\n", fixedpwm);

  if (IWrite_Byte (0x007b, ((fixedpwm << 0x02) | 0x80), 0x200, 0x200) != 0x00)
    rst = ERROR;
  else
    rst = OK;

  DBG (2, "- FixedPWM_Set: %i\n", rst);

  return rst;
}

static SANE_Int
FixedPWM_Get (SANE_Byte type)
{
  char sdebug[20];

  if (type == ST_NORMAL)
    strcpy (sdebug, "type=ST_NORMAL):\n");
  else if (type == ST_TA)
    strcpy (sdebug, "type=ST_TA):\n");
  else
    strcpy (sdebug, "type=ST_NEG):\n");
  DBG (2, "> FixedPWM_Get(%s", sdebug);

  if (ccdtype == SONY)
    {
      /* Sony CCD */
      if (usbtype == USB11)
	{
	  /* usb 1.1 */
	  switch (type)
	    {
	    case ST_NORMAL:
	      return get_value (PLATFORM, S_USB1FIXEDPWM, 0x16, FITCALIBRATE);
	    case ST_TA:
	      return get_value (PLATFORM, S_USB1FIXEDPWM_TA, 0x16,
				FITCALIBRATE);
	    case ST_NEG:
	      return get_value (PLATFORM, S_USB1FIXEDPWM_NEG, 0x16,
				FITCALIBRATE);
	    }
	}
      else
	{
	  /* usb 2.0 */
	  switch (type)
	    {
	    case ST_NORMAL:
	      return get_value (PLATFORM, S_USB2FIXEDPWM, 0x16, FITCALIBRATE);
	    case ST_TA:
	      return get_value (PLATFORM, S_USB2FIXEDPWM_TA, 0x16,
				FITCALIBRATE);
	    case ST_NEG:
	      return get_value (PLATFORM, S_USB2FIXEDPWM_NEG, 0x16,
				FITCALIBRATE);
	    }
	}
    }
  else
    {
      /* Toshiba CCD */
      if (usbtype == USB11)
	{
	  /* usb 1.1 */
	  switch (type)
	    {
	    case ST_NORMAL:
	      return get_value (PLATFORM, T_USB1FIXEDPWM, 0x16, FITCALIBRATE);
	    case ST_TA:
	      return get_value (PLATFORM, T_USB1FIXEDPWM_TA, 0x16,
				FITCALIBRATE);
	    case ST_NEG:
	      return get_value (PLATFORM, T_USB1FIXEDPWM_NEG, 0x16,
				FITCALIBRATE);
	    }
	}
      else
	{
	  /* usb 2.0 */
	  switch (type)
	    {
	    case ST_NORMAL:
	      return get_value (PLATFORM, T_USB2FIXEDPWM, 0x16, FITCALIBRATE);
	    case ST_TA:
	      return get_value (PLATFORM, T_USB2FIXEDPWM_TA, 0x16,
				FITCALIBRATE);
	    case ST_NEG:
	      return get_value (PLATFORM, T_USB2FIXEDPWM_NEG, 0x16,
				FITCALIBRATE);
	    }
	}
    }

  return type;
}

static SANE_Int
Set_LER_SER (SANE_Int resolution)
{
  switch (resolution)
    {
    case 100:
      scan.ser = get_value (SCAN_PARAM, SER_100, 0, usbfile);
      scan.ler = get_value (SCAN_PARAM, LER_100, 0, usbfile);
      break;
    case 300:
      scan.ser = get_value (SCAN_PARAM, SER_300, 0, usbfile);
      scan.ler = get_value (SCAN_PARAM, LER_300, 0, usbfile);
      break;
    case 600:
      scan.ser = get_value (SCAN_PARAM, SER_600, 0, usbfile);
      scan.ler = get_value (SCAN_PARAM, LER_600, 0, usbfile);
      break;
    case 1200:
      scan.ser = get_value (SCAN_PARAM, SER_1200, 0, usbfile);
      scan.ler = get_value (SCAN_PARAM, LER_1200, 0, usbfile);
      break;
    case 2400:
      scan.ser = get_value (SCAN_PARAM, SER_2400, 0, usbfile);
      scan.ler = get_value (SCAN_PARAM, LER_2400, 0, usbfile);
      break;
    default:
      scan.ser = get_value (SCAN_PARAM, SER_200, 0, usbfile);
      scan.ler = get_value (SCAN_PARAM, LER_200, 0, usbfile);
      break;
    }
  scan.ser &= 0xffff;
  scan.ler &= 0xffff;
  scan.leftleading = scan.ser;

  DBG (2, "> Set_LER_SER(resolution=%i): LER=%i SER=%i\n", resolution,
       scan.ler, scan.ser);

  return OK;
}

static SANE_Int
Lamp_SetupPwm (SANE_Int lamp)
{
  SANE_Int data, rst, fixedpwm;
  char sdebug[20];

  if (lamp == FLB_LAMP)
    strcpy (sdebug, "lamp=FLB_LAMP):\n");
  else
    strcpy (sdebug, "lamp=TMA_LAMP):\n");
  DBG (2, "+ Lamp_SetupPwm(%s", sdebug);

  data = 0;
  rst = OK;
  fixedpwm = FixedPWM_Get (lamp);

  if (SetPwmLampMode (1) == OK)
    {
      if (PWM_GetDutyCycle (&data) == OK)
	{
	  if (data != fixedpwm)
	    rst = PWM_SetDutyCycle (fixedpwm);
	}
      else
	rst = PWM_SetDutyCycle (fixedpwm);
    }

  DBG (2, "- Lamp_SetupPwm: %i\n", rst);

  return rst;
}

static SANE_Int
PWM_GetDutyCycle (SANE_Int * data)
{
  SANE_Byte a;
  SANE_Int rst = ERROR;

  DBG (2, "+ PWM_GetDutyCycle:\n");

  if (Read_Byte (0xe948, &a) == OK)
    {
      *data = a & 0x3f;
      rst = OK;
    }

  DBG (2, "- PWM_GetDutyCycle = %i: %i\n", *data, rst);

  return rst;
}

static SANE_Int
PWM_SetDutyCycle (SANE_Int duty_cycle)
{
  SANE_Byte Regs[0x71a];
  SANE_Int rst;

  DBG (2, "+ PWM_SetDutyCycle(duty_cycle=%i):\n", duty_cycle);

  rst = ERROR;

  if (RTS_ReadRegs (Regs) == OK)
    {
      Data_BitSet (duty_cycle, &Regs[0x148], 6);
      if (pwmlamplevel == 0)
	{
	  Regs[0x148] &= 0xbf;		     /*-0------*/
	  Regs[0x148] |= (duty_cycle & 0x40);
	  Regs[0x1e0] |= ((duty_cycle >> 1) & 0x40);
	}

      BGeneral[0x148] &= 0x80;
      BGeneral[0x148] |= (Regs[0x148] & 0x7f);
      BGeneral[0x1e0] &= 0xc0;
      BGeneral[0x1e0] |= (Regs[0x1e0] & 0x3f);

      Write_Byte (0xe948, Regs[0x0148]);

      rst = Write_Byte (0xe9e0, Regs[0x01e0]);
    }

  DBG (2, "- PWM_SetDutyCycle: %i\n", rst);

  return rst;
}

static SANE_Int
Motor_ParkHome (SANE_Int bWait, SANE_Int park)
{
  SANE_Byte Regs[0x71a];
  SANE_Int a;

  DBG (2, "+ Motor_ParkHome(bWait=%i, park=%i):\n", bWait, park);

  memcpy (&Regs, BGeneral, 0x71a * sizeof (SANE_Byte));

  /* Lets wait if it's required when is already executing */
  if (bWait > 0)
    {
      if (WaitEndingAction (0x3a98) != 0)
	{
	  DBG (2, "- Motor_ParkHome: WaitEndingAction Timeout\n");

	  return ERROR;		/* Si timeout */
	}
    }
  else
    {
      if (RTS_IsExecuting (Regs) == FALSE)
	{
	  DBG (2,
	       "- Motor_ParkHome: RTS_IsExecuting = 0, exiting function\n");

	  return ERROR;		/* if NOT executing */
	}
    }

  /* Check if lamp is at home */
  if (Lamp_IsAtHome (Regs) == FALSE)
    {
      struct stmotormove mymotor;

      DBG (2, "->   Motor_ParkHome: Lamp is not at home, lets move\n");

      /* it isn't */
      park--;
      if (_B0 (park) < motormovecount)
	{
	  if (motormove[park].motorcurve > 0)
	    {
	      memcpy (&mymotor, &motormove[park],
		      sizeof (struct stmotormove));
	      mymotor.v12e435 = 0;
	      mymotor.coord_y = 0;
	      mymotor.v12e448 = 0;
	      mymotor.v12e44c = 0;
	    }
	  else
	    {
	      mymotor.has_curves = FALSE;
	      if (motormove[park].scanmotorsteptype < 0x04)
		mymotor.scanmotorsteptype = motormove[park].scanmotorsteptype;
	      mymotor.ctpc = motormove[park].ctpc;
	      mymotor.systemclock = motormove[park].systemclock;
	    }
	}
      else
	{
	  mymotor.has_curves = FALSE;
	  if (default_calib_table.edcg2[2] < 4)
	    mymotor.scanmotorsteptype = default_calib_table.edcg2[2];

	  mymotor.ctpc = default_calib_table.odcg2[1];
	  mymotor.systemclock = default_calib_table.edcg2[1];
	}

      mymotor.v12e435 = 0x00;
      mymotor.v12e448 = 0x01;
      mymotor.v12e44c = 0x00;
      mymotor.coord_y = 0x4e20;
      Lamp_ParkHome (Regs, &mymotor);

      /* We must wait? */
      if (bWait == 1)
	{
	  /* Yes, we must wait */
	  a = WaitEndingAction (15000);
	  if (a == 0)
	    return 0x0d;
	  else
	    return a;
	}
      else
	{
	  /* No, return executing status */
	  if (RTS_IsExecuting (Regs) == TRUE)
	    return 0x0c;
	  else
	    return 0x0d;
	}
    }
  else
    return 0x0d;
}

static SANE_Int
Lamp_ParkHome (SANE_Byte * Regs, struct stmotormove *mymotor)
{
  SANE_Byte cpRegs[0x71a];
  SANE_Int data, v12dcf8, coord_y, rst;

  DBG (2, "+ Lamp_ParkHome:\n");
  show_MotorMove (mymotor);

  v12dcf8 = 0;
  memcpy (&cpRegs, Regs, 0x71a * sizeof (SANE_Byte));

  /* resolution = 1 dpi */
  cpRegs[0xc0] = (cpRegs[0xc0] & 0xe1) | 0x01;
  cpRegs[0xdd] |= 0x40;

  data = _B0 (mymotor->v12e435 | mymotor->scanmotorsteptype);
  cpRegs[0xdd] = _B0 (((data & 0xf0) << 3) | (cpRegs[0xdd] & 0x7f));

  cpRegs[0xd9] = _B0 (data << 0x04);

  data =
    (mymotor->scanmotorsteptype <
     4) ? 1 << mymotor->scanmotorsteptype : v12dcf8;

  coord_y = (mymotor->coord_y * data) & 0xffff;
  if (coord_y < 2)
    coord_y = 2;

  /* Sets dummyline = 0 and unknown data */
  cpRegs[0xd6] &= 0x0f;		/*0000---- */
  cpRegs[0xd6] |= 0x10;	      /*---1----*/

  cpRegs[0xe0] = 0;

  cpRegs[0x01] &= 0xf9;
  cpRegs[0x01] |= ((mymotor->v12e448 & 1) | 0x04) << 2;

  cpRegs[0x1cf] &= 0x3f;
  cpRegs[0x1cf] |= 0x80;	/*10------ */

  Data_Set (2, &cpRegs[0xe4], 3);

  cpRegs[0x12] = (v163c & 3) | 0x40;

  /* timing cnpp */
  Data_BitSet (0x0b, &cpRegs[0x96], 6);	     /*--001011*/

  /* Set systemclock */
  Data_BitSet (mymotor->systemclock, &cpRegs[0x000], 4);

  Data_Set (0x10, &Regs[0xea], 3);
  Data_Set (0x10, &Regs[0xed], 3);
  Data_Set (0x10, &Regs[0xf0], 3);
  Data_Set (0x10, &Regs[0xf3], 3);

  cpRegs[0xda] = 2;
  cpRegs[0xdd] &= 0xfc;

  /* set if motor has motorcurves */
  cpRegs[0xdf] &= 0xef;
  cpRegs[0xdf] |= (mymotor->has_curves & 1) << 4;	/*---x----*/

  if (mymotor->has_curves != FALSE)
    {
      struct st_ccurve *mc;

      data =
	(motorsetting !=
	 NULL) ? motorsetting[mymotor->motorcurve].acccurvecount : 0;
      if (data == 0)
	Motor_LoadCurve (mymotor->motorcurve);

      /* set last acccurve step in 0xe8e1 */
      mc = &motorsetting[mymotor->motorcurve].acccurve[0];

      data = mc->step[mc->count - 1];
      Data_Set (data, &cpRegs[0xe1], 3);

      v12dcf8 = Motor_Setup (cpRegs, &motorsetting[mymotor->motorcurve]);

      cpRegs[0xe0] = 0;
      coord_y -=
	((motorsetting[mymotor->motorcurve].
	  deccurve[motorsetting[mymotor->motorcurve].dec.normalscan].count +
	  v12dcf8) & 0xffff);

      Data_Set (mymotor->ctpc, &cpRegs[0x30], 3);
      Data_Set (0, &cpRegs[0xe4], 3);
    }
  else
    {
      /* Setting some motor step */
      SANE_Int some_step;

      some_step = 0;
      if (Regs[0x00] < 0x0e)
	{
	  switch (Regs[0x00])
	    {
	    case 0x00:
	      some_step = 0x00895440;
	      break;
	    case 0x01:
	      some_step = 0x00b71b00;
	      break;
	    case 0x02:
	      some_step = 0x00112a88;
	      break;
	    case 0x03:
	      some_step = 0x016e3600;
	      break;
	    case 0x04:
	      some_step = 0x02255100;
	      break;
	    case 0x05:
	      some_step = 0x044aa200;
	      break;
	    case 0x06:
	      some_step = v12dcf8;
	      break;
	    case 0x07:
	      some_step = v12dcf8;
	      break;
	    case 0x08:
	      some_step = 0x00b71b00;
	      break;
	    case 0x09:
	      some_step = 0x00f42400;
	      break;
	    case 0x0a:
	      some_step = 0x016e3600;
	      break;
	    case 0x0b:
	      some_step = 0x01e84800;
	      break;
	    case 0x0c:
	      some_step = 0x02dc6c00;
	      break;
	    case 0x0d:
	      some_step = 0x05b8d800;
	      break;
	    }
	}
      else
	some_step = v12dcf8;

      some_step /= ((cpRegs[0x96] & 0x3f) + 1);
      if (mymotor->ctpc > 0)
	some_step /= mymotor->ctpc;

      Data_Set (some_step, &cpRegs[0x30], 3);
      Data_Set (some_step, &cpRegs[0xe1], 3);
    }

  /* Setting coords */
  RTS_SetCoords (cpRegs, 0x64, coord_y - 1, 0x384, coord_y);

  cpRegs[0xd8] |= 0x80;
  E8D9_Control ();
  E800_FLIP_FLOP ();

  data = RTS_WriteRegs (cpRegs);
  if (data == OK)
    RTS_Execute ();

  WaitEndingAction (0x2710);

  rst = (data != 0) ? v12dcf8 : WaitEndingAction (0x4e20);

  DBG (2, "- Lamp_ParkHome: %i\n", rst);

  return rst;
}


static SANE_Int
Motor_LoadCurve (SANE_Int pos)
{
  DBG (2, "> Motor_LoadCurve(pos=%i):\n", pos);

  if ((pos > -1) && (pos < motorcount))
    {
      SANE_Int motorcurve = MOTORCURVE1 + pos;

      if (motorsetting == NULL)
	{
	  /* Lets allocate memory for all motorcurves */
	  motorsetting =
	    (struct st_motorsetting *) malloc (sizeof (struct st_motorsetting)
					       * motorcount);

	  if (motorsetting != NULL)
	    bzero (motorsetting,
		   sizeof (struct st_motorsetting) * motorcount);
	}

      /* malloc could fail... */
      if (motorsetting != NULL)
	{
	  struct st_motorsetting *ms = &motorsetting[pos];
	  ms->acccurvecount =
	    get_value (MOTORSETTING, ACCCURVECOUNT, 0, motorcurve);
	  ms->deccurvecount =
	    get_value (MOTORSETTING, DECCURVECOUNT, 0, motorcurve);
	  ms->acc.normalscan = get_value (ACC, NORMALSCAN, 1, motorcurve) - 1;
	  ms->acc.smearing = get_value (ACC, SMEARING, 1, motorcurve) - 1;
	  ms->acc.parkhome = get_value (ACC, PARKHOME, 1, motorcurve) - 1;
	  ms->dec.scanbufferfull =
	    get_value (DEC, SCANBUFFERFULL, 1, motorcurve) - 1;
	  ms->dec.smearing = get_value (DEC, SMEARING, 1, motorcurve) - 1;
	  ms->dec.parkhome = get_value (DEC, PARKHOME, 1, motorcurve) - 1;
	  ms->dec.normalscan = get_value (DEC, NORMALSCAN, 1, motorcurve) - 1;
	  /* I don't see any assigments to these variables here
	     but exist in motorcurve files...
	   */
	  ms->mri = 0;
	  ms->msi = 0;
	  ms->skiplinecount = 0;
	  /* Allocate memory for all acc curves */
	  ms->acccurve =
	    (struct st_ccurve *) malloc (sizeof (struct st_ccurve) *
					 ms->acccurvecount);

	  if (ms->acccurve != NULL)
	    {
	      SANE_Int a, b;
	      SANE_Int section = ACCCURVE1;
	      struct st_ccurve *ac;

	      /* Load all acc curves for this motorcurve */
	      for (a = 1; a <= ms->acccurvecount; a++)
		{
		  ac = &ms->acccurve[a - 1];
		  ac->maxspeed = get_value (section, MAXSPEED, 0, motorcurve);
		  ac->minspeed = 0;
		  ac->count =
		    get_value (section, COUNT, 0, motorcurve) & 0xffffff;

		  /* Allocate memory for steps */
		  ac->step =
		    (SANE_Int *) malloc (sizeof (SANE_Int) * ac->count);
		  /* if it fails????... */
		  if (ac->step != NULL)
		    {
		      for (b = 1; b <= ac->count; b++)
			ac->step[b - 1] =
			  get_value (section, b, 0, motorcurve);
		    }
		  else
		    return 0x68;
		  section++;
		}

	      /* Allocate memory for all dec curves */
	      ms->deccurve =
		(struct st_ccurve *) malloc (sizeof (struct st_ccurve) *
					     ms->deccurvecount);
	      if (ms->deccurve != NULL)
		{
		  /* Load all dec curves for this motorcurve */
		  struct st_ccurve *dc;
		  section = DECCURVE1;
		  for (a = 1; a <= ms->deccurvecount; a++)
		    {
		      dc = &ms->deccurve[a - 1];
		      dc->maxspeed =
			get_value (section, MAXSPEED, 0, motorcurve);
		      dc->minspeed = 0;
		      dc->count =
			get_value (section, COUNT, 0, motorcurve) & 0xffffff;
		      /* Allocate memory for steps */
		      dc->step =
			(SANE_Int *) malloc (sizeof (SANE_Int) * dc->count);
		      /* if it fails????... */
		      if (dc->step != NULL)
			{
			  for (b = 1; b <= dc->count; b++)
			    dc->step[b - 1] =
			      get_value (section, b, 0, motorcurve);
			}
		      else
			return 0x66;
		      section++;
		    }
		  return OK;
		}
	    }
	}
    }
  /* Error... */
  return 0x66;
}

static SANE_Byte *
Motor_AddStep (SANE_Byte * steps, SANE_Int * bwriten, SANE_Int step)
{
  steps = (SANE_Byte *) realloc (steps, sizeof (SANE_Byte) * (*bwriten + 3));
  if (steps != NULL)
    {
      Data_SetBigEndian (step, &steps[*bwriten], 3);
      *bwriten += 3;
    }
  else
    *bwriten = 0;
  return steps;
}

static SANE_Int
Motor_Setup (SANE_Byte * Regs, struct st_motorsetting *mysetting)
{
  SANE_Int a, varx10, cont, varx1c, varx20, varx2b, varx2c, mystep, iValue,
    bwriten;
  SANE_Int myvar, var1, myvalor, var2, mybwriten;
  struct st_ccurve *mycurve;
  SANE_Byte usecurve, *steps;

  DBG (2, "+ Motor_Setup:\n");

  var2 = 0;
  varx10 = 0;
  cont = 0;
  varx1c = 0;
  varx20 = 0;
  varx2b = 0;
  varx2c = (v15f8 << 4) & 0xffff;
  mycurve = NULL;
  usecurve = 0;
  steps = NULL;
  bwriten = 0;

  if (motorsetting != NULL)
    {
      usecurve = mysetting->acc.normalscan;
      a = motorsetting[usecurve].acccurvecount;
    }
  else
    a = 0;

  if (a == 0)
    Motor_LoadCurve (usecurve);

  mycurve = &mysetting->acccurve[mysetting->acc.normalscan];
  acccurvecount = mycurve->count;

  /* get last acccurve step from chip */
  varx1c = Data_Get (&Regs[0xe1], 3);

  /* Next register has 14 bits size */
  Data_BitSet (varx2c, &Regs[0xf6], 14);

  /* Separate each step in three bytes */
  for (cont = 0; cont < mycurve->count; cont++)
    {
      mystep = mycurve->step[cont];
      if (mystep <= varx1c)
	{
	  acccurvecount = cont;
	  break;
	}
      varx20 += mystep + 1;
      steps = Motor_AddStep (steps, &bwriten, mystep);
    }

  if (acccurvecount == 0)
    {
      /* Write one step (varx1c + 0x01) to buffer */
      acccurvecount++;
      varx20 += (varx1c + 1) + 1;
      steps = Motor_AddStep (steps, &bwriten, varx1c + 1);
    }

  /* write another step (varx1c) */
  acccurvecount++;
  varx20 += varx1c + 1;
  steps = Motor_AddStep (steps, &bwriten, varx1c);

  myvar = Data_Get (&Regs[0x30], 3) + 1;
  var1 = (varx20 + myvar - 1) / myvar;
  var1 = ((var1 * myvar) + mycurve->step[0] - varx20) - 0x0d;
  if (steps != NULL)
    Data_SetBigEndian (var1, &steps[0], 3);

  /* Next register has 14 bits size */
  varx2c += (acccurvecount * 3);
  Data_BitSet (varx2c, &Regs[0xf8], 14);

  mycurve = &mysetting->deccurve[mysetting->dec.scanbufferfull];
  deccurvecount = mycurve->count;
  Data_Set (mycurve->step[mycurve->count - 1], &Regs[0xea], 3);
  /* write another step   mycurve->count,cont,varx1c */
  deccurvecount++;
  steps = Motor_AddStep (steps, &bwriten, varx1c);

  cont = 0;
  /* Separate each step in three bytes */
  for (cont = 0; cont < (mycurve->count - 1); cont++)
    {
      mystep = mycurve->step[cont];
      if (mystep > varx1c)
	steps = Motor_AddStep (steps, &bwriten, mystep);
      else
	deccurvecount--;
    }

  myvalor = mysetting->motorbackstep;
  if (myvalor > 0)
    {
      myvalor = ((myvalor - deccurvecount) - acccurvecount) + 2;
      varx10 = myvalor;
      myvalor /= _B0 (Regs[0xe0]) + 1;
      myvalor *= _B0 (Regs[0xe0]) + 1;
      var1 = mycurve->step[mycurve->count - 1];	/* last deccurve step */
      if (varx1c >= var1)
	var1 = varx1c + 1;
      deccurvecount += (varx10 - myvalor);
      myvalor = varx10 - myvalor;
    }
  else
    myvalor = varx10;

  if (myvalor > 0)
    for (cont = myvalor; cont > 0; cont--)
      steps = Motor_AddStep (steps, &bwriten, var1 - 1);

  /* write another step , bwriten tiene 4b */
  steps = Motor_AddStep (steps, &bwriten, var1);

  /* acc.smearing */
  if (mysetting->acc.smearing == mysetting->acc.normalscan)
    {
      /* Next register has 14 bits size */
      iValue = Data_Get (&Regs[0xf6], 2);
      Data_BitSet (iValue, &Regs[0xfa], 14);
      /* Get last acccurve step */
      mystep = Data_Get (&Regs[0xe1], 3);
      Data_Set (mystep, &Regs[0xe4], 3);
    }
  else
    {
      /* Next register has 14 bits size */
      var2 = varx2c + ((deccurvecount * 3) & 0xffff);
      Data_BitSet (var2, &Regs[0xfa], 14);

      mycurve = &mysetting->acccurve[mysetting->acc.smearing];
      smearacccurvecount = mycurve->count;
      Data_Set (mycurve->step[mycurve->count - 1], &Regs[0xe4], 3);
      for (cont = 0; cont < mycurve->count; cont++)
	steps = Motor_AddStep (steps, &bwriten, mycurve->step[cont]);
    }


  /* dec.smearing */
  if (mysetting->dec.smearing == mysetting->dec.scanbufferfull)
    {
      /* Next register has 14 bits size */
      iValue = Data_Get (&Regs[0x00f8], 2);
      Data_BitSet (iValue, &Regs[0x00fc], 14);

      mystep = Data_Get (&Regs[0x00ea], 3);
      Data_Set (mystep, &Regs[0x00f0], 3);
    }
  else
    {
      /* Next register has 14 bits size */
      var2 += mycurve->count * 3;
      Data_BitSet (var2, &Regs[0xfc], 14);

      mycurve = &mysetting->deccurve[mysetting->dec.smearing];
      smeardeccurvecount = mycurve->count;
      Data_Set (mycurve->step[mycurve->count - 1], &Regs[0xf0], 3);
      for (cont = 0; cont < mycurve->count; cont++)
	steps = Motor_AddStep (steps, &bwriten, mycurve->step[cont]);
    }

  /* dec.normalscan */
  if (mysetting->dec.normalscan == mysetting->dec.scanbufferfull)
    {
      /* Next register has 14 bits size */
      iValue = Data_Get (&Regs[0xf8], 2);
      Data_BitSet (iValue, &Regs[0xfe], 14);

      mystep = Data_Get (&Regs[0xea], 3);
      Data_Set (mystep, &Regs[0xed], 3);
    }
  else if (mysetting->dec.normalscan == mysetting->dec.smearing)
    {
      /* Next register has 14 bits size */
      iValue = Data_Get (&Regs[0xfc], 2);
      Data_BitSet (iValue, &Regs[0xfe], 14);
      mystep = Data_Get (&Regs[0xf0], 3);
      Data_Set (mystep, &Regs[0xed], 3);
    }
  else
    {
      /* Next register has 14 bits size */
      var2 += mycurve->count * 3;
      Data_BitSet (var2, &Regs[0xfe], 14);
      mycurve = &mysetting->deccurve[mysetting->dec.normalscan];
      Data_Set (mycurve->step[mycurve->count - 1], &Regs[0xed], 3);
      for (cont = 0; cont < mycurve->count; cont++)
	steps = Motor_AddStep (steps, &bwriten, mycurve->step[cont]);
    }

  /* acc.parkhome */
  if (mysetting->acc.parkhome == mysetting->acc.normalscan)
    {
      /* Next register has 14 bits size */
      iValue = Data_Get (&Regs[0xf6], 2);
      Data_BitSet (iValue, &Regs[0x100], 14);
      /* Get last acccurve step */
      mystep = Data_Get (&Regs[0xe1], 3);
      Data_Set (mystep, &Regs[0xe7], 3);
    }
  else if (mysetting->acc.parkhome == mysetting->acc.smearing)
    {
      /* Next register has 14 bits size */
      iValue = Data_Get (&Regs[0xfa], 2);
      Data_BitSet (iValue, &Regs[0x100], 14);
      mystep = Data_Get (&Regs[0xe4], 3);
      Data_Set (mystep, &Regs[0xe7], 3);
    }
  else
    {
      /* Next register has 14 bits size */
      var2 += mycurve->count * 3;
      Data_BitSet (var2, &Regs[0x100], 14);
      mycurve = &mysetting->acccurve[mysetting->acc.parkhome];
      Data_Set (mycurve->step[mycurve->count - 1], &Regs[0xe7], 3);
      for (cont = 0; cont < mycurve->count; cont++)
	steps = Motor_AddStep (steps, &bwriten, mycurve->step[cont]);
    }

  /* dec.parkhome */
  if (mysetting->dec.parkhome == mysetting->dec.scanbufferfull)
    {
      /* Next register has 14 bits size */
      iValue = Data_Get (&Regs[0xf8], 2);
      Data_BitSet (iValue, &Regs[0x102], 14);

      mystep = Data_Get (&Regs[0xe4], 3);
      Data_Set (mystep, &Regs[0xf3], 3);
    }
  else if (mysetting->dec.parkhome == mysetting->dec.smearing)
    {
      /* Next register has 14 bits size */
      iValue = Data_Get (&Regs[0xfe], 2);
      Data_BitSet (iValue, &Regs[0x102], 14);
      mystep = Data_Get (&Regs[0xf0], 3);
      Data_Set (mystep, &Regs[0xf3], 3);
    }
  else if (mysetting->dec.parkhome == mysetting->dec.normalscan)
    {
      /* Next register has 14 bits size */
      iValue = Data_Get (&Regs[0xfe], 2);
      Data_BitSet (iValue, &Regs[0x102], 14);
      mystep = Data_Get (&Regs[0xed], 3);
      Data_Set (mystep, &Regs[0xf3], 3);
    }
  else
    {
      /* Next register has 14 bits size */
      iValue = var2 + (mycurve->count * 3);
      Data_BitSet (iValue, &Regs[0x102], 14);
      mycurve = &mysetting->deccurve[mysetting->dec.parkhome];
      Data_Set (mycurve->step[mycurve->count - 1], &Regs[0xf3], 3);
      for (cont = 0; cont < mycurve->count; cont++)
	steps = Motor_AddStep (steps, &bwriten, mycurve->step[cont]);
    }

  mybwriten = bwriten & 0x8000000f;
  if (mybwriten < 0)
    mybwriten = ((mybwriten - 1) | 0xfffffff0) + 1;

  if (mybwriten != 0)
    bwriten = (((bwriten & 0xffff) >> 0x04) + 1) << 0x04;
  bwriten = bwriten & 0xffff;

  E800_FLIP_FLOP ();

  /* lock */
  SetLock (Regs, TRUE);

  Motor_SendSteps (steps, bwriten, v15f8);

  if (steps != NULL)
    {
      free (steps);
      steps = NULL;
    }

  /* unlock */
  SetLock (Regs, FALSE);

  DBG (2, "+ Motor_Setup: %i\n", acccurvecount);

  return acccurvecount;
}


static SANE_Int
Motor_SendSteps (SANE_Byte * steps, SANE_Int size, SANE_Int v15f8)
{
  SANE_Int transfered;
  SANE_Int result;

  DBG (2, "+ Motor_SendSteps:(*steps, size=%i, v15f8=%i)\n", size, v15f8);

  result = ERROR;
  if (steps != NULL)
    {
      if (IWrite_Word (0x0000, 0x0000, 0x0800) == OK)
	{
	  SANE_Byte buffer[6];

	  Data_SetBigEndian (v15f8, &buffer[0], 3);
	  /* tamao del buffer a enviar dividido entre 2 */
	  Data_Set (size / 2, &buffer[3], 3);

	  if (IWrite_Buffer (0x0000, buffer, 0x06, 0x0401) == OK)
	    {
	      if (Bulk_Operation (0, size, steps, &transfered) == OK)
		{
		  /* Lets read steps again to check if are written correctly */
		  SANE_Byte *mysteps =
		    (SANE_Byte *) malloc (sizeof (SANE_Byte) * size);
		  if (mysteps != NULL)
		    {
		      if (IWrite_Buffer (0x0000, buffer, 0x06, 0x0400) == OK)
			{
			  usleep (1000 * 500);
			  /* Read buffer */
			  if (Bulk_Operation (1, size, mysteps, &transfered)
			      == OK)
			    {
			      /* Check data */
			      if (transfered == size)
				{
				  SANE_Int cont = 0;
				  result = OK;
				  while ((cont < size) && (result == OK))
				    {
				      if (mysteps[cont] != steps[cont])
					result = ERROR;
				      cont++;
				    }
				}
			      else
				result = ERROR;
			    }
			  else
			    DBG (2, "->     Reading bulk failed\n");
			}
		      free (mysteps);
		      mysteps = NULL;
		    }
		}
	      else
		DBG (2, "->     Writing bulk failed\n");
	    }
	}
    }
  else
    DBG (2, "->     *steps is null\n");

  DBG (2, "- Motor_SendSteps: %i\n", result);

  return result;
}

static SANE_Int
SetPwmLampMode (SANE_Int mode)
{
  SANE_Byte a, b;
  SANE_Int rst = ERROR;

  DBG (2, "+ SetPwmLampMode(mode=%i):\n", mode);

  if (Read_Byte (0xe948, &a) == OK)
    {
      if (Read_Byte (0xe9e0, &b) == OK)
	{
	  if (mode != 0)
	    {
	      if (pwmlamplevel != 0x00)
		{
		  b |= 0x80;
		  BGeneral[0x01e0] = (BGeneral[0x01e0] & 0x3f) | 0x80;
		}
	      else
		{
		  a |= 0x40;
		  b &= 0x3f;
		  BGeneral[0x0148] |= 0x40;
		  BGeneral[0x01e0] &= 0x3f;
		}
	    }
	  else
	    {
	      b &= 0x7f;
	      a &= 0xbf;
	    }

	  if (Write_Byte (0xe948, a) == OK)
	    rst = Write_Byte (0xe9e0, b);
	}
    }

  DBG (2, "- SetPwmLampMode(mode=%i):\n", rst);

  return rst;
}

static SANE_Int
SSCG_Enable (SANE_Byte enable, SANE_Byte mode, SANE_Byte clock)
{
  SANE_Int rst;
  SANE_Int sscg;
  SANE_Byte data1, data2;

  DBG (2, "+ SSCG_Enable(enable=%i, mode=%i, clock=%i)\n", enable, mode,
       clock);

  if ((Read_Byte (0xfe3a, &data1) == OK)
      && (Read_Byte (0xfe39, &data2) == OK))
    {
      if (enable != FALSE)
	{
	  data2 = (mode == 0) ? data2 & 0x7f : data2 | 0x80;

	  sscg = (data1 & 0xf3) | (((clock & 0x03) | 0x04) << 0x02);
	  sscg = (sscg << 8) | data2;
	}
      else
	sscg = ((data1 & 0xef) << 8) | _B0 (data2);

      rst = Write_Word (0xfe39, sscg);
    }
  else
    rst = ERROR;

  DBG (2, "- SSCG_Enable: %i\n", rst);

  return rst;
}

static SANE_Int
Init_USBData ()
{
  SANE_Byte data;
  SANE_Byte MotorResource[] =
    { 0xff, 0x90, 0xb0, 0xd4, 0xd0, 0x70, 0x50, 0x54, 0x30, 0x10, 0x14, 0x38,
0x18, 0x0c, 0x08, 0x28, 0x04, 0x00, 0x20, 0x44, 0x40, 0xe0, 0xc0, 0xc4, 0xa0, 0x80, 0x84, 0xa8,
0x88, 0x9c, 0x98, 0xb8 };

  DBG (2, "+ Init_USBData:\n");

  if (Read_Byte (0xf8ff, &data) != OK)
    return ERROR;

  data = (data | 1);
  if (Write_Byte (0xf8ff, data) != OK)
    return ERROR;

  if (SSCG_Enable (get_value (SCAN_PARAM, SSCGENABLE, 0, usbfile),
		   get_value (SCAN_PARAM, SSCGMODE, 1, usbfile),
		   get_value (SCAN_PARAM, SSCGCLOCKCONTROL, 3,
			      usbfile)) != OK)
    return ERROR;

  Init_Registers ();

  /* Gamma table size = 0x100 */
  BGeneral[0x1d0] &= 0xcf;	 /*--00----*/

  /* Set 3 channels_per_dot */
  BGeneral[0x12] |= 0xc0;

  BGeneral[0x00] &= 0xf0;
  BGeneral[0x00] |= 0x05;

  /* timing cnpp */
  BGeneral[0x96] &= 0xc0;
  BGeneral[0x96] |= 0x17;

  /* set sensor_channel_color_order */
  BGeneral[0x60a] &= 0x80;
  BGeneral[0x60a] |= 0x24;	/*x0aabbcc */

  Data_BitSet (get_value (SCAN_PARAM, CRVS, 7, usbfile), &BGeneral[0x10], 5);

  BGeneral[0x14] &= 0x1f;
  BGeneral[0x14] |= get_value (SCAN_PARAM, VRTS, 0, usbfile) << 5;

  BGeneral[0x15] &= 0x1f;
  BGeneral[0x15] |= get_value (SCAN_PARAM, VRMS, 0, usbfile) << 5;

  BGeneral[0x16] &= 0x1f;
  BGeneral[0x16] |= get_value (SCAN_PARAM, VRBS, 0, usbfile) << 5;

  BGeneral[0x11] |= 0x10;
  BGeneral[0x26] = (BGeneral[0x26] & 0xdf) | 0x50;
  BGeneral[0x185] = 0x88;
  BGeneral[0x186] = 0x88;

  data = get_value (SCAN_PARAM, MCLKIOC, 8, usbfile);
  BGeneral[0x187] = 0x08;
  BGeneral[0x187] |= data << 4;	/*aaaabbbb */

  data--;

  if (data < 7)
    {
      switch (data)
	{
	case 0:
	  data |= 0xc0;
	  break;
	case 1:
	  data |= 0xa0;
	  break;
	case 2:
	  data |= 0xe0;
	  break;
	case 3:
	  data |= 0x90;
	  break;
	case 4:
	  data |= 0xd0;
	  break;
	case 5:
	  data |= 0xb0;
	  break;
	case 6:
	  data = (data & 0x0f);
	  break;
	}
      BGeneral[0x187] = _B0 (data);
    }

  BGeneral[0x26] &= 0xf0;
  BGeneral[0x27] &= 0x3f;
  BGeneral[0x29] = 0x24;
  BGeneral[0x2a] = 0x10;
  BGeneral[0x150] = 0xff;
  BGeneral[0x151] = 0x13;
  BGeneral[0x156] = 0xf0;
  BGeneral[0x157] = 0xfd;

  if (changemotorcurrent != FALSE)
    Motor_Change (BGeneral, 3);

  BGeneral[0xde] = 0;
  BGeneral[0xdf] &= 0xf0;

  /* loads resource MOTOR en [047981b0]= MotorResource: */
  memcpy (&BGeneral[0x104], MotorResource, 32);

  BGeneral[0x124] = 0x94;
  E8D9_Control ();

  DBG (2, "- Init_USBData:\n");

  return OK;
}

static SANE_Int
Init_Registers ()
{
  SANE_Int rst = OK;
  SANE_Byte data;

  DBG (2, "+ Init_Registers:\n");

  /* Lee BGeneral */
  bzero (&BGeneral, 0x71a);
  RTS_ReadRegs (BGeneral);
  Read_FE3E (&v1619);

  if (sensortype == TOSHIBA)
    {
      /* TOSHIBA */
      BGeneral[0x0146] |= 0x80;
      BGeneral[0x0011] &= 0x3F;
      BGeneral[0x0146] |= 0x40;
    }
  else
    {
      /* SONY */
      BGeneral[0x146] &= 0x7f;	/*0------- */
      BGeneral[0x146] &= 0xbf;		 /*-0------*/

      BGeneral[0x11] &= 0x3f;
      BGeneral[0x11] |= 0x80;

      BGeneral[0xae] = ((BGeneral[0xae] & 0xd4) | 0x14);
      BGeneral[0xaf] = ((BGeneral[0xaf] & 0xf9) | 0x01);
      BGeneral[0x9c] = 0x01;
      BGeneral[0x9d] = 0x00;
      BGeneral[0x9e] = 0x00;
      BGeneral[0x9f] = 0x00;
      BGeneral[0xa0] = 0x00;
      BGeneral[0xa1] = 0x80;
      BGeneral[0xa2] = 0x01;
      BGeneral[0xa3] = 0x00;
      BGeneral[0xa4] = 0x00;
      BGeneral[0xa5] = 0x00;
      BGeneral[0xa6] = 0x00;
      BGeneral[0xa7] = 0x80;
      BGeneral[0xa8] = 0x01;
      BGeneral[0xa9] = 0x00;
      BGeneral[0xaa] = 0x00;
      BGeneral[0xab] = 0x00;
      BGeneral[0xac] = 0x00;
      BGeneral[0xad] = 0x80;
    }

  BGeneral[0x16f] &= 0xbf;
  BGeneral[0x0bf] = (BGeneral[0x00bf] & 0xe0) | 0x20;
  BGeneral[0x163] = (BGeneral[0x0163] & 0x3f) | 0x40;
  BGeneral[0xd6] &= 0xf0;
  BGeneral[0xd6] |= 0x08;
  BGeneral[0x164] |= 0x80;
  BGeneral[0x001] &= 0xf7;
  BGeneral[0x010] &= 0x1f;
  BGeneral[0x013] &= 0x7f;
  BGeneral[0x0bc] = 0x00;
  BGeneral[0x0bd] = 0x00;
  BGeneral[0x146] |= 0x10;
  BGeneral[0x165] = (BGeneral[0x0165] & 0x3f) | 0x80;
  BGeneral[0x0ed] = 0x10;
  BGeneral[0x0be] = 0x00;
  BGeneral[0x0d5] = 0x00;
  BGeneral[0x147] = 0xff;

  /* Set last acccurve step */
  Data_Set (0x2af8, &BGeneral[0xe1], 3);

  BGeneral[0xda] = 0x02;
  BGeneral[0xdd] &= 0xfc;
  BGeneral[0xee] = 0x00;
  BGeneral[0xef] = 0x00;
  BGeneral[0xde] = 0xff;

  /* set bit[4] has_curves = 0 | bit[0..3] unknown = 0 */
  BGeneral[0xdf] &= 0xe0;

  /* Set motortype */
  BGeneral[0xd7] = (motortype << 0x07) | (BGeneral[0x00d7] & 0x7f);

  if (motortype != 0)
    {
      v163f = 1;
      BGeneral[0x14e] |= 0x10;
      /* set motorpwmfrequency */
      Data_BitSet (motorpwmfrequency, &BGeneral[0x0d7], 6);
    }

  /* set binary threshold high and low in little endian */
  Data_Set (binarythresholdh, &BGeneral[0x1a0], 2);
  Data_Set (binarythresholdl, &BGeneral[0x19e], 2);

  BGeneral[0x600] &= 0xfb;
  BGeneral[0x1d8] |= 0x08;
  EF08_Control (BGeneral, 0);
  v160c = 0x04;
  v1610 = 0x80000;

  if (Read_Byte (0xef09, &data) == OK)
    {
      long mytime;
      mytime = GetTickCount () + 1500;
      while (((data & 1) == 0) && (mytime > GetTickCount ()) && (rst == 0))
	rst = Read_Byte (0xef09, &data);
    }
  else
    rst = ERROR;


  DBG (2, "- Init_Registers: %i\n", rst);

  return rst;
}

static SANE_Int
Read_FE3E (SANE_Byte * destino)
{
  SANE_Int rst;

  DBG (2, "+ Read_FE3E:\n");

  rst = ERROR;
  if (destino != NULL)
    {
      SANE_Byte data;
      if (Read_Byte (0xfe3e, &data) == 0)
	{
	  *destino = data;
	  rst = OK;
	}
    }

  DBG (2, "- Read_FE3E: %i\n", rst);

  return rst;
}

static SANE_Int
Lamp_IsAtHome (SANE_Byte * Regs)
{
  SANE_Int rst;
  char sdebug[20];

  DBG (2, "+ Lamp_IsAtHome:\n");

  /* if returns 1, lamp is at home. Otherwise it returns 0 */
  rst = FALSE;

  if (Regs != NULL)
    {
      SANE_Byte data;
      if (Read_Byte (0xe96f, &data) == OK)
	{
	  Regs[0x16f] = _B0 (data);
	  rst = (data >> 6) & 1;
	}
    }

  if (rst == TRUE)
    strcpy (sdebug, "Yes\n");
  else
    strcpy (sdebug, "No\n");

  DBG (2, "- Lamp_IsAtHome: %s", sdebug);

  return rst;
}

static SANE_Byte
RTS_IsExecuting (SANE_Byte * Regs)
{
  SANE_Byte rst;

  DBG (2, "+ RTS_IsExecuting:\n");

  rst = 0;

  if (Regs != NULL)
    {
      SANE_Byte data;
      if (Read_Byte (0xe800, &data) == OK)
	{
	  Regs[0x00] = data;
	  rst = (data >> 7) & 1;
	}
    }

  DBG (2, "- RTS_IsExecuting: %i\n", rst);

  return rst;
}

static SANE_Int
WaitEndingAction (SANE_Int msecs)
{
  SANE_Byte data;
  SANE_Int rst;

  DBG (2, "+ WaitEndingAction(msecs=%i):\n", msecs);

  /* returns 0 if ok or timeout
     returns -1 if fails */

  rst = ERROR;

  if (Read_Byte (0xe800, &data) == OK)
    {
      long ticks;
      ticks = GetTickCount () + msecs;
      rst = OK;
      while (((data & 0x80) != 0) && (ticks > GetTickCount ()) && (rst == OK))
	rst = Read_Byte (0xe800, &data);
    }

  DBG (2, "- WaitEndingAction: Ending with rst=%i\n", rst);

  return rst;
}

static SANE_Int
RTS_Enable_CCD (SANE_Byte * Regs, SANE_Int channels)
{
  SANE_Int rst = ERROR;

  DBG (2, "+ RTS_Enable_CCD(*Regs, arg2=%i):\n", channels);

  if (Read_Buffer (0xe810, &Regs[0x10], 4) == OK)
    {
      Regs[0x10] &= 0x1f;
      Regs[0x10] |= channels << 5;

      Regs[0x13] &= 0x7f;
      Regs[0x13] |= (channels & 0xf8) << 4;

      Write_Buffer (0xe810, &Regs[0x10], 4);
      rst = OK;
    }

  DBG (2, "- RTS_Enable_CCD: %i\n", rst);

  return rst;
}

static SANE_Int
E800_FLIP_FLOP ()
{
  SANE_Byte data;
  SANE_Int rst;

  DBG (2, "+ E800_FLIP_FLOP:\n");

  rst = ERROR;
  if (Read_Byte (0xe800, &data) == OK)
    {
      data = (data & 0x3f) | 0x40;
      if (Write_Byte (0xe800, data) == OK)
	{
	  data &= 0xbf;
	  rst = Write_Byte (0xe800, data);
	}
    }

  DBG (2, "- E800_FLIP_FLOP: %i\n", rst);

  return rst;
}

static SANE_Int
Lamp_SetTimer (SANE_Int minutes)
{
  SANE_Byte MyBuffer[2];
  SANE_Int rst;

  DBG (2, "+ Lamp_SetTimer(minutes=%i):\n", minutes);

  MyBuffer[0] = BGeneral[0x0146] & 0xef;
  MyBuffer[1] = BGeneral[0x0147];

  if (minutes > 0)
    {
      double rst, op2;

      minutes = _B0 (minutes);
      op2 = 2.682163611980331;
      MyBuffer[0x00] |= 0x10;
      rst = (minutes * op2);
      MyBuffer[0x01] = (SANE_Byte) floor (rst);
    }

  BGeneral[0x147] = MyBuffer[1];
  BGeneral[0x146] = (BGeneral[0x146] & 0xef) | (MyBuffer[0] & 0x10);

  rst = Write_Word (0xe946, (SANE_Int) ((MyBuffer[1] << 8) + MyBuffer[0]));

  DBG (2, "- Lamp_SetTimer: %i\n", rst);

  return rst;
}

static SANE_Int
Buttons_Enable ()
{
  SANE_Int data, rst;

  DBG (2, "+ Buttons_Enable:\n");

  if (Read_Word (0xe958, &data) == OK)
    {
      data |= 0x0f;
      rst = Write_Word (0xe958, data);
    }
  else
    rst = ERROR;

  DBG (2, "- Buttons_Enable: %i\n", rst);

  return rst;
}

static SANE_Int
Buttons_Status ()
{
  SANE_Int rst = -1;
  SANE_Byte data;

  if (Read_Byte (0x168, &data) == OK)
    rst = data & 0x63;

  DBG (2, "Buttons_Status: %i\n", rst);

  return rst;
}

static SANE_Int
GainOffset_Clear ()
{
  SANE_Int rst;

  DBG (2, "+ GainOffset_Clear:\n");

  rst = ERROR;
  offset_red = 0;
  offset_green = 0;
  offset_blue = 0;

  if (IWrite_Word (0x70, offset_red, 0x0200) == OK)
    if (IWrite_Word (0x72, offset_green, 0x0200) == OK)
      if (IWrite_Word (0x74, offset_blue, 0x0200) == OK)
	rst = IWrite_Byte (0x76, 0x00, 0x0200, 0x0200);

  DBG (2, "- GainOffset_Clear: %i\n", rst);

  return rst;
}

static SANE_Int
Lamp_GetStatus (SANE_Byte * flb_lamp, SANE_Byte * tma_lamp)
{
  SANE_Int data1, rst;
  SANE_Byte data2;

  DBG (2, "+ Lamp_GetStatus:\n");

  rst = ERROR;
  if (Read_Byte (0xe946, &data2) == OK)
    {
      if (Read_Word (0xe954, &data1) == OK)
	{
	  rst = OK;
	  *flb_lamp = 0;
	  *tma_lamp = 0;

	  if ((_B1 (data1) & 0x10) == 0)
	    *flb_lamp = (data2 >> 6) & 1;
	  else
	    *tma_lamp = (data2 >> 6) & 1;
	}
    }

  DBG (2, "- Lamp_GetStatus: rst=%i flb=%i tma=%i\n",
       rst, _B0 (*flb_lamp), _B0 (*tma_lamp));

  return rst;
}

static SANE_Int
WaitForScanner (SANE_Int msecs)
{
  SANE_Byte data;
  SANE_Int rst;
  long mytime;

  DBG (2, "+ WaitForScanner(msecs=%i):\n", msecs);

  rst = OK;
  mytime = GetTickCount () + msecs;

  while ((mytime > GetTickCount ()) && (rst == OK))
    {
      if (Read_Byte (0xf910, &data) == OK)
	{
	  if ((data & 8) == 0)
	    usleep (1000 * 100);
	  else
	    break;
	}
      else
	rst = ERROR;
    }

  DBG (2, "- WaitForScanner: %i\n", rst);

  return rst;
}

static SANE_Int
Motor_Change (SANE_Byte * buffer, SANE_Byte value)
{
  SANE_Int data, rst;

  DBG (2, "+ Motor_Change(*buffer, value=%i):\n", value);

  if (Read_Word (0xe954, &data) == OK)
    {
      data &= 0xcf;	      /*--00----*/
      value--;
      switch (value)
	{
	case 2:
	  data |= 0x30;
	  break;				     /*--11----*/
	case 1:
	  data |= 0x20;
	  break;				     /*--10----*/
	case 0:
	  data |= 0x10;
	  break;				     /*--01----*/
	}
      buffer[0x154] = _B0 (data);

      rst = Write_Byte (0xe954, buffer[0x154]);
    }
  else
    rst = ERROR;

  DBG (2, "- Motor_Change: %i\n", rst);

  return rst;
}

static void
EF08_Control (SANE_Byte * buffer, SANE_Byte value)
{
  DBG (2, "+ EF08_Control(*buffer, value=%i):\n", value);

  if (buffer != NULL)
    {
      buffer[0x708] &= 0xf7;
      if (Write_Byte (0xef08, buffer[0x708]) == OK)
	{
	  buffer[0x708] &= 0x1f;
	  buffer[0x708] |= _B0 (value << 5);
	  if (Write_Byte (0xef08, buffer[0x708]) == OK)
	    {
	      buffer[0x708] |= 0x08;
	      Write_Byte (0xef08, buffer[0x708]);
	    }
	}
    }

  DBG (2, "- EF08_Control\n");
}

static SANE_Int
E8D9_Control ()
{
  SANE_Byte data = 0;

  DBG (2, "+ E8D9_Control:\n");

  Read_Byte (0xe8d9, &data);
  data |= 4;
  Write_Byte (0xe8d9, data);

  DBG (2, "- E8D9_Control:\n");

  return OK;
}

static SANE_Byte
GainOffset_GetCount ()
{
  SANE_Byte data;

  DBG (2, "+ GainOffset_GetCount:\n");

  if (IRead_Byte (0x77, &data, 0x200) != OK)
    data = 0x0f;

  DBG (2, "- GainOffset_GetCount: %i\n", _B0 (data));

  return data;
}

static SANE_Int
RTS_Execute ()
{
  SANE_Byte e813, e800;
  SANE_Int ret;

  DBG (2, "+ RTS_Execute:\n");

  e813 = 0;
  e800 = 0;
  ret = ERROR;

  if (Read_Byte (0xe800, &e800) == OK)
    {
      if (Read_Byte (0xe813, &e813) == OK)
	{
	  e813 &= 0xbf;
	  if (Write_Byte (0xe813, e813) == OK)
	    {
	      e800 |= 0x40;
	      if (Write_Byte (0xe800, e800) == OK)
		{
		  e813 |= 0x40;
		  if (Write_Byte (0xe813, e813) == OK)
		    {
		      e800 &= 0xbf;
		      if (Write_Byte (0xe800, e800) == OK)
			{
			  usleep (1000 * 100);
			  e800 |= 0x80;
			  ret = Write_Byte (0xe800, e800);
			}
		    }
		}
	    }
	}
    }

  DBG (2, "- RTS_Execute: %i\n", ret);

  return ret;
}

static SANE_Int
RTS_isTmaAttached ()
{
  SANE_Int data;
  char sdebug[30];

  DBG (2, "+ RTS_isTmaAttached:\n");

  /* returns 0 if Tma is attached. Otherwise 1 */
  if (Read_Word (0xe968, &data) == OK)
    {
      data = ((_B1 (data) & 2) != 0) ? FALSE : TRUE;
    }
  else
    data = TRUE;

  if (data == TRUE)
    strcpy (sdebug, "Yes, TMA is attached\n");
  else
    strcpy (sdebug, "No, TMA is not attached\n");

  DBG (2, "- RTS_isTmaAttached: %s", sdebug);

  return data;
}

static SANE_Int
Gamma_AllocTable (SANE_Byte * table)
{
  SANE_Int C;
  SANE_Int rst = OK;

  hp_gamma.depth = 8;

  for (C = 0; C < 3; C++)
    if (hp_gamma.table[C] == NULL)
      hp_gamma.table[C] = malloc (sizeof (SANE_Byte) * 256);

  if ((hp_gamma.table[CL_RED] != NULL) &&
      (hp_gamma.table[CL_GREEN] != NULL) && (hp_gamma.table[CL_BLUE] != NULL))
    {
      /* All tables allocated */
      v1494 = 1;		/* Resultado de la funcion Gamma_AllocTable */

      for (C = 0; C < 256; C++)
	{
	  if ((table != NULL) && (RTS_Debug.EnableGamma == TRUE))
	    {
	      /* fill gamma tables with user defined values */
	      hp_gamma.table[CL_RED][C] = table[C];
	      hp_gamma.table[CL_GREEN][C] = table[0x100 + C];
	      hp_gamma.table[CL_BLUE][C] = table[0x200 + C];
	    }
	  else
	    {
	      hp_gamma.table[CL_RED][C] = C;
	      hp_gamma.table[CL_GREEN][C] = C;
	      hp_gamma.table[CL_BLUE][C] = C;
	    }
	}

      /* Locate threshold of bw */
      for (C = 0; C < 256; C++)
	if (hp_gamma.table[CL_RED][C] != 0)
	  break;

      bw_threshold = C - 1;
    }
  else
    {
      /* Some alloc failed */
      rst = ERROR;
      v1494 = 0;		/* Resultado de la funcion */

      Gamma_FreeTables ();
    }

  DBG (2, "> Gamma_AllocTable: %i >> bw_threshold = %i\n", rst, bw_threshold);

  return rst;
}


static SANE_Int
Refs_Calculate (SANE_Byte depth, SANE_Int width, SANE_Int height,
		SANE_Byte * scanned_pattern, SANE_Int * ler1,
		SANE_Int ler1order, SANE_Int * ser1, SANE_Int ser1order)
{
  SANE_Int a, buffersize, buffer_pos, xpos, ypos, data, rst, cnt;
  double *buffer1, *buffer2, data1, mydata1, d0, d1;

  DBG (2,
       "+ Refs_Calculate(depth=%i, width=%i, height=%i, *scanned_pattern, *ler1, ler1order=%i, *ser1, ser1order=%i)\n",
       depth, width, height, ler1order, ser1order);

  buffersize = width;
  if (buffersize < height)
    buffersize = height;

  buffer1 = (double *) malloc (sizeof (double) * buffersize);
  if (buffer1 == NULL)
    return ERROR;

  buffer2 = (double *) malloc (sizeof (double) * buffersize);
  if (buffer2 == NULL)
    {
      free (buffer1);
      buffer1 = NULL;
      return ERROR;
    }

	/*-------- 1st SER -------- */
  /* Buffers created, clear them */
  bzero (buffer1, sizeof (double) * buffersize);
  bzero (buffer2, sizeof (double) * buffersize);

  buffer_pos = 0;
  for (xpos = 0; xpos < width; xpos++)
    {
      for (a = 0; a < 20; a++)
	{
	  data = _B0 (scanned_pattern[(width * a) + xpos]);
	  if (depth > 8)
	    data =
	      ((_B0 (scanned_pattern[(width * a) + xpos + 1]) << 8) +
	       data) & 0xffff;
	  buffer1[buffer_pos] += data;
	}
      buffer_pos++;
    }

  /* d41f */
  rst = 1;

  data1 =
    (ser1order != 0) ? buffer1[0] - buffer1[1] : buffer1[1] - buffer1[0];
  buffer2[0] = data1;

  cnt = 1;			/* contador */
  if ((width - 5) > 1)
    {
      /*d473 */
      buffer_pos = 1;
      do
	{
	  mydata1 =
	    (ser1order !=
	     0) ? buffer1[buffer_pos] - buffer1[buffer_pos +
						5] : buffer1[buffer_pos + 5] -
	    buffer1[buffer_pos];
	  buffer2[buffer_pos] = mydata1;

	  if ((mydata1 >= 0) && (mydata1 > data1))
	    {
	      /*d4df */
	      data1 = mydata1;

	      d0 = abs (buffer2[rst] - buffer2[rst - 1]);
	      d1 = abs (buffer2[buffer_pos] - buffer2[buffer_pos - 1]);

	      if (d1 > d0)
		rst = cnt;
	    }
	  /*d551 */
	  buffer_pos++;
	  cnt++;
	}
      while (cnt < (width - 5));

    }

  if (ser1 != NULL)
    {
      *ser1 = rst;
      DBG (2, "> 1st SER=%x\n", *ser1);
    }

  if (_B0 (rst) < 0x0f)
    {
      /* Error */
      free (buffer1);
      free (buffer2);
      return ERROR;
    }

  /* Clear buffers again */
  bzero (buffer1, sizeof (double) * buffersize);
  bzero (buffer2, sizeof (double) * buffersize);

  buffer_pos = 0;
  for (ypos = 0; ypos < height; ypos++)
    {
      for (a = rst; a < (rst + 0x28); a++)
	{
	  data = _B0 (scanned_pattern[(width * ypos) + a]);
	  if (depth > 8)
	    data =
	      ((_B0 (scanned_pattern[(width * ypos) + a + 1]) << 8) +
	       data) & 0xffff;
	  buffer1[buffer_pos] += data;
	}
      buffer_pos++;
    }

  rst = 1;
  data1 =
    (ler1order != 0) ? buffer1[0] - buffer1[1] : buffer1[1] - buffer1[0];
  buffer2[0] = data1;
  cnt = 1;
  if ((height - 5) > 1)
    {
      buffer_pos = 1;
      do
	{
	  mydata1 =
	    (ler1order !=
	     0) ? buffer1[buffer_pos] - buffer1[buffer_pos +
						5] : buffer1[buffer_pos + 5] -
	    buffer1[buffer_pos];
	  buffer2[buffer_pos] = mydata1;

	  if ((mydata1 >= 0) && (mydata1 > data1))
	    {
	      data1 = mydata1;

	      d0 = abs (buffer2[rst] - buffer2[rst - 1]);
	      d1 = abs (buffer2[buffer_pos] - buffer2[buffer_pos - 1]);

	      if (d1 > d0)
		rst = cnt;
	    }
	  buffer_pos++;
	  cnt++;
	}
      while (cnt < (height - 5));
    }

  if (ler1 != NULL)
    {
      *ler1 = rst + 5;
      DBG (2, "> 1st LER=%x\n", *ler1);
    }

  if ((rst + 5) < 0x96)
    {
      /* Error */
      free (buffer1);
      free (buffer2);
      return ERROR;
    }

  /* Clear buffers again */
  bzero (buffer1, sizeof (double) * buffersize);
  bzero (buffer2, sizeof (double) * buffersize);

  buffer_pos = 0;
  for (xpos = 0; xpos < width; xpos++)
    {
      for (a = rst + 4; a < height; a++)
	{
	  data = _B0 (scanned_pattern[(width * a) + xpos]);
	  if (depth > 8)
	    data =
	      ((_B0 (scanned_pattern[(width * a) + xpos + 1]) << 8) +
	       data) & 0xffff;
	  buffer1[buffer_pos] += data;
	}
      buffer_pos++;
    }

  data1 =
    (ser1order != 0) ? buffer1[0] - buffer1[1] : buffer1[1] - buffer1[0];
  buffer2[0] = data1;
  cnt = 1;
  if ((width - 5) > 1)
    {
      buffer_pos = 1;
      do
	{
	  mydata1 =
	    (ser1order !=
	     0) ? buffer1[buffer_pos] - buffer1[buffer_pos +
						5] : buffer1[buffer_pos + 5] -
	    buffer1[buffer_pos];
	  buffer2[buffer_pos] = mydata1;

	  if ((mydata1 >= 0) && (mydata1 > data1))
	    {
	      data1 = mydata1;

	      d0 = abs (buffer2[rst] - buffer2[rst - 1]);
	      d1 = abs (buffer2[buffer_pos] - buffer2[buffer_pos - 1]);

	      if (d1 > d0)
		rst = cnt;
	    }
	  buffer_pos++;
	  cnt++;
	}
      while (cnt < (width - 5));

    }
  rst += 5;
  if (ser1 != NULL)
    {
      if (rst > *ser1)
	{
	  *ser1 = rst;
	  DBG (2, "> 2nd SER=%x\n", *ser1);
	}
      else
	{
	  /* Free memory */
	  free (buffer1);
	  free (buffer2);
	  return ERROR;
	}
    }

  /* Free memory */
  free (buffer1);
  free (buffer2);

  DBG (2, "- Refs_Calculate(*ser1=%i, *ler1=%i)\n", *ser1, *ler1);

  return OK;
}

/*static SANE_Int Lamp_On()
{
	// Turns on lamp 
	SANE_Byte data;
	
	if (Read_Byte(0xe946, &data) == 0)
	{
		data = (data | 0xc0);
		if (Write_Byte(0xe946, data) == 0)
			return 0;
				else return -1;
	} else return -1;
}*/

/*static SANE_Int Lamp_Off()
{
	// Turns off lamp 
	SANE_Byte data;
	
	if (Read_Byte(0xe946, &data) == 0)
	{
		data = (data & 0xbf);
		if (Write_Byte(0xe946, data) == 0) return 0; else return -1;
	} else return -1;
}*/

/*static SANE_Int Lamp_Switch(SANE_Int lamp)
{
	// If a lamp is turned on, it switches between main lamp (0) and cover lamp (1)
	// Returns 0 if lamp is switched correctly else -1
	
	SANE_Byte buffer[2];
	
	if (usb_ctl_read(0xe954, buffer, 0x02, 0x100) == 2)
	{
		switch (lamp)
		{
			case 1:
				buffer[1] = (buffer[1] | 0x10);
				break;
			case 0:
				buffer[1] = (buffer[1] & 0xef);
		}
		if (usb_ctl_write(0xe954, buffer, 0x02, 0) == 2) return 0; else return -1;
	} else return -1;
}*/

static double
get_shrd (double value, SANE_Int desp)
{
  if (desp <= 0x40)
    return value / pow (2, desp);
  else
    return 0;
}

static char
get_byte (double value)
{
  SANE_Int data = value;
  data = _B0 (data);

  return data;
}

static SANE_Int
Timing_Set_cph (SANE_Byte * Regs, struct st_cph *cph)
{
  SANE_Int rst = ERROR;

  if ((Regs != NULL) && (cph != NULL))
    {
      Regs[0x00] = get_byte (cph->p1);
      Regs[0x01] = get_byte (get_shrd (cph->p1, 0x08));
      Regs[0x02] = get_byte (get_shrd (cph->p1, 0x10));
      Regs[0x03] = get_byte (get_shrd (cph->p1, 0x18));

      Regs[0x04] &= 0x80;
      Regs[0x04] |= ((get_byte (get_shrd (cph->p1, 0x20))) & 0x0f);
      Regs[0x04] |= ((cph->ps & 1) << 6);
      Regs[0x04] |= ((cph->ge & 1) << 5);
      Regs[0x04] |= ((cph->go & 1) << 4);

      Regs[0x05] = get_byte (cph->p2);
      Regs[0x06] = get_byte (get_shrd (cph->p2, 0x08));
      Regs[0x07] = get_byte (get_shrd (cph->p2, 0x10));
      Regs[0x08] = get_byte (get_shrd (cph->p2, 0x18));
      Regs[0x09] &= 0xf0;
      Regs[0x09] |= ((get_byte (get_shrd (cph->p2, 0x20))) & 0x0f);

      rst = OK;
    }

  return rst;
}

static SANE_Int
Timing_Set (SANE_Int mytiming, SANE_Byte * Regs)
{
  DBG (2, "> Timing_Set(mytiming=%i, *Regs):\n", mytiming);

  if ((Regs != NULL) && (mytiming < timingcount))
    {
      struct st_timing *mt = &scantiming[mytiming];

      Data_BitSet (mt->cdss1, &Regs[0x92], 6);
      Data_BitSet (mt->cdsc1, &Regs[0x93], 6);
      Data_BitSet (mt->cdss2, &Regs[0x94], 6);
      Data_BitSet (mt->cdsc2, &Regs[0x95], 6);
      Data_BitSet (mt->cnpp, &Regs[0x96], 6);

      Regs[0x45] = 0;
      Regs[0x45] |= (mt->cvtrp[0] & 1) << 7;
      Regs[0x45] |= (mt->cvtrp[1] & 1) << 6;
      Regs[0x45] |= (mt->cvtrp[2] & 1) << 5;
      Data_BitSet (mt->cvtrfpw, &Regs[0x45], 5);

      Data_Set (mt->cvtrw, &Regs[0x47], 1);
      Data_BitSet (mt->cvtrbpw, &Regs[0x46], 5);
      Data_Set (mt->clamps, &Regs[0x8a], 3);
      Data_Set (mt->clampe, &Regs[0x8d], 3);

      Regs[0x97] = get_byte (mt->adcclkp[0]);
      Regs[0x98] = get_byte (get_shrd (mt->adcclkp[0], 0x08));
      Regs[0x99] = get_byte (get_shrd (mt->adcclkp[0], 0x10));
      Regs[0x9a] = get_byte (get_shrd (mt->adcclkp[0], 0x18));
      Regs[0x9b] &= 0xf0;
      Regs[0x9b] |= ((get_byte (get_shrd (mt->adcclkp[0], 0x20))) & 0x0f);

      Regs[0xc1] = get_byte (mt->adcclkp[1]);
      Regs[0xc2] = get_byte (get_shrd (mt->adcclkp[1], 0x08));
      Regs[0xc3] = get_byte (get_shrd (mt->adcclkp[1], 0x10));
      Regs[0xc4] = get_byte (get_shrd (mt->adcclkp[1], 0x18));
      Regs[0xc5] &= 0xe0;
      Regs[0xc5] |= ((get_byte (get_shrd (mt->adcclkp[1], 0x20))) & 0x0f);

      /* bit(4) = bit(0) */
      Regs[0xc5] |= ((mt->adcclkp2e & 1) << 0x04);

      Timing_Set_cph (&Regs[0x48], &mt->cph[0]);
      Timing_Set_cph (&Regs[0x52], &mt->cph[1]);
      Timing_Set_cph (&Regs[0x5c], &mt->cph[2]);
      Timing_Set_cph (&Regs[0x66], &mt->cph[3]);
      Timing_Set_cph (&Regs[0x70], &mt->cph[4]);
      Timing_Set_cph (&Regs[0x7a], &mt->cph[5]);
    }

  return OK;
}

static SANE_Int
Motor_GetFromResolution (SANE_Int resolution)
{
  SANE_Int ret;

  DBG (2, "+ Motor_GetFromResolution(resolution=%i):\n", resolution);

  ret = 3;
  if (usbtype != USB11)
    {
      if (scan.scantype != ST_NORMAL)
	{
	  /* scantype is ST_NEG or ST_TA */
	  if (resolution >= 600)
	    ret = 0;
	}
      else if (resolution >= 1200)
	ret = 0;
    }
  else if (resolution >= 600)
    ret = 0;

  DBG (2, "- Motor_GetFromResolution: %i\n", ret);

  return ret;
}

static SANE_Int
SetMultiExposure (SANE_Byte * Regs)
{
  SANE_Int iValue, myctpc;

  DBG (2, "> SetMultiExposure:\n");

  /* set motor has no curves */
  Regs[0xdf] &= 0xef;

  /* select case systemclock */
  switch ((Regs[0x00] & 0x0f))
    {
    case 0x00:
      iValue = 0x895440;
      break;
    case 0x01:
    case 0x08:
      iValue = 0x0b71b00;
      break;
    case 0x09:
      iValue = 0x0f42400;
      break;
    case 0x02:
      iValue = 0x112a880;
      break;
    case 0x03:
    case 0x0a:
      iValue = 0x16e3600;
      break;
    case 0x0b:
      iValue = 0x1e84800;
      break;
    case 0x04:
      iValue = 0x2255100;
      break;
    case 0x0c:
      iValue = 0x2dc6c00;
      break;
    case 0x05:
      iValue = 0x44aa200;
      break;
    case 0x0d:
      iValue = 0x5b8d800;
      break;
    default:
      iValue = 0x478f7f8;
      break;
    }

  iValue /= ((Regs[0x96] & 0x3f) + 1);
  iValue /= basespeedpps;

  myctpc = Data_Get (&Regs[0x30], 3) + 1;

  DBG (2, "CTPC -- SetMultiExposure -- 1 =%i\n", myctpc);

  if (Data_Get (&Regs[0xe1], 3) < iValue)
    {
      SANE_Int traget;

      if (Data_Get (&Regs[0x36], 3) == 0)
	Data_Set (myctpc - 1, &Regs[0x36], 3);

      if (Data_Get (&Regs[0x3c], 3) == 0)
	Data_Set (myctpc - 1, &Regs[0x3c], 3);

      if (Data_Get (&Regs[0x42], 3) == 0)
	Data_Set (myctpc - 1, &Regs[0x42], 3);

      iValue = (iValue + 1) * (_B0 (Regs[0xe0]) + 1);

      traget = (((myctpc + iValue - 1) / myctpc) * myctpc);
      Data_Set (traget - 1, &Regs[0x30], 3);

      traget = (traget / (_B0 (Regs[0xe0]) + 1)) - 1;
      Data_Set (traget, &Regs[0x00e1], 3);
    }

  /* 8300 */
  return OK;
}

static SANE_Int
Data_Get (SANE_Byte * address, SANE_Int size)
{
  SANE_Int ret = 0;
  if ((address != NULL) && (size > 0) && (size < 5))
    {
      SANE_Int a;
      SANE_Byte b;
      size--;
      for (a = size; a >= 0; a--)
	{
	  b = address[a];
	  ret = (ret << 8) + b;
	}
    }
  return ret;
}

static void
Data_Set (SANE_Int data, SANE_Byte * address, SANE_Int size)
{
  if ((address != NULL) && (size > 0) && (size < 5))
    {
      SANE_Int a;
      for (a = 0; a < size; a++)
	{
	  address[a] = _B0 (data);
	  data = data >> 8;
	}
    }
}

static void
Data_BitSet (SANE_Int data, SANE_Byte * address, SANE_Int size)
{
  Data_BitSet2 (data, address, size, 0);
/*
	if (size < 33)
	{
		SANE_Int bytes = size / 8;
		SANE_Int a;
		SANE_Int bits = size - (bytes * 8);
		SANE_Int b = 0;
		for (a = 0; a < bytes; a++)
		{
			address[a] = _B0(data);
			data = data >> 0x08;
		}
	
		b = pow(2, bits) - 1;
		address[bytes] = (address[bytes] & (0xff - b)) | (data & b);
	}*/
}

static void
Data_BitSet2 (SANE_Int data, SANE_Byte * address, SANE_Int size,
	      SANE_Int start)
{
  if ((size < 33) && (start < 8))
    {
      SANE_Int mask;
      SANE_Int a;

      for (a = 0; a < size; a++)
	{
	  start++;
	  if (start > 8)
	    {
	      start = 1;
	      address++;
	    }

	  mask = 1 << (start - 1);
	  if ((data & 1) != 0)
	    *address |= mask;
	  else
	    *address ^= (*address & mask);

	  data = data >> 1;
	}
    }
}

static void
Data_SetBigEndian (SANE_Int data, SANE_Byte * address, SANE_Int size)
{
  if ((address != NULL) && (size > 0) && (size < 5))
    {
      SANE_Int a;
      size--;
      for (a = size; a >= 0; a--)
	{
	  address[a] = _B0 (data);
	  data = data >> 8;
	}
    }
}

static void
Lamp_SetGainMode (SANE_Byte * Regs, SANE_Int resolution, SANE_Byte gainmode)
{
  SANE_Int data;

  DBG (2, "> Lamp_SetGainMode(*Regs, resolution=%i, gainmode=%i):\n",
       resolution, gainmode);

  data = Data_Get (&Regs[0x154], 2) & 0xfe7f;
  data = (gainmode == FALSE) ? data | 0x40 : data & 0xffbf;

  switch (resolution)
    {
    case 100:
    case 200:
    case 300:
    case 600:
      data |= 0x0100;
      break;
    case 2400:
      data |= 0x0180;
      break;
    case 1200:
      if (ccdtype == SONY)
	data |= 0x80;
      else if (ccdtype == TOSHIBA)
	data |= 0x0180;
      break;
    }

  Data_Set (data, &Regs[0x0154], 2);
}

static SANE_Int
RT_OP_START_SCAN (SANE_Int arg1, SANE_Int arg2)
{
  SANE_Int data;

  DBG (2, "+ RT_OP_START_SCAN(arg1=%i, arg2=%i):\n", arg1, arg2);

  v14b4 = 1;			/* TEMPORAL */
  data = 0;
  PWM_GetDutyCycle (&data);
  data = _B0 (data);

  DBG (2, "->   Pwm used = %i\n", data);

  /*
     windows driver saves pwm used, in file usbfile
     Section [SCAN_PARAM], field PwmUsed
   */

  v07d0 = 0x01;
  v0740 = Start_Scan ();
  if (v0740 == 0)
    {
      v0740 = fn66d0 ();
      Ops_in_0021 ();
    }

  DBG (2, "- RT_OP_START_SCAN: %i\n", v0740);

  return v0740;
}

static SANE_Int
fn66d0 ()
{
  SANE_Byte data;
  SANE_Int transferred;

  DBG (2, "+ fn66d0():\n");

  data = 0;

  if (scanning.imagebuffer != NULL)
    {
      free (scanning.imagebuffer);
      scanning.imagebuffer = NULL;
    }

  Read_Byte (0xee00, &data);
  data = (scan2.depth == 16) ? data & 0xfb : data | 0x04;
  Write_Byte (0xee00, data);

  /* Reservamos los buffers necesarios para leer la imagen */
  Reading_CreateBuffers ();

  if (Resize.type != 0)
    {
      /* 6729 */
      fnfe70 (&transferred);
    }

  DBG (2, "+ fn66d0():\n");

  return OK;
}

static void
Triplet_Gray (SANE_Byte * pPointer1, SANE_Byte * pPointer2,
	      SANE_Byte * buffer, SANE_Int channels_count)
{
  /*
     pPointer1 = FAB8
     pPointer2 = FABC
     buffer    = FAC0
     channels_count = FAC4
   */

  SANE_Int value;
  SANE_Int channel_size;

  DBG (2,
       "> Triplet_Gray(*pPointer1, *pPointer2, *buffer, channels_count=%i)\n",
       channels_count);

  channel_size = (scan2.depth > 8) ? 2 : 1;
  channels_count = channels_count / 2;

  while (channels_count > 0)
    {
      value = Data_Get (pPointer1, channel_size);
      Data_Set (value, buffer, channel_size);

      value = Data_Get (pPointer2, channel_size);
      Data_Set (value, buffer + channel_size, channel_size);

      pPointer1 += 2 * channel_size;
      pPointer2 += 2 * channel_size;
      buffer += 2 * channel_size;

      channels_count--;
    }
}

static void
Triplet_Lineart (SANE_Byte * pPointer1, SANE_Byte * pPointer2,
		 SANE_Byte * buffer, SANE_Int channels_count)
{
  /* Composing colour in lineart mode */

  SANE_Int dots_count = 0;
  SANE_Int channel;
  SANE_Byte mask;
  SANE_Byte value;
  SANE_Int C;

  DBG (2,
       "> Triplet_Lineart(*pPointer1, *pPointer2, *buffer, channels_count=%i)\n",
       channels_count);

  if (channels_count > 0)
    {
      dots_count = (channels_count + 1) / 2;
      while (dots_count > 0)
	{
	  mask = 0x80;
	  channel = 2;
	  do
	    {
	      value = 0;
	      for (C = 4; C > 0; C--)
		{
		  value =
		    (value << 2) +
		    (((*pPointer2 & mask) << 1) | (*pPointer1 & mask));
		  mask = mask >> 1;
		}
	      *buffer = value;
	      buffer++;
	      channel--;
	    }
	  while (channel > 0);
	  pPointer2 += 2;
	  pPointer1 += 2;
	  dots_count--;
	}
    }
}

static SANE_Int
Arrange_NonColour (SANE_Byte * buffer, SANE_Int buffer_size,
		   SANE_Int * transferred)
{
  /*
     buffer : fadc
     buffer_size : fae0
   */

  SANE_Int lines_count = 0;	/* ebp */
  SANE_Int channels_count = 0;	/* fadc pisa buffer */
  SANE_Int rst = ERROR;

  DBG (2, "+ Arrange_NonColour(*buffer, buffer_size=%i, *transferred):\n",
       buffer_size);

  if (scanning.imagebuffer == NULL)
    {
      if ((use_hightresolution == TRUE) || (scan2.colormode == CM_LINEART))
	{
	  scanning.bfsize = (use_sensorevenodddist + 1) * v158c;
	  scanning.imagebuffer =
	    (SANE_Byte *) malloc (scanning.bfsize * sizeof (SANE_Byte));
	  if (scanning.imagebuffer != NULL)
	    {
	      if (Read_Block
		  (scanning.bfsize, scanning.imagebuffer, transferred) == OK)
		{
		  v06c0 = 0;
		  channel_size = (scan2.depth == 8) ? 1 : 2;
		  scanning.desp1[CL_RED] = 0;
		  scanning.desp2[CL_RED] =
		    channel_size + (use_sensorevenodddist * v158c);
		  scanning.pColour2[CL_RED] =
		    scanning.imagebuffer + scanning.desp2[CL_RED];
		  scanning.pColour1[CL_RED] =
		    scanning.imagebuffer + scanning.desp1[CL_RED];
		  rst = OK;
		}
	    }
	}
    }
  else
    rst = OK;

  /* b0f4 */
  if (rst == OK)
    {
      scanning.imagepointer = scanning.imagebuffer;
      lines_count = buffer_size / v158c;
      channels_count = v158c / channel_size;
      while (lines_count > 0)
	{
	  if (scan2.colormode == CM_LINEART)
	    Triplet_Lineart (scanning.pColour1[CL_RED],
			     scanning.pColour2[CL_RED], buffer,
			     channels_count);
	  else
	    Triplet_Gray (scanning.pColour1[CL_RED],
			  scanning.pColour2[CL_RED], buffer, channels_count);

	  buffer += v158c;
	  v15b8 -= bytesperline;
	  lines_count--;
	  if (lines_count == 0)
	    {
	      if ((v15b8 | v15bc) == 0)
		break;
	    }

	  rst = Read_Block (v158c, scanning.imagepointer, transferred);
	  if (rst != OK)
	    break;

	  v06c0 = (v158c + v06c0) % scanning.bfsize;
	  if (use_hightresolution == TRUE)
	    {
	      scanning.desp2[CL_RED] =
		(v158c + scanning.desp2[CL_RED]) % scanning.bfsize;
	      scanning.desp1[CL_RED] =
		(v158c + scanning.desp1[CL_RED]) % scanning.bfsize;

	      scanning.pColour2[CL_RED] =
		scanning.imagebuffer + scanning.desp2[CL_RED];
	      scanning.pColour1[CL_RED] =
		scanning.imagebuffer + scanning.desp1[CL_RED];
	    }
	  /* b21d */
	  scanning.imagepointer += v158c;
	  if (scanning.imagepointer >=
	      (scanning.imagebuffer + scanning.bfsize))
	    scanning.imagepointer = scanning.imagebuffer;
	}
    }

  /* 2246 */

  DBG (2, "- Arrange_NonColour(*transferred=%i): %i\n", *transferred, rst);

  return rst;
}

static SANE_Int
Resize_Line (SANE_Byte * to_buffer, SANE_Int to_resolution, SANE_Int to_width,
	     SANE_Byte * from_buffer, SANE_Int from_resolution,
	     SANE_Int from_width, SANE_Int myresize_mode)
{
  /*
     to_buffer = FAC8 = 0x236200
     to_resolution      = FACC = 0x4b
     to_width    = FAD0 = 0x352
     from_buffer = FAD4 = 0x235460
     from_resolution      = FAD8 = 0x64
     from_width    = FADC = 0x46d
     myresize_mode   = FAE0 = 1
   */

  SANE_Int rst = ERROR;
  SANE_Int channels = 0;	/* fac8 */
  SANE_Int depth = 0;		/* fae0 */
  SANE_Int color[3] = { 0, 0, 0 };	/* fab8 | fabc | fac0 */
  SANE_Int to_pos = 0;		/* fad4 */
  SANE_Int rescont = 0;
  SANE_Int from_pos = 0;	/* fab4 */
  SANE_Int C;
  SANE_Int smres = 0;		/* fab0 */
  SANE_Int value;
  SANE_Int channel_size;

  to_resolution = to_resolution & 0xffff;
  from_resolution = from_resolution & 0xffff;

  DBG (2,
       "+ Resize_Line(*to_buffer, to_resolution=%i, to_width=%i, *from_buffer, from_resolution=%i, from_width=%i, myresize_mode=%i):\n",
       to_resolution, to_width, from_resolution, from_width, myresize_mode);

  if (myresize_mode != RSZ_LINEART)
    {
      switch (myresize_mode)
	{
	case RSZ_GRAYL:
	  channels = 1;
	  depth = 8;
	  break;
	case RSZ_COLOURL:
	  channels = 3;
	  depth = 8;
	  break;
	case RSZ_COLOURH:
	  channels = 3;
	  depth = 16;
	  break;
	case RSZ_GRAYH:
	  channels = 1;
	  depth = 16;
	  break;
	}

      channel_size = (depth > 8) ? 2 : 1;
      to_pos = 0;
      rescont = 0;

      while (to_pos < to_width)
	{
	  from_pos++;
	  if (from_pos > from_width)
	    from_buffer -= (((depth + 7) / 8) * channels);

	  rescont += to_resolution;
	  if (rescont < from_resolution)
	    {
	      /* Adds 3 color channel values */
	      for (C = 0; C < channels; C++)
		{
		  color[C] +=
		    Data_Get (from_buffer, channel_size) * to_resolution;
		  from_buffer += channel_size;
		}
	    }
	  else
	    {
	      /* fc3c */
	      to_pos++;
	      smres = to_resolution - (rescont - from_resolution);
	      for (C = 0; C < channels; C++)
		{
		  value =
		    ((Data_Get (from_buffer, channel_size) * smres) +
		     color[C]) / from_resolution;
		  Data_Set (value, to_buffer, channel_size);
		  color[C] =
		    Data_Get (from_buffer,
			      channel_size) * (rescont - from_resolution);

		  to_buffer += channel_size;
		  from_buffer += channel_size;
		}
	      rescont -= from_resolution;
	    }
	}

      rst = OK;
    }
  else
    {
      /* fd60 */
      SANE_Int bit, pos, desp, rescont2;

      *to_buffer = 0;
      bit = 0;
      pos = 0;
      desp = 0;
      rescont = 0;
      rescont2 = 0;
      if (to_width > 0)
	{
	  do
	    {
	      if (bit == 8)
		{
		  /* fda6 */
		  bit = 0;
		  to_buffer++;
		  *to_buffer = 0;
		}
	      rescont += to_resolution;
	      if (rescont < from_resolution)
		{
		  if ((*from_buffer & (0x80 >> desp)) != 0)
		    rescont2 += to_resolution;
		}
	      else
		{
		  /*fdd5 */
		  pos++;
		  rescont -= from_resolution;
		  if ((*from_buffer & (0x80 >> desp)) != 0)
		    /*fdee */
		    rescont2 += (to_resolution - rescont);
		  if (rescont2 > (to_resolution / 2))
		    /* fe00 */
		    *to_buffer = _B0 (*to_buffer | (0x80 >> bit));
		  rescont2 =
		    ((*from_buffer & (0x80 >> desp)) != 0) ? rescont : 0;
		  bit++;
		}
	      /* fe2f */
	      desp++;
	      if (desp == 8)
		{
		  desp = 0;
		  from_buffer++;
		}
	    }
	  while (pos < to_width);
	}
      else
	rst = OK;
    }

  DBG (2, "- Resize_Line: %i\n", rst);

  return rst;
}

static SANE_Int
fnf7f0 (SANE_Byte * pPointer1, SANE_Int res1, SANE_Int width1,
	SANE_Byte * pPointer2, SANE_Int res2, SANE_Int width2,
	SANE_Int myresize_mode)
{
  /*
     pPointer1 = FAC8 = 0x2353f0
     res1      = FACC = 0x4b
     width1    = FAD0 = 0x352
     pPointer2 = FAD4 = 0x234650
     res2      = FAD8 = 0x64
     width2    = FADC = 0x46d
     myresize_mode   = FAE0 = 1
   */

  SANE_Int rst = ERROR;
  SANE_Int myp1;		/* fac0 */
  SANE_Byte *myp2;		/* faac */
  SANE_Byte *myp3;		/* fab0 */
  SANE_Byte *myp4;		/* fad4 */
  SANE_Byte *myp5;		/* fac8 */
  SANE_Int mywidth;		/* fab4 fab8 */
  SANE_Int mychannels;		/* fabc */
  SANE_Int channels = 0;	/* faa4 */
  SANE_Int depth = 0;		/* faa8 */
  SANE_Int val4 = 0;		/* fae0 */
  SANE_Int val5;
  SANE_Int val6 = 0;
  SANE_Int val7 = 0;
  SANE_Int value;
  /**/
    DBG (2,
	 "+ fnf7f0(*pPointer1, res1=%i, width1=%i, *pPointer2, res2=%i, width2=%i, myresize_mode=%i):\n",
	 res1, width1, res2, width2, myresize_mode);

  if (myresize_mode != RSZ_LINEART)
    {
      switch (myresize_mode)
	{
	case RSZ_GRAYL:
	  channels = 1;
	  depth = 8;
	  break;
	case RSZ_COLOURL:
	  channels = 3;
	  depth = 8;
	  break;
	case RSZ_COLOURH:
	  channels = 3;
	  depth = 16;
	  break;
	case RSZ_GRAYH:
	  channels = 1;
	  depth = 16;
	  break;
	}


      if (channels > 0)
	{
	  myp1 = pPointer1 - pPointer2;
	  myp2 = pPointer2;
	  myp3 = pPointer2;
	  mychannels = channels;

	  do
	    {
	      val4 = 0;
	      if (depth == 8)
		{
		  myp4 = myp2;
		  myp5 = myp1 + myp2;
		  val5 = ((res2 & 0xffff) / 2) + (res1 & 0xffff);
		  val6 = _B0 (*myp2);
		  if (width1 > 0)
		    {
		      mywidth = width1;
		      do
			{
			  if (val5 >= (res1 & 0xffff))
			    {
			      val5 -= (res1 & 0xffff);
			      val4++;
			      val7 = val6;
			      if (val4 < width1)
				{
				  myp4 += channels;
				  val6 = _B0 (*myp4);
				}
			    }
			  /* f904 */
			  *myp5 =
			    _B0 (((((res1 & 0xffff) - val5) * val7) +
				  (val6 * val5)) / (res1 & 0xffff));
			  myp5 += channels;
			  mywidth--;
			}
		      while (mywidth > 0);
		    }
		}
	      else
		{
		  /* f938 */
		  SANE_Byte *myp6;	/* fab4 */
		  SANE_Int nchannels;	/* fac8 */

		  /* edx = channels
		     ecx = myp1
		     edi = depth
		   */

		  myp6 = myp1 + myp3;
		  myp4 = myp3;
		  val7 = Data_Get (myp3, 2);
		  if (width1 > 0)
		    {
		      nchannels = channels * 2;
		      mywidth = width1;
		      val5 = ((res2 & 0xffff) / 2) + (res1 & 0xffff);
		      do
			{
			  if (val5 >= (res1 & 0xffff))
			    {
			      val5 -= (res1 & 0xffff);
			      val6 = val7;
			      val4++;
			      if (val4 < width2)
				{
				  /*myp4 = myp4 + myp5; */
				  myp4 += nchannels;	/* ??????????? */
				  val7 = Data_Get (myp4, 2);
				}
			    }
			  /*f9a5 */
			  Data_Set ((((((res1 & 0xffff) - val5) * val6) +
				      (val7 * val5)) / (res1 & 0xffff)), myp6,
				    2);
			  val5 += (res2 & 0xffff);
			  myp6 += nchannels;
			  mywidth--;
			}
		      while (mywidth > 0);
		    }
		}
	      /* f9d5 */
	      myp2++;
	      myp3 += 2;
	      mychannels--;
	    }
	  while (mychannels > 0);
	  rst = OK;
	}
      else
	rst = OK;
    }
  else
    {
      /* fa02 */
      /*
         pPointer1 = FAC8 = 0x2353f0
         res1      = FACC = 0x4b
         width1    = FAD0 = 0x352
         pPointer2 = FAD4 = 0x234650
         res2      = FAD8 = 0x64
         width2    = FADC = 0x46d
         myresize_mode   = FAE0 = 1
       */
      SANE_Int myres2;		/* fac8 */
      SANE_Int sres;
      SANE_Int lfaa8;
      SANE_Int lfae0;
      SANE_Int lfad8;
      SANE_Int myres;
      SANE_Int cont = 1;
      SANE_Int someval;
      SANE_Int bit = 0;

      myres2 = res2 & 0xffff;
      sres = (myres2 / 2) + (res1 & 0xffff);
      value = _B0 (*pPointer2);
      lfaa8 = 0;
      lfae0 = 0;
      lfad8 = value >> 7;
      someval = lfad8;
      *pPointer1 = 0;

      if (width1 > 0)
	{
	  myres = res1 & 0xffff;
	  res1 = myres / 2;
	  do
	    {
	      if (sres >= myres)
		{
		  sres -= myres;
		  lfae0++;
		  cont++;
		  lfad8 = someval;
		  if (lfae0 < width2)
		    {
		      if (cont == 8)
			{
			  cont = 0;
			  pPointer2++;
			}
		      bit = (((0x80 >> cont) & *pPointer2) != 0) ? 1 : 0;
		    }
		}
	      /*faa6 */
	      if ((((myres - sres) * lfad8) + (bit * sres)) > res1)
		*pPointer1 |= (0x80 >> lfaa8);

	      lfaa8++;
	      if (lfaa8 == 8)
		{
		  lfaa8 = 0;
		  pPointer1++;
		  *pPointer1 = 0;
		}
	      width1--;
	      sres += myres2;
	    }
	  while (width1 > 0);
	  rst = OK;
	}
    }

  DBG (2, "- fnf7f0: %i\n", rst);

  return rst;
}

static SANE_Int
fnfe70 (SANE_Int * transferred)
{
  SANE_Int rst = ERROR;

  DBG (2, "+ fnfe70(*transferred):\n");

  if (Resizing_CreateBuffers (v158c, Resize.bytesperline, Resize.bytesperline)
      == ERROR)
    return ERROR;

  if (arrangeline2 == FIX_BY_SOFT)
    {
      /* fee0 */
      if (scan2.colormode == CM_COLOR)
	rst = Arrange_Colour (Resize.v3624, v158c, transferred);
      else
	rst = Arrange_NonColour (Resize.v3624, v158c, transferred);
    }
  else
    rst = Read_Block (v158c, Resize.v3624, transferred);	/* ff03 */

  /* Redimensionado */
  switch (Resize.type)
    {
    case 1:
      /* ff1b */
      Resize_Line (Resize.v3628, imageresx, Resize.towidth, Resize.v3624,
		   scan2.resolution_x, Resize.fromwidth, Resize.mode);
      break;
    case 2:
      /* ff69 */
      sresolutiony = 0;
      fnf7f0 (Resize.v3628, imageresx, Resize.towidth, Resize.v3624,
	      scan2.resolution_x, Resize.fromwidth, Resize.mode);
      if (arrangeline2 == FIX_BY_SOFT)
	{
	  /* ffb1 */
	  if (scan2.colormode == CM_COLOR)
	    rst = Arrange_Colour (Resize.v3624, v158c, transferred);
	  else
	    rst = Arrange_NonColour (Resize.v3624, v158c, transferred);
	}
      else
	rst = Read_Block (v158c, Resize.v3624, transferred);	/* ffe0 */

      /* fff2 */
      fnf7f0 (Resize.v362c, imageresx, Resize.towidth, Resize.v3624,
	      scan2.resolution_x, Resize.fromwidth, Resize.mode);
      break;
    }

  /* 002a */

  DBG (2, "- fnfe70(*transferred=%i): %i\n", *transferred, rst);

  return rst;
}

static SANE_Int
Resizing_CreateBuffers (SANE_Int size1, SANE_Int size2, SANE_Int size3)
{
  SANE_Int rst;

  Resize.v3624 = (SANE_Byte *) malloc ((size1 + 0x40) * sizeof (SANE_Byte));
  Resize.v3628 = (SANE_Byte *) malloc ((size2 + 0x40) * sizeof (SANE_Byte));
  Resize.v362c = (SANE_Byte *) malloc ((size3 + 0x40) * sizeof (SANE_Byte));

  if ((Resize.v3624 == NULL) || (Resize.v3628 == NULL)
      || (Resize.v362c == NULL))
    {
      Resizing_DestroyBuffers ();
      rst = ERROR;
    }
  else
    rst = OK;

  DBG (2, "> Resizing_CreateBuffers(size1=%i, size2=%i, size3=%i): %i\n",
       size1, size2, size3, rst);

  return rst;
}

static SANE_Int
Resizing_DestroyBuffers ()
{
  if (Resize.v3624 != NULL)
    free (Resize.v3624);

  if (Resize.v3628 != NULL)
    free (Resize.v3628);

  if (Resize.v362c != NULL)
    free (Resize.v362c);

  Resize.v3624 = NULL;
  Resize.v3628 = NULL;
  Resize.v362c = NULL;

  return OK;
}

static SANE_Int
Reading_DestroyBuffers ()
{
  DBG (2, "> Reading_DestroyBuffers():\n");

  if (Reading.DMABuffer != NULL)
    free (Reading.DMABuffer);

  if (scanning.imagebuffer != NULL)
    {
      free (scanning.imagebuffer);
      scanning.imagebuffer = NULL;
    }

  bzero (&Reading, sizeof (struct st_readimage));

  return OK;
}

static SANE_Int
Gamma_SendTables (SANE_Byte * Regs, SANE_Byte * gammatable, SANE_Int size)
{
  SANE_Int rst = ERROR;

  DBG (2, "+ Gamma_SendTables(*Regs, *gammatable, size=%i):\n", size);

  if ((gammatable != NULL) && (size > 0))
    {
      SANE_Int transferred;
      SANE_Byte buffer[6];
      SANE_Int first_table;
      SANE_Int cont = 0;
      SANE_Int retry = TRUE;
      SANE_Byte *mybuffer;

      /* lock */
      SetLock (Regs, TRUE);

      first_table = (Data_Get (&Regs[0x1b4], 2) & 0x3fff) >> 4;

      Data_SetBigEndian (first_table, &buffer[0], 3);
      /* buffer size to send divided by 2 */
      Data_Set (size / 2, &buffer[3], 3);

      mybuffer = (SANE_Byte *) malloc (sizeof (SANE_Byte) * size);
      if (mybuffer != NULL)
	{
	  /* Try to send buffer during 10 seconds */
	  long tick = GetTickCount () + 10000;
	  while ((retry == TRUE) && (tick > GetTickCount ()))
	    {
	      retry = FALSE;

	      /* Operation type 0x14 */
	      if (IWrite_Word (0x0000, 0x0014, 0x0800) == OK)
		{
		  /* Send size to write */
		  if (IWrite_Buffer (0x0000, buffer, 0x06, 0x0401) == OK)
		    {
		      /* Send data */
		      if (Bulk_Operation (0, size, gammatable, &transferred)
			  == OK)
			{
			  /* Send size to read */
			  if (IWrite_Buffer (0x0000, buffer, 0x06, 0x0400) ==
			      OK)
			    {
			      /* Retrieve data */
			      if (Bulk_Operation
				  (1, size, mybuffer, &transferred) == OK)
				{
				  /* Check data */
				  while ((cont < size) && (retry == FALSE))
				    {
				      if (mybuffer[cont] != gammatable[cont])
					retry = TRUE;
				      cont++;
				    }

				  if (retry == FALSE)
				    rst = OK;
				}
			    }
			}
		    }
		}
	    }

	  free (mybuffer);
	}

      /* unlock */
      SetLock (Regs, FALSE);
    }

  DBG (2, "- Gamma_SendTables: %i\n", rst);

  return rst;
}

/*static SANE_Int Get_Gamma_Tables(SANE_Byte *Gamma_buffer)
{
	SANE_Int rst = ERROR;

	DBG(2, "+ Get_Gamma_Tables(SANE_Byte *Gamma_buffer):\n");

	if (Gamma_buffer == NULL)
		return ERROR;
*/
	/* Operation type 0x14 */
/*	if (IWrite_Word(0x0000, 0x0014, 0x0800) == 0x00)
	{
		SANE_Byte buffer[6];
		SANE_Int size = 768;

		buffer[0x00] = 0;
		buffer[0x01] = 0;
		buffer[0x02] = 0;*/
		/* tamao del buffer a enviar dividido entre 2 */
/*		buffer[0x03] = (size >> 0x01) & 0xff;
		buffer[0x04] = (size >> 0x09) & 0xff;
		buffer[0x05] = (size >> 0x11) & 0xff;

		if (IWrite_Buffer(0x0000, buffer, 0x06, 0x0400) == OK)
		{
			SANE_Int transferred = 0;
			usleep(1000 * 500);*/
			/* Read buffer */
/*			rst = Bulk_Operation(1, size, Gamma_buffer, &transferred);
		}
	}

	DBG(2, "- Get_Gamma_Tables: %i\n", rst);

	return rst;
}*/

static void
Gamma_FreeTables ()
{
  SANE_Int c;

  DBG (2, "> Gamma_FreeTables()\n");

  for (c = 0; c < 3; c++)
    {
      if (hp_gamma.table[c] != NULL)
	{
	  free (hp_gamma.table[c]);
	  hp_gamma.table[c] = NULL;
	}
    }
  use_gamma_tables = FALSE;
}

static void
StopScan ()
{
  SANE_Byte data;

  DBG (2, "+ StopScan():\n");

  data = 0;

  Reading_DestroyBuffers ();
  Resizing_DestroyBuffers ();
  IWrite_Word (0x0000, 0, 0x800);
  BGeneral[0x60b] &= 0xef;
  BGeneral[0x60a] &= 0xbf;
  if (Write_Buffer (0xee0a, &BGeneral[0x60a], 2) == OK)
    Motor_Change (BGeneral, 3);
  usleep (1000 * 200);

  if (v07c0 == 0)
    {
      Read_Byte (0xe801, &data);
      if ((data & 0x02) == 0)
	{
	  if (Lamp_IsAtHome (BGeneral) == FALSE)
	    {
	      BGeneral[0x00] &= 0x7f;
	      Write_Byte (0x00, BGeneral[0x00]);
	      v0748 = Motor_ParkHome (TRUE, parkhomemotormove);
	    }
	}
    }
  else
    {
      /*66a1 */
      BGeneral[0x00] &= 0x7f;
      Write_Byte (0x0000, BGeneral[0x0000]);
      if (Lamp_IsAtHome (BGeneral) == FALSE)
	v0748 = Motor_ParkHome (TRUE, parkhomemotormove);
    }

  /*66e0 */
  RTS_Enable_CCD (BGeneral, 0);

  Lamp_SetTimer (13);

  DBG (2, "- StopScan()\n");
}

static SANE_Int
Reading_CreateBuffers ()
{
  SANE_Byte data;
  SANE_Int mybytesperline;
  SANE_Int mybuffersize, a, b;

  DBG (2, "+ Reading_CreateBuffers():\n");

  data = 0;

  /* Gets BinarythresholdH */
  if (Read_Byte (0xe9a1, &data) == OK)
    binarythresholdh = data;

  mybytesperline =
    (scan2.depth == 12) ? (bytesperline * 3) / 4 : bytesperline;

  Reading.Max_Size = 0xfc00;
  Reading.DMAAmount = 0;
  Reading.Cancel = FALSE;


  a = (dmabuffersize / 63);
  b = (((dmabuffersize - a) / 2) + a) >> 0x0f;
  mybuffersize = ((b << 6) - b) << 10;
  if (mybuffersize < 0x1f800)
    mybuffersize = 0x1f800;
  Reading.DMABufferSize = mybuffersize;	/*3FFC00 4193280 */
  do
    {
      Reading.DMABuffer =
	(SANE_Byte *) malloc (Reading.DMABufferSize * sizeof (SANE_Byte));
      if (Reading.DMABuffer != NULL)
	break;
      Reading.DMABufferSize -= Reading.Max_Size;
    }
  while (Reading.DMABufferSize >= Reading.Max_Size);

  /* 6003 */
  Reading.Starting = TRUE;

  Reading.Size4Lines = (mybytesperline > Reading.Max_Size) ?
    mybytesperline : (Reading.Max_Size / mybytesperline) * mybytesperline;

  Reading.ImageSize = imagesize;
  read_v15b4 = v15b4;

  DBG (2, "- Reading_CreateBuffers():\n");

  return OK;
}

static SANE_Int
Ops_in_0021 ()
{
  SANE_Byte somebuffer[26];
  SANE_Int idata;
  SANE_Byte cdata = 0;

  DBG (2, "+ Ops_in_0021():\n");

  bzero (&somebuffer, sizeof (somebuffer));
  somebuffer[4] = 0x0c;
  IRead_Integer (0x0021, &idata, 0x200);
  Data_Set (idata + 1, &somebuffer[0], 4);
  IRead_Byte (0x003a, &cdata, 0x200);
  somebuffer[25] = cdata;
  IWrite_Buffer (0x0021, somebuffer, 0x1a, 0x200);

  DBG (2, "- Ops_in_0021()\n");

  return OK;
}

static SANE_Int
Read_Image (SANE_Int buffer_size, SANE_Byte * buffer, SANE_Int * transferred)
{
  SANE_Int rst;
  SANE_Byte mycolormode;

  DBG (2, "+ Read_Image(buffer_size=%i, *buffer, *transferred):\n",
       buffer_size);

  *transferred = 0;
  mycolormode = scan2.colormode;
  rst = ERROR;
  if ((scan2.colormode != CM_COLOR) && (scan2.channel == 3))
    mycolormode = 3;

  if (Resize.type == 0)
    {
      if (arrangeline == FIX_BY_SOFT)
	{
	  switch (mycolormode)
	    {
	    case CM_COLOR:
	      rst = Arrange_Colour (buffer, buffer_size, transferred);
	      break;
	    case 3:
	      rst = fnb250 (buffer, buffer_size, transferred);
	      break;
	    default:
	      rst = Arrange_NonColour (buffer, buffer_size, transferred);
	      break;
	    }
	}
      else
	rst = Read_Block (buffer_size, buffer, transferred);	/*00fe */
    }
  else
    rst = Read_ResizeBlock (buffer, buffer_size, transferred);	/*010d */

  DBG (2, "- Read_Image(*transferred=%i): %i\n", *transferred, rst);

  return rst;
}

static SANE_Int
fnb250 (SANE_Byte * buffer, SANE_Int buffer_size, SANE_Int * transferred)
{
  /*
     0600FA7C   05E10048 buffer
     0600FA80   0000F906 buffer_size
   */
  SANE_Byte *mybuffer = buffer;	/* fa7c */
  SANE_Int mywidth = v158c / 3;	/* fa70 */
  SANE_Int mydistance;		/*ebp */
  SANE_Int mydots;		/*fa74 */
  SANE_Int channel_size;
  SANE_Int c;

  DBG (2, "+ fnb250(*buffer, buffer_size=%i, *transferred):\n", buffer_size);

  channel_size = (scan2.depth == 8) ? 1 : 2;

  if (scanning.imagebuffer == NULL)
    {
      if (sensortype == TOSHIBA)
	mydistance =
	  (sensorlinedistance * scan2.resolution_y) / realsensorresolution;
      else
	mydistance = 0;

      if (mydistance != 0)
	{
	  scanning.bfsize =
	    (use_hightresolution == TRUE) ? use_sensorevenodddist : 0;
	  scanning.bfsize = v158c * (scanning.bfsize + (mydistance * 2) + 1);
	}
      else
	scanning.bfsize = v158c * 2;

      /*b2f0 */
      scanning.imagebuffer =
	(SANE_Byte *) malloc (scanning.bfsize * sizeof (SANE_Byte));
      if (scanning.imagebuffer == NULL)
	return ERROR;

      scanning.imagepointer = scanning.imagebuffer;
      if (Read_Block (scanning.bfsize, scanning.imagebuffer, transferred) ==
	  ERROR)
	return ERROR;

      /* Calculate channel displacements */
      orderchannel = FALSE;
      for (c = CL_RED; c <= CL_BLUE; c++)
	{
	  if (mydistance == 0)
	    {
	      /*b34e */
	      if (use_hightresolution == FALSE)
		{
		  if ((((sensorlinedistance * scan2.resolution_y) * 2) /
		       realsensorresolution) == 1)
		    orderchannel = TRUE;

		  if (orderchannel == TRUE)
		    scanning.desp[c] =
		      ((rgbchannelorder[c] / 2) * v158c) + (channel_size * c);
		  else
		    scanning.desp[c] = channel_size * c;
		}
	    }
	  else
	    {
	      /*b3e3 */
	      scanning.desp[c] =
		(rgbchannelorder[c] * (mydistance * v158c)) +
		(channel_size * c);

	      if (use_hightresolution == TRUE)
		{
		  /*b43b */
		  scanning.desp1[c] = scanning.desp[c];
		  scanning.desp2[c] =
		    ((channel_size * 3) + scanning.desp1[c]) +
		    (use_sensorevenodddist * v158c);
		};
	    }
	}

      for (c = CL_RED; c <= CL_BLUE; c++)
	{
	  if (use_hightresolution == TRUE)
	    {
	      scanning.pColour2[c] = scanning.imagebuffer + scanning.desp2[c];
	      scanning.pColour1[c] = scanning.imagebuffer + scanning.desp1[c];
	    }
	  else
	    scanning.pColour[c] = scanning.imagebuffer + scanning.desp[c];
	}
    }

  /*b545 */
  buffer_size /= mywidth;
  mydots = v158c / (channel_size * 3);

  while (buffer_size > 0)
    {
      if (orderchannel == FALSE)
	{
	  /*b5aa */
	  if (use_hightresolution == TRUE)
	    Triplet_Compose_HRes (scanning.pColour1[CL_RED],
				  scanning.pColour1[CL_GREEN],
				  scanning.pColour1[CL_BLUE],
				  scanning.pColour2[CL_RED],
				  scanning.pColour2[CL_GREEN],
				  scanning.pColour2[CL_BLUE], mybuffer,
				  mydots);
	  else
	    Triplet_Compose_LRes (scanning.pColour[CL_RED],
				  scanning.pColour[CL_GREEN],
				  scanning.pColour[CL_BLUE], mybuffer,
				  mydots);
	}
      else
	Triplet_Compose_Order (scanning.pColour[CL_RED],
			       scanning.pColour[CL_GREEN],
			       scanning.pColour[CL_BLUE], mybuffer, mydots);

      /*b5f8 */
      mybuffer += mywidth;
      v15b8 -= bytesperline;
      if (v15b8 < 0)
	v15bc -= 1;

      buffer_size--;
      if (buffer_size == 0)
	{
	  if ((v15b8 | v15bc) == 0)
	    return OK;
	}

      /*b63f */
      if (Read_Block (v158c, scanning.imagepointer, transferred) == ERROR)
	return ERROR;

      for (c = CL_RED; c <= CL_BLUE; c++)
	{
	  if (use_hightresolution == TRUE)
	    {
	      /*b663 */
	      scanning.desp2[c] =
		(scanning.desp2[c] + v158c) % scanning.bfsize;
	      scanning.desp1[c] =
		(scanning.desp1[c] + v158c) % scanning.bfsize;

	      scanning.pColour2[c] = scanning.imagebuffer + scanning.desp2[c];
	      scanning.pColour1[c] = scanning.imagebuffer + scanning.desp1[c];
	    }
	  else
	    {
	      /*b74a */
	      scanning.desp[c] = (scanning.desp[c] + v158c) % scanning.bfsize;
	      scanning.pColour[c] = scanning.imagebuffer + scanning.desp[c];
	    }
	}

      /*b7be */
      scanning.imagepointer += v158c;
      if (scanning.imagepointer >= (scanning.imagebuffer + scanning.bfsize))
	scanning.imagepointer = scanning.imagebuffer;
    }

  return OK;
}

static void
Triplet_Compose_HRes (SANE_Byte * pRed1, SANE_Byte * pGreen1,
		      SANE_Byte * pBlue1, SANE_Byte * pRed2,
		      SANE_Byte * pGreen2, SANE_Byte * pBlue2,
		      SANE_Byte * buffer, SANE_Int Width)
{
  SANE_Int Value;
  SANE_Int Channel_size;
  SANE_Int max_value;

  DBG (2,
       "> Triplet_Compose_HRes(*pRed1, *pGreen1, *pBlue1, *pRed2 *pGreen2, *pBlue2, *buffer, Width=%i):\n",
       Width);

  Width /= 2;
  Channel_size = (scan2.depth > 8) ? 2 : 1;
  max_value = (1 << scan2.depth) - 1;

  while (Width > 0)
    {
      Value =
	Data_Get (pRed1, Channel_size) + Data_Get (pGreen1,
						   Channel_size) +
	Data_Get (pBlue1, Channel_size);

      Value = min (Value, max_value);

      if (v1600 != NULL)
	{
	  if (scan2.depth > 8)
	    Value = *(v1600 + (Value >> 8)) | _B0 (Value);
	  else
	    Value = *(v1600 + Value);
	}

      Data_Set (Value, buffer, Channel_size);
      buffer += Channel_size;

      Value =
	Data_Get (pRed2, Channel_size) + Data_Get (pGreen2,
						   Channel_size) +
	Data_Get (pBlue2, Channel_size);

      Value = min (Value, max_value);

      if (v1600 != NULL)
	{
	  if (scan2.depth > 8)
	    Value = *(v1600 + (Value >> 8)) | _B0 (Value);
	  else
	    Value = *(v1600 + Value);
	}

      Data_Set (Value, buffer, Channel_size);
      buffer += Channel_size;

      pRed1 += 6 * Channel_size;
      pGreen1 += 6 * Channel_size;
      pBlue1 += 6 * Channel_size;

      pRed2 += 6 * Channel_size;
      pGreen2 += 6 * Channel_size;
      pBlue2 += 6 * Channel_size;

      Width--;
    }
}

static void
Triplet_Compose_Order (SANE_Byte * pRed, SANE_Byte * pGreen,
		       SANE_Byte * pBlue, SANE_Byte * buffer, SANE_Int dots)
{
  SANE_Int Value;

  DBG (2,
       "> Triplet_Compose_Order(*pRed, *pGreen, *pBlue, *buffer, dots=%i):\n",
       dots);

  if (scan2.depth > 8)
    {
      /* c0fe */
      dots = dots / 2;
      while (dots > 0)
	{
	  Value =
	    min (Data_Get (pRed, 2) + Data_Get (pGreen, 2) +
		 Data_Get (pBlue, 2), 0xffff);

	  if (v1600 != NULL)
	    Value = (*(v1600 + (Value >> 8)) << 8) | _B0 (Value);

	  Data_Set (Value, buffer, 2);
	  buffer += 2;
	  pRed += 6;
	  pGreen += 6;
	  pBlue += 6;
	  dots--;
	}
    }
  else
    {
      SANE_Byte *myp1, *myp2, *myp3;

      if (rgbchannelorder[CL_RED] == 1)
	{
	  myp1 = pRed;
	  myp2 = pGreen;
	  myp3 = pBlue;
	}
      else if (rgbchannelorder[CL_GREEN] == 1)
	{
	  myp1 = pGreen;
	  myp2 = pRed;
	  myp3 = pBlue;
	}
      else
	{
	  myp1 = pBlue;
	  myp2 = pRed;
	  myp3 = pGreen;
	}

      while (dots > 0)
	{
	  Value = min (((*myp1 + *(v158c + myp1)) / 2) + *myp2 + *myp3, 0xff);

	  *buffer = (v1600 == NULL) ? _B0 (Value) : *(v1600 + Value);

	  buffer++;
	  myp1 += 3;
	  myp2 += 3;
	  myp3 += 3;
	  dots--;
	}
    }
}

static void
Triplet_Compose_LRes (SANE_Byte * pRed, SANE_Byte * pGreen, SANE_Byte * pBlue,
		      SANE_Byte * buffer, SANE_Int dots)
{
  SANE_Int Value;
  SANE_Int Channel_size;
  SANE_Int max_value;

  DBG (2,
       "> Triplet_Compose_LRes(*pRed, *pGreen, *pBlue, *buffer, dots=%i):\n",
       dots);

  Channel_size = (scan2.depth > 8) ? 2 : 1;
  max_value = (1 << scan2.depth) - 1;

  /*bf59 */
  while (dots > 0)
    {
      Value =
	Data_Get (pRed, Channel_size) + Data_Get (pGreen,
						  Channel_size) +
	Data_Get (pBlue, Channel_size);

      Value = min (Value, max_value);

      if (v1600 != NULL)
	{
	  if (scan2.depth > 8)
	    Value = (*(v1600 + (Value >> 8)) << 8) | _B0 (Value);
	  else
	    Value = _B0 (*(v1600 + Value));
	}

      Data_Set (Value, buffer, Channel_size);

      buffer += Channel_size;
      pRed += Channel_size * 3;
      pGreen += Channel_size * 3;
      pBlue += Channel_size * 3;
      dots--;
    }
}

static void
Triplet_Colour_Order (SANE_Byte * pRed, SANE_Byte * pGreen, SANE_Byte * pBlue,
		      SANE_Byte * buffer, SANE_Int Width)
{
  SANE_Int Value;

  DBG (2,
       "> Triplet_Colour_Order(*pRed, *pGreen, *pBlue, *buffer, Width=%i):\n",
       Width);

  if (scan2.depth > 8)
    {
      Width = Width / 2;
      while (Width > 0)
	{
	  Value = Data_Get (pRed, 2);
	  Data_Set (Value, buffer, 2);

	  Value = Data_Get (pGreen, 2);
	  Data_Set (Value, buffer + 2, 2);

	  Value = Data_Get (pBlue, 2);
	  Data_Set (Value, buffer + 4, 2);

	  pRed += 6;
	  pGreen += 6;
	  pBlue += 6;
	  buffer += 6;
	  Width--;
	}
    }
  else
    {
      SANE_Int Colour;

      if (rgbchannelorder[CL_RED] == 1)
	Colour = CL_RED;
      else if (rgbchannelorder[CL_GREEN] == 1)
	Colour = CL_GREEN;
      else
	Colour = CL_BLUE;

      while (Width > 0)
	{
	  switch (Colour)
	    {
	    case CL_RED:
	      *buffer = (*pRed + *(pRed + v158c)) / 2;
	      *(buffer + 1) = *pGreen;
	      *(buffer + 2) = *pBlue;
	      break;
	    case CL_GREEN:
	      *buffer = *pRed;
	      *(buffer + 1) = ((*pGreen + *(pGreen + v158c)) / 2);
	      *(buffer + 2) = *pBlue;
	      break;
	    case CL_BLUE:
	      *buffer = *pRed;
	      *(buffer + 1) = *pGreen;
	      *(buffer + 2) = ((*pBlue + *(pBlue + v158c)) / 2);
	      break;
	    }

	  pRed += 3;
	  pGreen += 3;
	  pBlue += 3;
	  buffer += 3;

	  Width--;
	}
    }
}

static void
Triplet_Colour_HRes (SANE_Byte * pRed1, SANE_Byte * pGreen1,
		     SANE_Byte * pBlue1, SANE_Byte * pRed2,
		     SANE_Byte * pGreen2, SANE_Byte * pBlue2,
		     SANE_Byte * buffer, SANE_Int Width)
{
  SANE_Int Value;
  SANE_Int channel_size;
  SANE_Int c;
  SANE_Byte *pPointers[6];

  pPointers[0] = pRed1;
  pPointers[1] = pGreen1;
  pPointers[2] = pBlue1;

  pPointers[3] = pRed2;
  pPointers[4] = pGreen2;
  pPointers[5] = pBlue2;

  DBG (2,
       "> Triplet_Colour_HRes(*pRed1, *pGreen1, *pBlue1, *pRed2, *pGreen2, *pBlue2, *buffer, Width=%i):\n",
       Width);

  channel_size = (scan2.depth > 8) ? 2 : 1;

  Width = Width / 2;
  while (Width > 0)
    {
      for (c = 0; c < 6; c++)
	{
	  Value = Data_Get (pPointers[c], channel_size);
	  Data_Set (Value, buffer, channel_size);
	  pPointers[c] += (6 * channel_size);
	  buffer += (channel_size);
	}
      Width--;
    }
}

static void
Triplet_Colour_LRes (SANE_Int Width, SANE_Byte * Buffer,
		     SANE_Byte * pChannel1, SANE_Byte * pChannel2,
		     SANE_Byte * pChannel3)
{
  /*
     05F0FA4C   04EBAE4A  /CALL to Assumed StdFunc6 from hpgt3970.04EBAE45
     05F0FA50   00234FF8  |Arg1 = 00234FF8 pChannel3
     05F0FA54   002359EF  |Arg2 = 002359EF pChannel2
     05F0FA58   002363E6  |Arg3 = 002363E6 pChannel1
     05F0FA5C   05D10048  |Arg4 = 05D10048 Buffer
     05F0FA60   00000352  |Arg5 = 00000352 Width
   */

  /* Esta funcion une los tres canales de color en un triplete
     Inicialmente cada color est separado en 3 buffers apuntados
     por pChannel1 ,2 y 3
   */
  SANE_Int Value;
  SANE_Int channel_size;
  SANE_Int c;
  SANE_Byte *pChannels[3];

  pChannels[0] = pChannel3;
  pChannels[1] = pChannel2;
  pChannels[2] = pChannel1;

  DBG (2, "> Triplet_Colour_LRes(Width=%i, *Buffer2, *p1, *p2, *p3):\n",
       Width);

  channel_size = (scan2.depth > 8) ? 2 : 1;
  while (Width > 0)
    {
      /* ba74 */
      for (c = 0; c < 3; c++)
	{
	  Value = Data_Get (pChannels[c], channel_size);
	  Data_Set (Value, Buffer, channel_size);
	  pChannels[c] += channel_size;
	  Buffer += channel_size;
	}
      Width--;
    }
}

static SANE_Int
Read_ResizeBlock (SANE_Byte * buffer, SANE_Int buffer_size,
		  SANE_Int * transferred)
{
  /*
     buffer      = FA7C   05E30048
     buffer_size = FA80   0000F906
   */

  SANE_Int rst = ERROR;		/* fa68 */
  SANE_Int myresx = scan2.resolution_x;	/* fa6c */
  SANE_Int myimageresx = imageresx;	/* fa70 */
  SANE_Int myresy = scan2.resolution_y;	/* fa64 */
  SANE_Int myimageresy = imageresy;	/* fa74 */
  SANE_Int lfa54;
  SANE_Int lfa58;
  SANE_Byte *pP1;		/* fa5c */
  SANE_Byte *pP2;		/* fa60 */
  SANE_Int bOk;

  DBG (2, "+ Read_ResizeBlock(*buffer, buffer_size=%i, *transferred):\n",
       buffer_size);

  if (Resize.type == 1)
    {
      lfa58 = 0;
      do
	{
	  bOk = 1;
	  if (arrangeline2 == FIX_BY_SOFT)
	    {
	      if (scan2.colormode == CM_COLOR)
		rst = Arrange_Colour (Resize.v3624, v158c, transferred);
	      else
		rst = Arrange_NonColour (Resize.v3624, v158c, transferred);
	    }
	  else
	    rst = Read_Block (v158c, Resize.v3624, transferred);

	  /*f2df */
	  Resize_Line (Resize.v362c, myimageresx, Resize.towidth,
		       Resize.v3624, myresx, Resize.fromwidth, Resize.mode);
	  sresolutiony += myimageresy;
	  if (sresolutiony > myresy)
	    {
	      /*f331 */
	      sresolutiony = sresolutiony - myresy;
	      if (scan2.depth == 8)
		{
		  /* f345 */
		  pP1 = Resize.v3628;
		  pP2 = Resize.v362c;
		  if (Resize.mode == RSZ_LINEART)
		    {
		      /* f36b */
		      SANE_Int bit = 0;
		      /**/ SANE_Int resol = myimageresy;	/* fa60 */
		      SANE_Byte *pP3 = Resize.v362c;
		      SANE_Int value;

		      *buffer = 0;
		      lfa54 = 0;
		      while (lfa54 < Resize.towidth)
			{
			  if (bit == 8)
			    {
			      buffer++;
			      *buffer = 0;
			      pP1++;
			      bit = 0;
			      pP3++;
			    }

			  value =
			    ((*pP1 & (0x80 >> bit)) != 0) ? sresolutiony : 0;
			  if ((*pP3 & (0x80 >> bit)) != 0)
			    value += ((myresy & 0xffff) - sresolutiony);

			  if (value > resol)
			    *buffer |= (0x80 >> bit);

			  bit++;
			  lfa54++;
			}
		    }
		  else
		    {
		      /* f414 */
		      lfa54 = 0;
		      while (lfa54 < Resize.bytesperline)
			{
			  *buffer =
			    _B0 ((((myresy - sresolutiony) * *pP2) +
				  (*pP1 * sresolutiony)) / myresy);
			  pP1++;
			  pP2++;
			  buffer++;
			  lfa54++;
			}
		    }
		}
	      else
		{
		  /* f47d */
		  lfa54 = 0;
		  pP1 = Resize.v3628;
		  pP2 = Resize.v362c;

		  if ((Resize.bytesperline & 0xfffffffe) > 0)
		    {
		      SANE_Int value;
		      do
			{
			  value =
			    (((myresy - sresolutiony) * Data_Get (pP2,
								  2)) +
			     (Data_Get (pP1, 2) * sresolutiony)) / myresy;
			  Data_Set (value, buffer, 2);

			  buffer += 2;
			  pP1 += 2;
			  pP2 += 2;
			  lfa54++;
			}
		      while (lfa54 < (Resize.bytesperline / 2));
		    }
		}
	    }
	  else
	    bOk = 0;
	  /* f4fd f502 */
	  pP1 = Resize.v3628;
	  /* swap pointers */
	  Resize.v3628 = Resize.v362c;
	  Resize.v362c = pP1;
	}
      while (bOk == 0);
    }
  else
    {
      /*f530 */
      /*falta codigo */
      DBG (1, "Seccion de codigo sin finalizar\n");
    }

  DBG (2, "- Read_ResizeBlock(*transferred=%i): %i\n", *transferred, rst);

  return rst;
}

static void
Split_into_12bit_channels (SANE_Byte * destino, SANE_Byte * fuente,
			   SANE_Int size)
{
  /*
     Each letter represents a bit
     abcdefgh 12345678 lmnopqrs << before splitting
     [efgh1234 0000abcd] [lmnopqrs 00005678]  << after splitting, in memory
     [0000abcd efgh1234] [00005678 lmnopqrs]  << resulting channels
   */

  SANE_Int C;

  DBG (2, "> Split_into_12bit_channels(*destino, *fuente, size=%i\n", size);

  if ((destino != NULL) && (fuente != NULL))
    {
      if ((size - (size & 0x03)) != 0)
	{
	  C = (size - (size & 0x03) + 3) / 4;
	  do
	    {
	      *destino = _B0 ((*(fuente + 1) >> 4) + (*fuente << 4));
	      *(destino + 1) = _B0 (*fuente >> 4);
	      *(destino + 2) = _B0 (*(fuente + 2));
	      *(destino + 3) = *(fuente + 1) & 0x0f;
	      destino += 4;
	      fuente += 3;
	      C--;
	    }
	  while (C > 0);
	}

      if ((size & 0x03) != 0)
	{
	  *destino = _B0 ((*(fuente + 1) >> 4) + (*fuente << 4));
	  *(destino + 1) = _B0 (*fuente >> 4);
	}
    }
}

static SANE_Int
Read_NonColor_Block (SANE_Byte * buffer, SANE_Int buffer_size,
		     SANE_Byte ColorMode, SANE_Int * transferred)
{
  /* FA50   05DA0048 buffer
     FA54   0000F906 buffer_size
     FA58   00       ColorMode
   */

  SANE_Int rst = OK;
  SANE_Int lfa38 = 0;
  SANE_Byte *lfa24 = v1600;
  SANE_Int lfa20;
  SANE_Int C;
  SANE_Int mysize;
  SANE_Byte *mybuffer;

  DBG (2, "+ Read_NonColor_Block(*buffer, buffer_size=%i, ColorMode=%i):\n",
       buffer_size, ColorMode);

  if (ColorMode != CM_GRAY)
    {
      /* Lineart mode */
      if ((lineart_width & 7) != 0)
	lfa38 = 8 - (lineart_width & 7);
      lfa20 = (lineart_width + 7) / 8;
    }
  else
    lfa20 = v158c;
  /*61b2 */

  mysize = (buffer_size / lfa20) * bytesperline;
  mybuffer = (SANE_Byte *) malloc (mysize * sizeof (SANE_Byte));	/*fa40 */
  if (mybuffer != NULL)
    {
      SANE_Int LinesCount;
      SANE_Int mysize4lines;
      SANE_Byte *pBuffer = buffer;
      SANE_Byte *pImage = NULL;	/* fa30 */
      SANE_Byte *pbackup = NULL;	/* fa30 */
      SANE_Int puntero;
      SANE_Int value;
      do
	{
	  mysize4lines =
	    (mysize <= Reading.Size4Lines) ? mysize : Reading.Size4Lines;
	  LinesCount = mysize4lines / bytesperline;

	  if (ColorMode == CM_GRAY)
	    {
	      if (scan2.depth == 16)
		{
		  /* 6224 */
		  /*GRAY Bit mode 16 */
		  rst =
		    Scan_Read_BufferA (mysize4lines, 0, mybuffer,
				       transferred);
		  if (rst == ERROR)
		    break;

		  /* Apply gamma value if neccesary */
		  pImage = mybuffer;
		  if (lfa24 == NULL)
		    {
		      /* No gamma tables */
		      pBuffer += LinesCount * lfa20;
		      while (LinesCount > 0)
			{
			  C = 0;
			  if ((v158c & 0xfffffffe) != 0)
			    {
			      pbackup = pImage;
			      do
				{
				  Data_Set (Data_Get (pImage, 2), pBuffer, 2);
				  pImage += 2;
				  pBuffer += 2;
				  C++;
				}
			      while (C < (v158c / 2));
			    }
			  /* 6299 */
			  pImage = pbackup + bytesperline;
			  LinesCount--;
			}
		    }
		  else
		    {
		      /* use gamma tables */
		      pBuffer += LinesCount * lfa20;
		      while (LinesCount > 0)
			{
			  C = 0;
			  if ((v158c & 0xfffffffe) != 0)
			    {
			      pbackup = pImage;
			      do
				{
				  value = Data_Get (pImage, 2);
				  value += (*lfa24 << 0x08);
				  Data_Set (value, pBuffer, 2);
				  pBuffer += 2;
				  pImage += 2;
				  C++;
				}
			      while (C < (v158c / 2));
			    }
			  /* 631f */
			  pImage = pbackup + bytesperline;
			  LinesCount--;
			}
		    }
		}
	      else if (scan2.depth == 12)
		{
		  /* 633b */
		  /*GRAY Bit mode 12 */
		  rst =
		    Scan_Read_BufferA ((mysize4lines * 3) / 4, 0, mybuffer,
				       transferred);
		  if (rst == ERROR)
		    break;

		  pImage = mybuffer;
		  pBuffer += LinesCount * lfa20;
		  while (LinesCount > 0)
		    {
		      Split_into_12bit_channels (mybuffer, pImage, v158c);
		      pImage += (bytesperline * 3) / 4;
		      LinesCount--;
		    }
		}
	      else
		{
		  /* 63ab */
		  /*GRAY Bit mode 8 */
		  rst =
		    Scan_Read_BufferA (mysize4lines, 0, mybuffer,
				       transferred);
		  if (rst == ERROR)
		    break;

		  /* 63c1 */
		  /* Apply gamma value if neccesary */
		  pImage = mybuffer;
		  if (lfa24 == NULL)
		    {
		      /* No gamma tables */
		      while (LinesCount > 0)
			{
			  if (v158c > 0)
			    {
			      puntero = 0;
			      do
				{
				  *pBuffer = *(pImage + puntero);
				  pBuffer++;
				  puntero++;
				}
			      while (puntero < v158c);
			    }
			  pImage += bytesperline;
			  LinesCount--;
			}
		    }
		  else
		    {
		      /*63f7 */
		      while (LinesCount > 0)
			{
			  if (v158c > 0)
			    {
			      puntero = 0;
			      do
				{
				  *pBuffer = *(lfa24 + *(pImage + puntero));
				  pBuffer++;
				  puntero++;
				}
			      while (puntero < v158c);
			    }
			  pImage += bytesperline;
			  LinesCount--;
			}
		    }
		}
	    }
	  else
	    {
	      /*6429 */
	      /* LINEART */
	      SANE_Int desp;
	      rst =
		Scan_Read_BufferA (mysize4lines, 0, mybuffer, transferred);
	      if (rst == ERROR)
		break;

	      pImage = mybuffer;
	      while (LinesCount > 0)
		{
		  if (lineart_width > 0)
		    {
		      desp = 0;
		      do
			{
			  if ((desp % 7) == 0)
			    *pBuffer = 0;

			  /* making a byte bit per bit */
			  *pBuffer = *pBuffer << 1;

			  /* bit 1 if data is under thresholdh value */
			  if (*(pImage + desp) >= binarythresholdh)	/* binarythresholdh = 0x0c */
			    *pBuffer = *pBuffer | 1;

			  desp++;
			  if ((desp % 7) == 0)
			    pBuffer++;

			}
		      while (desp < lineart_width);
		    }
		  if (lfa38 != 0)
		    {
		      *pBuffer = (*pBuffer << lfa38);
		      pBuffer++;
		    }
		  /* 64b0 */
		  pImage += bytesperline;
		  LinesCount--;
		}
	    }
	  /* 64c0 */
	  mysize -= mysize4lines;
	}
      while ((mysize > 0) && (Reading.Cancel == FALSE));

      free (mybuffer);
    }
  else
    rst = ERROR;

  DBG (2, "- Read_NonColor_Block(*transferred=%i): %i\n", *transferred, rst);

  return rst;
}

static SANE_Int
Read_Block (SANE_Int buffer_size, SANE_Byte * buffer, SANE_Int * transferred)
{
  /*
     SANE_Int buffer_size          fa80
     SANE_Byte *buffer    fa7c
   */
/*
scan2:
04F0155C  01 08 00 02 03 00 58 02  ..X
04F01564  58 02 58 02 C5 00 00 00  XX...
04F0156C  B4 07 00 00 8B 01 00 00  ....
04F01574  10 06 00 00 EC 13 00 00  ....
04F0157C  B2 07 00 00 B4 07 00 00  ....
04F01584  CF 08 00 00              ..

arrangeline2 = 1
*/
  SANE_Int rst, LinesCount;
  SANE_Int mysize;
  SANE_Byte *readbuffer = NULL;
  SANE_Byte *pImage = NULL;

  DBG (2, "+ Read_Block(buffer_size=%i, *buffer):\n", buffer_size);

  rst = ERROR;
  *transferred = 0;

  if ((scan2.colormode != CM_COLOR) && (scan2.channel == 3)
      && (arrangeline2 != FIX_BY_SOFT))
    {
      /*6510 */
      return Read_NonColor_Block (buffer, buffer_size, scan2.colormode,
				  transferred);
    }

  /*6544 */
  mysize = (buffer_size / v158c) * bytesperline;
  readbuffer = (SANE_Byte *) malloc (mysize * sizeof (SANE_Byte));
  pImage = buffer;

  if (readbuffer != NULL)
    {
      do
	{
	  buffer_size =
	    (Reading.Size4Lines < mysize) ? Reading.Size4Lines : mysize;
	  LinesCount = buffer_size / bytesperline;

	  if (scan2.depth == 12)
	    {
	      /*rst = Scan_Read_BufferA((Reading.Size4Lines * 3) / 4, 0, readbuffer, transferred); */
	      rst =
		Scan_Read_BufferA (buffer_size, 0, readbuffer, transferred);
	      if (rst == OK)
		{
		  if (LinesCount > 0)
		    {
		      SANE_Byte *destino, *fuente;
		      destino = buffer;
		      fuente = readbuffer;
		      do
			{
			  Split_into_12bit_channels (destino, fuente, v158c);
			  destino += v158c;
			  fuente += (bytesperline * 3) / 4;
			  LinesCount--;
			}
		      while (LinesCount > 0);
		    }
		}
	      else
		break;
	    }
	  else
	    {
	      /*65d9 */
	      rst =
		Scan_Read_BufferA (buffer_size, 0, readbuffer, transferred);
	      if (rst == OK)
		{
		  memcpy (pImage, readbuffer, *transferred);
		  pImage += *transferred;
		}
	      else
		break;
	    }
	  /*6629 */
	  mysize -= buffer_size;
	}
      while ((mysize > 0) && (Reading.Cancel == FALSE));

      free (readbuffer);
    }

  DBG (2, "- Read_Block(*transferred=%i): %i\n", *transferred, rst);

  return rst;
}

static SANE_Int
Scan_Read_BufferA (SANE_Int buffer_size, SANE_Int arg2, SANE_Byte * pBuffer,
		   SANE_Int * bytes_transfered)
{
  SANE_Int rst = OK;
  SANE_Byte *ptBuffer = NULL;
  SANE_Byte *ptImg = NULL;

  DBG (2,
       "+ Scan_Read_BufferA(buffer_size=%i, arg2, *pBuffer, *bytes_transfered):\n",
       buffer_size);

  arg2 = arg2;			/* silence gcc */
  *bytes_transfered = 0;

  if (pBuffer != NULL)
    {
      ptBuffer = pBuffer;

      while ((buffer_size > 0) && (rst == OK) && (Reading.Cancel == FALSE))
	{
	  /* Check if we've already started */
	  if (Reading.Starting == TRUE)
	    {
	      /* Get channels per dot and channel's size in bytes */
	      SANE_Byte data;

	      Reading.Channels_per_dot = 1;
	      if (Read_Byte (0xe812, &data) == OK)
		{
		  data = data >> 6;
		  if (data != 0)
		    Reading.Channels_per_dot = data;
		}

	      Reading.Channel_size = 1;
	      if (Read_Byte (0xee0b, &data) == OK)
		if (((data & 0x40) != 0) && ((data & 0x08) == 0))
		  Reading.Channel_size = 2;

	      Reading.RDStart = Reading.DMABuffer;
	      Reading.RDSize = 0;
	      Reading.DMAAmount = 0;
	      Reading.Starting = FALSE;
	    }

	  /* Is there any data to read from scanner? */
	  if ((Reading.ImageSize > 0) && (Reading.RDSize == 0))
	    {
	      /* Try to read from scanner all possible data to fill DMABuffer */
	      if (Reading.RDSize < Reading.DMABufferSize)
		{
		  SANE_Int iAmount, dofree;

		  /* Check if we have already notify buffer size */
		  if (Reading.DMAAmount <= 0)
		    {
		      /* Initially I suppose that I can read all image */
		      iAmount = min (Reading.ImageSize, Reading.Max_Size);
		      Reading.DMAAmount =
			((dmasetlength * 2) / iAmount) * iAmount;
		      Reading.DMAAmount =
			min (Reading.DMAAmount, Reading.ImageSize);
		      Notify_BufferSize_to_read (0, Reading.DMAAmount);
		      iAmount =
			min (iAmount, Reading.DMABufferSize - Reading.RDSize);
		    }
		  else
		    {
		      iAmount = min (Reading.DMAAmount, Reading.ImageSize);
		      iAmount = min (iAmount, Reading.Max_Size);
		    }

		  /* Allocate buffer to read image if it's necessary */
		  if ((Reading.RDSize == 0) && (iAmount <= buffer_size))
		    {
		      ptImg = ptBuffer;
		      dofree = FALSE;
		    }
		  else
		    {
		      ptImg =
			(SANE_Byte *) malloc (iAmount * sizeof (SANE_Byte));
		      dofree = TRUE;
		    }

		  if (ptImg != NULL)
		    {
		      /* We must wait for scanner to get data */
		      SANE_Int opStatus, sc;

		      sc = (iAmount < Reading.Max_Size) ? TRUE : FALSE;
		      opStatus =
			Wait_for_desired_size (Reading.Channels_per_dot,
					       Reading.Channel_size, iAmount,
					       &Reading.Bytes_Available, 5,
					       sc);

		      /* If something fails, perhaps we can read some bytes... */
		      if (opStatus != OK)
			{
			  if (Reading.Bytes_Available > 0)
			    iAmount = Reading.Bytes_Available;
			  else
			    rst = ERROR;
			}

		      if (rst == OK)
			{
			  /* Try to read from scanner */
			  SANE_Int transferred = 0;
			  opStatus =
			    Bulk_Operation (1, iAmount, ptImg, &transferred);

			  DBG (2, "> Scan_Read_BufferA: Bulk read %i bytes\n",
			       transferred);

			  /*if something fails may be we can read some bytes */
			  iAmount = (SANE_Int) transferred;
			  if (iAmount != 0)
			    {
			      /* Lets copy data into DMABuffer if it's necessary */
			      if (ptImg != ptBuffer)
				{
				  SANE_Byte *ptDMABuffer;

				  ptDMABuffer =
				    Reading.RDStart + Reading.RDSize;
				  if ((ptDMABuffer - Reading.DMABuffer) >=
				      Reading.DMABufferSize)
				    ptDMABuffer -= Reading.DMABufferSize;

				  if ((ptDMABuffer + iAmount) >=
				      (Reading.DMABuffer +
				       Reading.DMABufferSize))
				    {
				      SANE_Int rest =
					iAmount - (Reading.DMABufferSize -
						   (ptDMABuffer -
						    Reading.DMABuffer));
				      memcpy (ptDMABuffer, ptImg,
					      iAmount - rest);
				      memcpy (Reading.DMABuffer,
					      ptImg + (iAmount - rest), rest);
				    }
				  else
				    memcpy (ptDMABuffer, ptImg, iAmount);
				  Reading.RDSize += iAmount;
				}
			      else
				{
				  *bytes_transfered += iAmount;
				  buffer_size -= iAmount;
				}

			      Reading.DMAAmount -= iAmount;
			      Reading.ImageSize -= iAmount;
			    }
			  else
			    rst = ERROR;
			}

		      /* Lets free buffer */
		      if (dofree == TRUE)
			{
			  free (ptImg);
			  ptImg = NULL;
			}
		    }
		  else
		    rst = ERROR;
		}
	    }

	  /* is there any data read from scanner? */
	  if (Reading.RDSize > 0)
	    {
	      /* Add to the given buffer so many bytes as posible */
	      SANE_Int iAmount;

	      iAmount = min (buffer_size, Reading.RDSize);
	      if ((Reading.RDStart + iAmount) >=
		  (Reading.DMABuffer + Reading.DMABufferSize))
		{
		  SANE_Int rest =
		    Reading.DMABufferSize - (Reading.RDStart -
					     Reading.DMABuffer);
		  memcpy (ptBuffer, Reading.RDStart, rest);
		  memcpy (ptBuffer + rest, Reading.DMABuffer, iAmount - rest);
		  Reading.RDStart = Reading.DMABuffer + (iAmount - rest);
		}
	      else
		{
		  memcpy (ptBuffer, Reading.RDStart, iAmount);
		  Reading.RDStart += iAmount;
		}

	      ptBuffer += iAmount;
	      Reading.RDSize -= iAmount;
	      buffer_size -= iAmount;
	      *bytes_transfered += iAmount;

	      /* if there isn't any data in DMABuffer we can point RDStart
	         to the begining of DMABuffer */
	      if (Reading.RDSize == 0)
		Reading.RDStart = Reading.DMABuffer;
	    }

	  /* in case of all data is read we return OK with bytes_transfered = 0 */
	  if ((*bytes_transfered == 0)
	      || ((Reading.RDSize == 0) && (Reading.ImageSize == 0)))
	    break;
	}

      if (rst == ERROR)
	IWrite_Word (0x0000, 0, 0x600);
    }

  DBG (2, "->   *bytes_transfered=%i\n", *bytes_transfered);
  DBG (2, "->   Reading.ImageSize=%i\n", Reading.ImageSize);
  DBG (2, "->   Reading.DMAAmount=%i\n", Reading.DMAAmount);
  DBG (2, "->   Reading.RDSize   =%i\n", Reading.RDSize);

  DBG (2, "- Scan_Read_BufferA: %i\n", rst);

  return rst;
}

static SANE_Int
Get_Scanner_Buffer_Size (SANE_Byte channels_per_dot, SANE_Int channel_size)
{
  SANE_Int rst;
  SANE_Int myAmount;

  DBG (2,
       "+ Get_Scanner_Buffer_Size(channels_per_dot=%i, channel_size=%i):\n",
       channels_per_dot, channel_size);

  rst = 0;

  if (v360c != 0)
    {
      if (channels_per_dot < 1)
	{
	  if (Read_Byte (0xe812, &channels_per_dot) == OK)
	    channels_per_dot = _B0 (channels_per_dot >> 6);

	  if (channels_per_dot == 0)
	    channels_per_dot++;
	}

      if (Read_Integer (0xef16, &myAmount) == OK)
	{
	  if (channel_size > 0)
	    rst = ((channels_per_dot * 32) / channel_size) * myAmount;
	}
      else
	v3618 = 1;
    }

  DBG (2, "- Get_Scanner_Buffer_Size: %i\n", rst);

  return rst;
}

static SANE_Int
Lamp_Warmup (SANE_Byte * Regs, SANE_Int lamp)
{
  SANE_Int rst = OK;
  SANE_Byte flb_lamp, tma_lamp;

  DBG (2, "+ Lamp_Warmup(*Regs, lamp=%i)\n", lamp);

  if (Regs != NULL)
    {
      SANE_Int overdrivetime;

      Lamp_GetStatus (&flb_lamp, &tma_lamp);

      if (lamp == FLB_LAMP)
	{
	  overdrivetime =
	    get_value (PLATFORM, OVERDRIVETIME_FLB, 0x2710, FITCALIBRATE);

	  if (flb_lamp == 0)
	    {
	      /* FLB-Lamp is turned off, lets turn on */
	      Lamp_SetStatus (Regs, TRUE, FLB_LAMP - 1);
	      Lamp_OverDrive (overdrivetime, FLB_LAMP);
	      waitforpwm = TRUE;
	    }
	  else
	    {
	      if (waitforpwm != FALSE)
		Lamp_OverDrive (overdrivetime, FLB_LAMP);
	    }
	}
      else
	{
	  overdrivetime =
	    get_value (PLATFORM, OVERDRIVETIME_TA, 0x2710, FITCALIBRATE);

	  if (tma_lamp == 0)
	    {
	      /* tma lamp is turned off */
	      if (RTS_isTmaAttached () == TRUE)
		{
		  Lamp_SetStatus (Regs, FALSE, TMA_LAMP - 1);
		  Lamp_OverDrive (overdrivetime, TMA_LAMP);
		  waitforpwm = TRUE;
		}
	      else
		rst = ERROR;
	    }
	  else
	    {
	      if (waitforpwm != FALSE)
		Lamp_OverDrive (overdrivetime, TMA_LAMP);
	    }
	}
    }
  else
    rst = ERROR;

  DBG (2, "- Lamp_Warmup: %i\n", rst);

  return rst;
}

static SANE_Int
Start_Scan ()
{
  SANE_Int rst;

  DBG (2, "+ Start_Scan:\n");

  rst = ERROR;
  if (RTS_Enable_CCD (BGeneral, 0x0f) == OK)
    {
      SANE_Byte Regs[0x71a], data, mlock;
      SANE_Int cl, lfaa0, ypos, xpos, runb1, gainmode;
      struct st_scanparams scancfg;
      struct st_hwdconfig hwdcfg;
      struct st_calibration myCalib;
      long tick;

      memcpy (&Regs, &BGeneral, 0x71a * sizeof (SANE_Byte));
      memcpy (&scancfg, &scan, sizeof (struct st_scanparams));

      show_ScanParams (&scancfg);

/*
Regs:
04EFF7F8  05 54 00 00 00 00 00 00  T......
04EFF800  00 00 00 00 00 00 00 00  ........
04EFF808  EC 3F E4 80 00 00 00 60  ?...`
04EFF810  60 60 00 00 00 00 00 00  ``......
04EFF818  00 00 00 00 00 00 50 1B  ......P
04EFF820  18 24 10 00 00 00 00 00  $.....
04EFF828  90 0B 00 90 0B 00 00 00  ....
04EFF830  00 90 0B 00 00 00 00 90  .....
04EFF838  0B 00 00 00 00 04 04 0F  ....
04EFF840  00 00 00 00 20 00 00 00  .... ...
04EFF848  00 00 00 10 00 00 2E 00  .......
04EFF850  00 00 00 00 00 F0 FF FF  .....
04EFF858  3F 00 00 00 00 00 00 F0  ?......
04EFF860  FF FF 3F 00 00 00 00 00  ?.....
04EFF868  00 F0 03 3F 20 00 00 00  .? ...
04EFF870  00 00 00 00 FC C0 3F 00  ....?.
04EFF878  00 00 00 00 00 00 00 00  ........
04EFF880  00 00 01 00 00 00 10 01  .....
04EFF888  00 00 04 05 14 15 17 00  ...
04EFF890  80 87 87 07 00 00 00 00  ....
04EFF898  00 00 00 00 00 00 00 00  ........
04EFF8A0  00 00 00 00 00 00 3F E7  ......?
04EFF8A8  84 00 04 00 02 88 00 00  ....
04EFF8B0  00 82 02 11 00 00 00 20  ....
04EFF8B8  01 00 00 00 00 00 00 00  .......
04EFF8C0  00 00 00 00 00 00 00 00  ........
04EFF8C8  10 00 A0 00 00 00 08 1E  ....
04EFF8D0  80 14 02 FF 00 00 00 00  ....
04EFF8D8  0F F8 2A 00 B8 00 00 B8  *...
04EFF8E0  00 00 00 00 00 10 00 00  .......
04EFF8E8  00 00 00 E8 03 00 00 00  ......
04EFF8F0  12 03 00 00 12 03 12 03  ..
04EFF8F8  00 00 12 03 FF 90 B0 D4  ..
04EFF900  D0 70 50 54 30 10 14 38  pPT08
04EFF908  18 0C 08 28 04 00 20 44  .(. D
04EFF910  40 E0 C0 C4 A0 80 84 A8  @Ġ
04EFF918  88 9C 98 B8 94 0F 00 00  ..
04EFF920  00 00 00 00 00 00 00 00  ........
04EFF928  00 00 00 00 00 00 00 00  ........
04EFF930  00 00 00 00 00 00 00 00  ........
04EFF938  00 00 00 00 00 00 C9 22  ......"
04EFF940  56 00 00 00 00 00 01 10  V.....
04EFF948  FF 13 00 00 30 01 F0 FD  ..0
04EFF950  0F 00 00 00 00 00 00 00  .......
04EFF958  00 00 00 40 E0 8C 0B 0B  ...@
04EFF960  3F E5 00 00 00 00 00 00  ?......
04EFF968  00 00 00 00 00 00 00 00  ........
04EFF970  00 00 00 00 00 00 00 00  ........
04EFF978  99 99 99 99 99 88 88 88  
04EFF980  01 00 00 00 00 00 00 99  ......
04EFF988  00 00 00 00 00 00 00 00  ........
04EFF990  00 00 00 00 00 00 7F 00  .......
04EFF998  80 00 20 20 00 00 07 C0  .  ..
04EFF9A0  02 02 00 90 11 00 90 45  ..E
04EFF9A8  10 61 40 03 40 12 08 00  a@@.
04EFF9B0  81 20 00 00 00 14 0A 00   .....
04EFF9B8  0C 88 0C 00 74 00 84 00  ...t..
04EFF9C0  80 00 00 00 00 00 00 00  .......
04EFF9C8  00 00 00 00 00 00 00 00  ........
04EFF9D0  0C 00 00 00 00 00 00 00  ........
04EFF9D8  09 00 00 00 00 00 00 00  ........
04EFF9E0  00 00 00 00 00 00 00 00  ........
04EFF9E8  00 00 00 00 00 00 00 00  ........
04EFF9F0  00 00 00 00 00 00 00 00  ........
04EFF9F8  00 00 00 00 00 00 00 00  ........
04EFFA00  00 00 00 00 00 00 00 00  ........
04EFFA08  00 00 00 00 00 00 00 00  ........
04EFFA10  00 00 00 00 00 00 00 00  ........
04EFFA18  00 00 00 00 00 00 00 00  ........
04EFFA20  00 00 00 00 00 00 00 00  ........
04EFFA28  00 00 00 00 00 00 00 00  ........
04EFFA30  00 00 00 00 00 00 00 00  ........
04EFFA38  00 00 00 00 00 00 00 00  ........
04EFFA40  00 00 00 00 00 00 00 00  ........
04EFFA48  00 00 00 00 00 00 00 00  ........
04EFFA50  00 00 00 00 00 00 00 00  ........
04EFFA58  00 00 00 00 00 00 00 00  ........
04EFFA60  00 00 00 00 00 00 00 00  ........
04EFFA68  00 00 00 00 00 00 00 00  ........
04EFFA70  00 00 00 00 00 00 00 00  ........
04EFFA78  00 00 00 00 00 00 00 00  ........
04EFFA80  00 00 00 00 00 00 00 00  ........
04EFFA88  00 00 00 00 00 00 00 00  ........
04EFFA90  00 00 00 00 00 00 00 00  ........
04EFFA98  00 00 00 00 00 00 00 00  ........
04EFFAA0  00 00 00 00 00 00 00 00  ........
04EFFAA8  00 00 00 00 00 00 00 00  ........
04EFFAB0  00 00 00 00 00 00 00 00  ........
04EFFAB8  00 00 00 00 00 00 00 00  ........
04EFFAC0  00 00 00 00 00 00 00 00  ........
04EFFAC8  00 00 00 00 00 00 00 00  ........
04EFFAD0  00 00 00 00 00 00 00 00  ........
04EFFAD8  00 00 00 00 00 00 00 00  ........
04EFFAE0  00 00 00 00 00 00 00 00  ........
04EFFAE8  00 00 00 00 00 00 00 00  ........
04EFFAF0  00 00 00 00 00 00 00 00  ........
04EFFAF8  00 00 00 00 00 00 00 00  ........
04EFFB00  00 00 00 00 00 00 00 00  ........
04EFFB08  00 00 00 00 00 00 00 00  ........
04EFFB10  00 00 00 00 00 00 00 00  ........
04EFFB18  00 00 00 00 00 00 00 00  ........
04EFFB20  00 00 00 00 00 00 00 00  ........
04EFFB28  00 00 00 00 00 00 00 00  ........
04EFFB30  00 00 00 00 00 00 00 00  ........
04EFFB38  00 00 00 00 00 00 00 00  ........
04EFFB40  00 00 00 00 00 00 00 00  ........
04EFFB48  00 00 00 00 00 00 00 00  ........
04EFFB50  00 00 00 00 00 00 00 00  ........
04EFFB58  00 00 00 00 00 00 00 00  ........
04EFFB60  00 00 00 00 00 00 00 00  ........
04EFFB68  00 00 00 00 00 00 00 00  ........
04EFFB70  00 00 00 00 00 00 00 00  ........
04EFFB78  00 00 00 00 00 00 00 00  ........
04EFFB80  00 00 00 00 00 00 00 00  ........
04EFFB88  00 00 00 00 00 00 00 00  ........
04EFFB90  00 00 00 00 00 00 00 00  ........
04EFFB98  00 00 00 00 00 00 00 00  ........
04EFFBA0  00 00 00 00 00 00 00 00  ........
04EFFBA8  00 00 00 00 00 00 00 00  ........
04EFFBB0  00 00 00 00 00 00 00 00  ........
04EFFBB8  00 00 00 00 00 00 00 00  ........
04EFFBC0  00 00 00 00 00 00 00 00  ........
04EFFBC8  00 00 00 00 00 00 00 00  ........
04EFFBD0  00 00 00 00 00 00 00 00  ........
04EFFBD8  00 00 00 00 00 00 00 00  ........
04EFFBE0  00 00 00 00 00 00 00 00  ........
04EFFBE8  00 00 00 00 00 00 00 00  ........
04EFFBF0  00 00 00 00 00 00 00 00  ........
04EFFBF8  00 00 00 00 00 00 00 00  ........
04EFFC00  00 00 00 00 00 00 00 00  ........
04EFFC08  00 00 00 00 00 00 00 00  ........
04EFFC10  00 00 00 00 00 00 00 00  ........
04EFFC18  00 00 00 00 00 00 00 00  ........
04EFFC20  00 00 00 00 00 00 00 00  ........
04EFFC28  00 00 00 00 00 00 00 00  ........
04EFFC30  00 00 00 00 00 00 00 00  ........
04EFFC38  00 00 00 00 00 00 00 00  ........
04EFFC40  00 00 00 00 00 00 00 00  ........
04EFFC48  00 00 00 00 00 00 00 00  ........
04EFFC50  00 00 00 00 00 00 00 00  ........
04EFFC58  00 00 00 00 00 00 00 00  ........
04EFFC60  00 00 00 00 00 00 00 00  ........
04EFFC68  00 00 00 00 00 00 00 00  ........
04EFFC70  00 00 00 00 00 00 00 00  ........
04EFFC78  00 00 00 00 00 00 00 00  ........
04EFFC80  00 00 00 00 00 00 00 00  ........
04EFFC88  00 00 00 00 00 00 00 00  ........
04EFFC90  00 00 00 00 00 00 00 00  ........
04EFFC98  00 00 00 00 00 00 00 00  ........
04EFFCA0  00 00 00 00 00 00 00 00  ........
04EFFCA8  00 00 00 00 00 00 00 00  ........
04EFFCB0  00 00 00 00 00 00 00 00  ........
04EFFCB8  00 00 00 00 00 00 00 00  ........
04EFFCC0  00 00 00 00 00 00 00 00  ........
04EFFCC8  00 00 00 00 00 00 00 00  ........
04EFFCD0  00 00 00 00 00 00 00 00  ........
04EFFCD8  00 00 00 00 00 00 00 00  ........
04EFFCE0  00 00 00 00 00 00 00 00  ........
04EFFCE8  00 00 00 00 00 00 00 00  ........
04EFFCF0  00 00 00 00 00 00 00 00  ........
04EFFCF8  00 00 00 00 00 00 00 00  ........
04EFFD00  00 00 00 00 00 00 00 00  ........
04EFFD08  00 00 00 00 00 00 00 00  ........
04EFFD10  00 00 00 00 00 00 00 00  ........
04EFFD18  00 00 00 00 00 00 00 00  ........
04EFFD20  00 00 00 00 00 00 00 00  ........
04EFFD28  00 00 00 00 00 00 00 00  ........
04EFFD30  00 00 00 00 00 00 00 00  ........
04EFFD38  00 00 00 00 00 00 00 00  ........
04EFFD40  00 00 00 00 00 00 00 00  ........
04EFFD48  00 00 00 00 00 00 00 00  ........
04EFFD50  00 00 00 00 00 00 00 00  ........
04EFFD58  00 00 00 00 00 00 00 00  ........
04EFFD60  00 00 00 00 00 00 00 00  ........
04EFFD68  00 00 00 00 00 00 00 00  ........
04EFFD70  00 00 00 00 00 00 00 00  ........
04EFFD78  00 00 00 00 00 00 00 00  ........
04EFFD80  00 00 00 00 00 00 00 00  ........
04EFFD88  00 00 00 00 00 00 00 00  ........
04EFFD90  00 00 00 00 00 00 00 00  ........
04EFFD98  00 00 00 00 00 00 00 00  ........
04EFFDA0  00 00 00 00 00 00 00 00  ........
04EFFDA8  00 00 00 00 00 00 00 00  ........
04EFFDB0  00 00 00 00 00 00 00 00  ........
04EFFDB8  00 00 00 00 00 00 00 00  ........
04EFFDC0  00 00 00 00 00 00 00 00  ........
04EFFDC8  00 00 00 00 00 00 00 00  ........
04EFFDD0  00 00 00 00 00 00 00 00  ........
04EFFDD8  00 00 00 00 00 00 00 00  ........
04EFFDE0  00 00 00 00 00 00 00 00  ........
04EFFDE8  00 00 00 00 00 00 00 00  ........
04EFFDF0  00 00 00 00 00 00 00 00  ........
04EFFDF8  00 00 02 00 00 00 00 00  .......
04EFFE00  00 2C 24 00 00 00 00 00  .,$.....
04EFFE08  00 00 00 00 00 00 00 00  ........
04EFFE10  00 00 00 00 00 00 00 00  ........
04EFFE18  00 00 00 00 00 00 00 00  ........
04EFFE20  00 00 00 00 00 00 00 00  ........
04EFFE28  00 00 00 00 00 00 00 00  ........
04EFFE30  00 00 00 00 00 00 00 00  ........
04EFFE38  00 00 00 00 00 00 00 00  ........
04EFFE40  00 00 00 00 00 00 00 00  ........
04EFFE48  00 00 00 00 00 00 00 00  ........
04EFFE50  00 00 00 00 00 00 00 00  ........
04EFFE58  00 00 00 00 00 00 00 00  ........
04EFFE60  00 00 00 00 00 00 00 00  ........
04EFFE68  00 00 00 00 00 00 00 00  ........
04EFFE70  00 00 00 00 00 00 00 00  ........
04EFFE78  00 00 00 00 00 00 00 00  ........
04EFFE80  00 00 00 00 00 00 00 00  ........
04EFFE88  00 00 00 00 00 00 00 00  ........
04EFFE90  00 00 00 00 00 00 00 00  ........
04EFFE98  00 00 00 00 00 00 00 00  ........
04EFFEA0  00 00 00 00 00 00 00 00  ........
04EFFEA8  00 00 00 00 00 00 00 00  ........
04EFFEB0  00 00 00 00 00 00 00 00  ........
04EFFEB8  00 00 00 00 00 00 00 00  ........
04EFFEC0  00 00 00 00 00 00 00 00  ........
04EFFEC8  00 00 00 00 00 00 00 00  ........
04EFFED0  00 00 00 00 00 00 00 00  ........
04EFFED8  00 00 00 00 00 00 00 00  ........
04EFFEE0  00 00 00 00 00 00 00 00  ........
04EFFEE8  00 00 00 00 00 00 00 00  ........
04EFFEF0  00 00 00 00 00 00 00 00  ........
04EFFEF8  00 00 00 00 00 00 00 00  ........
04EFFF00  08 01 00 00 00 00 00 00  ......
04EFFF08  00 00 00 00 00 00 00 00  ........
04EFFF10  00 00 00 00              ....

scancfg:
065AFA58  01 08 00 02 03 00 58 02  ..X
065AFA60  58 02 58 02 32 00 00 00  XX2...
065AFA68  B4 07 00 00 18 00 00 00  .....
065AFA70  10 06 00 00 EC 13 00 00  ....
065AFA78  B2 07 00 00 B4 07 00 00  ....
065AFA80  CF 08 00 00              ..


*/
      /* reserva buffer 6 dwords en fa84-fa9f */
      bzero (&hwdcfg, sizeof (struct st_hwdconfig));

      cl = (pixeldarklevel == 0xffff) ? 0 : 1;

      /* wait till lamp is at home (should use timeout
         windows driver doesn't use it)
       */
      tick = GetTickCount () + 10000;
      while ((Lamp_IsAtHome (Regs) == 0) && (tick > GetTickCount ()));

      lfaa0 = 0;
      if (v14b4 != 0)
	{
	  if (GainOffset_IncCount (&lfaa0) != OK)
	    return 0x02;
	}

      data = AutoRef_GetCount ();
      tick = GetTickCount ();

#ifdef STANDALONE
      findref = TRUE;
#else
      findref = ((data != 0) && (data < 15)) ? FALSE : TRUE;
#endif

      if (findref != FALSE)
	{
	  /* Need Find Ref */
	  SANE_Byte BL;

	  DBG (2, "Need to find ref\n");

	  Lamp_Warmup (Regs, FLB_LAMP);
	  Lamp_SetupPwm (FLB_LAMP);	/* 56be */

	  if (waitforpwm != FALSE)
	    {
	      Lamp_WaitForPWM (scan.resolution_x, ST_NORMAL);
	      waitforpwm = FALSE;
	    }

	  /*56e1 */
	  BL = scan.scantype;	/* save scantype */
	  scan.scantype = ST_NORMAL;
	  Refs_Set (Regs, &scancfg, 1);
	  AutoRef_IncCount ();
	  findref = FALSE;
	  scan.scantype = BL;	/* restore scantype */

	  Load_StripCoords (ST_NORMAL, &ypos, &xpos);
	  if (ypos != 0)
	    Lamp_Relocate (parkhomemotormove, 1, ypos);

	  if (scan.scantype != ST_NORMAL)
	    {
	      if (Lamp_Warmup (Regs, TMA_LAMP) == ERROR)
		return ERROR;

	      Lamp_SetupPwm (TMA_LAMP);
	      /*5794 */
	      Load_StripCoords (ST_TA, &ypos, &xpos);
	      if (ypos != 0)
		Lamp_Relocate (parkhomemotormove, 1, ypos);
	      Lamp_WaitForPWM (scan.resolution_x, ST_TA);
	    }
	}
      else
	{
	  DBG (2, "Don't Need to find ref\n");

	  /* No need find ref */
	  /*57d9 */
	  if (scan.scantype == ST_NORMAL)
	    {
	      Lamp_Warmup (Regs, FLB_LAMP);
	      Lamp_SetupPwm (FLB_LAMP);
	    }
	  else
	    {
	      /*5836 */
	      if (Lamp_Warmup (Regs, TMA_LAMP) == ERROR)
		return ERROR;
	      Lamp_SetupPwm (TMA_LAMP);
	    }

	  /*5895 */
	  Refs_Set (Regs, &scancfg, 0x00);
	  AutoRef_IncCount ();
	  findref = FALSE;

	  Load_StripCoords (scantype, &ypos, &xpos);
	  if (ypos != 0)
	    Lamp_Relocate (parkhomemotormove, 0x01, ypos);

	  if (waitforpwm != FALSE)
	    {
	      SANE_Int myscantype;

	      if (v14b4 == 0)
		{
		  /*590a */
		  if (scan.scantype == ST_NORMAL)
		    myscantype = ST_NORMAL;
		  else
		    myscantype = ST_TA;
		}
	      else
		myscantype = 0;

	      Lamp_WaitForPWM (scan.resolution_x, myscantype);
	      waitforpwm = FALSE;
	    }
	}

      /* Calibration process */

      /*592c */
      if (Calib_CreateBuffers (&myCalib, v14b4) != OK)
	return ERROR;
      /*5947 */

      hwdcfg.calibrate = calibrate;

      if (calibrate != 0)
	{
	  /* Let's calibrate */
	  if ((scancfg.colormode != CM_COLOR) && (scancfg.channel == 3))
	    scancfg.colormode = CM_COLOR;

	  hwdcfg.arrangeline = 0;

	  if (scan.scantype == ST_NORMAL)
	    {
	      /* Calibration for reflective type */

	      /*59e3 */
	      memcpy (&Regs, &BGeneral, 0x71a * sizeof (SANE_Byte));

	      if (Calibration (Regs, &scancfg, &myCalib, 0) != OK)
		{
		  if (v14b4 == 0)
		    Calib_FreeBuffers (&myCalib);
		  return ERROR;
		}
	    }
	  else
	    {
	      /*59ed */
	      /* Calibration for negative/slide type */

	    }

	  /*5af1 */
	  if (RTS_Debug.ScanWhiteBoard != FALSE)
	    {
	      Motor_ParkHome (TRUE, basespeedmotormove);
	      scan.ler = 1;
	    }

	  scancfg.colormode = scan.colormode;
	}
      else
	{
	  /*5b1e */
	  /*Don't calibrate */
	  if (scan.scantype == ST_NORMAL)
	    {
	      Lamp_SetStatus2 (TRUE, FLB_LAMP - 1);
	    }
	  else
	    {
	      if ((scan.scantype == ST_TA) || (scan.scantype == ST_NEG))
		{
		  /*SANE_Int ta_y_start; */
		  Lamp_SetStatus2 (FALSE, TMA_LAMP - 1);
		  /*ta_y_start =
		     get_value(SCAN_PARAM, TA_Y_START, 0x2508, usbfile);
		     ta_y_start += (((((scan.coord.top * 3) * 5) * 5) * 32) / scancfg.resolution_x);
		     if (ta_y_start >= 500)
		     {
		     Lamp_Relocate(highspeedmotormove, 0x01, ta_y_start);
		     scancfg.coord.top = 1;
		     scan.ler = 1;
		     } else
		     {
		     / *5ba9* /
		     if (ta_y_start > 0)
		     {
		     Lamp_Relocate(basespeedmotormove, 0x01, ta_y_start);
		     scancfg.coord.top = 1;
		     scan.ler = 1;
		     }
		     } */
		}
	    }
	}
      /*5bd0 */
      usleep (1000 * 200);

      hwdcfg.scantype = scan.scantype;
      hwdcfg.depth = 8;

      /* Set Origin */
      if ((scan.scantype >= ST_NORMAL) || (scan.scantype <= ST_NEG))
	{
	  SANE_Int myser;
	  if ((dpi100Lumping == 0) && (scancfg.resolution_x == 100))
	    myser = scan.ser / 2;	/*x29/2 = x14 */
	  else
	    myser = scan.ser;
	  scancfg.coord.left += myser;	/*+2 */
	  scancfg.coord.top += scan.ler;	/*+ x40 */
	}

      hwdcfg.sensorevenodddistance = sensorevenodddistance;
      hwdcfg.highresolution = (scancfg.resolution_x <= 1200) ? FALSE : TRUE;

      /*5c55 */
      /*
         if (calibrate == FALSE)
         {
         SANE_Int mytop = (((scancfg.coord.top * 5) * 5) * 16) / scancfg.resolution_y;
         if ((scancfg.resolution_y <= 150)&&(mytop < 300))
         {
         scancfg.coord.top = scancfg.resolution_y / 4;
         } else
         {
         if (mytop < 100)
         scancfg.coord.top = scancfg.resolution_y / 12;
         }
         }
       */

      /*5cd9 */
      if (compression != FALSE)
	hwdcfg.compression = TRUE;

      hwdcfg.arrangeline = arrangeline;
      if (scancfg.resolution_x == 2400)
	{
	  /* 5cfa */
	  if (scancfg.colormode != CM_COLOR)
	    {
	      if ((scancfg.colormode == CM_GRAY) && (scancfg.channel == 3))
		hwdcfg.arrangeline = FIX_BY_SOFT;
	    }
	  else
	    hwdcfg.arrangeline = FIX_BY_SOFT;
	}

      /*5d12 */
      if (ccdtype == TOSHIBA)
	{
	  if ((dpi100Lumping == 0) && (scancfg.resolution_x == 100))
	    scancfg.coord.left += 12;
	  else
	    {
	      /*5d3a */
	      scancfg.coord.left += 24;
	      switch (scancfg.resolution_x)
		{
		case 1200:
		  scancfg.coord.left -= 63;
		  break;
		case 2400:
		  scancfg.coord.left -= 127;
		  break;
		}
	    }
	}
      else
	{
	  /*5d5a */
	  /* CCD Sony */
	  if ((dpi100Lumping == 0) && (scancfg.resolution_x == 100))
	    scancfg.coord.left += 25;
	  else
	    {
	      /*5d6d */
	      scancfg.coord.left += 50;
	      switch (scancfg.resolution_x)
		{
		case 1200:
		  scancfg.coord.left -= 63;
		  break;
		case 2400:
		  scancfg.coord.left -= 127;
		  break;
		}
	    }
	}

      /* 5d92 */
      DBG (2, " ->Start_Scan xStart=%i, xExtent=%i\n", scancfg.coord.left,
	   scancfg.coord.width);

      runb1 = 1;
      if (scan.scantype == ST_NORMAL)
	{
	  /*5db7 */
	  if ((scancfg.resolution_x == 1200)
	      || (scancfg.resolution_x == 2400))
	    {
	      /*5e41 */
	      if ((scancfg.resolution_y / 10) > scancfg.coord.top)
		runb1 = 0;
	    }
	  else
	    {
	      if ((scancfg.resolution_x == 600) && (usbtype == USB11)
		  && (scancfg.colormode == CM_COLOR))
		{
		  /*5ded */
		  if ((scancfg.resolution_y / 10) > scancfg.coord.top)
		    runb1 = 0;
		}
	      else
		{
		  if ((scancfg.resolution_x == 600)
		      || (scancfg.resolution_x == 300))
		    {
		      /*5e11 */
		      if (scancfg.resolution_y > scancfg.coord.top)
			runb1 = 0;
		    }
		  else
		    runb1 = 0;
		}
	    }
	}
      else
	{
	  /*5e7c *//* entra aqu */
	  if ((scancfg.resolution_y / 10) > scancfg.coord.top)
	    runb1 = 0;
	}
      /*5eb1 */
      if (runb1 == 1)		/*entra */
	{
	  SANE_Int val1 = scancfg.coord.top - (scancfg.resolution_y / 10);
	  scancfg.coord.top -= val1;
	  Lamp_Relocate (highspeedmotormove, 0x01, (motorresolution / scancfg.resolution_y) * val1);	/*x168 */
	}


      /*5efe */
      if (calibrate != FALSE)
	{
	  if (use_gamma_tables != FALSE)
	    {
	      hwdcfg.use_gamma_tables = TRUE;
	      hp_gamma.depth = 0;
	    }

	  /*5f24 */
	  hwdcfg.unk1 = 1;
	  hwdcfg.unk2 = 1;
	  hwdcfg.unk3 = 0;
	  RTS_Setup (Regs, &scancfg, &hwdcfg, &mitabla);
	  myCalib.value2 = 0;

	  myCalib.shadinglength =
	    min (myCalib.shadinglength, scan.shadinglength);

	  if (scancfg.colormode != CM_COLOR)
	    {
	      if ((scancfg.channel > 0) && (scancfg.channel < 3))
		myCalib.WRef[0] = myCalib.WRef[scancfg.channel];
	    }

	  RTS_WriteRegs (Regs);
	  Apply_Gamma_and_Shading (Regs, &scancfg, &hwdcfg, &hp_gamma,
				   &myCalib);

	  /* Save to file? */
	  if (RTS_Debug.DumpShadingData != FALSE)
	    dump_shading (&myCalib);	/*5ff9 */
	}
      else
	RTS_Setup (Regs, &scancfg, &hwdcfg, &default_calib_table);

      /*602a */
      calibrate = hwdcfg.calibrate;
      binarythresholdh = bw_threshold;
      binarythresholdl = bw_threshold;
      DBG (2, ">  bw threshold -- hi=%i, lo=%i\n", binarythresholdh,
	   binarythresholdl);

      /* Big endian */
      Regs[0x1a0] = 0;
      Regs[0x1a1] = _B0 (binarythresholdh);
      /* Big endian */
      Regs[0x19e] = 0;
      Regs[0x19f] = _B0 (binarythresholdl);

      /* if has motorcurves... */
      if ((Regs[0xdf] & 0x10) != 0)
	Regs[0x01] |= 0x02;

      /* Set MLOCK */
      mlock = get_value (SCAN_PARAM, MLOCK, 0, usbfile) & 1;
      Regs[0x00] &= 0xef;
      Regs[0x00] |= (mlock << 4);

      if (changemotorcurrent != FALSE)
	Motor_Change (Regs, Motor_GetFromResolution (scancfg.resolution_x));

      /* Set gain mode */
      gainmode = Lamp_GetGainMode (scancfg.resolution_x, scan.scantype);
      Lamp_SetGainMode (Regs, scancfg.resolution_x, gainmode);

      WaitEndingAction (15000);
      if (v14b4 == 0)
	Calib_FreeBuffers (&myCalib);
      E8D9_Control ();

      if (E800_FLIP_FLOP () == 0)
	{
	  RTS_WriteRegs (Regs);
	  usleep (1000 * 500);

	  if (RTS_Execute () == OK)
	    {
	      /* if filesharemode != 0 */
	      Lamp_SetTimer (0);
	      rst = OK;
	    }
	}
    }

  DBG (2, "- Start_Scan: %i\n", rst);

  return rst;
}

static SANE_Int
funcion2ec0 (SANE_Byte * Regs, struct st_scanparams *myvar,
	     SANE_Int somevalue)
{
  SANE_Int rst;

  DBG (2, "+ funcion2ec0(*Regs, *myvar, somevalue=%i):\n", somevalue);
  show_ScanParams (myvar);

  rst = -1;

  if ((Regs != NULL) && (myvar != NULL))
    {
      SANE_Int colormode, mymode, myUnk, mydata, dummyline, myvalue, lf02c;
      struct st_scanmode *sm;

      colormode = myvar->colormode;
      if ((colormode != CM_COLOR) && (myvar->channel == 3))
	colormode = 3;

      mymode = SetupScanMode (colormode, myvar->resolution_x);
      if (mymode == ERROR)
	return ERROR;

      sm = &scanmodeparams[mymode];
      myUnk = sm->scanmotorsteptype | somevalue;
      Regs[0xd9] = ((myUnk << 4) & 0xf0) | (somevalue & 0x0f);	/*zzzzyyyy */
      Regs[0xdd] &= 0x3f;
      Regs[0xdd] |= (((myUnk & 0x10) << 3) | ((somevalue & 0x10) << 2));	/*zy------ */

      somevalue = _B0 (Regs[0xdd]);

      mydata =
	(sm->scanmotorsteptype <= 3) ? pow (2,
					    sm->
					    scanmotorsteptype) : somevalue;
      mydata &= 0xffff;

      /* Set dummyline */
      dummyline = _B0 (sm->dummyline);
      if (dummyline == 0)
	dummyline++;

      Regs[0xd6] &= 0x0f;
      Regs[0xd6] |= (dummyline << 4);	/*xxxx---- */

      /* Set if motor has curves */
      Regs[0xdf] &= 0xef;
      Regs[0xdf] |= ((sm->has_curves & 1) << 4);	   /*---x----*/

      Data_Set (0x10, &Regs[0xea], 3);
      Data_Set (0x10, &Regs[0xed], 3);
      Data_Set (0x10, &Regs[0xf0], 3);
      Data_Set (0x10, &Regs[0xf3], 3);

      Regs[0xe0] = _B0 ((((motorresolution & 0xffff) * mydata) /
			 (dummyline * myvar->resolution_y)) - 1);

      myvalue = Data_Get (&Regs[0x30], 3);
      myvalue += ((myvalue + 1) % (_B0 (Regs[0xe0]) + 1));
      Data_Set (myvalue, &Regs[0x30], 3);

      Data_Set (0, &Regs[0xeb], 2);
      Data_Set (0, &Regs[0xee], 2);
      Data_Set (0, &Regs[0xf1], 2);
      Data_Set (0, &Regs[0xf4], 2);

      myvalue = ((myvalue + 1) / (_B0 (Regs[0xe0]) + 1)) - 1;
      Data_Set (myvalue, &Regs[0xe1], 3);

      /* 42b30eb */
      lf02c = 0;
      if (sm->has_curves != FALSE)
	{
	  struct st_motorsetting *ms;
	  SANE_Int data, data2;

	  data =
	    (motorsetting !=
	     NULL) ? motorsetting[sm->motorcurve].acccurvecount : 0;
	  if (data == 0)
	    Motor_LoadCurve (sm->motorcurve);

	  ms = &motorsetting[sm->motorcurve];
	  ms->motorbackstep = sm->motorbackstep;

	  lf02c = Motor_Setup (Regs, ms);

	  data2 = sm->motorbackstep;
	  if (data2 >= (smeardeccurvecount + smearacccurvecount))
	    data = data2 - (smeardeccurvecount + smearacccurvecount) + 2;
	  else
	    data = 0;

	  if (data2 >= (deccurvecount + acccurvecount))
	    data2 -= (deccurvecount + acccurvecount) + 2;
	  else
	    data2 = 0;

	  /* set msi */
	  Regs[0xdd] &= 0xfc;
	  Regs[0xda] = _B0 (sm->msi);
	  Regs[0xdd] |= _B1 (sm->msi) & 3;		 /*------xx*/

	  /* set motorbackstep1 (a) */
	  Regs[0xdb] = _B0 (data);
	  Regs[0xdd] &= 0xf3;
	  Regs[0xdd] |= ((data >> 6) & 0x0c);		     /*----xx--*/

	  /* set motorbackstep2 (b) */
	  data2 = data2 - sm->skiplinecount;
	  Regs[0xdc] = _B0 (data2);
	  Regs[0xdd] &= 0xcf;
	  Regs[0xdd] |= ((data2 >> 4) & 0x30);		     /*--xx----*/
	}
      else
	{
	  /* 3205 */
	  Data_Set (myvalue, &Regs[0xe4], 3);
	  Data_Set (myvalue, &Regs[0xe7], 3);

	  /* set msi */
	  Regs[0xda] = _B0 (sm->msi);
	  Regs[0xdd] = (somevalue & 0xfc) | (_B1 (sm->msi) & 0x03);

	  /* set motorbackstep (a) */
	  Regs[0xdb] = _B0 (sm->motorbackstep);
	  Regs[0xdd] &= 0xf3;
	  Regs[0xdd] |= ((sm->motorbackstep >> 6) & 0x0c);

	  /* set motorbackstep (b) */
	  Regs[0xdc] = _B0 (sm->motorbackstep);
	  Regs[0xdd] &= 0xcf;
	  Regs[0xdd] |= ((sm->motorbackstep >> 4) & 0x30);
	}
      /* 328b */
      v15fa = lf02c;
      dummyline = (Regs[0xd6] >> 4) & 0x0f;
      myvalue = myvar->coord.top * (dummyline * (_B0 (Regs[0xe0]) + 1));

      if (lf02c >= myvalue)
	myvar->coord.top = 1;
      else
	myvar->coord.top -=
	  (lf02c / (dummyline * (_B0 (Regs[0xe0]) + 1))) - 1;

      rst = lf02c;		/* Result from Motor_Setup */
    }

  DBG (2, "- funcion2ec0: %i\n", rst);

  return rst;
}


static SANE_Int
RTS_Setup (SANE_Byte * Regs, struct st_scanparams *scancfg,
	   struct st_hwdconfig *hwdcfg, struct st_calib_table *Calibtable)
{
  SANE_Int cont, iLineDistance, myvalue, myvalue2, lSMode, mydata, myexpt[3];
  SANE_Int channels_per_line, bytes_per_line, myresolution, iLeft, iRight;
  SANE_Int dots_count, lf08c, dummyline, iTop, iDown;
  SANE_Byte mycolormode;
  struct st_scanmode *sm;

  DBG (2, "+ RTS_Setup:\n");
  show_ScanParams (scancfg);
  show_ScanLowLevelConfig (hwdcfg);

  iLineDistance = 0;

  mycolormode = scancfg->colormode;
  if (scancfg->colormode != CM_COLOR)
    {
      if (scancfg->colormode == CM_LINEART)
	scancfg->depth = 8;

      if (scancfg->channel == 3)
	{
	  if (scancfg->colormode == CM_GRAY)
	    mycolormode = (hwdcfg->arrangeline != FIX_BY_SOFT) ? 3 : CM_COLOR;
	  else
	    mycolormode = 3;
	}
    }

  /* 42b47d6 */
  vcolormode = mycolormode;
  memcpy (&scan2, scancfg, sizeof (struct st_scanparams));

  scantype = hwdcfg->scantype;
  lSMode = SetupScanMode (mycolormode, scancfg->resolution_x);
  if (lSMode < 0)
    return ERROR;

  sm = &scanmodeparams[lSMode];

  scancfg->timing = sm->timing;
  scancfg->sensorresolution = scantiming[scancfg->timing].sensorresolution;
  scancfg->shadinglength =
    (((scancfg->sensorresolution * 17) / 2) + 3) & 0xfffffffc;
  scancfg->samplerate = sm->samplerate;

  hwdcfg->motorplus = sm->motorplus;

  /* set systemclock */
  Data_BitSet (sm->systemclock, &Regs[0x00], 4);

  mydata = sm->ctpc + 1;
  if (usbtype == USB11)
    mydata *= sm->multiexposureforfullspeed;

  if (scancfg->depth > 8)
    mydata *= sm->multiexposurefor16bitmode;
  mydata--;

  for (cont = CL_RED; cont <= CL_BLUE; cont++)
    {
      if ((mydata > sm->mexpt[cont]) && (sm->expt[cont] == 0))
	sm->expt[cont] = sm->mexpt[cont];

      myexpt[cont] = (sm->expt[cont] == 0) ? sm->mexpt[cont] : sm->expt[cont];
    }

  /* save expts */
  DBG (2, "-> Exposure times : %04x, %04x, %04x\n", sm->expt[0], sm->expt[1],
       sm->expt[2]);
  Data_Set (sm->expt[CL_RED], &Regs[0x36], 3);
  Data_Set (sm->expt[CL_GREEN], &Regs[0x3c], 3);
  Data_Set (sm->expt[CL_BLUE], &Regs[0x42], 3);

  /* save mexpts */
  DBG (2, "-> MExposure times: %04x, %04x, %04x\n", sm->mexpt[0],
       sm->mexpt[1], sm->mexpt[2]);
  Data_Set (sm->mexpt[CL_RED], &Regs[0x33], 3);
  Data_Set (sm->mexpt[CL_GREEN], &Regs[0x39], 3);
  Data_Set (sm->mexpt[CL_BLUE], &Regs[0x3f], 3);

  /* save mydata */
  Data_Set (mydata, &Regs[0x30], 3);

  /* scancfg->expt = valor ms pequeo */
  scancfg->expt = min (min (myexpt[1], myexpt[2]), myexpt[0]);

  use_compresion = (mycolormode == CM_LINEART) ? FALSE : hwdcfg->compression;

  if ((mycolormode == CM_LINEART)
      || ((mycolormode == CM_GRAY) && (hwdcfg->highresolution == FALSE)))
    arrangeline2 = 0;
  else
    arrangeline2 = hwdcfg->arrangeline;

  use_hightresolution = hwdcfg->highresolution;
  use_sensorevenodddist =
    (hwdcfg->highresolution == FALSE) ? 0 : hwdcfg->sensorevenodddistance;

  if (arrangeline2 == FIX_BY_HARD)
    {
      SANE_Int mylinedistance, myevenodddist;

      mylinedistance =
	(sensorlinedistance * scancfg->resolution_y) / realsensorresolution;

      if (use_hightresolution == TRUE)
	myevenodddist =
	  (use_sensorevenodddist * scancfg->resolution_y) /
	  realsensorresolution;
      else
	myevenodddist = 0;

      Data_BitSet (myevenodddist, &Regs[0x149], 6);
      Data_BitSet (mylinedistance, &Regs[0x14a], 6);
      Data_BitSet (mylinedistance + myevenodddist, &Regs[0x014b], 6);
      Data_BitSet (mylinedistance * 2, &Regs[0x014c], 6);
      Data_BitSet ((mylinedistance * 2) + myevenodddist, &Regs[0x014d], 6);
    }
  else
    {
      Regs[0x149] &= 0xc0;
      Regs[0x14b] &= 0xc0;
      Regs[0x14a] &= 0xc0;
      Regs[0x14d] &= 0xc0;
      Regs[0x14c] &= 0xc0;

      if (arrangeline2 == FIX_BY_SOFT)
	{
	  SANE_Int x = 0;
	  double op1;

	  if (hwdcfg->highresolution == FALSE)
	    {
	      if (mycolormode == CM_COLOR)
		iLineDistance = (sensorlinedistance * scan2.resolution_y) * 2;
	      else
		x = 1;
	    }
	  else
	    {
	      /* bcc */
	      if (mycolormode == CM_COLOR)
		iLineDistance =
		  ((sensorlinedistance * 2) +
		   use_sensorevenodddist) * scan2.resolution_y;
	      else
		iLineDistance = sensorlinedistance * scan2.resolution_y;
	    }

	  /* bff */
	  if (x == 0)
	    {
	      iLineDistance = (iLineDistance / realsensorresolution) + 1;
	      if (iLineDistance < 2)
		iLineDistance = 2;
	    }

	  /* c25 */
	  iLineDistance &= 0xffff;
	  op1 = imagesize + (iLineDistance * bytesperline);
	  if (op1 != imagesize)
	    {
	      /* imagesize very big */
	      v15b4 = 1;
	    }
	  imagesize = op1;
	  dimageheight = op1 / bytesperline;
	}
    }

  /* 4c67 */
  if ((mycolormode != CM_COLOR) && (mycolormode != 3))
    {
      /* CM_GRAY || CM_LINEART */
      if (scancfg->samplerate == TRUE)
	{
	  SANE_Int iValue;

	  /* Setting channels_per_dot to 1 */
	  Regs[0x12] &= 0x3f;
	  Regs[0x12] |= 0x40;	/*01------ */

	  /* setting one rgb_channel_order */
	  Regs[0x12] &= 0xfc;
	  Regs[0x12] |= rgbchannelorder[scancfg->channel];

	  /* set sensor_channel_color_order */
	  Regs[0x60a] &= 0xc0;
	  Regs[0x60a] |= 0x06;		     /*--000110*/

	  Regs[0x1cf] &= 0x3f;
	  Regs[0x1cf] |= 0x80;	/*10------ */

	  if (scancfg->channel == rgbchannelorder[1])
	    {
	      /* mexpts[CL_RED] = mexpts[CL_GREEN] */
	      iValue = Data_Get (&Regs[0x39], 3);
	      Data_Set (iValue, &Regs[0x33], 3);

	      /* expts[CL_RED] = expts[CL_GREEN] */
	      iValue = Data_Get (&Regs[0x3c], 3);
	      Data_Set (iValue, &Regs[0x36], 3);
	    }
	  else if (scancfg->channel == rgbchannelorder[2])
	    {
	      /* mexpts[CL_RED] = mexpts[CL_BLUE] */
	      iValue = Data_Get (&Regs[0x3f], 3);
	      Data_Set (iValue, &Regs[0x33], 3);

	      /* expts[CL_RED] = expts[CL_BLUE] */
	      iValue = Data_Get (&Regs[0x42], 3);
	      Data_Set (iValue, &Regs[0x36], 3);
	    }
	}
      else
	{
	  /* e01 */
	  /* Samplerate is FALSE */
	  SANE_Byte channel_color_order;

	  /* setting channels_per_dot to 2 */
	  Regs[0x12] &= 0x3f;
	  Regs[0x12] |= 0x80;	/*10------ */

	  /* set two channel color order */
	  channel_color_order =
	    (sensorchannelgray[1] << 2) | sensorchannelgray[0];
	  Regs[0x12] &= 0xf0;
	  Regs[0x12] |= channel_color_order;

	  Regs[0x1cf] |= 0xc0;	/*11------ */
	}
    }
  else
    {
      /* CM_COLOR || 3 */
      /* e42 */
      SANE_Byte channel_color_order, rgb_channel_order;

      /* setting channels_per_dot to 3 */
      Regs[0x12] |= 0xc0;

      /* setting samplerate */
      Regs[0x1cf] &= 0x3f;
      Regs[0x1cf] |= scancfg->samplerate << 6;

      /* set sensor chanel_color_order */
      channel_color_order =
	(sensorchannelcolor[0] << 4) | (sensorchannelcolor[1] << 2) |
	sensorchannelcolor[2];
      Regs[0x60a] &= 0xc0;
      Regs[0x60a] |= channel_color_order;	    /*--aabbcc*/

      /* set rgb_channel_order */
      rgb_channel_order =
	(rgbchannelorder[2] << 4) | (rgbchannelorder[1] << 2) |
	rgbchannelorder[0];
      Regs[0x12] &= 0xc0;
      Regs[0x12] |= rgb_channel_order;		 /*--aabbcc*/
    }

  /* ee3 */
  /* channels_per_line = channels_per_dot * scan.width
     bytes_per_line = channels_per_line * bits_per_channel
   */
  channels_per_line = (_B0 (Regs[0x12]) >> 6) * scancfg->coord.width;
  bytes_per_line = channels_per_line;

  if (mycolormode == CM_LINEART)
    {
      /* lineart mode */
      bytes_per_line = (bytes_per_line + 7) / 8;
      Regs[0x01cf] |= 0x30;		   /*--11----*/
    }
  else
    {
      /*f0c */
      switch (scancfg->depth)
	{
	case 16:
	  /* 16 bits per channel */
	  bytes_per_line *= 2;
	  Regs[0x1cf] &= 0xef;
	  Regs[0x1cf] |= 0x20;			       /*--10----*/
	  break;
	case 12:
	  /* 12 bits per channel */
	  bytes_per_line *= 2;
	  Regs[0x1cf] &= 0xdf;
	  Regs[0x1cf] |= 0x10;			       /*--01----*/
	  break;
	case 8:
	  /* 8 bits per channel */
	  Regs[0x1cf] &= 0xcf;			       /*--00----*/
	  break;
	}
    }

  /* f61 */
  myresolution = (scancfg->sensorresolution / scancfg->resolution_x) & 0x1f;
  Data_BitSet (myresolution, &Regs[0xc0], 5);

  if (scancfg->coord.left == 0)
    scancfg->coord.left++;

  iLeft = scancfg->coord.left * myresolution;
  if ((iLeft & 1) == 0)
    iLeft++;

  iRight = (scancfg->coord.width * myresolution) + iLeft;
  Timing_Set (scancfg->timing, Regs);

  Regs[0xd8] &= 0xbf;					     /*-0------*/
  Regs[0xd8] |= ((scantype == ST_NORMAL) ? 0 : 1) << 6;	     /*-x------*/

  /* Use static head ? */
  Regs[0xd8] &= 0x7f;		/*0------- */
  Regs[0xd8] |= ((hwdcfg->static_head == FALSE) ? 1 : 0) << 7;	/*x------- */

  /* Setting up gamma */
  RTS_SetupGamma (Regs, hwdcfg);

  /* 50de */
  Regs[0x1bf] &= 0xe7;				/*---00---*/
  Regs[0x1bf] |= (hwdcfg->unk3 & 3) << 3;	/*---xx---*/

  /* Enable black shading correction ? */
  Regs[0x1cf] &= 0xf7;				/*----0---*/
  Regs[0x1cf] |= (hwdcfg->unk2 & 1) << 3;	/*----x---*/

  /* Enable white shading correction ? */
  Regs[0x1cf] &= 0xfb;				/*-----0--*/
  Regs[0x1cf] |= (hwdcfg->unk1 & 1) << 2;	/*-----x--*/

  if (((Regs[0x1cf] & 4) != 0) && ((Regs[0x1cf] & 8) != 0)
      && (hwdcfg->unk3 != 0))
    Regs[0x1cf] &= 0xfb;	     /*-----0--*/

  mydata =
    ((Regs[0x1cf] & 8) !=
     0) ? ((Regs[0xc0] & 0x1f) * scancfg->coord.width) * 2 : 0;

  if ((Regs[0x1cf] & 4) != 0)
    mydata += ((Regs[0xc0] & 0x1f) * scancfg->coord.width) * 2;

  Regs[0x1ba] = 0x00;
  mydata = (v160c + mydata - 1) / v160c;
  mydata = ((mydata + 15) / 16) + 16;

  Regs[0x1bf] &= 0xfe;
  Regs[0x1bb] = _B0 (mydata);
  Regs[0x1bc] = _B1 (mydata);
  Regs[0x1bf] |= _B2 (mydata) & 1;

  Regs[0x1bf] &= 0xf9;
  Regs[0x1bd] = _B0 (mydata * 2);
  Regs[0x1be] = _B1 (mydata * 2);
  Regs[0x1bf] |= (_B2 (mydata * 2) & 3) << 1;

  Data_BitSet (mydata * 3, &Regs[0x1c0], 20);

  mydata = v1610 - ((mydata * 3) << 4);

  dots_count = bytes_per_line;

  /* select case channels_per_dot */
  switch ((Data_Get (&Regs[0x12], 1) >> 6))
    {
    case 3:			/* 3 channels per dot */
      /* 528d */
      dots_count = bytes_per_line / 3;	/* 882 */
      myvalue =
	((((Regs[0x14a] & 0x3f) + 1) * dots_count) + v160c - 1) / v160c;
      myvalue2 = myvalue;
      mydata = (mydata - (myvalue * 3) + 2) / 3;

      myvalue += (Data_Get (&Regs[0x1c0], 3) & 0x0fffff) * 8;
      myvalue = (((myvalue * 2) + mydata) >> 4) + 1;

      Regs[0x1c2] &= 0x0f;
      Regs[0x1c2] |= _B0 ((_B2 (myvalue) << 4));
      Regs[0x1c3] = _B0 (myvalue);
      Regs[0x1c4] = _B1 (myvalue);

      myvalue = (((myvalue << 4) + myvalue2 + mydata) >> 4) + 1;
      Data_BitSet (myvalue, &Regs[0x01c5], 20);
      break;
    case 2:			/* 2 channels per dot */
      dots_count = bytes_per_line / 2;
      myvalue =
	((((Regs[0x14a] & 0x3f) + 1) * dots_count) + v160c - 1) / v160c;
      mydata = ((mydata - myvalue) + 1) / 2;
      myvalue +=
	(((Data_Get (&Regs[0x1c0], 3) & 0x0fffff) + mydata) / 16) + 1;

      Regs[0x1c2] &= 0x0f;
      Regs[0x1c2] |= _B0 (_B2 (myvalue) << 4);
      Regs[0x1c3] = _B0 (myvalue);
      Regs[0x1c4] = _B1 (myvalue);
      break;
    }


  Regs[0x01c7] &= 0x0f;
  Regs[0x01c8] = _B0 ((v1610 - 1) / 16);
  Regs[0x01c9] = _B1 ((v1610 - 1) / 16);
  Regs[0x01c7] |= (_B2 ((v1610 - 1) / 16) & 0x0f) << 4;

  mydata -= (v160c + dots_count - 1) / v160c;
  Regs[0x0712] &= 0x0f;
  Regs[0x0710] = _B0 (mydata / 16);
  Regs[0x0711] = _B1 (mydata / 16);
  Regs[0x0712] |= _B0 (_B2 (mydata / 16) << 0x04);


  Regs[0x0713] = 0x00;
  Regs[0x0714] = 0x10;
  Regs[0x0715] &= 0xf0;
  lf08c = (hwdcfg->depth == 8) ? 8 : 0;
  hwdcfg->startpos = funcion2ec0 (Regs, scancfg, lf08c);

  /* SET SCANIMAGE COORDINATES */
  dummyline = (Regs[0xd6] >> 4) & 0x0f;
  if (scancfg->coord.top == 0)
    scancfg->coord.top++;
  iTop = scancfg->coord.top * dummyline;
  iDown =
    (((Regs[0x14d] & 0x3f) + scancfg->coord.height +
      iLineDistance) * dummyline) + iTop;
  RTS_SetCoords (Regs, iLeft, iTop, iRight, iDown);

  /* dummy_scan? */
  Regs[0x01] &= 0xe9;				     /*---0-00-*/
  Regs[0x01] |= (hwdcfg->dummy_scan & 1) << 4;	     /*---x----*/

  Regs[0x163] &= 0x3f;
  Regs[0x163] |= 0x40;		/*01------ */

  if (use_compresion != FALSE)
    {
      Regs[0x60b] &= 0x8f;
      Regs[0x60b] |= 0x10;		   /*-001----*/
    }
  else
    Regs[0x060b] &= 0x80;	     /*-0000000*/

  if (mycolormode == 3)
    {
      SANE_Int channels_per_line;
      /* Set channels_per_line = channels_per_dot * scan_width */
      channels_per_line = _B0 (Regs[0x12] >> 6) * scancfg->coord.width;
      Data_BitSet (channels_per_line, &Regs[0x060c], 18);

      /* Sets 16 bits per channel */
      Regs[0x1cf] &= 0xef;
      Regs[0x1cf] |= 0x20;	     /*--10----*/

      Regs[0x60b] |= 0x40;
      if (v1619 == 0x21)
	{
	  use_compresion = FALSE;
	  Regs[0x60b] &= 0xef;		     /*---0----*/
	}

      switch (scancfg->depth)
	{
	case 8:
	case 16:
	  Regs[0x060b] &= 0xf3;
	  break;
	case 12:
	  Regs[0x060b] = (Regs[0x060b] & 0xfb) | 0x08;
	  break;
	}

      if (scancfg->colormode == CM_LINEART)
	Regs[0x60b] &= 0xf3;

      Regs[0x1d0] &= 0xbf;
    }

  /* 5683 */
  /* Set calibration table */
  Calib_SetTable (Regs, Calibtable);

  DBG (2, "- RTS_Setup:\n");

  return OK;
}

static SANE_Int
RTS_SetCoords (SANE_Byte * Regs, SANE_Int iLeft, SANE_Int iTop,
	       SANE_Int iRight, SANE_Int iDown)
{
  SANE_Int rst = ERROR;

  if (Regs != NULL)
    {
      /* Set Left coord */
      Data_Set (iLeft, &Regs[0xb0], 2);

      /* Set Right coord */
      Data_Set (iRight, &Regs[0xb2], 2);

      /* Set Top coord */
      Data_Set (iTop, &Regs[0xd0], 2);
      Regs[0xd4] = (Regs[0xd4] & 0xf0) | (_B2 (iTop) & 0x0f);

      /* Set Down coord */
      Data_Set (iDown, &Regs[0xd2], 2);
      Regs[0xd4] = (Regs[0xd4] & 0x0f) | ((_B2 (iDown) & 0x0f) << 4);

      rst = OK;
    }

  DBG (2,
       "> RTS_SetCoords(*Regs, iLeft=%i, iTop=%i, iRight=%i, iDown=%i): %i\n",
       iLeft, iTop, iRight, iDown, rst);

  return rst;
}

static SANE_Int
Calib_SetTable (SANE_Byte * Regs, struct st_calib_table *Calibtable)
{
  SANE_Int rst = ERROR;
  SANE_Byte fake[] =
    { 0x19, 0x15, 0x19, 0x64, 0x64, 0x64, 0x74, 0xc0, 0x74, 0xc0, 0x6d,
    0xc0, 0x6d, 0xc0, 0x5f, 0xc0, 0x5f, 0xc0
  };

  DBG (2, "+ Calib_SetTable(*Regs, *Calibtable)\n");
  show_calibtable (Calibtable);

  if ((Regs != NULL) && (Calibtable != NULL))
    {
      if (calibrate == FALSE)
	{
	  SANE_Int cont;

	  Regs[0x13] &= 0xc0;
	  Regs[0x13] |= (Calibtable->pag[CL_BLUE] & 3) << 4;
	  Regs[0x13] |= (Calibtable->pag[CL_GREEN] & 3) << 2;
	  Regs[0x13] |= (Calibtable->pag[CL_RED] & 3);

	  for (cont = 0; cont < 19; cont++)
	    Regs[cont + 20] = fake[cont];
	}
      else
	{
	  Regs[0x1a] = Calibtable->edcg1[CL_RED] & 0xff;
	  Regs[0x1e] = Calibtable->edcg1[CL_GREEN] & 0xff;
	  Regs[0x22] = Calibtable->edcg1[CL_BLUE] & 0xff;

	  Regs[0x1b] =
	    ((Calibtable->edcg1[CL_RED] >> 1) & 0x80) | (Calibtable->
							 edcg2[CL_RED] &
							 0x7f);
	  Regs[0x1f] =
	    ((Calibtable->edcg1[CL_GREEN] >> 1) & 0x80) | (Calibtable->
							   edcg2[CL_GREEN] &
							   0x7f);
	  Regs[0x23] =
	    ((Calibtable->edcg1[CL_BLUE] >> 1) & 0x80) | (Calibtable->
							  edcg2[CL_BLUE] &
							  0x7f);

	  Regs[0x1c] = Calibtable->odcg1[CL_RED] & 0xff;
	  Regs[0x20] = Calibtable->odcg1[CL_GREEN] & 0xff;
	  Regs[0x24] = Calibtable->odcg1[CL_BLUE] & 0xff;

	  Regs[0x1d] =
	    ((Calibtable->odcg1[CL_RED] >> 1) & 0x80) | (Calibtable->
							 odcg2[CL_RED] &
							 0x7f);
	  Regs[0x21] =
	    ((Calibtable->odcg1[CL_GREEN] >> 1) & 0x80) | (Calibtable->
							   odcg2[CL_GREEN] &
							   0x7f);
	  Regs[0x25] =
	    ((Calibtable->odcg1[CL_BLUE] >> 1) & 0x80) | (Calibtable->
							  odcg2[CL_BLUE] &
							  0x7f);

	  Regs[0x13] =
	    ((Calibtable->pag[CL_BLUE] & 0x03) << 0x04) | ((Calibtable->
							    pag[CL_GREEN] &
							    0x03) << 0x02) |
	    (Calibtable->pag[CL_RED] & 0x03) | (Regs[0x13] & 0xc0);

	  Regs[0x14] =
	    (Regs[0x14] & 0xe0) | (Calibtable->vgag1[CL_RED] & 0x1f);
	  Regs[0x15] =
	    (Regs[0x15] & 0xe0) | (Calibtable->vgag1[CL_GREEN] & 0x1f);
	  Regs[0x16] =
	    (Regs[0x16] & 0xe0) | (Calibtable->vgag1[CL_BLUE] & 0x1f);
	  Regs[0x17] =
	    (Regs[0x17] & 0xe0) | (Calibtable->vgag2[CL_RED] & 0x1f);
	  Regs[0x18] =
	    (Regs[0x18] & 0xe0) | (Calibtable->vgag2[CL_GREEN] & 0x1f);
	  Regs[0x19] =
	    (Regs[0x19] & 0xe0) | (Calibtable->vgag2[CL_BLUE] & 0x1f);
	}
      rst = OK;
    }

  DBG (2, "- Calib_SetTable: %i\n", rst);

  return rst;
}

static void
Calibrate_Free (struct st_cal2 *calbuffers)
{
  DBG (2, "> Calibrate_Free(*calbuffers)\n");

  if (calbuffers != NULL)
    {
      SANE_Int c;

      if (calbuffers->table2 != NULL)
	{
	  free (calbuffers->table2);
	  calbuffers->table2 = NULL;
	}

      for (c = 0; c < 4; c++)
	{
	  if (calbuffers->tables[c] != NULL)
	    {
	      free (calbuffers->tables[c]);
	      calbuffers->tables[c] = NULL;
	    }
	}
    }
}

static SANE_Int
Calibrate_Malloc (struct st_cal2 *calbuffers, SANE_Byte * Regs,
		  struct st_calibration *myCalib, SANE_Int somelength)
{
  SANE_Int myshadinglength, pos;
  SANE_Int rst;

  DBG (2, "Calibrate_Malloc(*calbuffers, *Regs, *myCalib, somelength=%i)\n",
       somelength);

  if ((calbuffers != NULL) && (Regs != NULL) && (myCalib != NULL))
    {
      if ((Regs[0x1bf] & 0x18) == 0)
	{
	  if ((((Regs[0x1cf] >> 1) & Regs[0x1cf]) & 0x04) != 0)
	    calbuffers->table_count = 2;
	  else
	    calbuffers->table_count = 4;
	}
      else
	calbuffers->table_count = 4;

      /*365d */
      myshadinglength = myCalib->shadinglength * 2;
      if (myshadinglength < somelength)
	calbuffers->shadinglength1 = myshadinglength;
      else
	calbuffers->shadinglength1 = somelength;

      if ((myshadinglength % somelength) != 0)
	{
	  if (myshadinglength >= somelength)
	    calbuffers->shadinglength2 = myshadinglength * 2;
	  else
	    calbuffers->shadinglength2 = somelength;
	}
      else
	calbuffers->shadinglength2 = somelength;

      if (myshadinglength >= somelength)
	{
	  calbuffers->shadinglength1 =
	    (myshadinglength % calbuffers->shadinglength1) +
	    calbuffers->shadinglength1;
	  calbuffers->shadinglength3 =
	    ((myCalib->shadinglength * 2) / somelength) - 1;
	}
      else
	calbuffers->shadinglength3 = 0;

      calbuffers->shadinglength3 =
	(somelength >> 4) * calbuffers->shadinglength3;

      rst = OK;
      for (pos = 0; pos < calbuffers->table_count; pos++)
	{
	  calbuffers->tables[pos] =
	    (USHORT *) malloc (calbuffers->shadinglength2 * sizeof (USHORT));
	  if (calbuffers->tables[pos] == NULL)
	    {
	      rst = ERROR;
	      break;
	    }
	}

      if (rst == OK)
	{
	  calbuffers->table2 =
	    (USHORT *) malloc (calbuffers->shadinglength2 * sizeof (USHORT));
	  if (calbuffers->table2 == NULL)
	    rst = ERROR;
	}

      if (rst != OK)
	{
	  for (pos = 0; pos < calbuffers->table_count; pos++)
	    {
	      if (calbuffers->tables[pos] != NULL)
		{
		  free (calbuffers->tables[pos]);
		  calbuffers->tables[pos] = NULL;
		}
	    }
	}

    }
  else
    rst = ERROR;

  DBG (2,
       "> Calibrate_Malloc(*calbuffers, *Regs, *myCalib, somelength=%i): %i\n",
       somelength, rst);

  return rst;
}

static SANE_Int
fn3560 (USHORT * table, struct st_cal2 *calbuffers, SANE_Int * tablepos)
{
  /*05FEF974   001F99B0  |table = 001F99B0
     05FEF978   05FEFA08  |calbuffers->tables[0] = 05FEFA08
     05FEF97C   000000A0  |calbuffers->shadinglength3 = 000000A0
     05FEF980   00000348  |calbuffers->shadinglength1 = 00000348
     05FEF984   04F01502  |calbuffers->table_count = 04F01502
     05FEF988   05FEF998  \Arg6 = 05FEF998
   */

  SANE_Int pos[4] = { 0, 0, 0, 0 };	/*f960 f964 f968 f96c */
  SANE_Int usetable = 0;
  SANE_Int cont;

  SANE_Int mylength3 = calbuffers->shadinglength1;	/*f97c */
  SANE_Byte *pPointer =
    (SANE_Byte *) table + (calbuffers->shadinglength3 << 4);

  DBG (2, "> fn3560(*table, *calbuffers, *tablepos)\n");

#ifndef developing
  return OK;
#endif

  if (mylength3 > 0)
    {
      do
	{
	  if (mylength3 <= 16)
	    {
	      if (mylength3 > 0)
		{
		  do
		    {
		      *(calbuffers->tables[usetable] + pos[usetable]) =
			_B0 (*pPointer);
		      pPointer++;
		      pos[usetable]++;
		      mylength3--;
		    }
		  while (mylength3 > 0);
		}
	      break;
	    }

	  cont = 16;
	  do
	    {
	      *(calbuffers->tables[usetable] + pos[usetable]) =
		_B0 (*pPointer);
	      pPointer++;
	      pos[usetable]++;
	      cont--;
	    }
	  while (cont > 0);

	  mylength3 -= 16;
	  usetable++;
	  if (usetable == calbuffers->table_count)
	    usetable = 0;
	}
      while (mylength3 > 0);
    }

  /*35f8 */
  if (calbuffers->table_count > 0)
    {
      /* Return position of each table */
      memcpy (tablepos, pos, sizeof (SANE_Int) * 4);
    }

  return OK;
}

static SANE_Int
Calib_ReadTable (SANE_Byte * table, SANE_Int size, SANE_Int data)
{
  SANE_Int rst = ERROR;

  DBG (2, "+ Calib_ReadTable(*table, size=%i):\n", size);

  if ((table != NULL) && (size > 0))
    {
      SANE_Int transferred;
      SANE_Byte buffer[6];

      Data_SetBigEndian (data, &buffer[0], 3);
      /* buffer size to read divided by 2 */
      Data_Set (size / 2, &buffer[3], 3);

      /* Operation type 0x00 */
      if (IWrite_Word (0x0000, 0x0000, 0x0800) == OK)
	{
	  /* Send size to read */
	  if (IWrite_Buffer (0x0004, buffer, 0x06, 0x0400) == OK)
	    /* Retrieve data */
	    rst = Bulk_Operation (1, size, table, &transferred);
	}
    }

  DBG (2, "- Calib_ReadTable: %i\n", rst);

  return rst;
}

static SANE_Int
fn3330 (SANE_Byte * Regs, struct st_cal2 *calbuffers,
	SANE_Int sensorchannelcolor, SANE_Int * tablepos, SANE_Int data)
{
  /*05EEF968   04F0F7F8  |Regs = 04F0F7F8
     05EEF96C   02DEC838  |calbuffers->table2 = 02DEC838
     05EEF970   05EEFA08  |calbuffers->tables[] = 05EEFA08
     05EEF974   00000000  |sensorchannelcolor = 00000000
     05EEF978   000000A0  |calbuffers->shadinglength3 = 000000A0
     05EEF97C   00000400  |calbuffers->shadinglength2 = 00000400
     05EEF980   05EEF998  |&pos = 05EEF998
     05EEF984   00221502  |calbuffers->table_count = 00221502
     05EEF988   00000000  \data = 00000000
   */

  SANE_Int table_count = calbuffers->table_count;	/*f960 */
  SANE_Int schcolor = _B0 (sensorchannelcolor);
  SANE_Int a = 0;
  SANE_Int tablelength = calbuffers->shadinglength3 / table_count;	/*f954 */
  SANE_Int value1 = 0;		/*f974 */
  SANE_Int value2 = 0;		/*f978 */
  SANE_Int value3 = 0;		/*ebx */
  SANE_Int value4 = 0;		/*ebp */
  SANE_Int size;
  SANE_Int rst = OK;

  DBG (2,
       "+ fn3330(*Regs, *calbuffers, sensorchannelcolor=%i, *tablepos, data=%i):\n",
       sensorchannelcolor, data);

  if (calbuffers->table_count > 0)
    {
      do
	{
	  if (calbuffers->table_count == 2)
	    {
	      /*338c */
	      if (a != 0)
		{
		  /*3394 */
		  if ((a - 1) == 0)
		    {
		      if (_B0 (data) == 0)
			{
			  value1 = 0x100000;
			  value2 = 0x100000;
			  value3 = 0x200000;
			}
		      else
			{
			  /*343a */
			  value1 = 0x300000;
			  value2 = 0x300000;
			  value3 = 0;
			}
		    }
		}
	      else
		{
		  /*33be */
		  if (_B0 (data) == 0)
		    {
		      value1 = 0;
		      value2 = 0;
		      value3 = 0x300000;
		    }
		  else
		    {
		      /*342a */
		      value1 = 0x200000;
		      value2 = 0x200000;
		      value3 = 0x100000;
		    }
		}
	    }
	  else
	    {
	      /*33d5 */
	      switch (a)
		{
		case 0:
		  value1 = 0;
		  value2 = 0;
		  value3 = 0x300000;
		  break;
		case 1:
		  value1 = 0x200000;
		  value2 = 0x200000;
		  value3 = 0x100000;
		  break;
		case 2:
		  value1 = 0x100000;
		  value2 = 0x100000;
		  value3 = 0x200000;
		  break;
		case 3:
		  value1 = 0x300000;
		  value2 = 0x300000;
		  value3 = 0;
		  break;
		}
	    }

	  /*3449 */
	  switch (schcolor)
	    {
	    case CM_LINEART:
	      size =
		(((Regs[0x1bf] >> 1) & 3) << 0x10) | (Regs[0x1be] << 0x08) |
		Regs[0x1bd];
	      value4 = tablelength + size;
	      break;
	    case CM_GRAY:
	      size =
		((Regs[0x1bf] & 1) << 0x10) | (Regs[0x1bc] << 0x08) |
		Regs[0x1bb];
	      value4 = tablelength + (size | value3);
	      break;
	    default:
	      value4 = (_B0 (Regs[0x1ba]) + tablelength) | value1;
	      break;
	    }

	  if (Calib_ReadTable
	      ((SANE_Byte *) calbuffers->table2, calbuffers->shadinglength2,
	       value4) != OK)
	    {
	      rst = ERROR;
	      break;
	    }
	  memcpy (calbuffers->tables[a], calbuffers->table2, tablepos[a]);

	  if (tablepos[a + 1] == 0)
	    break;

	  a++;
	}
      while (a < calbuffers->table_count);
    }

  DBG (2, "- fn3330: %i\n", rst);

  return rst;
}

static SANE_Int
fn3730 (struct st_cal2 *calbuffers, SANE_Byte * Regs, USHORT * table,
	SANE_Int sensorchannelcolor, SANE_Int data)
{
  /*05FEF9AC   |calbuffers         = 05FEF9F8
     05FEF9B0   |Regs               = 04EFF7F8
     05FEF9B4   |table              = 001F99B0
     05FEF9B8   |sensorchannelcolor = 00000000
     05FEF9BC   |data               = 00000000
   */

  SANE_Int pos[4] = { 0, 0, 0, 0 };	/*f998 f99c f9a0 f9a4 */
  SANE_Int rst;

  DBG (2,
       "+ fn3730(*calbuffers, *Regs, *table, sensorchannelcolor=%i, data=%i):\n",
       sensorchannelcolor, data);

  fn3560 (table, calbuffers, pos);
  rst = fn3330 (Regs, calbuffers, sensorchannelcolor, pos, data);

  DBG (2, "- fn3730: %i\n", rst);

  return rst;
}

static SANE_Int
Apply_Gamma_and_Shading (SANE_Byte * Regs, struct st_scanparams *myvar,
			 struct st_hwdconfig *hwdcfg,
			 struct st_gammatables *mygamma,
			 struct st_calibration *myCalib)
{
  /*
     Regs f1bc
     myvar     f020
     hwdcfg  e838
     arg4      e81c
     myCalib   e820
   */

  SANE_Int rst;			/* lf9e0 */
  SANE_Int myfact;		/* e820 */
  SANE_Int shadata;
  SANE_Int lf9ec;
  SANE_Byte color_count;	/* f9d4 */
  SANE_Int myShadingBase;	/* e818 */

  SANE_Byte myshadinglength[6] = { 0, 0, 0, 0, 0, 0 };	/* f9f0 f9f1 f9f2 f9f3 f9f4 f9f5 */

  char lf9d1;
  char lf9d0;

  DBG (2,
       "+ Apply_Gamma_and_Shading(*Regs, *myvar, *hwdcfg, *mygamma, *myCalib):\n");
  show_ScanParams (myvar);

  lf9ec = (usbtype == USB20) ? 0x200 : 0x40;
  lf9d0 = (Regs[0x60b] >> 6) & 1;
  lf9d1 = (Regs[0x60b] >> 4) & 1;
  Regs[0x060b] &= 0xaf;
  rst = Write_Byte (0xee0b, Regs[0x060b]);
  if (rst == OK)
    {
      SANE_Byte colormode = myvar->colormode;	/*fa24 */
      SANE_Int le7cc, le7d8;
      struct st_cal2 calbuffers;	/* f9f8 */

      if (colormode != CM_COLOR)
	{
	  if (myvar->channel != 3)
	    {
	      if (colormode != 3)
		color_count = (myvar->samplerate == FALSE) ? 2 : 1;
	      else
		color_count = 3;
	    }
	  else
	    {
	      colormode = 3;
	      color_count = 3;
	    }
	}
      else
	color_count = 3;

      if (hwdcfg->use_gamma_tables == FALSE)
	{
	  DBG (2, "-> Gamma tables are not used\n");
	  v15fc = 0x00;
	  v1600 = NULL;
	  v1604 = NULL;
	  v1608 = NULL;
	}
      else
	{
	  /*390b */
	  SANE_Int table_size = 2;	/*fa28 */
	  SANE_Int buffersize;	/*f9dc */
	  SANE_Byte *gammabuffer;	/*f9e4 */
	  SANE_Int lf9e8;
	  SANE_Int c;

	  DBG (2, "-> Using gamma tables\n");
	  v15fc = 1;

	  switch (mygamma->depth & 0x0c)
	    {
	    case 0:
	      table_size = 0x100 + (mygamma->depth & 1);
	      break;
	    case 4:
	      table_size = 0x400 + (mygamma->depth & 1);
	      break;
	    case 8:
	      table_size = 0x1000 + (mygamma->depth & 1);
	      break;
	    }

	  buffersize = table_size * color_count;
	  gammabuffer =
	    (SANE_Byte *) malloc (buffersize * sizeof (SANE_Byte));
	  if (gammabuffer == NULL)
	    return ERROR;

	  /*39ac */
	  lf9e8 = 0;
	  v1600 = (SANE_Byte *) & mygamma->table[CL_RED];
	  v1604 = (SANE_Byte *) & mygamma->table[CL_GREEN];
	  v1608 = (SANE_Byte *) & mygamma->table[CL_BLUE];

	  for (c = 0; c < color_count; c++)
	    {
	      memcpy (gammabuffer + (c * table_size), mygamma->table[c],
		      table_size);
	      lf9e8 += table_size;
	    }
	  /*3a27 */

	  Gamma_SendTables (Regs, gammabuffer, buffersize);
	  free (gammabuffer);
	}

      /* 3aad */
      if (colormode == 3)
	{
	  SANE_Int pos;
	  SANE_Int colour;

	  myShadingBase = shadingbase;

	  for (colour = 0; colour < color_count; colour++)
	    {
	      if (myCalib->white_shading[colour] != NULL)
		{
		  myfact = shadingfact[colour];
		  if (myCalib->shadinglength > 0)
		    {
		      for (pos = myCalib->value - 1;
			   pos < myCalib->shadinglength; pos++)
			myCalib->white_shading[colour][pos] =
			  (myCalib->white_shading[colour][pos] * myfact) /
			  myShadingBase;
		    }
		}
	      else
		break;
	    }
	}

      /* 3b3b */
      if (myCalib->value3 != 0)
	{
	  /* 3b46 */
	  SANE_Int colour, pos;
	  le7cc = shadingbase;
	  le7d8 = shadingbase;

	  for (colour = 0; colour < color_count; colour++)
	    {
	      if (colormode == 3)
		{
		  le7cc = shadingfact[colour];
		}

	      if ((Regs[0x1cf] & 2) != 0)
		{
		  myShadingBase = 0x2000;
		  myfact = myCalib->WRef[colour] << 0x0d;
		}
	      else
		{
		  myShadingBase = 0x4000;
		  myfact = myCalib->WRef[colour] << 0x0e;
		}

	      if (myCalib->value2 == 2)
		{
		  /*3bd8 */
		  if ((myCalib->black_shading[colour] != NULL)
		      && (myCalib->white_shading[colour] != NULL))
		    {
		      for (pos = myCalib->value - 1;
			   pos < myCalib->shadinglength; pos++)
			{
			  if (myCalib->white_shading[colour][pos] == 0)
			    shadata = myShadingBase;
			  else
			    shadata =
			      myfact / myCalib->white_shading[colour][pos];

			  shadata = min ((shadata * le7cc) / le7d8, 0xff00);
			  myCalib->black_shading[colour][pos] &= 0xff;
			  myCalib->black_shading[colour][pos] |=
			    shadata & 0xff00;
			}
		    }
		  else
		    break;
		}
	      else
		{
		  /*3c63 */
		  if (myCalib->value2 == 3)
		    {
		      /*3c68 */
		      if (myCalib->black_shading[colour] != NULL)
			{
			  for (pos = myCalib->value - 1;
			       pos < myCalib->shadinglength; pos++)
			    {
			      if (myCalib->black_shading[colour][pos] == 0)
				shadata = myShadingBase;
			      else
				shadata =
				  myfact /
				  myCalib->black_shading[colour][pos];

			      shadata =
				min ((shadata * le7cc) / le7d8, 0xffc0);
			      myCalib->black_shading[colour][pos] &= 0x3f;
			      myCalib->black_shading[colour][pos] |=
				shadata & 0xffc0;
			    }
			}
		      else
			break;
		    }
		  else
		    {
		      /*3ce3 */
		      if (myCalib->white_shading[colour] != NULL)
			{
			  for (pos = 0; pos < myCalib->shadinglength; pos++)
			    {
			      if (myCalib->white_shading[colour][pos] == 0)
				shadata = myShadingBase;
			      else
				shadata =
				  myfact /
				  myCalib->white_shading[colour][pos];

			      shadata =
				min ((shadata * le7cc) / le7d8, 0xffff);
			      myCalib->white_shading[colour][pos] = shadata;
			    }
			}
		      else
			break;
		    }
		}
	    }
	}

      /*3d4c */
      Data_Set (myCalib->shadinglength, &myshadinglength[3], 3);

      bzero (&calbuffers, sizeof (struct st_cal2));

      if ((Regs[0x1cf] & 0x08) != 0)
	{
	  /* 3d79 */
	  Calibrate_Malloc (&calbuffers, Regs, myCalib, lf9ec);
	  if (color_count > 0)
	    {
	      SANE_Int myschannelcolor = 0;
	      SANE_Int colour;	/*fa24 */
	      SANE_Int pos;	/*fa2c */
	      SANE_Int transferred;

	      for (colour = color_count; colour != 0; colour--)
		{
		  for (pos = 0; pos <= 10; pos++)
		    {
		      /* Send size to write */
		      if (IWrite_Buffer
			  (sensorchannelcolor[myschannelcolor] | 0x10,
			   myshadinglength, 0x06, 0x0401) == OK)
			/* Send data */
			Bulk_Operation (0,
					myCalib->shadinglength *
					sizeof (USHORT),
					(SANE_Byte *) & myCalib->
					black_shading[pos][myCalib->value -
							   1], &transferred);

		      /*3df7 */
		      if (fn3730
			  (&calbuffers, Regs,
			   &myCalib->black_shading[pos][myCalib->value - 1],
			   sensorchannelcolor[myschannelcolor], 0) == OK)
			break;

		      IWrite_Word (0x0000, 0, 0x600);
		    }
		  myschannelcolor++;
		}
	    }

	  /*3e62 */
	  Calibrate_Free (&calbuffers);
	}

      /*3e6e */
      if ((Regs[0x1cf] & 0x04) != 0)
	{
	  /*3e7f */
	  Calibrate_Malloc (&calbuffers, Regs, myCalib, lf9ec);

	  if (color_count > 0)
	    {
	      SANE_Int myschannelcolor = 0;
	      SANE_Int colour;	/*fa24 */
	      SANE_Int pos;	/*fa2c */
	      SANE_Int transferred;

	      for (colour = color_count; colour != 0; colour--)
		{
		  for (pos = 0; pos <= 10; pos++)
		    {
		      /* Send size to write */
		      if (IWrite_Buffer
			  (sensorchannelcolor[myschannelcolor] | 0x14,
			   myshadinglength, 0x06, 0x0401) == OK)
			/* Send data */
			Bulk_Operation (0,
					myCalib->shadinglength *
					sizeof (USHORT),
					(SANE_Byte *) & myCalib->
					white_shading[pos][myCalib->value -
							   1], &transferred);

		      /*3df7 */
		      if (fn3730
			  (&calbuffers, Regs,
			   &myCalib->white_shading[pos][myCalib->value - 1],
			   sensorchannelcolor[myschannelcolor], 1) == OK)
			break;

		      IWrite_Word (0x0000, 0, 0x600);
		    }
		  myschannelcolor++;
		}
	    }
	  Calibrate_Free (&calbuffers);
	}

      /* 3f74 */
      if (rst == 0)
	{
	  Regs[0x60b] &= 0xaf;				 /*-0-0----*/
	  Regs[0x60b] |= (lf9d0 & 1) << 6;		 /*-x------*/
	  Regs[0x60b] |= (lf9d1 & 1) << 4;		 /*---x----*/
	  rst = Write_Byte (0xee0b, Regs[0x060b]);
	}
    }
  /*3fb5 */

  DBG (2, "- Apply_Gamma_and_Shading: %i\n", rst);

  return rst;
}

static SANE_Int
Bulk_Operation (SANE_Byte op, SANE_Int buffer_size, SANE_Byte * buffer,
		SANE_Int * transfered)
{
  SANE_Int iTransferSize, iBytesToTransfer, iPos, rst, iBytesTransfered;
  char sdebug[20];

  if ((op & 0x01) != 0)
    strcpy (sdebug, "READ");
  else
    strcpy (sdebug, "WRITE");
  DBG (2, "+ Bulk_Operation(op=%s, buffer_size=%i, buffer):\n", sdebug,
       buffer_size);

  iBytesToTransfer = buffer_size;
  iPos = 0;
  rst = OK;
  iBytesTransfered = 0;

  if (transfered != NULL)
    *transfered = 0;

  iTransferSize = min (buffer_size, dmatransfersize);

  if (op != 0)
    {
      /* Lectura */
      do
	{
	  iTransferSize = min (iTransferSize, iBytesToTransfer);

	  iBytesTransfered = Read_Bulk (&buffer[iPos], iTransferSize);
	  if (iBytesTransfered < 0)
	    {
	      v3618 = 1;
	      rst = ERROR;
	      break;
	    }
	  else
	    {
	      if (transfered != NULL)
		*transfered += iBytesTransfered;
	    }
	  iPos += iTransferSize;
	  iBytesToTransfer -= iTransferSize;
	}
      while (iBytesToTransfer > 0);
    }
  else
    {
      /* Escritura */
      do
	{
	  iTransferSize = min (iTransferSize, iBytesToTransfer);

	  if (Write_Bulk (&buffer[iPos], iTransferSize) != OK)
	    {
	      v3618 = 1;
	      rst = ERROR;
	      break;
	    }
	  else
	    {
	      if (transfered != NULL)
		*transfered += iTransferSize;
	    }
	  iPos += iTransferSize;
	  iBytesToTransfer -= iTransferSize;
	}
      while (iBytesToTransfer > 0);
    }

  DBG (2, "- Bulk_Operation: %i\n", rst);

  return rst;
}

static SANE_Int
Notify_BufferSize_to_read (SANE_Int data, SANE_Int size)
{
  SANE_Int rst;
  SANE_Byte regs[6];

  DBG (2, "+ Notify_BufferSize_to_read(data=%i, size=%i):\n", data, size);

  Data_SetBigEndian (data, &regs[0], 3);
  Data_Set (size / 2, &regs[3], 3);

  rst = IWrite_Buffer (0x0008, regs, sizeof (SANE_Byte) * 6, 0x0400);

  DBG (2, "- Notify_BufferSize_to_read: %i\n", rst);

  return rst;
}

static SANE_Int
Wait_for_desired_size (SANE_Byte Channels_per_dot, SANE_Byte Channel_size,
		       SANE_Int size, SANE_Int * last_amount,
		       SANE_Int seconds, SANE_Byte op)
{
  SANE_Int rst;
  SANE_Byte cTimeout, executing;
  SANE_Int lastAmount, myAmount;
  long tick;

  DBG (2,
       "+ Wait_for_desired_size(Channels_per_dot=%i, Channel_size=%i, size=%i, *last_amount, seconds=%i, op=%i):\n",
       Channels_per_dot, Channel_size, size, seconds, op);

  rst = OK;
  cTimeout = FALSE;
  lastAmount = 0;

  myAmount = Get_Scanner_Buffer_Size (Channels_per_dot, Channel_size);
  if (myAmount < size)
    {
      /* Wait until scanner fills its buffer */
      if (seconds == 0)
	seconds = 5;
      tick = GetTickCount () + (seconds * 1000);

      while (cTimeout == FALSE)
	{
	  myAmount = Get_Scanner_Buffer_Size (Channels_per_dot, Channel_size);

	  /* check special case */
	  if (op == TRUE)
	    {
	      if (((myAmount + 0x450) > size)
		  || (RTS_IsExecuting (&executing) == FALSE))
		break;
	    }

	  if (myAmount < size)
	    {
	      /* Check timeout */
	      if (myAmount == lastAmount)
		{
		  /* we are in timeout? */
		  if (tick < GetTickCount ())
		    {
		      /* TIMEOUT */
		      rst = ERROR;
		      cTimeout = TRUE;
		    }
		  else
		    usleep (100 * 1000);
		}
	      else
		{
		  /* Amount increased, update tick */
		  lastAmount = myAmount;
		  tick = GetTickCount () + (seconds * 1000);
		}
	    }
	  else
	    {
	      lastAmount = myAmount;
	      break;		/* buffer full */
	    }
	}
    }

  if (last_amount != NULL)
    *last_amount = myAmount;

  DBG (2, "- Wait_for_desired_size: %i , last_amount=%i\n", rst, myAmount);

  return rst;
}

static SANE_Int
fn11b0 (double dSize, char unsigned *buffer, double *lf080)
{
  /* dSize        f068|f06c
     buffer f070
     lf080  f074 */

  SANE_Int rst;
  SANE_Int transfered;
  char lf04e, lf04f;

  DBG (2, "+ fn11b0(dSize=%f, buffer, lf080):\n", dSize);

  rst = ERROR;
  lf04e = 0;
  lf04f = 0;

  if (v360c != 0)
    {
      double lf05c;
      SANE_Int lf060, iPos;

      rst = OK;
      dSize /= 2;
      lf05c = 0;
      lf060 = 0;
      iPos = 0;

      if (dSize > 0)
	{
	  SANE_Int myLength;
	  do
	    {
	      myLength = (dSize <= dmasetlength) ? dSize : dmasetlength;

	      if (myLength > 0x1ffe0)
		myLength = 0x1ffe0;

	      rst = ERROR;
	      if (Wait_for_desired_size (0, 1, myLength * 2, NULL, 5, FALSE)
		  == OK)
		{
		  if (Notify_BufferSize_to_read (0, myLength * 2) == OK)
		    rst =
		      Bulk_Operation (1, myLength * 2, &buffer[iPos],
				      &transfered);
		}

	      if (rst != OK)
		break;

	      dSize -= myLength;
	      lf05c += myLength * 2;
	    }
	  while (dSize > 0);
	}

      /* 130c */
      if (lf080 != NULL)
	*lf080 = lf05c;

      if (rst != OK)
	IWrite_Word (0x0000, 0, 0x600);
    }

  DBG (2, "- fn11b0: %i\n", rst);

  return rst;
}

static SANE_Int
fn3fc0 (SANE_Byte * buffer, struct st_scanparams *myvar,
	struct st_hwdconfig *hwdcfg)
{
  /*buffer   f80c = esp+14
     myvar    f850 = esp+18
     hwdcfg faac = */

  SANE_Int rst;

  DBG (2, "+ fn3fc0(buffer, myvar, hwdcfg):\n");

  rst = ERROR;

  if (buffer != NULL)
    {
      double dSize = myvar->bytesperline * myvar->coord.height;
      SANE_Byte exfn;

      if (myvar->depth == 12)
	dSize = (dSize * 3) / 4;
      /*3ff6 */
      exfn = 1;
      if (hwdcfg != NULL)
	if (hwdcfg->compression != FALSE)
	  exfn = 0;
      if (exfn != 0)
	{
	  double lf080;
	  rst = fn11b0 (dSize, buffer, &lf080);
	}

      if (rst == 0)
	WaitEndingAction (1500);
    }

  DBG (2, "- fn3fc0: %i\n", rst);

  return rst;
}

static SANE_Int
RTS_GetImage (SANE_Byte * Regs, struct st_scanparams *myvar,
	      struct st_calib_table *Calibtable, SANE_Byte * buffer,
	      struct st_calibration *myCalib, SANE_Int arg6,
	      SANE_Int gainmode)
{
  SANE_Int myvalue;
  struct st_scanparams mycpvar;
  struct st_hwdconfig hwdcfg;

  DBG (2,
       "+ RTS_GetImage(*Regs, *myvar, *Calibtable, *buffer, myCalib, arg6=%i, gainmode=%i):\n",
       arg6, gainmode);
  show_ScanParams (myvar);

  /* 42b8e10 */
  memcpy (&mycpvar, myvar, sizeof (struct st_scanparams));
  bzero (&hwdcfg, sizeof (struct st_hwdconfig));

  if ((myvar->coord.width != 0) && (myvar->coord.height != 0))
    {
      if (((arg6 & 2) != 0) || ((_B1 (arg6) & 1) != 0))
	{
	  Regs[0x146] &= 0xbf;
	  Write_Byte (0xe946, Regs[0x146]);
	  if (v14b4 == 0)
	    usleep (1000 * 500);
	  else
	    usleep (1000 * 300);
	}

      hwdcfg.scantype = scan.scantype;
      hwdcfg.use_gamma_tables = (arg6 >> 0x06) & 1;
      hwdcfg.unk1 = (arg6 >> 0x05) & 1;
      hwdcfg.unk2 = (arg6 >> 0x07) & 1;
      hwdcfg.depth = ((arg6 & 0x10) == 0) ? 8 : 0;
      hwdcfg.compression = (arg6 >> 2) & 1;
      hwdcfg.static_head = arg6 & 1;
      hwdcfg.dummy_scan = (buffer == NULL) ? 1 : 0;
      hwdcfg.arrangeline = 0;
      hwdcfg.highresolution = (myvar->resolution_x > 1200) ? TRUE : FALSE;
      hwdcfg.unk3 = 0;

      /* Set Left coord */

      if (ccdtype == TOSHIBA)
	myvar->coord.left += 24;
      else
	myvar->coord.left += 50;

      switch (myvar->resolution_x)
	{
	case 1200:
	  myvar->coord.left -= 63;
	  break;
	case 2400:
	  myvar->coord.left -= 126;
	  break;
	}

      if (myvar->coord.left < 0)
	myvar->coord.left = 0;

      RTS_Setup (Regs, myvar, &hwdcfg, Calibtable);

      /* Setting exposure time */
      switch (scan.scantype)
	{
	case ST_NORMAL:
	  if (scan.resolution_x == 100)
	    {
	      SANE_Int iValue;
	      SANE_Byte myregisters[0x71a];
	      bzero (&myregisters, 0x71a * sizeof (SANE_Byte));
	      RTS_Setup (myregisters, &scan, &hwdcfg, Calibtable);

	      iValue = Data_Get (&myregisters[0x30], 3);
	      Data_Set (iValue, &Regs[0x30], 3);

	      /*Copy myregisters mexpts to Regs mexpts */
	      iValue = Data_Get (&myregisters[0x33], 3);
	      Data_Set (iValue, &Regs[0x33], 3);

	      iValue = Data_Get (&myregisters[0x39], 3);
	      Data_Set (iValue, &Regs[0x39], 3);

	      iValue = Data_Get (&myregisters[0x3f], 3);
	      Data_Set (iValue, &Regs[0x3f], 3);
	    }
	  break;
	case ST_NEG:
	  /* Setting exposure times for Negative scans */
	  Data_Set (myvar->expt, &Regs[0x30], 3);
	  Data_Set (myvar->expt, &Regs[0x33], 3);
	  Data_Set (myvar->expt, &Regs[0x39], 3);
	  Data_Set (myvar->expt, &Regs[0x3f], 3);
	  Data_Set (0, &Regs[0x36], 3);
	  Data_Set (0, &Regs[0x3c], 3);
	  Data_Set (0, &Regs[0x42], 3);

	  myvalue = ((myvar->expt + 1) / (Data_Get (&Regs[0xe0], 1) + 1)) - 1;
	  Data_Set (myvalue, &Regs[0xe1], 3);
	  break;
	}

      /* 91a0 */
      if (myvar->resolution_y <= 600)
	{
	  SetMultiExposure (Regs);
	}
      else
	{
	  arg6 |= 0x20000000;
	  if (arg6 != 0)	/* Always true ... */
	    SetMultiExposure (Regs);
	  else
	    myvar->coord.top += (hwdcfg.startpos & 0xffff);
	}

      /* 91e2 */
      RTS_WriteRegs (Regs);
      if (myCalib != NULL)
	Apply_Gamma_and_Shading (Regs, myvar, &hwdcfg, NULL, myCalib);

      if (changemotorcurrent != FALSE)
	{
	  SANE_Int motor = Motor_GetFromResolution (myvar->resolution_x);
	  Motor_Change (Regs, motor);
	}

      Regs[0x00] &= 0xef;
      Regs[0xde] = 0x00;
      Regs[0xdf] &= 0xf0;

      E8D9_Control ();
      if (E800_FLIP_FLOP () != 0)
	return ERROR;

      SetLock (Regs, (myvar->depth == 16) ? FALSE : TRUE);

      Lamp_SetGainMode (Regs, myvar->resolution_x, gainmode);
      if (RTS_WriteRegs (Regs) == OK)
	{
	  if (RTS_Execute () == OK)
	    fn3fc0 (buffer, myvar, &hwdcfg);	/*92e7 */
	}

      /*92fc */
      SetLock (Regs, FALSE);

      if ((arg6 & 0x200) != 0)
	{
	  /* Turn on lamp */
	  Regs[0x146] |= 0x40;
	  Write_Byte (0xe946, Regs[0x146]);
	  /* Wait 3 seconds */
	  usleep (1000 * 3000);
	}

      /*9351 */
      if (changemotorcurrent != 0)
	Motor_Change (BGeneral, 3);
      /* Restore myvar */
      memcpy (myvar, &mycpvar, sizeof (struct st_scanparams));
    }

  DBG (2, "- RTS_GetImage\n");

  return OK;
}

static SANE_Int
AutoRef (SANE_Byte * Regs, SANE_Int resolution_x, SANE_Int resolution_y,
	 SANE_Int saveautoreffile)
{
  struct st_scanparams myvar;
  struct st_calib_table myCalibTable;
  SANE_Int rst, gainmode, pwmlamplevel_backup, C, buffersize, ser1, ler1;
  SANE_Byte *buffer;

  DBG (2,
       "+ AutoRef(*Regs, resolution_x=%i, resolution_y=%i, saveautoreffile=%i):\n",
       resolution_x, resolution_y, saveautoreffile);

  gainmode = 0;
  if (usefixedpwm == FALSE)
    {
      /* 3877 */
      SANE_Int pwmdutycycle;
      gainmode = Lamp_GetGainMode (resolution_x, scan.scantype);
      pwmdutycycle = (gainmode == 0) ? 0x12 : 0x26;
      pwmlamplevel = 0;
      SetPwmLampMode (1);
      PWM_SetDutyCycle (pwmdutycycle);
      /* Enciende flb lamp */
      Lamp_SetStatus2 (TRUE, FLB_LAMP - 1);
      usleep (1000 * 2000);
    }
  /* 38d6 */
  pwmlamplevel_backup = pwmlamplevel;
  pwmlamplevel = 0;
  SetPwmLampMode (1);

  bzero (&myCalibTable, sizeof (struct st_calib_table));
  for (C = CL_RED; C <= CL_BLUE; C++)
    {
      myCalibTable.pag[C] = 3;
      myCalibTable.vgag1[C] = 4;
      myCalibTable.vgag2[C] = 4;
    }

  bzero (&myvar, sizeof (struct st_scanparams));
  myvar.resolution_x = resolution_x;
  myvar.depth = 8;
  myvar.colormode = CM_GRAY;
  myvar.channel = 0;
  myvar.resolution_y = resolution_y;
  myvar.coord.left = 4;
  myvar.coord.width = (resolution_x * 3) / 10;
  myvar.coord.top = 1;
  myvar.coord.height = (resolution_y * 4) / 10;
  myvar.shadinglength = (resolution_x * 17) / 2;
  myvar.bytesperline = myvar.coord.width;

  rst = ERROR;

  buffersize = myvar.coord.height * myvar.coord.width;
  buffer = (SANE_Byte *) malloc (buffersize * sizeof (SANE_Byte));
  if (buffer != NULL)
    {
      if (RTS_GetImage
	  (Regs, &myvar, &myCalibTable, buffer, 0, 0x20000000,
	   gainmode) == OK)
	{
	  if (RTS_Debug.SaveCalibFile != FALSE)
	    {
	      TIFF_Save ("autoref.tiff",
			 myvar.coord.width,
			 myvar.coord.height, myvar.depth, buffer, buffersize);
	    }

	  if (Refs_Calculate
	      (myvar.depth, myvar.coord.width, myvar.coord.height, buffer,
	       &ler1, 1, &ser1, 0) == OK)
	    {
	      scan.startpos = myvar.coord.top + ler1;
	      scan.leftleading = myvar.coord.left + ser1;
	      rst = OK;
	    }
	}
    }

  pwmlamplevel = pwmlamplevel_backup;
  free (buffer);

  DBG (2, "- AutoRef: scan.startpos=%i, scan.leftleading=%i : %i\n",
       scan.startpos, scan.leftleading, rst);

  return OK;
}

static SANE_Int
Refs_Set (SANE_Byte * Regs, struct st_scanparams *myscan, SANE_Int autoref)
{
  SANE_Int rst, autofindrefpos;

  DBG (2, "+ Refs_Set(*Regs, *myscan, autoref=%i):\n", autoref);
  show_ScanParams (myscan);

  rst = OK;
  Set_LER_SER (myscan->resolution_x);

  if (autoref == 1)
    autofindrefpos = REF_AUTODETECT;
  else
    autofindrefpos =
      get_value (AUTOREFPOS, AUTOFINDREFPOS, REF_TAKEFROMSCANNER,
		 FITCALIBRATE);

  if (autofindrefpos != 0)
    {
      SANE_Int ler_offset =
	get_value (AUTOREFPOS, LEROFFSET, 0, FITCALIBRATE);
      SANE_Int ser_offset =
	get_value (AUTOREFPOS, SEROFFSET, 0, FITCALIBRATE);
      SANE_Int saveautoreffile =
	get_value (AUTOREFPOS, SAVEAUTOREFFILE, 0, FITCALIBRATE);
      SANE_Int start_pos, left_leading;

      switch (autofindrefpos)
	{
	case REF_AUTODETECT:
	  if (AutoRef (Regs, 600, 600, saveautoreffile) == OK)
	    Refs_SetOrigin (scan.leftleading, scan.startpos);
	  else
	    rst = ERROR;

	  Motor_ParkHome (1, parkhomemotormove);
	  break;
	case REF_TAKEFROMSCANNER:
	  /* Try to get values from scanner */
	  if (Refs_GetOrigin (&left_leading, &start_pos) == ERROR)
	    {
	      if (AutoRef (Regs, 600, 600, saveautoreffile) == OK)
		Refs_SetOrigin (left_leading, start_pos);
	      else
		rst = ERROR;

	      DBG (2, ">  blacklinipos:ler=%i, leftBlackpos:ser = %i\n",
		   scan.startpos, scan.leftleading);

	      Motor_ParkHome (1, parkhomemotormove);
	    }
	  else
	    {
	      scan.leftleading = left_leading;
	      scan.startpos = start_pos;
	    }
	  break;
	}

      if (rst == OK)
	{
	  scan.leftleading *= 4;
	  scan.startpos = (myscan->resolution_y < 1200) ?
	    (scan.startpos - 12) * 4 : (scan.startpos - 24) * 4;

	  if ((dpi100Lumping == 0) && (myscan->resolution_x == 100))
	    scan.ser = ((scan.leftleading + ser_offset) * 200) / 2400;
	  else
	    scan.ser =
	      ((scan.leftleading + ser_offset) * myscan->resolution_x) / 2400;

	  scan.ler =
	    ((scan.startpos + ler_offset) * myscan->resolution_y) / 2400;
	  if (myscan->resolution_x <= 300)
	    scan.ler += 3;

	  DBG (2,
	       "> After SEROffset and LEROffset, xoffset = %i, yoffset =%i\n",
	       scan.ser, scan.ler);
	}
    }

  DBG (2, "- Refs_Set: %i\n", rst);

  return rst;
}

static SANE_Int
Lamp_SetStatus (SANE_Byte * Regs, SANE_Int turn_on, SANE_Int lamp)
{
  char sdebug1[10], sdebug2[10];

  if (((lamp | turn_on) & 1) == 1)
    strcpy (sdebug1, "Yes");
  else
    strcpy (sdebug1, "No");

  if (lamp == FLB_LAMP - 1)
    strcpy (sdebug2, "FLB_LAMP");
  else
    strcpy (sdebug2, "TMA_LAMP");

  DBG (2, "+ Lamp_SetStatus(*Regs, turn_on=%i->%s, lamp=%s)\n",
       turn_on, sdebug1, sdebug2);

  RTS_ReadRegs (Regs);

  /* Encender lmpara? S es TMA_LAMP, s, sino lo que diga turn_on */
  Regs[0x146] = (((lamp | turn_on) & 1) << 0x06) | (Regs[0x146] & 0xbf);

  /* Qu lmpara hay que encender? (si procede) */
  if ((Regs[0x146] & 0x40) != 0)
    {
      if (lamp != FLB_LAMP - 1)
	{
	  /* Use Tma lamp */
	  Regs[0x155] |= 0x10;
	  v14b0 = 1;
	}
      else
	{
	  /*42b8cc2 */
	  /* Use Flb lamp */
	  Regs[0x155] &= 0xef;
	  v14b0 = 0;
	}
    }
  /*42b8cd1 */
  /* Encendido/Apagado de lmpara */
  BGeneral[0x0146] = (BGeneral[0x146] & 0xbf) | (Regs[0x146] & 0x40);
  /* Which lamp */
  BGeneral[0x0155] = Regs[0x0155];
  Write_Byte (0xe946, Regs[0x0146]);
  usleep (1000 * 200);
  Write_Buffer (0xe954, &Regs[0x0154], 2);

  DBG (2, "- SetLamp\n");

  return OK;
}

static SANE_Int
Lamp_OverDrive (SANE_Int itime, SANE_Int lamp)
{
  long ticks;
  SANE_Int pwmdutycycle;

  DBG (2, "+ Lamp_OverDrive(itime=%i, lamp=%i):\n", itime, lamp);

  ticks = GetTickCount () + itime;

  switch (lamp)
    {
    case TMA_LAMP:
      pwmdutycycle = 0x0e;
      break;
    default:
      pwmdutycycle = 0x00;
      break;
    }

  PWM_SetDutyCycle (pwmdutycycle);

  DBG (2, ">   Lamp_OverDrive: Waiting for %i msecs\n", itime);

  while (GetTickCount () <= ticks)
    usleep (1000 * 200);

  DBG (2, "- Lamp_OverDrive\n");

  return OK;
}

static SANE_Int
Get_PAG_Value (SANE_Byte scantype, SANE_Byte color)
{
  SANE_Int rst, iType, iColor;

  switch (scantype)
    {
    case ST_NEG:
      iType = CALIBNEGATIVEFILM;
      break;
    case ST_TA:
      iType = CALIBTRANSPARENT;
      break;
    case ST_NORMAL:
      iType = CALIBREFLECTIVE;
      break;
    default:
      iType = CALIBREFLECTIVE;
      break;
    }

  switch (color)
    {
    case CL_BLUE:
      iColor = PAGB;
      break;
    case CL_GREEN:
      iColor = PAGG;
      break;
    case CL_RED:
      iColor = PAGR;
      break;
    default:
      iColor = PAGR;
      break;
    }

  rst = get_value (iType, iColor, 1, FITCALIBRATE);

  DBG (2, "> Get_PAG_Value(scantype=%i, color=%i): %i\n",
       scantype, color, rst);

  return rst;
}

static SANE_Byte
Lamp_GetGainMode (SANE_Int resolution, SANE_Byte scantype)
{
  SANE_Byte ret;
  SANE_Int mygain, iValue;

  switch (scantype)
    {
    case ST_TA:
      ret = 0;
      iValue = DPIGAINCONTROL_TA600;
      break;
    case ST_NEG:
      ret = 1;
      iValue = DPIGAINCONTROL_NEG600;
      break;
    default:
      ret = 1;
      iValue = DPIGAINCONTROL600;
      break;
    }

  mygain = get_value (SCAN_PARAM, iValue, ret, usbfile);
  ret = 0;

  if (scantype == ST_NORMAL)
    {
      switch (resolution)
	{
	case 100:
	case 200:
	case 300:
	case 600:
	  if (usbtype != USB11)
	    ret = (mygain != 0) ? 1 : 0;
	  else
	    ret = (resolution == 100) ? 1 : 0;
	  break;
	case 1200:
	case 2400:
	  ret = 0;
	  break;
	}
    }
  else if (scantype == ST_TA)
    {
      switch (resolution)
	{
	case 100:
	case 200:
	case 300:
	case 600:
	case 1200:
	case 2400:
	  ret = ((usbtype != USB11) && (mygain != 0)) ? 1 : 0;
	  break;
	}
    }
  else
    {
      /* ST_NEG */
      switch (resolution)
	{
	case 100:
	case 200:
	case 300:
	case 600:
	  if (usbtype != USB11)
	    ret = (mygain != 0) ? 1 : 0;
	  else
	    ret = 0;
	  break;
	case 1200:
	case 2400:
	  ret = 0;
	  break;
	}
    }

  DBG (2, "> Lamp_GetGainMode(resolution=%i, scantype=%i): %i\n", resolution,
       scantype, ret);

  return ret;
}

static SANE_Int
GetOneLineInfo (SANE_Int resolution, struct st_icolours *maximus,
		struct st_icolours *minimus, struct st_dcolours *average)
{
  SANE_Byte Regs[0x71a];
  SANE_Byte *buffer;
  SANE_Int a, buffer_size, gainmode;
  struct st_calib_table Calibtable;
  struct st_scanparams myvar;

  DBG (2, "+ GetOneLineInfo(resolution=%i, *maximus, *minimus, *average):\n",
       resolution);

  /* Check parameters */
  if ((maximus == NULL) || (minimus == NULL) || (average == NULL))
    return ERROR;

  /* Copy scanner registers */
  memcpy (&Regs, &BGeneral, 0x71a * sizeof (SANE_Byte));

  /* Setting some registers */
  for (a = 0x192; a <= 0x19d; a++)
    Regs[a] = 0;

  /* Create calibration table */
  for (a = CL_RED; a <= CL_BLUE; a++)
    {
      Calibtable.edcg1[a] = 256;
      Calibtable.edcg2[a] = 0;
      Calibtable.odcg1[a] = 256;
      Calibtable.odcg2[a] = 0;
      Calibtable.vgag1[a] = 4;
      Calibtable.vgag2[a] = 4;
      Calibtable.pag[a] = Get_PAG_Value (scan.scantype, a);
    }

  SetupScanMode (0, resolution);

  /* Setting scanning params */
  myvar.colormode = CM_COLOR;
  myvar.resolution_x = resolution & 0xffff;
  myvar.resolution_y = myvar.resolution_x;
  myvar.coord.left = 100;
  myvar.coord.width = (resolution * 8.5) - 100;
  myvar.coord.top = 1;
  myvar.coord.height = 1;
  myvar.depth = 8;
  myvar.shadinglength = resolution * 8.5;
  myvar.v157c = myvar.coord.width * 3;
  myvar.bytesperline = myvar.v157c;

  /* Reserve buffer for line */
  buffer_size = ((myvar.coord.width * 0x21) * 3) * sizeof (SANE_Byte);
  buffer = (SANE_Byte *) malloc (buffer_size);
  if (buffer == NULL)
    return ERROR;

  gainmode = Lamp_GetGainMode (resolution & 0xffff, scan.scantype);
  a = RTS_GetImage (Regs, &myvar, &Calibtable, buffer, 0, 1, gainmode);
  if (a != ERROR)
    {
      /* Read all buffer to take max min and average colours */
      SANE_Byte *pointer1 = buffer;
      SANE_Byte *pointer2;
      SANE_Byte *pointer3;
      SANE_Int minblue, mingreen, minred;
      SANE_Int maxblue, maxgreen, maxred;
      SANE_Int mysize;
      double avered = 0, avegreen = 0, aveblue = 0;

      if (myvar.colormode != CM_GRAY)
	{
	  pointer2 = buffer;
	  pointer3 = buffer;
	}
      else
	{
	  pointer2 = buffer + 1;
	  pointer3 = buffer + 2;
	}

      minblue = 255;
      mingreen = 255;
      minred = 255;
      maxblue = 0;
      maxgreen = 0;
      maxred = 0;
      if (myvar.coord.height > 0)
	{
	  SANE_Int cont = 0;
	  SANE_Int cont2;
	  SANE_Byte *mypointer;
	  SANE_Byte red_desp;
	  SANE_Byte green_desp;
	  SANE_Byte cRed, cGreen, cBlue;
	  do
	    {
	      if (myvar.resolution_y > 0)
		{
		  red_desp = pointer1 - pointer3;
		  green_desp = pointer2 - pointer3;
		  mypointer = pointer3;
		  cont2 = 0;
		  do
		    {
		      /* Take max values for each color */
		      cRed = *(red_desp + mypointer);
		      if (maxred < cRed)
			maxred = cRed;
		      cGreen = *(green_desp + mypointer);
		      if (maxgreen < cGreen)
			maxgreen = cGreen;
		      cBlue = *mypointer;
		      if (maxblue < cBlue)
			maxblue = cBlue;

		      /* Take min values for each color */
		      if (minred > cRed)
			minred = cRed;
		      if (mingreen > cGreen)
			mingreen = cGreen;
		      if (minblue > cBlue)
			minblue = cBlue;

		      /* Average */
		      avered += cRed;
		      avegreen += cGreen;
		      aveblue += cBlue;

		      mypointer += 3;
		      cont2++;
		    }
		  while (cont2 < myvar.resolution_y);
		}
	      pointer1 += myvar.resolution_y * 3;
	      pointer2 += myvar.resolution_y * 3;
	      pointer3 += myvar.resolution_y * 3;
	      cont++;
	    }
	  while (cont < myvar.coord.height);
	}
      mysize = myvar.coord.height * myvar.resolution_y;
      if (mysize < 1)
	mysize = 1;

      maximus->red = maxred;
      maximus->green = maxgreen;
      maximus->blue = maxblue;
      minimus->red = minred;
      minimus->green = mingreen;
      minimus->blue = minblue;
      average->red = avered / mysize;
      average->green = avegreen / mysize;
      average->blue = aveblue / mysize;

      DBG (2, "GetOneLine0Info: max r=%i g=%i b=%i\n",
	   maximus->red, maximus->green, maximus->blue);
      DBG (2, "->                min r=%i g=%i b=%i\n",
	   minimus->red, minimus->green, minimus->blue);
      DBG (2, "->                avg r=%.0f g=%.0f b=%.0f\n",
	   average->red, average->green, average->blue);
    }
  free (buffer);

  DBG (2, "- GetOneLineInfo\n");

  return OK;
}

static SANE_Int
PWM_GetReady (SANE_Int resolution, SANE_Int * unknown, double diff,
	      SANE_Int totaltime, SANE_Int interval, SANE_Int value)
{
  struct st_icolours maximus;
  struct st_icolours minimus;
  struct st_dcolours average;
  SANE_Int maxbigger;
  SANE_Byte brk;
  SANE_Int rst;

  DBG (2,
       "+ PWM_GetReady(resolution=%i, *unknown, diff=%f, totaltime=%i, interval=%i, value=%i):\n",
       resolution, diff, totaltime, interval, value);

  bzero (&maximus, sizeof (struct st_icolours));
  bzero (&minimus, sizeof (struct st_icolours));
  bzero (&average, sizeof (struct st_icolours));

  brk = 0;
  while ((brk == 0) && (GetTickCount () <= totaltime))
    {
      rst = GetOneLineInfo (resolution, &maximus, &minimus, &average);
      if (rst == 0)
	{
	  /* Pilla el mayor de los 3 colores mximos */
	  maxbigger = max (maximus.green, max (maximus.blue, maximus.red));
	  if (abs (maxbigger - *unknown) < diff)
	    brk++;
	  else
	    *unknown = maxbigger;
	}
      usleep (1000 * interval);
    }

  DBG (2, "- PWM_GetReady\n");

  return OK;
}

static SANE_Int
Lamp_WaitForPWM (SANE_Int resolution, SANE_Int scan_type)
{
  struct st_checkstable *mycheck = NULL;
  SANE_Int unknown;

  DBG (2, "+ Lamp_WaitForPWM(resolution=%i, scan_type=%i):\n", resolution,
       scan_type);

  switch (scan_type)
    {
    case 2:
      mycheck = &check_tma;
      break;			/* tma     */
    case 1:
      mycheck = &check_flb;
      break;			/* flb     */
    case 0:
      mycheck = &check_preview;
      break;			/* preview */
    default:
      mycheck = &check_preview;
      break;			/* preview */
    }
  /*42b64f5 */
  unknown = 0;
  if (mycheck != NULL)
    PWM_GetReady (resolution, &unknown, mycheck->diff,
		  mycheck->tottime + GetTickCount (), mycheck->interval, -1);

  DBG (2, "- Lamp_WaitForPWM\n");

  return OK;
}

/*static SANE_Int showbuffer(SANE_Int level, char *title, SANE_Byte *buffer, SANE_Int size)
{
	if (level <= DBG_LEVEL)
	{
		DBG(level, "%s\n", title);
		if ((size > 0) && (buffer != NULL))
		{
			SANE_Int cont, data, offset = 0;
			SANE_Int col = 0;
			char text[9];
			char *sline = NULL;
			char *sdata = NULL;

			sline = (char *)malloc(81);
			if (sline != NULL)
			{
				sdata = (char *)malloc(81);
				if (sdata != NULL)
				{
					for (cont = 0; cont < size; cont++)
					{
						if (col == 0)
						{
							if (cont == 0)
								snprintf(sline, 80, "           BF: ");
									else snprintf(sline, 80, "               ");
							bzero(&text, sizeof(text));
						}
						data = (buffer[cont] & 0xff);
						text[col] = (data > 31)? data: '';
						snprintf(sdata, 80, "%02x ", data);
						sline = strcat(sline, sdata);
						col++;
						offset++;
						if (col == 8)
						{
							col = 0;
							snprintf(sdata, 80, " : %s : %i\n", text, offset - 8);
							sline = strcat(sline, sdata);
							DBG(level, "%s", sline);
							bzero(sline, 81);
						}
					}
					if (col > 0)
					{
						for (cont = col; cont < 8; cont++)
						{
							snprintf(sdata, 80, "-- ");
							sline = strcat(sline, sdata);
							offset++;
						}
						snprintf(sdata, 80, " : %s : %i\n", text, offset - 8);
						sline = strcat(sline, sdata);
						DBG(level, "%s", sline);
						bzero(sline, 81);
					}
					free(sdata);
				}
				free(sline);
			}
		} else DBG(level, "           BF: Empty buffer\n");
	}

	return OK;
}
*/

static SANE_Byte
AutoRef_GetCount ()
{
  SANE_Byte data;

  DBG (2, "+ AutoRef_GetCount:\n");

  data = 0;
  if (IRead_Byte (0x78, &data, 0x200) != OK)
    data = 15;

  DBG (2, "- AutoRef_GetCount: %i\n", _B0 (data));

  return data;
}

static SANE_Int
AutoRef_SetCount (SANE_Byte data)
{
  SANE_Int rst;

  DBG (2, "+ AutoRef_SetCount(data=%i):\n", data);

  if (data > 15)
    data = 15;

  rst = IWrite_Byte (0x78, data, 0x200, 0x200);

  DBG (2, "- AutoRef_SetCount: %i\n", rst);

  return rst;
}

static SANE_Int
AutoRef_IncCount ()
{
  SANE_Byte data;

  DBG (2, "+ AutoRef_IncCount:\n");

  data = AutoRef_GetCount () + 1;

  if (data >= 15)
    data = 0;

  AutoRef_SetCount (data);

  DBG (2, "- AutoRef_IncCount() : Count=%i\n", data);

  return OK;
}

static SANE_Int
Load_StripCoords (SANE_Int scantype, SANE_Int * ypos, SANE_Int * xpos)
{
  SANE_Int iType;

  switch (scantype)
    {
    case 3:
      iType = CALIBNEGATIVEFILM;
      break;
    case 2:
      iType = CALIBTRANSPARENT;
      break;
    default:
      iType = CALIBREFLECTIVE;
      break;
    }

  *xpos = get_value (iType, WSTRIPXPOS, 0, FITCALIBRATE);
  *ypos = get_value (iType, WSTRIPYPOS, 0, FITCALIBRATE);

  DBG (2, "> Load_StripCoords(scantype=%i): ypos=%i, xpos=%i\n", scantype,
       *ypos, *xpos);

  return OK;
}

static SANE_Int
Lamp_Relocate (SANE_Int park, SANE_Int value, SANE_Int ypos)
{
  SANE_Byte Regs[0x71a];
  struct stmotormove mymotor;

  DBG (2, "+ Lamp_Relocate(park=%i, value=%i, ypos=%i):\n",
       park, value, ypos);

  bzero (&mymotor, sizeof (struct stmotormove));
  memcpy (&Regs, &BGeneral, 0x71a * sizeof (SANE_Byte));

  park--;

  if (park < motormovecount)
    {
      if (motormove[park].has_curves == TRUE)
	memcpy (&mymotor, &motormove[park], sizeof (struct stmotormove));
    }
  else
    {
      /* 83a3 */
      mymotor.has_curves = FALSE;
      /*mymotor.scanmotorsteptype = motormove[park].scanmotorsteptype;
         mymotor.ctpc              = motormove[park].ctpc;
         mymotor.systemclock       = motormove[park].systemclock; */
    }
  /*83fe */
  mymotor.coord_y = ypos;
  if (value == 0)
    mymotor.v12e435 = 0;
  else
    mymotor.v12e435 = 8;
  mymotor.v12e448 = 0x00;
  mymotor.v12e44c = 0x01;
  Lamp_ParkHome (Regs, &mymotor);
  /* waits 15 seconds */
  WaitEndingAction (15000);

  DBG (2, "- Lamp_Relocate\n");

  return OK;
}

static SANE_Int
Lamp_SetStatus2 (SANE_Int turnon, SANE_Int lamp)
{
  SANE_Byte Regs[0x71a];

  DBG (2, "> Lamp_SetStatus2(turnon=%i, lamp=%i)\n", turnon, lamp);

  return Lamp_SetStatus (Regs, turnon, lamp);
}

static SANE_Int
Calib_CreateFixedBuffers ()
{
  SANE_Byte channel;
  SANE_Int ret;

  DBG (2, "> Calib_CreateFixedBuffers()\n");

  ret = OK;
  channel = 0;

  while ((channel < 3) && (ret == OK))
    {
      /* First table */
      if (fixed_black_shading[channel] == NULL)
	fixed_black_shading[channel] =
	  (USHORT *) malloc (0x7f8 * sizeof (USHORT));

      if (fixed_black_shading[channel] != NULL)
	bzero (fixed_black_shading[channel], 0x7f8 * sizeof (USHORT));
      else
	ret = ERROR;

      /* Second table */
      if (fixed_white_shading[channel] == NULL)
	fixed_white_shading[channel] =
	  (USHORT *) malloc (0x7f8 * sizeof (USHORT));

      if (fixed_white_shading[channel] != NULL)
	bzero (fixed_white_shading[channel], 0x7f8 * sizeof (USHORT));
      else
	ret = ERROR;

      channel++;
    }

  return ret;
}

static SANE_Int
Calib_CreateBuffers (struct st_calibration *buffer, SANE_Int my14b4)
{
  SANE_Int ebp, ret, channel;

  ret = ERROR;

  buffer->shadinglength = scan.coord.width;
  ebp = 0x14;
  if ((dpi100Lumping == 0) && (scan.resolution_x == 100))
    {
      buffer->shadinglength = scan.coord.width * 2;
      ebp = 0x28;
    }

  if (my14b4 != 0)
    {
      /* 673d */
      if (Calib_CreateFixedBuffers () == OK)
	{
	  for (channel = 0; channel < 3; channel++)
	    {
	      buffer->white_shading[channel] = fixed_white_shading[channel];
	      buffer->black_shading[channel] = fixed_black_shading[channel];
	    }
	  ret = OK;
	}
    }
  else
    {
      /* 677f */
      SANE_Int pos;
      channel = 0;
      while ((channel < 3) && (ret == OK))
	{
	  buffer->black_shading[channel] =
	    (USHORT *) malloc (ebp +
			       (buffer->shadinglength * sizeof (USHORT)));
	  buffer->white_shading[channel] =
	    (USHORT *) malloc (ebp +
			       (buffer->shadinglength * sizeof (USHORT)));
	  if ((buffer->black_shading[channel] != NULL)
	      && (buffer->white_shading[channel] != NULL))
	    {
	      for (pos = 0; pos < buffer->shadinglength; pos++)
		{
		  buffer->black_shading[channel][pos] = 0x00;
		  buffer->white_shading[channel][pos] = 0x4000;
		}
	      ret = OK;
	    }
	  else
	    Calib_FreeBuffers (buffer);

	  channel++;
	}
    }

  DBG (2, "> Calib_CreateBuffers: *buffer, my14b4=%i): %i\n", my14b4, ret);

  return ret;
}

static void
Calib_FreeBuffers (struct st_calibration *caltables)
{
  DBG (2, "> Calib_FreeBuffers(*caltables)\n");

  if (caltables != NULL)
    {
      SANE_Int channel;

      for (channel = 0; channel < 3; channel++)
	{
	  if (caltables->black_shading[channel] != NULL)
	    {
	      free (caltables->black_shading[channel]);
	      caltables->black_shading[channel] = NULL;
	    }

	  if (caltables->white_shading[channel] != NULL)
	    {
	      free (caltables->white_shading[channel]);
	      caltables->white_shading[channel] = NULL;
	    }
	}
    }
}

static SANE_Int
Calib_LoadParams (struct st_calibration_data *calibdata, SANE_Int scantype,
		  SANE_Int resolution, SANE_Int bitmode)
{
  SANE_Int section, myoption = 0, mydefault = 0;

  DBG (2,
       "> Calib_LoadParams(*calibdata, scantype=%i, resolution=%i, bitmode=%i)\n",
       scantype, resolution, bitmode);

  switch (scantype)
    {
    case ST_NEG:
      section = CALIBNEGATIVEFILM;
      break;
    case ST_TA:
      section = CALIBTRANSPARENT;
      break;
    default:
      section = CALIBREFLECTIVE;
      break;
    }
  calibdata->WStripXPos = get_value (section, WSTRIPXPOS, 0, FITCALIBRATE);
  calibdata->WStripYPos = get_value (section, WSTRIPYPOS, 0, FITCALIBRATE);
  calibdata->BStripXPos = get_value (section, BSTRIPXPOS, 0, FITCALIBRATE);
  calibdata->BStripYPos = get_value (section, WSTRIPYPOS, 0, FITCALIBRATE);

  if (scantype == ST_NORMAL)
    {
      calibdata->WRef[CL_RED] =
	get_value (section, WREFR, 0xf2, FITCALIBRATE);
      calibdata->WRef[CL_GREEN] =
	get_value (section, WREFG, 0xee, FITCALIBRATE);
      calibdata->WRef[CL_BLUE] =
	get_value (section, WREFB, 0xe6, FITCALIBRATE);
    }
  else
    {
      /*45a9 */
      SANE_Int section2;
      SANE_Int option;
      SANE_Int Params[] =
	{ U1_T_8B_24D_WREF_R, U1_T_8B_24D_WREF_G, U1_T_8B_24D_WREF_B,
	U1_T_8B_12D_WREF_R, U1_T_8B_12D_WREF_G, U1_T_8B_12D_WREF_B,
	U1_T_8B_6D_WREF_R, U1_T_8B_6D_WREF_G, U1_T_8B_6D_WREF_B,
	U1_T_8B_3D_WREF_R, U1_T_8B_3D_WREF_G, U1_T_8B_3D_WREF_B,
	U1_T_8B_2D_WREF_R, U1_T_8B_2D_WREF_G, U1_T_8B_2D_WREF_B,
	U1_T_8B_1D_WREF_R, U1_T_8B_1D_WREF_G, U1_T_8B_1D_WREF_B,
	U1_T_16B_24D_WREF_R, U1_T_16B_24D_WREF_G, U1_T_16B_24D_WREF_B,
	U1_T_16B_12D_WREF_R, U1_T_16B_12D_WREF_G, U1_T_16B_12D_WREF_B,
	U1_T_16B_6D_WREF_R, U1_T_16B_6D_WREF_G, U1_T_16B_6D_WREF_B,
	U1_T_16B_3D_WREF_R, U1_T_16B_3D_WREF_G, U1_T_16B_3D_WREF_B,
	U1_T_16B_2D_WREF_R, U1_T_16B_2D_WREF_G, U1_T_16B_2D_WREF_B,
	U1_T_16B_1D_WREF_R, U1_T_16B_1D_WREF_G, U1_T_16B_1D_WREF_B,
	U1_S_8B_24D_WREF_R, U1_S_8B_24D_WREF_G, U1_S_8B_24D_WREF_B,
	U1_S_8B_12D_WREF_R, U1_S_8B_12D_WREF_G, U1_S_8B_12D_WREF_B,
	U1_S_8B_6D_WREF_R, U1_S_8B_6D_WREF_G, U1_S_8B_6D_WREF_B,
	U1_S_8B_3D_WREF_R, U1_S_8B_3D_WREF_G, U1_S_8B_3D_WREF_B,
	U1_S_8B_2D_WREF_R, U1_S_8B_2D_WREF_G, U1_S_8B_2D_WREF_B,
	U1_S_8B_1D_WREF_R, U1_S_8B_1D_WREF_G, U1_S_8B_1D_WREF_B,
	U1_S_16B_24D_WREF_R, U1_S_16B_24D_WREF_G, U1_S_16B_24D_WREF_B,
	U1_S_16B_12D_WREF_R, U1_S_16B_12D_WREF_G, U1_S_16B_12D_WREF_B,
	U1_S_16B_6D_WREF_R, U1_S_16B_6D_WREF_G, U1_S_16B_6D_WREF_B,
	U1_S_16B_3D_WREF_R, U1_S_16B_3D_WREF_G, U1_S_16B_3D_WREF_B,
	U1_S_16B_2D_WREF_R, U1_S_16B_2D_WREF_G, U1_S_16B_2D_WREF_B,
	U1_S_16B_1D_WREF_R, U1_S_16B_1D_WREF_G, U1_S_16B_1D_WREF_B,
	U2_T_8B_24D_WREF_R, U2_T_8B_24D_WREF_G, U2_T_8B_24D_WREF_B,
	U2_T_8B_12D_WREF_R, U2_T_8B_12D_WREF_G, U2_T_8B_12D_WREF_B,
	U2_T_8B_6D_WREF_R, U2_T_8B_6D_WREF_G, U2_T_8B_6D_WREF_B,
	U2_T_8B_3D_WREF_R, U2_T_8B_3D_WREF_G, U2_T_8B_3D_WREF_B,
	U2_T_8B_2D_WREF_R, U2_T_8B_2D_WREF_G, U2_T_8B_2D_WREF_B,
	U2_T_8B_1D_WREF_R, U2_T_8B_1D_WREF_G, U2_T_8B_1D_WREF_B,
	U2_T_16B_24D_WREF_R, U2_T_16B_24D_WREF_G, U2_T_16B_24D_WREF_B,
	U2_T_16B_12D_WREF_R, U2_T_16B_12D_WREF_G, U2_T_16B_12D_WREF_B,
	U2_T_16B_6D_WREF_R, U2_T_16B_6D_WREF_G, U2_T_16B_6D_WREF_B,
	U2_T_16B_3D_WREF_R, U2_T_16B_3D_WREF_G, U2_T_16B_3D_WREF_B,
	U2_T_16B_2D_WREF_R, U2_T_16B_2D_WREF_G, U2_T_16B_2D_WREF_B,
	U2_T_16B_1D_WREF_R, U2_T_16B_1D_WREF_G, U2_T_16B_1D_WREF_B,
	U2_S_8B_24D_WREF_R, U2_S_8B_24D_WREF_G, U2_S_8B_24D_WREF_B,
	U2_S_8B_12D_WREF_R, U2_S_8B_12D_WREF_G, U2_S_8B_12D_WREF_B,
	U2_S_8B_6D_WREF_R, U2_S_8B_6D_WREF_G, U2_S_8B_6D_WREF_B,
	U2_S_8B_3D_WREF_R, U2_S_8B_3D_WREF_G, U2_S_8B_3D_WREF_B,
	U2_S_8B_2D_WREF_R, U2_S_8B_2D_WREF_G, U2_S_8B_2D_WREF_B,
	U2_S_8B_1D_WREF_R, U2_S_8B_1D_WREF_G, U2_S_8B_1D_WREF_B,
	U2_S_16B_24D_WREF_R, U2_S_16B_24D_WREF_G, U2_S_16B_24D_WREF_B,
	U2_S_16B_12D_WREF_R, U2_S_16B_12D_WREF_G, U2_S_16B_12D_WREF_B,
	U2_S_16B_6D_WREF_R, U2_S_16B_6D_WREF_G, U2_S_16B_6D_WREF_B,
	U2_S_16B_3D_WREF_R, U2_S_16B_3D_WREF_G, U2_S_16B_3D_WREF_B,
	U2_S_16B_2D_WREF_R, U2_S_16B_2D_WREF_G, U2_S_16B_2D_WREF_B,
	U2_S_16B_1D_WREF_R, U2_S_16B_1D_WREF_G, U2_S_16B_1D_WREF_B
      };

      if (scantype == 2)
	section2 = CALIBNEGATIVEFILM;
      else
	section2 = CALIBTRANSPARENT;

      option = 0;
      if (usbtype != USB11)
	option += 71;

      if (ccdtype == SONY)
	option += 36;

      if (bitmode != 8)
	option += 18;

      if (resolution < 2400)
	{
	  option += 3;
	  if (resolution < 1200)
	    {
	      option += 3;
	      if (resolution < 600)
		{
		  option += 3;
		  if (resolution < 300)
		    {
		      option += 3;
		      if (resolution < 200)
			option += 3;
		    }
		}
	    }
	}

      calibdata->WRef[CL_RED] =
	get_value (section2, Params[option], 0x50, FITCALIBRATE);
      calibdata->WRef[CL_GREEN] =
	get_value (section2, Params[option + 1], 0x50, FITCALIBRATE);
      calibdata->WRef[CL_BLUE] =
	get_value (section2, Params[option + 2], 0x50, FITCALIBRATE);
    }
  /* 4913 */
  WRef[CL_RED] = _B0 (calibdata->WRef[CL_RED]);
  WRef[CL_GREEN] = _B0 (calibdata->WRef[CL_GREEN]);
  WRef[CL_BLUE] = _B0 (calibdata->WRef[CL_BLUE]);

  calibdata->BRef[CL_RED] = get_value (section, BREFR, 10, FITCALIBRATE);
  calibdata->BRef[CL_GREEN] = get_value (section, BREFG, 10, FITCALIBRATE);
  calibdata->BRef[CL_BLUE] = get_value (section, BREFB, 10, FITCALIBRATE);
  calibdata->RefBitDepth =
    _B0 (get_value (section, REFBITDEPTH, 8, FITCALIBRATE));
  calibdata->CalibOffset10n =
    _B0 (get_value (section, CALIBOFFSET10N, 3, FITCALIBRATE));
  calibdata->CalibOffset20n =
    _B0 (get_value (section, CALIBOFFSET20N, 0, FITCALIBRATE));
  calibdata->OffsetEven1[CL_RED] =
    _B0 (get_value (section, OFFSETEVEN1R, 256, FITCALIBRATE));
  calibdata->OffsetEven1[CL_GREEN] =
    _B0 (get_value (section, OFFSETEVEN1G, 256, FITCALIBRATE));
  calibdata->OffsetEven1[CL_BLUE] =
    _B0 (get_value (section, OFFSETEVEN1B, 256, FITCALIBRATE));
  calibdata->OffsetEven2[CL_RED] =
    _B0 (get_value (section, OFFSETEVEN2R, 0, FITCALIBRATE));
  calibdata->OffsetEven2[CL_GREEN] =
    _B0 (get_value (section, OFFSETEVEN2G, 0, FITCALIBRATE));
  calibdata->OffsetEven2[CL_BLUE] =
    _B0 (get_value (section, OFFSETEVEN2B, 0, FITCALIBRATE));
  calibdata->OffsetOdd1[CL_RED] =
    _B0 (get_value (section, OFFSETODD1R, 256, FITCALIBRATE));
  calibdata->OffsetOdd1[CL_GREEN] =
    _B0 (get_value (section, OFFSETODD1G, 256, FITCALIBRATE));
  calibdata->OffsetOdd1[CL_BLUE] =
    _B0 (get_value (section, OFFSETODD1B, 256, FITCALIBRATE));
  calibdata->OffsetOdd2[CL_RED] =
    _B0 (get_value (section, OFFSETODD2R, 0, FITCALIBRATE));
  calibdata->OffsetOdd2[CL_GREEN] =
    _B0 (get_value (section, OFFSETODD2G, 0, FITCALIBRATE));
  calibdata->OffsetOdd2[CL_BLUE] =
    _B0 (get_value (section, OFFSETODD2B, 0, FITCALIBRATE));
  calibdata->OffsetHeight =
    _B0 (get_value (section, OFFSETHEIGHT, 10, FITCALIBRATE));

  /* 4ae9 */
  switch (resolution)
    {
    case 100:
    case 200:
      if (ccdtype == TOSHIBA)
	{
	  myoption = T2952_OFFSETPIXELSTART_200;
	  mydefault = 0x19;
	}
      else
	{
	  myoption = S575_OFFSETPIXELSTART_200;
	  mydefault = 0x34;
	}
      calibdata->OffsetPixelStart =
	_B0 (get_value (section, myoption, mydefault, FITCALIBRATE));
      calibdata->OffsetNPixel =
	_B0 (get_value (section, OFFSETNPIXEL_200, 0x10, FITCALIBRATE));
      break;
    case 300:
      if (ccdtype == TOSHIBA)
	{
	  myoption = T2952_OFFSETPIXELSTART_300;
	  mydefault = 0x19;
	}
      else
	{
	  myoption = S575_OFFSETPIXELSTART_300;
	  mydefault = 0x37;
	}
      calibdata->OffsetPixelStart =
	_B0 (get_value (section, myoption, mydefault, FITCALIBRATE));
      calibdata->OffsetNPixel =
	_B0 (get_value (section, OFFSETNPIXEL_300, 0x10, FITCALIBRATE));
      break;
    case 600:
      mydefault = 0x3c;
      if (ccdtype == TOSHIBA)
	myoption = T2952_OFFSETPIXELSTART_600;
      else
	myoption = S575_OFFSETPIXELSTART_600;
      calibdata->OffsetPixelStart =
	_B0 (get_value (section, myoption, mydefault, FITCALIBRATE));
      calibdata->OffsetNPixel =
	_B0 (get_value (section, OFFSETNPIXEL_600, 0x14, FITCALIBRATE));
      break;
    case 1200:
      if (ccdtype == TOSHIBA)
	{
	  myoption = T2952_OFFSETPIXELSTART_1200;
	  mydefault = 0x3c;
	}
      else
	{
	  myoption = S575_OFFSETPIXELSTART_1200;
	  mydefault = 0x51;
	}
      calibdata->OffsetPixelStart =
	_B0 (get_value (section, myoption, mydefault, FITCALIBRATE));
      calibdata->OffsetNPixel =
	_B0 (get_value (section, OFFSETNPIXEL_1200, 0x24, FITCALIBRATE));
      break;
    case 2400:
      mydefault = 0x64;
      myoption =
	(ccdtype ==
	 TOSHIBA) ? T2952_OFFSETPIXELSTART_2400 : S575_OFFSETPIXELSTART_2400;

      calibdata->OffsetPixelStart =
	_B0 (get_value (section, myoption, mydefault, FITCALIBRATE));
      calibdata->OffsetNPixel =
	_B0 (get_value (section, OFFSETNPIXEL_2400, 0x24, FITCALIBRATE));
      break;
    }
  /*4c49 */
  calibdata->OffsetNSigma =
    get_value (section, OFFSETNSIGMA, 2, FITCALIBRATE);
  calibdata->OffsetTargetMax =
    get_value (section, OFFSETTARGETMAX, 0x32, FITCALIBRATE) * 0.01;
  calibdata->OffsetTargetMin =
    get_value (section, OFFSETTARGETMIN, 2, FITCALIBRATE) * 0.01;
  calibdata->OffsetBoundaryRatio1 =
    get_value (section, OFFSETBOUNDARYRATIO1, 0x64, FITCALIBRATE) * 0.01;
  calibdata->OffsetBoundaryRatio2 =
    get_value (section, OFFSETBOUNDARYRATIO2, 0x64, FITCALIBRATE) * 0.01;

  calibdata->OffsetAvgTarget[CL_RED] =
    _B0 (get_value (section, OFFSETAVGTARGETR, 0x0d, FITCALIBRATE));
  calibdata->OffsetAvgTarget[CL_GREEN] =
    _B0 (get_value (section, OFFSETAVGTARGETG, 0x0d, FITCALIBRATE));
  calibdata->OffsetAvgTarget[CL_BLUE] =
    _B0 (get_value (section, OFFSETAVGTARGETB, 0x0d, FITCALIBRATE));

  calibdata->OffsetAvgRatio1 =
    get_value (section, OFFSETAVGRATIO1, 0x64, FITCALIBRATE) * 0.01;
  calibdata->OffsetAvgRatio2 =
    get_value (section, OFFSETAVGRATIO2, 0x64, FITCALIBRATE) * 0.01;
  calibdata->AdcOffQuickWay =
    get_value (section, ADCOFFQUICKWAY, 1, FITCALIBRATE);
  calibdata->AdcOffPredictStart =
    get_value (section, ADCOFFPREDICTSTART, 0xc8, FITCALIBRATE);
  calibdata->AdcOffPredictEnd =
    get_value (section, ADCOFFPREDICTEND, 0x1f4, FITCALIBRATE);
  calibdata->AdcOffEvenOdd =
    get_value (section, ADCOFFEVENODD, 1, FITCALIBRATE);
  calibdata->OffsetTuneStep1 =
    _B0 (get_value (section, OFFSETTUNESTEP1, 1, FITCALIBRATE));
  calibdata->OffsetTuneStep2 =
    _B0 (get_value (section, OFFSETTUNESTEP2, 1, FITCALIBRATE));
  calibdata->CalibGain10n =
    get_value (section, CALIBGAIN10N, 1, FITCALIBRATE);
  calibdata->CalibGain20n =
    get_value (section, CALIBGAIN20N, 0, FITCALIBRATE);
  calibdata->CalibPAGOn = get_value (section, CALIBPAGON, 0, FITCALIBRATE);

  calibdata->PAG[CL_RED] = get_value (section, PAGR, 3, FITCALIBRATE);
  calibdata->PAG[CL_GREEN] = get_value (section, PAGG, 3, FITCALIBRATE);
  calibdata->PAG[CL_BLUE] = get_value (section, PAGB, 3, FITCALIBRATE);

  calibdata->Gain1[CL_RED] = get_value (section, GAIN1R, 4, FITCALIBRATE);
  calibdata->Gain1[CL_GREEN] = get_value (section, GAIN1G, 4, FITCALIBRATE);
  calibdata->Gain1[CL_BLUE] = get_value (section, GAIN1B, 4, FITCALIBRATE);

  calibdata->Gain2[CL_RED] = get_value (section, GAIN2R, 4, FITCALIBRATE);
  calibdata->Gain2[CL_GREEN] = get_value (section, GAIN2G, 4, FITCALIBRATE);
  calibdata->Gain2[CL_BLUE] = get_value (section, GAIN2B, 4, FITCALIBRATE);

  calibdata->GainHeight = get_value (section, GAINHEIGHT, 0x1e, FITCALIBRATE);
  calibdata->GainTargetFactor =
    get_value (section, GAINTARGETFACTOR, 0x5a, FITCALIBRATE) * 0.01;
  calibdata->TotShading = get_value (section, TOTSHADING, 0, FITCALIBRATE);
  calibdata->WShadingOn = get_value (section, WSHADINGON, 3, FITCALIBRATE);
  calibdata->WShadingHeight =
    get_value (section, WSHADINGHEIGHT, 0x18, FITCALIBRATE);

  calibdata->WShadingPreDiff[CL_RED] =
    get_value (section, WSHADINGPREDIFFR, -1, FITCALIBRATE);
  calibdata->WShadingPreDiff[CL_GREEN] =
    get_value (section, WSHADINGPREDIFFG, -1, FITCALIBRATE);
  calibdata->WShadingPreDiff[CL_BLUE] =
    get_value (section, WSHADINGPREDIFFB, -1, FITCALIBRATE);

  calibdata->BShadingOn = get_value (section, BSHADINGON, 2, FITCALIBRATE);
  calibdata->BShadingHeight =
    get_value (section, BSHADINGHEIGHT, 0x1e, FITCALIBRATE);

  calibdata->BShadingPreDiff[CL_RED] =
    get_value (section, BSHADINGPREDIFFR, 2, FITCALIBRATE);
  calibdata->BShadingPreDiff[CL_GREEN] =
    get_value (section, BSHADINGPREDIFFG, 2, FITCALIBRATE);
  calibdata->BShadingPreDiff[CL_BLUE] =
    get_value (section, BSHADINGPREDIFFB, 2, FITCALIBRATE);

  calibdata->BShadingDefCutOff =
    get_value (section, BSHADINGDEFCUTOFF, 0, FITCALIBRATE);
  calibdata->ExternBoundary =
    get_value (AUTOREFPOS, EXTERNBOUNDARY, 0x28, FITCALIBRATE) * 0.01;

  /* 5084 */
  switch (resolution)
    {
    case 100:
    case 200:
    case 300:
    case 600:
      if (ccdtype == TOSHIBA)
	{
	  myoption = T2952_STARTEFFECTIVEPIXEL_600;
	  mydefault = 0xa0;
	}
      else
	{
	  myoption = S575_STARTEFFECTIVEPIXEL_600;
	  mydefault = 0xac;
	}
      break;
    case 1200:
      if (ccdtype == TOSHIBA)
	{
	  myoption = T2952_STARTEFFECTIVEPIXEL_1200;
	  mydefault = 0x40;
	}
      else
	{
	  myoption = S575_STARTEFFECTIVEPIXEL_1200;
	  mydefault = 0xaa;
	}
      break;
    case 2400:
      if (ccdtype == TOSHIBA)
	{
	  myoption = T2952_STARTEFFECTIVEPIXEL_2400;
	  mydefault = 0x40;
	}
      else
	{
	  myoption = S575_STARTEFFECTIVEPIXEL_2400;
	  mydefault = 0x94;
	}
      break;
    }
  calibdata->EffectivePixel =
    get_value (AUTOREFPOS, myoption, mydefault, FITCALIBRATE);

  return OK;
}

static SANE_Int
Calib_PAGain (struct st_calibration_data *calibdata, SANE_Int gainmode)
{
  SANE_Byte myRegisters[0x71a];
  struct st_scanparams bakscan;
  SANE_Int bytes_to_next_colour = 0;
  SANE_Int bytes_per_pixel = 0;
  SANE_Int length = 0;
  SANE_Byte *scanbuffer;
  SANE_Byte *pointer_0, *pointer_1, *pointer_2;
  SANE_Int vmin[3] = { 255, 255, 255 };	/* f16c|f16e|f170 */
  SANE_Int vmax[3] = { 0, 0, 0 };	/* f164|f166|f168 */
  SANE_Int total[3];
  double rst;
  SANE_Byte color;
  SANE_Int ret = ERROR;

  DBG (2, "+ Calib_PAGain(*calibdata, gainmode=%i)\n", gainmode);

  memcpy (&myRegisters, &bkRegisters, 0x71a * sizeof (SANE_Byte));
  memcpy (&bakscan, &cpyscan, sizeof (struct st_scanparams));

  if (scan.scantype != ST_NORMAL)
    {
      if ((scan.scantype > 1) && (scan.scantype < 4))
	{
	  bakscan.coord.left = scan.ser + v0750;
	  bakscan.coord.width = (bakscan.sensorresolution * 3) / 2;
	}
    }
  else
    {
      /* bfa5 */
      bakscan.coord.left = scan.ser;
      bakscan.coord.width = (bakscan.sensorresolution * 17) / 2;
    }

  /* bfca */
  if ((bakscan.coord.width & 1) == 1)
    bakscan.coord.width++;

  bakscan.coord.top = 1;
  bakscan.coord.height = calibdata->OffsetHeight;

  switch (bakscan.colormode)
    {
    case CM_GRAY:
    case CM_LINEART:
      bytes_to_next_colour = 0;
      bytes_per_pixel = 1;
      length = ((bakscan.depth + 7) / 8) * bakscan.coord.width;
      break;
    case 0:
      /* c027 */
      bytes_to_next_colour = 1;
      length = (((_B0 (bakscan.depth) + 7) / 8) * bakscan.coord.width) * 3;
      if (bakscan.samplerate != FALSE)
	{
	  bytes_to_next_colour = bakscan.coord.width;
	  bytes_per_pixel = 1;
	}
      else
	bytes_per_pixel = 3;
      break;
    }

  /* c070 */
  bakscan.v157c = length;

  scanbuffer =
    (SANE_Byte *) malloc ((bakscan.coord.height * length) *
			  sizeof (SANE_Byte));
  if (scanbuffer != NULL)
    {
      ret =
	RTS_GetImage (myRegisters, &bakscan, &mitabla, scanbuffer, 0x00, 0x01,
		      gainmode);
      if (ret == OK)
	{
	  /* 429c105 */
	  pointer_0 = scanbuffer;
	  pointer_1 = scanbuffer + (bytes_to_next_colour * 2);
	  pointer_2 = scanbuffer + bytes_to_next_colour;

	  if (bakscan.coord.width > 0)
	    {
	      SANE_Int pos = bakscan.coord.width;
	      SANE_Int myheight;
	      SANE_Byte b;
	      do
		{
		  total[CL_BLUE] = 0;
		  total[CL_GREEN] = 0;
		  total[CL_RED] = 0;
		  myheight = bakscan.coord.height;

		  while (myheight > 0)
		    {
		      total[CL_GREEN] +=
			pointer_0[(bakscan.coord.height - myheight) * length];
		      total[CL_GREEN] +=
			pointer_2[(bakscan.coord.height - myheight) * length];
		      total[CL_BLUE] +=
			pointer_1[(bakscan.coord.height - myheight) * length];
		      myheight--;
		    }

		  /* c1a5 */
		  for (b = 0; b < 3; b++)
		    {
		      total[b] /= bakscan.coord.height;
		      vmin[b] = min (vmin[b], total[b]);
		      vmax[b] = max (vmax[b], total[b]);
		    }

		  pointer_0 += bytes_per_pixel;
		  pointer_1 += bytes_per_pixel;
		  pointer_2 += bytes_per_pixel;
		  pos--;
		}
	      while (pos > 0);
	    }

	  /* 429c234 */
	  for (color = CL_RED; color <= CL_BLUE; color++)
	    {
	      rst =
		(calibdata->WRef[color] * calibdata->GainTargetFactor) /
		vmax[color];
	      if (rst <= 1.5)
		{
		  if (rst <= 1.286)
		    {
		      if (rst <= 1.125)
			mitabla.pag[color] = 0;
		      else
			mitabla.pag[color] = 1;
		    }
		  else
		    mitabla.pag[color] = 2;
		}
	      else
		mitabla.pag[color] = 3;
	    }

	  free (scanbuffer);
	}
      else
	free (scanbuffer);
    }

  DBG (2, "- Calib_PAGain: %i\n", ret);

  return ret;
}

static SANE_Int
Chipset_ID ()
{
  SANE_Int ret;

  if (Read_Word (0xfe3c, &ret) == OK)
    ret = _B0 (ret);
  else
    ret = 0;

  DBG (2, "> Chipset_ID(): %i\n", ret);

  return ret;
}

static SANE_Int
Chipset_Name (char *name, SANE_Int size)
{
  SANE_Int rst = ERROR;

  if (name != NULL)
    {
      switch (Chipset_ID ())
	{
	case 1:
	  snprintf (name, size, "RTS8822-01B");
	  break;
	case 2:
	  snprintf (name, size, "RTS8822-01C");
	  break;
	case 3:
	  snprintf (name, size, "RTS8822L-01C");
	  break;
	case 4:
	  snprintf (name, size, "RTS8822L-01H");
	  break;
	default:
	  snprintf (name, size, "unknown");
	  break;
	}
      rst = OK;
    }

  return rst;
}

static SANE_Int
Refs_GetOrigin (SANE_Int * left_leading, SANE_Int * start_pos)
{
  SANE_Int data;
  SANE_Int ret;

  DBG (2, "+ Refs_GetOrigin:\n");

  ret = ERROR;

  *start_pos = 0;
  *left_leading = 0;

  if (IRead_Word (0x006a, &data, 0x200) == OK)
    {
      *left_leading = data;
      if (IRead_Word (0x006c, &data, 0x200) == OK)
	{
	  *start_pos = data;
	  if (IRead_Word (0x006e, &data, 0x200) == OK)
	    {
	      if ((_B0 (*start_pos + *left_leading + data)) == 0x5a)
		ret = OK;
	    }
	}
    }

  DBG (2, "- Refs_GetOrigin(start_pos=%i, left_leading=%i) : %i\n",
       *start_pos, *left_leading, ret);

  return ret;
}

static SANE_Int
Refs_SetOrigin (SANE_Int left_leading, SANE_Int start_pos)
{
  SANE_Int ret;

  DBG (2, "+ Refs_SetOrigin(left_leading=%i, start_pos=%i)\n", left_leading,
       start_pos);

  ret = ERROR;
  if (IWrite_Word (0x6a, left_leading, 0x200) == OK)
    {
      if (IWrite_Word (0x6c, start_pos, 0x200) == OK)
	{
	  SANE_Byte data = _B0 (0x5a - (start_pos + left_leading));
	  ret = IWrite_Byte (0x006e, data, 0x200, 0x200);
	}
    }

  DBG (2, "- Refs_SetOrigin: %i\n", ret);

  return ret;
}

#ifdef DONTUSE
static SANE_Int
Calib_AdcOffsetRT (struct st_calibration_data *calibdata, SANE_Int value)
{
/*
05EFF8E4   04F10738  |Arg1 = 04F10738
05EFF8E8   05EFF90C  |Arg2 = 05EFF90C calibdata
05EFF8EC   00000001  \Arg3 = 00000001 value
*/
  SANE_Byte Regs[0x71a];	/*f1c4 */
  SANE_Int channels_per_dot;	/*f108 */
  struct st_scanparams scancfg;	/*f18c */
  USHORT *pedcg;		/*f114 */
  USHORT *podcg;		/*f118 */
  SANE_Int *poffseteven;	/*f130 */
  SANE_Int *poffsetodd;		/*f128 */
  SANE_Int a, b, c;
  SANE_Int avgtarget[3];	/*f1b8 f1bc f1c0 */
  SANE_Int myoffsetnpixel;	/*f120 */
  SANE_Byte *scanbuffer;	/*f0f8 */
  SANE_Int lf12c;		/*f12c */
  SANE_Int highresolution;	/*f144 */
  double dbValues[3] = { 0, 0, 0 };	/*f148 f14c f150 */
  SANE_Int lf0ec;		/*f0ec */
  SANE_Int gainmode;
  SANE_Int ivalues[6];		/*f134 f138 f13c *//*f174 f178 f17c f180 f184 f18c */
  SANE_Byte *ptr;		/*f0f4 */
  SANE_Byte *mvgag;		/*f0e4 *//*f10c */
  SANE_Int desp;		/*f0e8 *//*f140 */
  USHORT wvalues[9];		/*0856 0858 085a 085c 085e 0860 0862 0864 0866 */
  SANE_Int imgcount = 0;

  DBG (2, "+ Calib_AdcOffsetRT(*calibdata, value=%i)\n", value);

  memcpy (&Regs, &bkRegisters, 0x71a * sizeof (SANE_Byte));
  memcpy (&scancfg, &cpyscan, sizeof (struct st_scanparams));

  channels_per_dot = (cpyscan.colormode == CM_COLOR) ? 3 : 1;

  if (value != 0)
    {
      pedcg = &mitabla.edcg1[CL_RED];
      podcg = &mitabla.odcg1[CL_RED];
      poffseteven = &calibdata->OffsetEven1[CL_RED];
      poffsetodd = &calibdata->OffsetOdd1[CL_RED];
    }
  else
    {
      /*c37c */
      pedcg = &mitabla.edcg2[CL_RED];
      podcg = &mitabla.odcg2[CL_RED];
      poffseteven = &calibdata->OffsetEven2[CL_RED];
      poffsetodd = &calibdata->OffsetOdd2[CL_RED];
    }

  /*c3a4 */
  scancfg.coord.left = calibdata->OffsetPixelStart;

  if (channels_per_dot > 0)
    {
      for (a = 0; a < channels_per_dot; a++)
	{
	  avgtarget[a] = calibdata->OffsetAvgTarget[a] << 8;
	  if (avgtarget[a] == 0)
	    avgtarget[a] = 0x80;
	}
    }

  myoffsetnpixel = calibdata->OffsetNPixel & 0xffff;
  scancfg.coord.width = calibdata->OffsetNPixel & 0xffff;
  if ((scancfg.coord.width & 1) == 0)
    scancfg.coord.width++;

  scancfg.bytesperline = channels_per_dot * scancfg.coord.width;

  scancfg.coord.top = 1;
  scancfg.coord.height = calibdata->OffsetHeight;
  scancfg.depth = 8;
  scanbuffer =
    (SANE_Byte *) malloc ((scancfg.bytesperline * calibdata->OffsetHeight) *
			  sizeof (SANE_Byte));
  if (scanbuffer == NULL)
    return ERROR;

  /*42ac477 */
  lf12c = (linedarlampoff == 1) ? 1 : 0x101;
  highresolution = (scancfg.sensorresolution >= 1200) ? TRUE : FALSE;

  do
    {
      if (channels_per_dot > 0)
	{
	  for (a = 0; a < channels_per_dot; a++)
	    dbValues[a] =
	      (40 / (44 - mitabla.vgag2[a])) * (40 / (44 - mitabla.vgag1[a]));
	}

      /*429c50f */
      gainmode = Lamp_GetGainMode (scancfg.resolution_x, scan.scantype);
      if (RTS_GetImage
	  (Regs, &scancfg, &mitabla, scanbuffer, 0, lf12c, gainmode) != OK)
	{
	  free (scanbuffer);
	  return ERROR;
	}

      /*429c55f */
      if (RTS_Debug.SaveCalibFile != FALSE)
	{
	  char fname[30];

	  imgcount++;
	  if (snprintf (fname, 29, "adcoffset_rt%i.tiff", imgcount) > 0)
	    TIFF_Save (fname,
		       scancfg.coord.width,
		       scancfg.coord.height,
		       scancfg.depth,
		       scanbuffer,
		       scancfg.bytesperline * calibdata->OffsetHeight);
	}

      /*429c5a5 */
      lf0ec = 0;
      if (highresolution == TRUE)
	{
	  SANE_Int lf0e4, lf0fc, lf104;
	  USHORT *mydcg;	/*f0f4 */
	  USHORT *mywvalue;	/*ebp */
	  SANE_Int *myivalue;	/*f11c */
	  SANE_Int myedi;
	  SANE_Int myesi;
	  SANE_Int c, d;

	  for (a = 0; a < 6; a++)
	    ivalues[a] = 0;

	  if (channels_per_dot <= 0)
	    break;

	  lf0e4 = 0;
	  lf0fc = 0;

	  ptr = scanbuffer;
	  mvgag = (SANE_Byte *) mitabla.vgag1;

	  for (a = 0; a < channels_per_dot; a++)
	    {
	      for (lf104 = 0; lf104 < 2; lf104++)
		{
		  if (lf104 == 0)
		    {
		      mywvalue = &wvalues[a];
		      mydcg = pedcg;
		      myivalue = &ivalues[0];
		    }
		  else
		    {
		      /*1645 */
		      mydcg = podcg;
		      myivalue = &ivalues[3];
		      mywvalue = &wvalues[3];
		    }

		  /*1658 */
		  if (myivalue[lf0fc] == 0)
		    {
		      myedi = 0;
		      if (lf104 < myoffsetnpixel)
			for (b = 0; b < (myoffsetnpixel - lf104 + 1) / 2; b++)
			  myedi +=
			    scanbuffer[mvgag[(lf104 * channels_per_dot)] +
				       (b * (channels_per_dot * 2))];

		      /*c6b2 */
		      myedi = myedi << 8;
		      if (myedi == 0)
			{
			  /*c6b9 */
			  if (mydcg[lf0e4] != 0x1ff)
			    {
			      /*c6d5 */
			      mydcg[lf0e4] = 0x1ff;
			      lf0ec = 1;
			    }
			  else
			    myivalue[lf0fc] = 1;
			}
		      else
			{
			  /*c6e8 */
			  if (*mywvalue == 0)
			    mywvalue += 2;

			  c = myedi / (myoffsetnpixel / 2);
			  if (c >= avgtarget[lf0fc])
			    {
			      c -= avgtarget[lf0fc];
			      myesi = 0;
			    }
			  else
			    {
			      c = avgtarget[lf0fc] - c;
			      myesi = 1;
			    }

			  d = mydcg[lf0e4];
			  if (d < 0x100)
			    d = 0xff - d;

			  if (myesi != 0)
			    {
			      /*c76e */
			      if ((d + c) > 0x1ff)
				{
				  if (*mvgag > 0)
				    {
				      *mvgag--;
				      lf0ec = 1;
				    }
				  else
				    myivalue[lf0fc] = 1;	/*c7a0 */
				}
			      else
				d += c;
			    }
			  else
			    {
			      /*c7ad */
			      if (c > d)
				{
				  if (*mvgag > 0)
				    {
				      *mvgag--;
				      lf0ec = 1;
				    }
				  else
				    myivalue[lf0fc] = 1;
				}
			      else
				d -= c;
			    }
			  /*c7dd */
			  mydcg[lf0e4] = (d < 0x100) ? 0x100 - d : d;
			}
		      show_calibtable (&mitabla);
		    }
		}
	      /*c804 */
	      lf0e4++;
	      mvgag++;
	      lf0fc++;
	    }
	}
      else
	{
	  /*429c845 */
	  for (a = 0; a < 3; a++)
	    ivalues[a] = 0;

	  if (channels_per_dot <= 0)
	    break;

	  ptr = scanbuffer;
	  mvgag = (SANE_Byte *) mitabla.vgag1;
	  desp = podcg - pedcg;

	  for (a = 0; a < channels_per_dot; a++)
	    {
	      if (ivalues[a] == 0)
		{
		  c = 0;
		  if (myoffsetnpixel > 0)
		    {
		      for (b = 0; b < myoffsetnpixel; b++)
			c += *(ptr + (b * channels_per_dot));
		    }

		  c = c << 8;
		  if (c == 0)
		    {
		      if (pedcg[a] == 0x1ff)
			ivalues[a] = 1;
		      else
			{
			  lf0ec = 1;
			  podcg[a] = 0x1ff;
			  pedcg[a] = 0x1ff;
			}
		    }
		  else
		    {
		      /*c8f7 */
		      SANE_Int myesi;
		      SANE_Int op1, op2, op3;

		      c /= myoffsetnpixel;
		      if (c > avgtarget[a])
			{
			  c -= avgtarget[a];
			  myesi = 0;
			}
		      else
			{
			  c = avgtarget[a] - c;
			  myesi = 1;
			}

		      if (scancfg.resolution_x > 600)
			{
			  /*c923 */
			  if (wvalues[a + 3] == 0)
			    wvalues[a + 3]++;

			  if (wvalues[a] == 0)
			    wvalues[a]++;

			  op3 = max (wvalues[a], wvalues[a + 3]);
			}
		      else
			{
			  if (wvalues[a + 6] == 0)
			    wvalues[a + 6]++;

			  op3 = wvalues[a + 6];
			}

		      /*c9d3 */
		      op1 = (SANE_Int) (c / (dbValues[a] * op3));
		      op2 = (pedcg[a] < 0x100) ? pedcg[a] - 0xff : pedcg[a];

		      if (myesi != 0)
			{
			  /*c9f5 */
			  if (((op2 + op1) & 0xffff) > 0x1ff)
			    {
			      if (*mvgag != 0)
				{
				  lf0ec = 1;
				  *mvgag--;
				}
			      else
				ivalues[a] = 1;
			    }
			  else
			    op2 += op1;
			}
		      else
			{
			  /*ca31 */
			  if (op1 > op2)
			    {
			      if (*mvgag > 0)
				{
				  lf0ec = 1;
				  *mvgag--;
				}
			      else
				ivalues[a] = 1;
			    }
			  else
			    op2 -= op1;
			}

		      /*ca54 */
		      if (op2 < 0x100)
			op2 = 0x100 - op2;

		      pedcg[a] = op2;
		      podcg[a] = op2;
		    }
		}
	      /*ca6f */
	      ptr++;
	      mvgag++;
	      show_calibtable (&mitabla);
	    }
	}
      /*429ca99 */
    }
  while (lf0ec != 0);
  /*429cad1 */

  for (a = 0; a < 3; a++)
    {
      poffseteven[a] = (pedcg[a] < 0x100) ? 0xff - pedcg[a] : pedcg[a];
      poffsetodd[a] = (podcg[a] < 0x100) ? 0xff - podcg[a] : podcg[a];
    }

  free (scanbuffer);

  return OK;
}
#endif

static void
Calib_LoadCut (struct st_scanparams *scancfg, SANE_Int scantype,
	       struct st_calibration_data *calibdata, SANE_Int file)
{
  double mylong;		/*ee78 */
  double mylong2;
  /**/ SANE_Int section, option;
  SANE_Int Params[] =
    { U1_T_8B_24D_CUT_R, U1_T_8B_24D_CUT_G, U1_T_8B_24D_CUT_B,
    U1_T_8B_12D_CUT_R, U1_T_8B_12D_CUT_G, U1_T_8B_12D_CUT_B,
    U1_T_8B_6D_CUT_R, U1_T_8B_6D_CUT_G, U1_T_8B_6D_CUT_B,
    U1_T_8B_3D_CUT_R, U1_T_8B_3D_CUT_G, U1_T_8B_3D_CUT_B,
    U1_T_8B_2D_CUT_R, U1_T_8B_2D_CUT_G, U1_T_8B_2D_CUT_B,
    U1_T_8B_1D_CUT_R, U1_T_8B_1D_CUT_G, U1_T_8B_1D_CUT_B,
    U1_T_16B_24D_CUT_R, U1_T_16B_24D_CUT_G, U1_T_16B_24D_CUT_B,
    U1_T_16B_12D_CUT_R, U1_T_16B_12D_CUT_G, U1_T_16B_12D_CUT_B,
    U1_T_16B_6D_CUT_R, U1_T_16B_6D_CUT_G, U1_T_16B_6D_CUT_B,
    U1_T_16B_3D_CUT_R, U1_T_16B_3D_CUT_G, U1_T_16B_3D_CUT_B,
    U1_T_16B_2D_CUT_R, U1_T_16B_2D_CUT_G, U1_T_16B_2D_CUT_B,
    U1_T_16B_1D_CUT_R, U1_T_16B_1D_CUT_G, U1_T_16B_1D_CUT_B,
    U1_S_8B_24D_CUT_R, U1_S_8B_24D_CUT_G, U1_S_8B_24D_CUT_B,
    U1_S_8B_12D_CUT_R, U1_S_8B_12D_CUT_G, U1_S_8B_12D_CUT_B,
    U1_S_8B_6D_CUT_R, U1_S_8B_6D_CUT_G, U1_S_8B_6D_CUT_B,
    U1_S_8B_3D_CUT_R, U1_S_8B_3D_CUT_G, U1_S_8B_3D_CUT_B,
    U1_S_8B_2D_CUT_R, U1_S_8B_2D_CUT_G, U1_S_8B_2D_CUT_B,
    U1_S_8B_1D_CUT_R, U1_S_8B_1D_CUT_G, U1_S_8B_1D_CUT_B,
    U1_S_16B_24D_CUT_R, U1_S_16B_24D_CUT_G, U1_S_16B_24D_CUT_B,
    U1_S_16B_12D_CUT_R, U1_S_16B_12D_CUT_G, U1_S_16B_12D_CUT_B,
    U1_S_16B_6D_CUT_R, U1_S_16B_6D_CUT_G, U1_S_16B_6D_CUT_B,
    U1_S_16B_3D_CUT_R, U1_S_16B_3D_CUT_G, U1_S_16B_3D_CUT_B,
    U1_S_16B_2D_CUT_R, U1_S_16B_2D_CUT_G, U1_S_16B_2D_CUT_B,
    U1_S_16B_1D_CUT_R, U1_S_16B_1D_CUT_G, U1_S_16B_1D_CUT_B,
    U2_T_8B_24D_CUT_R, U2_T_8B_24D_CUT_G, U2_T_8B_24D_CUT_B,
    U2_T_8B_12D_CUT_R, U2_T_8B_12D_CUT_G, U2_T_8B_12D_CUT_B,
    U2_T_8B_6D_CUT_R, U2_T_8B_6D_CUT_G, U2_T_8B_6D_CUT_B,
    U2_T_8B_3D_CUT_R, U2_T_8B_3D_CUT_G, U2_T_8B_3D_CUT_B,
    U2_T_8B_2D_CUT_R, U2_T_8B_2D_CUT_G, U2_T_8B_2D_CUT_B,
    U2_T_8B_1D_CUT_R, U2_T_8B_1D_CUT_G, U2_T_8B_1D_CUT_B,
    U2_T_16B_24D_CUT_R, U2_T_16B_24D_CUT_G, U2_T_16B_24D_CUT_B,
    U2_T_16B_12D_CUT_R, U2_T_16B_12D_CUT_G, U2_T_16B_12D_CUT_B,
    U2_T_16B_6D_CUT_R, U2_T_16B_6D_CUT_G, U2_T_16B_6D_CUT_B,
    U2_T_16B_3D_CUT_R, U2_T_16B_3D_CUT_G, U2_T_16B_3D_CUT_B,
    U2_T_16B_2D_CUT_R, U2_T_16B_2D_CUT_G, U2_T_16B_2D_CUT_B,
    U2_T_16B_1D_CUT_R, U2_T_16B_1D_CUT_G, U2_T_16B_1D_CUT_B,
    U2_S_8B_24D_CUT_R, U2_S_8B_24D_CUT_G, U2_S_8B_24D_CUT_B,
    U2_S_8B_12D_CUT_R, U2_S_8B_12D_CUT_G, U2_S_8B_12D_CUT_B,
    U2_S_8B_6D_CUT_R, U2_S_8B_6D_CUT_G, U2_S_8B_6D_CUT_B,
    U2_S_8B_3D_CUT_R, U2_S_8B_3D_CUT_G, U2_S_8B_3D_CUT_B,
    U2_S_8B_2D_CUT_R, U2_S_8B_2D_CUT_G, U2_S_8B_2D_CUT_B,
    U2_S_8B_1D_CUT_R, U2_S_8B_1D_CUT_G, U2_S_8B_1D_CUT_B,
    U2_S_16B_24D_CUT_R, U2_S_16B_24D_CUT_G, U2_S_16B_24D_CUT_B,
    U2_S_16B_12D_CUT_R, U2_S_16B_12D_CUT_G, U2_S_16B_12D_CUT_B,
    U2_S_16B_6D_CUT_R, U2_S_16B_6D_CUT_G, U2_S_16B_6D_CUT_B,
    U2_S_16B_3D_CUT_R, U2_S_16B_3D_CUT_G, U2_S_16B_3D_CUT_B,
    U2_S_16B_2D_CUT_R, U2_S_16B_2D_CUT_G, U2_S_16B_2D_CUT_B,
    U2_S_16B_1D_CUT_R, U2_S_16B_1D_CUT_G, U2_S_16B_1D_CUT_B
  };

  switch (scantype)
    {
    case ST_NEG:
      section = CALIBNEGATIVEFILM;
      break;
    case ST_TA:
      section = CALIBTRANSPARENT;
      break;
    default:
      section = CALIBREFLECTIVE;
      break;
    }

  option = 0;
  if (usbtype != USB11)
    option += 71;

  if (ccdtype == SONY)
    option += 36;

  if (scancfg->depth != 8)
    option += 18;

  if (scancfg->resolution_x < 2400)
    {
      option += 3;
      if (scancfg->resolution_x < 1200)
	{
	  option += 3;
	  if (scancfg->resolution_x < 600)
	    {
	      option += 3;
	      if (scancfg->resolution_x < 300)
		{
		  option += 3;
		  if (scancfg->resolution_x < 200)
		    option += 3;
		}
	    }
	}
    }

  mylong = 1 << scancfg->depth;
  mylong2 = get_value (section, Params[option], 0, file);
  calibdata->ShadingCut[CL_RED] = (mylong * mylong2) * 0.000390625;

  mylong2 =
    get_value (section, Params[option + 1], calibdata->BShadingDefCutOff,
	       file);
  calibdata->ShadingCut[CL_GREEN] = (mylong * mylong2) * 0.000390625;

  mylong2 =
    get_value (section, Params[option + 2], calibdata->BShadingDefCutOff,
	       file);
  calibdata->ShadingCut[CL_BLUE] = (mylong * mylong2) * 0.000390625;

}

static SANE_Int
Calib_WhiteShading3 (struct st_calibration_data *calibdata,
		     struct st_calibration *myCalib, SANE_Int gainmode)
{
/*
05EDF8E0   04F00738  |Arg1 = 04F00738
05EDF8E4   05EDF90C  |Arg2 = 05EDF90C calibdata
05EDF8E8   05EDFAAC  |Arg3 = 05EDFAAC myCalib
05EDF8EC   00000001  \Arg4 = 00000001 gainmode
*/
  SANE_Byte *myRegs;		/*f1bc */
  struct st_scanparams scancfg;	/*f170 */
  SANE_Int myWidth;		/*f14c */
  SANE_Int lf168, bytes_per_pixel;
  SANE_Int bytes_per_line;
  /**/ SANE_Int a;
  double lf1a4[3];
  SANE_Int otherheight;		/*f150 */
  SANE_Int otherheight2;
  SANE_Int lf12c;
  SANE_Int lf130;
  double *buffer1;		/*f138 */
  double *buffer2;		/*f144 */
  SANE_Byte *scanbuffer;	/*f164 */
  SANE_Byte *ptr;		/*f148 */
  SANE_Int position;		/*f140 */
  SANE_Int lf13c, myHeight;
  SANE_Int myESI, myEDI;
  SANE_Int channel;		/*f134 */
  double myst;
  double sumatorio;
  SANE_Int rst;

  DBG (2, "> Calib_WhiteShading3(*calibdata, *myCalib, gainmode=%i)\n",
       gainmode);

  myRegs = (SANE_Byte *) malloc (0x71a * sizeof (SANE_Byte));
  memcpy (myRegs, &bkRegisters, 0x71a * sizeof (SANE_Byte));
  memcpy (&scancfg, &cpyscan, sizeof (struct st_scanparams));

  Lamp_SetGainMode (myRegs, scancfg.resolution_x, gainmode);

  rst = OK;
  scancfg.resolution_y = 200;
  switch (scan.scantype)
    {
    case ST_NORMAL:
      /*a184 */
      scancfg.coord.left += scan.ser;
      scancfg.coord.width &= 0xffff;
      break;
    case ST_TA:
    case ST_NEG:
      scancfg.coord.left += scan.ser;
      break;
    }

  /*a0e5 */
  /* Set resolution */
  if ((dpi100Lumping == 0) && (scancfg.resolution_x == 100))
    {
      scancfg.resolution_y = 200;
      scancfg.resolution_x = 200;
      scancfg.coord.width =
	min (scancfg.coord.width * 2, scancfg.shadinglength);
    }

  /*a11b */
  if ((scancfg.coord.width & 1) != 0)
    scancfg.coord.width++;

  scancfg.coord.top = 1;
  scancfg.coord.height = calibdata->WShadingHeight;

  switch (scancfg.colormode)
    {
    case CM_GRAY:
    case CM_LINEART:
      myWidth = scancfg.coord.width;
      lf168 = 0;
      bytes_per_line = ((scancfg.depth + 7) / 8) * myWidth;
      bytes_per_pixel = 1;
      break;
    default:			/* CM_COLOR */
      myWidth = scancfg.coord.width * 3;
      bytes_per_line = ((scancfg.depth + 7) / 8) * myWidth;
      lf168 = (scancfg.samplerate != FALSE) ? scancfg.coord.width : 1;
      bytes_per_pixel = (scancfg.samplerate == FALSE) ? 3 : 1;
      break;
    }

  /*a1e8 */
  scancfg.v157c = bytes_per_line;
  scancfg.bytesperline = bytes_per_line;

  for (a = 0; a < 3; a++)
    lf1a4[a] = (calibdata->WRef[a] * (1 << scancfg.depth)) >> 8;

  otherheight = calibdata->WShadingHeight - 3;
  otherheight -= (otherheight - 4);
  otherheight2 = otherheight / 2;
  otherheight -= otherheight2;
  lf130 = otherheight2;
  lf12c = otherheight;

  buffer1 = (double *) malloc (otherheight * sizeof (double));
  if (buffer1 == NULL)
    return ERROR;

  buffer2 = (double *) malloc (otherheight * sizeof (double));
  if (buffer2 == NULL)
    {
      free (buffer1);
      return ERROR;
    }

  scanbuffer =
    (SANE_Byte *) malloc (((scancfg.coord.height + 16) * bytes_per_line) *
			  sizeof (SANE_Byte));
  if (scanbuffer == NULL)
    {
      free (buffer1);
      free (buffer2);
      return ERROR;
    }

  /* Scan image */
  myCalib->value3 = 0;
  rst =
    RTS_GetImage (myRegs, &scancfg, &mitabla, scanbuffer, myCalib, 0x20000080,
		  gainmode);

  for (a = 0; a < 3; a++)
    myCalib->WRef[a] *= ((1 << scancfg.depth) >> 8);

  if (rst == ERROR)
    {
      free (buffer1);
      free (buffer2);
      free (scanbuffer);
      return ERROR;
    }

  if (scancfg.depth > 8)
    {
      /*a6d9 */
      position = 0;
      sumatorio = 0;
      if (myWidth > 0)
	{
	  do
	    {
	      switch (scancfg.colormode)
		{
		case CM_GRAY:
		case CM_LINEART:
		  channel = 0;
		  lf13c = position;
		  break;
		default:	/*CM_COLOR */
		  if (scancfg.samplerate == FALSE)
		    {
		      channel = position % bytes_per_pixel;
		      lf13c = position / bytes_per_pixel;
		    }
		  else
		    {
		      channel = position / lf168;
		      lf13c = position % lf168;
		    }
		  break;
		}

	      /*a743 */
	      if (lf130 > 0)
		bzero (buffer1, lf130 * sizeof (double));

	      /*a761 */
	      if (lf12c > 0)
		{
		  for (a = 0; a < lf12c; a++)
		    buffer2[a] = (1 << scancfg.depth) - 1.0;
		}

	      /*a78f */
	      myESI = 0;
	      myEDI = 0;
	      ptr = scanbuffer + (position * 2);
	      myHeight = 0;

	      if (otherheight > 0)
		{
		  do
		    {
		      myst = 0;
		      for (a = 0; a < 4; a++)
			myst += Data_Get (ptr + (a * (myWidth * 2)), 2);

		      myEDI = 0;
		      myst = myst * 0.25;
		      if (myHeight < (otherheight - 4))
			{
			  if (myst < buffer2[myESI])
			    {
			      buffer2[myESI] = myst;
			      if (lf12c > 0)
				{
				  for (a = 0; a < lf12c; a++)
				    if (buffer2[myESI] < buffer2[a])
				      myESI = a;
				}
			    }
			  /*a820 */
			  if (myst >= buffer1[myEDI])
			    {
			      buffer1[myEDI] = myst;
			      if (lf130 > 0)
				{
				  for (a = 0; a < lf130; a++)
				    if (buffer1[myEDI] >= buffer1[a])
				      myEDI = a;
				}
			    }
			  sumatorio += myst;
			}
		      else
			{
			  /*a853 */
			  if (myHeight == (otherheight - 4))
			    {
			      if (lf12c > 0)
				{
				  for (a = 0; a < lf12c; a++)
				    if (buffer2[myESI] >= buffer2[a])
				      myESI = a;
				}

			      if (lf130 > 0)
				{
				  for (a = 0; a < lf130; a++)
				    if (buffer1[myEDI] < buffer1[a])
				      myEDI = a;
				}
			    }

			  /*a895 */
			  if (myst >= buffer2[myESI])
			    {
			      /*a89c */
			      sumatorio -= buffer2[myESI];
			      sumatorio += myst;
			      buffer2[myESI] = myst;
			      if (lf12c > 0)
				{
				  for (a = 0; a < lf12c; a++)
				    if (buffer2[myESI] >= buffer2[a])
				      myESI = a;
				}
			    }
			  else
			    {
			      if (myst < buffer1[myEDI])
				{
				  sumatorio -= buffer1[myEDI];
				  sumatorio += myst;
				  buffer1[myEDI] = myst;

				  if (lf130 > 0)
				    {
				      for (a = 0; a < lf130; a++)
					if (buffer1[myEDI] < buffer1[a])
					  myEDI = a;
				    }
				}
			    }
			}
		      /*a901 */
		      ptr += (myWidth * 2);
		      myHeight++;
		    }
		  while (myHeight < otherheight);
		}
	      /*a924 */
	      scancfg.ser = 0;
	      scancfg.startpos = otherheight - 4;

	      sumatorio = sumatorio / scancfg.startpos;
	      if (myCalib->value3 != 0)
		{
		  /*a94a */
		  myCalib->white_shading[channel][lf13c] =
		    (unsigned short) sumatorio;
		}
	      else
		{
		  /*a967 */
		  if ((scancfg.colormode != CM_GRAY)
		      && (scancfg.colormode != CM_LINEART))
		    sumatorio /= lf1a4[channel];
		  else
		    sumatorio /= lf1a4[scancfg.channel];

		  sumatorio = min (sumatorio * 0x4000, 65535);

		  if (myRegs[0x1bf] != 0x18)
		    myCalib->black_shading[channel][lf13c] |=
		      (0x140 -
		       ((((myRegs[0x1bf] >> 3) & 3) *
			 3) << 6)) & ((int) sumatorio);
		  else
		    myCalib->white_shading[channel][lf13c] =
		      (unsigned short) sumatorio;
		}
	      /*a9fd */
	      position++;
	    }
	  while (position < myWidth);
	}
    }
  else
    {
      /*a6d9 */
      position = 0;
      sumatorio = 0;
      if (myWidth > 0)
	{
	  do
	    {
	      switch (scancfg.colormode)
		{
		case CM_GRAY:
		case CM_LINEART:
		  channel = 0;
		  lf13c = position;
		  break;
		default:	/*CM_COLOR */
		  if (scancfg.samplerate == FALSE)
		    {
		      channel = position % bytes_per_pixel;
		      lf13c = position / bytes_per_pixel;
		    }
		  else
		    {
		      channel = position / lf168;
		      lf13c = position % lf168;
		    }
		  break;
		}

	      /*a743 */
	      if (lf130 > 0)
		bzero (buffer1, lf130 * sizeof (double));

	      /*a761 */
	      if (lf12c > 0)
		{
		  for (a = 0; a < lf12c; a++)
		    buffer2[a] = (1 << scancfg.depth) - 1.0;
		}

	      /*a78f */
	      myESI = 0;
	      myEDI = 0;
	      ptr = scanbuffer + position;
	      myHeight = 0;

	      if (otherheight > 0)
		{
		  do
		    {
		      myst = 0;
		      for (a = 0; a < 4; a++)
			myst += *(ptr + (a * myWidth));

		      myEDI = 0;
		      myst *= 0.25;
		      if (myHeight < (otherheight - 4))
			{
			  if (myst < buffer2[myESI])
			    {
			      buffer2[myESI] = myst;
			      if (lf12c > 0)
				{
				  for (a = 0; a < lf12c; a++)
				    if (buffer2[myESI] < buffer2[a])
				      myESI = a;
				}
			    }
			  /*a820 */
			  if (myst >= buffer1[myEDI])
			    {
			      buffer1[myEDI] = myst;
			      if (lf130 > 0)
				{
				  for (a = 0; a < lf130; a++)
				    if (buffer1[myEDI] >= buffer1[a])
				      myEDI = a;
				}
			    }
			  sumatorio += myst;
			}
		      else
			{
			  /*a853 */
			  if (myHeight == (otherheight - 4))
			    {
			      if (lf12c > 0)
				{
				  for (a = 0; a < lf12c; a++)
				    if (buffer2[myESI] >= buffer2[a])
				      myESI = a;
				}

			      if (lf130 > 0)
				{
				  for (a = 0; a < lf130; a++)
				    if (buffer1[myEDI] < buffer1[a])
				      myEDI = a;
				}
			    }

			  /*a895 */
			  if (myst >= buffer2[myESI])
			    {
			      /*a89c */
			      sumatorio -= buffer2[myESI];
			      sumatorio += myst;
			      buffer2[myESI] = myst;
			      if (lf12c > 0)
				{
				  for (a = 0; a < lf12c; a++)
				    if (buffer2[myESI] >= buffer2[a])
				      myESI = a;
				}
			    }
			  else
			    {
			      if (myst < buffer1[myEDI])
				{
				  sumatorio -= buffer1[myEDI];
				  sumatorio += myst;
				  buffer1[myEDI] = myst;

				  if (lf130 > 0)
				    {
				      for (a = 0; a < lf130; a++)
					if (buffer1[myEDI] < buffer1[a])
					  myEDI = a;
				    }
				}
			    }
			}
		      /*a901 */
		      ptr += myWidth;
		      myHeight++;
		    }
		  while (myHeight < otherheight);
		}
	      /*a924 */
	      scancfg.ser = 0;
	      scancfg.startpos = otherheight - 4;

	      sumatorio /= scancfg.startpos;
	      if (myCalib->value3 != 0)
		{
		  /*a94a */
		  myCalib->white_shading[channel][lf13c] =
		    (unsigned short) sumatorio;
		}
	      else
		{
		  /*a967 */
		  if ((scancfg.colormode != CM_GRAY)
		      && (scancfg.colormode != CM_LINEART))
		    sumatorio /= lf1a4[channel];
		  else
		    sumatorio /= lf1a4[scancfg.channel];

		  sumatorio = min (sumatorio * 0x4000, 65535);

		  if (myRegs[0x1bf] != 0x18)
		    myCalib->black_shading[channel][lf13c] |=
		      (0x140 -
		       ((((myRegs[0x1bf] >> 3) & 0x03) *
			 3) << 6)) & ((int) sumatorio);
		  else
		    myCalib->white_shading[channel][lf13c] =
		      (unsigned short) sumatorio;
		}
	      /*a9fd */
	      position++;
	    }
	  while (position < myWidth);
	}
    }

  /*aa12 */
  if (RTS_Debug.SaveCalibFile != FALSE)
    {
      TIFF_Save ("whiteshading3.tiff",
		 scancfg.coord.width,
		 scancfg.coord.height,
		 scancfg.depth,
		 scanbuffer, (scancfg.coord.height + 16) * bytes_per_line);
    }

  free (buffer1);
  free (buffer2);
  free (scanbuffer);

  return OK;
}

static SANE_Int
Calib_BlackShading (struct st_calibration_data *calibdata,
		    struct st_calibration *myCalib, SANE_Int gainmode)
{
  /*
     gainmode  f8ec
     myCalib   f8e8
     calibdata f8e4
   */
  SANE_Byte *myRegs;		/*f1bc */
  struct st_scanparams scancfg;	/*f020 */
  long ltime;
  double shadingprediff[6];	/*f08c f094 f09c f0a4 f0ac f0b4 */
  double mylong;		/*f018 */
  double maxvalue;		/*eff8 */
  double sumatorio = 0.0;
  double myst;
  SANE_Int rst;
  SANE_Int a;
  SANE_Int mheight;		/*efe0 */
  SANE_Int current_line;	/*efe4 */
  SANE_Int bytes_per_line;	/*efd8 */
  SANE_Int position;		/*lefcc */
  SANE_Int leff0, lf010, lefd0;
  SANE_Byte *buffer;		/*efd4 */
  SANE_Byte buff2[256];		/*F0BC */
  SANE_Int buff3[0x8000];
  SANE_Byte *ptr;		/*f008 */
  SANE_Int my14b4;		/*f008 pisa ptr */
  SANE_Int biggest;		/*bx */
  SANE_Int lowest;		/*dx */
  SANE_Int lefdc;
  SANE_Int channel;
  SANE_Int smvalues[3];		/*f04c f04e f050 */
  double dbvalue[6];		/*lf05c lf060, lf064 lf068, lf06c lf070,
				   lf074 lf078, lf07c lf080, lf084 lf088 */

  DBG (2, "> Calib_BlackShading(*calibdata, *myCalib, gainmode=%i)\n",
       gainmode);

  rst = OK;
  ltime = GetTickCount ();
  myRegs = (SANE_Byte *) malloc (0x71a * sizeof (SANE_Byte));
  memcpy (myRegs, &bkRegisters, 0x71a * sizeof (SANE_Byte));
  memcpy (&scancfg, &cpyscan, sizeof (struct st_scanparams));

  Lamp_SetGainMode (myRegs, scancfg.resolution_x, gainmode);

  for (a = CL_RED; a <= CL_BLUE; a++)
    shadingprediff[a + 3] = calibdata->BShadingPreDiff[a];

  if ((scan.scantype >= ST_NORMAL) && (scan.scantype <= ST_NEG))
    scancfg.coord.left += scan.ser;

  if ((dpi100Lumping == 0) && (scancfg.resolution_x == 100))
    {
      scancfg.resolution_x = 200;
      scancfg.resolution_y = 200;
      scancfg.coord.width =
	min (scancfg.coord.width * 2, scancfg.shadinglength);
    }

  if ((scancfg.coord.width & 1) != 0)
    scancfg.coord.width++;

  scancfg.coord.top = 1;
  scancfg.depth = 8;
  scancfg.coord.height = calibdata->BShadingHeight;

  if (scancfg.colormode != CM_COLOR)
    {
      bytes_per_line = scancfg.coord.width;
      leff0 = 0;
      lf010 = 1;
    }
  else
    {
      /*876c */
      bytes_per_line = scancfg.coord.width * 3;
      if (scancfg.samplerate != 0)
	{
	  leff0 = scancfg.coord.width;
	  lf010 = 1;
	}
      else
	{
	  leff0 = 1;
	  lf010 = 3;
	}
    }

  scancfg.v157c = bytes_per_line;
  scancfg.bytesperline = bytes_per_line;

  mylong = 1 << (16 - scancfg.depth);
  if ((myRegs[0x1bf] & 0x18) != 0)
    mylong /= 1 << (((myRegs[0x1bf] >> 5) & 3) + 4);

  lefd0 =
    ((((myRegs[0x1bf] >> 3) & 2) << 8) -
     ((((myRegs[0x1bf] >> 3) & 1) * 3) << 6)) - 1;

  if (scancfg.depth >= 8)
    maxvalue = ((1 << (scancfg.depth - 8)) << 8) - 1;
  else
    maxvalue = (256 / (1 << (8 - scancfg.depth))) - 1;

  Calib_LoadCut (&scancfg, scan.scantype, calibdata, FITCALIBRATE);
  for (a = CL_RED; a <= CL_BLUE; a++)
    shadingprediff[a] = calibdata->ShadingCut[a];

  if (calibdata->BShadingOn == -1)
    {
      SANE_Int b, d;
      double e;

      for (a = 0; a < 3; a++)
	{
	  myst = max (shadingprediff[a], 0);
	  myst = (maxvalue >= myst) ? shadingprediff[a] : maxvalue;
	  shadingprediff[a] = max (myst, 0);
	}

      b = 0;

      while (b < bytes_per_line)
	{
	  if (scancfg.colormode != CM_COLOR)
	    {
	      channel = 0;
	      d = b;
	    }
	  else
	    {
	      if (scancfg.samplerate == FALSE)
		{
		  channel = (b % lf010) & 0xffff;
		  d = (b / lf010) & 0xffff;
		}
	      else
		{
		  channel = (b / leff0) & 0xffff;
		  d = (b % leff0) & 0xffff;
		}
	    }
	  /*89d0 */
	  e = min (lefd0, mylong * shadingprediff[channel]);
	  myCalib->black_shading[channel][d] |= (unsigned short) e & 0xffff;
	  b++;
	}

      return OK;
    }

  /* Allocate buffer to read image */
  mheight = scancfg.coord.height;
  buffer =
    (SANE_Byte *) malloc (((scancfg.coord.height + 16) * bytes_per_line) *
			  sizeof (SANE_Byte));
  if (buffer == NULL)
    return ERROR;

  /* Turn off lamp */
  Lamp_SetStatus2 (FALSE, FLB_LAMP - 1);
  usleep (200 * 1000);

  /* Scan image */
  myCalib->value3 = 0;
  rst =
    RTS_GetImage (myRegs, &scancfg, &mitabla, buffer, myCalib, 0x101,
		  gainmode);
  if (rst == ERROR)
    {
      /*8ac2 */
      free (buffer);
      memcpy (&bkRegisters, myRegs, 0x71a * sizeof (SANE_Byte));
      free (myRegs);
      return ERROR;
    }

  /* myRegs isn't going to be used anymore */
  free (myRegs);
  myRegs = NULL;

  /* Turn on lamp again */
  if (scan.scantype != ST_NORMAL)
    {
      Lamp_SetStatus2 (FALSE, TMA_LAMP - 1);
      usleep (1000 * 1000);
    }
  else
    Lamp_SetStatus2 (TRUE, FLB_LAMP - 1);

  /* Save buffer */
  if (RTS_Debug.SaveCalibFile != FALSE)
    {
      TIFF_Save ("blackshading.tiff",
		 scancfg.coord.width,
		 scancfg.coord.height,
		 scancfg.depth,
		 buffer, (scancfg.coord.height + 16) * bytes_per_line);
    }

  if (scancfg.depth > 8)
    {
      /*8bb2 */
      bzero (&dbvalue, 6 * sizeof (double));
      position = 0;

      if (bytes_per_line > 0)
	{
	  do
	    {
	      bzero (&buff3, 0x8000 * sizeof (SANE_Int));
	      sumatorio = 0;
	      ptr = buffer + position;
	      current_line = 0;
	      biggest = 0;
	      lowest = (int) maxvalue;
	      /* Toma los valores de una columna */
	      if (mheight > 0)
		{
		  SANE_Int value;
		  do
		    {
		      value = Data_Get (ptr, 2);
		      biggest = max (biggest, value);
		      if (current_line < mheight)
			{
			  sumatorio += value;
			  lowest = min (lowest, value);
			  biggest = max (biggest, value);

			  buff3[value]++;
			}
		      else
			{
			  /*8cab */
			  if (value > lowest)
			    {
			      buff3[lowest]--;
			      buff3[value]++;
			      sumatorio += value;
			      sumatorio -= lowest;

			      if (buff3[lowest] != 0)
				{
				  do
				    {
				      lowest++;
				    }
				  while (buff3[lowest] == 0);
				}
			    }
			}
		      /*8d0b */
		      ptr += (bytes_per_line * 2);
		      current_line++;
		    }
		  while (current_line < mheight);
		}
	      /*8d27 */
	      sumatorio /= mheight;

	      if (scancfg.colormode != CM_COLOR)
		{
		  channel = 0;
		  lefdc = position;
		}
	      else
		{
		  /*8d5f */
		  if (scancfg.samplerate == FALSE)
		    {
		      channel = position % lf010;
		      lefdc = (position / lf010) & 0xffff;
		    }
		  else
		    {
		      channel = position / leff0;
		      lefdc = position % leff0;
		    }
		}

	      dbvalue[channel] += sumatorio;
	      if ((scancfg.colormode == CM_GRAY)
		  || (scancfg.colormode == CM_LINEART))
		sumatorio += shadingprediff[scancfg.channel];
	      else
		sumatorio += shadingprediff[channel];

	      myst = min (max (0, sumatorio), maxvalue);

	      dbvalue[channel + 3] = myst;

	      if ((calibdata->BShadingOn == 1)
		  || (calibdata->BShadingOn == 2))
		{
		  if (calibdata->BShadingOn == 2)
		    {
		      myst -=
			calibdata->BRef[channel] * (1 << (scancfg.depth - 8));
		      myst = max (myst, 0);
		    }
		  /*8e6d */
		  myst *= mylong;
		  myCalib->black_shading[channel][lefdc] = min (myst, lefd0);
		}

	      position++;
	    }
	  while (position < bytes_per_line);
	}
    }
  else
    {
      /*8eb6 */
      bzero (&dbvalue, 6 * sizeof (double));
      position = 0;

      if (bytes_per_line > 0)
	{
	  do
	    {
	      bzero (&buff2, 256 * sizeof (SANE_Byte));
	      sumatorio = 0;
	      /* ptr points to the next position of the first line */
	      ptr = buffer + position;
	      biggest = 0;
	      lowest = (int) maxvalue;
	      current_line = 0;
	      /* Toma los valores de una columna */
	      if (mheight > 0)
		{
		  my14b4 = v14b4;
		  do
		    {
		      biggest = max (biggest, *ptr);

		      if (my14b4 == 0)
			{
			  /*8fd7 */
			  if (current_line < mheight)
			    {
			      sumatorio += *ptr;

			      lowest = min (lowest, *ptr);
			      biggest = max (biggest, *ptr);

			      buff2[*ptr]++;
			    }
			  else
			    {
			      /*9011 */
			      if (*ptr > lowest)
				{
				  buff2[lowest]--;
				  buff2[*ptr]++;
				  sumatorio += *ptr;
				  sumatorio -= lowest;

				  if (buff2[lowest] != 0)
				    {
				      do
					{
					  lowest++;
					}
				      while (buff2[lowest] == 0);
				    }
				}
			    }
			}
		      else
			sumatorio += *ptr;
		      /*9067 */
		      /* Point to the next pixel under current line */
		      ptr += bytes_per_line;
		      current_line++;
		    }
		  while (current_line < mheight);
		}

	      /*908a */
	      /* Calculates average of each column */
	      sumatorio = sumatorio / mheight;

	      if (scancfg.colormode != CM_COLOR)
		{
		  channel = 0;
		  lefdc = position;
		}
	      else
		{
		  /*90c5 */
		  if (scancfg.samplerate == FALSE)
		    {
		      channel = position % lf010;
		      lefdc = (position / lf010) & 0xffff;
		    }
		  else
		    {
		      /*90fb */
		      channel = position / leff0;
		      lefdc = position % leff0;
		    }
		}

	      /*911f */
	      dbvalue[channel] += sumatorio;
	      if ((scancfg.colormode == CM_GRAY)
		  || (scancfg.colormode == CM_LINEART))
		sumatorio += shadingprediff[scancfg.channel];
	      else
		sumatorio += shadingprediff[channel];

	      /*9151 */
	      myst = min (max (0, sumatorio), maxvalue);

	      /*9198 */
	      if (position >= 3)
		{
		  double myst2;

		  myst -= dbvalue[channel + 3];
		  myst2 = myst;
		  myst = min (myst, shadingprediff[channel + 3]);

		  my14b4 = -shadingprediff[channel + 3];
		  if (myst >= my14b4)
		    myst = min (myst2, shadingprediff[channel + 3]);
		  else
		    myst = my14b4;

		  myst += dbvalue[channel + 3];
		}

	      /*9203 */
	      dbvalue[channel + 3] = myst;

	      switch (calibdata->BShadingOn)
		{
		case 1:
		  myCalib->black_shading[channel][lefdc] |=
		    (unsigned short) (((int) myst & 0xff) << 8) & 0xffff;
		  break;
		case 2:
		  /*9268 */
		  my14b4 =
		    calibdata->BRef[channel] / (1 << (8 - scancfg.depth));
		  myst -= my14b4;
		  myst = max (myst, 0);
		  myst *= mylong;
		  myCalib->black_shading[channel][lefdc] = min (myst, lefd0);
		  break;
		}

	      /*92d8 */
	      position++;
	    }
	  while (position < bytes_per_line);
	}
    }

  /*9306 */
  if (calibdata->BShadingOn == -2)
    {
      for (a = 0; a < 3; a++)
	{
	  dbvalue[a] =
	    (dbvalue[a] / scancfg.coord.width) + calibdata->ShadingCut[a];
	  if (dbvalue[a] < 0)
	    dbvalue[a] = 0;
	  smvalues[a] = min ((int) (dbvalue[a] + 0.5) & 0xffff, maxvalue);
	}

      if (scancfg.coord.width > 0)
	{
	  SANE_Int b, c;

	  for (c = 0; c < scancfg.coord.width; c++)
	    for (b = 0; b < 3; b++)
	      myCalib->black_shading[b][c] |=
		(unsigned short) min (smvalues[b] * mylong, lefd0);
	}
    }
  /*9425 */
  free (buffer);

  return OK;
}

static SANE_Int
Calibration (SANE_Byte * TheBuffer, struct st_scanparams *myscan,
	     struct st_calibration *myCalib, SANE_Int value)
{
  /*//SANE_Int Calibration([fa20]char *TheBuffer, [fa24]struct st_scanparams *myscan, [fa28]struct st_calibration myCalib, [fa2c]SANE_Int value)
   */

  struct st_calibration_data calibdata;	/* f90c */
  SANE_Int a;
  SANE_Byte gainmode;
  SANE_Int lf900;
  SANE_Int myleftleading;	/* [3ec0] */
  SANE_Int myler;		/* [3ec4] */

  DBG (2, "> Calibration\n");
  show_ScanParams (myscan);

  value = value;		/*silence gcc */

  memcpy (&bkRegisters, TheBuffer, sizeof (SANE_Byte) * 0x71a);

  /*4213be8 */
  memset (&calibdata, 0x30, sizeof (struct st_calibration_data));
  Calib_LoadParams (&calibdata, scan.scantype, myscan->resolution_x,
		    myscan->depth);

  myCalib->WRef[CL_RED] = calibdata.WRef[CL_RED];
  myCalib->WRef[CL_GREEN] = calibdata.WRef[CL_GREEN];
  myCalib->WRef[CL_BLUE] = calibdata.WRef[CL_BLUE];

  bzero (&mitabla, sizeof (struct st_calib_table));	/*[42b3654] */
  for (a = CL_RED; a <= CL_BLUE; a++)
    {
      mitabla.edcg1[a] = 256;
      mitabla.odcg1[a] = 256;
      mitabla.vgag1[a] = 4;
      mitabla.vgag2[a] = 4;

      /*3654|3656|3658
         365a|365c|365e
         3660|3662|3664
         3666|3668|366a
         366c|366d|366e
         366f|3670|3671
         3672|3673|3674 */
    }

  memcpy (&cpyscan, myscan, sizeof (struct st_scanparams));
  gainmode = Lamp_GetGainMode (myscan->resolution_x, scan.scantype);	/* [lf904] = 1 */

  if ((dpi100Lumping == 0) && (myscan->resolution_x == 100))
    {
      /* duplicate resolution, so duplicate coords */
      cpyscan.resolution_x = 200;
      cpyscan.resolution_y = 200;
      cpyscan.coord.width *= 2;
      cpyscan.coord.height *= 2;
      cpyscan.coord.top *= 2;
      cpyscan.coord.left *= 2;
      cpyscan.v157c *= 2;
      cpyscan.bytesperline *= 2;
    }

  /* 3cf3 */
  myCalib->value = 1;
  myCalib->value2 = 0;
  if (cpyscan.colormode == CM_LINEART)
    {
      cpyscan.colormode = CM_GRAY;
      calibdata.GainTargetFactor = 1.3;	/*hex = 0x00000000 0x3ff00000 */
    }

  lf900 = 0x01;
  /*OK*/ myleftleading = scan.leftleading;
  myler = scan.ler;

  if (calibdata.CalibPAGOn != 0)
    {
      if (Calib_PAGain (&calibdata, gainmode) != 0)
	lf900 = 0x66;
    /*ERROR*/}
  else
    {
      /*3da7 */
      if ((cpyscan.colormode != CM_GRAY) && (cpyscan.colormode != CM_LINEART))
	{
	  mitabla.pag[CL_RED] = calibdata.PAG[CL_RED];
	  mitabla.pag[CL_GREEN] = calibdata.PAG[CL_GREEN];
	  mitabla.pag[CL_BLUE] = calibdata.PAG[CL_BLUE];
	}
      else
	{
	  /* 3dd3 */
	  /* Default PAGain */
	  if (cpyscan.channel > 2)
	    cpyscan.channel = 0;
	  mitabla.pag[CL_RED] = calibdata.PAG[cpyscan.channel];
	  mitabla.pag[CL_GREEN] = calibdata.PAG[cpyscan.channel];
	  mitabla.pag[CL_BLUE] = calibdata.PAG[cpyscan.channel];
	}
    }

  /* 3e01 */
  if (calibdata.CalibOffset10n != 0)	   /*==2*/
    {
      /*v14b4=1  offset_red=0x174  offset_green=0x16d  offset_blue=0x160 */
      if ((v14b4 != 0) && (offset_red != 0) && (offset_green != 0)
	  && (offset_blue != 0))
	{
	  mitabla.edcg1[CL_RED] = offset_red;
	  mitabla.edcg1[CL_GREEN] = offset_green;
	  mitabla.edcg1[CL_BLUE] = offset_blue;
	  mitabla.odcg1[CL_RED] = offset_red;
	  mitabla.odcg1[CL_GREEN] = offset_green;
	  mitabla.odcg1[CL_BLUE] = offset_blue;
	}
      else
	{
	  /* 3e84 */
	  if ((calibdata.CalibOffset10n > 0)
	      && (calibdata.CalibOffset10n < 4))
	    {
	      /*if (calibdata.CalibOffset10n != 0) */
	      if (calibdata.CalibOffset10n == 3)
		{
		  /*lf900 = Calib_AdcOffsetRT(&calibdata, 1); */
		}
	      else
		{
		  /* 3eb2 */
		  /*falta codigo */
		}
	    }
	}
    }
  else
    {
      /* 3faf */
      /*falta codigo */
    }

  /* 3f13 3f0b */
  if ((gainmode != 0) && (calibdata.CalibGain10n != 0))
    {
      /*gain_red=0x17 gain_green=0x12 gain_blue=0x17 */
      if ((v14b4 != 0) && (gain_red != 0) && (gain_green != 0)
	  && (gain_blue != 0))
	{
	  mitabla.vgag1[CL_RED] = gain_red;
	  mitabla.vgag1[CL_GREEN] = gain_green;
	  mitabla.vgag1[CL_BLUE] = gain_blue;
	}
      else
	{
	  /*4025 */
	  /*falta codigo */
	}
    }
  else
    {
      /*4089 */
      mitabla.vgag1[CL_RED] = calibdata.Gain1[CL_RED];
      mitabla.vgag1[CL_GREEN] = calibdata.Gain1[CL_GREEN];
      mitabla.vgag1[CL_BLUE] = calibdata.Gain1[CL_BLUE];
    }

  /*40a5 */
  if ((gainmode != 0) && (calibdata.CalibOffset20n != 0))
    {
      /*falta codigo */
    }
  else
    {
      /*4162 */
      for (a = CL_RED; a <= CL_BLUE; a++)
	{
	  if (calibdata.OffsetEven2[a] > 0x40)
	    mitabla.edcg2[a] = calibdata.OffsetEven2[a] - 0x40;
	  else
	    mitabla.edcg2[a] = 0x40 - calibdata.OffsetEven2[a];

	  if (calibdata.OffsetOdd2[a] > 0x40)
	    mitabla.odcg2[a] = calibdata.OffsetOdd2[a] - 0x40;
	  else
	    mitabla.odcg2[a] = 0x40 - calibdata.OffsetOdd2[a];
	}
    }

  /*41d6 */
  if ((gainmode != 0) && (calibdata.CalibGain20n != 0))
    {
      /*falta codigo */
    }
  else
    {
      /*423c */
      mitabla.vgag2[CL_RED] = calibdata.Gain2[CL_RED];
      mitabla.vgag2[CL_GREEN] = calibdata.Gain2[CL_GREEN];
      mitabla.vgag2[CL_BLUE] = calibdata.Gain2[CL_BLUE];
    }

  /*4258 */
  if (calibdata.TotShading != 0)
    {
      /*falta codigo */
    }
  else
    {
      /*428f */
      if (gainmode != 0)
	{
	  if (calibdata.BShadingOn != 0)
	    lf900 = Calib_BlackShading (&calibdata, myCalib, gainmode);

	  /*42fd */
	  if ((lf900 != ERROR) && (calibdata.WShadingOn != 0))
	    {
	      switch (calibdata.WShadingOn)
		{
		default:
		  break;
		case 3:
		  lf900 = Calib_WhiteShading3 (&calibdata, myCalib, gainmode);
		  break;
		case 2:
		  break;
		}
	    }
	  else
	    myCalib->value3 = 0;
	}
      else
	myCalib->value3 = 0;
    }

  /*43ca */
  memcpy (&myCalib->mitabla, &mitabla, sizeof (struct st_calib_table));
  memcpy (&mitabla2, &mitabla, sizeof (struct st_calib_table));

  /* Park home after calibration */
  if (get_value (SCANINFO, PARKHOMEAFTERCALIB, TRUE, FITCALIBRATE) == FALSE)
    {
      /*4424 */
      SANE_Int mh = calibdata.WShadingHeight & 0xffff;
      if ((dpi100Lumping == 0) && (myscan->resolution_x == 100))
	mh *= 2;

      scan.ler -= mh;
    }
  else
    Motor_ParkHome (TRUE, parkhomemotormove);

  return OK;
}

static void
show_ScanParams (struct st_scanparams *params)
{
  if (params != NULL)
    {
      DBG (2, " -> Scan params:\n");
      DBG (2, " -> colormode        = %i ", params->colormode);
      switch (params->colormode)
	{
	case CM_GRAY:
	  DBG (2, "CM_GRAY\n");
	  break;
	case CM_LINEART:
	  DBG (2, "CM_LINEART\n");
	  break;
	case CM_COLOR:
	  DBG (2, "CM_COLOR\n");
	  break;
	default:
	  DBG (2, "\n");
	}
      DBG (2, " -> depth            = %i\n", params->depth);
      DBG (2, " -> samplerate       = %i\n", params->samplerate);
      DBG (2, " -> timing           = %i\n", params->timing);
      DBG (2, " -> channel            = %i\n", params->channel);
      DBG (2, " -> sensorresolution = %i\n", params->sensorresolution);
      DBG (2, " -> resolution_x     = %i\n", params->resolution_x);
      DBG (2, " -> resolution_y     = %i\n", params->resolution_y);
      DBG (2, " -> left             = %i\n", params->coord.left);
      DBG (2, " -> width            = %i\n", params->coord.width);
      DBG (2, " -> top              = %i\n", params->coord.top);
      DBG (2, " -> height           = %i\n", params->coord.height);
      DBG (2, " -> shadinglength    = %i\n", params->shadinglength);
      DBG (2, " -> v157c            = %i\n", params->v157c);
      DBG (2, " -> bytesperline     = %i\n", params->bytesperline);
      DBG (2, " -> expt             = %i\n", params->expt);
      DBG (2, " *> startpos         = %i\n", params->startpos);
      DBG (2, " *> leftleading      = %i\n", params->leftleading);
      DBG (2, " *> ser              = %i\n", params->ser);
      DBG (2, " *> ler              = %i\n", params->ler);
      DBG (2, " *> scantype         = %i\n", params->scantype);
    }
}

static void
show_ScanLowLevelConfig (struct st_hwdconfig *params)
{
  if (params != NULL)
    {
      DBG (2, " -> Low level config:\n");
      DBG (2, " -> startpos              = %i\n", params->startpos);
      DBG (2, " -> arrangeline           = ");
      switch (params->arrangeline)
	{
	case FIX_BY_SOFT:
	  DBG (2, "FIX_BY_SOFT\n");
	  break;
	case FIX_BY_HARD:
	  DBG (2, "FIX_BY_HARD\n");
	  break;
	default:
	  DBG (2, "FIX_BY_NONE\n");
	}
      DBG (2, " -> scantype              = %i\n", params->scantype);
      DBG (2, " -> compression           = %i\n", params->compression);
      DBG (2, " -> use_gamma_tables      = %i\n", params->use_gamma_tables);
      DBG (2, " -> gamma_tablesize       = %i\n", params->gamma_tablesize);
      DBG (2, " -> unk1                  = %i\n", params->unk1);
      DBG (2, " -> unk2                  = %i\n", params->unk2);
      DBG (2, " -> unk3                  = %i\n", params->unk3);
      DBG (2, " -> motorplus             = %i\n", params->motorplus);
      DBG (2, " -> static_head           = %i\n", params->static_head);
      DBG (2, " -> depth                 = %i\n", params->depth);
      DBG (2, " -> dummy_scan            = %i\n", params->dummy_scan);
      DBG (2, " -> highresolution        = %i\n", params->highresolution);
      DBG (2, " -> sensorevenodddistance = %i\n",
	   params->sensorevenodddistance);
      DBG (2, " -> calibrate             = %i\n", params->calibrate);
    }
}

static void
show_MotorMove (struct stmotormove *params)
{
  if (params != NULL)
    {
      DBG (2, " -> MotorMove:\n");
      DBG (2, " -> systemclock       = %i\n", params->systemclock);
      DBG (2, " -> v12e435           = %i\n", params->v12e435);
      DBG (2, " -> scanmotorsteptype = %i\n", params->scanmotorsteptype);
      DBG (2, " -> motorcurve        = %i\n", params->motorcurve);
      DBG (2, " -> coord_y           = %i\n", params->coord_y);
      DBG (2, " -> ctpc              = %i\n", params->ctpc);
      DBG (2, " -> has_curves        = %i\n", params->has_curves);
      DBG (2, " -> v12e448           = %i\n", params->v12e448);
      DBG (2, " -> v12e44c           = %i\n", params->v12e44c);
    }
}

static void
show_calibtable (struct st_calib_table *params)
{
  if (params != NULL)
    {
      DBG (2, " -> Calib table:\n");
      DBG (2, " -> edcg1 = %3i , %3i , %3i\n", params->edcg1[0],
	   params->edcg1[1], params->edcg1[2]);
      DBG (2, " -> edcg2 = %3i , %3i , %3i\n", params->edcg2[0],
	   params->edcg2[1], params->edcg2[2]);
      DBG (2, " -> odcg1 = %3i , %3i , %3i\n", params->odcg1[0],
	   params->odcg1[1], params->odcg1[2]);
      DBG (2, " -> odcg2 = %3i , %3i , %3i\n", params->odcg2[0],
	   params->odcg2[1], params->odcg2[2]);
      DBG (2, " -> pag   = %3i , %3i , %3i\n", params->pag[0], params->pag[1],
	   params->pag[2]);
      DBG (2, " -> vgag1 = %3i , %3i , %3i\n", params->vgag1[0],
	   params->vgag1[1], params->vgag1[2]);
      DBG (2, " -> vgag2 = %3i , %3i , %3i\n", params->vgag2[0],
	   params->vgag2[1], params->vgag2[2]);
    }
}

/*static SANE_Int info_registers(SANE_Byte *buffer)
{
	// buffer size must be 0x71a bytes 
	SANE_Int iValue, iValue2;
	double dValue;
	
	DBG(2, "\n----------------------------------------------------\n");
	DBG(2, """RTS8822 Registers info""\nAddress  Info\n-------  ----\n");
	iValue = Data_Get(&buffer[0x000], 1);
	DBG(2, "0x0000");
	DBG(2, "   bit[0..3] = SystemClock: %02x\n", iValue & 0x0f);
	DBG(2, "         bit[4..6] = ? : %02x\n", (iValue >> 0x04) & 0x07);
	DBG(2, "         bit[7]    = RTS_IsExecuting: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = Data_Get(&buffer[0x010], 1);
	iValue2 = Data_Get(&buffer[0x013], 1);
	DBG(2, "0x0010");
	DBG(2, "   bit[0..1] = cvrs: %02x\n", iValue & 0x1f);
	DBG(2, "         bit[5..7] = ?   : %02x\n", ((iValue >> 0x05) & 0x07) | ((iValue2 & 0x80) >> 4));
	
	iValue = Data_Get(&buffer[0x012], 0x01);
	DBG(2, "0x0012");
	DBG(2, "   bit[0..5] = %02x [%02x %02x %02x] rgb channel order\n", (iValue & 0x3f), (iValue >> 0x04) & 0x02, (iValue >> 0x02) & 0x02, iValue & 0x02);
	DBG(2, "         bit[6..7] = %02x bytes per color\n", (iValue >> 0x06) & 0x02);
	
	iValue = Data_Get(&buffer[0x014], 0x01);
	DBG(2, "0x0014");
	DBG(2, "   bit[0..4] = ?   : %02x\n", iValue & 0x1f);
	DBG(2, "         bit[5..7] = vrts: %02x\n", (iValue >> 0x05) & 0x03);
	
	iValue = Data_Get(&buffer[0x015], 0x01);
	DBG(2, "0x0015");
	DBG(2, "   bit[0..4] = ?   : %02x\n", iValue & 0x1f);
	DBG(2, "         bit[5..7] = vrms: %02x\n", (iValue >> 0x05) & 0x03);
	
	iValue = Data_Get(&buffer[0x016], 0x01);
	DBG(2, "0x0016");
	DBG(2, "   bit[0..4] = ?   : %02x\n", iValue & 0x1f);
	DBG(2, "         bit[5..7] = vrbs: %02x\n", (iValue >> 0x05) & 0x03);
	
	iValue = Data_Get(&buffer[0x030], 0x02);
	dValue = ((buffer[0x032] & 0xff) * 65536) + iValue;
	DBG(2, "0x0030");
	DBG(2, "   ? : %.0f.\n", dValue);
	
	iValue = Data_Get(&buffer[0x033], 0x02);
	dValue = ((buffer[0x035] & 0xff) * 65536) + iValue;
	DBG(2, "0x0033");
	DBG(2, "   mexpts1: %.0f.\n", dValue);
	
	iValue = Data_Get(&buffer[0x036], 0x02);
	dValue = ((buffer[0x038] & 0xff) * 65536) + iValue;
	DBG(2, "0x0036");
	DBG(2, "   expts1 : %.0f.\n", dValue);
	
	iValue = Data_Get(&buffer[0x039], 0x02);
	dValue = ((buffer[0x03b] & 0xff) * 65536) + iValue;
	DBG(2, "0x0039");
	DBG(2, "   mexpts2: %.0f.\n", dValue);
	
	iValue = Data_Get(&buffer[0x03c], 0x02);
	dValue = ((buffer[0x03e] & 0xff) * 65536) + iValue;
	DBG(2, "0x003c");
	DBG(2, "   expts2 : %.0f.\n", dValue);
	
	iValue = Data_Get(&buffer[0x03f], 0x02);
	dValue = ((buffer[0x041] & 0xff) * 65536) + iValue;
	DBG(2, "0x003f");
	DBG(2, "   mexpts3: %.0f.\n", dValue);
	
	iValue = Data_Get(&buffer[0x042], 0x02);
	dValue = ((buffer[0x044] & 0xff) * 65536) + iValue;
	DBG(2, "0x0042");
	DBG(2, "   expts3 : %.0f.\n", dValue);
	
	iValue = Data_Get(&buffer[0x045], 0x01);
	DBG(2, "0x0045");
	DBG(2, "   bit[0..4] = timing.cvtrfpw: %02x\n", iValue & 0x1f);
	DBG(2, "         bit[5..7] = ?: %02x\n", (iValue >> 0x05) & 0x03);
	
	iValue = Data_Get(&buffer[0x046], 0x01);
	DBG(2, "0x0046");
	DBG(2, "   bit[0..4] = timing.cvtrbpw: %02x\n", iValue & 0x1f);
	DBG(2, "         bit[5..7] = ?: %02x\n", (iValue >> 0x05) & 0x03);
	
	iValue = Data_Get(&buffer[0x047], 0x01);
	DBG(2, "0x0047");
	DBG(2, "   timing.cvtrw: %02x\n", iValue);
	
	iValue = Data_Get(&buffer[0x04c], 0x01) & 0x0f;
	dValue = iValue * pow(2, 32);
	iValue = Data_Get(&buffer[0x04a], 0x02);
	dValue = dValue + (iValue * pow(2, 16)) + Data_Get(&buffer[0x048], 0x02);
	DBG(2, "0x0048");
	DBG(2, "   bit[0..35] = timing.cph0p1: %.0f.\n", dValue);
	iValue = Data_Get(&buffer[0x04c], 0x01);
	DBG(2, "         bit[36] = timing.cph0go: %02x\n", (iValue >> 0x04) & 0x01);
	DBG(2, "         bit[37] = timing.cph0ge: %02x\n", (iValue >> 0x05) & 0x01);
	DBG(2, "         bit[38] = timing.cph0ps: %02x\n", (iValue >> 0x06) & 0x01);
	DBG(2, "         bit[39] = ?: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = Data_Get(&buffer[0x051], 0x01) & 0x0f;
	dValue = iValue * pow(2, 32);
	iValue = Data_Get(&buffer[0x04f], 0x02);
	dValue = dValue + (iValue * pow(2, 16)) + Data_Get(&buffer[0x04d], 0x02);
	DBG(2, "0x004d");
	DBG(2, "   bit[0..35] = timing.cph0p2: %.0f.\n", dValue);
	iValue = Data_Get(&buffer[0x051], 0x01);
	DBG(2, "         bits[36..39] = %02x\n", (iValue >> 0x04) & 0x0f);
	DBG(2, "         bit[36] = ?: %02x\n", (iValue >> 0x04) & 0x01);
	DBG(2, "         bit[37] = ?: %02x\n", (iValue >> 0x05) & 0x01);
	DBG(2, "         bit[38] = ?: %02x\n", (iValue >> 0x06) & 0x01);
	DBG(2, "         bit[39] = ?: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = Data_Get(&buffer[0x056], 0x01) & 0x0f;
	dValue = iValue * pow(2, 32);
	iValue = Data_Get(&buffer[0x054], 0x02);
	dValue = dValue + (iValue * pow(2, 16)) + Data_Get(&buffer[0x052], 0x02);
	DBG(2, "0x0052");
	DBG(2, "   bit[0..35] = timing.cph1p1: %.0f.\n", dValue);
	iValue = Data_Get(&buffer[0x056], 0x01);
	DBG(2, "         bit[36] = timing.cph1go: %02x\n", (iValue >> 0x04) & 0x01);
	DBG(2, "         bit[37] = timing.cph1ge: %02x\n", (iValue >> 0x05) & 0x01);
	DBG(2, "         bit[38] = timing.cph1ps: %02x\n", (iValue >> 0x06) & 0x01);
	DBG(2, "         bit[39] = ?: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = Data_Get(&buffer[0x05b], 0x01) & 0x0f;
	dValue = iValue * pow(2, 32);
	iValue = Data_Get(&buffer[0x059], 0x02);
	dValue = dValue + (iValue * pow(2, 16)) + Data_Get(&buffer[0x057], 0x02);
	DBG(2, "0x0057");
	DBG(2, "   bit[0..35] = timing.cph1p2: %.0f.\n", dValue);
	iValue = Data_Get(&buffer[0x05b], 0x01);
	DBG(2, "         bits[36..39] = %02x\n", (iValue >> 0x04) & 0x0f);
	DBG(2, "         bit[36] = ?: %02x\n", (iValue >> 0x04) & 0x01);
	DBG(2, "         bit[37] = ?: %02x\n", (iValue >> 0x05) & 0x01);
	DBG(2, "         bit[38] = ?: %02x\n", (iValue >> 0x06) & 0x01);
	DBG(2, "         bit[39] = ?: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = Data_Get(&buffer[0x060], 0x01) & 0x0f;
	dValue = iValue * pow(2, 32);
	iValue = Data_Get(&buffer[0x05e], 0x02);
	dValue = dValue + (iValue * pow(2, 16)) + Data_Get(&buffer[0x05c], 0x02);
	DBG(2, "0x005c");
	DBG(2, "   bit[0..35] = timing.cph2p1: %.0f.\n", dValue);
	iValue = Data_Get(&buffer[0x060], 0x01);
	DBG(2, "         bit[36] = timing.cph2go: %02x\n", (iValue >> 0x04) & 0x01);
	DBG(2, "         bit[37] = timing.cph2ge: %02x\n", (iValue >> 0x05) & 0x01);
	DBG(2, "         bit[38] = timing.cph2ps: %02x\n", (iValue >> 0x06) & 0x01);
	DBG(2, "         bit[39] = ?: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = Data_Get(&buffer[0x065], 0x01) & 0x0f;
	dValue = iValue * pow(2, 32);
	iValue = Data_Get(&buffer[0x063], 0x02);
	dValue = dValue + (iValue * pow(2, 16)) + Data_Get(&buffer[0x061], 0x02);
	DBG(2, "0x0061");
	DBG(2, "   bit[0..35] = timing.cph2p2: %.0f.\n", dValue);
	iValue = Data_Get(&buffer[0x065], 0x01);
	DBG(2, "         bits[36..39] = %02x\n", (iValue >> 0x04) & 0x0f);
	DBG(2, "         bit[36] = ?: %02x\n", (iValue >> 0x04) & 0x01);
	DBG(2, "         bit[37] = ?: %02x\n", (iValue >> 0x05) & 0x01);
	DBG(2, "         bit[38] = ?: %02x\n", (iValue >> 0x06) & 0x01);
	DBG(2, "         bit[39] = ?: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = Data_Get(&buffer[0x06a], 0x01) & 0x0f;
	dValue = iValue * pow(2, 32);
	iValue = Data_Get(&buffer[0x068], 0x02);
	dValue = dValue + (iValue * pow(2, 16)) + Data_Get(&buffer[0x066], 0x02);
	DBG(2, "0x0066");
	DBG(2, "   bit[0..35] = timing.cph3p1: %.0f.\n", dValue);
	iValue = Data_Get(&buffer[0x06a], 0x01);
	DBG(2, "         bit[36] = timing.cph3go: %02x\n", (iValue >> 0x04) & 0x01);
	DBG(2, "         bit[37] = timing.cph3ge: %02x\n", (iValue >> 0x05) & 0x01);
	DBG(2, "         bit[38] = timing.cph3ps: %02x\n", (iValue >> 0x06) & 0x01);
	DBG(2, "         bit[39] = ?: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = Data_Get(&buffer[0x06f], 0x01) & 0x0f;
	dValue = iValue * pow(2, 32);
	iValue = Data_Get(&buffer[0x06d], 0x02);
	dValue = dValue + (iValue * pow(2, 16)) + Data_Get(&buffer[0x06b], 0x02);
	DBG(2, "0x006b");
	DBG(2, "   bit[0..35] = timing.cph3p2: %.0f.\n", dValue);
	iValue = Data_Get(&buffer[0x06f], 0x01);
	DBG(2, "         bits[36..39] = %02x\n", (iValue >> 0x04) & 0x0f);
	DBG(2, "         bit[36] = ?: %02x\n", (iValue >> 0x04) & 0x01);
	DBG(2, "         bit[37] = ?: %02x\n", (iValue >> 0x05) & 0x01);
	DBG(2, "         bit[38] = ?: %02x\n", (iValue >> 0x06) & 0x01);
	DBG(2, "         bit[39] = ?: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = Data_Get(&buffer[0x074], 0x01) & 0x0f;
	dValue = iValue * pow(2, 32);
	iValue = Data_Get(&buffer[0x072], 0x02);
	dValue = dValue + (iValue * pow(2, 16)) + Data_Get(&buffer[0x070], 0x02);
	DBG(2, "0x0070");
	DBG(2, "   bit[0..35] = timing.cph4p1: %.0f.\n", dValue);
	iValue = Data_Get(&buffer[0x074], 0x01);
	DBG(2, "         bit[36] = timing.cph4go: %02x\n", (iValue >> 0x04) & 0x01);
	DBG(2, "         bit[37] = timing.cph4ge: %02x\n", (iValue >> 0x05) & 0x01);
	DBG(2, "         bit[38] = timing.cph4ps: %02x\n", (iValue >> 0x06) & 0x01);
	DBG(2, "         bit[39] = ?: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = Data_Get(&buffer[0x079], 0x01) & 0x0f;
	dValue = iValue * pow(2, 32);
	iValue = Data_Get(&buffer[0x077], 0x02);
	dValue = dValue + (iValue * pow(2, 16)) + Data_Get(&buffer[0x075], 0x02);
	DBG(2, "0x0075");
	DBG(2, "   bit[0..35] = timing.cph4p2: %.0f.\n", dValue);
	iValue = Data_Get(&buffer[0x079], 0x01);
	DBG(2, "         bits[36..39] = %02x\n", (iValue >> 0x04) & 0x0f);
	DBG(2, "         bit[36] = ?: %02x\n", (iValue >> 0x04) & 0x01);
	DBG(2, "         bit[37] = ?: %02x\n", (iValue >> 0x05) & 0x01);
	DBG(2, "         bit[38] = ?: %02x\n", (iValue >> 0x06) & 0x01);
	DBG(2, "         bit[39] = ?: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = Data_Get(&buffer[0x07e], 0x01) & 0x0f;
	dValue = iValue * pow(2, 32);
	iValue = Data_Get(&buffer[0x07c], 0x02);
	dValue = dValue + (iValue * pow(2, 16)) + Data_Get(&buffer[0x07a], 0x02);
	DBG(2, "0x007a");
	DBG(2, "   bit[0..35] = timing.cph5p1: %.0f.\n", dValue);
	iValue = Data_Get(&buffer[0x07e], 0x01);
	DBG(2, "         bit[36] = timing.cph5go: %02x\n", (iValue >> 0x04) & 0x01);
	DBG(2, "         bit[37] = timing.cph5ge: %02x\n", (iValue >> 0x05) & 0x01);
	DBG(2, "         bit[38] = timing.cph5ps: %02x\n", (iValue >> 0x06) & 0x01);
	DBG(2, "         bit[39] = ?: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = Data_Get(&buffer[0x083], 0x01) & 0x0f;
	dValue = iValue * pow(2, 32);
	iValue = Data_Get(&buffer[0x081], 0x02);
	dValue = dValue + (iValue * pow(2, 16)) + Data_Get(&buffer[0x07f], 0x02);
	DBG(2, "0x007f");
	DBG(2, "   bit[0..35] = timing.cph5p2: %.0f.\n", dValue);
	iValue = Data_Get(&buffer[0x083], 0x01);
	DBG(2, "         bits[36..39] = %02x\n", (iValue >> 0x04) & 0x0f);
	DBG(2, "         bit[36] = ?: %02x\n", (iValue >> 0x04) & 0x01);
	DBG(2, "         bit[37] = ?: %02x\n", (iValue >> 0x05) & 0x01);
	DBG(2, "         bit[38] = ?: %02x\n", (iValue >> 0x06) & 0x01);
	DBG(2, "         bit[39] = ?: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = Data_Get(&buffer[0x08a], 0x02);
	dValue = ((buffer[0x08c] & 0xff) * 65536) + iValue;
	DBG(2, "0x008a");
	DBG(2, "   timing.clamps : %.0f.\n", dValue);
	
	iValue = Data_Get(&buffer[0x08d], 0x02);
	dValue = ((buffer[0x08f] & 0xff) * 65536) + iValue;
	DBG(2, "0x008d");
	DBG(2, "   timing.clampe : %.0f.\n", dValue);
	
	iValue = Data_Get(&buffer[0x092], 0x01);
	DBG(2, "0x0092");
	DBG(2, "   bit[0..5] = timing.cdss1: %02x\n", iValue & 0x3f);
	DBG(2, "         bit[6..7] = ?: %02x\n", (iValue >> 0x06) & 0x02);
	
	iValue = Data_Get(&buffer[0x093], 0x01);
	DBG(2, "0x0093");
	DBG(2, "   bit[0..5] = timing.cdsc1: %02x\n", iValue & 0x3f);
	DBG(2, "         bit[6..7] = ?: %02x\n", (iValue >> 0x06) & 0x02);
	
	iValue = Data_Get(&buffer[0x094], 0x01);
	DBG(2, "0x0094");
	DBG(2, "   bit[0..5] = timing.cdss2: %02x\n", iValue & 0x3f);
	DBG(2, "         bit[6..7] = ?: %02x\n", (iValue >> 0x06) & 0x02);
	
	iValue = Data_Get(&buffer[0x095], 0x01);
	DBG(2, "0x0095");
	DBG(2, "   bit[0..5] = timing.cdsc2: %02x\n", iValue & 0x3f);
	DBG(2, "         bit[6..7] = ?: %02x\n", (iValue >> 0x06) & 0x02);
	
	iValue = Data_Get(&buffer[0x096], 0x01);
	DBG(2, "0x0096");
	DBG(2, "   bit[0..5] = timing.cnpp: %02x\n", iValue & 0x3f);
	DBG(2, "         bit[6..7] = ?: %02x\n", (iValue >> 0x06) & 0x02);
	
	iValue = Data_Get(&buffer[0x09b], 0x01) & 0x0f;
	dValue = iValue * pow(2, 32);
	iValue = Data_Get(&buffer[0x099], 0x02);
	dValue = dValue + (iValue * pow(2, 16)) + Data_Get(&buffer[0x097], 0x02);
	DBG(2, "0x0097");
	DBG(2, "   bit[0..35] = timing.adcclkp[0]: %.0f.\n", dValue);
	iValue = Data_Get(&buffer[0x09b], 0x01);
	DBG(2, "         bits[36..39] = %02x\n", (iValue >> 0x04) & 0x0f);
	DBG(2, "         bit[36] = ?: %02x\n", (iValue >> 0x04) & 0x01);
	DBG(2, "         bit[37] = ?: %02x\n", (iValue >> 0x05) & 0x01);
	DBG(2, "         bit[38] = ?: %02x\n", (iValue >> 0x06) & 0x01);
	DBG(2, "         bit[39] = ?: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = Data_Get(&buffer[0x0b0], 0x02);
	DBG(2, "0x00b0");
	DBG(2, "   Left : %04x\n", iValue);
	
	iValue = Data_Get(&buffer[0x0b2], 0x02);
	DBG(2, "0x00b2");
	DBG(2, "   Right: %04x\n", iValue);
	
	iValue = Data_Get(&buffer[0x0c0], 0x01);
	DBG(2, "0x00c0");
	DBG(2, "   bit[0..4] = (sensorresolution / resolution_x): %02x\n", iValue & 0x1f);
	DBG(2, "         bit[5..7] = ?: %02x\n", (iValue >> 0x05) & 0x07);
	
	iValue = Data_Get(&buffer[0x0c5], 0x01) & 0x0f;
	dValue = iValue * pow(2, 32);
	iValue = Data_Get(&buffer[0x0c3], 0x02);
	dValue = dValue + (iValue * pow(2, 16)) + Data_Get(&buffer[0x0c1], 0x02);
	DBG(2, "0x00c1");
	DBG(2, "   bit[0..35] = timing.adcclkp[1]: %.0f.\n", dValue);
	iValue = Data_Get(&buffer[0x0c5], 0x01);
	DBG(2, "         bits[36..39] = %02x\n", (iValue >> 0x04) & 0x0f);
	DBG(2, "         bit[36] = ?: %02x (equal to bit[32])\n", (iValue >> 0x04) & 0x01);
	DBG(2, "         bit[37] = ?: %02x\n", (iValue >> 0x05) & 0x01);
	DBG(2, "         bit[38] = ?: %02x\n", (iValue >> 0x06) & 0x01);
	DBG(2, "         bit[39] = ?: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = ((buffer[0x0d4] & 0x0f) << 0x10) + Data_Get(&buffer[0x0d0], 0x02);
	DBG(2, "0x00d0");
	DBG(2, "   Top : %04x\n", iValue);
	
	iValue = ((buffer[0x0d4] & 0xf0) << 0x06)+ Data_Get(&buffer[0x0d2], 0x02);
	DBG(2, "0x00d2");
	DBG(2, "   Down: %04x\n", iValue);
	
	iValue = Data_Get(&buffer[0x0d7], 0x01);
	DBG(2, "0x00d7");
	DBG(2, "   bit[0..5] = motorpwmfrequency: %02x\n", iValue & 0x3f);
	DBG(2, "         bit[6]    = ?: %02x\n", (iValue >> 0x06) & 0x01);
	DBG(2, "         bit[7]    = motortype: %02x\n", (iValue >> 0x07) & 0x01);
	
	iValue = Data_Get(&buffer[0x0d8], 0x01);
	DBG(2, "0x00d8");
	DBG(2, "   bit[0..5] = ?: %02x\n", iValue & 0x3f);
	DBG(2, "         bit[6]    =  %02x :", (iValue >> 0x06) & 0x01);
	if (((iValue >> 0x06) & 0x01) == 0x00)
		DBG(2, "scantype == ST_NORMAL\n");
			else DBG(2, "\n");
	DBG(2, "         bit[7]    =  %02x :", (iValue >> 0x07) & 0x01);
	if (((iValue >> 0x07) & 0x01) == 0x00)
		DBG(2, "scantype == ST_NORMAL\n");
			else DBG(2, "\n");

	iValue = Data_Get(&buffer[0x0dd], 0x01);
	DBG(2, "0x00da");
	DBG(2, "   msi = %03x\n", ((iValue & 0x3) << 8)  + Data_Get(&buffer[0x0da], 0x01));

	DBG(2, "0x00db");
	DBG(2, "   motorbackstep1 = %03x\n", ((iValue & 0x0c) << 6)  + Data_Get(&buffer[0x0db], 0x01));

	DBG(2, "0x00dc");
	DBG(2, "   motorbackstep2 = %03x\n", ((iValue & 0x30) << 4)  + Data_Get(&buffer[0x0dc], 0x01));

	DBG(2, "0x00dd");
	DBG(2, "   bit[6..7] = %02x\n", ((iValue & 0xc0) >> 6)  & 0xff);

	iValue = Data_Get(&buffer[0x0de], 0x02);
	DBG(2, "0x00de");
	DBG(2, "   bit[0..11] = ?: %02x\n", iValue & 0xfff);
	DBG(2, "         bit[12..15] = ?: %02x\n", (iValue >> 12) & 0x0f);

	iValue = Data_Get(&buffer[0x0df], 0x01);
	DBG(2, "0x00df");
	DBG(2, "   bit[0..3] = ?: %02x\n", iValue & 0x0f);
	DBG(2, "         bit[4] = has_motorcurves?: %02x\n", (iValue >> 4) & 0x01);

	iValue = Data_Get(&buffer[0x0e0], 0x0);
	DBG(2, "0x00e0");
	DBG(2, "   ?: %02x\n", iValue);

	iValue = Data_Get(&buffer[0x0e1], 0x03);
	DBG(2, "0x00e1");
	DBG(2, "   step = %06x\n", iValue);

	iValue = Data_Get(&buffer[0x0e4], 0x03);
	DBG(2, "0x00e4");
	DBG(2, "   step = %06x\n", iValue);

	iValue = Data_Get(&buffer[0x0e7], 0x03);
	DBG(2, "0x00e7");
	DBG(2, "   step = %06x\n", iValue);

	iValue = Data_Get(&buffer[0x0ea], 0x03);
	DBG(2, "0x00ea");
	DBG(2, "   step = %06x\n", iValue);

	iValue = Data_Get(&buffer[0x0ed], 0x03);
	DBG(2, "0x00ed");
	DBG(2, "   step = %06x\n", iValue);

	iValue = Data_Get(&buffer[0x0f0], 0x03);
	DBG(2, "0x00f0");
	DBG(2, "   step = %06x\n", iValue);

	iValue = Data_Get(&buffer[0x0f3], 0x03);
	DBG(2, "0x00f3");
	DBG(2, "   step = %06x\n", iValue);

	iValue = Data_Get(&buffer[0x0f6], 0x02);
	DBG(2, "0x00f6");
	DBG(2, "   bit[00..13] = %04x\n", iValue & 0x3fff);
	DBG(2, "         bit[14..15] = %04x\n",(iValue >> 14) & 0x02);

	iValue = Data_Get(&buffer[0x0f8], 0x02);
	DBG(2, "0x00f8");
	DBG(2, "   bit[00..13] = %04x\n", iValue & 0x3fff);
	DBG(2, "         bit[14..15] = %04x\n",(iValue >> 14) & 0x02);

	iValue = Data_Get(&buffer[0x0fa], 0x02);
	DBG(2, "0x00fa");
	DBG(2, "   bit[00..13] = %04x\n", iValue & 0x3fff);
	DBG(2, "         bit[14..15] = %04x\n",(iValue >> 14) & 0x02);

	iValue = Data_Get(&buffer[0x0fc], 0x02);
	DBG(2, "0x00fc");
	DBG(2, "   bit[00..13] = %04x\n", iValue & 0x3fff);
	DBG(2, "         bit[14..15] = %04x\n",(iValue >> 14) & 0x02);

	iValue = Data_Get(&buffer[0x0fe], 0x02);
	DBG(2, "0x00fe");
	DBG(2, "   bit[00..13] = %04x\n", iValue & 0x3fff);
	DBG(2, "         bit[14..15] = %04x\n",(iValue >> 14) & 0x02);

	iValue = Data_Get(&buffer[0x100], 0x02);
	DBG(2, "0x0100");
	DBG(2, "   bit[00..13] = %04x\n", iValue & 0x3fff);
	DBG(2, "         bit[14..15] = %04x\n",(iValue >> 14) & 0x02);

	iValue = Data_Get(&buffer[0x102], 0x02);
	DBG(2, "0x0102");
	DBG(2, "   bit[00..13] = %04x\n", iValue & 0x3fff);
	DBG(2, "         bit[14..15] = %04x\n",(iValue >> 14) & 0x02);

	iValue = Data_Get(&buffer[0x146], 0x01);
	DBG(2, "0x0146");
	DBG(2, "   bit[00..05] = ? : %04x\n", iValue & 0x3f);
	DBG(2, "         bit[6] = lamp turned on? : %02x\n", (iValue >> 6) & 0x01);
	DBG(2, "         bit[7] = sensortype : %02x ", (iValue >> 7) & 0x01);
	if (((iValue >> 7) & 0x01) == 1)
		DBG(2, "TOSHIBA\n");
			else DBG(2, "SONY\n");

	iValue = Data_Get(&buffer[0x147], 0x01);
	DBG(2, "0x0147");
	DBG(2, "   time to turn off lamp =  %04x (seconds * 2.682163611980331)\n", iValue);

	iValue = Data_Get(&buffer[0x148], 0x01);
	DBG(2, "0x0148");
	DBG(2, "   bit[0..5] = %02x\n", iValue & 0x3f);
	DBG(2, "         bit[6..7] = %02x\n",(iValue >> 6) & 0x03);

	iValue = Data_Get(&buffer[0x14a], 0x01);
	DBG(2, "0x014a");
	DBG(2, "   bit[0..5] = sensor line distance : %02x\n", iValue & 0x3f);
	DBG(2, "         bit[6..7] = ?: %02x\n",(iValue >> 6) & 0x03);

	iValue = Data_Get(&buffer[0x14b], 0x01);
	DBG(2, "0x014b");
	DBG(2, "   bit[0..5] = ?: %02x\n", iValue & 0x3f);
	DBG(2, "         bit[6..7] = ?: %02x\n",(iValue >> 6) & 0x03);

	iValue = Data_Get(&buffer[0x14c], 0x01);
	DBG(2, "0x014c");
	DBG(2, "   bit[0..5] = sensor line distance * 2 : %02x\n", iValue & 0x3f);
	DBG(2, "         bit[6..7] = ?: %02x\n",(iValue >> 6) & 0x03);

	iValue = Data_Get(&buffer[0x155], 0x01);
	DBG(2, "0x0155");
	DBG(2, "   bit[0..3] = ?: %02x\n", iValue & 0x0f);
	DBG(2, "         bit[4] = %02x : ",(iValue >> 4) & 0x01);
	if (((iValue >> 4) & 0x01) == 0)
		DBG(2, "flb lamp\n");
			else DBG(2, "tma lamp\n");

	iValue = Data_Get(&buffer[0x158], 0x01);
	DBG(2, "0x0158");
	DBG(2, "   bit[0..3] = %02x : Scanner buttons ", iValue & 0x0f);
	if ((iValue & 0x0f) == 0x0f)
		DBG(2, "enabled\n");
			else DBG(2, "dissabled\n");
	DBG(2, "         bit[4..7] = ? : %02x\n", (iValue >> 4) & 0x0f);

	iValue = Data_Get(&buffer[0x16f], 0x01);
	DBG(2, "0x016f");
	DBG(2, "   bit[0..5] = ? : %02x\n", iValue & 0x3f);
	DBG(2, "         bit[6] = is lamp at home? : %02x\n", (iValue >> 6) & 0x01);
	DBG(2, "         bit[7] = ?: %02x\n", (iValue >> 7) & 0x01);

	DBG(2, "----------------------------------------------------\n\n");
	return OK;
}
*/

/*static void show_diff(SANE_Byte *original)
{
	SANE_Byte *buffer = (SANE_Byte *)malloc(0x71a * sizeof(SANE_Byte));
	SANE_Int a;

	if ((buffer == NULL)||(original == NULL))
		return;

	if (RTS_ReadRegs(buffer) != OK)
	{
		free(buffer);
		return;
	}

	for (a = 0; a < 0x71a; a++)
	{
		if ((original[a] & 0xff) != (buffer[a] & 0xff))
		{
			printf("%5i: %i -> %i\n", a, original[a] & 0xff, buffer[a] & 0xff);
			original[a] = buffer[a] & 0xff;
		}
	}

	free(buffer);
} */

static SANE_Int
Constrains_Set (SANE_Byte type, struct st_coords *coords)
{
  /*
   * Sets constrains to one scan type in milimeters unit.
   */

  SANE_Int rst = ERROR;

  if ((coords != NULL) && (constrains != NULL))
    {
      if ((type < ST_NORMAL) || (type > ST_NEG))
	type = ST_NORMAL;

      switch (type)
	{
	case ST_TA:
	  memcpy (&constrains->slide, coords, sizeof (struct st_coords));
	  break;
	case ST_NEG:
	  memcpy (&constrains->negative, coords, sizeof (struct st_coords));
	  break;
	default:
	  /* ST_NORMAL and others */
	  memcpy (&constrains->reflective, coords, sizeof (struct st_coords));
	  break;
	}

      DBG (2,
	   "> Constrains_Set(type=%i, left=%i, top=%i, width=%i, height=%i): OK\n",
	   type, coords->left, coords->top, coords->width, coords->height);
    }
  else
    DBG (2, "> Constrains_Set: ERROR\n");

  return rst;
}

static SANE_Int
Constrains_Init ()
{
  /*
   * It will set default constrains of a HP3970 scanner
   * All values are set in milimeters
   */

  SANE_Int rst = ERROR;

  if (constrains == NULL)
    {
      constrains =
	(struct st_constrains *) malloc (sizeof (struct st_constrains));
      if (constrains != NULL)
	{
	  struct st_coords coords;

	  /* Reflective */
	  coords.left = 0;
	  coords.width = 220;
	  coords.top = 0;
	  coords.height = 300;
	  Constrains_Set (ST_NORMAL, &coords);

	  /* Negative and slide */
	  coords.left = 88;
	  coords.top = 0;
	  coords.width = 42;
	  coords.height = 83;
	  Constrains_Set (ST_TA, &coords);
	  Constrains_Set (ST_NEG, &coords);
	  rst = OK;
	}
    }

  DBG (2, "> Constrains_Init(): %i\n", rst);

  return rst;
}

static SANE_Int
Constrains_Check (SANE_Int Resolution, SANE_Int scantype,
		  struct st_coords *mycoords)
{
  /*
     Constrains: 
     100 dpi   850 x  1170   | 164 x 327
     300 dpi  2550 x  3510
     600 dpi  5100 x  7020
     1200 dpi 10200 x 14040
   */

  SANE_Int rst = ERROR;

  if (constrains != NULL)
    {
      struct st_coords coords;
      struct st_coords *mc;

      if ((scantype < ST_NORMAL) || (scantype > ST_NEG))
	scantype = ST_NORMAL;

      switch (scantype)
	{
	case ST_TA:
	  mc = &constrains->slide;
	  break;
	case ST_NEG:
	  mc = &constrains->negative;
	  break;
	default:
	  mc = &constrains->reflective;
	  break;
	}

      coords.left = MM_TO_PIXEL (mc->left, Resolution);
      coords.width = MM_TO_PIXEL (mc->width, Resolution);
      coords.top = MM_TO_PIXEL (mc->top, Resolution);
      coords.height = MM_TO_PIXEL (mc->height, Resolution);

      /* Check left and top */
      if (mycoords->left < 0)
	mycoords->left = 0;

      mycoords->left += coords.left;

      if (mycoords->top < 0)
	mycoords->top = 0;

      mycoords->top += coords.top;

      /* Check width and height */
      if (mycoords->width < 0)
	mycoords->width = coords.width;

      if (mycoords->width > coords.width)
	mycoords->width = coords.width;

      if (mycoords->height < 0)
	mycoords->height = coords.height;

      if (mycoords->height > coords.height)
	mycoords->height = coords.height;

      rst = OK;
    }

  DBG (2,
       "> Constrains_Check: Source=%i, Res=%i, LW=(%i,%i), TH=(%i,%i): %i\n",
       scantype, Resolution, mycoords->left, mycoords->width, mycoords->top,
       mycoords->height, rst);

  return rst;
}

static struct st_coords *
Constrains_Get (SANE_Byte scantype)
{
  static struct st_coords *rst = NULL;

  if (constrains != NULL)
    {
      switch (scantype)
	{
	case ST_TA:
	  rst = &constrains->slide;
	  break;
	case ST_NEG:
	  rst = &constrains->negative;
	  break;
	default:
	  rst = &constrains->reflective;
	  break;
	}
    }

  return rst;
}

static void
Constrains_Free ()
{
  DBG (2, "> Constrains_Free\n");

  if (constrains != NULL)
    {
      free (constrains);
      constrains = NULL;
    }
}

static void
TIFF_Save (char *sFile, SANE_Int width, SANE_Int height, SANE_Int depth,
	   SANE_Byte * buffer, SANE_Int size)
{
  if (buffer != NULL)
    {
      TIFF *image;

      /* Open the TIFF file */
      if ((image = TIFFOpen (sFile, "w")) != NULL)
	{
	  SANE_Int spp = (depth > 1) ? 3 : 1;

	  /* We need to set some values for basic tags before we can add any data */
	  TIFFSetField (image, TIFFTAG_IMAGEWIDTH, width);
	  TIFFSetField (image, TIFFTAG_IMAGELENGTH, height);
	  TIFFSetField (image, TIFFTAG_BITSPERSAMPLE, depth);
	  TIFFSetField (image, TIFFTAG_SAMPLESPERPIXEL, spp);

	  TIFFSetField (image, TIFFTAG_PHOTOMETRIC, PHOTOMETRIC_RGB);
	  TIFFSetField (image, TIFFTAG_FILLORDER, FILLORDER_MSB2LSB);
	  TIFFSetField (image, TIFFTAG_PLANARCONFIG, PLANARCONFIG_CONTIG);

	  TIFFSetField (image, TIFFTAG_XRESOLUTION, 150.0);
	  TIFFSetField (image, TIFFTAG_YRESOLUTION, 150.0);
	  TIFFSetField (image, TIFFTAG_RESOLUTIONUNIT, RESUNIT_INCH);

	  /* Write the information to the file */
	  TIFFWriteRawStrip (image, 0, buffer, size);
	  TIFFClose (image);
	}
    }
}

static void
RTS_DebugInit ()
{
  RTS_Debug.DumpShadingData = FALSE;
  RTS_Debug.SaveCalibFile = FALSE;
  RTS_Debug.ScanWhiteBoard = FALSE;
  RTS_Debug.EnableGamma = TRUE;
}

static SANE_Int
dump_shading (struct st_calibration *myCalib)
{
  SANE_Int rst = ERROR;

  if (myCalib != NULL)
    {
      SANE_Int colour, a;
      FILE *shadingfile[3];

      shadingfile[0] = fopen ("RShading.txt", "w");
      shadingfile[1] = fopen ("GShading.txt", "w");
      shadingfile[2] = fopen ("BShading.txt", "w");

      for (colour = 0; colour < 3; colour++)
	{
	  if (shadingfile[colour] != NULL)
	    {
	      for (a = 0; a < myCalib->shadinglength; a++)
		fprintf (shadingfile[colour], "%04i: %04x %04x\n", a,
			 (unsigned int) myCalib->white_shading[colour][a],
			 (unsigned int) myCalib->black_shading[colour][a]);
	      fclose (shadingfile[colour]);
	    }
	}

      rst = OK;
    }

  return rst;
}

static SANE_Int
RTS_SetupGamma (SANE_Byte * Regs, struct st_hwdconfig *lowcfg)
{
  SANE_Int rst = ERROR;

  if ((lowcfg != NULL) && (Regs != NULL))
    {
      rst = OK;
      if (lowcfg->use_gamma_tables != FALSE)
	{
	  SANE_Int table_size;

	  Regs[0x1d0] &= 0xf0;
	  Regs[0x1d0] |= (lowcfg->gamma_tablesize & 0x0f);		 /*----xxxx Table size */
	  Regs[0x1d0] |= 0x40;						 /*-1------ Enable gamma */

	  switch (Regs[0x1d0] & 0x0c)
	    {
	    case 0:
	      table_size = (Regs[0x1d0] & 1) | 0x0100;
	      break;
	    case 4:
	      table_size = (Regs[0x1d0] & 1) | 0x0400;
	      break;
	    case 8:
	      table_size = (Regs[0x1d0] & 1) | 0x1000;
	      break;
	    default:
	      table_size = lowcfg->startpos & 0xffff;
	      break;
	    }

	  /* 5073 */
	  Data_BitSet (0, &Regs[0x1b4], 14);
	  Data_BitSet (table_size, &Regs[0x1b6], 14);
	  Data_BitSet (table_size * 2, &Regs[0x1b8], 14);
	  v15f8 = (((table_size * 3) + 15) / 16) & 0xffff;
	}
      else
	{
	  Regs[0x1d0] &= 0xbf;	/* -0------ Disable gamma */
	  v15f8 = 0;
	}
    }

  DBG (2, "> RTS_SetupGamma(*Regs, *lowcfg): %i\n", rst);

  return rst;
}

static SANE_Int
RTS_USBType (void)
{
  /* Gets USB type of this scanner */

  SANE_Int rst = ERROR;
  SANE_Byte data;
  char sUSB[7];

  DBG (2, "+ RTS_USBType(void)\n");

  if (Read_Byte (0xfe11, &data) == OK)
    rst = (data & 1);

  if (rst == USB11)
    strcpy (sUSB, "USB1.1");
  else
    strcpy (sUSB, "USB2.0");

  DBG (2, "- RTS_USBType(void): %s\n", sUSB);

  return rst;
}

static SANE_Int
Init_Vars (void)
{
  SANE_Int rst = ERROR;

  bzero (&scanning, sizeof (struct st_scanning));
  RTS_DebugInit ();
  rst = OK;

  return rst;
}
