/* asic.c - ASIC registers I/O functions
 * 
 * Copyright (C) 2004, 2005 Anderson Lizardo
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc., 59
 * Temple Place, Suite 330, Boston, MA  02111-1307 USA
*/

#include <linux/parport.h>

#include "geniusvp2-asic.h"
#include "geniusvp2-parport.h"

int
sane_geniusvp2_reg_read (unsigned char reg, unsigned char *data)
{
    return sane_geniusvp2_reg_read_buf (reg, data, 1);
}

int
sane_geniusvp2_reg_read_buf (unsigned char reg, unsigned char *data, size_t size)
{
    sane_geniusvp2_epp_set_mode (IEEE1284_ADDR);
    sane_geniusvp2_epp_write (&reg, 1);
    sane_geniusvp2_epp_set_mode (IEEE1284_DATA);
    return sane_geniusvp2_epp_read (data, size);
}

int
sane_geniusvp2_reg_write (unsigned char reg, unsigned char data)
{
    return sane_geniusvp2_reg_write_buf (reg, &data, 1);
}

int
sane_geniusvp2_reg_write_buf (unsigned char reg, unsigned char *data, size_t size)
{
    sane_geniusvp2_epp_set_mode (IEEE1284_ADDR);
    sane_geniusvp2_epp_write (&reg, 1);
    sane_geniusvp2_epp_set_mode (IEEE1284_DATA);
    return sane_geniusvp2_epp_write (data, size);
}

void
sane_geniusvp2_init_regs (void)
{
    reg0.w = 0xe1;
    reg1.w = 0x5a;
    reg2.w = 0x00;
    reg3.w = 0x0f;
    reg4.w = 0x32;
    reg5.w = 0x00;
    reg6.w = 0x94;
    reg7.w = 0x09;
    reg8.w = 0xc4;
    reg9.w = 0x0a;
    reg10.w = 0x17;
    reg11.w = 0x70;
    reg12.w = 0x44;
    reg13.w = 0x91;
    reg14.w = 0x07;
    reg15.w = 0xff;
    reg16.w = 0xff;
    reg17.w = 0x00;
    reg18.w = 0x00;
    reg19.w = 0x00;
    reg20.w = 0x00;
    reg21.w = 0x00;
    reg22.w = 0x13;
    reg23.w = 0xec;
    reg24.w = 0x86;
    reg25.w = 0xf0;
    reg26.w = 0x18;
    reg27.w = 0x22;
    reg28.w = 0x58;
    reg29.w = 0x58;
}
