/*
  Copyright (C) 2001 Bertrik Sikken (bertrik@zonnet.nl)

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

  $Id: niash_xfer.h,v 1.1.1.1 2003/10/12 16:23:38 bertrik Exp $
*/

/*
    Provides a simple interface to read and write data from the scanner,
    without any knowledge whether it's a parallel or USB scanner
*/

#ifndef _NIASH_XFER_H_
#define _NIASH_XFER_H_

#include <stdio.h>		/* for FILE * */
#include "niash_types.h"


/* register codes for the USB - IEEE1284 bridge */
#define USB_SETUP       0x82
#define EPP_ADDR        0x83
#define EPP_DATA_READ   0x84
#define EPP_DATA_WRITE  0x85
#define SPP_STATUS      0x86
#define SPP_CONTROL     0x87
#define SPP_DATA        0x88


typedef enum
{
  eUnknownModel = 0,
  eHp3300c,
  eHp3400c,
  eHp4300c,
  eAgfaTouch
} EScannerModel;


typedef struct
{
  char *pszVendor;
  char *pszName;
  int iVendor;
  int iProduct;
  EScannerModel eModel;
} TScannerModel;


typedef int (TFnReportDevice) (TScannerModel * pModel, char *pszDeviceName);


/* Creates our own DBG definitions, externs are define in main.c*/
#ifndef WITH_NIASH
#define DBG fprintf
extern FILE *DBG_MSG;
extern FILE *DBG_ERR;
extern FILE *BG_ASSERT;
#endif /* NO WITH_NIASH */


/* USB device file name */
extern char *usb_devfile;


/* list of supported models, the actual list is in niash_xfer.c */
extern TScannerModel ScannerModels[];


void NiashXferInit (TFnReportDevice * pfnReport);
int NiashXferOpen (char *pszName, EScannerModel * peModel);
void NiashXferClose (int iXferHandle);

void NiashWriteReg (int iXferHandle, unsigned char bReg, unsigned char bData);
void NiashReadReg (int iXferHandle, unsigned char bReg, unsigned char * pbData);
void NiashWriteBulk (int iXferHandle, unsigned char * pabBuf, int iSize);
void NiashReadBulk (int iXferHandle, unsigned char * pabBuf, int iSize);
void NiashWakeup (int iXferHandle);

bool MatchUsbDevice (int iVendor, int iProduct, TScannerModel ** ppeModel);

#endif /* _NIASH_XFER_H_ */
