# Summary

[Introduction](README.md)

* [Meet Safe and Unsafe](meet-safe-and-unsafe.md)
	* [How Safe and Unsafe Interact](safe-unsafe-meaning.md)
	* [Working with Unsafe](working-with-unsafe.md)
* [Data Layout](data.md)
	* [repr(Rust)](repr-rust.md)
	* [Exotically Sized Types](exotic-sizes.md)
	* [Other reprs](other-reprs.md)
* [Ownership](ownership.md)
	* [References](references.md)
	* [Lifetimes](lifetimes.md)
	* [Limits of Lifetimes](lifetime-mismatch.md)
	* [Lifetime Elision](lifetime-elision.md)
	* [Unbounded Lifetimes](unbounded-lifetimes.md)
	* [Higher-Rank Trait Bounds](hrtb.md)
	* [Subtyping and Variance](subtyping.md)
	* [Drop Check](dropck.md)
	* [PhantomData](phantom-data.md)
	* [Splitting Borrows](borrow-splitting.md)
* [Type Conversions](conversions.md)
	* [Coercions](coercions.md)
	* [The Dot Operator](dot-operator.md)
	* [Casts](casts.md)
	* [Transmutes](transmutes.md)
* [Uninitialized Memory](uninitialized.md)
	* [Checked](checked-uninit.md)
	* [Drop Flags](drop-flags.md)
	* [Unchecked](unchecked-uninit.md)
* [Ownership Based Resource Management](obrm.md)
	* [Constructors](constructors.md)
	* [Destructors](destructors.md)
	* [Leaking](leaking.md)
* [Unwinding](unwinding.md)
	* [Exception Safety](exception-safety.md)
	* [Poisoning](poisoning.md)
* [Concurrency](concurrency.md)
	* [Races](races.md)
	* [Send and Sync](send-and-sync.md)
	* [Atomics](atomics.md)
* [Implementing Vec](vec.md)
	* [Layout](vec-layout.md)
	* [Allocating](vec-alloc.md)
	* [Push and Pop](vec-push-pop.md)
	* [Deallocating](vec-dealloc.md)
	* [Deref](vec-deref.md)
	* [Insert and Remove](vec-insert-remove.md)
	* [IntoIter](vec-into-iter.md)
	* [RawVec](vec-raw.md)
	* [Drain](vec-drain.md)
	* [Handling Zero-Sized Types](vec-zsts.md)
	* [Final Code](vec-final.md)
* [Implementing Arc and Mutex](arc-and-mutex.md)
