# Protocol::HTTP

Provides abstractions for working with the HTTP protocol.

[![Build Status](https://travis-ci.com/socketry/protocol-http.svg?branch=master)](http://travis-ci.com/socketry/protocol-http)

## Installation

Add this line to your application's Gemfile:

```ruby
gem 'protocol-http'
```

And then execute:

	$ bundle

Or install it yourself as:

	$ gem install protocol-http

## Usage

### Headers

```ruby
require 'protocol/http/headers'

headers = Protocol::HTTP::Headers.new

headers['Content-Type'] = "image/jpeg"

headers['content-type']
# => "image/jpeg"
```

### Reference

```ruby
require 'protocol/http/reference'

reference = Protocol::HTTP::Reference.new("/search", q: 'kittens')

reference.to_s
# => "/search?q=kittens"
```

### URL

```ruby
require 'protocol/http/url'

reference = Protocol::HTTP::Reference.parse("/search?q=kittens")

parameters = Protocol::HTTP::URL.decode(reference.query_string)
# => {"q"=>"kittens"}
```

## Contributing

1. Fork it
2. Create your feature branch (`git checkout -b my-new-feature`)
3. Commit your changes (`git commit -am 'Add some feature'`)
4. Push to the branch (`git push origin my-new-feature`)
5. Create new Pull Request

## License

Released under the MIT license.

Copyright, 2019, by [Samuel G. D. Williams](http://www.codeotaku.com/samuel-williams).  

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
