def print_results(result)
	printer = RubyProf::FlatPrinter.new(result)
	printer.print(STDOUT)
    
	STDOUT << "\n" * 2
    
	printer = RubyProf::GraphPrinter.new(result)
	printer.print(STDOUT)
end

def check_parent_times(method)
	return if method.parents.length == 0 

	parents_self_time = method.parents.values.inject(0) do |sum, call_info|
		sum + call_info.self_time
	end
	assert_in_delta(method.self_time, parents_self_time, 0.01, method.name)	
    
	parents_children_time = method.parents.values.inject(0) do |sum, call_info|
		sum + call_info.children_time
	end
	assert_in_delta(method.children_time, parents_children_time, 0.01, method.name)
end
  
def check_parent_calls(method)
	return if method.parents.length == 0 
	
	parent_calls = method.parents.values.inject(0) do |sum, call_info|
		sum + call_info.called
	end
	assert_equal(method.called, parent_calls, method.name)	
end
  
def check_child_times(method)
	return if method.children.length == 0
    
	children_total_time = method.children.values.inject(0) do |sum, call_info|
		sum + call_info.total_time
	end
	
	assert_in_delta(method.children_time, children_total_time, 0.01, method.name)
end
  


