# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::DataLakeAnalytics
  #
  # Creates an Azure Data Lake Analytics account management client.
  #
  class StorageAccounts
    include MsRestAzure

    #
    # Creates and initializes a new instance of the StorageAccounts class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [DataLakeAnalyticsAccountManagementClient] reference to the DataLakeAnalyticsAccountManagementClient
    attr_reader :client

    #
    # Updates the specified Data Lake Analytics account to add an Azure Storage
    # account.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # which to add the Azure Storage account.
    # @param storage_account_name [String] The name of the Azure Storage account to
    # add
    # @param parameters [AddStorageAccountParameters] The parameters containing the
    # access key and optional suffix for the Azure Storage Account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def add(resource_group_name, account_name, storage_account_name, parameters, custom_headers = nil)
      response = add_async(resource_group_name, account_name, storage_account_name, parameters, custom_headers).value!
      nil
    end

    #
    # Updates the specified Data Lake Analytics account to add an Azure Storage
    # account.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # which to add the Azure Storage account.
    # @param storage_account_name [String] The name of the Azure Storage account to
    # add
    # @param parameters [AddStorageAccountParameters] The parameters containing the
    # access key and optional suffix for the Azure Storage Account.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def add_with_http_info(resource_group_name, account_name, storage_account_name, parameters, custom_headers = nil)
      add_async(resource_group_name, account_name, storage_account_name, parameters, custom_headers).value!
    end

    #
    # Updates the specified Data Lake Analytics account to add an Azure Storage
    # account.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # which to add the Azure Storage account.
    # @param storage_account_name [String] The name of the Azure Storage account to
    # add
    # @param parameters [AddStorageAccountParameters] The parameters containing the
    # access key and optional suffix for the Azure Storage Account.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def add_async(resource_group_name, account_name, storage_account_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'storage_account_name is nil' if storage_account_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::DataLakeAnalytics::Models::AddStorageAccountParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'storageAccountName' => storage_account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Updates the Data Lake Analytics account to replace Azure Storage blob account
    # details, such as the access key and/or suffix.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # modify storage accounts in
    # @param storage_account_name [String] The Azure Storage account to modify
    # @param parameters [UpdateStorageAccountParameters] The parameters containing
    # the access key and suffix to update the storage account with, if any. Passing
    # nothing results in no change.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def update(resource_group_name, account_name, storage_account_name, parameters = nil, custom_headers = nil)
      response = update_async(resource_group_name, account_name, storage_account_name, parameters, custom_headers).value!
      nil
    end

    #
    # Updates the Data Lake Analytics account to replace Azure Storage blob account
    # details, such as the access key and/or suffix.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # modify storage accounts in
    # @param storage_account_name [String] The Azure Storage account to modify
    # @param parameters [UpdateStorageAccountParameters] The parameters containing
    # the access key and suffix to update the storage account with, if any. Passing
    # nothing results in no change.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def update_with_http_info(resource_group_name, account_name, storage_account_name, parameters = nil, custom_headers = nil)
      update_async(resource_group_name, account_name, storage_account_name, parameters, custom_headers).value!
    end

    #
    # Updates the Data Lake Analytics account to replace Azure Storage blob account
    # details, such as the access key and/or suffix.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account to
    # modify storage accounts in
    # @param storage_account_name [String] The Azure Storage account to modify
    # @param parameters [UpdateStorageAccountParameters] The parameters containing
    # the access key and suffix to update the storage account with, if any. Passing
    # nothing results in no change.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def update_async(resource_group_name, account_name, storage_account_name, parameters = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'storage_account_name is nil' if storage_account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::DataLakeAnalytics::Models::UpdateStorageAccountParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'storageAccountName' => storage_account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Updates the specified Data Lake Analytics account to remove an Azure Storage
    # account.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account from
    # which to remove the Azure Storage account.
    # @param storage_account_name [String] The name of the Azure Storage account to
    # remove
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      response = delete_async(resource_group_name, account_name, storage_account_name, custom_headers).value!
      nil
    end

    #
    # Updates the specified Data Lake Analytics account to remove an Azure Storage
    # account.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account from
    # which to remove the Azure Storage account.
    # @param storage_account_name [String] The name of the Azure Storage account to
    # remove
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_with_http_info(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      delete_async(resource_group_name, account_name, storage_account_name, custom_headers).value!
    end

    #
    # Updates the specified Data Lake Analytics account to remove an Azure Storage
    # account.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account from
    # which to remove the Azure Storage account.
    # @param storage_account_name [String] The name of the Azure Storage account to
    # remove
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_async(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'storage_account_name is nil' if storage_account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'storageAccountName' => storage_account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets the specified Azure Storage account linked to the given Data Lake
    # Analytics account.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account from
    # which to retrieve Azure storage account details.
    # @param storage_account_name [String] The name of the Azure Storage account
    # for which to retrieve the details.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StorageAccountInfo] operation results.
    #
    def get(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      response = get_async(resource_group_name, account_name, storage_account_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the specified Azure Storage account linked to the given Data Lake
    # Analytics account.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account from
    # which to retrieve Azure storage account details.
    # @param storage_account_name [String] The name of the Azure Storage account
    # for which to retrieve the details.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      get_async(resource_group_name, account_name, storage_account_name, custom_headers).value!
    end

    #
    # Gets the specified Azure Storage account linked to the given Data Lake
    # Analytics account.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account from
    # which to retrieve Azure storage account details.
    # @param storage_account_name [String] The name of the Azure Storage account
    # for which to retrieve the details.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'storage_account_name is nil' if storage_account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'storageAccountName' => storage_account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DataLakeAnalytics::Models::StorageAccountInfo.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the specified Azure Storage container associated with the given Data
    # Lake Analytics and Azure Storage accounts.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to retrieve blob container.
    # @param storage_account_name [String] The name of the Azure storage account
    # from which to retrieve the blob container.
    # @param container_name [String] The name of the Azure storage container to
    # retrieve
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [StorageContainer] operation results.
    #
    def get_storage_container(resource_group_name, account_name, storage_account_name, container_name, custom_headers = nil)
      response = get_storage_container_async(resource_group_name, account_name, storage_account_name, container_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the specified Azure Storage container associated with the given Data
    # Lake Analytics and Azure Storage accounts.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to retrieve blob container.
    # @param storage_account_name [String] The name of the Azure storage account
    # from which to retrieve the blob container.
    # @param container_name [String] The name of the Azure storage container to
    # retrieve
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_storage_container_with_http_info(resource_group_name, account_name, storage_account_name, container_name, custom_headers = nil)
      get_storage_container_async(resource_group_name, account_name, storage_account_name, container_name, custom_headers).value!
    end

    #
    # Gets the specified Azure Storage container associated with the given Data
    # Lake Analytics and Azure Storage accounts.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to retrieve blob container.
    # @param storage_account_name [String] The name of the Azure storage account
    # from which to retrieve the blob container.
    # @param container_name [String] The name of the Azure storage container to
    # retrieve
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_storage_container_async(resource_group_name, account_name, storage_account_name, container_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'storage_account_name is nil' if storage_account_name.nil?
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}/Containers/{containerName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'storageAccountName' => storage_account_name,'containerName' => container_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DataLakeAnalytics::Models::StorageContainer.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the Azure Storage containers, if any, associated with the specified
    # Data Lake Analytics and Azure Storage account combination. The response
    # includes a link to the next page of results, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage blob containers.
    # @param storage_account_name [String] The name of the Azure storage account
    # from which to list blob containers.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<StorageContainer>] operation results.
    #
    def list_storage_containers(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      first_page = list_storage_containers_as_lazy(resource_group_name, account_name, storage_account_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists the Azure Storage containers, if any, associated with the specified
    # Data Lake Analytics and Azure Storage account combination. The response
    # includes a link to the next page of results, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage blob containers.
    # @param storage_account_name [String] The name of the Azure storage account
    # from which to list blob containers.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_storage_containers_with_http_info(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      list_storage_containers_async(resource_group_name, account_name, storage_account_name, custom_headers).value!
    end

    #
    # Lists the Azure Storage containers, if any, associated with the specified
    # Data Lake Analytics and Azure Storage account combination. The response
    # includes a link to the next page of results, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage blob containers.
    # @param storage_account_name [String] The name of the Azure storage account
    # from which to list blob containers.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_storage_containers_async(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'storage_account_name is nil' if storage_account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}/Containers'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'storageAccountName' => storage_account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DataLakeAnalytics::Models::ListStorageContainersResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the SAS token associated with the specified Data Lake Analytics and
    # Azure Storage account and container combination.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account from
    # which an Azure Storage account's SAS token is being requested.
    # @param storage_account_name [String] The name of the Azure storage account
    # for which the SAS token is being requested.
    # @param container_name [String] The name of the Azure storage container for
    # which the SAS token is being requested.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SasTokenInfo>] operation results.
    #
    def list_sas_tokens(resource_group_name, account_name, storage_account_name, container_name, custom_headers = nil)
      first_page = list_sas_tokens_as_lazy(resource_group_name, account_name, storage_account_name, container_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the SAS token associated with the specified Data Lake Analytics and
    # Azure Storage account and container combination.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account from
    # which an Azure Storage account's SAS token is being requested.
    # @param storage_account_name [String] The name of the Azure storage account
    # for which the SAS token is being requested.
    # @param container_name [String] The name of the Azure storage container for
    # which the SAS token is being requested.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_sas_tokens_with_http_info(resource_group_name, account_name, storage_account_name, container_name, custom_headers = nil)
      list_sas_tokens_async(resource_group_name, account_name, storage_account_name, container_name, custom_headers).value!
    end

    #
    # Gets the SAS token associated with the specified Data Lake Analytics and
    # Azure Storage account and container combination.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account from
    # which an Azure Storage account's SAS token is being requested.
    # @param storage_account_name [String] The name of the Azure storage account
    # for which the SAS token is being requested.
    # @param container_name [String] The name of the Azure storage container for
    # which the SAS token is being requested.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_sas_tokens_async(resource_group_name, account_name, storage_account_name, container_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, 'storage_account_name is nil' if storage_account_name.nil?
      fail ArgumentError, 'container_name is nil' if container_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/{storageAccountName}/Containers/{containerName}/listSasTokens'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'storageAccountName' => storage_account_name,'containerName' => container_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DataLakeAnalytics::Models::ListSasTokensResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the first page of Azure Storage accounts, if any, linked to the
    # specified Data Lake Analytics account. The response includes a link to the
    # next page, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage accounts.
    # @param filter [String] The OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<StorageAccountInfo>] operation results.
    #
    def list_by_account(resource_group_name, account_name, filter = nil, top = nil, skip = nil, select = nil, orderby = nil, count = nil, custom_headers = nil)
      first_page = list_by_account_as_lazy(resource_group_name, account_name, filter, top, skip, select, orderby, count, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the first page of Azure Storage accounts, if any, linked to the
    # specified Data Lake Analytics account. The response includes a link to the
    # next page, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage accounts.
    # @param filter [String] The OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_account_with_http_info(resource_group_name, account_name, filter = nil, top = nil, skip = nil, select = nil, orderby = nil, count = nil, custom_headers = nil)
      list_by_account_async(resource_group_name, account_name, filter, top, skip, select, orderby, count, custom_headers).value!
    end

    #
    # Gets the first page of Azure Storage accounts, if any, linked to the
    # specified Data Lake Analytics account. The response includes a link to the
    # next page, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage accounts.
    # @param filter [String] The OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_account_async(resource_group_name, account_name, filter = nil, top = nil, skip = nil, select = nil, orderby = nil, count = nil, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'account_name is nil' if account_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataLakeAnalytics/accounts/{accountName}/StorageAccounts/'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'accountName' => account_name,'subscriptionId' => @client.subscription_id},
          query_params: {'$filter' => filter,'$top' => top,'$skip' => skip,'$select' => select,'$orderby' => orderby,'$count' => count,'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DataLakeAnalytics::Models::DataLakeAnalyticsAccountListStorageAccountsResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the Azure Storage containers, if any, associated with the specified
    # Data Lake Analytics and Azure Storage account combination. The response
    # includes a link to the next page of results, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ListStorageContainersResult] operation results.
    #
    def list_storage_containers_next(next_page_link, custom_headers = nil)
      response = list_storage_containers_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists the Azure Storage containers, if any, associated with the specified
    # Data Lake Analytics and Azure Storage account combination. The response
    # includes a link to the next page of results, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_storage_containers_next_with_http_info(next_page_link, custom_headers = nil)
      list_storage_containers_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists the Azure Storage containers, if any, associated with the specified
    # Data Lake Analytics and Azure Storage account combination. The response
    # includes a link to the next page of results, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_storage_containers_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DataLakeAnalytics::Models::ListStorageContainersResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the SAS token associated with the specified Data Lake Analytics and
    # Azure Storage account and container combination.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ListSasTokensResult] operation results.
    #
    def list_sas_tokens_next(next_page_link, custom_headers = nil)
      response = list_sas_tokens_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the SAS token associated with the specified Data Lake Analytics and
    # Azure Storage account and container combination.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_sas_tokens_next_with_http_info(next_page_link, custom_headers = nil)
      list_sas_tokens_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets the SAS token associated with the specified Data Lake Analytics and
    # Azure Storage account and container combination.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_sas_tokens_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DataLakeAnalytics::Models::ListSasTokensResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the first page of Azure Storage accounts, if any, linked to the
    # specified Data Lake Analytics account. The response includes a link to the
    # next page, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeAnalyticsAccountListStorageAccountsResult] operation
    # results.
    #
    def list_by_account_next(next_page_link, custom_headers = nil)
      response = list_by_account_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the first page of Azure Storage accounts, if any, linked to the
    # specified Data Lake Analytics account. The response includes a link to the
    # next page, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_by_account_next_with_http_info(next_page_link, custom_headers = nil)
      list_by_account_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets the first page of Azure Storage accounts, if any, linked to the
    # specified Data Lake Analytics account. The response includes a link to the
    # next page, if any.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_by_account_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::DataLakeAnalytics::Models::DataLakeAnalyticsAccountListStorageAccountsResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the Azure Storage containers, if any, associated with the specified
    # Data Lake Analytics and Azure Storage account combination. The response
    # includes a link to the next page of results, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage blob containers.
    # @param storage_account_name [String] The name of the Azure storage account
    # from which to list blob containers.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ListStorageContainersResult] which provide lazy access to pages of
    # the response.
    #
    def list_storage_containers_as_lazy(resource_group_name, account_name, storage_account_name, custom_headers = nil)
      response = list_storage_containers_async(resource_group_name, account_name, storage_account_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_storage_containers_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets the SAS token associated with the specified Data Lake Analytics and
    # Azure Storage account and container combination.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account from
    # which an Azure Storage account's SAS token is being requested.
    # @param storage_account_name [String] The name of the Azure storage account
    # for which the SAS token is being requested.
    # @param container_name [String] The name of the Azure storage container for
    # which the SAS token is being requested.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ListSasTokensResult] which provide lazy access to pages of the
    # response.
    #
    def list_sas_tokens_as_lazy(resource_group_name, account_name, storage_account_name, container_name, custom_headers = nil)
      response = list_sas_tokens_async(resource_group_name, account_name, storage_account_name, container_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_sas_tokens_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets the first page of Azure Storage accounts, if any, linked to the
    # specified Data Lake Analytics account. The response includes a link to the
    # next page, if any.
    #
    # @param resource_group_name [String] The name of the Azure resource group that
    # contains the Data Lake Analytics account.
    # @param account_name [String] The name of the Data Lake Analytics account for
    # which to list Azure Storage accounts.
    # @param filter [String] The OData filter. Optional.
    # @param top [Integer] The number of items to return. Optional.
    # @param skip [Integer] The number of items to skip over before returning
    # elements. Optional.
    # @param select [String] OData Select statement. Limits the properties on each
    # entry to just those requested, e.g.
    # Categories?$select=CategoryName,Description. Optional.
    # @param orderby [String] OrderBy clause. One or more comma-separated
    # expressions with an optional "asc" (the default) or "desc" depending on the
    # order you'd like the values sorted, e.g. Categories?$orderby=CategoryName
    # desc. Optional.
    # @param count [Boolean] The Boolean value of true or false to request a count
    # of the matching resources included with the resources in the response, e.g.
    # Categories?$count=true. Optional.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [DataLakeAnalyticsAccountListStorageAccountsResult] which provide
    # lazy access to pages of the response.
    #
    def list_by_account_as_lazy(resource_group_name, account_name, filter = nil, top = nil, skip = nil, select = nil, orderby = nil, count = nil, custom_headers = nil)
      response = list_by_account_async(resource_group_name, account_name, filter, top, skip, select, orderby, count, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_by_account_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
