/*************************************************************************** 
 * RT2400 SourceForge Project - http://rt2400.sourceforge.net              * 
 *                                                                         * 
 *   This program is free software; you can redistribute it and/or modify  * 
 *   it under the terms of the GNU General Public License as published by  * 
 *   the Free Software Foundation; either version 2 of the License, or     * 
 *   (at your option) any later version.                                   * 
 *                                                                         * 
 *   This program is distributed in the hope that it will be useful,       * 
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        * 
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         * 
 *   GNU General Public License for more details.                          * 
 *                                                                         * 
 *   You should have received a copy of the GNU General Public License     * 
 *   along with this program; if not, write to the                         * 
 *   Free Software Foundation, Inc.,                                       * 
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             * 
 *                                                                         * 
 *   Licensed under the GNU GPL                                            * 
 *   Original code supplied under license from RaLink Inc, 2003.           * 
 ***************************************************************************/ 

 /*************************************************************************** 
 *      Module Name: oid.h 
 *              
 *      Abstract:   
 *              
 *      Revision History: 
 *      Who             When            What 
 *      --------        -----------     ----------------------------- 
 *      MarkW           9th  Feb 04     Baseline of code
 *      RobinC(RT2500)  21st Dec 04     RFMON Support
 *      MarkW(RT2500)   21st Dec 04     iwconfig mode monitor support
 ***************************************************************************/ 

 
#ifndef _OID_H_
#define _OID_H_

#define OID_GEN_MACHINE_NAME               0x0001021A

#define OID_802_11_BSSID                   0x0D010101
#define OID_802_11_SSID                    0x0D010102
#define OID_802_11_INFRASTRUCTURE_MODE     0x0D010108
#define OID_802_11_ADD_WEP                 0x0D010113
#define OID_802_11_REMOVE_WEP              0x0D010114
#define OID_802_11_DISASSOCIATE            0x0D010115
#define OID_802_11_AUTHENTICATION_MODE     0x0D010118
#define OID_802_11_PRIVACY_FILTER          0x0D010119
#define OID_802_11_BSSID_LIST_SCAN         0x0D01011A
#define OID_802_11_WEP_STATUS              0x0D01011B
#define OID_802_11_RELOAD_DEFAULTS         0x0D01011C
#define OID_802_11_NETWORK_TYPES_SUPPORTED 0x0D010203
#define OID_802_11_NETWORK_TYPE_IN_USE     0x0D010204
#define OID_802_11_TX_POWER_LEVEL          0x0D010205
#define OID_802_11_RSSI                    0x0D010206
#define OID_802_11_RSSI_TRIGGER            0x0D010207
#define OID_802_11_FRAGMENTATION_THRESHOLD 0x0D010209
#define OID_802_11_RTS_THRESHOLD           0x0D01020A
#define OID_802_11_NUMBER_OF_ANTENNAS      0x0D01020B
#define OID_802_11_RX_ANTENNA_SELECTED     0x0D01020C
#define OID_802_11_TX_ANTENNA_SELECTED     0x0D01020D
#define OID_802_11_SUPPORTED_RATES         0x0D01020E
#define OID_802_11_DESIRED_RATES           0x0D010210
#define OID_802_11_CONFIGURATION           0x0D010211
#define OID_802_11_POWER_MODE              0x0D010216
#define OID_802_11_BSSID_LIST              0x0D010217
#define OID_802_11_STATISTICS              0x0D020212


//
// IEEE 802.11 structures and definitions
//

typedef enum _NDIS_802_11_NETWORK_TYPE {
   Ndis802_11FH, 
   Ndis802_11DS, 
   Ndis802_11NetworkTypeMax
} NDIS_802_11_NETWORK_TYPE, *PNDIS_802_11_NETWORK_TYPE;

typedef struct _NDIS_802_11_NETWORK_TYPE_LIST {
   ULONG                       NumberOfItems;
   NDIS_802_11_NETWORK_TYPE    NetworkType [1];
} NDIS_802_11_NETWORK_TYPE_LIST, *PNDIS_802_11_NETWORK_TYPE_LIST;

typedef enum _NDIS_802_11_POWER_MODE {
   Ndis802_11PowerModeCAM,
   Ndis802_11PowerModeMAX_PSP,
   Ndis802_11PowerModeFast_PSP,
   Ndis802_11PowerModeMax
} NDIS_802_11_POWER_MODE, *PNDIS_802_11_POWER_MODE;

typedef ULONG   NDIS_802_11_TX_POWER_LEVEL; // in milliwatts

//
// Received Signal Strength Indication
//
typedef LONG    NDIS_802_11_RSSI;           // in dBm

typedef struct _NDIS_802_11_CONFIGURATION_FH {
   ULONG           Length;            // Length of structure
   ULONG           HopPattern;        // As defined by 802.11, MSB set 
   ULONG           HopSet;            // to one if non-802.11
   ULONG           DwellTime;         // units are Kusec
} NDIS_802_11_CONFIGURATION_FH, *PNDIS_802_11_CONFIGURATION_FH;

typedef struct _NDIS_802_11_CONFIGURATION {
   ULONG                           Length;             // Length of structure
   ULONG                           BeaconPeriod;       // units are Kusec
   ULONG                           ATIMWindow;         // units are Kusec
   ULONG                           DSConfig;           // Frequency, units are kHz
   NDIS_802_11_CONFIGURATION_FH    FHConfig;
} NDIS_802_11_CONFIGURATION, *PNDIS_802_11_CONFIGURATION;

typedef struct _NDIS_802_11_STATISTICS {
   ULONG           Length;             // Length of structure
   LARGE_INTEGER   TransmittedFragmentCount;
   LARGE_INTEGER   MulticastTransmittedFrameCount;
   LARGE_INTEGER   FailedCount;
   LARGE_INTEGER   RetryCount;
   LARGE_INTEGER   MultipleRetryCount;
   LARGE_INTEGER   RTSSuccessCount;
   LARGE_INTEGER   RTSFailureCount;
   LARGE_INTEGER   ACKFailureCount;
   LARGE_INTEGER   FrameDuplicateCount;
   LARGE_INTEGER   ReceivedFragmentCount;
   LARGE_INTEGER   MulticastReceivedFrameCount;
   LARGE_INTEGER   FCSErrorCount;
} NDIS_802_11_STATISTICS, *PNDIS_802_11_STATISTICS;

typedef  ULONG  NDIS_802_11_KEY_INDEX;

typedef struct _NDIS_802_11_WEP {
   ULONG     Length;        // Length of this structure
   ULONG     KeyIndex;      // 0 is the per-client key, 1-N are the global keys
   ULONG     KeyLength;     // length of key in bytes
   UCHAR     KeyMaterial[1];// variable length depending on above field
} NDIS_802_11_WEP, *PNDIS_802_11_WEP;

typedef enum _NDIS_802_11_NETWORK_INFRASTRUCTURE {
   Ndis802_11IBSS,
   Ndis802_11Infrastructure,
   Ndis802_11AutoUnknown,
   Ndis802_11Monitor,
   Ndis802_11InfrastructureMax     // Not a real value, defined as upper bound
} NDIS_802_11_NETWORK_INFRASTRUCTURE, *PNDIS_802_11_NETWORK_INFRASTRUCTURE;

typedef enum _NDIS_802_11_AUTHENTICATION_MODE {
   Ndis802_11AuthModeOpen,
   Ndis802_11AuthModeShared,
   Ndis802_11AuthModeAutoSwitch,
   Ndis802_11AuthModeMax           // Not a real mode, defined as upper bound
} NDIS_802_11_AUTHENTICATION_MODE, *PNDIS_802_11_AUTHENTICATION_MODE;

typedef  UCHAR   NDIS_802_11_RATES[8];  // Set of 8 data rates

typedef  UCHAR   NDIS_802_11_MAC_ADDRESS[6];

typedef struct _NDIS_802_11_SSID {
   ULONG   SsidLength;         // length of SSID field below, in bytes; this can be zero.
   UCHAR   Ssid[32];           // SSID information field
} NDIS_802_11_SSID, *PNDIS_802_11_SSID;

typedef struct _NDIS_WLAN_BSSID {
   ULONG                               Length;     // Length of this structure
   NDIS_802_11_MAC_ADDRESS             MacAddress; // BSSID
   UCHAR                               Reserved[2];
   NDIS_802_11_SSID                    Ssid;       // SSID
   ULONG                               Privacy;    // WEP encryption requirement
   NDIS_802_11_RSSI                    Rssi;       // receive signal strength in dBm
   NDIS_802_11_NETWORK_TYPE            NetworkTypeInUse;
   NDIS_802_11_CONFIGURATION           Configuration;
   NDIS_802_11_NETWORK_INFRASTRUCTURE  InfrastructureMode;
   NDIS_802_11_RATES                   SupportedRates;
} NDIS_WLAN_BSSID, *PNDIS_WLAN_BSSID;

typedef struct _NDIS_802_11_BSSID_LIST {
   ULONG           NumberOfItems;      // in list below, at least 1
   NDIS_WLAN_BSSID Bssid[1];
} NDIS_802_11_BSSID_LIST, *PNDIS_802_11_BSSID_LIST;

typedef  ULONG   NDIS_802_11_FRAGMENTATION_THRESHOLD;

typedef  ULONG   NDIS_802_11_RTS_THRESHOLD;

typedef  ULONG   NDIS_802_11_ANTENNA;

typedef enum _NDIS_802_11_PRIVACY_FILTER {
   Ndis802_11PrivFilterAcceptAll,
   Ndis802_11PrivFilter8021xWEP
} NDIS_802_11_PRIVACY_FILTER, *PNDIS_802_11_PRIVACY_FILTER;

typedef enum _NDIS_802_11_WEP_STATUS {
   Ndis802_11WEPEnabled,
   Ndis802_11WEPDisabled,
   Ndis802_11WEPKeyAbsent,
   Ndis802_11WEPNotSupported,
} NDIS_802_11_WEP_STATUS, *PNDIS_802_11_WEP_STATUS;

typedef enum _NDIS_802_11_RELOAD_DEFAULTS {
   Ndis802_11ReloadWEPKeys
} NDIS_802_11_RELOAD_DEFAULTS, *PNDIS_802_11_RELOAD_DEFAULTS;

//#endif //of WIN 2k

// Ralink defined OIDs
#define OID_GET_SET_TOGGLE                    0x00800000

#define RT_OID_802_11_BSSID                   (OID_GET_SET_TOGGLE | OID_802_11_BSSID)
#define RT_OID_802_11_SSID                    (OID_GET_SET_TOGGLE | OID_802_11_SSID)
#define RT_OID_802_11_INFRASTRUCTURE_MODE     (OID_GET_SET_TOGGLE | OID_802_11_INFRASTRUCTURE_MODE)
#define RT_OID_802_11_ADD_WEP                 (OID_GET_SET_TOGGLE | OID_802_11_ADD_WEP)
#define RT_OID_802_11_REMOVE_WEP              (OID_GET_SET_TOGGLE | OID_802_11_REMOVE_WEP)
#define RT_OID_802_11_DISASSOCIATE            (OID_GET_SET_TOGGLE | OID_802_11_DISASSOCIATE)
#define RT_OID_802_11_AUTHENTICATION_MODE     (OID_GET_SET_TOGGLE | OID_802_11_AUTHENTICATION_MODE)
#define RT_OID_802_11_PRIVACY_FILTER          (OID_GET_SET_TOGGLE | OID_802_11_PRIVACY_FILTER)
#define RT_OID_802_11_BSSID_LIST_SCAN         (OID_GET_SET_TOGGLE | OID_802_11_BSSID_LIST_SCAN)
#define RT_OID_802_11_WEP_STATUS              (OID_GET_SET_TOGGLE | OID_802_11_WEP_STATUS)
#define RT_OID_802_11_RELOAD_DEFAULTS         (OID_GET_SET_TOGGLE | OID_802_11_RELOAD_DEFAULTS)
#define RT_OID_802_11_NETWORK_TYPE_IN_USE     (OID_GET_SET_TOGGLE | OID_802_11_NETWORK_TYPE_IN_USE)
#define RT_OID_802_11_TX_POWER_LEVEL          (OID_GET_SET_TOGGLE | OID_802_11_TX_POWER_LEVEL)
#define RT_OID_802_11_RSSI_TRIGGER            (OID_GET_SET_TOGGLE | OID_802_11_RSSI_TRIGGER)
#define RT_OID_802_11_FRAGMENTATION_THRESHOLD (OID_GET_SET_TOGGLE | OID_802_11_FRAGMENTATION_THRESHOLD)
#define RT_OID_802_11_RTS_THRESHOLD           (OID_GET_SET_TOGGLE | OID_802_11_RTS_THRESHOLD)
#define RT_OID_802_11_RX_ANTENNA_SELECTED     (OID_GET_SET_TOGGLE | OID_802_11_RX_ANTENNA_SELECTED)
#define RT_OID_802_11_TX_ANTENNA_SELECTED     (OID_GET_SET_TOGGLE | OID_802_11_TX_ANTENNA_SELECTED)
#define RT_OID_802_11_DESIRED_RATES           (OID_GET_SET_TOGGLE | OID_802_11_DESIRED_RATES)
#define RT_OID_802_11_CONFIGURATION           (OID_GET_SET_TOGGLE | OID_802_11_CONFIGURATION)
#define RT_OID_802_11_POWER_MODE              (OID_GET_SET_TOGGLE | OID_802_11_POWER_MODE)
#define RT_OID_802_11_STATISTICS              (OID_GET_SET_TOGGLE | OID_802_11_STATISTICS)

#define RT_OID_802_11_QUERY_PREAMBLE          0x0D710101
#define RT_OID_802_11_SET_PREAMBLE            (OID_GET_SET_TOGGLE | RT_OID_802_11_QUERY_PREAMBLE)
#define RT_OID_802_11_QUERY_LINK_STATUS       0x0D710102
#define RT_OID_802_11_RESET_COUNTERS          (OID_GET_SET_TOGGLE | 0x0D710103)
#define RT_OID_802_11_QUERY_AC_CAM            0x0D710104
#define RT_OID_802_11_SET_AC_CAM              (OID_GET_SET_TOGGLE | RT_OID_802_11_QUERY_AC_CAM)

typedef enum _RT_802_11_PREAMBLE {
    Rt802_11PreambleLong,
    Rt802_11PreambleShort,
    Rt802_11PreambleAuto
} RT_802_11_PREAMBLE, *PRT_802_11_PREAMBLE;

// put all proprietery for-query objects here to reduce # of Query_OID
typedef struct _RT_802_11_LINK_STATUS {
    ULONG   CurrTxRate;         // in units of 0.5Mbps
    ULONG   ChannelQuality;     // 0..100 %
    ULONG   TxByteCount;        // both ok and fail
    ULONG   RxByteCount;        // both ok and fail
} RT_802_11_LINK_STATUS, *PRT_802_11_LINK_STATUS;

// structure for query/set hardware register - MAC, BBP, RF register
typedef struct _RT_802_11_HARDWARE_REGISTER {
    ULONG   HardwareType;       // 0:MAC, 1:BBP, 2:RF register
    ULONG   Offset;             // Q/S register offset addr
    ULONG   Data;               // R/W data buffer
} RT_802_11_HARDWARE_REGISTER, *PRT_802_11_HARDWARE_REGISTER;

typedef struct _RT_VERSION_INFO{
	UCHAR		DriverMajorVersion;
	UCHAR		DriverMinorVersion;
	UCHAR		DriverSubVersion;	
	UINT		DriverBuildYear;
	UINT		DriverBuildMonth;
	UINT		DriverBuildDay;
} RT_VERSION_INFO, *PRT_VERSION_INFO;


// IOCTL SubCmd definition
#define RTLINUX_GET_OID_802_11_BSSID_LIST                      8001	// Get Access Points list
#define RTLINUX_SET_OID_802_11_BSSID_LIST_SCAN                 8002	// Start Site Survey
#define RTLINUX_GET_MEDIA_CONNECT_STATUS                       8003
#define RTLINUX_SET_OID_802_11_BSSID                           8004 
#define RTLINUX_GET_OID_802_11_SSID                            8005
#define RTLINUX_GET_OID_802_11_BSSID                           8006
#define RTLINUX_GET_OID_802_11_CONFIGURATION                   8007
#define RTLINUX_GET_RT_OID_802_11_QUERY_LINK_STATUS            8008
#define RTLINUX_GET_OID_802_11_RSSI                            8009
#define RTLINUX_GET_OID_802_11_INFRASTRUCTURE_MODE             8010
#define RTLINUX_SET_OID_802_11_INFRASTRUCTURE_MODE             8011
#define RTLINUX_GET_OID_802_11_TX_ANTENNA_SELECTED             8012
#define RTLINUX_SET_OID_802_11_TX_ANTENNA_SELECTED             8013
#define RTLINUX_GET_OID_802_11_RX_ANTENNA_SELECTED             8014
#define RTLINUX_SET_OID_802_11_RX_ANTENNA_SELECTED             8015
#define RTLINUX_GET_OID_802_11_DESIRED_RATES                   8016
#define RTLINUX_SET_OID_802_11_DESIRED_RATES                   8017
#define RTLINUX_GET_OID_802_11_QUERY_PREAMBLE                  8018
#define RTLINUX_SET_OID_802_11_SET_PREAMBLE                    8019
#define RTLINUX_GET_OID_802_11_TX_POWER_LEVEL                  8020
#define RTLINUX_SET_OID_802_11_TX_POWER_LEVEL                  8021
#define RTLINUX_GET_OID_802_11_RTS_THRESHOLD                   8022
#define RTLINUX_SET_OID_802_11_RTS_THRESHOLD                   8023 
#define RTLINUX_GET_OID_802_11_FRAGMENTATION_THRESHOLD         8024
#define RTLINUX_SET_OID_802_11_FRAGMENTATION_THRESHOLD         8025
#define RTLINUX_GET_OID_802_11_AUTHENTICATION_MODE             8026
#define RTLINUX_SET_OID_802_11_AUTHENTICATION_MODE             8027
#define RTLINUX_GET_OID_802_11_WEP_STATUS                      8028
#define RTLINUX_SET_OID_802_11_WEP_STATUS                      8029
#define RTLINUX_SET_OID_802_11_REMOVE_WEP                      8030
#define RTLINUX_SET_OID_802_11_ADD_WEP                         8031
#define RTLINUX_SET_OID_802_11_CONFIGURATION                   8032
#define RTLINUX_GET_OID_802_11_POWER_MODE                      8033
#define RTLINUX_SET_OID_802_11_POWER_MODE                      8034
#define RTLINUX_SET_OID_802_11_SSID                            8035
#define RTLINUX_GET_OID_802_11_STATISTICS                      8036
#define RTLINUX_GET_OID_GEN_RCV_OK                             8037
#define RTLINUX_GET_OID_GEN_RCV_NO_BUFFER                      8038
#define RTLINUX_SET_RT_OID_802_11_RESET_COUNTERS               8039
#define RTLINUX_GET_OID_802_3_CURRENT_ADDRESS                  8040
#define RTLINUX_GET_VERSION_INFO                               8041
#define RTLINUX_GET_RT_OID_802_11_QUERY_HARDWARE_REGISTER	   8042
#define RTLINUX_SET_RT_OID_802_11_SET_HARDWARE_REGISTER		   8043
#define RTLINUX_SET_RT_OID_802_11_SET_RADIO					   8044 
#define RTLINUX_GET_RT_OID_802_11_QUERY_RADIO				   8045
#define RTLINUX_RT_OID_802_11_SET_COUNTRY_REGION			   8046

#endif
