glm.od <-
function(object, maxit = 30, verbose = TRUE)
{
  if (class(object)[1] != "glm")
     stop("first argument must be a fitted model of class \"glm\" !")
  class <- class(object)
  if (!(family(object)$family == "binomial" & family(object)$link == "logit"))
     stop("overdispersed model fitting available only for \nbinomial regression models with logit link function!")

  pearson.X2 <- function(x) sum(residuals(x, "pearson")^2)

  y <- object$model[,1]       # observed proportion of success & failures
  trials <- apply(y, 1, sum)  # = object$prior.weights
  X <- model.matrix(object)
  p <- length(object$coefficients)
  n <- dim(X)[[1]]
  h <- lm.influence(object)$hat
  X2 <- pearson.X2(object)
  # initial estimate of dispersion parameter
  phi <- (X2 - (n-p)) / sum((trials-1)*(1-h))
  if(phi <0){phi <- 0;}
  w <- 1/(1+phi*(trials-1))
  if (verbose)
      cat("\nBinomial overdispersed logit model fitting...\n")
  # loop until Pearson X2 approx equal to 1
  i <- 0

  while( (X2/(n-p)-1) > object$control$epsilon )
  {
    i <- i + 1
    if (i > maxit)
    { warning("algoritm not converged after ", i, " iterations!")
         break }
    else
       if (verbose) cat("Iter. ", i, " phi:", format(phi), "\n")
    # computes weights
    w <- 1/(1+phi*(trials-1))
    # re-fit the model using update() evaluated in original model
    # environment, usually R_GlobalEnv
    disp.weights <<- w; object <<- object
    object <- eval(expression(update(object, weights=disp.weights)),
                   envir = object$data)

    h <- lm.influence(object)$hat
    X2 <- pearson.X2(object)
    # current estimate of dispersion parameter
    phi <- (X2 - sum(w*(1-h))) / sum(w*(trials-1)*(1-h))
  }

  if (verbose)
     { cat("Converged after", i, "iterations. \n")
       cat("Estimated dispersion parameter:", format(phi), "\n")
           print(summary(object)) }
  ##### Jun Lu
  if (X2 < (n-p)){
	  phi <- 0;
	  w <- 1;
  }
  #cat(c("w is ",w,"\n"));
  #if(phi <0){phi <- 0;}
  #w[w>1] <- 1;
  #cat(c("w is ",w,"\n"));
  #####
  object <- c(object, list(dispersion=phi, disp.weights=w))
  class(object) <- class
  invisible(object)
}


logit.1fact <- function(lib.size, counts, gp.des){
   tmp <- counts
   #if (sum(tmp)<5) next ;
   #if(sum(tmp>0) <3) {tmp <- tmp+1;}
   mod <- glm(cbind(tmp, lib.size-tmp) ~ gp.des, family=binomial(logit));
   mod.disp <- glm.od(mod,verbose=FALSE);
   test <- summary(mod.disp)$coefficients[2,];
   return (list(zp = test))
}
