from __future__ import nested_scopes

import unittest
try:
    from Numeric import *
except ImportError:
    print 'Numeric not available. Skipping.\n'
    import sys
    sys.exit(0)
    
import sys
sys.path.insert(1, "..")
from rpy import *

idx = r['[[']
idx.autoconvert(0)

def to_r(obj):
    r.list.autoconvert(0)
    return idx(r.list(obj),1)

class ArrayTestCase(unittest.TestCase):

    def setUp(self):
        py = array(range(24))
        self.py = reshape(py, (2,3,4))
        py_to_r = to_r(self.py)
        self.py_c = py_to_r.as_py()
        
        r.array.autoconvert(NO_CONVERSION)
        self.ra = r.array(range(24), dim=(2,3,4))
        ra_to_py = self.ra.as_py()
        self.ra_c = to_r(ra_to_py)
        r.array.autoconvert(PROC_CONVERSION)
        
    def testZeroDimToR(self):
        set_default_mode(NO_CONVERSION)
        a = zeros((0,7))
        ra = r.c(a)
        set_default_mode(NO_DEFAULT)
        self.failUnless(r.is_null(ra))

    def testZeroDimToPy(self):
        self.failUnless(r.array(0,dim=(0,7)) == None)
        
    def testToPyDimensions(self):
        self.failUnless(self.py_c.shape == self.py.shape,
                        'wrong dimensions in Numeric array')

    def testToRDimensions(self):
        self.failUnless(r.dim(self.ra) == r.dim(self.ra_c),
                        'wrong dimensions in R array')

    def testPyElements(self):
        self.failUnless(self.py[0,0,0] == self.py_c[0,0,0] and
                        self.py[1,2,3] == self.py_c[1,2,3] and
                        self.py[1,1,2] == self.py_c[1,1,2] and
                        self.py[1,0,3] == self.py_c[1,0,3],
                        'Numeric array not equal')

    def testRElements(self):
        try:
            idx.autoconvert(1)
            self.failUnless(idx(self.ra, 1,1,1) == idx(self.ra_c, 1,1,1) and
                            idx(self.ra, 2,3,4) == idx(self.ra_c, 2,3,4) and
                            idx(self.ra, 2,2,3) == idx(self.ra_c, 2,2,3) and
                            idx(self.ra, 2,1,4) == idx(self.ra_c, 2,1,4),
                            'R array not equal')
        finally:
            idx.autoconvert(0)

    def testPyOutOfBounds(self):
        self.failUnlessRaises(IndexError, lambda: self.py_c[5,5,5])
                           
    def testROutOfBounds(self):
        self.failUnlessRaises(RException, lambda: idx(self.ra_c, 5,5,5))


if __name__ == '__main__':
    unittest.main()
