<?php

/**
 * Command line learn driver
 * @version 1.1
 * @author Philip Weir
 * Patched by Julien Vehent to support DSPAM
 * Enhanced support for DSPAM by Stevan Bajic <stevan@bajic.ch>
 */
function learn_spam($uids)
{
	do_salearn($uids, true);
}

function learn_ham($uids)
{
	do_salearn($uids, false);
}

function do_salearn($uids, $spam)
{
	$rcmail = rcmail::get_instance();
	$temp_dir = realpath($rcmail->config->get('temp_dir'));

	if ($spam)
		$command = $rcmail->config->get('markasjunk2_spam_cmd');
	else
		$command = $rcmail->config->get('markasjunk2_ham_cmd');

	if (!$command)
		return;

	$command = str_replace('%u', $_SESSION['username'], $command);
	$command = str_replace('%l', $rcmail->user->get_username('local'), $command);
	$command = str_replace('%d', $rcmail->user->get_username('domain'), $command);
	if (preg_match('/%i/', $command)) {
		$identity_arr = $rcmail->user->get_identity();
		$command = str_replace('%i', $identity_arr['email'], $command);
	}

	foreach (explode(",", $uids) as $uid) {
		// get DSPAM signature from header (if %xds macro is used)
		if (preg_match('/%xds/', $command)) {
			if (preg_match('/^X\-DSPAM\-Signature:\s+((\d+,)?([a-f\d]+))\s*$/im', $rcmail->imap->get_raw_headers($uid), $dspam_signature))
				$tmp_command = str_replace('%xds', $dspam_signature[1], $command);
			else
				continue; // no DSPAM signature found in headers -> continue with next uid/message
		}

		if (preg_match('/%f/', $command)) {
			$tmpfname = tempnam($temp_dir, 'rcmSALearn');
			file_put_contents($tmpfname, $rcmail->imap->get_raw_body($uid));
			$tmp_command = str_replace('%f', $tmpfname, $command);
		}

		exec($tmp_command, $output);

		if ($rcmail->config->get('markasjunk2_debug')) {
			write_log('markasjunk2', $tmp_command);
			write_log('markasjunk2', $output);
		}

		if (preg_match('/%f/', $command))
			unlink($tmpfname);

		$output = '';
	}
}

?>