global = (propellant_database = "propellant.dat",
	  product_database    = "thermo.dat"
	 )	 

propellant = (name       = "Candy"
	     ,ingrediant = (name     = "Potassium Nitrate"
			   ,formula  = "KNO3"
			   ,comp     = (ing = (qty = 1, at = "K")
				       ,ing = (qty = 3, at = "O")
				       ) 
			   ,enthalpy = (val = 6543., units = "kJ/kg") 
			   ,qty      = (val = 65., units = "gram")
			   )
	     ,ingrediant = (name     = "Sucrose"
			   ,formula  = "H22C12O11"
			   ,comp     = (ing = (qty = 22, at = "H")
				       #,ing = (qty = 12, at = "C")
				       ,ing = (qty = 11, at = "O")
				       )
			   ,enthalpy = (val = 1234., units = "kJ/kg")
			   ,qty      = (val = 35., units = "gram")
			   )
	     ,density    = (val = 1.83, units = "g/cm3")
	     )

propellant = (name       = "LH2/LO2"
	     ,ingrediant = (database = 457  # Liquid Hydrogen 
		           ,qty      = (val = 35., units = "gram")
	                   )
	     ,ingrediant = (database = 686  # Liquid Oxygene 
		           ,qty      = (val = 65., units = "gram")
			   )
	     ,density    = (val = 0.8, units = "g/cm3")
	     )
	       

problem = (type             = "HP"
	  ,propellant       = "Candy"
	  ,chamber_pressure = (val = 10., units = "atm")
	  ,exit_pressure    = (val = 1.,  units = "atm")
	  )
