/* -*- Mode: C; c-file-style: "k&r"; -*-*/

/* token.h
 *    Header file for token.c
 *
 * $Id: token.h,v 1.6 2000/10/29 22:41:23 antoine Exp $
 *
 * Copyright (C) 2000,
 *     Antoine Lefebvre <antoine.lefebvre@polymtl.ca>
 *     Remi Lefebvre <remi@debian.org>
 *
 * gpcp is free software; you can redistribute them and/or modify them
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 */

#ifndef __token_h__
#define __token_h__

/* possible token */
#define TOK_KEYWORD      1   /* standard unquoted string */
#define TOK_FLOAT        2   /* heh */
#define TOK_INTEGER      3
#define TOK_STRING       4   /* quoted string (double quotes only) */
#define TOK_FUNCTION     5   /* not clearly defined yet. keyword followed by a
                           * parenthesis */
#define TOK_TRUE         6   /* special keywords 'true' and 'false' */
#define TOK_FALSE        7
#define TOK_EQUAL        8   /* equality sign */
#define TOK_OPENPAR      9   /* opening parenthesis (not in function) */
#define TOK_CLOSEPAR     10   /* closing parenthesis */
#define TOK_COMMA        11  /* une virgule batard! */
#define TOK_BEGINCOMMENT 12  /* # */
#define TOK_COMMENT      13  /* not useful probably .. huh */
#define TOK_NEWLINE      14  /* to count line numbers */

/*   lexer state
 * NONE        when there is no state yet
 * LONG_TOKEN  when a token of more than one caracter is beeing read
 * STR         a string is beeing read
 * INCOMMENT   a comment is beeing read
 */

#define STATE_NONE 0
#define STATE_LONG_TOKEN 1
#define STATE_STRING 2
#define STATE_IN_COMMENT 3


/* function definitions */
int get_token(FILE *fd, char *buffer, int size, int *line);
int is_float(char *buffer);
int is_integer(char *buffer);

#endif /* __token_h__ */






