/* -*- Mode: C; c-file-style: "k&r"; indent-tabs-mode: nil -*- */

/* gpcp.c
 *    library functions
 *
 * $Id: gpcp.c,v 1.13 2001/04/07 12:49:03 antoine Exp $
 *
 * Copyright (C) 2000,
 *     Antoine Lefebvre <antoine.lefebvre@polymtl.ca>
 *     Remi Lefebvre <remi@debian.org>
 *
 * gpcp is free software; you can redistribute them and/or modify them
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 */

#include <stdlib.h>
#include <string.h>

#include "gpcp.h"
#include "err.h"

short opt_registered = 0;

Options *options;
//Functions *functions;

//static int level = 0;
Data *toplevel;
GPCP_State cur_n;
//Data *dataptr;

int GPCP_RegisterOptions(Options *opt)
{
     /* probably not useful */
     memset(&cur_n, 0, sizeof(GPCP_State));

     options = opt;
     opt_registered = 1;
     return 0;
}

int GPCP_ReadFile(char *filename, Data **returnptr)
{
     FILE *fd;
     int status;

     Data *data;

     if (!opt_registered)
          return OPT_NOT_REGISTERED;
    
     if ((fd = fopen(filename, "r")) == NULL)
     {
          return ERR_OPEN;
     }

     /* Allocate the memory for data structure */
     data = (Data *) malloc (sizeof(Data));
     data->n_key = 0;
     data->key_list = NULL;

  
     /* parse the file */
     status = parse_file(fd, data);

     *returnptr = data;

     /* initialise pointers */
     toplevel = data;
     cur_n.level = 0;
     cur_n.data = data;

     fclose(fd);
     return status;
}

int GPCP_PrintData(Data *data)
{
     static int level = 0;
     int i;
     for (i = 0; i < data->n_key; i++)
     {
          printf("%*s%-2d: %s\n", 2*level, "", i, data->key_list[i].name);

          if (data->key_list[i].type == PARENT)
          {
               level++;
               GPCP_PrintData(data->key_list[i].val.subdata);
          }
     }
     level--;
     return 0;
}

int GPCP_FreeData(Data **ptr)
{
     int i;

     Data *data = *ptr;
  
     for (i = 0; i < data->n_key; i++)
     { 
          switch (data->key_list[i].type)
          {  
          case PARENT:
               GPCP_FreeData(&(data->key_list[i].val.subdata));
               free(data->key_list[i].name);
               break;
          
          case STRING:
               free(data->key_list[i].val.string);
               free(data->key_list[i].name);
               break;

          case FLOAT:
               free(data->key_list[i].val.number);
               free(data->key_list[i].name);
               break;

          case INTEGER:
               free(data->key_list[i].val.integer);
               free(data->key_list[i].name);
               break;
               
          case BOOLEAN:
               free(data->key_list[i].val.boolean);
               free(data->key_list[i].name);
               break;
          
          case FUNCTION:
               break;
          }  
     }

     if (data->key_list) free(data->key_list);
     if (data) free(data);
     
     return 0;
}

int GPCP_EnterLevel(char *name, int rank)
{
     int i, n = 0;

     for (i = 0; i < cur_n.data->n_key; i++)
     {
          if (strcmp (name, cur_n.data->key_list[i].name) == 0)
          {
               if (n == rank)
               {
                    if (cur_n.data->key_list[i].type == PARENT)
                    {
                         cur_n.data = cur_n.data->key_list[i].val.subdata;
                         cur_n.level++;
                         return 0;
                    }
               }
               n++;
          }
     }
     return -1;
}

int GPCP_ExitLevel(void)
{
     if (cur_n.data->prev != NULL)
     {
          cur_n.data = cur_n.data->prev;
          cur_n.level--;
          return 0;
     }
     else
     {
          /* can't leave sub, we are in main */
          return -1;
     }
}

int GPCP_NumParent(char *parent_name)
{
     int i, n = 0;

     for (i = 0; i < cur_n.data->n_key; i++)
     {
          if (strcmp (parent_name, cur_n.data->key_list[i].name) == 0)
          {
               if (cur_n.data->key_list[i].type == PARENT)
               {
                    n++;
               }
          }
     }
     return n;
}

int GPCP_GetValue(char *keyword, void *var)
{
     int i;

     char **s;
     float *n;
     short *b;
     int   *a;
     
     for (i = 0; i < cur_n.data->n_key; i++)
     {
          if (strcmp(keyword, cur_n.data->key_list[i].name) == 0)
          {
               switch (cur_n.data->key_list[i].type)
               {
               case STRING:
                    s = (char **) var;
                    
                    *s = (char *) malloc
                         (sizeof(char) *
                          (strlen(cur_n.data->key_list[i].val.string) + 1));
                    strcpy(*s, cur_n.data->key_list[i].val.string);
                    return 0;
                    break;
                    
               case FLOAT:
                    n = (float *) var;
                    *n = *(cur_n.data->key_list[i].val.number);
                    return 0;
                    break;

               case INTEGER:
                    a = (int *) var;
                    *a = *(cur_n.data->key_list[i].val.integer);
                    return 0;
                    break;
                    
               case BOOLEAN:
                    b = (short *) var;
                    *b = *(cur_n.data->key_list[i].val.boolean);
                    return 0;
                    break;
                    
               case PARENT:
               case FUNCTION:
                    // duh
                    return -1;
                    break;

               }
          }
     }
     return -1;
}

