/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldOrMethod;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;

public abstract class FieldInstruction
extends FieldOrMethod
implements TypedInstruction {
    FieldInstruction() {
    }

    protected FieldInstruction(short s, int n) {
        super(s, n);
    }

    public String toString(ConstantPool constantPool) {
        return Constants.OPCODE_NAMES[this.opcode] + " " + constantPool.constantToString(this.index, (byte)9);
    }

    protected int getFieldSize(ConstantPoolGen constantPoolGen) {
        return this.getType(constantPoolGen).getSize();
    }

    public Type getType(ConstantPoolGen constantPoolGen) {
        return this.getFieldType(constantPoolGen);
    }

    public Type getFieldType(ConstantPoolGen constantPoolGen) {
        return Type.getType(this.getSignature(constantPoolGen));
    }

    public String getFieldName(ConstantPoolGen constantPoolGen) {
        return this.getName(constantPoolGen);
    }
}

